# Program: xf
# Description: info routine for preload pixmaps
#
# $Header: xfinfoPixmaps.tcl[2.3] Wed Mar 10 12:06:15 1993 garfield@garfield frozen $

##########
# Procedure: XFInfoPixmaps
# Description: show the currently selected preload pixmaps
# Arguments: none
# Returns: none
# Sideeffects: none
##########
proc XFInfoPixmaps {} {
  global preloadList
  global xfBind

  if {"[info commands pinfo]" == ""} {
    return
  }

  XFEditSetStatus "Calling pixmap list..."

  # build widget structure
  XFTmpltToplevel .xfInfoPixmaps 800x300 {XF preload pixmaps}

  XFTmpltFrame .xfInfoPixmaps.frame0 0

  button .xfInfoPixmaps.frame0.ok \
    -text {OK} \
    -command {destroy .xfInfoPixmaps}

  button .xfInfoPixmaps.frame0.rescan \
    -text {Rescan} \
    -command {
      XFMiscClearList .xfInfoPixmaps.frame1.pixmaps.pixmaps
      foreach counter [lsort [pinfo names]] {
        .xfInfoPixmaps.frame1.pixmaps.pixmaps insert end $counter
      }}

  button .xfInfoPixmaps.frame0.edit \
    -text {Edit} \
    -command {
      set xfCurSelect [.xfInfoPixmaps.frame1.pixmaps.pixmaps curselect]
      if {$xfCurSelect >= 0} {
        set xfTmpValue [.xfInfoPixmaps.frame1.pixmaps.pixmaps get $xfCurSelect]
        if {[pinfo depth $xfTmpValue] == 1} {
          set xfTmpPath [pwd]
          cd [file dirname [string range $xfTmpValue 1 end]]
          if {[catch "exec bitmap [file tail [string range $xfTmpValue 1 end]] &" xfResult]} {
            XFProcError $xfResult
          }
          cd $xfTmpPath
        } {
          if {[catch "exec xfpixmap [string range $xfTmpValue 1 end] &" xfResult]} {
            XFProcError $xfResult
          }
        }
      }}

  XFTmpltFrame .xfInfoPixmaps.frame2 0

  button .xfInfoPixmaps.frame2.insert \
    -text {Insert} \
    -command {XFInfoPixmapsInsert}

  button .xfInfoPixmaps.frame2.delete \
    -text {Delete} \
    -command {XFInfoPixmapsDelete}

  XFTmpltFrame .xfInfoPixmaps.frame1 0

  XFTmpltListbox .xfInfoPixmaps.frame1 pixmaps
  .xfInfoPixmaps.frame1.pixmaps.pixmaps configure \
    -geometry 20x30

  label .xfInfoPixmaps.frame1.pixmaps.pixmapsMess \
    -relief raised \
    -text {Pixmaps:}

  XFTmpltListbox .xfInfoPixmaps.frame1 preload
  .xfInfoPixmaps.frame1.preload.preload configure \
    -geometry 20x30

  label .xfInfoPixmaps.frame1.preload.preloadMess \
    -relief raised \
    -text {Preloaded pixmaps:}

  foreach counter [lsort [pinfo names]] {
    .xfInfoPixmaps.frame1.pixmaps.pixmaps insert end $counter
  }

  foreach counter [lsort [array names preloadList]] {
    if {"$counter" != "xfInternal"} {
      .xfInfoPixmaps.frame1.preload.preload insert end $counter
    }
  }

  # bindings
  bind .xfInfoPixmaps.frame1.pixmaps.pixmaps $xfBind(select1) {
    XFBindSelectOne %W %y
    XFInfoPixmapsInsert}
  bind .xfInfoPixmaps.frame1.pixmaps.pixmaps <ButtonPress-1> {
    XFBindSelectOne %W %y}
  bind .xfInfoPixmaps.frame1.pixmaps.pixmaps <Button1-Motion> {
    XFBindSelectOne %W %y}
  bind .xfInfoPixmaps.frame1.pixmaps.pixmaps <Shift-ButtonPress-1> {
    XFBindSelectOne %W %y}
  bind .xfInfoPixmaps.frame1.pixmaps.pixmaps <Shift-Button1-Motion> {
    XFBindSelectOne %W %y}

  bind .xfInfoPixmaps.frame1.preload.preload $xfBind(select) {
    XFBindSelectOne %W %y
    XFInfoPixmapsDelete}
  bind .xfInfoPixmaps.frame1.preload.preload <ButtonPress-1> {
    XFBindSelectOne %W %y}
  bind .xfInfoPixmaps.frame1.preload.preload <Button1-Motion> {
    XFBindSelectOne %W %y}
  bind .xfInfoPixmaps.frame1.preload.preload <Shift-ButtonPress-1> {
    XFBindSelectOne %W %y}
  bind .xfInfoPixmaps.frame1.preload.preload <Shift-Button1-Motion> {
    XFBindSelectOne %W %y}

  # packing
  pack append .xfInfoPixmaps.frame0 \
              .xfInfoPixmaps.frame0.ok {left fill expand} \
              .xfInfoPixmaps.frame0.rescan {left fill expand} \
              .xfInfoPixmaps.frame0.edit {left fill expand}
  pack append .xfInfoPixmaps.frame2 \
              .xfInfoPixmaps.frame2.insert {left fill expand} \
              .xfInfoPixmaps.frame2.delete {left fill expand}
  pack before .xfInfoPixmaps.frame1.pixmaps.vscroll \
              .xfInfoPixmaps.frame1.pixmaps.pixmapsMess {top fillx}
  pack before .xfInfoPixmaps.frame1.preload.vscroll \
              .xfInfoPixmaps.frame1.preload.preloadMess {top fillx}
  pack append .xfInfoPixmaps.frame1 \
              .xfInfoPixmaps.frame1.pixmaps {left fill expand} \
              .xfInfoPixmaps.frame1.preload {left fill expand}
  pack append .xfInfoPixmaps \
              .xfInfoPixmaps.frame0 {bottom fill} \
              .xfInfoPixmaps.frame2 {bottom fill} \
              .xfInfoPixmaps.frame1 {bottom fill expand}

  XFEditSetStatus "Calling pixmap list...done"
}

##########
# Procedure: XFInfoPixmapsDelete
# Description: delete currently selected pixmap from list
# Arguments: none
# Returns: none
# Sideeffects: none
##########
proc XFInfoPixmapsDelete {} {
  global preloadList

  set xfCurSelect [.xfInfoPixmaps.frame1.preload.preload curselect]
  if {$xfCurSelect >= 0} {
    set xfTmpValue [.xfInfoPixmaps.frame1.preload.preload get $xfCurSelect]
    catch "unset preloadList($xfTmpValue)"
    .xfInfoPixmaps.frame1.preload.preload delete $xfCurSelect
  }
}

##########
# Procedure: XFInfoPixmapsInsert
# Description: insert currently selected pixmap to list
# Arguments: none
# Returns: none
# Sideeffects: none
##########
proc XFInfoPixmapsInsert {} {
  global preloadList

  set xfCurSelect [.xfInfoPixmaps.frame1.pixmaps.pixmaps curselect]
  if {$xfCurSelect >= 0} {
    set xfTmpValue [.xfInfoPixmaps.frame1.pixmaps.pixmaps get $xfCurSelect]
    set preloadList($xfTmpValue) ""
    .xfInfoPixmaps.frame1.preload.preload insert end $xfTmpValue
  }
}

# eof

