# Program: xf
# Description: procedures that implement the help functionality
#
# $Header: xfprocHelp.tcl[2.4] Wed Mar 10 12:07:53 1993 garfield@garfield frozen $

proc XFProcHelpAbout {} {
##########
# Procedure: XFProcHelpAbout
# Description: show the about box
# Arguments: none
# Returns: none
# Sideeffects: none
##########
  global xfAlertBox
  global xfPath

  foreach xfHelpElement [split $xfPath(helps) :] {
    if {[file exists $xfHelpElement/XF/About.H]} {
      set xfAlertBox(toplevelName) .about
      XFProcMessageFile $xfHelpElement/XF/About.H 290x240 {XF about} center {}
      set xfAlertBox(toplevelName) .xfAlertBox
    }
  }
}

proc XFProcHelpHelp {args} {
##########
# Procedure: XFProcHelpHelp
# Description: show help in a external wish
# Arguments: args - the section (page) to show
# Returns: none
# Sideeffects: none
##########
  global env
  global xfPath

  set xfArgs [split [string trimright [string trimleft $args \{] \}]]
  if {"[lindex $xfArgs 0]" == "General" ||
      [llength $xfArgs] == 0} {
    set xfHelpTopic "XF/XF"
  } {
    if {[llength $xfArgs] == 1} {
      set xfHelpTopic "XF/$args"
    } {
      set xfHelpTopic "$args"
    }
  }
  regsub -all " " $xfHelpTopic "/" xfHelpTopic
  set env(XF_HELP_DIR) $xfPath(helps)
  if {[catch "exec xfhelp $xfHelpTopic &" xfResult]} {
    XFProcError $xfResult
  }
}

proc XFProcHelpTutorial {} {
##########
# Procedure: XFProcHelpTutorial
# Description: start tutorial
# Arguments: none
# Returns: none
# Sideeffects: none
##########

  global xfConf
  global xfPath

  if {[XFProcYesNo "Running the tutorial will erase your current work.\n Is this ok ?"]} {
    catch "exec $xfConf(interpreterTut) -n \"XF-tutorial\" -f $xfPath(base)/xftutorial/xftutorial.tcl $xfPath(base)/xftutorial/script.xf [winfo name .] &"
  }
}

# eof

