# The Tix Intrinsics

proc tixInt_CreateWidget {w class className args} {
    upvar #0 $w data
    upvar #0 $class classRec

    # CREATE CLASS RECORD IF NECESSARY
    if {[info globals $class] == ""} {
	tixInt_CreateClassRec $class
    }

    tixInt_CreateWidgetRec        $w $class $className
    eval $class::CreateWidgetRoot $w
    tixInt_MkWidgetCommand        $w

    if {$classRec(rootOptions) == {}} {
	foreach option [$data(rootCmd) config] {
	    lappend classRec(rootOptions) [lindex $option 0]
	}
    }

    # CREATE WIDGET RECORD
    eval tixInt_LoadOptions       $w $class $className $args

    # INITIALIZE
    eval $class::InitWidgetRec    $w $class $className $args 
    eval $class::ConstructWidget  $w
    eval $class::SetBindings      $w

    bind $w <Destroy> "+tixDeleteWidgetCmd $w"
}

proc tixInt_CreateClassRec {class} {
    $class::CreateClassRec
    tixInt_CreateDefMethods $class
}

proc tixInt_CreateWidgetRec {w class className} {
    upvar #0 $w data
    upvar #0 $class classRec

    set data(class)     $class
    set data(className) $className
    set data(root)      $w
}

proc tixInt_LoadOptions {w class className args} {
    upvar #0 $w data
    upvar #0 $class classRec

    # SET UP THE WIDGET RECORD ACCORDING TO DEFAULT VALUES

    foreach option $classRec(options) {
	if {[lindex $classRec($option) 0] == "="} {
	    continue
	}

	set o_name    [lindex $classRec($option) 1]
	set o_class   [lindex $classRec($option) 2]
	set o_default [lindex $classRec($option) 3]

	set userDef [option get $w $o_name $o_class]
	if {$userDef != ""} {
	    set data($option) $userDef
	} else {
	    set data($option) $o_default
	}
    }

    # SET UP THE WIDGET RECORD ACCORDING TO COMMAND ARGUMENTS
    set len  [llength $args]
    set len2 [expr {$len - 2}]
    set i 0
    set root_options {}

    while {$i <= $len2} {
	set option [lindex $args $i]
	incr i
	set arg [lindex $args $i]
	incr i
	
	if {[lsearch $classRec(options) $option] != "-1"} {
	    if {[lindex $classRec($option) 0] != "="} {
		set data($option) $arg
	    } else {
		set realOption [lindex $classRec($option) 1]
		set data($realOption) $arg
	    }
	} else {
	    if [catch {$data(rootCmd) config $option $arg} err_msg] {
		if {[string range $err_msg 0 13] == "unknown option"} {
		    error "unknown option $option. Should be: \
                           [tixInt_ListOptions $w]"
		} else {
		    error $err_msg
		}
	    }
	}
    }

    if {$i != $len} {
	error "Odd number of config parameters applied to $data(root)"
    }
}

proc tixInt_MkWidgetCommand {w} {
    upvar #0 $w data

    set data(rootCmd) $w:root
    tixRenameWidgetCmd $w $data(rootCmd)

    proc $w {method args} {
	#------------------------------------------------------------
	# the name of the data structure is the same as the procedure
	#------------------------------------------------------------
	set w [lindex [info level 0] 0]
	upvar #0 $w data
	upvar #0 $data(class) classRec

	case $method in {
	    #------------------------------------------------------------
	    # Config is a special method that needs special attention
	    #------------------------------------------------------------
	    {config configure} {
		if {$args == {}} {
		    return [tixInt_QueryOptions $w]
		}
		eval tixInt_ApplyOptions $w $args
	    }
	    default {
		# 1. Execute the method as if it is a method of the class
		# 2. If error happens in the execution of 1, check if
		#    the method is supported by the class
		# 3. If yes, then simply output the error message from 1.
		# 4. If no, then try execute as if the method belogs 
		#    to the root widget
		# 5. If error in 4, check the following
		# 6. If the method does belong to the root widget
		#    simple print out the error message from 4.
		# 7. If the method does not belong to the root widget
		#    print the set of methods avilable from both the class
		#    and the root widget

	      if [catch {set ret [eval $data(class)::$method $w $args]} e_msg] {
		   if {[lsearch $classRec(methods) $method] != "-1"} {
		       error $e_msg
		   } elseif [catch {set ret [eval $data(rootCmd) $method $args]}\
			     e_msg2] {
		       if {[lrange $e_msg2 0 1] == "bad option"} {
			   if {$classRec(methods) != ""} {
			       error "$e_msg2; or $classRec(methods)"
			   } else {
			       error $e_msg2
			   }
		       } else {
			   error $e_msg2
		       }
		   }
		   # An original command executed OK
		   return $ret
	       }
	       # A valid method of the widget executed OK.
	       return $ret
	    }
	}
    }
}


proc tixInt_ListOptions {w} {
    upvar #0 $w data
    upvar #0 $data(class) classRec

    return [lsort "$classRec(rootOptions) $classRec(options)"]
}

proc tixInt_QueryOptions {w} {
    upvar #0 $w data
    upvar #0 $data(class) classRec

    set options {}

    foreach option [$data(rootCmd) config] {
	set flag [lindex $option 0]
	if {[lsearch $classRec(options) $flag] == "-1"} {
	    lappend options $option
	}
    }

    foreach option $classRec(options) {
	if {[lindex $classRec($option) 0] != "="} {
	    lappend options "$classRec($option) $data($option)"
	}
    }

    return [lsort $options]
}

proc tixInt_QueryOption {w option} {
    upvar #0 $w data
    upvar #0 $data(class) classRec

    if {[lsearch $classRec(options) $option] != -1} {
	if {[lindex $classRec($option) 0] == "="} {
	    set option [lindex $classRec($option) 1]
	}
	return "$classRec($option) $data($option)"
    } else {
	if [catch {return [$data(rootCmd) config $option]} err_msg] {
	    if {[string range $err_msg 0 13] == "unknown option"} {
		error "unknown option $option. Should be: \
                           [tixInt_ListOptions $w]"
	    } else {
		error $err_msg
	    }
	}
    }
}


proc tixInt_ApplyOptions {w args} {
    upvar #0 $w data
    upvar #0 $data(class) classRec

    set len  [llength $args]
    set len2 [expr {$len - 2}]
    set i    0

    if {$len == 1} {
	return [eval tixInt_QueryOption $w $args]
    }

    while {$i <= $len2} {
	set option [lindex $args $i]
	incr i
	set arg [lindex $args $i]
	incr i

	if {[lsearch $classRec(options) $option] != "-1"} {
	    if {[lindex $classRec($option) 0] == "="} {
		set option [lindex $classRec($option) 1]
	    }
	    $data(class)::config$option $w $arg
	    set data($option) $arg
	} else {
	    if [catch {$data(rootCmd) config $option $arg} err_msg] {
		if {[string range $err_msg 0 13] == "unknown option"} {
		    error "unknown option $option. Should be: \
                           [tixInt_ListOptions $w]"
		} else {
		    error $err_msg
		}
	    }
	}
    }

    if {$i != $len} {
	error "value for \"$option\" missing"
    }
}

proc tixInt_DefCreateWidgetRoot {w} {
    upvar #0 $w data

    frame $w -class $data(className)
}

# CREATE THE DEFAULT METHODS
proc tixInt_CreateDefMethods {class} {

    if {[auto_load $class::CreateWidgetRoot] == 0} {
	proc $class::CreateWidgetRoot {w} {
	    tixInt_DefCreateWidgetRoot $w
	}
    }

    if {[auto_load $class::InitWidgetRec] == 0} {
	proc $class::InitWidgetRec {w class className args} {}
    }

    if {[auto_load $class::SetBindings] == 0} {
	proc $class::SetBindings {w} {}
    }
}

proc tixRenameWidgetCmd {w new_w} {
    if {[info commands $new_w] != {}} {
	rename $new_w {}
    }
    rename $w $new_w
}

proc tixDeleteWidgetCmd {w} {
    if {[info commands $w] != {}} {
	rename $w {}
    }
}
