'\"
.\"
.\" .HS name section [date [version]]
.\"	Replacement for .TH in other man pages.  See below for valid
.\"	section names.
.\"
.\" .AP type name in/out [indent]
.\"	Start paragraph describing an argument to a library procedure.
.\"	type is type of argument (int, etc.), in/out is either "in", "out",
.\"	or "in/out" to describe whether procedure reads or modifies arg,
.\"	and indent is equivalent to second arg of .IP (shouldn't ever be
.\"	needed;  use .AS below instead)
.\"
.\" .AS [type [name]]
.\"	Give maximum sizes of arguments for setting tab stops.  Type and
.\"	name are examples of largest possible arguments that will be passed
.\"	to .AP later.  If args are omitted, default tab stops are used.
.\"
.\" .BS
.\"	Start box enclosure.  From here until next .BE, everything will be
.\"	enclosed in one large box.
.\"
.\" .BE
.\"	End of box enclosure.
.\"
.\" .VS
.\"	Begin vertical sidebar, for use in marking newly-changed parts
.\"	of man pages.
.\"
.\" .VE
.\"	End of vertical sidebar.
.\"
.\" .DS
.\"	Begin an indented unfilled display.
.\"
.\" .DE
.\"	End of indented unfilled display.
.\"
'\"	# Heading for TIX man pages
.de HS
.if '\\$2'tix'        .TH \\$1 n \\$3 \\TIX
.if t .wh -1.3i ^B
.nr ^l \\n(.l
.ad b
..
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ie !"\\$3"" \{\
.ta \\n()Au \\n()Bu
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp .5
..
'
'
'----------------------------------------------------------------------
.HS tixCombobox tix 3.6
.BS
'
'
'----------------------------------------------------------------------
.SH NAME
tixCombobox - Create and manipulate TIX \fBCombobox\fR widgets
'
'
'
'----------------------------------------------------------------------
.SH SYNOPSIS
\fBtixCombobox\fI \fIpathName ?\fIoptions\fR?
'
'
'
'----------------------------------------------------------------------
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
.VS
\fB
'
background	cursor
relief	borderWidth	geometry
'
\fR
.fi
.LP
See the ``options'' manual entry for details on the standard options.
'
'
'----------------------------------------------------------------------
.SH "WIDGET-SPECIFIC OPTIONS"
'

'----------BEGIN
.LP
.nf
Name:		\fBanchor\fR
Class:		\fBAnchor\fR
Command-Line Switch:	\fB\-anchor\fR
.fi
.IP
Specifies how the string inside the entry subwidget should be aligned.
Only the values "w" or "e" are allowed. When set the "w", the entry is
aligned to its beginning. When set to "e", it is aligned to its end.
'----------END

'----------BEGIN
.LP
.nf
Name:		\fBcommand\fR
Class:		\fBCommand\fR
Command-Line Switch:	\fB\-command\fR
.fi
.IP
Specifies the command to be called when the \fBCombobox\fR is invoked
(See the \fBBINDINGS\fR section).
'----------END
'
'----------BEGIN
.LP
.nf
Name:		\fBdisabledforeground\fR
Class:		\fBDisabledForeground\fR
Command-Line Switch:	\fB\-disabledforeground\fR
.fi
.IP
Specifies the foreground color to be used when the \fBCombobox\fR
widget is disabled.
'----------END
'
'----------BEGIN
.LP
.nf
Name:		\fBentryBg\fR
Class:		\fBBackground\fR
Command-Line Switch:	\fB\-entrybg\fR
.fi
.IP
Specifies the background of the entry subwidget.
'----------END
'
'----------BEGIN
.LP
.nf
Name:		\fBentryWidth\fR
Class:		\fBEntryWidth\fR
Command-Line Switch:	\fB\-entrywidth\fR
Alias:		\fB\-width\fR
.fi
.IP
Specifies the width of the entry subwidget.
'----------END
'
'----------BEGIN
.LP
.nf
Name:		\fBentryfont\fR
Class:		\fBFont\fR
Command-Line Switch:	\fB\-entryfont\fR
.fi
.IP
Specifies the font of the entry subwidget inside the \fBCombobox\fR widget.
'----------END
'
'----------BEGIN
.LP
.nf
Name:		\fBfancy\fR
Class:		\fBFancy\fR
Command-Line Switch:	\fB\-fancy\fR
.fi
.IP
Specifies whether the cross and tick button subwidgets should be
shown. Only the values "true" and "false" are allowed.
'----------END
'
'----------BEGIN
.LP
.nf
Name:		\fBforeground\fR
Class:		\fBForeground\fR
Command-Line Switch:	\fB\-foreground\fR
.fi
.IP
Specifies the foreground color of all the subwidgets of the
\fBCombobox\fR widget.
'----------END
'
'----------BEGIN
.LP
.nf
Name:		\fBhistLimit\fR
Class:		\fBHistLimit\fR
Command-Line Switch:	\fB\-histlimit\fR
.fi
.IP
Specifies how many previous user inputs will be stored.
'----------END
'
'----------BEGIN
.LP
.nf
Name:		\fBlistboxBg\fR
Class:		\fBBackground\fR
Command-Line Switch:	\fB\-listboxbg\fR
.fi
.IP
Specifies the background color of the listbox subwidget.
'----------END
'
'----------BEGIN
.LP
.nf
Name:		\fBlistboxFont\fR
Class:		\fBFont\fR
Command-Line Switch:	\fB\-listboxfont\fR
.fi
.IP
Specifies the font of the listbox subwidget.
'----------END
'
'----------BEGIN
.LP
.nf
Name:		\fBlistboxHeight\fR
Class:		\fBListboxHeight\fR
Command-Line Switch:	\fB\-listboxheight\fR
Alias:		\fB\-height\fR
.fi
.IP
Specifies the height of the listbox subwidget.
'----------END
'
'
'----------BEGIN
.LP
.nf
Name:		\fBscrollbar\fR
Class:		\fBScrollbar\fR
Command-Line Switch:	\fB\-scrollbar\fR
.fi
.IP
Specifies how the schollbars inside the listbox subwidget should be
displayed. See the manual for \fBScrolledListbox\fR for more details.
'----------END
'
'----------BEGIN
.LP
.nf
Name:		\fBstate\fR
Class:		\fBState\fR
Command-Line Switch:	\fB\-state\fR
.fi
.IP
Specifies the whether the \fBCombobox\fR widget is normal or disabled.
Only the values "normal" and "disabled" are recognized.
'----------END
'
'----------BEGIN
.LP
.nf
Name:		\fBtype\fR
Class:		\fBType\fR
Command-Line Switch:	\fB\-type\fR
.fi
.IP
Specifies whether the user can edit the entry and whether previous
user selections will be stored. It can only have one of the following
three values:

\fBstatic\fR: User cannot edit entry. Previous selections not stored.

\fBeditable\fR: User can edit entry. Previous selections not stored.

\fBhistory\fR: User can edit entry. Previous selections are stored.

'----------END
'
'
'
.VE
.BE
'
'
'----------------------------------------------------------------------
.SH DESCRIPTION
'
.PP
'
The \fBtixCombobox\fR command creates a new window (given by the
\fIpathName\fR argument) and makes it into a \fBCombobox\fR widget.
Additional options, described above, may be specified on the command
line or in the option database to configure aspects of the
\fBCombobox\fR such as its cursor and relief.

The Tix \fBCombobox\fR widget is similar to the combo box control in
MS Windows. The user can give a choice by either typing in the entry
subwdget or selecting inside the listbox subwidget.
'
'----------------------------------------------------------------------
.SH WIDGET COMMANDS
.PP
'
The \fBCombobox\fR command creates a new Tcl command whose
name is the same as the path name of the \fBCombobox\fR's window.  This
command may be used to invoke various
operations on the widget. It has the following general form:
'
.DS C
'
\fIpathName option \fR?\fIarg arg ...\fR?

.DE
'
\fIPathName\fR is the name of the command, which is the same as
the frame widget's path name.  \fIOption\fR and the \fIarg\fRs
determine the exact behavior of the command.  The following
commands are possible for \fBCombobox\fR widgets:
'
.TP
'
\fIpathName \fBconfigure\fR ?\fIoption\fR? \fI?value option value ...\fR?
Query or modify the configuration options of the widget.
If no \fIoption\fR is specified, returns a list describing all of
the available options for \fIpathName\fR (see \fBTk_ConfigureInfo\fR for
information on the format of this list).  If \fIoption\fR is specified
with no \fIvalue\fR, then the command returns a list describing the
one named option (this list will be identical to the corresponding
sublist of the value returned if no \fIoption\fR is specified).  If
one or more \fIoption\-value\fR pairs are specified, then the command
modifies the given widget option(s) to have the given value(s);  in
this case the command returns an empty string.
\fIOption\fR may have any of the values accepted by the \fBframe\fR
command.
'
.TP
\fIpathName \fBaddhistory\fI string \fR
Add the string to the beinning of the listbox.
'
.TP
\fIpathName \fBappendhistory\fI string \fR
Append the string to the end of the listbox.
'
'
.TP
\fIpathName \fBentry\fI ?options? \fR
When no options are given, this command returns the pathname of the
entry subwidget.

When options are given, the widget command of the entry subwidget will
be called with these options.
'
.TP
\fIpathName \fBget\fR
return the current user input in the entry subwidget.
'
.TP
\fIpathName \fBlistbox\fI ?options?\fR
When no options are given, this command returns the pathname of the
listbox subwidget.

When options are given, the widget command of the listbox subwidget will
be called with these options.
'
.TP
\fIpathName \fBpick\fI string\fR 
Set the content of the entry subwidget to be this string.
'
.TP
\fIpathName \fBpick -at\fI index\fR 
Select the index'th item inside the lixtbox subwidget and put it
inside the entry subwidget.
'
'----------------------------------------------------------------------
.SH BINDINGS
.PP
.IP [1]
The listbox is popped up when the <Down> key is pressed inside the entry.

.IP [2]
The combobox is invoked and the current content of the entry is
passed to the command specified by the -command option if (1) <Return>
or <Double-ButtonPress-1> inside the entry, (2) <Return> or
<Double-ButtonPress-1> inside the listbox. (3) The "tick" button
subwidget is invoked.

.IP [3]
The current content of the entry can be selected by clicking on
the listbox or moving up and down the listbox using the arrow keys.

.IP [4] When the "cross" button subwidget is invoked, the entry is
cleared if the type of the \fBCombobox\fR is \fIeditable\fR or
\fIhistory\fR '
'----------------------------------------------------------------------
.SH AUTHOR .PP Ioi Kim Lam - ioi@graphics.cis.upenn.edu '
'----------------------------------------------------------------------
.SH KEYWORDS TIX
