'\"
'\" Copyright 1991 Regents of the University of California
'\" Permission to use, copy, modify, and distribute this
'\" documentation for any purpose and without fee is hereby
'\" granted, provided that this notice appears in all copies.
'\" The University of California makes no representations about
'\" the suitability of this material for any purpose.  It is
'\" provided "as is" without express or implied warranty.
'\" 
'\" $Header: /user6/ouster/wish/man/RCS/wish.man,v 1.4 91/12/06 10:43:50 ouster Exp $ SPRITE (Berkeley)
'/" 
.\" The definitions below are for supplemental macros used in Sprite
.\" manual entries.
.\"
.\" .HS name section [date [version]]
.\"	Replacement for .TH in other man pages.  See below for valid
.\"	section names.
.\"
.\" .AP type name in/out [indent]
.\"	Start paragraph describing an argument to a library procedure.
.\"	type is type of argument (int, etc.), in/out is either "in", "out",
.\"	or "in/out" to describe whether procedure reads or modifies arg,
.\"	and indent is equivalent to second arg of .IP (shouldn't ever be
.\"	needed;  use .AS below instead)
.\"
.\" .AS [type [name]]
.\"	Give maximum sizes of arguments for setting tab stops.  Type and
.\"	name are examples of largest possible arguments that will be passed
.\"	to .AP later.  If args are omitted, default tab stops are used.
.\"
.\" .BS
.\"	Start box enclosure.  From here until next .BE, everything will be
.\"	enclosed in one large box.
.\"
.\" .BE
.\"	End of box enclosure.
.\"
.\" .VS
.\"	Begin vertical sidebar, for use in marking newly-changed parts
.\"	of man pages.
.\"
.\" .VE
.\"	End of vertical sidebar.
.\"
.\" .DS
.\"	Begin an indented unfilled display.
.\"
.\" .DE
.\"	End of indented unfilled display.
.\"
'\"	# Heading for Sprite man pages
.de HS
.if '\\$2'cmds'       .TH \\$1 1 \\$3 \\$4
.if '\\$2'lib'        .TH \\$1 3 \\$3 \\$4
.if '\\$2'tcl'        .TH \\$1 3 \\$3 \\$4
.if '\\$2'tk'         .TH \\$1 3 \\$3 \\$4
.if t .wh -1.3i ^B
.nr ^l \\n(.l
.ad b
..
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ie !"\\$3"" \{\
.ta \\n()Au \\n()Bu
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp .5
..
.HS xfemacs cmds
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
xfemacs \- Emacs with menubars, scrollbars and more
.SH SYNOPSIS
\fBxfemacs\fR ?\fIoptions\fR?\fR ?\fIfilenames\fR?
.SH OPTIONS
.IP "\fB\-display \fIdisplay\fR" 15
Display (and screen) on which to display window.
.IP "\fB\-geometry \fIgeometry\fR" 15
Initial geometry to use for window.
.IP "\fB\-function \fIlisp-function\fR" 15
Runs lisp function in emacs. The function must be a valid emacs
function call (enclosed in '()').
.IP "\fB\-load \fIfile\fR" 15
Loads the lisp code in the file \fIfile\fR.
.IP "\fB\-client\fR" 15
Starts xfemacs as client. This means that xfemacs tries
to use an existing xfemacs for editing.
.IP "\fB\-xfColorFile \fIfilename\fR" 15
This option specifies a file containing a list of all known
colors. This file is automatically created when XF is installed,
so please set this variable to the location of the \fBColors\fR
file of the installed XF (usually in the directory ./lib inside
the XF distribution).
.IP "\fB\-xfFontFile \fIfilename\fR" 15
This option specifies a file containing a list of all known
fonts. This file is automatically created when XF is installed,
so please set this variable to the location of the \fBFonts\fR
file of the installed XF (usually in the directory ./lib inside
the XF distribution).
.IP "\fB\-xfLoadPath \fIpathname\fR" 15
This option specifies a list of pathnames (separated by ":") where
the xfemacs Tcl source files can be found. In order to find the
Tcl source files they must be stored in one of these directories.
.IP "\fBfilenames\fR" 15
The given filenames are loaded into the emacs at startup.
.BE

.SH DESCRIPTION
.PP
\fBXfemacs\fR is a simple program that provides access to emacs
(18.58 or later) under a Tcl/Tk environment. It is based upon the
\fBTkEmacs\fR widget. You can define pull-down menus and popup
menus which directly call emacs lisp functions. This gives you full
access to emacs with additional functionality provided by Tcl/Tk.
\fBXfemacs\fR is just a little demo program for the \fBTkEmacs\fR
widget, so don't expect too much. Feel free to adapt the program
for your local needs. If you make substantial (interesting :-)
changes, please let us know, so we can include them into future
releases.

To add a file to an \fBxfemacs\fR already running, you can call
\fBxfemacsc\fR. This calls \fBxfemacs\fR as a client. That means
that the files are loaded in the \fBxfemacs\fR already running.

.SH MENU-STRUCTURE
.PP
The menu structure of \fBxfemacs\fR can be adapted by you. Select
the menu item \fBMenus\fR in the pull-down menu \fBConfigure\fR.
You will get a dialog box which allows you the manipulation of
the menubuttons and menus that are used by \fBxfemacs\fR. For
users who are not familiar with the programming of Tcl/Tk we
would recommend that you take a short look in the documentation
of Tcl/Tk (especially concerning the menubuttons and the menus).
If you only want to send lisp code this may not be necessary.
.PP
There are 15 menubuttons that can be configured. You see all
available menubuttons in the list up right. Select one
menubutton from the list to display its current configuration
in the left area of the dialog box. If a menubutton has a label,
it will be displayed; otherwise it will be hidden. The order of
the menubuttons is not changeable. The menubutton has an option
(named menu) that links a menu to a menubutton. By changing
this option, you can change the order of the menus. Some
of the resources can be changed with additional dialog boxes.
To call such a dialog (i.e. a color selection box) double click
the right mouse button into the text field you want to change.
All changes can be applied to the menubutton by pressing the
button \fBModify\fR. If you change the visibility of a button
(by adding/deleting a label) this change will affect the
menubutton at the next startup of xfemacs.
.PP
The menus can be changed by selecting the menu in the list
showing the names of all menus that are currently defined. You
can change the parameters for the menu, or the items that the
menu contains. In the first case the handling is exactly like
the handling of menubuttons. The only difference is, that you
can add/delete menus. If you select the button \fBModify Menu\fR
the dialog window changes and you see a list of the currently
defined menu items that can be modified by you. The handling for
modifying the menu items is the same as for menus and menubuttons.
To change the type of the menu item to be inserted, you select
the menubutton in the upper left corner named \fBMenu entry\fR.
.PP
The most important command is the Tcl command \fBSendToEmacs\fR
that sends the passed parameter to emacs, where this lisp code
is evaluated. If you want to have more direct control over the
sending (i.e. to handle the return value) you can send the lisp
code by typing: \fB.frame.text send {lisp code}\fR. For a more
detailed description of the communication and handling of the
Tcl/Tk - Emacs connection, read the manual for the \fBTkEmacs\fR 
widget.
.PP
To make your changes permanent you have to select the \fBSave\fR
button in the dialog box for menu and menubutton changing. The 
new definition for the menu layout is stored to the file named
~/.xfemacs-c.tcl.

.SH "MODE SPECIFIC MENUS"
.PP
You can define popup menus, that are specific for a certain emacs
mode. This popup is activated by pressing <Mod1-Button3> (this
default can be changed). The menu for a mode must have a certain
name to be accessible. It must be child of the root window (.),
and must have the same name as the mode where spaces are ignored
(deleted). For Lisp Interaction mode, the name of the popup menu
is: \fB.LispInteraction\fR.

If a mode specific menu is defined, a double click on the left
mouse button activates the first menu action of the mode menu.

.SH SCROLLBARS
.PP
The linkage between the emacs widget and emacs is not strong
enough to guarantee that the scrollbars are always in the
correct size and at the correct location. There is a polling
mechanism, that updates the scrollbar in a 10 second interval.
Some of the most important emacs functions (in our opinion :-)
update the scrollbar when they are called as well.

.SH RESOURCES
.PP
You can configure the colors and fonts that \fBxfemacs\fR uses.
These options are changed via the menu item \fBResources\fR in
the pull-down menu \fBConfigure\fR. You have to save your
changes by selecting the menu item \fBSave\fR. The options are
stored to the file named ~/.xfemacs-o.tcl.

.SH ENVIRONMENT
.IP DISPLAY 15
The default display to be used.
.IP XF_COLOR_FILE 15
This variable specifies a file containing a list of all known
colors. This file is automatically created when XF is installed,
so please set this variable to the location of the \fBColors\fR
file of the installed XF (usually in the directory ./lib inside
the XF distribution).
.IP XF_FONT_FILE 15
This variable specifies a file containing a list of all known
fonts. This file is automatically created when XF is installed,
so please set this variable to the location of the \fBFonts\fR
file of the installed XF (usually in the directory ./lib inside
the XF distribution).
.IP XF_LOAD_PATH 15
This variable specifies a list of pathnames (separated by ":") where
the xfemacs Tcl source files can be found. In order to find the
Tcl source files they must be stored in one of these directories.

.SH WARNING
.PP
If you use this widget (program), be aware of the fact that it
can lead into trouble. It was tested, but as emacs is a complex
system and tk2.3 is a complex system, too, there may still be
some problems. 
.PP
If you encounter any problems, please let us know. If you are
able to locate the bug, please send problems, bug fixes and
ideas related with the emacs code to:
.IP "" 15
\fBnickel@cs.tu-berlin.de\fR
.LP
.PP
and problems etc. with tk and the emacs C code (the
modifications for TkEmacs, not general problems with emacs C
code :-), to:
.IP "" 15
\fBgarfield@cs.tu-berlin.de\fR
.LP
.PP
If you don't know which one is the right address for your
problem, it's no problem... Just send it to one of us (you
will not be punished if it was the wrong address ;-).
.PP
Feel free to modify/adapt the sources and to write new lisp
functions for improved functionality. If you do so, please
let us know, so we can improve the widget for us and the
other users (if there are any :-).

.SH BUGS
.\"
.IP "\(bu"
The Buffers menu is a little sensitive. It can happen
that you only get the correct pull-down menu after you
have clicked the Buffers menubutton a few times.
Sometimes the contents of the menu are not correct.
.\"
.IP "\(bu"
Surely there are many bugs.

.SH KEYWORDS
emacs, wish, tkemacs, xf
