#!ewish -f
#
# Program: xfemacs
#
# startup source

  global argc
  global argv
  global env

  wm withdraw .

  set runAsClient 0
  set tmpStartArgv ""
  for {set counter 0} {$counter < $argc} {incr counter 1} {
    case [string tolower [lindex $argv $counter]] in {
      {-client} {
        set runAsClient 1
      }
      {default} {
        lappend tmpStartArgv [lindex $argv $counter]
      }
    }
  }
  set tmpFileArgv ""
  set tmpLoadFile ""
  set tmpFunction ""
  if {$runAsClient == 1} {
    for {set counter 0} {$counter < [llength $tmpStartArgv]} {incr counter 1} {
      case [string tolower [lindex $tmpStartArgv $counter]] in {
        {-xfloadpath} {
          incr counter
        }
        {-load} {
          incr counter
          lappend tmpLoadFile [lindex $tmpStartArgv $counter]
        }
        {-function} {
          incr counter
          set tmpFunction [lindex $tmpStartArgv $counter]
        }
        {default} {
          set fileName [lindex $tmpStartArgv $counter]
          if {"[file dirname $fileName]" == "."} {
            lappend tmpFileArgv [pwd]/$fileName
          } {
            lappend tmpFileArgv $fileName
          }
        }
      }
    }
    foreach counter $tmpLoadFile {
      set sendCommand "SendToEmacs {(load \"$counter\")}"
      if {[catch "send xfemacs \{$sendCommand\}" result]} {
        set argv $tmpStartArgv
        set argc [llength $tmpStartArgv]
        set runAsClient 0
        break
      }
    }
    foreach counter $tmpFileArgv {
      set sendCommand "SendToEmacs {(find-file \"$counter\")}"
      if {[catch "send xfemacs \{$sendCommand\}" result]} {
        set argv $tmpStartArgv
        set argc [llength $tmpStartArgv]
        set runAsClient 0
        break
      }
    }
    if {"[string trim $tmpFunction]" != ""} {
      set sendCommand "SendToEmacs {$tmpFunction}"
      if {[catch "send xfemacs \{$sendCommand\}" result]} {
        set argv $tmpStartArgv
        set argc [llength $tmpStartArgv]
        set runAsClient 0
        break
      }
    }
  }
  if {$runAsClient == 1} {
    destroy .
  }
  catch "unset fileName"
  catch "unset runAsClient"
  catch "unset tmpStartArgv"
  catch "unset tmpFileArgv"
  catch "unset tmpLoadFile"
  catch "unset tmpFunction"



# module inclusion
global argc
global argv
global env
global xfLoadInfo
global xfLoadPath

if {[info exists env(XF_LOAD_PATH)]} {
  if {[string first $env(XF_LOAD_PATH) .:/usr/local/lib] == -1} {
    set xfLoadPath $env(XF_LOAD_PATH):.:/usr/local/lib
  } {
    set xfLoadPath .:/usr/local/lib
  }
} {
  set xfLoadPath .:/usr/local/lib
}

set xfLoadInfo 0
set tmpArgv ""
for {set counter 0} {$counter < $argc} {incr counter 1} {
  case [string tolower [lindex $argv $counter]] in {
    {-xfloadpath} {
      incr counter 1
      set xfLoadPath "[lindex $argv $counter]:$xfLoadPath"
    }
    {-xfcolorfile} {
      incr counter 1
      set env(XF_COLOR_FILE) "[lindex $argv $counter]"
    }
    {-xfcursorfile} {
      incr counter 1
      set env(XF_CURSOR_FILE) "[lindex $argv $counter]"
    }
    {-xffontfile} {
      incr counter 1
      set env(XF_FONT_FILE) "[lindex $argv $counter]"
    }
    {-xfloading} {
      set xfLoadInfo 1
    }
    {-xfnoloading} {
      set xfLoadInfo 0
    }
    {default} {
      lappend tmpArgv [lindex $argv $counter]
    }
  }
}
set argv $tmpArgv
set argc [llength $tmpArgv]
unset counter
unset tmpArgv


proc ShowWindow. {args} {

  # Window manager configurations
  wm title . {xfemacs.tcl}
  if {[string match 200x200* [wm geometry .]] == 1} {
    wm sizefrom . program
    wm geometry . 600x400
  } {
    if {[string match *x* [wm geometry .]] == 1} {
      wm sizefrom . program
    } {
      wm sizefrom . user
    }
  }
  if {[string match *+0+0 [wm geometry .]] == 1} {
    wm positionfrom . program
    wm geometry . +436+284
  } {
    if {[regexp {[+]+0[+]+0} [wm geometry .]] == 1} {
      wm positionfrom . program
    } {
      wm positionfrom . user
    }
  }
  wm maxsize . 1152 900
  wm minsize . 0 0

  # build widget .C
  menu .C
  .C configure \
    -activebackground {white}\
    -activeforeground {black}\
    -background {#dcdcdc}\
    -font {-adobe-helvetica-bold-r-normal--12-120-75-75-p-70-iso8859-1}\
    -foreground {black}
  # bindings
  tk_bindForTraversal .C

  # Menu widget code
  .C add command\
    -command {SendToEmacs {(find-tag "")}}\
    -label {Find tag under pointer}
  .C add command\
    -accelerator {M-.}\
    -command {SendToEmacs {(call-interactively 'find-tag)}}\
    -label {Find tag}
  .C add command\
    -accelerator {C-x `}\
    -command {SendToEmacs {(next-error)}}\
    -label {Next error}
  .C add separator
  .C add command\
    -accelerator {C-M-q}\
    -command {SendToEmacs {(indent-sexp)}}\
    -label {Indent expression}
  .C add command\
    -accelerator {C-M-\ }\
    -command {SendToEmacs {(indent-region)}}\
    -label {Indent region}

  # build widget .EmacsDefault
  menu .EmacsDefault
  .EmacsDefault configure \
    -activebackground {white}\
    -activeforeground {black}\
    -background {#dcdcdc}\
    -font {-adobe-helvetica-bold-r-normal--12-120-75-75-p-70-iso8859-1}\
    -foreground {black}
  # bindings
  tk_bindForTraversal .EmacsDefault

  # Menu widget code
  .EmacsDefault add command\
    -accelerator {C-x u}\
    -command {SendToEmacs {(undo)}}\
    -label {Undo}

  # build widget .frame
  frame .frame
  .frame configure \
    -background {#dcdcdc}\
    -relief {raised}
  # bindings
  tk_bindForTraversal .frame


  # build widget .frame.scrollbar1
  scrollbar .frame.scrollbar1
  .frame.scrollbar1 configure \
    -activeforeground {GhostWhite}\
    -background {#dcdcdc}\
    -command {.frame.text yview}\
    -foreground {gray}\
    -relief {raised}
  # bindings
  tk_bindForTraversal .frame.scrollbar1
  bind .frame.scrollbar1 <Any-Button> {
incr tk_priv(buttons)
.frame.text updatescrollbars} 


  # build widget .frame.scrollbar5
  scrollbar .frame.scrollbar5
  .frame.scrollbar5 configure \
    -activeforeground {GhostWhite}\
    -background {#dcdcdc}\
    -command {.frame.text xview}\
    -foreground {gray}\
    -orient {horizontal}\
    -relief {raised}
  # bindings
  tk_bindForTraversal .frame.scrollbar5
  bind .frame.scrollbar5 <Any-Button> {
incr tk_priv(buttons)
.frame.text updatescrollbars} 


  # build widget .frame.text
  if {[catch "tkemacs .frame.text -command TkEmacs -lispfile tkemacs.el"] != 0} {
    if {[string length [info procs XFSaveAsProc]] > 0} {
      XFError "Unknown widget type: tkemacs"
      return
    } {
      puts stderr "Unknown widget type: tkemacs"
      destroy .
    }
  }
  .frame.text configure \
    -background {#dcdcdc}\
    -borderwidth {2}\
    -errorcallback {EmacsError}\
    -debug {false}\
    -foreground {black}\
    -geometry {300x200}\
    -insertbackground {blue}\
    -pollinterval {60}\
    -relief {raised}\
    -useadvise {true}\
    -xscrollcommand {.frame.scrollbar5 set}\
    -yscrollcommand {.frame.scrollbar1 set}
  # bindings
  tk_bindForTraversal .frame.text
  bind .frame.text <Any-ButtonRelease-3> {
      global emacsCurrentMenu
      if {"$emacsCurrentMenu" != ""} {
        $emacsCurrentMenu invoke active
        $emacsCurrentMenu unpost
        set emacsCurrentMenu ""
      }} 
  bind .frame.text <B3-Mod1-Motion> {EmacsPopupHandle %X %Y} 
  bind .frame.text <Double-Button-1> {EmacsDoubleClick} 
  bind .frame.text <Mod1-Button-3> {EmacsPopup %X %Y} 


  # pack widget .frame
  pack append .frame\
    .frame.scrollbar1   {left frame center filly} \
    .frame.text   {top frame center expand fill} \
    .frame.scrollbar5   {top frame center fillx} 


  # build widget .frame0
  frame .frame0
  .frame0 configure \
    -background {#dcdcdc}\
    -borderwidth {2}\
    -relief {raised}
  # bindings
  tk_bindForTraversal .frame0


  # build widget .frame0.button01
  button .frame0.button01
  .frame0.button01 configure \
    -activebackground {white}\
    -activeforeground {black}\
    -background {#dcdcdc}\
    -command {SendToEmacs {(undo)}}\
    -font {-adobe-helvetica-bold-r-normal--12-120-75-75-p-70-iso8859-1}\
    -foreground {black}\
    -text {Undo}
  # bindings
  tk_bindForTraversal .frame0.button01


  # build widget .frame0.menubutton00
  menubutton .frame0.menubutton00
  .frame0.menubutton00 configure \
    -activebackground {white}\
    -activeforeground {black}\
    -background {#dcdcdc}\
    -font {-adobe-helvetica-bold-r-normal--12-120-75-75-p-70-iso8859-1}\
    -foreground {black}\
    -menu {.frame0.menubutton00.m}\
    -text {File}\
    -underline {0}
  # bindings
  tk_bindForTraversal .frame0.menubutton00
  bind .frame0.menubutton00 <B1-Enter> {
              set tk_priv(inMenuButton) %W
              if {([lindex [%W config -state] 4] != "disabled")
                  && ("%m" != "NotifyGrab") && ("%m" != "NotifyUngrab")} {
                if {!$tk_strictMotif} {
                  %W config -state active
                }
                tk_mbPost %W
              }} 
  bind .frame0.menubutton00 <Button-1> {
              tk_mbButtonDown %W} 
  bind .frame0.menubutton00 <Button-2> {
              if {($tk_priv(posted) == "")
                  && ([lindex [%W config -state] 4] != "disabled")} {
                set tk_priv(dragging) %W
                  [lindex [$tk_priv(dragging) config -menu] 4] post %X %Y
              }} 

  eval "tk_menus . [string trim [tk_menus .] \"\{\}\"] .frame0.menubutton00"

  # build widget .frame0.menubutton00.m
  menu .frame0.menubutton00.m
  .frame0.menubutton00.m configure \
    -activebackground {white}\
    -activeforeground {black}\
    -background {#dcdcdc}\
    -font {-adobe-helvetica-bold-r-normal--12-120-75-75-p-70-iso8859-1}\
    -foreground {black}
  # bindings
  tk_bindForTraversal .frame0.menubutton00.m

  # Menu widget code
  .frame0.menubutton00.m add cascade\
    -accelerator {C-x C-f}\
    -command {set emacsResult [FSBox {Select file to load:}]
if {"$emacsResult" != ""} {
  SendToEmacs "(find-file \"$emacsResult\")"
}}\
    -label {Open...}\
    -menu {.frame0.menubutton00.m.m}\
    -underline {0}
  .frame0.menubutton00.m add command\
    -accelerator {C-x i}\
    -command {set emacsResult [FSBox {Select file to load:}]
if {"$emacsResult" != ""} {
  SendToEmacs "(insert-file \"$emacsResult\")"
}}\
    -label {Insert...}\
    -underline {0}
  .frame0.menubutton00.m add command\
    -command {set emacsResult [FSBox {Select lisp file to load:}]
if {"$emacsResult" != ""} {
  SendToEmacs "(load-file \"$emacsResult\")"
}}\
    -label {Load file (lisp)...}\
    -underline {5}
  .frame0.menubutton00.m add separator
  .frame0.menubutton00.m add command\
    -accelerator {C-x C-s}\
    -command {SendToEmacs (save-buffer)}\
    -label {Save}\
    -underline {0}
  .frame0.menubutton00.m add command\
    -accelerator {C-x s}\
    -command {SendToEmacs {(call-interactively 'save-some-buffers)}}\
    -label {Save some}\
    -underline {7}
  .frame0.menubutton00.m add command\
    -accelerator {C-x C-w}\
    -command {set emacsResult [FSBox {Select filename for saving:}]
if {"$emacsResult" != ""} {
  SendToEmacs "(write-file \"$emacsResult\")"
}}\
    -label {Save as...}\
    -underline {5}
  .frame0.menubutton00.m add separator
  .frame0.menubutton00.m add command\
    -command {ReadBox}\
    -label {Enter TCL code...}\
    -underline {6}
  .frame0.menubutton00.m add separator
  .frame0.menubutton00.m add command\
    -accelerator {C-x C-c}\
    -command {
EmacsQuit}\
    -label {Quit}\
    -underline {0}

  # build widget .frame0.menubutton00.m.m
  menu .frame0.menubutton00.m.m
  .frame0.menubutton00.m.m configure \
    -activebackground {white}\
    -activeforeground {black}\
    -background {#dcdcdc}\
    -font {-adobe-helvetica-bold-r-normal--12-120-75-75-p-70-iso8859-1}\
    -foreground {black}
  # bindings
  tk_bindForTraversal .frame0.menubutton00.m.m

  # Menu widget code
  .frame0.menubutton00.m.m add command\
    -accelerator {C-x 4 f}\
    -command {set emacsResult [FSBox {Select file to load:}]
if {"$emacsResult" != ""} {
  SendToEmacs "(find-file-other-window \"$emacsResult\")"
}}\
    -label {In other window...}\
    -underline {0}

  # build widget .frame0.menubutton01
  menubutton .frame0.menubutton01
  .frame0.menubutton01 configure \
    -activebackground {white}\
    -activeforeground {black}\
    -background {#dcdcdc}\
    -font {-adobe-helvetica-bold-r-normal--12-120-75-75-p-70-iso8859-1}\
    -foreground {black}\
    -menu {.frame0.menubutton01.m}\
    -text {Edit}\
    -underline {0}
  # bindings
  tk_bindForTraversal .frame0.menubutton01
  bind .frame0.menubutton01 <B1-Enter> {
              set tk_priv(inMenuButton) %W
              if {([lindex [%W config -state] 4] != "disabled")
                  && ("%m" != "NotifyGrab") && ("%m" != "NotifyUngrab")} {
                if {!$tk_strictMotif} {
                  %W config -state active
                }
                tk_mbPost %W
              }} 
  bind .frame0.menubutton01 <Button-1> {
              tk_mbButtonDown %W} 
  bind .frame0.menubutton01 <Button-2> {
              if {($tk_priv(posted) == "")
                  && ([lindex [%W config -state] 4] != "disabled")} {
                set tk_priv(dragging) %W
                  [lindex [$tk_priv(dragging) config -menu] 4] post %X %Y
              }} 

  eval "tk_menus . [string trim [tk_menus .] \"\{\}\"] .frame0.menubutton01"

  # build widget .frame0.menubutton01.m
  menu .frame0.menubutton01.m
  .frame0.menubutton01.m configure \
    -activebackground {white}\
    -activeforeground {black}\
    -background {#dcdcdc}\
    -font {-adobe-helvetica-bold-r-normal--12-120-75-75-p-70-iso8859-1}\
    -foreground {black}
  # bindings
  tk_bindForTraversal .frame0.menubutton01.m

  # Menu widget code
  .frame0.menubutton01.m add command\
    -accelerator {C-x u}\
    -command {SendToEmacs {(undo)}}\
    -label {Undo}\
    -underline {0}
  .frame0.menubutton01.m add separator
  .frame0.menubutton01.m add command\
    -accelerator {C-w}\
    -command {SendToEmacs {(call-interactively 'kill-region)}}\
    -label {Cut}\
    -underline {1}
  .frame0.menubutton01.m add command\
    -accelerator {M-w}\
    -command {SendToEmacs {(call-interactively 'copy-region-as-kill)}}\
    -label {Copy}\
    -underline {0}
  .frame0.menubutton01.m add command\
    -accelerator {C-y}\
    -command {SendToEmacs {(yank)}}\
    -label {Paste}\
    -underline {0}
  .frame0.menubutton01.m add separator
  .frame0.menubutton01.m add command\
    -accelerator {C-SPC}\
    -command {SendToEmacs {(call-interactively 'set-mark-command)}}\
    -label {Set mark}\
    -underline {0}
  .frame0.menubutton01.m add command\
    -accelerator {C-x C-x}\
    -command {SendToEmacs {(exchange-point-and-mark)}}\
    -label {Exchange point and mark}\
    -underline {0}
  .frame0.menubutton01.m add command\
    -accelerator {C-u C-SPC}\
    -command {SendToEmacs {(set-mark-command '(4))}}\
    -label {Previous mark}\
    -underline {9}

  # build widget .frame0.menubutton02
  menubutton .frame0.menubutton02
  .frame0.menubutton02 configure \
    -activebackground {white}\
    -activeforeground {black}\
    -background {#dcdcdc}\
    -font {-adobe-helvetica-bold-r-normal--12-120-75-75-p-70-iso8859-1}\
    -foreground {black}\
    -menu {.frame0.menubutton02.m}\
    -text {Commands}\
    -underline {0}
  # bindings
  tk_bindForTraversal .frame0.menubutton02
  bind .frame0.menubutton02 <B1-Enter> {
              set tk_priv(inMenuButton) %W
              if {([lindex [%W config -state] 4] != "disabled")
                  && ("%m" != "NotifyGrab") && ("%m" != "NotifyUngrab")} {
                if {!$tk_strictMotif} {
                  %W config -state active
                }
                tk_mbPost %W
              }} 
  bind .frame0.menubutton02 <Button-1> {
              tk_mbButtonDown %W} 
  bind .frame0.menubutton02 <Button-2> {
              if {($tk_priv(posted) == "")
                  && ([lindex [%W config -state] 4] != "disabled")} {
                set tk_priv(dragging) %W
                  [lindex [$tk_priv(dragging) config -menu] 4] post %X %Y
              }} 

  eval "tk_menus . [string trim [tk_menus .] \"\{\}\"] .frame0.menubutton02"

  # build widget .frame0.menubutton02.m
  menu .frame0.menubutton02.m
  .frame0.menubutton02.m configure \
    -activebackground {white}\
    -activeforeground {black}\
    -background {#dcdcdc}\
    -font {-adobe-helvetica-bold-r-normal--12-120-75-75-p-70-iso8859-1}\
    -foreground {black}
  # bindings
  tk_bindForTraversal .frame0.menubutton02.m

  # Menu widget code
  .frame0.menubutton02.m add command\
    -command {SendToEmacs {(redraw-display)}}\
    -label {Redisplay}\
    -underline {0}
  .frame0.menubutton02.m add separator
  .frame0.menubutton02.m add command\
    -accelerator {C-x m}\
    -command {SendToEmacs (mail)}\
    -label {Send mail}\
    -underline {5}
  .frame0.menubutton02.m add command\
    -command {SendToEmacs (rmail)}\
    -label {Read mail}\
    -underline {0}
  .frame0.menubutton02.m add command\
    -command {SendToEmacs (gnus)}\
    -label {Read news}\
    -underline {5}
  .frame0.menubutton02.m add command\
    -command {set emacsResult [FSBox {Select directoryname:}]
if {"$emacsResult" != ""} {
  SendToEmacs "(dired \"$emacsResult\")"
}}\
    -label {Dired...}\
    -underline {0}
  .frame0.menubutton02.m add command\
    -command {set emacsResult [FSBox {Select filename for debugging:}]
if {"$emacsResult" != ""} {
  SendToEmacs "(gdb \"$emacsResult\")"
}}\
    -label {GDB}\
    -underline {0}
  .frame0.menubutton02.m add command\
    -command {SendToEmacs (shell)}\
    -label {Shell}\
    -underline {0}
  .frame0.menubutton02.m add separator
  .frame0.menubutton02.m add cascade\
    -command {SendToEmacs {(call-interactively 'search-forward)}}\
    -label {Search}\
    -menu {.frame0.menubutton02.m.m0}
  .frame0.menubutton02.m add command\
    -accelerator {M-.}\
    -command {SendToEmacs {(call-interactively 'find-tag)}}\
    -label {Find tag}\
    -underline {0}
  .frame0.menubutton02.m add command\
    -command {SendToEmacs {(call-interactively 'compile)}}\
    -label {Compile}\
    -underline {0}
  .frame0.menubutton02.m add command\
    -command {SendToEmacs (eval-current-buffer)}\
    -label {Eval buffer}\
    -underline {0}
  .frame0.menubutton02.m add command\
    -command {SendToEmacs (ispell-buffer)}\
    -label {Ispell buffer}\
    -underline {4}
  .frame0.menubutton02.m add command\
    -command {SendToEmacs {(call-interactively 'query-replace)}}\
    -label {Query replace}\
    -underline {0}
  .frame0.menubutton02.m add separator
  .frame0.menubutton02.m add command\
    -accelerator {C-g}\
    -command {SendToEmacs {(message "Press C-g to abort.")(sit-for 3)}}\
    -label {Abort}\
    -underline {0}

  # build widget .frame0.menubutton02.m.m0
  menu .frame0.menubutton02.m.m0
  .frame0.menubutton02.m.m0 configure \
    -activebackground {white}\
    -activeforeground {black}\
    -background {#dcdcdc}\
    -font {-adobe-helvetica-bold-r-normal--12-120-75-75-p-70-iso8859-1}\
    -foreground {black}
  # bindings
  tk_bindForTraversal .frame0.menubutton02.m.m0

  # Menu widget code
  .frame0.menubutton02.m.m0 add command\
    -command {SendToEmacs {(call-interactively 'search-forward)}}\
    -label {forward}
  .frame0.menubutton02.m.m0 add command\
    -command {SendToEmacs {(call-interactively 'search-backward)}}\
    -label {backward}

  # build widget .frame0.menubutton03
  menubutton .frame0.menubutton03
  .frame0.menubutton03 configure \
    -activebackground {white}\
    -activeforeground {black}\
    -background {#dcdcdc}\
    -font {-adobe-helvetica-bold-r-normal--12-120-75-75-p-70-iso8859-1}\
    -foreground {black}\
    -menu {.frame0.menubutton03.m}\
    -text {Buffers}\
    -underline {0}
  # bindings
  tk_bindForTraversal .frame0.menubutton03
  bind .frame0.menubutton03 <B1-Enter> {
          EmacsBuildBuffList %W
          set tk_priv(inMenuButton) %W
          if {([lindex [%W config -state] 4] != "disabled")
              && ("%m" != "NotifyGrab") && ("%m" != "NotifyUngrab")} {
            if {!$tk_strictMotif} {
              %W config -state active
            }
            tk_mbPost %W
          }} 
  bind .frame0.menubutton03 <Button-1> {
          EmacsBuildBuffList %W
          tk_mbButtonDown %W} 
  bind .frame0.menubutton03 <Button-2> {
          EmacsBuildBuffList %W
          if {($tk_priv(posted) == "")
              && ([lindex [%W config -state] 4] != "disabled")} {
            set tk_priv(dragging) %W
              [lindex [$tk_priv(dragging) config -menu] 4] post %X %Y
          }} 

  eval "tk_menus . [string trim [tk_menus .] \"\{\}\"] .frame0.menubutton03"

  # build widget .frame0.menubutton03.m
  menu .frame0.menubutton03.m
  .frame0.menubutton03.m configure \
    -activebackground {white}\
    -activeforeground {black}\
    -background {#dcdcdc}\
    -font {-adobe-helvetica-bold-r-normal--12-120-75-75-p-70-iso8859-1}\
    -foreground {black}
  # bindings
  tk_bindForTraversal .frame0.menubutton03.m

  # Menu widget code
  .frame0.menubutton03.m add command\
    -label {nothing}

  # build widget .frame0.menubutton04
  menubutton .frame0.menubutton04
  .frame0.menubutton04 configure \
    -activebackground {white}\
    -activeforeground {black}\
    -background {#dcdcdc}\
    -font {-adobe-helvetica-bold-r-normal--12-120-75-75-p-70-iso8859-1}\
    -foreground {black}\
    -menu {.frame0.menubutton04.m}\
    -text {Windows}\
    -underline {0}
  # bindings
  tk_bindForTraversal .frame0.menubutton04
  bind .frame0.menubutton04 <B1-Enter> {
              set tk_priv(inMenuButton) %W
              if {([lindex [%W config -state] 4] != "disabled")
                  && ("%m" != "NotifyGrab") && ("%m" != "NotifyUngrab")} {
                if {!$tk_strictMotif} {
                  %W config -state active
                }
                tk_mbPost %W
              }} 
  bind .frame0.menubutton04 <Button-1> {
              tk_mbButtonDown %W} 
  bind .frame0.menubutton04 <Button-2> {
              if {($tk_priv(posted) == "")
                  && ([lindex [%W config -state] 4] != "disabled")} {
                set tk_priv(dragging) %W
                  [lindex [$tk_priv(dragging) config -menu] 4] post %X %Y
              }} 

  eval "tk_menus . [string trim [tk_menus .] \"\{\}\"] .frame0.menubutton04"

  # build widget .frame0.menubutton04.m
  menu .frame0.menubutton04.m
  .frame0.menubutton04.m configure \
    -activebackground {white}\
    -activeforeground {black}\
    -background {#dcdcdc}\
    -font {-adobe-helvetica-bold-r-normal--12-120-75-75-p-70-iso8859-1}\
    -foreground {black}
  # bindings
  tk_bindForTraversal .frame0.menubutton04.m

  # Menu widget code
  .frame0.menubutton04.m add cascade\
    -command {SendToEmacs {(split-window-vertically)}}\
    -label {Split Window}\
    -menu {.frame0.menubutton04.m.m}\
    -underline {1}
  .frame0.menubutton04.m add command\
    -accelerator {C-x 0}\
    -command {SendToEmacs {(delete-window)}}\
    -label {Delete window}\
    -underline {0}
  .frame0.menubutton04.m add command\
    -accelerator {C-x 1}\
    -command {SendToEmacs {(delete-other-windows)}}\
    -label {Delete other windows}\
    -underline {0}
  .frame0.menubutton04.m add separator
  .frame0.menubutton04.m add cascade\
    -command {SendToEmacs {(shrink-window 1)}}\
    -label {Shrink window}\
    -menu {.frame0.menubutton04.m.m1}\
    -underline {1}
  .frame0.menubutton04.m add cascade\
    -accelerator {C-x ^}\
    -command {SendToEmacs {(enlarge-window 1)}}\
    -label {Enlarge window}\
    -menu {.frame0.menubutton04.m.m2}\
    -underline {1}

  # build widget .frame0.menubutton04.m.m
  menu .frame0.menubutton04.m.m
  .frame0.menubutton04.m.m configure \
    -activebackground {white}\
    -activeforeground {black}\
    -background {#dcdcdc}\
    -font {-adobe-helvetica-bold-r-normal--12-120-75-75-p-70-iso8859-1}\
    -foreground {black}
  # bindings
  tk_bindForTraversal .frame0.menubutton04.m.m

  # Menu widget code
  .frame0.menubutton04.m.m add command\
    -accelerator {C-x 2}\
    -command {SendToEmacs {(split-window-vertically)}}\
    -label {Vertically}\
    -underline {0}
  .frame0.menubutton04.m.m add command\
    -accelerator {C-x 5}\
    -command {SendToEmacs {(split-window-horizontally)}}\
    -label {Horizontally}\
    -underline {0}

  # build widget .frame0.menubutton04.m.m1
  menu .frame0.menubutton04.m.m1
  .frame0.menubutton04.m.m1 configure \
    -activebackground {white}\
    -activeforeground {black}\
    -background {#dcdcdc}\
    -font {-adobe-helvetica-bold-r-normal--12-120-75-75-p-70-iso8859-1}\
    -foreground {black}
  # bindings
  tk_bindForTraversal .frame0.menubutton04.m.m1

  # Menu widget code
  .frame0.menubutton04.m.m1 add command\
    -command {SendToEmacs {(shrink-window 1)}}\
    -label {1}\
    -underline {0}
  .frame0.menubutton04.m.m1 add command\
    -command {SendToEmacs {(shrink-window 2)}}\
    -label {2}\
    -underline {0}
  .frame0.menubutton04.m.m1 add command\
    -command {SendToEmacs {(shrink-window 3)}}\
    -label {3}\
    -underline {0}
  .frame0.menubutton04.m.m1 add command\
    -command {SendToEmacs {(shrink-window 4)}}\
    -label {4}\
    -underline {0}
  .frame0.menubutton04.m.m1 add command\
    -command {SendToEmacs {(shrink-window 6)}}\
    -label {6}\
    -underline {0}
  .frame0.menubutton04.m.m1 add command\
    -command {SendToEmacs {(shrink-window 9)}}\
    -label {9}\
    -underline {0}
  .frame0.menubutton04.m.m1 add command\
    -command {SendToEmacs {(shrink-window 13)}}\
    -label {13}\
    -underline {0}
  .frame0.menubutton04.m.m1 add command\
    -command {SendToEmacs {(shrink-window 20)}}\
    -label {20}\
    -underline {0}

  # build widget .frame0.menubutton04.m.m2
  menu .frame0.menubutton04.m.m2
  .frame0.menubutton04.m.m2 configure \
    -activebackground {white}\
    -activeforeground {black}\
    -background {#dcdcdc}\
    -font {-adobe-helvetica-bold-r-normal--12-120-75-75-p-70-iso8859-1}\
    -foreground {black}
  # bindings
  tk_bindForTraversal .frame0.menubutton04.m.m2

  # Menu widget code
  .frame0.menubutton04.m.m2 add command\
    -command {SendToEmacs {(enlarge-window 1)}}\
    -label {1}\
    -underline {0}
  .frame0.menubutton04.m.m2 add command\
    -command {SendToEmacs {(enlarge-window 2)}}\
    -label {2}\
    -underline {0}
  .frame0.menubutton04.m.m2 add command\
    -command {SendToEmacs {(enlarge-window 3)}}\
    -label {3}\
    -underline {0}
  .frame0.menubutton04.m.m2 add command\
    -command {SendToEmacs {(enlarge-window 4)}}\
    -label {4}\
    -underline {0}
  .frame0.menubutton04.m.m2 add command\
    -command {SendToEmacs {(enlarge-window 6)}}\
    -label {6}\
    -underline {0}
  .frame0.menubutton04.m.m2 add command\
    -command {SendToEmacs {(enlarge-window 9)}}\
    -label {9}\
    -underline {0}
  .frame0.menubutton04.m.m2 add command\
    -command {SendToEmacs {(enlarge-window 13)}}\
    -label {13}\
    -underline {0}
  .frame0.menubutton04.m.m2 add command\
    -command {SendToEmacs {(enlarge-window 20)}}\
    -label {20}\
    -underline {0}

  # build widget .frame0.menubutton05
  menubutton .frame0.menubutton05
  .frame0.menubutton05 configure \
    -activebackground {white}\
    -activeforeground {black}\
    -background {#dcdcdc}\
    -font {-adobe-helvetica-bold-r-normal--12-120-75-75-p-70-iso8859-1}\
    -foreground {black}\
    -menu {.frame0.menubutton05.m}\
    -text {Modes}\
    -underline {0}
  # bindings
  tk_bindForTraversal .frame0.menubutton05
  bind .frame0.menubutton05 <B1-Enter> {
              set tk_priv(inMenuButton) %W
              if {([lindex [%W config -state] 4] != "disabled")
                  && ("%m" != "NotifyGrab") && ("%m" != "NotifyUngrab")} {
                if {!$tk_strictMotif} {
                  %W config -state active
                }
                tk_mbPost %W
              }} 
  bind .frame0.menubutton05 <Button-1> {
              tk_mbButtonDown %W} 
  bind .frame0.menubutton05 <Button-2> {
              if {($tk_priv(posted) == "")
                  && ([lindex [%W config -state] 4] != "disabled")} {
                set tk_priv(dragging) %W
                  [lindex [$tk_priv(dragging) config -menu] 4] post %X %Y
              }} 

  eval "tk_menus . [string trim [tk_menus .] \"\{\}\"] .frame0.menubutton05"

  # build widget .frame0.menubutton05.m
  menu .frame0.menubutton05.m
  .frame0.menubutton05.m configure \
    -activebackground {white}\
    -activeforeground {black}\
    -background {#dcdcdc}\
    -font {-adobe-helvetica-bold-r-normal--12-120-75-75-p-70-iso8859-1}\
    -foreground {black}
  # bindings
  tk_bindForTraversal .frame0.menubutton05.m

  # Menu widget code
  .frame0.menubutton05.m add command\
    -command {SendToEmacs (fundamental-mode)}\
    -label {Fundamental}\
    -underline {0}
  .frame0.menubutton05.m add separator
  .frame0.menubutton05.m add command\
    -command {SendToEmacs (c-mode)}\
    -label {C}\
    -underline {0}
  .frame0.menubutton05.m add command\
    -command {SendToEmacs (emacs-lisp-mode)}\
    -label {Emacs lisp}\
    -underline {0}
  .frame0.menubutton05.m add command\
    -command {SendToEmacs (latex-mode)}\
    -label {LaTeX}\
    -underline {0}
  .frame0.menubutton05.m add command\
    -command {SendToEmacs (lisp-interaction-mode)}\
    -label {Lisp interaction}\
    -underline {5}
  .frame0.menubutton05.m add command\
    -command {SendToEmacs (nroff-mode)}\
    -label {Nroff}\
    -underline {0}
  .frame0.menubutton05.m add command\
    -command {SendToEmacs (outline-mode)}\
    -label {Outline}\
    -underline {0}
  .frame0.menubutton05.m add command\
    -command {SendToEmacs (picture-mode)}\
    -label {Picture}\
    -underline {4}
  .frame0.menubutton05.m add command\
    -command {SendToEmacs (tex-mode)}\
    -label {Tex}\
    -underline {2}
  .frame0.menubutton05.m add command\
    -command {SendToEmacs (text-mode)}\
    -label {Text}\
    -underline {0}

  # build widget .frame0.menubutton06
  menubutton .frame0.menubutton06
  .frame0.menubutton06 configure \
    -activebackground {white}\
    -activeforeground {black}\
    -background {#dcdcdc}\
    -font {-adobe-helvetica-bold-r-normal--12-120-75-75-p-70-iso8859-1}\
    -foreground {black}\
    -menu {.EmacsDefault}\
    -text {Current mode}\
    -underline {0}
  # bindings
  tk_bindForTraversal .frame0.menubutton06
  bind .frame0.menubutton06 <B1-Enter> {
            EmacsSetModeMenu %W
            set tk_priv(inMenuButton) %W
            if {([lindex [%W config -state] 4] != "disabled")
                && ("%m" != "NotifyGrab") && ("%m" != "NotifyUngrab")} {
              if {!$tk_strictMotif} {
                %W config -state active
              }
              tk_mbPost %W
            }} 
  bind .frame0.menubutton06 <Button-1> {
            EmacsSetModeMenu %W
            tk_mbButtonDown %W} 
  bind .frame0.menubutton06 <Button-2> {
            EmacsSetModeMenu %W
            if {($tk_priv(posted) == "")
                && ([lindex [%W config -state] 4] != "disabled")} {
              set tk_priv(dragging) %W
                [lindex [$tk_priv(dragging) config -menu] 4] post %X %Y
            }} 

  eval "tk_menus . [string trim [tk_menus .] \"\{\}\"] .frame0.menubutton06"

  # build widget .frame0.menubutton07
  menubutton .frame0.menubutton07
  .frame0.menubutton07 configure \
    -activebackground {white}\
    -activeforeground {black}\
    -background {#dcdcdc}\
    -cursor {arrow}\
    -font {-adobe-helvetica-bold-r-normal--12-120-75-75-p-70-iso8859-1}\
    -foreground {black}\
    -menu {.frame0.menubutton07.m}\
    -text {Configure}\
    -underline {1}
  # bindings
  tk_bindForTraversal .frame0.menubutton07
  bind .frame0.menubutton07 <B1-Enter> {
              set tk_priv(inMenuButton) %W
              if {([lindex [%W config -state] 4] != "disabled")
                  && ("%m" != "NotifyGrab") && ("%m" != "NotifyUngrab")} {
                if {!$tk_strictMotif} {
                  %W config -state active
                }
                tk_mbPost %W
              }} 
  bind .frame0.menubutton07 <Button-1> {
              tk_mbButtonDown %W} 
  bind .frame0.menubutton07 <Button-2> {
              if {($tk_priv(posted) == "")
                  && ([lindex [%W config -state] 4] != "disabled")} {
                set tk_priv(dragging) %W
                  [lindex [$tk_priv(dragging) config -menu] 4] post %X %Y
              }} 

  eval "tk_menus . [string trim [tk_menus .] \"\{\}\"] .frame0.menubutton07"

  # build widget .frame0.menubutton07.m
  menu .frame0.menubutton07.m
  .frame0.menubutton07.m configure \
    -activebackground {white}\
    -activeforeground {black}\
    -background {#dcdcdc}\
    -font {-adobe-helvetica-bold-r-normal--12-120-75-75-p-70-iso8859-1}\
    -foreground {black}
  # bindings
  tk_bindForTraversal .frame0.menubutton07.m

  # Menu widget code
  .frame0.menubutton07.m add cascade\
    -label {Resources}\
    -menu {.frame0.menubutton07.m.m0}\
    -underline {0}
  .frame0.menubutton07.m add cascade\
    -label {Menus}\
    -menu {.frame0.menubutton07.m.m1}\
    -underline {0}
  .frame0.menubutton07.m add cascade\
    -label {Emacs popup binding}\
    -menu {.frame0.menubutton07.m.m2}\
    -underline {0}
  .frame0.menubutton07.m add cascade\
    -label {Other}\
    -menu {.frame0.menubutton07.m.m3}\
    -underline {0}
  .frame0.menubutton07.m add command\
    -command {EmacsSaveOptions}\
    -label {Save}\
    -underline {0}

  # build widget .frame0.menubutton07.m.m0
  menu .frame0.menubutton07.m.m0
  .frame0.menubutton07.m.m0 configure \
    -activebackground {white}\
    -activeforeground {black}\
    -background {#dcdcdc}\
    -font {-adobe-helvetica-bold-r-normal--12-120-75-75-p-70-iso8859-1}\
    -foreground {black}
  # bindings
  tk_bindForTraversal .frame0.menubutton07.m.m0

  # Menu widget code
  .frame0.menubutton07.m.m0 add command\
    -command {global menuConfColorFile
global emacsActBackground
global alertBoxActiveBackground
global colorBoxActiveBackground
global fontBoxActiveBackground
global fsBoxActiveBackground
global menuConfActiveBackground
global readBoxActiveBackground
global textBoxActiveBackground
set emacsResult [ColorBox $menuConfColorFile]
if {"$emacsResult" != ""} {
  set emacsActBackground \"$emacsResult\"
  set alertBoxActiveBackground $emacsResult
  set colorBoxActiveBackground $emacsResult
  set fontBoxActiveBackground $emacsResult
  set fsBoxActiveBackground $emacsResult
  set menuConfActiveBackground $emacsResult
  set readBoxActiveBackground $emacsResult
  set textBoxActiveBackground $emacsResult
  EmacsSetWidgetResources .
}}\
    -label {Active background}
  .frame0.menubutton07.m.m0 add command\
    -command {global menuConfColorFile
global emacsActForeground
global alertBoxActiveForeground
global colorBoxActiveForeground
global fontBoxActiveForeground
global fsBoxActiveForeground
global menuConfActiveForeground
global readBoxActiveForeground
global textBoxActiveForeground
set emacsResult [ColorBox $menuConfColorFile]
if {"$emacsResult" != ""} {
  set emacsActForeground \"$emacsResult\"
  set alertBoxActiveForeground $emacsResult
  set colorBoxActiveForeground $emacsResult
  set fontBoxActiveForeground $emacsResult
  set fsBoxActiveForeground $emacsResult
  set menuConfActiveForeground $emacsResult
  set readBoxActiveForeground $emacsResult
  set textBoxActiveForeground $emacsResult
  EmacsSetWidgetResources .
}}\
    -label {Active foreground}
  .frame0.menubutton07.m.m0 add command\
    -command {global menuConfColorFile
global emacsBackground
global alertBoxBackground
global colorBoxBackground
global fontBoxBackground
global fsBoxBackground
global menuConfBackground
global readBoxBackground
global textBoxBackground
global alertBoxScrollBackground
global colorBoxScrollBackground
global fontBoxScrollBackground
global fsBoxScrollBackground
global menuConfScrollBackground
global readBoxScrollBackground
global textBoxScrollBackground
set emacsResult [ColorBox $menuConfColorFile]
if {"$emacsResult" != ""} {
  set emacsBackground \"$emacsResult\"
  set alertBoxBackground $emacsResult
  set colorBoxBackground $emacsResult
  set fontBoxBackground $emacsResult
  set fsBoxBackground $emacsResult
  set menuConfBackground $emacsResult
  set readBoxBackground $emacsResult
  set textBoxBackground $emacsResult
  set alertBoxScrollBackground $emacsResult
  set colorBoxScrollBackground $emacsResult
  set fontBoxScrollBackground $emacsResult
  set fsBoxScrollBackground $emacsResult
  set menuConfScrollBackground $emacsResult
  set readBoxScrollBackground $emacsResult
  set textBoxScrollBackground $emacsResult
  EmacsSetWidgetResources .
}}\
    -label {Background}
  .frame0.menubutton07.m.m0 add command\
    -command {global menuConfColorFile
global emacsForeground
global alertBoxForeground
global colorBoxForeground
global fontBoxForeground
global fsBoxForeground
global menuConfForeground
global readBoxForeground
global textBoxForeground
set emacsResult [ColorBox $menuConfColorFile]
if {"$emacsResult" != ""} {
  set emacsForeground \"$emacsResult\"
  set alertBoxForeground $emacsResult
  set colorBoxForeground $emacsResult
  set fontBoxForeground $emacsResult
  set fsBoxForeground $emacsResult
  set menuConfForeground $emacsResult
  set readBoxForeground $emacsResult
  set textBoxForeground $emacsResult
  EmacsSetWidgetResources .
}}\
    -label {Foreground}
  .frame0.menubutton07.m.m0 add command\
    -command {global menuConfFontFile
global emacsFont
global alertBoxFont
global colorBoxFont
global fontBoxFont
global fsBoxFont
global menuConfFont
global readBoxFont
global textBoxFont
set emacsResult [FontBox $menuConfFontFile]
if {"$emacsResult" != ""} {
  set emacsFont \"$emacsResult\"
  set alertBoxFont $emacsResult
  set colorBoxFont $emacsResult
  set fontBoxFont $emacsResult
  set fsBoxFont $emacsResult
  set menuConfFont $emacsResult
  set readBoxFont $emacsResult
  set textBoxFont $emacsResult
  EmacsSetWidgetResources .
}}\
    -label {Font}
  .frame0.menubutton07.m.m0 add command\
    -command {global menuConfFontFile
global emacsEmacsFont
set emacsResult [FontBox $menuConfFontFile "Emacs font:"]
if {"$emacsResult" != ""} {
  set emacsEmacsFont \"$emacsResult\"
  EmacsSetWidgetResources .
}}\
    -label {Emacs font}
  .frame0.menubutton07.m.m0 add command\
    -command {global menuConfColorFile
global emacsEmacsCursor
set emacsResult [ColorBox $menuConfColorFile]
if {"$emacsResult" != ""} {
  set emacsEmacsCursor \"$emacsResult\"
  EmacsSetWidgetResources .
}}\
    -label {Emacs insert background}
  .frame0.menubutton07.m.m0 add command\
    -command {global menuConfColorFile
global emacsScrollActForeground
global alertBoxScrollActiveForeground
global colorBoxScrollActiveForeground
global fontBoxScrollActiveForeground
global fsBoxScrollActiveForeground
global menuConfScrollActiveForeground
global readBoxScrollActiveForeground
global textBoxScrollActiveForeground
set emacsResult [ColorBox $menuConfColorFile]
if {"$emacsResult" != ""} {
  set emacsScrollActForeground \"$emacsResult\"
  set alertBoxScrollActiveForeground $emacsResult
  set colorBoxScrollActiveForeground $emacsResult
  set fontBoxScrollActiveForeground $emacsResult
  set fsBoxScrollActiveForeground $emacsResult
  set menuConfScrollActiveForeground $emacsResult
  set readBoxScrollActiveForeground $emacsResult
  set textBoxScrollActiveForeground $emacsResult
  EmacsSetWidgetResources .
}}\
    -label {Scrollbar active foreground}
  .frame0.menubutton07.m.m0 add command\
    -command {global menuConfColorFile
global emacsScrollForeground
global alertBoxScrollForeground
global colorBoxScrollForeground
global fontBoxScrollForeground
global fsBoxScrollForeground
global menuConfScrollForeground
global readBoxScrollForeground
global textBoxScrollForeground
set emacsResult [ColorBox $menuConfColorFile]
if {"$emacsResult" != ""} {
  set emacsScrollForeground \"$emacsResult\"
  set alertBoxScrollForeground $emacsResult
  set colorBoxScrollForeground $emacsResult
  set fontBoxScrollForeground $emacsResult
  set fsBoxScrollForeground $emacsResult
  set menuConfScrollForeground $emacsResult
  set readBoxScrollForeground $emacsResult
  set textBoxScrollForeground $emacsResult
  EmacsSetWidgetResources .
}}\
    -label {Scrollbar foreground}

  # build widget .frame0.menubutton07.m.m1
  menu .frame0.menubutton07.m.m1
  .frame0.menubutton07.m.m1 configure \
    -activebackground {white}\
    -activeforeground {black}\
    -background {#dcdcdc}\
    -font {-adobe-helvetica-bold-r-normal--12-120-75-75-p-70-iso8859-1}\
    -foreground {black}
  # bindings
  tk_bindForTraversal .frame0.menubutton07.m.m1

  # Menu widget code
  .frame0.menubutton07.m.m1 add command\
    -command {MenuConf .frame0}\
    -label {Menubar}
  .frame0.menubutton07.m.m1 add command\
    -command {MenuConf .}\
    -label {Popups}
  .frame0.menubutton07.m.m1 add command\
    -command {MenuConf}\
    -label {All}

  # build widget .frame0.menubutton07.m.m2
  menu .frame0.menubutton07.m.m2
  .frame0.menubutton07.m.m2 configure \
    -activebackground {white}\
    -activeforeground {black}\
    -background {#dcdcdc}\
    -font {-adobe-helvetica-bold-r-normal--12-120-75-75-p-70-iso8859-1}\
    -foreground {black}
  # bindings
  tk_bindForTraversal .frame0.menubutton07.m.m2

  # Menu widget code
  .frame0.menubutton07.m.m2 add radiobutton\
    -command {global bindPopupDown
global bindPopupRelease
global bindPopupMove
set bindPopupDown {<Mod1-Button-3>}
set bindPopupRelease {<Any-ButtonRelease-3>}
set bindPopupMove {<B3-Mod1-Motion>}
EmacsSetBinding}\
    -label {<Mod1-Button3>}\
    -value {<Mod1-Button3>}\
    -variable {emacsPopupBind}
  .frame0.menubutton07.m.m2 add radiobutton\
    -command {global bindPopupDown
global bindPopupRelease
global bindPopupMove
set bindPopupDown {<Mod1-Button-2>}
set bindPopupRelease {<Any-ButtonRelease-2>}
set bindPopupMove {<B2-Mod1-Motion>}
EmacsSetBinding}\
    -label {<Mod1-Button2>}\
    -value {<Mod1-Button2>}\
    -variable {emacsPopupBind}
  .frame0.menubutton07.m.m2 add radiobutton\
    -command {global bindPopupDown
global bindPopupRelease
global bindPopupMove
set bindPopupDown {<Mod1-Button-1>}
set bindPopupRelease {<Any-ButtonRelease-1>}
set bindPopupMove {<B1-Mod1-Motion>}
EmacsSetBinding}\
    -label {<Mod1-Button1>}\
    -value {<Mod1-Button1>}\
    -variable {emacsPopupBind}
  .frame0.menubutton07.m.m2 add radiobutton\
    -command {global bindPopupDown
global bindPopupRelease
global bindPopupMove
set bindPopupDown {<Shift-Button-3>}
set bindPopupRelease {<Any-ButtonRelease-3>}
set bindPopupMove {<B3-Shift-Motion>}
EmacsSetBinding}\
    -label {<Shift-Button3>}\
    -value {<Shift-Button3>}\
    -variable {emacsPopupBind}
  .frame0.menubutton07.m.m2 add radiobutton\
    -command {global bindPopupDown
global bindPopupRelease
global bindPopupMove
set bindPopupDown {<Control-Button-3>}
set bindPopupRelease {<Any-ButtonRelease-3>}
set bindPopupMove {<B3-Control-Motion>}
EmacsSetBinding}\
    -label {<Control-Button3>}\
    -value {<Control-Button3>}\
    -variable {emacsPopupBind}
  .frame0.menubutton07.m.m2 add radiobutton\
    -command {global bindPopupDown
global bindPopupRelease
global bindPopupMove
set bindPopupDown {<Shift-Control-Button-3>}
set bindPopupRelease {<Any-ButtonRelease-3>}
set bindPopupMove {<B3-Shift-Control-Motion>}
EmacsSetBinding}\
    -label {<Shift-Control-Button3>}\
    -value {<Shift-Control-Button3>}\
    -variable {emacsPopupBind}

  # build widget .frame0.menubutton07.m.m3
  menu .frame0.menubutton07.m.m3
  .frame0.menubutton07.m.m3 configure \
    -activebackground {white}\
    -activeforeground {black}\
    -background {#dcdcdc}\
    -font {-adobe-helvetica-bold-r-normal--12-120-75-75-p-70-iso8859-1}\
    -foreground {black}
  # bindings
  tk_bindForTraversal .frame0.menubutton07.m.m3

  # Menu widget code
  .frame0.menubutton07.m.m3 add checkbutton\
    -command {global emacsDebug; .frame.text debug $emacsDebug}\
    -label {Debugging}\
    -variable {emacsDebug}\
    -underline {0}
  .frame0.menubutton07.m.m3 add checkbutton\
    -command {global emacsUseAdvise
.frame.text config -useadvise $emacsUseAdvise}\
    -label {Update scrollbars from emacs}\
    -offvalue {false}\
    -onvalue {true}\
    -variable {emacsUseAdvise}\
    -underline {0}
  .frame0.menubutton07.m.m3 add cascade\
    -label {Scrollbar poll interval}\
    -menu {.frame0.menubutton07.m.m3.m}\
    -underline {0}

  # build widget .frame0.menubutton07.m.m3.m
  menu .frame0.menubutton07.m.m3.m
  .frame0.menubutton07.m.m3.m configure \
    -activebackground {white}\
    -activeforeground {black}\
    -background {#dcdcdc}\
    -font {-adobe-helvetica-bold-r-normal--12-120-75-75-p-70-iso8859-1}\
    -foreground {black}
  # bindings
  tk_bindForTraversal .frame0.menubutton07.m.m3.m

  # Menu widget code
  .frame0.menubutton07.m.m3.m add radiobutton\
    -command {global emacsPollInterval
.frame.text config -pollinterval $emacsPollInterval}\
    -label {0 seconds (off)}\
    -value {0}\
    -variable {emacsPollInterval}
  .frame0.menubutton07.m.m3.m add radiobutton\
    -command {global emacsPollInterval
.frame.text config -pollinterval $emacsPollInterval}\
    -label {5 seconds}\
    -value {5}\
    -variable {emacsPollInterval}
  .frame0.menubutton07.m.m3.m add radiobutton\
    -command {global emacsPollInterval
.frame.text config -pollinterval $emacsPollInterval}\
    -label {10 seconds}\
    -value {10}\
    -variable {emacsPollInterval}
  .frame0.menubutton07.m.m3.m add radiobutton\
    -command {global emacsPollInterval
.frame.text config -pollinterval $emacsPollInterval}\
    -label {30 seconds}\
    -value {30}\
    -variable {emacsPollInterval}
  .frame0.menubutton07.m.m3.m add radiobutton\
    -command {global emacsPollInterval
.frame.text config -pollinterval $emacsPollInterval}\
    -label {60 seconds}\
    -value {60}\
    -variable {emacsPollInterval}
  .frame0.menubutton07.m.m3.m add radiobutton\
    -command {global emacsPollInterval
.frame.text config -pollinterval $emacsPollInterval}\
    -label {120 seconds}\
    -value {120}\
    -variable {emacsPollInterval}

  # build widget .frame0.menubutton08
  menubutton .frame0.menubutton08
  .frame0.menubutton08 configure \
    -activebackground {white}\
    -activeforeground {black}\
    -background {#dcdcdc}\
    -font {-adobe-helvetica-bold-r-normal--12-120-75-75-p-70-iso8859-1}\
    -foreground {black}\
    -menu {.frame0.menubutton08.m}\
    -text {}\
    -underline {0}
  # bindings
  tk_bindForTraversal .frame0.menubutton08
  bind .frame0.menubutton08 <B1-Enter> {
          set tk_priv(inMenuButton) %W
          if {([lindex [%W config -state] 4] != "disabled")
              && ("%m" != "NotifyGrab") && ("%m" != "NotifyUngrab")} {
            if {!$tk_strictMotif} {
              %W config -state active
            }
            tk_mbPost %W
          }} 
  bind .frame0.menubutton08 <Button-1> {
          tk_mbButtonDown %W} 
  bind .frame0.menubutton08 <Button-2> {
          if {($tk_priv(posted) == "")
              && ([lindex [%W config -state] 4] != "disabled")} {
            set tk_priv(dragging) %W
              [lindex [$tk_priv(dragging) config -menu] 4] post %X %Y
          }} 

  eval "tk_menus . [string trim [tk_menus .] \"\{\}\"] .frame0.menubutton08"

  # build widget .frame0.menubutton08.m
  menu .frame0.menubutton08.m
  .frame0.menubutton08.m configure \
    -activebackground {white}\
    -activeforeground {black}\
    -background {#dcdcdc}\
    -font {-adobe-helvetica-bold-r-normal--12-120-75-75-p-70-iso8859-1}\
    -foreground {black}
  # bindings
  tk_bindForTraversal .frame0.menubutton08.m


  # build widget .frame0.menubutton09
  menubutton .frame0.menubutton09
  .frame0.menubutton09 configure \
    -activebackground {white}\
    -activeforeground {black}\
    -background {#dcdcdc}\
    -font {-adobe-helvetica-bold-r-normal--12-120-75-75-p-70-iso8859-1}\
    -foreground {black}\
    -menu {.frame0.menubutton09.m}\
    -text {}\
    -underline {0}
  # bindings
  tk_bindForTraversal .frame0.menubutton09
  bind .frame0.menubutton09 <B1-Enter> {
          set tk_priv(inMenuButton) %W
          if {([lindex [%W config -state] 4] != "disabled")
              && ("%m" != "NotifyGrab") && ("%m" != "NotifyUngrab")} {
            if {!$tk_strictMotif} {
              %W config -state active
            }
            tk_mbPost %W
          }} 
  bind .frame0.menubutton09 <Button-1> {
          tk_mbButtonDown %W} 
  bind .frame0.menubutton09 <Button-2> {
          if {($tk_priv(posted) == "")
              && ([lindex [%W config -state] 4] != "disabled")} {
            set tk_priv(dragging) %W
              [lindex [$tk_priv(dragging) config -menu] 4] post %X %Y
          }} 

  eval "tk_menus . [string trim [tk_menus .] \"\{\}\"] .frame0.menubutton09"

  # build widget .frame0.menubutton09.m
  menu .frame0.menubutton09.m
  .frame0.menubutton09.m configure \
    -activebackground {white}\
    -activeforeground {black}\
    -background {#dcdcdc}\
    -font {-adobe-helvetica-bold-r-normal--12-120-75-75-p-70-iso8859-1}\
    -foreground {black}
  # bindings
  tk_bindForTraversal .frame0.menubutton09.m


  # build widget .frame0.menubutton10
  menubutton .frame0.menubutton10
  .frame0.menubutton10 configure \
    -activebackground {white}\
    -activeforeground {black}\
    -background {#dcdcdc}\
    -font {-adobe-helvetica-bold-r-normal--12-120-75-75-p-70-iso8859-1}\
    -foreground {black}\
    -menu {.frame0.menubutton10.m}\
    -text {}\
    -underline {0}
  # bindings
  tk_bindForTraversal .frame0.menubutton10
  bind .frame0.menubutton10 <B1-Enter> {
          set tk_priv(inMenuButton) %W
          if {([lindex [%W config -state] 4] != "disabled")
              && ("%m" != "NotifyGrab") && ("%m" != "NotifyUngrab")} {
            if {!$tk_strictMotif} {
              %W config -state active
            }
            tk_mbPost %W
          }} 
  bind .frame0.menubutton10 <Button-1> {
          tk_mbButtonDown %W} 
  bind .frame0.menubutton10 <Button-2> {
          if {($tk_priv(posted) == "")
              && ([lindex [%W config -state] 4] != "disabled")} {
            set tk_priv(dragging) %W
              [lindex [$tk_priv(dragging) config -menu] 4] post %X %Y
          }} 

  eval "tk_menus . [string trim [tk_menus .] \"\{\}\"] .frame0.menubutton10"

  # build widget .frame0.menubutton10.m
  menu .frame0.menubutton10.m
  .frame0.menubutton10.m configure \
    -activebackground {white}\
    -activeforeground {black}\
    -background {#dcdcdc}\
    -font {-adobe-helvetica-bold-r-normal--12-120-75-75-p-70-iso8859-1}\
    -foreground {black}
  # bindings
  tk_bindForTraversal .frame0.menubutton10.m


  # build widget .frame0.menubutton11
  menubutton .frame0.menubutton11
  .frame0.menubutton11 configure \
    -activebackground {white}\
    -activeforeground {black}\
    -background {#dcdcdc}\
    -font {-adobe-helvetica-bold-r-normal--12-120-75-75-p-70-iso8859-1}\
    -foreground {black}\
    -menu {.frame0.menubutton11.m}\
    -text {}\
    -underline {0}
  # bindings
  tk_bindForTraversal .frame0.menubutton11
  bind .frame0.menubutton11 <B1-Enter> {
          set tk_priv(inMenuButton) %W
          if {([lindex [%W config -state] 4] != "disabled")
              && ("%m" != "NotifyGrab") && ("%m" != "NotifyUngrab")} {
            if {!$tk_strictMotif} {
              %W config -state active
            }
            tk_mbPost %W
          }} 
  bind .frame0.menubutton11 <Button-1> {
          tk_mbButtonDown %W} 
  bind .frame0.menubutton11 <Button-2> {
          if {($tk_priv(posted) == "")
              && ([lindex [%W config -state] 4] != "disabled")} {
            set tk_priv(dragging) %W
              [lindex [$tk_priv(dragging) config -menu] 4] post %X %Y
          }} 

  eval "tk_menus . [string trim [tk_menus .] \"\{\}\"] .frame0.menubutton11"

  # build widget .frame0.menubutton11.m
  menu .frame0.menubutton11.m
  .frame0.menubutton11.m configure \
    -activebackground {white}\
    -activeforeground {black}\
    -background {#dcdcdc}\
    -font {-adobe-helvetica-bold-r-normal--12-120-75-75-p-70-iso8859-1}\
    -foreground {black}
  # bindings
  tk_bindForTraversal .frame0.menubutton11.m


  # build widget .frame0.menubutton12
  menubutton .frame0.menubutton12
  .frame0.menubutton12 configure \
    -activebackground {white}\
    -activeforeground {black}\
    -background {#dcdcdc}\
    -font {-adobe-helvetica-bold-r-normal--12-120-75-75-p-70-iso8859-1}\
    -foreground {black}\
    -menu {.frame0.menubutton12.m}\
    -text {}\
    -underline {0}
  # bindings
  tk_bindForTraversal .frame0.menubutton12
  bind .frame0.menubutton12 <B1-Enter> {
          set tk_priv(inMenuButton) %W
          if {([lindex [%W config -state] 4] != "disabled")
              && ("%m" != "NotifyGrab") && ("%m" != "NotifyUngrab")} {
            if {!$tk_strictMotif} {
              %W config -state active
            }
            tk_mbPost %W
          }} 
  bind .frame0.menubutton12 <Button-1> {
          tk_mbButtonDown %W} 
  bind .frame0.menubutton12 <Button-2> {
          if {($tk_priv(posted) == "")
              && ([lindex [%W config -state] 4] != "disabled")} {
            set tk_priv(dragging) %W
              [lindex [$tk_priv(dragging) config -menu] 4] post %X %Y
          }} 

  eval "tk_menus . [string trim [tk_menus .] \"\{\}\"] .frame0.menubutton12"

  # build widget .frame0.menubutton12.m
  menu .frame0.menubutton12.m
  .frame0.menubutton12.m configure \
    -activebackground {white}\
    -activeforeground {black}\
    -background {#dcdcdc}\
    -font {-adobe-helvetica-bold-r-normal--12-120-75-75-p-70-iso8859-1}\
    -foreground {black}
  # bindings
  tk_bindForTraversal .frame0.menubutton12.m


  # build widget .frame0.menubutton13
  menubutton .frame0.menubutton13
  .frame0.menubutton13 configure \
    -activebackground {white}\
    -activeforeground {black}\
    -background {#dcdcdc}\
    -font {-adobe-helvetica-bold-r-normal--12-120-75-75-p-70-iso8859-1}\
    -foreground {black}\
    -menu {.frame0.menubutton13.m}\
    -text {}\
    -underline {0}
  # bindings
  tk_bindForTraversal .frame0.menubutton13
  bind .frame0.menubutton13 <B1-Enter> {
              set tk_priv(inMenuButton) %W
              if {([lindex [%W config -state] 4] != "disabled")
                  && ("%m" != "NotifyGrab") && ("%m" != "NotifyUngrab")} {
                if {!$tk_strictMotif} {
                  %W config -state active
                }
                tk_mbPost %W
              }} 
  bind .frame0.menubutton13 <Button-1> {
              tk_mbButtonDown %W} 
  bind .frame0.menubutton13 <Button-2> {
              if {($tk_priv(posted) == "")
                  && ([lindex [%W config -state] 4] != "disabled")} {
                set tk_priv(dragging) %W
                  [lindex [$tk_priv(dragging) config -menu] 4] post %X %Y
              }} 

  eval "tk_menus . [string trim [tk_menus .] \"\{\}\"] .frame0.menubutton13"

  # build widget .frame0.menubutton13.m
  menu .frame0.menubutton13.m
  .frame0.menubutton13.m configure \
    -activebackground {white}\
    -activeforeground {black}\
    -background {#dcdcdc}\
    -font {-adobe-helvetica-bold-r-normal--12-120-75-75-p-70-iso8859-1}\
    -foreground {black}
  # bindings
  tk_bindForTraversal .frame0.menubutton13.m


  # build widget .frame0.menubutton14
  menubutton .frame0.menubutton14
  .frame0.menubutton14 configure \
    -activebackground {white}\
    -activeforeground {black}\
    -background {#dcdcdc}\
    -font {-adobe-helvetica-bold-r-normal--12-120-75-75-p-70-iso8859-1}\
    -foreground {black}\
    -menu {.frame0.menubutton14.m}\
    -text {Help}\
    -underline {0}
  # bindings
  tk_bindForTraversal .frame0.menubutton14
  bind .frame0.menubutton14 <B1-Enter> {
              set tk_priv(inMenuButton) %W
              if {([lindex [%W config -state] 4] != "disabled")
                  && ("%m" != "NotifyGrab") && ("%m" != "NotifyUngrab")} {
                if {!$tk_strictMotif} {
                  %W config -state active
                }
                tk_mbPost %W
              }} 
  bind .frame0.menubutton14 <Button-1> {
              tk_mbButtonDown %W} 
  bind .frame0.menubutton14 <Button-2> {
              if {($tk_priv(posted) == "")
                  && ([lindex [%W config -state] 4] != "disabled")} {
                set tk_priv(dragging) %W
                  [lindex [$tk_priv(dragging) config -menu] 4] post %X %Y
              }} 

  eval "tk_menus . [string trim [tk_menus .] \"\{\}\"] .frame0.menubutton14"

  # build widget .frame0.menubutton14.m
  menu .frame0.menubutton14.m
  .frame0.menubutton14.m configure \
    -activebackground {white}\
    -activeforeground {black}\
    -background {#dcdcdc}\
    -font {-adobe-helvetica-bold-r-normal--12-120-75-75-p-70-iso8859-1}\
    -foreground {black}
  # bindings
  tk_bindForTraversal .frame0.menubutton14.m

  # Menu widget code
  .frame0.menubutton14.m add cascade\
    -accelerator {C-h i d}\
    -command {SendToEmacs {(info)}
SendToEmacs {(Info-directory)}
}\
    -label {Info directory}\
    -menu {.frame0.menubutton14.m.m}\
    -underline {0}
  .frame0.menubutton14.m add command\
    -accelerator {C-h i 2}\
    -command {SendToEmacs {(info)}
SendToEmacs {(Info-directory)}
SendToEmacs {(Info-menu "Emacs")}
}\
    -label {Info Emacs}\
    -underline {5}
  .frame0.menubutton14.m add separator
  .frame0.menubutton14.m add command\
    -accelerator {C-h t}\
    -command {SendToEmacs {(help-with-tutorial)}}\
    -label {Tutorial}\
    -underline {0}
  .frame0.menubutton14.m add separator
  .frame0.menubutton14.m add command\
    -accelerator {C-h a}\
    -command {SendToEmacs {(call-interactively 'command-apropos)}}\
    -label {Apropos command}\
    -underline {0}
  .frame0.menubutton14.m add command\
    -accelerator {C-h c}\
    -command {SendToEmacs {(call-interactively 'describe-key-briefly)}}\
    -label {Describe key briefly}\
    -underline {3}
  .frame0.menubutton14.m add command\
    -accelerator {C-h k}\
    -command {SendToEmacs {(call-interactively 'describe-key)}}\
    -label {Describe key}\
    -underline {9}
  .frame0.menubutton14.m add command\
    -accelerator {C-h w}\
    -command {SendToEmacs {(call-interactively 'where-is)}}\
    -label {Where is command}\
    -underline {0}
  .frame0.menubutton14.m add command\
    -accelerator {C-h m}\
    -command {SendToEmacs {(call-interactively 'describe-mode)}}\
    -label {Describe mode}\
    -underline {9}
  .frame0.menubutton14.m add command\
    -accelerator {C-h v}\
    -command {SendToEmacs {(call-interactively 'describe-variable)}}\
    -label {Describe variable}\
    -underline {9}
  .frame0.menubutton14.m add separator
  .frame0.menubutton14.m add command\
    -accelerator {C-h C-c}\
    -command {SendToEmacs {(call-interactively 'describe-copying)}}\
    -label {License}\
    -underline {0}

  # build widget .frame0.menubutton14.m.m
  menu .frame0.menubutton14.m.m
  .frame0.menubutton14.m.m configure \
    -activebackground {white}\
    -activeforeground {black}\
    -background {#dcdcdc}\
    -font {-adobe-helvetica-bold-r-normal--12-120-75-75-p-70-iso8859-1}\
    -foreground {black}
  # bindings
  tk_bindForTraversal .frame0.menubutton14.m.m

  # Menu widget code
  .frame0.menubutton14.m.m add command\
    -command {SendToEmacs {(info)}}\
    -label {Previous entry}\
    -underline {0}
  .frame0.menubutton14.m.m add separator
  .frame0.menubutton14.m.m add command\
    -command {SendToEmacs {(info)}
SendToEmacs {(Info-directory)}
SendToEmacs {(Info-menu "GCC")}}\
    -label {GCC}\
    -underline {1}
  .frame0.menubutton14.m.m add command\
    -command {SendToEmacs {(info)}
SendToEmacs {(Info-directory)}
SendToEmacs {(Info-menu "GDB")}}\
    -label {GDB}\
    -underline {1}

  # pack widget .frame0
  pack append .frame0\
    .frame0.menubutton00   {left frame center} \
    .frame0.menubutton01   {left frame center} \
    .frame0.menubutton02   {left frame center} \
    .frame0.menubutton03   {left frame center} \
    .frame0.menubutton04   {left frame center} \
    .frame0.menubutton05   {left frame center} \
    .frame0.menubutton06   {left frame center} \
    .frame0.menubutton07   {left frame center} \
    .frame0.button01   {left frame center} \
    .frame0.menubutton14   {right frame center} 

  # bindings
  tk_bindForTraversal .


  # pack widget .
  pack append .\
    .frame0   {top frame center fillx} \
    .frame   {top frame center expand fill} 

  if {[string length [info commands .XFEdit]] > 0} {
    XFEditSetShowWindows
    XFMiscBindWidgetTree .frame0
  }
}


# Procedure: AlertBox
proc AlertBox { {alertBoxMessage "Alert message"} {alertBoxGeometry "350x150"} args} {
  # Description: show alert box
  # Arguments: alertBoxMessage - the text to display
  #            alertBoxGeometry - the geometry for the window
  #            args - labels of buttons
  # Returns: The number of the selected button
  # Notes: there exists also functions called:
  #          AlertBoxFile - to open and read a file automatically
  #          AlertBoxFd - to read from an already opened filedescriptor
  #
  # global alertBoxActiveBackground - active background color
  # global alertBoxActiveForeground - active foreground color
  # global alertBoxAnchor - anchor for message box
  # global alertBoxBackground - background color
  # global alertBoxFont - message font
  # global alertBoxForeground - foreground color
  # global alertBoxJustify - justify for message box

  global alertBoxButton

  # show alert box
  if {[llength $args] > 0} {
    eval AlertBoxInternal "\{$alertBoxMessage\}" "\{$alertBoxGeometry\}" $args
  } {
    AlertBoxInternal $alertBoxMessage $alertBoxGeometry
  }

  # wait for the box to be destroyed
  grab .AlertBox
  tkwait window .AlertBox

  return $alertBoxButton
}


# Procedure: AlertBoxInternal
proc AlertBoxInternal { alertBoxMessage alertBoxGeometry args} {
  global alertBoxActiveBackground
  global alertBoxActiveForeground
  global alertBoxAnchor
  global alertBoxBackground
  global alertBoxFont
  global alertBoxForeground
  global alertBoxJustify
  global alertBoxButton

  if {"[info commands XFDestroy]" != ""} {
    catch {XFDestroy .AlertBox}
  } {
    catch {destroy .AlertBox}
  }
  toplevel .AlertBox     -background "$alertBoxBackground"     -borderwidth 0
  if {[catch "wm geometry .AlertBox $alertBoxGeometry"]} {
    wm geometry .AlertBox 350x150
  }
  wm title .AlertBox {Alert box}
  wm maxsize .AlertBox 1000 1000
  wm minsize .AlertBox 100 100
  wm positionfrom .AlertBox program
  wm sizefrom .AlertBox user

  message .AlertBox.message1     -background "$alertBoxBackground"     -foreground "$alertBoxForeground"     -font "$alertBoxFont"     -anchor "$alertBoxAnchor"     -justify "$alertBoxJustify"     -relief raised     -text "$alertBoxMessage"
  set xfTmpWidth     [string range $alertBoxGeometry 0 [expr [string first x $alertBoxGeometry]-1]]
  if {"$xfTmpWidth" != ""} {
    # set message size
    catch ".AlertBox.message1 configure       -width [expr $xfTmpWidth-10]"
  } {
    .AlertBox.message1 configure       -aspect 1500
  }

  frame .AlertBox.frame1     -background "$alertBoxBackground"     -borderwidth 0     -relief raised

  set alertCounter 0
  set buttonNum [llength $args]

  if {$buttonNum > 0} {
    while {$alertCounter < $buttonNum} {
      button .AlertBox.frame1.button$alertCounter         -activebackground "$alertBoxActiveBackground"         -activeforeground "$alertBoxActiveForeground"         -background "$alertBoxBackground"         -foreground "$alertBoxForeground"         -font "$alertBoxFont"         -text "[lindex $args $alertCounter]"         -command "
          global alertBoxButton
          set alertBoxButton $alertCounter
          if {\"\[info commands XFDestroy\]\" != \"\"} {
            catch {XFDestroy .AlertBox}
          } {
            catch {destroy .AlertBox}
          }"

      pack append .AlertBox.frame1                   .AlertBox.frame1.button$alertCounter {left fillx expand}

      incr alertCounter
    }
  } {
    button .AlertBox.frame1.button0       -activebackground "$alertBoxActiveBackground"       -activeforeground "$alertBoxActiveForeground"       -background "$alertBoxBackground"       -foreground "$alertBoxForeground"       -font "$alertBoxFont"       -text "OK"       -command "
        global alertBoxButton
        set alertBoxButton 0
        if {\"\[info commands XFDestroy\]\" != \"\"} {
          catch {XFDestroy .AlertBox}
        } {
          catch {destroy .AlertBox}
        }"

    pack append .AlertBox.frame1                 .AlertBox.frame1.button0 {left fillx expand}
  }

  # packing
  pack append .AlertBox               .AlertBox.frame1 {bottom fill}               .AlertBox.message1 {top fill expand}
}


# Procedure: ColorBox
proc ColorBox { {colorFileColor "/usr/local/lib/xf/lib/Colors"} {colorMessage "Color:"}} {
  # Description: select a color
  # Arguments: colorFileColor - the color file with all colornames
  #            colorMessage - a message to display
  # Returns: colorname
  # 
  # global colorBoxActiveBackground - active background color
  # global colorBoxActiveForeground - active foreground color
  # global colorBoxBackground - background color
  # global colorBoxFont - text font
  # global colorBoxForeground - foreground color
  # global colorBoxScrollActiveForeground - scrollbar active background color
  # global colorBoxScrollBackground - scrollbar background color
  # global colorBoxScrollForeground - scrollbar foreground color

  global colorBoxName
  global colorBoxActiveBackground
  global colorBoxActiveForeground
  global colorBoxBackground
  global colorBoxFont
  global colorBoxForeground
  global colorBoxScrollActiveForeground
  global colorBoxScrollBackground
  global colorBoxScrollForeground

  set colorBoxName ""

  # get color file name
  if {!([file exists $colorFileColor] &&
        [file readable $colorFileColor])} {
    set colorFileColor ""
  }
  if {"$colorFileColor" == ""} {
    global env
    if {[info exists env(XF_COLOR_FILE)]} {
      if {[file exists $env(XF_COLOR_FILE)] &&
          [file readable $env(XF_COLOR_FILE)]} {
        set colorFileColor $env(XF_COLOR_FILE)
      }
    }
  }

  # build widget structure
  if {"[info commands XFDestroy]" != ""} {
    catch {XFDestroy .ColorBox}
  } {
    catch {destroy .ColorBox}
  }
  toplevel .ColorBox     -background "$colorBoxBackground"     -borderwidth 0
  wm geometry .ColorBox 400x477
  wm title .ColorBox {Color box}
  wm maxsize .ColorBox 1000 1000
  wm minsize .ColorBox 100 100
  wm positionfrom .ColorBox program
  wm sizefrom .ColorBox user

  frame .ColorBox.frame1     -background "$colorBoxBackground"     -borderwidth 0     -relief raised
 
  button .ColorBox.frame1.ok     -activebackground "$colorBoxActiveBackground"     -activeforeground "$colorBoxActiveForeground"     -background "$colorBoxBackground"     -foreground "$colorBoxForeground"     -font "$colorBoxFont"     -text "OK"     -command "
      global colorBoxName
      set colorBoxName \[.ColorBox.current.current get\]
      if {\"\[info commands XFDestroy\]\" != \"\"} {
        catch {XFDestroy .ColorBox}
      } {
        catch {destroy .ColorBox}
      }"

  button .ColorBox.frame1.cancel     -activebackground "$colorBoxActiveBackground"     -activeforeground "$colorBoxActiveForeground"     -background "$colorBoxBackground"     -foreground "$colorBoxForeground"     -font "$colorBoxFont"     -text "Cancel"     -command "
      global colorBoxName
      set colorBoxName {}
      if {\"\[info commands XFDestroy\]\" != \"\"} {
        catch {XFDestroy .ColorBox}
      } {
        catch {destroy .ColorBox}
      }"

  scale .ColorBox.red     -activeforeground "$colorBoxScrollActiveForeground"     -background red     -foreground "$colorBoxForeground"     -from 0     -label "Red"     -orient horizontal     -relief raised     -sliderlength 15     -to 255     -width 8     -command "ColorBoxSetRGBColor $colorMessage"

   scale .ColorBox.green     -activeforeground "$colorBoxScrollActiveForeground"     -background green     -foreground "$colorBoxForeground"     -from 0     -label "Green"     -orient horizontal     -relief raised     -sliderlength 15     -to 255     -width 8     -command "ColorBoxSetRGBColor $colorMessage"

  scale .ColorBox.blue     -activeforeground "$colorBoxScrollActiveForeground"     -background blue     -foreground "$colorBoxForeground"     -from 0     -label "Blue"     -orient horizontal     -relief raised     -sliderlength 15     -to 255     -width 8     -command "ColorBoxSetRGBColor $colorMessage"

  scale .ColorBox.H     -activeforeground "$colorBoxScrollActiveForeground"     -background "$colorBoxBackground"     -foreground "$colorBoxForeground"     -from 0     -label "Hue"     -orient horizontal     -relief raised     -sliderlength 15     -to 360     -width 8     -command "ColorBoxSetHSVColor $colorMessage"

   scale .ColorBox.S     -activeforeground "$colorBoxScrollActiveForeground"     -background "$colorBoxBackground"     -foreground "$colorBoxForeground"     -from 0     -label "Saturation * 100"     -orient horizontal     -relief raised     -sliderlength 15     -to 100     -width 8     -command "ColorBoxSetHSVColor $colorMessage"

  scale .ColorBox.V     -activeforeground "$colorBoxScrollActiveForeground"     -background "$colorBoxBackground"     -foreground "$colorBoxForeground"     -from 0     -label "Value"     -orient horizontal     -relief raised     -sliderlength 15     -to 255     -width 8     -command "ColorBoxSetHSVColor $colorMessage"

  label .ColorBox.demo     -background "$colorBoxBackground"     -foreground "$colorBoxForeground"     -font "$colorBoxFont"     -relief raised     -text "This text shows the results :-)"

  frame .ColorBox.current     -background "$colorBoxBackground"     -borderwidth 0     -relief raised

  label .ColorBox.current.labelcurrent     -background "$colorBoxBackground"     -foreground "$colorBoxForeground"     -font "$colorBoxFont"     -relief raised     -text "$colorMessage"

  entry .ColorBox.current.current     -background "$colorBoxBackground"     -foreground "$colorBoxForeground"     -font "$colorBoxFont"     -relief raised

  frame .ColorBox.colors     -background "$colorBoxBackground"     -borderwidth 0     -relief raised

  scrollbar .ColorBox.colors.vscroll     -activeforeground "$colorBoxScrollActiveForeground"     -background "$colorBoxScrollBackground"     -foreground "$colorBoxScrollForeground"     -relief raised     -command ".ColorBox.colors.colors yview"

  scrollbar .ColorBox.colors.hscroll     -activeforeground "$colorBoxScrollActiveForeground"     -background "$colorBoxScrollBackground"     -foreground "$colorBoxScrollForeground"     -orient horiz     -relief raised     -command ".ColorBox.colors.colors xview"

  listbox .ColorBox.colors.colors     -background "$colorBoxBackground"     -foreground "$colorBoxForeground"     -font "$colorBoxFont"     -exportselection false     -relief raised     -xscrollcommand ".ColorBox.colors.hscroll set"     -yscrollcommand ".ColorBox.colors.vscroll set"

  # read color file
  if {"$colorFileColor" != ""} {
    if {[catch "open $colorFileColor r" colorInFile]} {
      puts stderr "$colorInFile"
      set colorFileColor ""
    } {
      while {1 == 1} {
        if {[gets $colorInFile colorLine] == -1} {
          break
        }
        set colorNewLine [lrange $colorLine 3 end]
        append colorNewLine " " [format #%02x [lindex $colorLine 0]]
        append colorNewLine [format %02x [lindex $colorLine 1]]
        append colorNewLine [format %02x [lindex $colorLine 2]]
        .ColorBox.colors.colors insert end $colorNewLine
      }
      close $colorInFile
    }
  }

  # bindings
  bind .ColorBox.current.current <Delete> {
    EntryBS %W}
  bind .ColorBox.current.current <BackSpace> {
    EntryBS %W}
  bind .ColorBox.current.current <Right> {
    %W cursor [expr [%W index cursor]+1]
    EntryV2C %W }
  bind .ColorBox.current.current <Left> {
    %W cursor [expr [%W index cursor]-1]
    EntryV2C %W }
  bind .ColorBox.current.current <Control-a> {
    %W cursor 0
    %W view 0}
  bind .ColorBox.current.current <Control-b> {
    %W cursor [expr [%W index cursor]-1]
    EntryV2C %W}
  bind .ColorBox.current.current <Control-d> {
    %W delete [%W index cursor]
    EntryV2C %W }
  bind .ColorBox.current.current <Control-e> {
    %W cursor end
    EntryV2C %W}
  bind .ColorBox.current.current <Control-f> {
    %W cursor [expr [%W index cursor]+1]
    EntryV2C %W}
  bind .ColorBox.current.current <Control-h> {
    EntryBS %W}
  bind .ColorBox.current.current <Meta-h> {
    %W delete 0 cursor
    %W view cursor}
  bind .ColorBox.current.current <Control-i> {
    %W insert cursor \t}
  bind .ColorBox.current.current <Control-k> {
    %W delete cursor end
    EntryV2C %W}
  bind .ColorBox.current.current <Control-l> {
    EntryV2C %W}
  bind .ColorBox.current.current <Control-t> {
    set contents [%W get]
    set char1 [string index $contents [expr [%W index cursor]-2]]
    set char2 [string index $contents [expr [%W index cursor]-1]]
    %W delete [expr [%W index cursor]-2] [expr [%W index cursor]-1]
    %W insert [%W index cursor] "$char2$char1"
    %W cursor [expr [%W index cursor]+1]
    EntryV2C %W}
  bind .ColorBox.current.current <Control-v> {
    %W insert cursor "[GetSelection]"}
  bind .ColorBox.current.current <Control-w> {
    catch "%W delete sel.first sel.last"
    EntryV2C %W}
  bind .ColorBox.current.current <Control-y> {
    %W insert cursor "[GetSelection]"}
  bind .ColorBox.current.current <space> {
    %W insert cursor " "
    EntryV2C %W}
  bind .ColorBox.current.current <Any-Key> {
    %W insert cursor "%A"
    EntryV2C %W}
  bind .ColorBox.current.current <Return> {
    catch ".ColorBox.demo configure -background       [.ColorBox.current.current get]"}

  bind .ColorBox.colors.colors <ButtonPress-1> {
    ColorBoxSelectColor %W %y}
  bind .ColorBox.colors.colors <Button1-Motion> {
    ColorBoxSelectColor %W %y}
  bind .ColorBox.colors.colors <Shift-ButtonPress-1> {
    ColorBoxSelectColor %W %y}
  bind .ColorBox.colors.colors <Shift-Button1-Motion> {
    ColorBoxSelectColor %W %y}

  # packing
  pack append .ColorBox.frame1               .ColorBox.frame1.ok {left fill expand}               .ColorBox.frame1.cancel {left fill expand}
  pack append .ColorBox.current               .ColorBox.current.labelcurrent {left}               .ColorBox.current.current {left fill expand}
  pack append .ColorBox.colors               .ColorBox.colors.vscroll {left filly}               .ColorBox.colors.hscroll {bottom fillx}               .ColorBox.colors.colors {left fill expand}

  if {[string length $colorFileColor] > 0} {
    pack append .ColorBox                 .ColorBox.frame1 {bottom fillx}                 .ColorBox.current {bottom fillx}                 .ColorBox.demo {bottom fillx}                 .ColorBox.red {top fillx}                 .ColorBox.green {top fillx}                 .ColorBox.blue {top fillx}                 .ColorBox.H {top fillx}                 .ColorBox.S {top fillx}                 .ColorBox.V {top fillx}                 .ColorBox.colors {top fill expand}
  } {
    wm geometry .ColorBox 400x345
    pack append .ColorBox                 .ColorBox.frame1 {bottom fillx}                 .ColorBox.current {bottom fillx}                 .ColorBox.red {top fillx}                 .ColorBox.green {top fillx}                 .ColorBox.blue {top fillx}                 .ColorBox.H {top fillx}                 .ColorBox.S {top fillx}                 .ColorBox.V {top fillx}                 .ColorBox.demo {bottom fill expand}
  }

  # wait for the box to be destroyed
  grab .ColorBox
  tkwait window .ColorBox

  return $colorBoxName
}


# Procedure: ColorBoxSelectColor
proc ColorBoxSelectColor { colorW colorY} {

  set colorNearest [$colorW nearest $colorY]
  if {$colorNearest >= 0} {
    $colorW select from $colorNearest
    $colorW select to $colorNearest
    set colorTmpValue [$colorW get $colorNearest]
    set colorCurrentColor [lrange $colorTmpValue 0           [expr [llength $colorTmpValue]-2]]
    set colorCurrentValue [lrange $colorTmpValue           [expr [llength $colorTmpValue]-1] end]

    scan [string range $colorCurrentValue 1 2] "%x" colorValue
    .ColorBox.red set $colorValue
    scan [string range $colorCurrentValue 3 4] "%x" colorValue
    .ColorBox.green set $colorValue
    scan [string range $colorCurrentValue 5 6] "%x" colorValue
    .ColorBox.blue set $colorValue

    .ColorBox.current.current delete 0 end
    .ColorBox.current.current insert 0 $colorCurrentColor
    catch ".ColorBox.demo configure -background $colorCurrentColor"
  }
}


# Procedure: ColorBoxSetHSVColor
proc ColorBoxSetHSVColor { colorMessage colorValue} {

  set H [expr ([.ColorBox.H get]%360)/60.0]
  set Hint [expr ([.ColorBox.H get]%360)/60]
  set Hfloat [expr $H-$Hint]
  set S [expr [.ColorBox.S get]/100.0]
  set V [.ColorBox.V get]
  set tmp1 [expr $V*(1.0-$S)]
  set tmp2 [expr $V*(1.0-$S*$Hfloat)]
  set tmp3 [expr $V*(1.0-$S*(1.0-$Hfloat))]

  case $Hint in {
    {0} {
      set red $V
      set green $tmp3
      set blue $tmp1
    }
    {1} {
      set red $tmp2
      set green $V
      set blue $tmp1
    }
    {2} {
      set red $tmp1
      set green $V
      set blue $tmp3
    }
    {3} {
      set red $tmp1
      set green $tmp2
      set blue $V
    }
    {4} {
      set red $tmp3
      set green $tmp1
      set blue $V
    }
    {default} {
      set red $V
      set green $tmp1
      set blue $tmp2
    }
  }

  if {[string first . $red] >= 0} {
    set red [string range $red 0 [expr [string first . $red]-1]]
  }
  if {[string first . $green] >= 0} {
    set green [string range $green 0 [expr [string first . $green]-1]]
  }
  if {[string first . $blue] >= 0} {
    set blue [string range $blue 0 [expr [string first . $blue]-1]]
  }

  .ColorBox.red configure     -command "NoFunction"
  .ColorBox.green configure     -command "NoFunction"
  .ColorBox.blue configure     -command "NoFunction"
  .ColorBox.red set $red
  .ColorBox.green set $green
  .ColorBox.blue set $blue
  .ColorBox.red configure     -command "ColorBoxSetRGBColor $colorMessage"
  .ColorBox.green configure     -command "ColorBoxSetRGBColor $colorMessage"
  .ColorBox.blue configure     -command "ColorBoxSetRGBColor $colorMessage"

  .ColorBox.current.current delete 0 end
  .ColorBox.current.current insert 0     [format #%02x%02x%02x [.ColorBox.red get]       [.ColorBox.green get] [.ColorBox.blue get]]
  if {[string match "*oreground*" $colorMessage]} {
    catch ".ColorBox.demo configure -foreground       [format #%02x%02x%02x [.ColorBox.red get]         [.ColorBox.green get] [.ColorBox.blue get]]"
  } {
    catch ".ColorBox.demo configure -background       [format #%02x%02x%02x [.ColorBox.red get]         [.ColorBox.green get] [.ColorBox.blue get]]"
  }
}


# Procedure: ColorBoxSetRGBColor
proc ColorBoxSetRGBColor { colorMessage colorValue} {

  set R [.ColorBox.red get].0
  set G [.ColorBox.green get].0
  set B [.ColorBox.blue get].0
  set cMax $R
  set cMin $G
  set iMax 1
  if {$cMax < $G} {
    set cMax $G
    set cMin $R
    set iMax 2
  }
  if {$cMax < $B} {
    set cMax $B
    set iMax 3
  }
  if {$cMin > $B} {
    set cMin $R
  }
  set cMM [expr $cMax-$cMin]
  set V $cMax
  if {$cMM == 0} {
    set S 0
    set H 0
  } {
    set S [expr $cMM/$cMax]
    case $iMax in {
      {1} {
        set H [expr ($G-$B)/$cMM]
      }
      {2} {
        set H [expr 2.0+($B-$R)/$cMM]
      }
      {3} {
        set H [expr 4.0+($R-$G)/$cMM]
      }
    }
    if {$H < 0} {
      set H [expr $H+6.0]
    }
  }
  set H [expr $H*60.0]
  set S [expr $S*100.0]

  if {[string first . $H] >= 0} {
    set H [string range $H 0 [expr [string first . $H]-1]]
  }
  if {[string first . $S] >= 0} {
    set S [string range $S 0 [expr [string first . $S]-1]]
  }
  if {[string first . $V] >= 0} {
    set V [string range $V 0 [expr [string first . $V]-1]]
  }

  .ColorBox.H configure     -command "NoFunction"
  .ColorBox.S configure     -command "NoFunction"
  .ColorBox.V configure     -command "NoFunction"
  .ColorBox.H set $H
  .ColorBox.S set $S
  .ColorBox.V set $V
  .ColorBox.H configure     -command "ColorBoxSetHSVColor $colorMessage"
  .ColorBox.S configure     -command "ColorBoxSetHSVColor $colorMessage"
  .ColorBox.V configure     -command "ColorBoxSetHSVColor $colorMessage"

  .ColorBox.current.current delete 0 end
  .ColorBox.current.current insert 0     [format #%02x%02x%02x [.ColorBox.red get]       [.ColorBox.green get] [.ColorBox.blue get]]
  if {[string match "*oreground*" $colorMessage]} {
    catch ".ColorBox.demo configure -foreground       [format #%02x%02x%02x [.ColorBox.red get]         [.ColorBox.green get] [.ColorBox.blue get]]"
  } {
    catch ".ColorBox.demo configure -background       [format #%02x%02x%02x [.ColorBox.red get]         [.ColorBox.green get] [.ColorBox.blue get]]"
  }
}


# Procedure: EmacsBuildBuffList
proc EmacsBuildBuffList { emacsW} {
  global emacsBuffList

  set buffList ""
  set tmpBuffList [string trim [.frame.text send "(mapcar 'buffer-name (buffer-list))"] ()]
  foreach counter $tmpBuffList {
    if {[string index $counter 0] != " "} {
      append buffList "\{$counter\} "
    }
  }
  set buffList [lsort $buffList]
  if {"$buffList" == "$emacsBuffList"} {
    return
  }
  set emacsBuffList $buffList

  catch "destroy $emacsW.m"
  menu $emacsW.m

  set counter 0
  foreach buffName $buffList {
    $emacsW.m add cascade      -label "$buffName"      -menu "$emacsW.m.$counter"      -command "
        SendToEmacs \{(switch-to-buffer \"$buffName\")\}"

    menu $emacsW.m.$counter
    $emacsW.m.$counter add command      -accelerator {C-x b}      -label "Switch to buffer"      -command "
        SendToEmacs \{(switch-to-buffer \"$buffName\")\}"
    $emacsW.m.$counter add command      -accelerator {C-x 4 b}      -label "Switch to buffer other window"      -command "
        SendToEmacs \{(switch-to-buffer-other-window \"$buffName\")\}"
    $emacsW.m.$counter add command      -label "Bury buffer"      -command "
        SendToEmacs \{(bury-buffer)\}"
    $emacsW.m.$counter add separator
    $emacsW.m.$counter add command      -accelerator {C-x k}      -command "SendToEmacs \{(kill-buffer \"$buffName\")\}"      -label {Kill buffer}      -underline {0}
    incr counter
  }
  EmacsSetWidgetResources $emacsW.m
  update idletask
}


# Procedure: EmacsDoubleClick
proc EmacsDoubleClick {} {
  global emacsCurrentMenu

  set emacsMode [.frame.text send mode-name]
  set menuName .
  foreach counter [split $emacsMode] {
    append menuName [string trim $counter]
  }
  if {"$menuName" != "." && "[info commands $menuName]" != ""} {
    catch "$menuName invoke 0"
  }
}


# Procedure: EmacsError
proc EmacsError { emacsW emacsMessage} {
  global emacsErrorMessage
  
  append emacsErrorMessage "$emacsMessage\n"
  TextBox $emacsErrorMessage 400x300
}


# Procedure: EmacsPopup
proc EmacsPopup { emacsX emacsY} {
  global emacsCurrentMenu

  set emacsMode [.frame.text send mode-name]
  set menuName .
  foreach counter [split $emacsMode] {
    append menuName [string trim $counter]
  }
  if {"$menuName" != "." && "[info commands $menuName]" != ""} {
    set emacsCurrentMenu $menuName
    $menuName post $emacsX $emacsY
  } {
    set emacsCurrentMenu .EmacsDefault
    .EmacsDefault post $emacsX $emacsY
  }
}


# Procedure: EmacsPopupHandle
proc EmacsPopupHandle { emacsX emacsY} {
  global emacsCurrentMenu

  if {"$emacsCurrentMenu" != "" &&
      [winfo ismapped $emacsCurrentMenu]} {
    set emacsPopMinX [winfo rootx $emacsCurrentMenu]
    set emacsPopMaxX       [expr "$emacsPopMinX + [winfo width $emacsCurrentMenu]"]
    if {($emacsX >= $emacsPopMinX) && ($emacsX <= $emacsPopMaxX)} {
      $emacsCurrentMenu activate @[expr "$emacsY - [winfo rooty $emacsCurrentMenu]"]
    } {
      $emacsCurrentMenu activate none
    }
  }
}


# Procedure: EmacsQuit
proc EmacsQuit {} {

  if {"[info commands ClientShutdown]" != ""} {
    wm iconify .
    wm withdraw .
  } {
    SendToEmacs {(progn (tk-advise-destroy-widget-on-exit)
                 (save-buffers-kill-emacs))}
  }
}


# Procedure: EmacsSaveOptions
proc EmacsSaveOptions {} {
  global bindPopupDown
  global oldBindPopupDown
  global bindPopupRelease
  global oldBindPopupRelease
  global bindPopupMove
  global oldBindPopupMove
  global emacsPopupBind
  global emacsActBackground
  global emacsActForeground
  global emacsBackground
  global emacsForeground
  global emacsFont
  global emacsEmacsFont
  global emacsEmacsCursor
  global emacsPollInterval
  global emacsScrollActForeground
  global emacsScrollForeground
  global emacsUseAdvise

  if {![catch "open ~/.xfemacs-o.tcl w" outFile]} {
    puts $outFile "global bindPopupDown"
    puts $outFile "set bindPopupDown \{$bindPopupDown\}"
    puts $outFile "global bindPopupRelease"
    puts $outFile "set bindPopupRelease \{$bindPopupRelease\}"
    puts $outFile "global bindPopupMove"
    puts $outFile "set bindPopupMove \{$bindPopupMove\}"
    puts $outFile "global emacsPopupBind"
    puts $outFile "set emacsPopupBind \{$emacsPopupBind\}"
    puts $outFile "global emacsActBackground"
    puts $outFile "set emacsActBackground $emacsActBackground"
    puts $outFile "global emacsActForeground"
    puts $outFile "set emacsActForeground $emacsActForeground"
    puts $outFile "global emacsBackground"
    puts $outFile "set emacsBackground $emacsBackground"
    puts $outFile "global emacsForeground"
    puts $outFile "set emacsForeground $emacsForeground"
    puts $outFile "global emacsFont"
    puts $outFile "set emacsFont $emacsFont"
    puts $outFile "global emacsEmacsFont"
    puts $outFile "set emacsEmacsFont $emacsEmacsFont"
    puts $outFile "global emacsEmacsCursor"
    puts $outFile "set emacsEmacsCursor $emacsEmacsCursor"
    puts $outFile "global emacsPollInterval"
    puts $outFile "set emacsPollInterval \{$emacsPollInterval\}"
    puts $outFile "global emacsScrollActForeground"
    puts $outFile "set emacsScrollActForeground $emacsScrollActForeground"
    puts $outFile "global emacsScrollForeground"
    puts $outFile "set emacsScrollForeground $emacsScrollForeground"
    puts $outFile "global emacsUseAdvise"
    puts $outFile "set emacsUseAdvise $emacsUseAdvise"
    close $outFile
  } {
    puts stderr "could not open options file ~/.xfemacs-o.tcl"
  }
}


# Procedure: EmacsSetBinding
proc EmacsSetBinding {} {
  global bindPopupDown
  global oldBindPopupDown
  global bindPopupRelease
  global oldBindPopupRelease
  global bindPopupMove
  global oldBindPopupMove

  if {"$bindPopupDown" != "$oldBindPopupDown"} {
    bind .frame.text $oldBindPopupDown {}
    bind .frame.text $bindPopupDown {EmacsPopup %X %Y}
    set oldBindPopupDown $bindPopupDown
  }
  if {"$bindPopupRelease" != "$oldBindPopupRelease"} {
    bind .frame.text $oldBindPopupRelease {}
    bind .frame.text $bindPopupRelease {
      global emacsCurrentMenu
      if {"$emacsCurrentMenu" != ""} {
        $emacsCurrentMenu invoke active
        $emacsCurrentMenu unpost
        set emacsCurrentMenu ""
      }}
    set oldBindPopupRelease $bindPopupRelease
  }
  if {"$bindPopupMove" != "$oldBindPopupMove"} {
    bind .frame.text $oldBindPopupMove {}
    bind .frame.text $bindPopupMove {EmacsPopupHandle %X %Y}
    set oldBindPopupMove $bindPopupMove
  }
}


# Procedure: EmacsSetModeMenu
proc EmacsSetModeMenu { emacsW} {

  set emacsMode [.frame.text send mode-name]
  set menuName .
  foreach counter [split $emacsMode] {
    append menuName [string trim $counter]
  }
  if {"$menuName" != "." && "[info commands $menuName]" != ""} {
    $emacsW config -menu "$menuName"
  } {
    $emacsW config -menu ".EmacsDefault"
  }
}


# Procedure: EmacsSetWidgetResources
proc EmacsSetWidgetResources { emacsW} {
  global emacsActBackground
  global emacsActForeground
  global emacsBackground
  global emacsForeground
  global emacsFont
  global emacsEmacsFont
  global emacsEmacsCursor
  global emacsScrollActForeground
  global emacsScrollForeground

  if {"[info commands $emacsW]" == "" &&
      "$emacsW" != "."} {
    return
  }
  set emacsOptions ""
  case [winfo class $emacsW] in {
    {Button CheckButton RadioButton Menubutton Menu} {
      if {"$emacsActBackground" != ""} {
        append emacsOptions " -activebackground $emacsActBackground"
      }
      if {"$emacsActForeground" != ""} {
        append emacsOptions " -activeforeground $emacsActForeground"
      }
      if {"$emacsBackground" != ""} {
        append emacsOptions " -background $emacsBackground"
      }
      if {"$emacsForeground" != ""} {
        append emacsOptions " -foreground $emacsForeground"
      }
      if {"$emacsFont" != ""} {
        append emacsOptions " -font $emacsFont"
      }
    }
    {Listbox} {
      if {"$emacsActBackground" != ""} {
        append emacsOptions " -selectbackground $emacsActBackground"
      }
      if {"$emacsActForeground" != ""} {
        append emacsOptions " -selectforeground $emacsActForeground"
      }
      if {"$emacsBackground" != ""} {
        append emacsOptions " -background $emacsBackground"
      }
      if {"$emacsForeground" != ""} {
        append emacsOptions " -foreground $emacsForeground"
      }
      if {"$emacsFont" != ""} {
        append emacsOptions " -font $emacsFont"
      }
    }
    {Frame Toplevel} {
      if {"$emacsBackground" != ""} {
        append emacsOptions " -background $emacsBackground"
      }
    }
    {Label Message Text Entry} {
      if {"$emacsBackground" != ""} {
        append emacsOptions " -background $emacsBackground"
      }
      if {"$emacsForeground" != ""} {
        append emacsOptions " -foreground $emacsForeground"
      }
      if {"$emacsFont" != ""} {
        append emacsOptions " -font $emacsFont"
      }
      if {[string compare Entry [winfo class $emacsW]] == 0} {
        if {"$emacsEmacsCursor" != ""} {
          append emacsOptions " -cursorbackground $emacsEmacsCursor"
        }
      }
    }
    {Scrollbar} {
      if {"$emacsScrollActForeground" != ""} {
        append emacsOptions " -activeforeground $emacsScrollActForeground"
      }
      if {"$emacsBackground" != ""} {
        append emacsOptions " -background $emacsBackground"
      }
      if {"$emacsScrollForeground" != ""} {
        append emacsOptions " -foreground $emacsScrollForeground"
      }
    }
    {Scale} {
      if {"$emacsScrollActForeground" != ""} {
        append emacsOptions " -activeforeground $emacsScrollActForeground"
      }
      if {"$emacsBackground" != ""} {
        append emacsOptions " -background $emacsBackground"
      }
      if {"$emacsScrollForeground" != ""} {
        append emacsOptions " -foreground $emacsForeground"
      }
    }
    {TkEmacs Text} {
      if {"$emacsBackground" != ""} {
        append emacsOptions " -background $emacsBackground"
      }
      if {"$emacsForeground" != ""} {
        append emacsOptions " -foreground $emacsForeground"
      }
      if {"$emacsEmacsFont" != ""} {
        append emacsOptions " -font $emacsEmacsFont"
      }
      if {"$emacsEmacsCursor" != ""} {
        append emacsOptions " -insertbackground $emacsEmacsCursor"
      }
    }
  }
  if {"$emacsOptions" != ""} {
    catch "$emacsW config $emacsOptions" xfres
  }
  foreach counter [winfo children $emacsW] {
    EmacsSetWidgetResources $counter
  }
}


# Procedure: EmacsUpdateResources
proc EmacsUpdateResources {} {

  foreach counter [lsort [winfo children .frame0]] {
    pack unpack $counter
  }
  set emacsButtonList ""
  foreach counter [lsort [winfo children .frame0]] {
    if {"[string trim [lindex [$counter config -text] 4]]" != ""} {
      if {"[winfo class $counter]" == "Menubutton"} {
        set emacsButtonList "$emacsButtonList $counter"
      }
      if {"$counter" == ".frame0.menubutton14"} {
        pack append .frame0           .frame0.button01 {left frame center}
        pack append .frame0           $counter {right frame center}
      } {
        pack append .frame0           $counter {left frame center}
      }
      if {"[lindex [$counter config -text] 4]" == "Buffers"} {
        bind $counter <1> {
          EmacsBuildBuffList %W
          tk_mbButtonDown %W}
        bind $counter <B1-Enter> {
          EmacsBuildBuffList %W
          set tk_priv(inMenuButton) %W
          if {([lindex [%W config -state] 4] != "disabled")
              && ("%m" != "NotifyGrab") && ("%m" != "NotifyUngrab")} {
            if {!$tk_strictMotif} {
              %W config -state active
            }
            tk_mbPost %W
          }}
        bind $counter <2> {
          EmacsBuildBuffList %W
          if {($tk_priv(posted) == "")
              && ([lindex [%W config -state] 4] != "disabled")} {
            set tk_priv(dragging) %W
              [lindex [$tk_priv(dragging) config -menu] 4] post %X %Y
          }}
      } {
        if {"[lindex [$counter config -text] 4]" == "Current mode"} {
          bind $counter <1> {
            EmacsSetModeMenu %W
            tk_mbButtonDown %W}
          bind $counter <B1-Enter> {
            EmacsSetModeMenu %W
            set tk_priv(inMenuButton) %W
            if {([lindex [%W config -state] 4] != "disabled")
                && ("%m" != "NotifyGrab") && ("%m" != "NotifyUngrab")} {
              if {!$tk_strictMotif} {
                %W config -state active
              }
              tk_mbPost %W
            }}
          bind $counter <2> {
            EmacsSetModeMenu %W
            if {($tk_priv(posted) == "")
                && ([lindex [%W config -state] 4] != "disabled")} {
              set tk_priv(dragging) %W
                [lindex [$tk_priv(dragging) config -menu] 4] post %X %Y
            }}
        } {
          if {"[winfo class $counter]" == "Menubutton"} {
            bind $counter <1> {
              tk_mbButtonDown %W}
            bind $counter <B1-Enter> {
              set tk_priv(inMenuButton) %W
              if {([lindex [%W config -state] 4] != "disabled")
                  && ("%m" != "NotifyGrab") && ("%m" != "NotifyUngrab")} {
                if {!$tk_strictMotif} {
                  %W config -state active
                }
                tk_mbPost %W
              }}
            bind $counter <2> {
              if {($tk_priv(posted) == "")
                  && ([lindex [%W config -state] 4] != "disabled")} {
                set tk_priv(dragging) %W
                  [lindex [$tk_priv(dragging) config -menu] 4] post %X %Y
              }}
          }
        }
      }
    } {
      pack unpack $counter
    }
  }
  eval "tk_menus . $emacsButtonList"
  EmacsSetWidgetResources .
}


# Procedure: EntryBS
if {[string length [info procs EntryBS]] == 0} {
proc EntryBS { xfW} {

  set xfX [expr "[$xfW index cursor]-1"]
  if {$xfX != -1} {
    $xfW delete $xfX
  }
  EntryV2C $xfW
}
}


# Procedure: EntryV2C
if {[string length [info procs EntryV2C]] == 0} {
proc EntryV2C { xfW} {

  set xfLeftExtent [$xfW index @0]
  set xfRightExtent [$xfW index @[winfo width $xfW]]
  set xfCursorPos [$xfW index cursor]
  set xfEntryLen [expr "$xfRightExtent-$xfLeftExtent"]

  if {$xfCursorPos > $xfLeftExtent} {
    if {$xfCursorPos > $xfRightExtent} {
      #handle cursor too far to the right
      $xfW view [expr "$xfCursorPos-$xfEntryLen+1"]
    }
  } { 
    #handle cursor too far to the left
    $xfW view [expr "$xfCursorPos-1"]
  }
}
}


# Procedure: FSBox
proc FSBox { {fsBoxMessage "Select file:"} {fsBoxFileName ""}} {
  # Description: show file selector box
  # Arguments: fsBoxMessage - the text to display
  #            fsBoxFileName - a file name that should be selected
  # Returns: The filename that was selected
  # 
  # global fsBoxActiveBackground - active background color
  # global fsBoxActiveForeground - active foreground color
  # global fsBoxBackground - background color
  # global fsBoxFont - text font
  # global fsBoxForeground - foreground color
  # global fsBoxExtensions - scan directory for extensions
  # global fsBoxScrollActiveForeground - scrollbar active background color
  # global fsBoxScrollBackground - scrollbar background color
  # global fsBoxScrollForeground - scrollbar foreground color

  global fsBoxFSAll
  global fsBoxFSName
  global fsBoxFSPath
  global fsBoxFSInternalPath
  global fsBoxFSPattern
  global fsBoxActiveBackground
  global fsBoxActiveForeground
  global fsBoxBackground
  global fsBoxExtensions
  global fsBoxFont
  global fsBoxForeground
  global fsBoxScrollActiveForeground
  global fsBoxScrollBackground
  global fsBoxScrollForeground

  set fsBoxFSName $fsBoxFileName
  if {"$fsBoxFSPath" != "" &&
      [file exists $fsBoxFSPath] &&
      [file isdirectory $fsBoxFSPath]} {
    set fsBoxFSInternalPath $fsBoxFSPath
  } {
    if {"$fsBoxFSInternalPath" == "" ||
        ![file exists $fsBoxFSInternalPath]} {
      set fsBoxFSInternalPath [pwd]
    }
  }

  if {"[info commands XFDestroy]" != ""} {
    catch {XFDestroy .FSBox}
  } {
    catch {destroy .FSBox}
  }
  toplevel .FSBox     -background "$fsBoxBackground"     -borderwidth 0
  wm geometry .FSBox 350x300 
  wm title .FSBox {File select box}
  wm maxsize .FSBox 1000 1000
  wm minsize .FSBox 100 100
  wm positionfrom .FSBox program
  wm sizefrom .FSBox user

  label .FSBox.message1     -background "$fsBoxBackground"     -foreground "$fsBoxForeground"     -font "$fsBoxFont"     -anchor c     -relief raised     -text "$fsBoxMessage"

  frame .FSBox.frame1     -background "$fsBoxBackground"     -borderwidth 0     -relief raised

  button .FSBox.frame1.ok     -activebackground "$fsBoxActiveBackground"     -activeforeground "$fsBoxActiveForeground"     -background "$fsBoxBackground"     -foreground "$fsBoxForeground"     -font "$fsBoxFont"     -text "OK"     -command "
      global fsBoxFSName
      global fsBoxFSPath
      global fsBoxFSInternalPath
      set fsBoxFSName \[.FSBox.file.file get\]
      set fsBoxFSPath \[.FSBox.path.path get\]
      set fsBoxFSInternalPath \[.FSBox.path.path get\]
      if {\"\[info commands XFDestroy\]\" != \"\"} {
        catch {XFDestroy .FSBox}
      } {
        catch {destroy .FSBox}
      }"

  button .FSBox.frame1.rescan     -activebackground "$fsBoxActiveBackground"     -activeforeground "$fsBoxActiveForeground"     -background "$fsBoxBackground"     -foreground "$fsBoxForeground"     -font "$fsBoxFont"     -text "Rescan"     -command {
      global fsBoxFSAll
      FSBoxFSShow [.FSBox.path.path get]         [.FSBox.pattern.pattern get] $fsBoxFSAll}

  button .FSBox.frame1.cancel     -activebackground "$fsBoxActiveBackground"     -activeforeground "$fsBoxActiveForeground"     -background "$fsBoxBackground"     -foreground "$fsBoxForeground"     -font "$fsBoxFont"     -text "Cancel"     -command "
      global fsBoxFSName
      global fsBoxFSPath
      set fsBoxFSName {}
      set fsBoxFSPath {}
      if {\"\[info commands XFDestroy\]\" != \"\"} {
        catch {XFDestroy .FSBox}
      } {
        catch {destroy .FSBox}
      }"

  frame .FSBox.path     -background "$fsBoxBackground"     -borderwidth 0     -relief raised

  frame .FSBox.path.paths     -background "$fsBoxBackground"     -borderwidth 2     -relief raised

  menubutton .FSBox.path.paths.paths     -activebackground "$fsBoxActiveBackground"     -activeforeground "$fsBoxActiveForeground"     -background "$fsBoxBackground"     -foreground "$fsBoxForeground"     -font "$fsBoxFont"     -borderwidth 0     -underline 0     -menu ".FSBox.path.paths.paths.menu"     -relief flat     -text "Pathname:"

  menu .FSBox.path.paths.paths.menu     -activebackground "$fsBoxActiveBackground"     -activeforeground "$fsBoxActiveForeground"     -background "$fsBoxBackground"     -foreground "$fsBoxForeground"     -font "$fsBoxFont"

  .FSBox.path.paths.paths.menu add command      -label "$fsBoxFSInternalPath"      -command "
       global fsBoxFSAll 
       global fsBoxFSInternalPath
       FSBoxFSShow \[.FSBox.path.path get\]          \[.FSBox.pattern.pattern get\] \$fsBoxFSAll
       .FSBox.path.path delete 0 end
       .FSBox.path.path insert 0 $fsBoxFSInternalPath"

  entry .FSBox.path.path     -background "$fsBoxBackground"     -foreground "$fsBoxForeground"     -font "$fsBoxFont"     -relief raised
  if {![file isdirectory $fsBoxFSInternalPath]} {
    set $fsBoxFSInternalPath [pwd]
  }
  .FSBox.path.path insert 0 $fsBoxFSInternalPath

  frame .FSBox.pattern     -background "$fsBoxBackground"     -borderwidth 0     -relief raised

  frame .FSBox.pattern.patterns     -background "$fsBoxBackground"     -borderwidth 2     -relief raised

  menubutton .FSBox.pattern.patterns.patterns     -activebackground "$fsBoxActiveBackground"     -activeforeground "$fsBoxActiveForeground"     -background "$fsBoxBackground"     -foreground "$fsBoxForeground"     -font "$fsBoxFont"     -borderwidth 0     -underline 0     -menu ".FSBox.pattern.patterns.patterns.menu"     -relief flat     -text "Selection pattern:"

  menu .FSBox.pattern.patterns.patterns.menu     -activebackground "$fsBoxActiveBackground"     -activeforeground "$fsBoxActiveForeground"     -background "$fsBoxBackground"     -foreground "$fsBoxForeground"     -font "$fsBoxFont"

  .FSBox.pattern.patterns.patterns.menu add checkbutton     -label "Scan extensions"     -variable fsBoxExtensions     -command {
      global fsBoxFSAll
      FSBoxFSShow [.FSBox.path.path get]         [.FSBox.pattern.pattern get] $fsBoxFSAll}

  entry .FSBox.pattern.pattern     -background "$fsBoxBackground"     -foreground "$fsBoxForeground"     -font "$fsBoxFont"     -relief raised
  .FSBox.pattern.pattern insert 0 $fsBoxFSPattern
  
  frame .FSBox.files     -background "$fsBoxBackground"     -borderwidth 0     -relief raised

  scrollbar .FSBox.files.vscroll     -activeforeground "$fsBoxScrollActiveForeground"     -background "$fsBoxScrollBackground"     -foreground "$fsBoxScrollForeground"     -relief raised     -command ".FSBox.files.files yview"

  scrollbar .FSBox.files.hscroll     -activeforeground "$fsBoxScrollActiveForeground"     -background "$fsBoxScrollBackground"     -foreground "$fsBoxScrollForeground"     -orient horiz     -relief raised     -command ".FSBox.files.files xview"

  listbox .FSBox.files.files     -background "$fsBoxBackground"     -foreground "$fsBoxForeground"     -font "$fsBoxFont"     -exportselection false     -relief raised     -xscrollcommand ".FSBox.files.hscroll set"     -yscrollcommand ".FSBox.files.vscroll set"

  frame .FSBox.file     -background "$fsBoxBackground"     -borderwidth 0     -relief raised

  label .FSBox.file.labelfile     -background "$fsBoxBackground"     -foreground "$fsBoxForeground"     -font "$fsBoxFont"     -relief raised     -text "Filename:"

  entry .FSBox.file.file     -background "$fsBoxBackground"     -foreground "$fsBoxForeground"     -font "$fsBoxFont"     -relief raised

  .FSBox.file.file delete 0 end
  .FSBox.file.file insert 0 $fsBoxFSName
  
  checkbutton .FSBox.pattern.all     -activebackground "$fsBoxActiveBackground"     -activeforeground "$fsBoxActiveForeground"     -background "$fsBoxBackground"     -foreground "$fsBoxForeground"     -font "$fsBoxFont"     -offvalue 0     -onvalue 1     -text "Show all files"     -variable fsBoxFSAll     -command {
      global fsBoxFSAll
      FSBoxFSShow [.FSBox.path.path get]         [.FSBox.pattern.pattern get] $fsBoxFSAll}

  FSBoxFSShow $fsBoxFSInternalPath $fsBoxFSPattern $fsBoxFSAll

  # init menus
  tk_menus .FSBox     .FSBox.path.paths.paths     .FSBox.pattern.patterns.patterns 

  # bindings
  bind .FSBox.files.files <Double-Button-1> "
    FSBoxBindSelectOne %W %y
    FSBoxFSFileSelectDouble %W %y"
  bind .FSBox.files.files <ButtonPress-1> {
    FSBoxBindSelectOne %W %y
    FSBoxFSFileSelect %W %y}
  bind .FSBox.files.files <Button1-Motion> {
    FSBoxBindSelectOne %W %y
    FSBoxFSFileSelect %W %y}
  bind .FSBox.files.files <Shift-Button1-Motion> {
    FSBoxBindSelectOne %W %y
    FSBoxFSFileSelect %W %y}
  bind .FSBox.files.files <Shift-ButtonPress-1> {
    FSBoxBindSelectOne %W %y
    FSBoxFSFileSelect %W %y}

  bind .FSBox.path.path <Delete> {
    EntryBS %W}
  bind .FSBox.path.path <BackSpace> {
    EntryBS %W}
  bind .FSBox.path.path <Right> {
    %W cursor [expr [%W index cursor]+1]
    EntryV2C %W }
  bind .FSBox.path.path <Left> {
    %W cursor [expr [%W index cursor]-1]
    EntryV2C %W }
  bind .FSBox.path.path <Control-a> {
    %W cursor 0
    %W view 0}
  bind .FSBox.path.path <Control-b> {
    %W cursor [expr [%W index cursor]-1]
    EntryV2C %W}
  bind .FSBox.path.path <Control-d> {
    %W delete [%W index cursor]
    EntryV2C %W }
  bind .FSBox.path.path <Control-e> {
    %W cursor end
    EntryV2C %W}
  bind .FSBox.path.path <Control-f> {
    %W cursor [expr [%W index cursor]+1]
    EntryV2C %W}
  bind .FSBox.path.path <Control-h> {
    EntryBS %W}
  bind .FSBox.path.path <Meta-h> {
    %W delete 0 cursor
    %W view cursor}
  bind .FSBox.path.path <Control-i> {
    %W insert cursor \t}
  bind .FSBox.path.path <Control-k> {
    %W delete cursor end
    EntryV2C %W}
  bind .FSBox.path.path <Control-l> {
    EntryV2C %W}
  bind .FSBox.path.path <Control-t> {
    set contents [%W get]
    set char1 [string index $contents [expr [%W index cursor]-2]]
    set char2 [string index $contents [expr [%W index cursor]-1]]
    %W delete [expr [%W index cursor]-2] [expr [%W index cursor]-1]
    %W insert [%W index cursor] "$char2$char1"
    %W cursor [expr [%W index cursor]+1]
    EntryV2C %W}
  bind .FSBox.path.path <Control-v> {
    %W insert cursor "[GetSelection]"}
  bind .FSBox.path.path <Control-w> {
    catch "%W delete sel.first sel.last"
    EntryV2C %W}
  bind .FSBox.path.path <Control-y> {
    %W insert cursor "[GetSelection]"}
  bind .FSBox.path.path <space> {
    %W insert cursor " "
    EntryV2C %W}
  bind .FSBox.path.path <Any-Key> {
    %W insert cursor "%A"
    EntryV2C %W}
  bind .FSBox.path.path <Tab> {
    FSBoxFSNameComplete path}
  bind .FSBox.path.path <Return> {
    global fsBoxFSAll
    FSBoxFSShow [.FSBox.path.path get]       [.FSBox.pattern.pattern get] $fsBoxFSAll
    FSBoxFSInsertPath
    .FSBox.file.file cursor end
    focus .FSBox.file.file}
  catch "bind .FSBox.path.path <Up> {}"
  bind .FSBox.path.path <Down> {
    .FSBox.file.file cursor end
    focus .FSBox.file.file}

  bind .FSBox.file.file <Delete> {
    EntryBS %W}
  bind .FSBox.file.file <BackSpace> {
    EntryBS %W}
  bind .FSBox.file.file <Right> {
    %W cursor [expr [%W index cursor]+1]
    EntryV2C %W }
  bind .FSBox.file.file <Left> {
    %W cursor [expr [%W index cursor]-1]
    EntryV2C %W }
  bind .FSBox.file.file <Control-a> {
    %W cursor 0
    %W view 0}
  bind .FSBox.file.file <Control-b> {
    %W cursor [expr [%W index cursor]-1]
    EntryV2C %W}
  bind .FSBox.file.file <Control-d> {
    %W delete [%W index cursor]
    EntryV2C %W }
  bind .FSBox.file.file <Control-e> {
    %W cursor end
    EntryV2C %W}
  bind .FSBox.file.file <Control-f> {
    %W cursor [expr [%W index cursor]+1]
    EntryV2C %W}
  bind .FSBox.file.file <Control-h> {
    EntryBS %W}
  bind .FSBox.file.file <Meta-h> {
    %W delete 0 cursor
    %W view cursor}
  bind .FSBox.file.file <Control-i> {
    %W insert cursor \t}
  bind .FSBox.file.file <Control-k> {
    %W delete cursor end
    EntryV2C %W}
  bind .FSBox.file.file <Control-l> {
    EntryV2C %W}
  bind .FSBox.file.file <Control-t> {
    set contents [%W get]
    set char1 [string index $contents [expr [%W index cursor]-2]]
    set char2 [string index $contents [expr [%W index cursor]-1]]
    %W delete [expr [%W index cursor]-2] [expr [%W index cursor]-1]
    %W insert [%W index cursor] "$char2$char1"
    %W cursor [expr [%W index cursor]+1]
    EntryV2C %W}
  bind .FSBox.file.file <Control-v> {
    %W insert cursor "[GetSelection]"}
  bind .FSBox.file.file <Control-w> {
    catch "%W delete sel.first sel.last"
    EntryV2C %W}
  bind .FSBox.file.file <Control-y> {
    %W insert cursor "[GetSelection]"}
  bind .FSBox.file.file <space> {
    %W insert cursor " "
    EntryV2C %W}
  bind .FSBox.file.file <Any-Key> {
    %W insert cursor "%A"
    EntryV2C %W}
  bind .FSBox.file.file <Tab> {
    FSBoxFSNameComplete file}
  bind .FSBox.file.file <Return> "
    global fsBoxFSName
    global fsBoxFSPath
    global fsBoxFSInternalPath
    set fsBoxFSName \[.FSBox.file.file get\]
    set fsBoxFSPath \[.FSBox.path.path get\]
    set fsBoxFSInternalPath \[.FSBox.path.path get\]
    if {\"\[info commands XFDestroy\]\" != \"\"} {
      catch {XFDestroy .FSBox}
    } {
      catch {destroy .FSBox}
    }"
  bind .FSBox.file.file <Up> {
    .FSBox.path.path cursor end
    focus .FSBox.path.path}
  bind .FSBox.file.file <Down> {
    .FSBox.pattern.pattern cursor end
    focus .FSBox.pattern.pattern}

  bind .FSBox.pattern.pattern <Delete> {
    EntryBS %W}
  bind .FSBox.pattern.pattern <BackSpace> {
    EntryBS %W}
  bind .FSBox.pattern.pattern <Right> {
    %W cursor [expr [%W index cursor]+1]
    EntryV2C %W }
  bind .FSBox.pattern.pattern <Left> {
    %W cursor [expr [%W index cursor]-1]
    EntryV2C %W }
  bind .FSBox.pattern.pattern <Control-a> {
    %W cursor 0
    %W view 0}
  bind .FSBox.pattern.pattern <Control-b> {
    %W cursor [expr [%W index cursor]-1]
    EntryV2C %W}
  bind .FSBox.pattern.pattern <Control-d> {
    %W delete [%W index cursor]
    EntryV2C %W }
  bind .FSBox.pattern.pattern <Control-e> {
    %W cursor end
    EntryV2C %W}
  bind .FSBox.pattern.pattern <Control-f> {
    %W cursor [expr [%W index cursor]+1]
    EntryV2C %W}
  bind .FSBox.pattern.pattern <Control-h> {
    EntryBS %W}
  bind .FSBox.pattern.pattern <Meta-h> {
    %W delete 0 cursor
    %W view cursor}
  bind .FSBox.pattern.pattern <Control-i> {
    %W insert cursor \t}
  bind .FSBox.pattern.pattern <Control-k> {
    %W delete cursor end
    EntryV2C %W}
  bind .FSBox.pattern.pattern <Control-l> {
    EntryV2C %W}
  bind .FSBox.pattern.pattern <Control-t> {
    set contents [%W get]
    set char1 [string index $contents [expr [%W index cursor]-2]]
    set char2 [string index $contents [expr [%W index cursor]-1]]
    %W delete [expr [%W index cursor]-2] [expr [%W index cursor]-1]
    %W insert [%W index cursor] "$char2$char1"
    %W cursor [expr [%W index cursor]+1]
    EntryV2C %W}
  bind .FSBox.pattern.pattern <Control-v> {
    %W insert cursor "[GetSelection]"}
  bind .FSBox.pattern.pattern <Control-w> {
    catch "%W delete sel.first sel.last"
    EntryV2C %W}
  bind .FSBox.pattern.pattern <Control-y> {
    %W insert cursor "[GetSelection]"}
  bind .FSBox.pattern.pattern <space> {
    %W insert cursor " "
    EntryV2C %W}
  bind .FSBox.pattern.pattern <Any-Key> {
    %W insert cursor "%A"
    EntryV2C %W}
  bind .FSBox.pattern.pattern <Return> {
    global fsBoxFSAll
    FSBoxFSShow [.FSBox.path.path get]       [.FSBox.pattern.pattern get] $fsBoxFSAll}
  bind .FSBox.pattern.pattern <Up> {
    .FSBox.file.file cursor end
    focus .FSBox.file.file}
  catch "bind .FSBox.pattern.pattern <Down> {}"

  # packing
  pack append .FSBox.files               .FSBox.files.vscroll {left filly}               .FSBox.files.hscroll {bottom fillx}               .FSBox.files.files {left fill expand}
  pack append .FSBox.file               .FSBox.file.labelfile {left}               .FSBox.file.file {left fill expand}
  pack append .FSBox.frame1               .FSBox.frame1.ok {left fill expand}               .FSBox.frame1.rescan {left fill expand}               .FSBox.frame1.cancel {left fill expand}
  pack append .FSBox.path.paths               .FSBox.path.paths.paths {left}
  pack append .FSBox.pattern.patterns               .FSBox.pattern.patterns.patterns {left}
  pack append .FSBox.path               .FSBox.path.paths {left}               .FSBox.path.path {left fill expand}
  pack append .FSBox.pattern               .FSBox.pattern.patterns {left}               .FSBox.pattern.all {right fill}               .FSBox.pattern.pattern {left fill expand}
  pack append .FSBox               .FSBox.message1 {top fill}               .FSBox.frame1 {bottom fill}               .FSBox.pattern {bottom fill}               .FSBox.file {bottom fill}               .FSBox.path {bottom fill}               .FSBox.files {left fill expand}

  # wait for the box to be destroyed
  grab .FSBox
  tkwait window .FSBox

  if {"[string trim $fsBoxFSPath]" != "" ||
      "[string trim $fsBoxFSName]" != ""} {
    return [string trimright [string trim $fsBoxFSPath] /]/[string trimleft [string trim $fsBoxFSName] /]
  }
}


# Procedure: FSBoxBindSelectOne
proc FSBoxBindSelectOne { fsBoxW fsBoxY} {

  set fsBoxNearest [$fsBoxW nearest $fsBoxY]
  if {$fsBoxNearest >= 0} {
    $fsBoxW select from $fsBoxNearest
    $fsBoxW select to $fsBoxNearest
  }
}


# Procedure: FSBoxFSFileSelect
proc FSBoxFSFileSelect { fsBoxW fsBoxY} {
  global fsBoxFSName
  global fsBoxFSInternalPath

  set fsBoxNearest [$fsBoxW nearest $fsBoxY]
  if {$fsBoxNearest >= 0} {
    set fsBoxTmpEntry [$fsBoxW get $fsBoxNearest]
    if {"/" == "[string index $fsBoxTmpEntry           [expr [string length $fsBoxTmpEntry]-1]]" ||
        "@" == "[string index $fsBoxTmpEntry           [expr [string length $fsBoxTmpEntry]-1]]"} {
      set fsBoxFileName [string range $fsBoxTmpEntry 0             [expr [string length $fsBoxTmpEntry]-2]]
      if {![IsADir [string trimright $fsBoxFSInternalPath/$fsBoxFileName @]] &&
          ![IsASymlink [string trimright $fsBoxFSInternalPath/$fsBoxFileName @]]} {
        set fsBoxFileName $fsBoxTmpEntry
      }
    } {
      if {"*" == "[string index $fsBoxTmpEntry             [expr [string length $fsBoxTmpEntry]-1]]"} {
        set fsBoxFileName [string range $fsBoxTmpEntry 0               [expr [string length $fsBoxTmpEntry]-2]]
        if {![file executable $fsBoxFSInternalPath/$fsBoxFileName]} {
          set fsBoxFileName $fsBoxTmpEntry
        }
      } {
        set fsBoxFileName $fsBoxTmpEntry
      }
    }
    if {![IsADir [string trimright $fsBoxFSInternalPath/$fsBoxFileName @]]} {
      set fsBoxFSName $fsBoxFileName
      .FSBox.file.file delete 0 end
      .FSBox.file.file insert 0 $fsBoxFSName
    }
  }
}


# Procedure: FSBoxFSFileSelectDouble
proc FSBoxFSFileSelectDouble { fsBoxW fsBoxY} {
  global fsBoxFSAll
  global fsBoxFSName
  global fsBoxFSPath
  global fsBoxFSInternalPath

  set fsBoxNearest [$fsBoxW nearest $fsBoxY]
  if {$fsBoxNearest >= 0} {
    set fsBoxTmpEntry [$fsBoxW get $fsBoxNearest]
    if {"../" == "$fsBoxTmpEntry"} {
      set fsBoxTmpEntry [string trimright [string trimright [string trim $fsBoxFSInternalPath] /] @]
      if {[string length $fsBoxTmpEntry] <= 0} {
        return
      }
      FSBoxFSShow [file dirname $fsBoxTmpEntry]         [.FSBox.pattern.pattern get] $fsBoxFSAll
      .FSBox.path.path delete 0 end
      .FSBox.path.path insert 0 $fsBoxFSInternalPath
    } {
      if {"/" == "[string index $fsBoxTmpEntry             [expr [string length $fsBoxTmpEntry]-1]]" ||
          "@" == "[string index $fsBoxTmpEntry             [expr [string length $fsBoxTmpEntry]-1]]"} {
        set fsBoxFileName [string range $fsBoxTmpEntry 0               [expr [string length $fsBoxTmpEntry]-2]]
        if {![IsADir [string trimright $fsBoxFSInternalPath/$fsBoxFileName @]] &&
            ![IsASymlink [string trimright $fsBoxFSInternalPath/$fsBoxFileName @]]} {
          set fsBoxFileName $fsBoxTmpEntry
        }
      } {
        if {"*" == "[string index $fsBoxTmpEntry               [expr [string length $fsBoxTmpEntry]-1]]"} {
          set fsBoxFileName [string range $fsBoxTmpEntry 0                 [expr [string length $fsBoxTmpEntry]-2]]
          if {![file executable $fsBoxFSInternalPath/$fsBoxFileName]} {
            set fsBoxFileName $fsBoxTmpEntry
          }
        } {
          set fsBoxFileName $fsBoxTmpEntry
        }
      }
      if {[IsADir [string trimright $fsBoxFSInternalPath/$fsBoxFileName @]]} {
        if {"/" == "[string index $fsBoxFSInternalPath               [expr [string length $fsBoxFSInternalPath]-1]]"} {
           append fsBoxFSInternalPath $fsBoxFileName
        } {
          append fsBoxFSInternalPath / $fsBoxFileName
        }
        FSBoxFSShow $fsBoxFSInternalPath           [.FSBox.pattern.pattern get] $fsBoxFSAll
        .FSBox.path.path delete 0 end
        .FSBox.path.path insert 0 $fsBoxFSInternalPath
      } {
        set fsBoxFSName $fsBoxFileName
        set fsBoxFSPath $fsBoxFSInternalPath
        if {[string length [info commands XFDestroy]] > 0} {
          catch {XFDestroy .FSBox}
        } {
          catch {destroy .FSBox}
        }
      }
    }
  }
}


# Procedure: FSBoxFSInsertPath
proc FSBoxFSInsertPath {} {
  global fsBoxFSInternalPath

  set fsBoxLast [.FSBox.path.paths.paths.menu index last]
  set fsBoxNewEntry [string trimright [string trimright [.FSBox.path.path get] /] @]
  for {set fsBoxCounter 0} {$fsBoxCounter <= $fsBoxLast} {incr fsBoxCounter 1} {
    if {"$fsBoxNewEntry" ==           "[lindex [.FSBox.path.paths.paths.menu entryconfigure                     $fsBoxCounter -label] 4]"} {
      return
    }
  }
  if {$fsBoxLast < 9} {
    .FSBox.path.paths.paths.menu add command       -label "$fsBoxNewEntry"       -command "
        global fsBoxFSAll 
        FSBoxFSShow $fsBoxNewEntry           \[.FSBox.pattern.pattern get\] \$fsBoxFSAll
        .FSBox.path.path delete 0 end
        .FSBox.path.path insert 0 $fsBoxNewEntry"
  } {
    for {set fsBoxCounter 0} {$fsBoxCounter < $fsBoxLast} {incr fsBoxCounter 1} {
      .FSBox.path.paths.paths.menu entryconfigure         $fsBoxCounter -label           [lindex [.FSBox.path.paths.paths.menu entryconfigure             [expr $fsBoxCounter+1] -label] 4]
      .FSBox.path.paths.paths.menu entryconfigure $fsBoxCounter         -command "
          global fsBoxFSAll 
          FSBoxFSShow [lindex [.FSBox.path.paths.paths.menu entryconfigure             [expr $fsBoxCounter+1] -label] 4]             \[.FSBox.pattern.pattern get\] \$fsBoxFSAll
          .FSBox.path.path delete 0 end
          .FSBox.path.path insert 0 [lindex             [.FSBox.path.paths.paths.menu entryconfigure               [expr $fsBoxCounter+1] -label] 4]"
    }
    .FSBox.path.paths.paths.menu entryconfigure $fsBoxLast       -label "$fsBoxNewEntry"
    .FSBox.path.paths.paths.menu entryconfigure $fsBoxCounter       -command "
        global fsBoxFSAll 
        FSBoxFSShow \[.FSBox.path.path get\]           \[.FSBox.pattern.pattern get\] \$fsBoxFSAll
        .FSBox.path.path delete 0 end
        .FSBox.path.path insert 0 $fsBoxNewEntry"
  }
}


# Procedure: FSBoxFSNameComplete
proc FSBoxFSNameComplete { fsBoxType} {

  set fsBoxNewFile ""
  set fsBoxMatched ""
  if {"$fsBoxType" == "path"} {
    set fsBoxDirName [file dirname [.FSBox.path.path get]]
    set fsBoxFileName [file tail [.FSBox.path.path get]]
  } {
    set fsBoxDirName [file dirname [.FSBox.path.path get]/]
    set fsBoxFileName [file tail [.FSBox.file.file get]]
  }
  set fsBoxFoundCounter 0
  if {[IsADir [string trimright $fsBoxDirName @]]} {
    catch "exec ls $fsBoxDirName/" fsBoxResult
    set fsBoxCounter 0
    set fsBoxListLength [llength $fsBoxResult]
    while {$fsBoxCounter < $fsBoxListLength} {
      if {"$fsBoxFileName" == ""} {
        if {$fsBoxFoundCounter == 0} {
          set fsBoxNewFile [lindex $fsBoxResult $fsBoxCounter]
        } {
          set fsBoxCounter1 0
          set fsBoxTmpFile1 $fsBoxNewFile
          set fsBoxTmpFile2 [lindex $fsBoxResult $fsBoxCounter]
          set fsBoxLength1 [string length $fsBoxTmpFile1]
          set fsBoxLength2 [string length $fsBoxTmpFile2]
          set fsBoxNewFile ""
          if {$fsBoxLength1 > $fsBoxLength2} {
            set fsBoxLength1 $fsBoxLength2
          }
          while {$fsBoxCounter1 < $fsBoxLength1} {
            if {"[string index $fsBoxTmpFile1 $fsBoxCounter1]" ==                   "[string index $fsBoxTmpFile2 $fsBoxCounter1]"} {
              append fsBoxNewFile [string index $fsBoxTmpFile1 $fsBoxCounter1]
            } {
              break
            }
            incr fsBoxCounter1 1
          }
        }
        incr fsBoxFoundCounter 1
      } {
        if {[regexp "^$fsBoxFileName" [lindex $fsBoxResult $fsBoxCounter]               fsBoxMatched]} {
          if {$fsBoxFoundCounter == 0} {
            set fsBoxNewFile [lindex $fsBoxResult $fsBoxCounter]
          } {
            set fsBoxCounter1 0
            set fsBoxTmpFile1 $fsBoxNewFile
            set fsBoxTmpFile2 [lindex $fsBoxResult $fsBoxCounter]
            set fsBoxLength1 [string length $fsBoxTmpFile1]
            set fsBoxLength2 [string length $fsBoxTmpFile2]
            set fsBoxNewFile ""
            if {$fsBoxLength1 > $fsBoxLength2} {
              set fsBoxLength1 $fsBoxLength2
            }
            while {$fsBoxCounter1 < $fsBoxLength1} {
              if {"[string index $fsBoxTmpFile1 $fsBoxCounter1]" ==                     "[string index $fsBoxTmpFile2 $fsBoxCounter1]"} {
                append fsBoxNewFile [string index $fsBoxTmpFile1 $fsBoxCounter1]
              } {
                break
              }
              incr fsBoxCounter1 1
            }
          }
          incr fsBoxFoundCounter 1
        }
      }
      incr fsBoxCounter 1
    }
  }
  if {$fsBoxFoundCounter == 1} {
    if {[IsADir [string trimright $fsBoxDirName/$fsBoxNewFile @]]} {
      if {"/" == "$fsBoxDirName"} {
        .FSBox.path.path delete 0 end
        .FSBox.path.path insert 0 "/[string trimright [string trim $fsBoxNewFile /] @]/"
      } {
        .FSBox.path.path delete 0 end
        .FSBox.path.path insert 0 "[string trimright $fsBoxDirName /]/[string trimright [string trim $fsBoxNewFile /] @]/"
      }
    } {
      .FSBox.path.path delete 0 end
      .FSBox.path.path insert 0 "[string trimright [string trimright $fsBoxDirName /] @]/"
      .FSBox.file.file delete 0 end
      .FSBox.file.file insert 0 "$fsBoxNewFile"
      .FSBox.file.file cursor end
      focus .FSBox.file.file
    }
  } {
    if {[IsADir [string trimright $fsBoxDirName/$fsBoxNewFile @]] ||
        "$fsBoxType" == "path"} {
      .FSBox.path.path delete 0 end
      .FSBox.path.path insert 0 "[string trimright $fsBoxDirName /]/[string trimright [string trim $fsBoxNewFile /] @]"
    } {
      .FSBox.path.path delete 0 end
      .FSBox.path.path insert 0 "$fsBoxDirName"
      if {[string length $fsBoxNewFile] > 0} {
        .FSBox.file.file delete 0 end
        .FSBox.file.file insert 0 "$fsBoxNewFile"
        .FSBox.file.file cursor end
        focus .FSBox.file.file
      }
    }
  }
}


# Procedure: FSBoxFSShow
proc FSBoxFSShow { fsBoxPath fsBoxPattern fsBoxAll} {
  global fsBoxActiveBackground
  global fsBoxActiveForeground
  global fsBoxBackground
  global fsBoxExtensions
  global fsBoxFont
  global fsBoxForeground
  global fsBoxScrollActiveForeground
  global fsBoxScrollBackground
  global fsBoxScrollForeground
  global fsBoxFSInternalPath
  global fsBoxFSPattern

  set fsBoxFSPattern $fsBoxPattern
  if {[file exists $fsBoxPath] &&
      [file readable $fsBoxPath] &&
      [file isdirectory $fsBoxPath]} {
    set fsBoxFSInternalPath $fsBoxPath
    .FSBox.path.path delete 0 end
    .FSBox.path.path insert 0 "$fsBoxFSInternalPath"
  } {
    if {[file exists $fsBoxPath] &&
        [file readable $fsBoxPath] &&
        [file isfile $fsBoxPath]} {
      set fsBoxFSInternalPath [file dirname $fsBoxPath]
      .FSBox.path.path delete 0 end
      .FSBox.path.path insert 0 "$fsBoxFSInternalPath"
      .FSBox.file.file delete 0 end
      .FSBox.file.file insert 0 [file tail $fsBoxPath]
      set fsBoxPath $fsBoxFSInternalPath
    } {
      while {"$fsBoxPath" != "" &&
             "$fsBoxPath" != "/" &&
             ![file isdirectory $fsBoxPath]} {
        set fsBoxFSInternalPath [file dirname $fsBoxPath]
       .FSBox.path.path delete 0 end
       .FSBox.path.path insert 0 "$fsBoxFSInternalPath"
        set fsBoxPath $fsBoxFSInternalPath
      }
      if {"$fsBoxPath" == ""} {
        set fsBoxPath "/"
        set fsBoxFSInternalPath "/"
      }
      .FSBox.path.path delete 0 end
      .FSBox.path.path insert 0 "$fsBoxFSInternalPath"
    }
  }

  if {[.FSBox.files.files size] > 0} {
    .FSBox.files.files delete 0 end
  }
  if {$fsBoxAll == 1} {
    if {[catch "exec ls -F -a $fsBoxPath" fsBoxResult]} {
      puts stderr "$fsBoxResult"
    }
  } {
    if {[catch "exec ls -F $fsBoxPath" fsBoxResult]} {
      puts stderr "$fsBoxResult"
    }
  }
  set fsBoxElementList [lsort $fsBoxResult]

  if {$fsBoxExtensions == 1} {
    foreach fsBoxCounter [winfo children .FSBox.pattern.patterns.patterns] {
      if {[string length [info commands XFDestroy]] > 0} {
        catch {XFDestroy $fsBoxCounter}
      } {
        catch {destroy $fsBoxCounter}
      }
    }
    menu .FSBox.pattern.patterns.patterns.menu       -activebackground "$fsBoxActiveBackground"       -activeforeground "$fsBoxActiveForeground"       -background "$fsBoxBackground"       -foreground "$fsBoxForeground"       -font "$fsBoxFont"

    .FSBox.pattern.patterns.patterns.menu add command       -label "*"       -command {
        global fsBoxFSAll
        global fsBoxFSPattern
        set fsBoxFSPattern "*"
        .FSBox.pattern.pattern delete 0 end
        .FSBox.pattern.pattern insert 0 $fsBoxFSPattern
        FSBoxFSShow [.FSBox.path.path get] $fsBoxFSPattern           $fsBoxFSAll}
  } {
    if {[.FSBox.pattern.patterns.patterns.menu index last] > 0} {
      foreach fsBoxCounter [winfo children .FSBox.pattern.patterns.patterns] {
        if {[string length [info commands XFDestroy]] > 0} {
          catch {XFDestroy $fsBoxCounter}
        } {
          catch {destroy $fsBoxCounter}
        }
      }
      menu .FSBox.pattern.patterns.patterns.menu         -activebackground "$fsBoxActiveBackground"         -activeforeground "$fsBoxActiveForeground"         -background "$fsBoxBackground"         -foreground "$fsBoxForeground"         -font "$fsBoxFont"    
    }
  }

  if {"/" != "$fsBoxPath"} {
    .FSBox.files.files insert end "../"
  }
  foreach fsBoxCounter $fsBoxElementList {
    if {[string match $fsBoxPattern $fsBoxCounter] ||
        [IsADir [string trimright $fsBoxPath/$fsBoxCounter @]]} {
      if {"../" != "$fsBoxCounter" &&
          "./" != "$fsBoxCounter"} {
        .FSBox.files.files insert end $fsBoxCounter
      }
    }

    if {$fsBoxExtensions == 1} {
      catch "file rootname $fsBoxCounter" fsBoxRootName
      catch "file extension $fsBoxCounter" fsBoxExtension
      set fsBoxExtension [string trim $fsBoxExtension /]
      set fsBoxExtension [string trim $fsBoxExtension *]
      set fsBoxExtension [string trim $fsBoxExtension @]
      if {[string length $fsBoxExtension] > 0 &&
          [string length $fsBoxRootName] > 0} {
        set fsBoxInsert 1
        set fsBoxLast [.FSBox.pattern.patterns.patterns.menu index last]
        for {set fsBoxCounter1 0} {$fsBoxCounter1 <= $fsBoxLast} {incr fsBoxCounter1 1} {
          if {"*$fsBoxExtension" ==                 "[lindex [.FSBox.pattern.patterns.patterns.menu entryconfigure                         $fsBoxCounter1 -label] 4]"} {
            set fsBoxInsert 0
          }
        }
	if {$fsBoxInsert == 1} {
          .FSBox.pattern.patterns.patterns.menu add command             -label "*$fsBoxExtension"             -command "
              global fsBoxFSAll
              global fsBoxFSPattern
              set fsBoxFSPattern \"*$fsBoxExtension\"
              .FSBox.pattern.pattern delete 0 end
              .FSBox.pattern.pattern insert 0 \$fsBoxFSPattern
              FSBoxFSShow \[.FSBox.path.path get\] \$fsBoxFSPattern                 \$fsBoxFSAll"
        }
      }
    }
  }
  if {$fsBoxExtensions == 1} {
    .FSBox.pattern.patterns.patterns.menu add separator
  }
  if {$fsBoxExtensions == 1 || 
      "[.FSBox.pattern.patterns.patterns.menu index last]" == "none"} {
    .FSBox.pattern.patterns.patterns.menu add checkbutton       -label "Scan extensions"       -variable "fsBoxExtensions"       -command {
        global fsBoxFSAll
        FSBoxFSShow [.FSBox.path.path get]           [.FSBox.pattern.pattern get] $fsBoxFSAll}
  }
}


# Procedure: FontBox
proc FontBox { {fontFileFont "/usr/local/lib/xf/lib/Fonts"} {fontMessage "Font:"}} {
  # Description: select a font
  # Arguments: fontFileFont - the font file with all fontnames
  #            fontMessage - a message to display
  # Returns: fontname
  # 
  # global fontBoxActiveBackground - active background color
  # global fontBoxActiveForeground - active foreground color
  # global fontBoxBackground - background color
  # global fontBoxFont - text font
  # global fontBoxForeground - foreground color
  # global fontBoxScrollActiveForeground - scrollbar active background color
  # global fontBoxScrollBackground - scrollbar background color
  # global fontBoxScrollForeground - scrollbar foreground color

  global fontBoxName
  global fontBoxFontFamily
  global fontBoxFontPixels
  global fontBoxFontSlant
  global fontBoxFontSWeight
  global fontBoxFontWeight
  global fontBoxActiveBackground
  global fontBoxActiveForeground
  global fontBoxBackground
  global fontBoxFont
  global fontBoxForeground
  global fontBoxScrollActiveForeground
  global fontBoxScrollBackground
  global fontBoxScrollForeground

  set fontBoxName ""
  set fontBoxFontFamily *
  set fontBoxFontPixels *
  set fontBoxFontSlant *
  set fontBoxFontSWeight *
  set fontBoxFontWeight *

  # get font file name
  if {!([file exists $fontFileFont] &&
        [file readable $fontFileFont])} {
    set fontFileFont ""
  }
  if {"$fontFileFont" == ""} {
    global env
    if {[info exists env(XF_FONT_FILE)]} {
      if {[file exists $env(XF_FONT_FILE)] &&
          [file readable $env(XF_FONT_FILE)]} {
        set fontFileFont $env(XF_FONT_FILE)
      }
    }
  }

  # build widget structure
  if {"[info commands XFDestroy]" != ""} {
    catch {XFDestroy .FontBox}
  } {
    catch {destroy .FontBox}
  }
  toplevel .FontBox     -background "$fontBoxBackground"     -borderwidth 0
  wm geometry .FontBox 600x300
  wm title .FontBox {Font box}
  wm maxsize .FontBox 1000 1000
  wm minsize .FontBox 100 90
  wm positionfrom .FontBox program
  wm sizefrom .FontBox user

  frame .FontBox.frame1     -background "$fontBoxBackground"     -borderwidth 0     -relief raised

  frame .FontBox.frame2     -background "$fontBoxBackground"     -borderwidth 2     -relief raised

  button .FontBox.frame1.ok     -activebackground "$fontBoxActiveBackground"     -activeforeground "$fontBoxActiveForeground"     -background "$fontBoxBackground"     -foreground "$fontBoxForeground"     -font "$fontBoxFont"     -text "OK"     -command "
      global fontBoxName
      set fontBoxName \[.FontBox.current.current get\]
      if {\"\[info commands XFDestroy\]\" != \"\"} {
        catch {XFDestroy .FontBox}
      } {
        catch {destroy .FontBox}
      }"

  button .FontBox.frame1.rescan     -activebackground "$fontBoxActiveBackground"     -activeforeground "$fontBoxActiveForeground"     -background "$fontBoxBackground"     -foreground "$fontBoxForeground"     -font "$fontBoxFont"     -text "Rescan fonts"     -command "
      if {\"$fontFileFont\" != \"\"} {
        exec xlsfonts > $fontFileFont
        if {\[.FontBox.fonts.fonts size\] > 0} {
          .FontBox.fonts.fonts delete 0 end
        }
        if {\[catch \"open $fontFileFont r\" fontInFile\]} {
          puts stderr \"\$fontInFile\"
        } {
          while {1 == 1} {
            if {\[gets \$fontInFile fontLine\] == -1} {
              break
            }
            .FontBox.fonts.fonts insert end \$fontLine
          }
          close \$fontInFile
        }
      }"

  button .FontBox.frame1.cancel     -activebackground "$fontBoxActiveBackground"     -activeforeground "$fontBoxActiveForeground"     -background "$fontBoxBackground"     -foreground "$fontBoxForeground"     -font "$fontBoxFont"     -text "Cancel"     -command "
      global fontBoxName
      set fontBoxName \"\"
      if {\"\[info commands XFDestroy\]\" != \"\"} {
        catch {XFDestroy .FontBox}
      } {
        catch {destroy .FontBox}
      }"

  label .FontBox.demo     -background "$fontBoxBackground"     -foreground "$fontBoxForeground"     -font "$fontBoxFont"     -relief raised     -text "This text shows the results :-)"

  frame .FontBox.current     -background "$fontBoxBackground"     -borderwidth 0     -relief raised

  label .FontBox.current.labelcurrent     -background "$fontBoxBackground"     -foreground "$fontBoxForeground"     -font "$fontBoxFont"     -relief raised     -text "$fontMessage"

  entry .FontBox.current.current     -background "$fontBoxBackground"     -foreground "$fontBoxForeground"     -font "$fontBoxFont"     -relief raised

  frame .FontBox.fonts     -background "$fontBoxBackground"     -borderwidth 0     -relief raised

  scrollbar .FontBox.fonts.vscroll     -activeforeground "$fontBoxScrollActiveForeground"     -background "$fontBoxScrollBackground"     -foreground "$fontBoxScrollForeground"     -relief raised     -command ".FontBox.fonts.fonts yview"

  scrollbar .FontBox.fonts.hscroll     -activeforeground "$fontBoxScrollActiveForeground"     -background "$fontBoxScrollBackground"     -foreground "$fontBoxScrollForeground"     -orient horiz     -relief raised     -command ".FontBox.fonts.fonts xview"

  listbox .FontBox.fonts.fonts     -background "$fontBoxBackground"     -foreground "$fontBoxForeground"     -font "$fontBoxFont"     -exportselection false     -relief raised     -xscrollcommand ".FontBox.fonts.hscroll set"     -yscrollcommand ".FontBox.fonts.vscroll set"

  # family menu
  menubutton .FontBox.frame2.family     -activebackground "$fontBoxActiveBackground"     -activeforeground "$fontBoxActiveForeground"     -background "$fontBoxBackground"     -foreground "$fontBoxForeground"     -font "$fontBoxFont"     -text "Family"     -underline 0     -menu ".FontBox.frame2.family.m"

  menu .FontBox.frame2.family.m     -activebackground "$fontBoxActiveBackground"     -activeforeground "$fontBoxActiveForeground"     -background "$fontBoxBackground"     -foreground "$fontBoxForeground"     -font "$fontBoxFont"

  .FontBox.frame2.family.m add radiobutton     -label "*"     -value "*"     -variable fontBoxFontFamily     -command "FontBoxComposeFont"
  .FontBox.frame2.family.m add radiobutton     -label "charter"     -value "charter"     -variable fontBoxFontFamily     -command "FontBoxComposeFont"
  .FontBox.frame2.family.m add radiobutton     -label "courier"     -value "courier"     -variable fontBoxFontFamily     -command "FontBoxComposeFont"
  .FontBox.frame2.family.m add radiobutton     -label "fixed"     -value "fixed"     -variable fontBoxFontFamily     -command "FontBoxComposeFont"
  .FontBox.frame2.family.m add radiobutton     -label "helvetica"     -value "helvetica"     -variable fontBoxFontFamily     -command "FontBoxComposeFont"
  .FontBox.frame2.family.m add radiobutton     -label "lucida"     -value "lucida"     -variable fontBoxFontFamily     -command "FontBoxComposeFont"
  .FontBox.frame2.family.m add radiobutton     -label "terminal"     -value "terminal"     -variable fontBoxFontFamily     -command "FontBoxComposeFont"
  .FontBox.frame2.family.m add radiobutton     -label "times"     -value "times"     -variable fontBoxFontFamily     -command "FontBoxComposeFont"

  # weight menu
  menubutton .FontBox.frame2.weight     -activebackground "$fontBoxActiveBackground"     -activeforeground "$fontBoxActiveForeground"     -background "$fontBoxBackground"     -foreground "$fontBoxForeground"     -font "$fontBoxFont"     -text "Weight"     -underline 0     -menu ".FontBox.frame2.weight.m"

  menu .FontBox.frame2.weight.m     -activebackground "$fontBoxActiveBackground"     -activeforeground "$fontBoxActiveForeground"     -background "$fontBoxBackground"     -foreground "$fontBoxForeground"     -font "$fontBoxFont"

  .FontBox.frame2.weight.m add radiobutton     -label "*"     -value "*"     -variable fontBoxFontWeight     -command "FontBoxComposeFont"
  .FontBox.frame2.weight.m add radiobutton     -label "bold"     -value "bold"     -variable fontBoxFontWeight     -command "FontBoxComposeFont"
  .FontBox.frame2.weight.m add radiobutton     -label "demibold"     -value "demibold"     -variable fontBoxFontWeight     -command "FontBoxComposeFont"
  .FontBox.frame2.weight.m add radiobutton     -label "medium"     -value "medium"     -variable fontBoxFontWeight     -command "FontBoxComposeFont"

  # Slant menu
  menubutton .FontBox.frame2.slant     -activebackground "$fontBoxActiveBackground"     -activeforeground "$fontBoxActiveForeground"     -background "$fontBoxBackground"     -foreground "$fontBoxForeground"     -font "$fontBoxFont"     -text "Slant"     -underline 0     -menu ".FontBox.frame2.slant.m"

  menu .FontBox.frame2.slant.m     -activebackground "$fontBoxActiveBackground"     -activeforeground "$fontBoxActiveForeground"     -background "$fontBoxBackground"     -foreground "$fontBoxForeground"     -font "$fontBoxFont"

  .FontBox.frame2.slant.m add radiobutton     -label "*"     -value "*"     -variable fontBoxFontSlant     -command "FontBoxComposeFont"
  .FontBox.frame2.slant.m add radiobutton     -label "i"     -value "i"     -variable fontBoxFontSlant     -command "FontBoxComposeFont"
  .FontBox.frame2.slant.m add radiobutton     -label "o"     -value "o"     -variable fontBoxFontSlant     -command "FontBoxComposeFont"
  .FontBox.frame2.slant.m add radiobutton     -label "r"     -value "r"     -variable fontBoxFontSlant     -command "FontBoxComposeFont"

  # Set width menu
  menubutton .FontBox.frame2.swidth     -activebackground "$fontBoxActiveBackground"     -activeforeground "$fontBoxActiveForeground"     -background "$fontBoxBackground"     -foreground "$fontBoxForeground"     -font "$fontBoxFont"     -text "Set width"     -underline 1     -menu ".FontBox.frame2.swidth.m"

  menu .FontBox.frame2.swidth.m     -activebackground "$fontBoxActiveBackground"     -activeforeground "$fontBoxActiveForeground"     -background "$fontBoxBackground"     -foreground "$fontBoxForeground"     -font "$fontBoxFont"

  .FontBox.frame2.swidth.m add radiobutton     -label "*"     -value "*"     -variable fontBoxFontSWidth     -command "FontBoxComposeFont"
  .FontBox.frame2.swidth.m add radiobutton     -label "normal"     -value "normal"     -variable fontBoxFontSWidth     -command "FontBoxComposeFont"
  .FontBox.frame2.swidth.m add radiobutton     -label "semicondensed"     -value "semicondensed"     -variable fontBoxFontSWidth     -command "FontBoxComposeFont"

  # pixels menu
  menubutton .FontBox.frame2.pixels     -activebackground "$fontBoxActiveBackground"     -activeforeground "$fontBoxActiveForeground"     -background "$fontBoxBackground"     -foreground "$fontBoxForeground"     -font "$fontBoxFont"     -text "Pixels"     -underline 0     -menu ".FontBox.frame2.pixels.m"

  menu .FontBox.frame2.pixels.m     -activebackground "$fontBoxActiveBackground"     -activeforeground "$fontBoxActiveForeground"     -background "$fontBoxBackground"     -foreground "$fontBoxForeground"     -font "$fontBoxFont"

  .FontBox.frame2.pixels.m add radiobutton     -label "*"     -value "*"     -variable fontBoxFontPixels     -command "FontBoxComposeFont"
  .FontBox.frame2.pixels.m add radiobutton     -label "6 pixels"     -value "6"     -variable fontBoxFontPixels     -command "FontBoxComposeFont"
  .FontBox.frame2.pixels.m add radiobutton     -label "8 pixels"     -value "8"     -variable fontBoxFontPixels     -command "FontBoxComposeFont"
  .FontBox.frame2.pixels.m add radiobutton     -label "10 pixels"     -value "10"     -variable fontBoxFontPixels     -command "FontBoxComposeFont"
  .FontBox.frame2.pixels.m add radiobutton     -label "12 pixels"     -value "12"     -variable fontBoxFontPixels     -command "FontBoxComposeFont"
  .FontBox.frame2.pixels.m add radiobutton     -label "13 pixels"     -value "13"     -variable fontBoxFontPixels     -command "FontBoxComposeFont"
  .FontBox.frame2.pixels.m add radiobutton     -label "14 pixels"     -value "14"     -variable fontBoxFontPixels     -command "FontBoxComposeFont"
  .FontBox.frame2.pixels.m add radiobutton     -label "16 pixels"     -value "16"     -variable fontBoxFontPixels     -command "FontBoxComposeFont"
  .FontBox.frame2.pixels.m add radiobutton     -label "18 pixels"     -value "18"     -variable fontBoxFontPixels     -command "FontBoxComposeFont"
  .FontBox.frame2.pixels.m add radiobutton     -label "24 pixels"     -value "24"     -variable fontBoxFontPixels     -command "FontBoxComposeFont"
  .FontBox.frame2.pixels.m add radiobutton     -label "28 pixels"     -value "28"     -variable fontBoxFontPixels     -command "FontBoxComposeFont"
  .FontBox.frame2.pixels.m add radiobutton     -label "30 pixels"     -value "30"     -variable fontBoxFontPixels     -command "FontBoxComposeFont"

  # read font file
  if {"$fontFileFont" != ""} {
    if {[catch "open $fontFileFont r" fontInFile]} {
      puts stderr "$fontInFile"
    } {
      while {1 == 1} {
        if {[gets $fontInFile fontLine] == -1} {
          break
        }
        .FontBox.fonts.fonts insert end $fontLine
      }
      close $fontInFile
    }
  }
  
  # init menus
  tk_menus .FontBox     .FontBox.frame2.family     .FontBox.frame2.weight     .FontBox.frame2.slant     .FontBox.frame2.swidth     .FontBox.frame2.pixels

  # bindings
  bind .FontBox.current.current <Delete> {
    EntryBS %W}
  bind .FontBox.current.current <BackSpace> {
    EntryBS %W}
  bind .FontBox.current.current <Right> {
    %W cursor [expr [%W index cursor]+1]
    EntryV2C %W }
  bind .FontBox.current.current <Left> {
    %W cursor [expr [%W index cursor]-1]
    EntryV2C %W }
  bind .FontBox.current.current <Control-a> {
    %W cursor 0
    %W view 0}
  bind .FontBox.current.current <Control-b> {
    %W cursor [expr [%W index cursor]-1]
    EntryV2C %W}
  bind .FontBox.current.current <Control-d> {
    %W delete [%W index cursor]
    EntryV2C %W }
  bind .FontBox.current.current <Control-e> {
    %W cursor end
    EntryV2C %W}
  bind .FontBox.current.current <Control-f> {
    %W cursor [expr [%W index cursor]+1]
    EntryV2C %W}
  bind .FontBox.current.current <Control-h> {
    EntryBS %W}
  bind .FontBox.current.current <Meta-h> {
    %W delete 0 cursor
    %W view cursor}
  bind .FontBox.current.current <Control-i> {
    %W insert cursor \t}
  bind .FontBox.current.current <Control-k> {
    %W delete cursor end
    EntryV2C %W}
  bind .FontBox.current.current <Control-l> {
    EntryV2C %W}
  bind .FontBox.current.current <Control-t> {
    set contents [%W get]
    set char1 [string index $contents [expr [%W index cursor]-2]]
    set char2 [string index $contents [expr [%W index cursor]-1]]
    %W delete [expr [%W index cursor]-2] [expr [%W index cursor]-1]
    %W insert [%W index cursor] "$char2$char1"
    %W cursor [expr [%W index cursor]+1]
    EntryV2C %W}
  bind .FontBox.current.current <Control-v> {
    %W insert cursor "[GetSelection]"}
  bind .FontBox.current.current <Control-w> {
    catch "%W delete sel.first sel.last"
    EntryV2C %W}
  bind .FontBox.current.current <Control-y> {
    %W insert cursor "[GetSelection]"}
  bind .FontBox.current.current <space> {
    %W insert cursor " "
    EntryV2C %W}
  bind .FontBox.current.current <Any-Key> {
    %W insert cursor "%A"
    EntryV2C %W}
  bind .FontBox.current.current <Return> "
    FontBoxSetFont"

  bind .FontBox.fonts.fonts <ButtonPress-1> "
    FontBoxSelectFont %W %y"
  bind .FontBox.fonts.fonts <Button1-Motion> "
    FontBoxSelectFont %W %y"
  bind .FontBox.fonts.fonts <Shift-ButtonPress-1> "
    FontBoxSelectFont %W %y"
  bind .FontBox.fonts.fonts <Shift-Button1-Motion> "
    FontBoxSelectFont %W %y"

  # packing
  pack append .FontBox.frame1               .FontBox.frame1.ok {left fill expand}               .FontBox.frame1.rescan {left fill expand}               .FontBox.frame1.cancel {left fill expand}
  pack append .FontBox.frame2               .FontBox.frame2.family {left}               .FontBox.frame2.weight {left}               .FontBox.frame2.slant {left}               .FontBox.frame2.swidth {left}               .FontBox.frame2.pixels {left}
  pack append .FontBox.current               .FontBox.current.labelcurrent {left}               .FontBox.current.current {left fill expand}
  pack append .FontBox.fonts               .FontBox.fonts.vscroll {left filly}               .FontBox.fonts.hscroll {bottom fillx}               .FontBox.fonts.fonts {left fill expand}

  if {"$fontFileFont" != ""} {
    pack append .FontBox                 .FontBox.frame1 {bottom fillx}                 .FontBox.current {bottom fillx}                 .FontBox.demo {bottom fillx}                 .FontBox.frame2 {top fill}                 .FontBox.fonts {left expand fill}
  } {
    wm geometry .FontBox 400x90
    pack append .FontBox                 .FontBox.frame1 {bottom fillx}                 .FontBox.current {bottom fillx}                 .FontBox.frame2 {top fill}                 .FontBox.demo {bottom fill expand}
  }

  # wait for the box to be destroyed
  grab .FontBox
  tkwait window .FontBox

  return $fontBoxName
}


# Procedure: FontBoxComposeFont
proc FontBoxComposeFont {} {
  global fontBoxFontFamily
  global fontBoxFontPixels
  global fontBoxFontSlant
  global fontBoxFontSWidth
  global fontBoxFontWeight
  
  if {"$fontBoxFontFamily" != "*"} {
    append fontNewFont * $fontBoxFontFamily
  } {
    append fontNewFont *
  }
  if {"$fontBoxFontWeight" != "*"} {
    append fontNewFont - $fontBoxFontWeight
  } {
    append fontNewFont - *
  }
  if {"$fontBoxFontSlant" != "*"} {
    append fontNewFont - $fontBoxFontSlant
  } {
    append fontNewFont - *
  }
  if {"$fontBoxFontSWidth" != "*"} {
    append fontNewFont - $fontBoxFontSWidth
  } {
    append fontNewFont - *
  }
  append fontNewFont - *
  if {"$fontBoxFontPixels" != "*"} {
    append fontNewFont - $fontBoxFontPixels
  } {
    append fontNewFont -
  }
  append fontNewFont *

  .FontBox.current.current delete 0 end
  .FontBox.current.current insert 0 $fontNewFont
  catch ".FontBox.demo configure     -font $fontNewFont"
}


# Procedure: FontBoxSelectFont
proc FontBoxSelectFont { fontW fontY} {

  set fontNearest [$fontW nearest $fontY]
  if {$fontNearest >= 0} {
    $fontW select from $fontNearest
    $fontW select to $fontNearest
    .FontBox.current.current delete 0 end
    .FontBox.current.current insert 0 [$fontW get $fontNearest]
    FontBoxSetFont
  }
}


# Procedure: FontBoxSetFont
proc FontBoxSetFont {} {

  if {"[.FontBox.current.current get]" != ""} {
    catch ".FontBox.demo configure -font       [.FontBox.current.current get]"
  }
}


# Procedure: GetSelection
if {[string length [info procs GetSelection]] == 0} {
proc GetSelection {} {

  # the save way
  set xfSelection ""
  catch "selection get" xfSelection
  return $xfSelection
}
}


# Procedure: IsADir
proc IsADir { pathName} {

  if {[file isdirectory $pathName]} {
    return 1
  } {
    catch "file type $pathName" fileType
    if {"$fileType" == "link"} {
      if {[catch "file readlink $pathName" linkName]} {
        return 0
      }
      catch "file type $linkName" fileType
      while {"$fileType" == "link"} {
        if {[catch "file readlink $linkName" linkName]} {
          return 0
        }
      }
      return [file isdirectory $linkName]
    }
  }
  return 0
}


# Procedure: IsASymlink
proc IsASymlink { fileName} {

  catch "file type $fileName" fileType
  if {"$fileType" == "link"} {
    return 1
  }
  return 0
}


# Procedure: MenuConf
proc MenuConf { args} {
  # Description: configure the menubutton and menus of
  #              the given pathnames
  # Arguments: args - the widget pathnames we configure
  # Returns: none
  # 
  # global menuConfActiveBackground - active background color
  # global menuConfActiveForeground - active foreground color
  # global menuConfBackground - background color
  # global menuConfFont - text font
  # global menuConfForeground - foreground color
  # global menuConfScrollActiveForeground - scrollbar active background color
  # global menuConfScrollBackground - scrollbar background color
  # global menuConfScrollForeground - scrollbar foreground color

  global menuConfPathNames
  global menuConfActiveBackground
  global menuConfActiveForeground
  global menuConfBackground
  global menuConfFont
  global menuConfForeground
  global menuConfScrollActiveForeground
  global menuConfScrollBackground
  global menuConfScrollForeground

  if {[llength $args] == 0} {
    set menuConfConfig $menuConfPathNames
  } {
    set menuConfConfig $args
  }

  # build widget structure
  if {"[info commands XFDestroy]" != ""} {
    catch {XFDestroy .MenuConf}
  } {
    catch {destroy .MenuConf}
  }
  toplevel .MenuConf     -background "$menuConfBackground"     -borderwidth 0
  wm geometry .MenuConf 530x400
  wm title .MenuConf {Menu configuration}
  wm maxsize .MenuConf 1000 1000
  wm minsize .MenuConf 100 100
  wm positionfrom .MenuConf program
  wm sizefrom .MenuConf user

  frame .MenuConf.frame1     -background "$menuConfBackground"     -borderwidth 0     -relief raised
 
  frame .MenuConf.frame1.frame2     -background "$menuConfBackground"     -borderwidth 0     -relief raised
 
  frame .MenuConf.frame1.frame2.frame4     -background "$menuConfBackground"     -borderwidth 0     -relief raised
 
  frame .MenuConf.frame1.frame2.frame5     -background "$menuConfBackground"     -borderwidth 0     -relief raised
 
  frame .MenuConf.frame1.frame2.frame6     -background "$menuConfBackground"     -borderwidth 0     -relief raised
 
  frame .MenuConf.frame1.frame2.frame8     -background "$menuConfBackground"     -borderwidth 0     -relief raised
 
  frame .MenuConf.frame1.frame7     -background "$menuConfBackground"     -borderwidth 0     -relief raised
 
  frame .MenuConf.frame1.frame3     -background "$menuConfBackground"     -borderwidth 0     -relief raised
 
  scrollbar .MenuConf.frame1.frame2.frame5.vscroll     -activeforeground "$menuConfScrollActiveForeground"     -background "$menuConfScrollBackground"     -foreground "$menuConfScrollForeground"     -relief raised     -command ".MenuConf.frame1.frame2.frame5.buttons yview"

  scrollbar .MenuConf.frame1.frame2.frame5.hscroll     -activeforeground "$menuConfScrollActiveForeground"     -background "$menuConfScrollBackground"     -foreground "$menuConfScrollForeground"     -orient horiz     -relief raised     -command ".MenuConf.frame1.frame2.frame5.buttons xview"

  listbox .MenuConf.frame1.frame2.frame5.buttons     -background "$menuConfBackground"     -foreground "$menuConfForeground"     -font "$menuConfFont"     -exportselection false     -relief raised     -xscrollcommand ".MenuConf.frame1.frame2.frame5.hscroll set"     -yscrollcommand ".MenuConf.frame1.frame2.frame5.vscroll set"

  scrollbar .MenuConf.frame1.frame2.frame6.vscroll     -activeforeground "$menuConfScrollActiveForeground"     -background "$menuConfScrollBackground"     -foreground "$menuConfScrollForeground"     -relief raised     -command ".MenuConf.frame1.frame2.frame6.menus yview"

  scrollbar .MenuConf.frame1.frame2.frame6.hscroll     -activeforeground "$menuConfScrollActiveForeground"     -background "$menuConfScrollBackground"     -foreground "$menuConfScrollForeground"     -orient horiz     -relief raised     -command ".MenuConf.frame1.frame2.frame6.menus xview"

  listbox .MenuConf.frame1.frame2.frame6.menus     -background "$menuConfBackground"     -foreground "$menuConfForeground"     -font "$menuConfFont"     -exportselection false     -relief raised     -xscrollcommand ".MenuConf.frame1.frame2.frame6.hscroll set"     -yscrollcommand ".MenuConf.frame1.frame2.frame6.vscroll set"

  scrollbar .MenuConf.frame1.frame2.frame8.vscroll     -activeforeground "$menuConfScrollActiveForeground"     -background "$menuConfScrollBackground"     -foreground "$menuConfScrollForeground"     -relief raised     -command ".MenuConf.frame1.frame2.frame8.menu yview"

  scrollbar .MenuConf.frame1.frame2.frame8.hscroll     -activeforeground "$menuConfScrollActiveForeground"     -background "$menuConfScrollBackground"     -foreground "$menuConfScrollForeground"     -orient horiz     -relief raised     -command ".MenuConf.frame1.frame2.frame8.menu xview"

  listbox .MenuConf.frame1.frame2.frame8.menu     -background "$menuConfBackground"     -foreground "$menuConfForeground"     -font "$menuConfFont"     -exportselection false     -relief raised     -xscrollcommand ".MenuConf.frame1.frame2.frame8.hscroll set"     -yscrollcommand ".MenuConf.frame1.frame2.frame8.vscroll set"

  scale .MenuConf.frame1.frame2.frame8.mover     -activeforeground "$menuConfScrollActiveForeground"     -background "$menuConfBackground"     -foreground "$menuConfForeground"     -orient vertical     -width 8     -relief raised     -sliderlength 15     -from 0     -command "MenuConfReposition"

  button .MenuConf.frame1.frame7.insert     -activebackground "$menuConfActiveBackground"     -activeforeground "$menuConfActiveForeground"     -background "$menuConfBackground"     -foreground "$menuConfForeground"     -font "$menuConfFont"     -text "Append"     -command "
      MenuConfInsert \"$menuConfConfig\""

  button .MenuConf.frame1.frame7.modify     -activebackground "$menuConfActiveBackground"     -activeforeground "$menuConfActiveForeground"     -background "$menuConfBackground"     -foreground "$menuConfForeground"     -font "$menuConfFont"     -text "Modify"     -command "
      MenuConfModify \"$menuConfConfig\""

  button .MenuConf.frame1.frame7.modifymenu     -activebackground "$menuConfActiveBackground"     -activeforeground "$menuConfActiveForeground"     -background "$menuConfBackground"     -foreground "$menuConfForeground"     -font "$menuConfFont"     -text "Modify menu"     -command {
      set curSelected [.MenuConf.frame1.frame2.frame6.menus curselection]
      if {$curSelected >= 0} {
        place forget .MenuConf.frame1.frame2.frame5
        place forget .MenuConf.frame1.frame2.frame6
        place .MenuConf.frame1.frame2.frame8           -in .MenuConf.frame1.frame2           -relx 0.5           -rely 0           -relheight 1.0           -relwidth 0.5
        pack unpack .MenuConf.frame1.frame7.modifymenu
        pack append .MenuConf.frame1.frame7                     .MenuConf.frame1.frame7.insert {left fill expand}                     .MenuConf.frame1.frame7.modify {left fill expand}                     .MenuConf.frame1.frame7.modifyback {left fill expand}                     .MenuConf.frame1.frame7.delete {left fill expand}
        update idletask
        MenuConfSetItems command
        MenuConfReadMenu           [.MenuConf.frame1.frame2.frame6.menus get $curSelected]
        case [lindex [.MenuConf.frame1.frame2.frame4.items.message1 config -text] 4] in {
          {Cascadebutton} {
            .MenuConf.frame1.frame2.frame4.items.items.m invoke 0
          }
          {Checkbutton} {
            .MenuConf.frame1.frame2.frame4.items.items.m invoke 1
          }
          {Radiobutton} {
            .MenuConf.frame1.frame2.frame4.items.items.m invoke 3
          }
          {Separator} {
            .MenuConf.frame1.frame2.frame4.items.items.m invoke 4
          }
          {default} {
            .MenuConf.frame1.frame2.frame4.items.items.m invoke 2
          }
        }
        MenuConfSetItem
      }}

  button .MenuConf.frame1.frame7.modifyback     -activebackground "$menuConfActiveBackground"     -activeforeground "$menuConfActiveForeground"     -background "$menuConfBackground"     -foreground "$menuConfForeground"     -font "$menuConfFont"     -text "Back to main"     -command {
      place forget .MenuConf.frame1.frame2.frame8
      if {[.MenuConf.frame1.frame2.frame5.buttons size] > 0} {
        place .MenuConf.frame1.frame2.frame5           -in .MenuConf.frame1.frame2           -relx 0.5           -rely 0           -relheight 0.5           -relwidth 0.5
        place .MenuConf.frame1.frame2.frame6           -in .MenuConf.frame1.frame2           -relx 0.5           -rely 0.5           -relheight 0.5           -relwidth 0.5
      } {
        place .MenuConf.frame1.frame2.frame6           -in .MenuConf.frame1.frame2           -relx 0.5           -rely 0           -relheight 1           -relwidth 0.5
      }
      update idletask
      pack unpack .MenuConf.frame1.frame7.modifyback
      pack append .MenuConf.frame1.frame7                   .MenuConf.frame1.frame7.insert {left fill expand}                   .MenuConf.frame1.frame7.modify {left fill expand}                   .MenuConf.frame1.frame7.modifymenu {left fill expand}                   .MenuConf.frame1.frame7.delete {left fill expand}
      MenuConfSetItem}

  button .MenuConf.frame1.frame7.delete     -activebackground "$menuConfActiveBackground"     -activeforeground "$menuConfActiveForeground"     -background "$menuConfBackground"     -foreground "$menuConfForeground"     -font "$menuConfFont"     -text "Delete"     -command "
      if {\[.MenuConf.frame1.frame2.frame6.menus size\] > 0} {
        MenuConfDelete \"$menuConfConfig\"
      }"

  button .MenuConf.frame1.frame3.ok     -activebackground "$menuConfActiveBackground"     -activeforeground "$menuConfActiveForeground"     -background "$menuConfBackground"     -foreground "$menuConfForeground"     -font "$menuConfFont"     -text "OK"     -command "
      if {\"\[info commands XFDestroy\]\" != \"\"} {
        catch {XFDestroy .MenuConf}
      } {
        catch {destroy .MenuConf}
      }"

  button .MenuConf.frame1.frame3.save     -activebackground "$menuConfActiveBackground"     -activeforeground "$menuConfActiveForeground"     -background "$menuConfBackground"     -foreground "$menuConfForeground"     -font "$menuConfFont"     -text "Save"     -command "MenuConfSave"

  frame .MenuConf.frame1.frame2.frame4.items     -background "$menuConfBackground"     -borderwidth 0     -relief raised
 
  menubutton .MenuConf.frame1.frame2.frame4.items.items     -activebackground "$menuConfActiveBackground"     -activeforeground "$menuConfActiveForeground"     -background "$menuConfBackground"     -foreground "$menuConfForeground"     -font "$menuConfFont"     -text "Menu entry:"     -menu ".MenuConf.frame1.frame2.frame4.items.items.m"

  menu .MenuConf.frame1.frame2.frame4.items.items.m     -activebackground "$menuConfActiveBackground"     -activeforeground "$menuConfActiveForeground"     -background "$menuConfBackground"     -foreground "$menuConfForeground"     -font "$menuConfFont"

  .MenuConf.frame1.frame2.frame4.items.items.m     add radiobutton       -label "Cascadebutton"       -variable menuConfCurrentMenuType       -value "<cascade> "       -command "MenuConfSetItems cascade"
  .MenuConf.frame1.frame2.frame4.items.items.m     add radiobutton       -label "Checkbutton"       -variable menuConfCurrentMenuType       -value "<checkbutton> "       -command "MenuConfSetItems check"
  .MenuConf.frame1.frame2.frame4.items.items.m     add radiobutton       -label "Commandbutton"       -variable menuConfCurrentMenuType       -value "<command> "       -command "MenuConfSetItems command"
  .MenuConf.frame1.frame2.frame4.items.items.m     add radiobutton       -label "Radiobutton"       -variable menuConfCurrentMenuType       -value "<radiobutton> "       -command "MenuConfSetItems radio"
  .MenuConf.frame1.frame2.frame4.items.items.m     add radiobutton       -label "Separator"       -variable menuConfCurrentMenuType       -value "<separator> "       -command "MenuConfSetItems separator"
  
  label .MenuConf.frame1.frame2.frame4.items.message1     -background "$menuConfBackground"     -foreground "$menuConfForeground"     -font "$menuConfFont"     -anchor w     -text "Commandbutton"
  
  MenuConfEntry accelerator "Accelerator:"
  MenuConfEntry actbg "Active background:"
  MenuConfScale actborder "Active borderwidth:" "pixels" 40
  MenuConfEntry actfg "Active foreground:"
  MenuConfEntry bg "Background:"
  MenuConfEntry bitmap "Bitmap:"
  MenuConfScale border "Borderwidth:" "pixels" 40
  MenuConfEntry font "Font:"
  MenuConfEntry fg "Foreground:"
  MenuConfEntry label "Label:"
  MenuConfEntry menu "Menu:"
  MenuConfEntry name "Menu name:"
  MenuConfEntry offvalue "Offvalue:"
  MenuConfEntry onvalue "Onvalue:"
  MenuConfScaleDouble size "Size:" "Width" "Height" 300 300

  frame .MenuConf.frame1.frame2.frame4.state     -background "$menuConfBackground"     -borderwidth 0     -relief raised
 
  label .MenuConf.frame1.frame2.frame4.state.message1     -background "$menuConfBackground"     -foreground "$menuConfForeground"     -font "$menuConfFont"     -anchor w     -relief raised     -text "State:"

  radiobutton .MenuConf.frame1.frame2.frame4.state.normal     -activebackground "$menuConfActiveBackground"     -activeforeground "$menuConfActiveForeground"     -background "$menuConfBackground"     -foreground "$menuConfForeground"     -font "$menuConfFont"     -text "Normal"     -variable menuConfState

  radiobutton .MenuConf.frame1.frame2.frame4.state.active     -activebackground "$menuConfActiveBackground"     -activeforeground "$menuConfActiveForeground"     -background "$menuConfBackground"     -foreground "$menuConfForeground"     -font "$menuConfFont"     -text "Active"     -variable menuConfState

  radiobutton .MenuConf.frame1.frame2.frame4.state.disabled     -activebackground "$menuConfActiveBackground"     -activeforeground "$menuConfActiveForeground"     -background "$menuConfBackground"     -foreground "$menuConfForeground"     -font "$menuConfFont"     -text "Disabled"     -variable menuConfState

  pack append .MenuConf.frame1.frame2.frame4.state               .MenuConf.frame1.frame2.frame4.state.message1 {left}               .MenuConf.frame1.frame2.frame4.state.normal {left fillx expand}               .MenuConf.frame1.frame2.frame4.state.active {left fillx expand}               .MenuConf.frame1.frame2.frame4.state.disabled {left fillx expand}

  MenuConfEntry textvar "Text variable:"

  MenuConfScale underline "Underline:" "" 40
  .MenuConf.frame1.frame2.frame4.underline.underline config     -from -1

  MenuConfEntry value "Value:"
  MenuConfEntry variable "Variable:"

  label .MenuConf.frame1.frame2.frame4.message1     -background "$menuConfBackground"     -foreground "$menuConfForeground"     -font "$menuConfFont"     -anchor c     -relief raised     -text "Command:"
  
  frame .MenuConf.frame1.frame2.frame4.command     -background "$menuConfBackground"     -borderwidth 0     -relief raised

  text .MenuConf.frame1.frame2.frame4.command.command     -background "$menuConfBackground"     -foreground "$menuConfForeground"     -font "$menuConfFont"     -relief raised     -wrap none     -borderwidth 2     -yscrollcommand ".MenuConf.frame1.frame2.frame4.command.vscroll set"

  scrollbar .MenuConf.frame1.frame2.frame4.command.vscroll     -activeforeground "$menuConfScrollActiveForeground"     -background "$menuConfScrollBackground"     -foreground "$menuConfScrollForeground"     -relief raised     -command ".MenuConf.frame1.frame2.frame4.command.command yview"

  pack append .MenuConf.frame1.frame2.frame4.command               .MenuConf.frame1.frame2.frame4.command.vscroll {left filly}               .MenuConf.frame1.frame2.frame4.command.command {left fill expand}

  # bindings
  bind .MenuConf.frame1.frame2.frame4.command.command <Left> {
    %W mark set insert insert-1c
    %W yview -pickplace insert}
  bind .MenuConf.frame1.frame2.frame4.command.command <Right> {
    %W mark set insert insert+1c
    %W yview -pickplace insert}
  bind .MenuConf.frame1.frame2.frame4.command.command <Up> {
    %W mark set insert insert-1l
    %W yview -pickplace insert}
  bind .MenuConf.frame1.frame2.frame4.command.command <Down> {
    %W mark set insert insert+1l
    %W yview -pickplace insert}
  bind .MenuConf.frame1.frame2.frame4.command.command <Delete> {
    tk_textBackspace %W
    %W yview -pickplace insert}
  bind .MenuConf.frame1.frame2.frame4.command.command <Control-a> {
    %W mark set insert "insert linestart"
    %W yview -pickplace insert}
  bind .MenuConf.frame1.frame2.frame4.command.command <Control-b> {
    %W mark set insert insert-1c
    %W yview -pickplace insert}
  bind .MenuConf.frame1.frame2.frame4.command.command <Control-d> {
    %W delete insert insert+1c
    %W yview -pickplace insert}
  bind .MenuConf.frame1.frame2.frame4.command.command <Control-e> {
    %W mark set insert "insert lineend"
    %W yview -pickplace insert}
  bind .MenuConf.frame1.frame2.frame4.command.command <Control-f> {
    %W mark set insert insert+1c
    %W yview -pickplace insert}
  bind .MenuConf.frame1.frame2.frame4.command.command <Meta-h> {
    %W delete "insert linestart" insert
    %W yview -pickplace insert}
  bind .MenuConf.frame1.frame2.frame4.command.command <Control-i> {
    %W inser insert \t
    %W yview -pickplace insert}
  bind .MenuConf.frame1.frame2.frame4.command.command <Control-j> {
    %W inser insert \n
    %W yview -pickplace insert}
  bind .MenuConf.frame1.frame2.frame4.command.command <Control-k> {
    if {[%W compare insert == "insert lineend"]} {
      %W delete insert "insert lineend +1c"
      %W yview -pickplace insert
    } {
      %W delete insert "insert lineend"
      %W yview -pickplace insert
    }}
  bind .MenuConf.frame1.frame2.frame4.command.command <Control-l> {
    %W yview -pickplace insert}
  bind .MenuConf.frame1.frame2.frame4.command.command <Control-m> {
    %W inser insert \n
    %W yview -pickplace insert}
  bind .MenuConf.frame1.frame2.frame4.command.command <Control-n> {
    %W mark set insert insert+1l
    %W yview -pickplace insert}
  bind .MenuConf.frame1.frame2.frame4.command.command <Control-o> {
    %W inser insert \n
    %W yview -pickplace insert}
  bind .MenuConf.frame1.frame2.frame4.command.command <Control-p> {
    %W mark set insert insert-1l
    %W yview -pickplace insert}
  bind .MenuConf.frame1.frame2.frame4.command.command <Control-t> {
    set char1 [%W get insert-2c insert-1c]
    set char2 [%W get insert-1c insert]
    %W delete insert-2c insert
    %W insert insert "$char2$char1"
    %W mark set insert insert+1c
    %W yview -pickplace insert}
  bind .MenuConf.frame1.frame2.frame4.command.command <Meta-v> {
    set xfCounter [lindex [%W config -height] 4]
    while {$xfCounter > 0} {
      %W mark set insert insert-1l
      incr xfCounter -1
    }
    %W yview -pickplace insert}
  bind .MenuConf.frame1.frame2.frame4.command.command <Control-v> {
    set xfCounter [lindex [%W config -height] 4]
    while {$xfCounter > 0} {
      %W mark set insert insert+1l
      incr xfCounter -1
    }
    %W yview -pickplace insert}
  bind .MenuConf.frame1.frame2.frame4.command.command <Control-w> {
    catch "%W delete sel.first sel.last"}
  bind .MenuConf.frame1.frame2.frame4.command.command <Control-y> {
    %W insert insert "[GetSelection]"
    %W yview -pickplace insert}
  bind .MenuConf.frame1.frame2.frame4.command.command <Home> {
    %W mark set insert 1.0
    %W yview -pickplace insert}
  bind .MenuConf.frame1.frame2.frame4.command.command <End> {
    %W mark set insert end
    %W yview -pickplace insert}
  bind .MenuConf.frame1.frame2.frame4.command.command <Prior> {
    set xfCounter [lindex [%W config -height] 4]
    while {$xfCounter > 0} {
      %W mark set insert insert-1l
      incr xfCounter -1
    }
    %W yview -pickplace insert}
  bind .MenuConf.frame1.frame2.frame4.command.command <Next> {
    set xfCounter [lindex [%W config -height] 4]
    while {$xfCounter > 0} {
      %W mark set insert insert+1l
      incr xfCounter -1
    }
    %W yview -pickplace insert}

  bind .MenuConf.frame1.frame2.frame5.buttons <ButtonPress-1> {
   MenuConfSelect1 %W %y}
  bind .MenuConf.frame1.frame2.frame5.buttons <Button1-Motion> {
   MenuConfSelect1 %W %y}
  bind .MenuConf.frame1.frame2.frame5.buttons <Shift-ButtonPress-1> {
   MenuConfSelect1 %W %y}
  bind .MenuConf.frame1.frame2.frame5.buttons <Shift-Button1-Motion> {
   MenuConfSelect1 %W %y}

  bind .MenuConf.frame1.frame2.frame6.menus <ButtonPress-1> {
   MenuConfSelect1 %W %y}
  bind .MenuConf.frame1.frame2.frame6.menus <Button1-Motion> {
   MenuConfSelect1 %W %y}
  bind .MenuConf.frame1.frame2.frame6.menus <Shift-ButtonPress-1> {
   MenuConfSelect1 %W %y}
  bind .MenuConf.frame1.frame2.frame6.menus <Shift-Button1-Motion> {
   MenuConfSelect1 %W %y}

  bind .MenuConf.frame1.frame2.frame8.menu <ButtonPress-1> {
   MenuConfSelect2 %W %y}
  bind .MenuConf.frame1.frame2.frame8.menu <Button1-Motion> {
   MenuConfSelect2 %W %y}
  bind .MenuConf.frame1.frame2.frame8.menu <Shift-ButtonPress-1> {
   MenuConfSelect2 %W %y}
  bind .MenuConf.frame1.frame2.frame8.menu <Shift-Button1-Motion> {
   MenuConfSelect2 %W %y}

  bind .MenuConf.frame1.frame2.frame4.actbg.actbg <Double-ButtonPress-3> {
   global menuConfColorFile
   if {"[info commands ColorBox]" != ""} {
     set menuConfResult [ColorBox $menuConfColorFile "Active background:"]
     if {"$menuConfResult" != ""} {
       .MenuConf.frame1.frame2.frame4.actbg.actbg delete 0 end
       .MenuConf.frame1.frame2.frame4.actbg.actbg insert end $menuConfResult
     }
   }}

  bind .MenuConf.frame1.frame2.frame4.actfg.actfg <Double-ButtonPress-3> {
   global menuConfColorFile
   if {"[info commands ColorBox]" != ""} {
     set menuConfResult [ColorBox $menuConfColorFile "Active foreground:"]
     if {"$menuConfResult" != ""} {
       .MenuConf.frame1.frame2.frame4.actfg.actfg delete 0 end
       .MenuConf.frame1.frame2.frame4.actfg.actfg insert end $menuConfResult
     }
   }}

  bind .MenuConf.frame1.frame2.frame4.bg.bg <Double-ButtonPress-3> {
   global menuConfColorFile
   if {"[info commands ColorBox]" != ""} {
     set menuConfResult [ColorBox $menuConfColorFile "Background:"]
     if {"$menuConfResult" != ""} {
       .MenuConf.frame1.frame2.frame4.bg.bg delete 0 end
       .MenuConf.frame1.frame2.frame4.bg.bg insert end $menuConfResult
     }
   }}

  bind .MenuConf.frame1.frame2.frame4.bitmap.bitmap <Double-ButtonPress-3> {
   if {"[info commands FSBox]" != ""} {
     set menuConfResult [FSBox]
     if {"$menuConfResult" != ""} {
       .MenuConf.frame1.frame2.frame4.bitmap.bitmap delete 0 end
       .MenuConf.frame1.frame2.frame4.bitmap.bitmap insert end $menuConfResult
     }
   }}

  bind .MenuConf.frame1.frame2.frame4.font.font <Double-ButtonPress-3> {
   global menuConfFontFile
   if {"[info commands FontBox]" != ""} {
     set menuConfResult [FontBox $menuConfFontFile]
     if {"$menuConfResult" != ""} {
       .MenuConf.frame1.frame2.frame4.font.font delete 0 end
       .MenuConf.frame1.frame2.frame4.font.font insert end $menuConfResult
     }
   }}

  bind .MenuConf.frame1.frame2.frame4.fg.fg <Double-ButtonPress-3> {
   global menuConfColorFile
   if {"[info commands ColorBox]" != ""} {
     set menuConfResult [ColorBox $menuConfColorFile "Foreground:"]
     if {"$menuConfResult" != ""} {
       .MenuConf.frame1.frame2.frame4.fg.fg delete 0 end
       .MenuConf.frame1.frame2.frame4.fg.fg insert end $menuConfResult
     }
   }}

  MenuConfReadMenus $menuConfConfig

  # packing
  pack append .MenuConf.frame1.frame7               .MenuConf.frame1.frame7.insert {left fill expand}               .MenuConf.frame1.frame7.modify {left fill expand}               .MenuConf.frame1.frame7.modifymenu {left fill expand}               .MenuConf.frame1.frame7.delete {left fill expand}
  pack append .MenuConf.frame1.frame3               .MenuConf.frame1.frame3.ok {left fill expand}               .MenuConf.frame1.frame3.save {left fill expand}
  pack append .MenuConf.frame1.frame2.frame4.items               .MenuConf.frame1.frame2.frame4.items.items {left fill}               .MenuConf.frame1.frame2.frame4.items.message1 {left fill expand}
  pack append .MenuConf.frame1.frame2.frame4               .MenuConf.frame1.frame2.frame4.actbg {top fillx}               .MenuConf.frame1.frame2.frame4.actfg {top fillx}               .MenuConf.frame1.frame2.frame4.bg {top fillx}               .MenuConf.frame1.frame2.frame4.bitmap {top fillx}               .MenuConf.frame1.frame2.frame4.border {top fillx}               .MenuConf.frame1.frame2.frame4.font {top fillx}               .MenuConf.frame1.frame2.frame4.fg {top fillx}               .MenuConf.frame1.frame2.frame4.label {top fillx}               .MenuConf.frame1.frame2.frame4.menu {top fillx}               .MenuConf.frame1.frame2.frame4.size {top fillx}               .MenuConf.frame1.frame2.frame4.textvar {top fillx}               .MenuConf.frame1.frame2.frame4.underline {top fillx}               .MenuConf.frame1.frame2.frame4.variable {top fillx}
  pack append .MenuConf.frame1.frame2.frame5               .MenuConf.frame1.frame2.frame5.vscroll {left filly}               .MenuConf.frame1.frame2.frame5.hscroll {bottom fillx}               .MenuConf.frame1.frame2.frame5.buttons {left fill expand}
  pack append .MenuConf.frame1.frame2.frame6               .MenuConf.frame1.frame2.frame6.vscroll {left filly}               .MenuConf.frame1.frame2.frame6.hscroll {bottom fillx}               .MenuConf.frame1.frame2.frame6.menus {left fill expand}
  pack append .MenuConf.frame1.frame2.frame8               .MenuConf.frame1.frame2.frame8.mover {right filly}               .MenuConf.frame1.frame2.frame8.vscroll {left filly}               .MenuConf.frame1.frame2.frame8.hscroll {bottom fillx}               .MenuConf.frame1.frame2.frame8.menu {left fill expand}

  place .MenuConf.frame1.frame2.frame4     -in .MenuConf.frame1.frame2     -relx 0     -rely 0     -relheight 1.0     -relwidth 0.5

  if {[.MenuConf.frame1.frame2.frame5.buttons size] > 0} {
    place .MenuConf.frame1.frame2.frame5       -in .MenuConf.frame1.frame2       -relx 0.5       -rely 0       -relheight 0.5       -relwidth 0.5

    place .MenuConf.frame1.frame2.frame6       -in .MenuConf.frame1.frame2       -relx 0.5       -rely 0.5       -relheight 0.5       -relwidth 0.5
    MenuConfSetItems menubutton
  } {
    place .MenuConf.frame1.frame2.frame6       -in .MenuConf.frame1.frame2       -relx 0.5       -rely 0       -relheight 1       -relwidth 0.5
    MenuConfSetItems menu
  }

  pack append .MenuConf.frame1               .MenuConf.frame1.frame3 {bottom fillx}               .MenuConf.frame1.frame7 {bottom fillx}               .MenuConf.frame1.frame2 {top fill expand}
  pack append .MenuConf               .MenuConf.frame1 {top fill expand}

  update idletask
  MenuConfSetItem
}


# Procedure: MenuConfDelete
proc MenuConfDelete { menuConfConfig} {

  set curSelected     [.MenuConf.frame1.frame2.frame6.menus curselection]
  if {[winfo ismapped .MenuConf.frame1.frame2.frame6] &&
      $curSelected >= 0} {
    if {"[info commands XFDestroy]" != ""} {
      catch "XFDestroy [.MenuConf.frame1.frame2.frame6.menus get $curSelected]"
    } {
      catch "destroy [.MenuConf.frame1.frame2.frame6.menus get $curSelected]"
    }
    MenuConfReadMenus $menuConfConfig
  } {
    set curSelected       [.MenuConf.frame1.frame2.frame8.menu curselection]
    if {[winfo ismapped .MenuConf.frame1.frame2.frame8] &&
        $curSelected >= 0} {
      [.MenuConf.frame1.frame2.frame6.menus get [.MenuConf.frame1.frame2.frame6.menus curselection]] delete $curSelected
      MenuConfReadMenu         [.MenuConf.frame1.frame2.frame6.menus get [.MenuConf.frame1.frame2.frame6.menus curselection]]
    }
  }
}


# Procedure: MenuConfEntry
proc MenuConfEntry { menuConfName menuConfLabel} {
  global menuConfActiveBackground
  global menuConfActiveForeground
  global menuConfBackground
  global menuConfFont
  global menuConfForeground
  global menuConfScrollActiveForeground
  global menuConfScrollBackground
  global menuConfScrollForeground

  # build widgets
  frame .MenuConf.frame1.frame2.frame4.$menuConfName     -background "$menuConfBackground"     -borderwidth 0     -relief raised

  label .MenuConf.frame1.frame2.frame4.$menuConfName.label$menuConfName     -background "$menuConfBackground"     -foreground "$menuConfForeground"     -font "$menuConfFont"     -relief raised     -text "$menuConfLabel"

  entry .MenuConf.frame1.frame2.frame4.$menuConfName.$menuConfName     -background "$menuConfBackground"     -foreground "$menuConfForeground"     -font "$menuConfFont"     -relief raised

  # bindings
  bind .MenuConf.frame1.frame2.frame4.$menuConfName.$menuConfName <Delete> {
    EntryBS %W}
  bind .MenuConf.frame1.frame2.frame4.$menuConfName.$menuConfName <BackSpace> {
    EntryBS %W}
  bind .MenuConf.frame1.frame2.frame4.$menuConfName.$menuConfName <Right> {
    %W cursor [expr [%W index cursor]+1]
    EntryV2C %W }
  bind .MenuConf.frame1.frame2.frame4.$menuConfName.$menuConfName <Left> {
    %W cursor [expr [%W index cursor]-1]
    EntryV2C %W }
  bind .MenuConf.frame1.frame2.frame4.$menuConfName.$menuConfName <Control-a> {
    %W cursor 0
    %W view 0}
  bind .MenuConf.frame1.frame2.frame4.$menuConfName.$menuConfName <Control-b> {
    %W cursor [expr [%W index cursor]-1]
    EntryV2C %W}
  bind .MenuConf.frame1.frame2.frame4.$menuConfName.$menuConfName <Control-d> {
    %W delete [%W index cursor]
    EntryV2C %W }
  bind .MenuConf.frame1.frame2.frame4.$menuConfName.$menuConfName <Control-e> {
    %W cursor end
    EntryV2C %W}
  bind .MenuConf.frame1.frame2.frame4.$menuConfName.$menuConfName <Control-f> {
    %W cursor [expr [%W index cursor]+1]
    EntryV2C %W}
  bind .MenuConf.frame1.frame2.frame4.$menuConfName.$menuConfName <Control-h> {
    EntryBS %W}
  bind .MenuConf.frame1.frame2.frame4.$menuConfName.$menuConfName <Meta-h> {
    %W delete 0 cursor
    %W view cursor}
  bind .MenuConf.frame1.frame2.frame4.$menuConfName.$menuConfName <Control-i> {
    %W insert cursor \t}
  bind .MenuConf.frame1.frame2.frame4.$menuConfName.$menuConfName <Control-k> {
    %W delete cursor end
    EntryV2C %W}
  bind .MenuConf.frame1.frame2.frame4.$menuConfName.$menuConfName <Control-l> {
    EntryV2C %W}
  bind .MenuConf.frame1.frame2.frame4.$menuConfName.$menuConfName <Control-t> {
    set contents [%W get]
    set char1 [string index $contents [expr [%W index cursor]-2]]
    set char2 [string index $contents [expr [%W index cursor]-1]]
    %W delete [expr [%W index cursor]-2] [expr [%W index cursor]-1]
    %W insert [%W index cursor] "$char2$char1"
    %W cursor [expr [%W index cursor]+1]
    EntryV2C %W}
  bind .MenuConf.frame1.frame2.frame4.$menuConfName.$menuConfName <Control-v> {
    %W insert cursor "[GetSelection]"}
  bind .MenuConf.frame1.frame2.frame4.$menuConfName.$menuConfName <Control-w> {
    %W delete sel.first sel.last
    EntryV2C %W}
  bind .MenuConf.frame1.frame2.frame4.$menuConfName.$menuConfName <Control-y> {
    %W insert cursor "[GetSelection]"}
  bind .MenuConf.frame1.frame2.frame4.$menuConfName.$menuConfName <space> {
    %W insert cursor " "
    EntryV2C %W}
  bind .MenuConf.frame1.frame2.frame4.$menuConfName.$menuConfName <Any-Key> {
    %W insert cursor "%A"
    EntryV2C %W}

  # packing of the subwidgets
  pack append .MenuConf.frame1.frame2.frame4.$menuConfName               .MenuConf.frame1.frame2.frame4.$menuConfName.label$menuConfName {left filly}               .MenuConf.frame1.frame2.frame4.$menuConfName.$menuConfName {left fill expand}
}


# Procedure: MenuConfEntryType
proc MenuConfEntryType { menuConfW menuConfPosition} {

  set menuConfEntryNum [llength [$menuConfW entryconfigure $menuConfPosition]]
  # get number of components
  if {9 == $menuConfEntryNum} {
    return "command"
  } {
    if {0 == $menuConfEntryNum} {
      return "separator"
    } {
      if {10 == $menuConfEntryNum} {
        return "cascade"
      } {
        if {11 == $menuConfEntryNum} {
          return "radiobutton"
        } {
          if {12 == $menuConfEntryNum} {
            return "checkbutton"
          } {
            puts stderr "MenuConf error: menu item type is unknown\nYou have probably switched to a new tk release"
            return "unknown"
          }
        }
      }
    }
  }
}


# Procedure: MenuConfInit
proc MenuConfInit { confUserFile confFile args} {
  # Description: initialize the configuration of menubuttons and
  #              menus of specified pathnames
  # Arguments: menuConfUserFile - the user specific loadfile
  #            menuConfFile - the default loadfile
  #            args - the widget pathnames we configure
  # Returns: none

  global menuConfPathNames
  global menuConfFile
  global menuConfUserFile

  set menuConfFile $confFile
  set menuConfUserFile $confUserFile
  if {[file exists $menuConfUserFile]} {
    if {[catch "source \"$menuConfUserFile\"" menuConfResult]} {
      puts stderr $menuConfResult
    }
  } {
    if {[file exists $menuConfFile]} {
      if {[catch "source \"$menuConfFile\"" menuConfResult]} {
        puts stderr $menuConfResult
      }
    }
  }
  set menuConfPathNames "$args"
}


# Procedure: MenuConfInsert
proc MenuConfInsert { menuConfConfig} {
  global menuConfCurrentMenuType

  if {[winfo ismapped .MenuConf.frame1.frame2.frame6]} {
    if {"[.MenuConf.frame1.frame2.frame4.name.name get]" != ""} {
      if {"[info commands XFDestroy]" != ""} {
        catch "XFDestroy [.MenuConf.frame1.frame2.frame4.name.name get]"
      } {
        catch "destroy [.MenuConf.frame1.frame2.frame4.name.name get]"
      }
      if {[catch "menu [.MenuConf.frame1.frame2.frame4.name.name get]" menuConfResult]} {
        puts stderr $menuConfResult
      } {
        .MenuConf.frame1.frame2.frame6.menus insert end           "[.MenuConf.frame1.frame2.frame4.name.name get]"
        .MenuConf.frame1.frame2.frame6.menus select from           [.MenuConf.frame1.frame2.frame6.menus size]
        .MenuConf.frame1.frame2.frame6.menus select to           [.MenuConf.frame1.frame2.frame6.menus size]
        MenuConfModify $menuConfConfig
        MenuConfReadMenus $menuConfConfig
      }
    }
  } {
    set currType       [string trim [string trim [string trim $menuConfCurrentMenuType] >] <]
    if {[winfo ismapped .MenuConf.frame1.frame2.frame8]} {
      if {[catch "[.MenuConf.frame1.frame2.frame6.menus get [.MenuConf.frame1.frame2.frame6.menus curselection]] add $currType" menuConfResult]} {
        puts stderr $menuConfResult
      } {
        .MenuConf.frame1.frame2.frame8.menu insert end           "$menuConfCurrentMenuType [.MenuConf.frame1.frame2.frame4.name.name get]"
        .MenuConf.frame1.frame2.frame8.menu select from           [.MenuConf.frame1.frame2.frame8.menu size]
        .MenuConf.frame1.frame2.frame8.menu select to           [.MenuConf.frame1.frame2.frame8.menu size]
        MenuConfModify $menuConfConfig
        MenuConfReadMenu           [.MenuConf.frame1.frame2.frame6.menus get [.MenuConf.frame1.frame2.frame6.menus curselection]]
      }
    }
  }
}


# Procedure: MenuConfInsertMenus
proc MenuConfInsertMenus { menuConfW} {
  if {"[winfo class $menuConfW]" == "Menu"} {
    .MenuConf.frame1.frame2.frame6.menus insert end $menuConfW
  }

  set last [$menuConfW index last]
  if {"$last" == "none"} {
    set last -1
  }
  for {set counter 0} {$counter <= $last} {incr counter 1} {
    if {"[MenuConfEntryType $menuConfW $counter]" == "cascade"} {
      if {"[lindex [$menuConfW entryconfig $counter -menu] 4]" != ""} {
        if {"[info commands [lindex [$menuConfW entryconfig $counter -menu] 4]]" == ""} {
          $menuConfW entryconfig $counter -menu ""
        }
      }
    }
  }
  foreach counter [lsort [winfo children $menuConfW]] {
    if {"[winfo class $counter]" == "Menu"} {
      MenuConfInsertMenus $counter
    }
  }
}


# Procedure: MenuConfModify
proc MenuConfModify { menuConfConfig} {
  global menuConfState

  set curSelected     [.MenuConf.frame1.frame2.frame5.buttons curselection]
  if {[winfo ismapped .MenuConf.frame1.frame2.frame5] &&
      $curSelected >= 0} {
    set menuConfList .MenuConf.frame1.frame2.frame5.buttons
    set menuConfW [$menuConfList get $curSelected]
    # insert values
    set optionString "config"
    if {"[.MenuConf.frame1.frame2.frame4.actbg.actbg get]" != ""} {
      append optionString         " -activebackground \{[.MenuConf.frame1.frame2.frame4.actbg.actbg get]\}"
    }
    if {"[.MenuConf.frame1.frame2.frame4.actfg.actfg get]" != ""} {
      append optionString         " -activeforeground \{[.MenuConf.frame1.frame2.frame4.actfg.actfg get]\}"
    }
    if {"[.MenuConf.frame1.frame2.frame4.bg.bg get]" != ""} {
      append optionString         " -background \{[.MenuConf.frame1.frame2.frame4.bg.bg get]\}"
    }
    if {"[.MenuConf.frame1.frame2.frame4.bitmap.bitmap get]" != ""} {
      if {"[string index [.MenuConf.frame1.frame2.frame4.bitmap.bitmap get] 0]" == "@"} {
        append optionString           " -bitmap \{[.MenuConf.frame1.frame2.frame4.bitmap.bitmap get]\}"
      } {
        append optionString           " -bitmap \{@[.MenuConf.frame1.frame2.frame4.bitmap.bitmap get]\}"
      }
    } {
      append optionString         " -bitmap \{\}"
    }
    append optionString       " -borderwidth [.MenuConf.frame1.frame2.frame4.border.border get]"
    if {"[.MenuConf.frame1.frame2.frame4.font.font get]" != ""} {
      append optionString         " -font \{[.MenuConf.frame1.frame2.frame4.font.font get]\}"
    }
    if {"[.MenuConf.frame1.frame2.frame4.fg.fg get]" != ""} {
      append optionString         " -foreground \{[.MenuConf.frame1.frame2.frame4.fg.fg get]\}"
    }
    append optionString       " -menu \{[.MenuConf.frame1.frame2.frame4.menu.menu get]\}"
    append optionString       " -text \{[.MenuConf.frame1.frame2.frame4.label.label get]\}"
    append optionString       " -textvariable \{[.MenuConf.frame1.frame2.frame4.textvar.textvar get]\}"
    append optionString       " -underline \{[.MenuConf.frame1.frame2.frame4.underline.underline get]\}"
    if {[.MenuConf.frame1.frame2.frame4.size.size1.size1 get] > 0 &&
	[.MenuConf.frame1.frame2.frame4.size.size2.size2 get] > 0} {
      append optionString         " -width \{[.MenuConf.frame1.frame2.frame4.size.size1.size1 get]\}"
      append optionString         " -height \{[.MenuConf.frame1.frame2.frame4.size.size2.size2 get]\}"
    }
    if {[catch "$menuConfW $optionString" menuConfResult]} {
      puts stderr $menuConfResult
    }
  } {
    set curSelected       [.MenuConf.frame1.frame2.frame6.menus curselection]
    if {[winfo ismapped .MenuConf.frame1.frame2.frame6] &&
        $curSelected >= 0} {
      set menuConfList .MenuConf.frame1.frame2.frame6.menus
      set menuConfW [$menuConfList get $curSelected]
      # insert values
      set optionString "config"
      if {"[.MenuConf.frame1.frame2.frame4.actbg.actbg get]" != ""} {
        append optionString           " -activebackground \{[.MenuConf.frame1.frame2.frame4.actbg.actbg get]\}"
      }
      append optionString         " -activeborderwidth \{[.MenuConf.frame1.frame2.frame4.actborder.actborder get]\}"
      if {"[.MenuConf.frame1.frame2.frame4.actfg.actfg get]" != ""} {
        append optionString           " -activeforeground \{[.MenuConf.frame1.frame2.frame4.actfg.actfg get]\}"
      }
      if {"[.MenuConf.frame1.frame2.frame4.bg.bg get]" != ""} {
        append optionString           " -background \{[.MenuConf.frame1.frame2.frame4.bg.bg get]\}"
      }
      append optionString         " -borderwidth \{[.MenuConf.frame1.frame2.frame4.border.border get]\}"
      if {"[.MenuConf.frame1.frame2.frame4.font.font get]" != ""} {
        append optionString           " -font \{[.MenuConf.frame1.frame2.frame4.font.font get]\}"
      }
      if {"[.MenuConf.frame1.frame2.frame4.fg.fg get]" != ""} {
        append optionString           " -foreground \{[.MenuConf.frame1.frame2.frame4.fg.fg get]\}"
      }
      if {[catch "$menuConfW $optionString" menuConfResult]} {
        puts stderr $menuConfResult
      }
    } {
      set curSelected         [.MenuConf.frame1.frame2.frame8.menu curselection]
      if {[winfo ismapped .MenuConf.frame1.frame2.frame8] &&
          $curSelected >= 0} {
        set menuConfList .MenuConf.frame1.frame2.frame6.menus
        set menuConfW           [$menuConfList get [.MenuConf.frame1.frame2.frame6.menus curselection]]
        # insert values
        if {![string match <separator* [.MenuConf.frame1.frame2.frame8.menu get $curSelected]]} {
          set optionString "entryconfig $curSelected"
          if {"[.MenuConf.frame1.frame2.frame4.actbg.actbg get]" != ""} {
            append optionString               " -activebackground \{[.MenuConf.frame1.frame2.frame4.actbg.actbg get]\}"
          }
          append optionString             " -accelerator \{[.MenuConf.frame1.frame2.frame4.accelerator.accelerator get]\}"
          if {"[.MenuConf.frame1.frame2.frame4.bg.bg get]" != ""} {
            append optionString               " -background \{[.MenuConf.frame1.frame2.frame4.bg.bg get]\}"
          }
          if {"[.MenuConf.frame1.frame2.frame4.bitmap.bitmap get]" != ""} {
            if {"[string index [.MenuConf.frame1.frame2.frame4.bitmap.bitmap get] 0]" == "@"} {
              append optionString                 " -bitmap \{[.MenuConf.frame1.frame2.frame4.bitmap.bitmap get]\}"
            } {
              append optionString                 " -bitmap \{@[.MenuConf.frame1.frame2.frame4.bitmap.bitmap get]\}"
            }
          } {
            append optionString               " -bitmap \{\}"
          }
          append optionString             " -command \{[.MenuConf.frame1.frame2.frame4.command.command get 1.0 end]\}"
          if {"[.MenuConf.frame1.frame2.frame4.font.font get]" != ""} {
            append optionString               " -font \{[.MenuConf.frame1.frame2.frame4.font.font get]\}"
          }
          append optionString             " -label \{[.MenuConf.frame1.frame2.frame4.label.label get]\}"
          append optionString             " -state \{$menuConfState\}"
          append optionString             " -underline \{[.MenuConf.frame1.frame2.frame4.underline.underline get]\}"
          case [.MenuConf.frame1.frame2.frame8.menu get $curSelected] in {
            {<cascade*} {
              append optionString                 " -menu \{[.MenuConf.frame1.frame2.frame4.menu.menu get]\}"
            }
            {<radiobutton*} {
              append optionString                 " -value \{[.MenuConf.frame1.frame2.frame4.value.value get]\}"
              if {"[.MenuConf.frame1.frame2.frame4.variable.variable get]" != ""} {
                append optionString                   " -variable \{[.MenuConf.frame1.frame2.frame4.variable.variable get]\}"
              }
            }
            {<checkbutton*} {
              append optionString                 " -offvalue \{[.MenuConf.frame1.frame2.frame4.offvalue.offvalue get]\}"
              append optionString                 " -onvalue \{[.MenuConf.frame1.frame2.frame4.onvalue.onvalue get]\}"
              if {"[.MenuConf.frame1.frame2.frame4.variable.variable get]" != ""} {
                append optionString                   " -variable \{[.MenuConf.frame1.frame2.frame4.variable.variable get]\}"
              }
            }
          }
          if {[catch "$menuConfW $optionString" menuConfResult]} {
            puts stderr $menuConfResult
          }
        }
      }
    }
  }
}


# Procedure: MenuConfReadMenu
proc MenuConfReadMenu { menuConfW} {

  if {[.MenuConf.frame1.frame2.frame8.menu size] > 0} {
    .MenuConf.frame1.frame2.frame8.menu delete 0 end
  }
  set last [$menuConfW index last]
  if {"$last" == "none"} {
    set last -1
  }
  for {set counter 0} {$counter <= $last} {incr counter 1} {
    if {"[MenuConfEntryType $menuConfW $counter]" == "separator"} {
      .MenuConf.frame1.frame2.frame8.menu insert end        "<[MenuConfEntryType $menuConfW $counter]>"
    } {
      .MenuConf.frame1.frame2.frame8.menu insert end         "<[MenuConfEntryType $menuConfW $counter]> [lindex [$menuConfW entryconfigure $counter -label] 4]"
    }
  }

  if {[.MenuConf.frame1.frame2.frame8.menu size] > 0} {
    .MenuConf.frame1.frame2.frame8.menu select from 0
    .MenuConf.frame1.frame2.frame8.menu select to 0
    MenuConfSetItem
    .MenuConf.frame1.frame2.frame8.mover configure         -to [.MenuConf.frame1.frame2.frame8.menu size]
  } {
    .MenuConf.frame1.frame2.frame8.mover configure         -to 1
  }
}


# Procedure: MenuConfReadMenus
proc MenuConfReadMenus { menuConfConfig} {

  if {[.MenuConf.frame1.frame2.frame5.buttons size] > 0} {
    .MenuConf.frame1.frame2.frame5.buttons delete 0 end
  }
  if {[.MenuConf.frame1.frame2.frame6.menus size] > 0} {
    .MenuConf.frame1.frame2.frame6.menus delete 0 end
  }
  foreach menuConfCounter [split $menuConfConfig] {
    if {![catch "winfo children $menuConfCounter" menuConfResult]} {
      foreach menuConfChild [lsort [split $menuConfResult]] {
        if {"[winfo class $menuConfChild]" == "Menubutton"} {
          if {"[lindex [$menuConfChild config -menu] 4]" != ""} {
            if {"[info commands [lindex [$menuConfChild config -menu] 4]]" == ""} {
              $menuConfChild config -menu ""
            }
          }
          .MenuConf.frame1.frame2.frame5.buttons insert end $menuConfChild
          foreach menuConfMenuChild [lsort [winfo children $menuConfChild]] {
            MenuConfInsertMenus $menuConfMenuChild
          }
        }
        if {"[winfo class $menuConfChild]" == "Menu"} {
          MenuConfInsertMenus $menuConfChild
        }
      }
    }
  }
  if {[.MenuConf.frame1.frame2.frame5.buttons size] > 0} {
    .MenuConf.frame1.frame2.frame5.buttons select from 0
    .MenuConf.frame1.frame2.frame5.buttons select to 0
    MenuConfSetItem
  } {
    .MenuConf.frame1.frame2.frame6.menus select from 0
    .MenuConf.frame1.frame2.frame6.menus select to 0
    MenuConfSetItem
  }
}


# Procedure: MenuConfReposition
proc MenuConfReposition { menuConfPos} {

  set curSelected     [.MenuConf.frame1.frame2.frame8.menu curselection]
  set menuConfW     [.MenuConf.frame1.frame2.frame6.menus get [.MenuConf.frame1.frame2.frame6.menus curselection]]
  if {$curSelected >= 0} {
    set menuConfLast [$menuConfW index last]
    if {"$menuConfLast" == "none"} {
      set menuConfLast -1
    }
    set counter 0
    set newMenu ""
    set currentItem "[MenuConfEntryType $menuConfW $curSelected] "
    foreach optCounter [$menuConfW entryconfig $curSelected] {
      if {[llength $optCounter] == 5} {
        if {"[lindex $optCounter 3]" != "[lindex $optCounter 4]"} {
          append currentItem " [lindex $optCounter 0] \{[lindex $optCounter 4]\}"
        }
      }
    }
    set counter 0
    while {$counter <= $menuConfLast} {
      if {$menuConfPos > $curSelected &&
          $counter == [expr $menuConfPos+1]} {
        lappend newMenu $currentItem
      }
      if {$menuConfPos <= $curSelected &&
          $counter == $menuConfPos} {
        lappend newMenu $currentItem
      }
      if {$counter == $curSelected} {
        incr counter
        continue
      }
      set newItem "[MenuConfEntryType $menuConfW $counter] "
      foreach optCounter [$menuConfW entryconfig $counter] {
        if {[llength $optCounter] == 5} {
          if {"[lindex $optCounter 3]" != "[lindex $optCounter 4]"} {
            append newItem " [lindex $optCounter 0] \{[lindex $optCounter 4]\}"
          }
        }
      }
      lappend newMenu $newItem
      incr counter
    }
    if {$menuConfPos > $curSelected} {
      lappend newMenu $currentItem
    }
    set counter 0
    while {$counter <= $menuConfLast} {
      $menuConfW delete 0
      incr counter
    }
    set counter 0
    while {$counter <= $menuConfLast} {
      if {[catch "$menuConfW add [lindex $newMenu $counter]" menuConfRes]} {
        puts stderr $menuConfRes
      }
      incr counter
    }
    MenuConfReadMenu $menuConfW
    .MenuConf.frame1.frame2.frame8.menu select from $menuConfPos
    .MenuConf.frame1.frame2.frame8.menu select to $menuConfPos
    MenuConfSetItem
  }
}


# Procedure: MenuConfSave
proc MenuConfSave {} {
  global menuConfPathNames
  global menuConfFile
  global menuConfUserFile

  if {![catch "open $menuConfUserFile w" outFile]} {
    foreach counter $menuConfPathNames {
      foreach widgets [winfo children $counter] {
        if {"[winfo class $widgets]" == "Menu"} {
          MenuConfSaveMenu $outFile $widgets
        }
        if {"[winfo class $widgets]" == "Menubutton"} {
          puts $outFile "$widgets config" nonewline
          foreach optCounter [$widgets config] {
            if {[llength $optCounter] == 5} {
              if {"[lindex $optCounter 3]" != "[lindex $optCounter 4]"} {
                puts $outFile "\\\n  [lindex $optCounter 0] \{[lindex $optCounter 4]\}" nonewline
              }
            }
          }
          puts $outFile ""
          puts $outFile ""
          foreach children [winfo children $widgets] {
            if {"[winfo class $children]" == "Menu"} {
              MenuConfSaveMenu $outFile $children
            }
          }
        }
      }
    }
    close $outFile
  } {
    puts stderr $outFile
  }
}


# Procedure: MenuConfSaveMenu
proc MenuConfSaveMenu { outFile menuConfW} {

  puts $outFile "if {\"\[info commands XFDestroy\]\" != \"\"} {"
  puts $outFile "  catch \"XFDestroy $menuConfW\""
  puts $outFile "} {"
  puts $outFile "  catch \"destroy $menuConfW\""
  puts $outFile "}"
  puts $outFile "menu $menuConfW" nonewline
  foreach optCounter [$menuConfW config] {
    if {[llength $optCounter] == 5} {
      if {"[lindex $optCounter 3]" != "[lindex $optCounter 4]"} {
        puts $outFile "\\\n  [lindex $optCounter 0] \{[lindex $optCounter 4]\}" nonewline
      }
    }
  }
  puts $outFile ""

  set menuLast [$menuConfW index last]
  if {"$menuLast" == "none"} {
    set menuLast -1
  }
  set counter 0
  while {$counter <= $menuLast} {
    puts $outFile "$menuConfW add [MenuConfEntryType $menuConfW $counter] " nonewline
    foreach optCounter [$menuConfW entryconfig $counter] {
      if {[llength $optCounter] == 5} {
        if {"[lindex $optCounter 3]" != "[lindex $optCounter 4]"} {
          puts $outFile "\\\n  [lindex $optCounter 0] \{[lindex $optCounter 4]\}" nonewline
        }
      }
    }
    puts $outFile ""
    incr counter
  }
  puts $outFile ""
  puts $outFile ""

  foreach children [winfo children $menuConfW] {
    if {"[winfo class $children]" == "Menu"} {
      MenuConfSaveMenu $outFile $children
    }
  }
}


# Procedure: MenuConfScale
proc MenuConfScale { menuConfName menuConfLabel1 menuConfLabel2 menuConfTo} {
  global menuConfActiveBackground
  global menuConfActiveForeground
  global menuConfBackground
  global menuConfFont
  global menuConfForeground
  global menuConfScrollActiveForeground
  global menuConfScrollBackground
  global menuConfScrollForeground

  # build widgets
  frame .MenuConf.frame1.frame2.frame4.$menuConfName     -background "$menuConfBackground"     -borderwidth 0     -relief raised

  label .MenuConf.frame1.frame2.frame4.$menuConfName.message1     -background "$menuConfBackground"     -foreground "$menuConfForeground"     -font "$menuConfFont"     -relief raised     -text "$menuConfLabel1"

  scale .MenuConf.frame1.frame2.frame4.$menuConfName.$menuConfName     -activeforeground "$menuConfScrollActiveForeground"     -background "$menuConfBackground"     -foreground "$menuConfForeground"     -from 0     -label "$menuConfLabel2"     -orient horizontal     -relief raised     -sliderlength 15     -to $menuConfTo     -width 8

  # packing of the subwidgets
  pack append .MenuConf.frame1.frame2.frame4.$menuConfName               .MenuConf.frame1.frame2.frame4.$menuConfName.message1 {left filly}               .MenuConf.frame1.frame2.frame4.$menuConfName.$menuConfName {left fillx expand}
}


# Procedure: MenuConfScaleDouble
proc MenuConfScaleDouble { menuConfName menuConfLabel1 menuConfLabel2 menuConfLabel3 menuConfTo1 menuConfTo2} {
  global menuConfActiveBackground
  global menuConfActiveForeground
  global menuConfBackground
  global menuConfFont
  global menuConfForeground
  global menuConfScrollActiveForeground
  global menuConfScrollBackground
  global menuConfScrollForeground

  # build widgets
  frame .MenuConf.frame1.frame2.frame4.$menuConfName     -background "$menuConfBackground"     -borderwidth 0     -relief raised

  frame .MenuConf.frame1.frame2.frame4.$menuConfName.${menuConfName}1     -background "$menuConfBackground"     -borderwidth 0     -relief raised

  frame .MenuConf.frame1.frame2.frame4.$menuConfName.${menuConfName}2     -background "$menuConfBackground"     -borderwidth 0     -relief raised

  label .MenuConf.frame1.frame2.frame4.$menuConfName.message1     -background "$menuConfBackground"     -foreground "$menuConfForeground"     -font "$menuConfFont"     -relief raised     -text "$menuConfLabel1"

  scale .MenuConf.frame1.frame2.frame4.$menuConfName.${menuConfName}1.${menuConfName}1     -activeforeground "$menuConfScrollActiveForeground"     -background "$menuConfBackground"     -foreground "$menuConfForeground"     -from 0     -label "$menuConfLabel2"     -orient horizontal     -relief raised     -sliderlength 15     -to $menuConfTo1     -width 8

  scale .MenuConf.frame1.frame2.frame4.$menuConfName.${menuConfName}2.${menuConfName}2     -activeforeground "$menuConfScrollActiveForeground"     -background "$menuConfBackground"     -foreground "$menuConfForeground"     -from 0     -label "$menuConfLabel3"     -orient horizontal     -relief raised     -sliderlength 15     -to $menuConfTo2     -width 8

  # packing of the subwidgets
  pack append .MenuConf.frame1.frame2.frame4.$menuConfName.${menuConfName}1               .MenuConf.frame1.frame2.frame4.$menuConfName.${menuConfName}1.${menuConfName}1 {left fillx expand}
  pack append .MenuConf.frame1.frame2.frame4.$menuConfName.${menuConfName}2               .MenuConf.frame1.frame2.frame4.$menuConfName.${menuConfName}2.${menuConfName}2 {left fillx expand}
  pack append .MenuConf.frame1.frame2.frame4.$menuConfName               .MenuConf.frame1.frame2.frame4.$menuConfName.message1 {left filly}               .MenuConf.frame1.frame2.frame4.$menuConfName.${menuConfName}1 {left fillx expand}               .MenuConf.frame1.frame2.frame4.$menuConfName.${menuConfName}2 {left fillx expand}
}


# Procedure: MenuConfSelect1
proc MenuConfSelect1 { menuConfW menuConfY} {

  .MenuConf.frame1.frame2.frame5.buttons select clear
  .MenuConf.frame1.frame2.frame6.menus select clear

  set menuConfNearest [$menuConfW nearest $menuConfY]
  if {$menuConfNearest >= 0} {
    $menuConfW select from $menuConfNearest
    $menuConfW select to $menuConfNearest
    MenuConfSetItem
    if {"$menuConfW" == ".MenuConf.frame1.frame2.frame5.buttons"} {
      .MenuConf.frame1.frame7.insert config         -state disabled
      .MenuConf.frame1.frame7.modifymenu config         -state disabled
      .MenuConf.frame1.frame7.delete config         -state disabled
    } {
      .MenuConf.frame1.frame7.insert config         -state normal
      .MenuConf.frame1.frame7.modifymenu config         -state normal
      .MenuConf.frame1.frame7.delete config         -state normal
    }
  }
}


# Procedure: MenuConfSelect2
proc MenuConfSelect2 { menuConfW menuConfY} {

  set menuConfNearest [$menuConfW nearest $menuConfY]
  if {$menuConfNearest >= 0} {
    $menuConfW select from $menuConfNearest
    $menuConfW select to $menuConfNearest
    MenuConfSetItem
  }
}


# Procedure: MenuConfSetItem
proc MenuConfSetItem {} {
  global menuConfCurrentMenuType
  global menuConfState

  set menuConfList ""
  set curSelected     [.MenuConf.frame1.frame2.frame5.buttons curselection]
  if {[winfo ismapped .MenuConf.frame1.frame2.frame5] &&
      $curSelected >= 0} {
    set menuConfList .MenuConf.frame1.frame2.frame5.buttons
    MenuConfSetItems menubutton
    set menuConfW [$menuConfList get $curSelected]
    # insert values
    .MenuConf.frame1.frame2.frame4.actbg.actbg       insert 0 [lindex [$menuConfW config -activebackground] 4]
    .MenuConf.frame1.frame2.frame4.actfg.actfg       insert 0 [lindex [$menuConfW config -activeforeground] 4]
    .MenuConf.frame1.frame2.frame4.bg.bg       insert 0 [lindex [$menuConfW config -background] 4]
    .MenuConf.frame1.frame2.frame4.bitmap.bitmap       insert 0 [lindex [$menuConfW config -bitmap] 4]
    if {"[lindex [$menuConfW config -borderwidth] 4]" != ""} {
      .MenuConf.frame1.frame2.frame4.border.border         set [lindex [$menuConfW config -borderwidth] 4]
    }
    .MenuConf.frame1.frame2.frame4.font.font       insert 0 [lindex [$menuConfW config -font] 4]
    .MenuConf.frame1.frame2.frame4.fg.fg       insert 0 [lindex [$menuConfW config -foreground] 4]
    if {"[lindex [$menuConfW config -height] 4]" != ""} {
      .MenuConf.frame1.frame2.frame4.size.size2.size2         set [lindex [$menuConfW config -height] 4]
    }
    .MenuConf.frame1.frame2.frame4.label.label       insert 0 [lindex [$menuConfW config -text] 4]
    if {"[lindex [$menuConfW config -menu] 4]" != ""} {
      .MenuConf.frame1.frame2.frame4.menu.menu         delete 0 end
    }
    .MenuConf.frame1.frame2.frame4.menu.menu       insert 0 [lindex [$menuConfW config -menu] 4]
    .MenuConf.frame1.frame2.frame4.textvar.textvar       insert 0 [lindex [$menuConfW config -textvariable] 4]
    if {"[lindex [$menuConfW config -underline] 4]" != ""} {
      .MenuConf.frame1.frame2.frame4.underline.underline         set [lindex [$menuConfW config -underline] 4]
    }
    .MenuConf.frame1.frame2.frame4.variable.variable       insert 0 [lindex [$menuConfW config -variable] 4]
    if {"[lindex [$menuConfW config -width] 4]" != ""} {
      .MenuConf.frame1.frame2.frame4.size.size1.size1         set [lindex [$menuConfW config -width] 4]
    }
  } {
    set curSelected       [.MenuConf.frame1.frame2.frame6.menus curselection]
    if {[winfo ismapped .MenuConf.frame1.frame2.frame6] &&
        $curSelected >= 0} {
      set menuConfList .MenuConf.frame1.frame2.frame6.menus
      MenuConfSetItems menu
      set menuConfW [$menuConfList get $curSelected]
      # insert values
      .MenuConf.frame1.frame2.frame4.name.name         insert 0 [.MenuConf.frame1.frame2.frame6.menus get $curSelected]
      .MenuConf.frame1.frame2.frame4.actbg.actbg         insert 0 [lindex [$menuConfW config -activebackground] 4]
      if {"[lindex [$menuConfW config -activeborderwidth] 4]" != ""} {
        .MenuConf.frame1.frame2.frame4.actborder.actborder           set [lindex [$menuConfW config -activeborderwidth] 4]
      }
      .MenuConf.frame1.frame2.frame4.actfg.actfg         insert 0 [lindex [$menuConfW config -activeforeground] 4]
      .MenuConf.frame1.frame2.frame4.bg.bg         insert 0 [lindex [$menuConfW config -background] 4]
      if {"[lindex [$menuConfW config -borderwidth] 4]" != ""} {
        .MenuConf.frame1.frame2.frame4.border.border           set [lindex [$menuConfW config -borderwidth] 4]
      }
      .MenuConf.frame1.frame2.frame4.font.font         insert 0 [lindex [$menuConfW config -font] 4]
      .MenuConf.frame1.frame2.frame4.fg.fg         insert 0 [lindex [$menuConfW config -foreground] 4]
    } {
      set curSelected         [.MenuConf.frame1.frame2.frame8.menu curselection]
      if {[winfo ismapped .MenuConf.frame1.frame2.frame8] &&
          $curSelected >= 0} {
        set menuConfList .MenuConf.frame1.frame2.frame8.menu
        case [.MenuConf.frame1.frame2.frame8.menu get $curSelected] in {
          {<cascade*} {
            set menuConfCurrentMenuType "<cascade> "
            .MenuConf.frame1.frame2.frame4.items.items.m               entryconfigure 0 -state active
            MenuConfSetItems cascade
          }
          {<check*} {
            set menuConfCurrentMenuType "<checkbutton> "
            .MenuConf.frame1.frame2.frame4.items.items.m               entryconfigure 1 -state active
            MenuConfSetItems check
          }
          {<radio*} {
            set menuConfCurrentMenuType "<radiobutton> "
            .MenuConf.frame1.frame2.frame4.items.items.m               entryconfigure 3 -state active
            MenuConfSetItems radio
          }
          {<separator*} {
            set menuConfCurrentMenuType "<separator> "
            .MenuConf.frame1.frame2.frame4.items.items.m               entryconfigure 4 -state active
            MenuConfSetItems separator
          }
          {default} {
            set menuConfCurrentMenuType "<command> "
            .MenuConf.frame1.frame2.frame4.items.items.m               entryconfigure 2 -state active
            MenuConfSetItems command
          }
        }
        # insert values
        if {![string match <separator* [.MenuConf.frame1.frame2.frame8.menu get $curSelected]]} {
          set menuConfW [.MenuConf.frame1.frame2.frame6.menus get [.MenuConf.frame1.frame2.frame6.menus curselection]]
          .MenuConf.frame1.frame2.frame4.accelerator.accelerator             insert 0 [lindex [$menuConfW entryconfig $curSelected -accelerator] 4]
          .MenuConf.frame1.frame2.frame4.actbg.actbg             insert 0 [lindex [$menuConfW entryconfig $curSelected -activebackground] 4]
          .MenuConf.frame1.frame2.frame4.bg.bg             insert 0 [lindex [$menuConfW entryconfig $curSelected -background] 4]
          .MenuConf.frame1.frame2.frame4.bitmap.bitmap             insert 0 [lindex [$menuConfW entryconfig $curSelected -bitmap] 4]
          .MenuConf.frame1.frame2.frame4.command.command delete 1.0 end
          .MenuConf.frame1.frame2.frame4.command.command insert 1.0             [lindex [$menuConfW entryconfig $curSelected -command] 4]
          .MenuConf.frame1.frame2.frame4.font.font             insert 0 [lindex [$menuConfW entryconfig $curSelected -font] 4]
          .MenuConf.frame1.frame2.frame4.label.label             insert 0 [lindex [$menuConfW entryconfig $curSelected -label] 4]
          set menuConfState             [lindex [$menuConfW entryconfig $curSelected -state] 4]
          case $menuConfState in {
            {active} {
              .MenuConf.frame1.frame2.frame4.state.active select
            }
            {disabled} {
              .MenuConf.frame1.frame2.frame4.state.disabled select
            }
            {default} {
              .MenuConf.frame1.frame2.frame4.state.normal select
            }
          }
          if {"[lindex [$menuConfW entryconfig $curSelected -underline] 4]" != ""} {
            .MenuConf.frame1.frame2.frame4.underline.underline               set [lindex [$menuConfW entryconfig $curSelected -underline] 4]
          }
          case [.MenuConf.frame1.frame2.frame8.menu get $curSelected] in {
            {<cascade*} {
              if {[string length [lindex [$menuConfW entryconfig $curSelected -menu] 4]] > 0} {
                .MenuConf.frame1.frame2.frame4.menu.menu                   delete 0 end
              }
              .MenuConf.frame1.frame2.frame4.menu.menu                 insert 0 [lindex [$menuConfW entryconfig $curSelected -menu] 4]
            }
            {<radiobutton*} {
              .MenuConf.frame1.frame2.frame4.value.value                 insert 0 [lindex [$menuConfW entryconfig $curSelected -value] 4]
              .MenuConf.frame1.frame2.frame4.variable.variable                 insert 0 [lindex [$menuConfW entryconfig $curSelected -variable] 4]
            }
            {<checkbutton*} {
              .MenuConf.frame1.frame2.frame4.offvalue.offvalue                 insert 0 [lindex [$menuConfW entryconfig $curSelected -offvalue] 4]
              .MenuConf.frame1.frame2.frame4.onvalue.onvalue                 insert 0 [lindex [$menuConfW entryconfig $curSelected -onvalue] 4]
              .MenuConf.frame1.frame2.frame4.variable.variable                 insert 0 [lindex [$menuConfW entryconfig $curSelected -variable] 4]
            }
          }
        }
      }
    }
  }
}


# Procedure: MenuConfSetItems
proc MenuConfSetItems { menuConfType} {

  # remove widgets
  pack unpack .MenuConf.frame1.frame2.frame4.items
  pack unpack .MenuConf.frame1.frame2.frame4.accelerator
  pack unpack .MenuConf.frame1.frame2.frame4.actbg
  pack unpack .MenuConf.frame1.frame2.frame4.actborder
  pack unpack .MenuConf.frame1.frame2.frame4.actfg
  pack unpack .MenuConf.frame1.frame2.frame4.bg
  pack unpack .MenuConf.frame1.frame2.frame4.bitmap
  pack unpack .MenuConf.frame1.frame2.frame4.border
  pack unpack .MenuConf.frame1.frame2.frame4.message1
  pack unpack .MenuConf.frame1.frame2.frame4.command
  pack unpack .MenuConf.frame1.frame2.frame4.font
  pack unpack .MenuConf.frame1.frame2.frame4.fg
  pack unpack .MenuConf.frame1.frame2.frame4.label
  pack unpack .MenuConf.frame1.frame2.frame4.menu
  pack unpack .MenuConf.frame1.frame2.frame4.name
  pack unpack .MenuConf.frame1.frame2.frame4.offvalue
  pack unpack .MenuConf.frame1.frame2.frame4.onvalue
  pack unpack .MenuConf.frame1.frame2.frame4.size
  pack unpack .MenuConf.frame1.frame2.frame4.state
  pack unpack .MenuConf.frame1.frame2.frame4.textvar
  pack unpack .MenuConf.frame1.frame2.frame4.underline
  pack unpack .MenuConf.frame1.frame2.frame4.value
  pack unpack .MenuConf.frame1.frame2.frame4.variable

  # clear entry fields
  .MenuConf.frame1.frame2.frame4.accelerator.accelerator     delete 0 end
  .MenuConf.frame1.frame2.frame4.actbg.actbg     delete 0 end
  .MenuConf.frame1.frame2.frame4.actborder.actborder     set 0
  .MenuConf.frame1.frame2.frame4.actfg.actfg     delete 0 end
  .MenuConf.frame1.frame2.frame4.bg.bg     delete 0 end
  .MenuConf.frame1.frame2.frame4.bitmap.bitmap     delete 0 end
  .MenuConf.frame1.frame2.frame4.border.border     set 0
  .MenuConf.frame1.frame2.frame4.command.command     delete 1.0 end
  .MenuConf.frame1.frame2.frame4.font.font     delete 0 end
  .MenuConf.frame1.frame2.frame4.fg.fg     delete 0 end
  .MenuConf.frame1.frame2.frame4.size.size2.size2     set 0
  .MenuConf.frame1.frame2.frame4.label.label     delete 0 end
  .MenuConf.frame1.frame2.frame4.menu.menu     delete 0 end
  .MenuConf.frame1.frame2.frame4.name.name     delete 0 end
  .MenuConf.frame1.frame2.frame4.offvalue.offvalue     delete 0 end
  .MenuConf.frame1.frame2.frame4.onvalue.onvalue     delete 0 end
  .MenuConf.frame1.frame2.frame4.state.normal     select
  .MenuConf.frame1.frame2.frame4.textvar.textvar     delete 0 end
  .MenuConf.frame1.frame2.frame4.underline.underline     set -1
  .MenuConf.frame1.frame2.frame4.value.value     delete 0 end
  .MenuConf.frame1.frame2.frame4.variable.variable     delete 0 end
  .MenuConf.frame1.frame2.frame4.size.size1.size1     set 0

  case $menuConfType in {
    {menubutton} {
      pack append .MenuConf.frame1.frame2.frame4                   .MenuConf.frame1.frame2.frame4.actbg {top fillx}                   .MenuConf.frame1.frame2.frame4.actfg {top fillx}                   .MenuConf.frame1.frame2.frame4.bg {top fillx}                   .MenuConf.frame1.frame2.frame4.bitmap {top fillx}                   .MenuConf.frame1.frame2.frame4.border {top fillx}                   .MenuConf.frame1.frame2.frame4.font {top fillx}                   .MenuConf.frame1.frame2.frame4.fg {top fillx}                   .MenuConf.frame1.frame2.frame4.label {top fillx}                   .MenuConf.frame1.frame2.frame4.menu {top fillx}                   .MenuConf.frame1.frame2.frame4.size {top fillx}                   .MenuConf.frame1.frame2.frame4.textvar {top fillx}                   .MenuConf.frame1.frame2.frame4.underline {top fillx}                   .MenuConf.frame1.frame2.frame4.variable {top fillx}
    }
    {menu} {
      pack append .MenuConf.frame1.frame2.frame4                   .MenuConf.frame1.frame2.frame4.name {top fillx}                   .MenuConf.frame1.frame2.frame4.actbg {top fillx}                   .MenuConf.frame1.frame2.frame4.actborder {top fillx}                   .MenuConf.frame1.frame2.frame4.actfg {top fillx}                   .MenuConf.frame1.frame2.frame4.bg {top fillx}                   .MenuConf.frame1.frame2.frame4.border {top fillx}                   .MenuConf.frame1.frame2.frame4.font {top fillx}                   .MenuConf.frame1.frame2.frame4.fg {top fillx}
    }
    {cascade} {
      .MenuConf.frame1.frame2.frame4.items.message1 configure         -text Cascadebutton

      pack append .MenuConf.frame1.frame2.frame4                   .MenuConf.frame1.frame2.frame4.items {top fillx}                   .MenuConf.frame1.frame2.frame4.label {top fillx}                   .MenuConf.frame1.frame2.frame4.actbg {top fillx}                   .MenuConf.frame1.frame2.frame4.accelerator {top fillx}                   .MenuConf.frame1.frame2.frame4.bg {top fillx}                   .MenuConf.frame1.frame2.frame4.bitmap {top fillx}                   .MenuConf.frame1.frame2.frame4.font {top fillx}                   .MenuConf.frame1.frame2.frame4.menu {top fill}                   .MenuConf.frame1.frame2.frame4.state {top fillx}                   .MenuConf.frame1.frame2.frame4.underline {top fillx}                   .MenuConf.frame1.frame2.frame4.message1 {top fillx}                   .MenuConf.frame1.frame2.frame4.command {top fill}
    }
    {check} {
      .MenuConf.frame1.frame2.frame4.items.message1 configure         -text Checkbutton

      pack append .MenuConf.frame1.frame2.frame4                   .MenuConf.frame1.frame2.frame4.items {top fillx}                   .MenuConf.frame1.frame2.frame4.label {top fillx}                   .MenuConf.frame1.frame2.frame4.actbg {top fillx}                   .MenuConf.frame1.frame2.frame4.accelerator {top fillx}                   .MenuConf.frame1.frame2.frame4.bg {top fillx}                   .MenuConf.frame1.frame2.frame4.bitmap {top fillx}                   .MenuConf.frame1.frame2.frame4.font {top fillx}                   .MenuConf.frame1.frame2.frame4.offvalue {top fillx}                   .MenuConf.frame1.frame2.frame4.onvalue {top fillx}                   .MenuConf.frame1.frame2.frame4.state {top fillx}                   .MenuConf.frame1.frame2.frame4.underline {top fillx}                   .MenuConf.frame1.frame2.frame4.variable {top fillx}                   .MenuConf.frame1.frame2.frame4.message1 {top fillx}                   .MenuConf.frame1.frame2.frame4.command {top fill}
    }
    {radio} {
      .MenuConf.frame1.frame2.frame4.items.message1 configure         -text Radiobutton

      pack append .MenuConf.frame1.frame2.frame4                   .MenuConf.frame1.frame2.frame4.items {top fillx}                   .MenuConf.frame1.frame2.frame4.label {top fillx}                   .MenuConf.frame1.frame2.frame4.actbg {top fillx}                   .MenuConf.frame1.frame2.frame4.accelerator {top fillx}                   .MenuConf.frame1.frame2.frame4.bg {top fillx}                   .MenuConf.frame1.frame2.frame4.bitmap {top fillx}                   .MenuConf.frame1.frame2.frame4.font {top fillx}                   .MenuConf.frame1.frame2.frame4.state {top fillx}                   .MenuConf.frame1.frame2.frame4.underline {top fillx}                   .MenuConf.frame1.frame2.frame4.value {top fillx}                   .MenuConf.frame1.frame2.frame4.variable {top fillx}                   .MenuConf.frame1.frame2.frame4.message1 {top fillx}                   .MenuConf.frame1.frame2.frame4.command {top fill}
    }
    {separator} {
      .MenuConf.frame1.frame2.frame4.items.message1 configure         -text Separator

      pack append .MenuConf.frame1.frame2.frame4                   .MenuConf.frame1.frame2.frame4.items {top fillx}
    }
    {default} {
      .MenuConf.frame1.frame2.frame4.items.message1 configure         -text Commandbutton

      pack append .MenuConf.frame1.frame2.frame4                   .MenuConf.frame1.frame2.frame4.items {top fillx}                   .MenuConf.frame1.frame2.frame4.label {top fillx}                   .MenuConf.frame1.frame2.frame4.actbg {top fillx}                   .MenuConf.frame1.frame2.frame4.accelerator {top fillx}                   .MenuConf.frame1.frame2.frame4.bg {top fillx}                   .MenuConf.frame1.frame2.frame4.bitmap {top fillx}                   .MenuConf.frame1.frame2.frame4.font {top fillx}                   .MenuConf.frame1.frame2.frame4.state {top fillx}                   .MenuConf.frame1.frame2.frame4.underline {top fillx}                   .MenuConf.frame1.frame2.frame4.message1 {top fillx}                   .MenuConf.frame1.frame2.frame4.command {top fill}
    }
  }
}


# Procedure: MenuPopupAdd
if {[string length [info procs MenuPopupAdd]] == 0} {
proc MenuPopupAdd { xfW xfButton xfMenu} {

  if {[catch "bind $xfW \"<ButtonPress-$xfButton>\"                 \"$xfMenu post %X %Y\"" xfResult]} {
    XFError "$xfResult"
    return
  }
  # we need these to counteract the effects of passive grabs :-(
  if {[catch "bind $xfW \"<ButtonRelease-$xfButton>\"                 \"$xfMenu invoke active; $xfMenu unpost\"" xfResult]} {
    XFError "$xfResult"
    return
  }
  if {[catch "bind $xfW \"<B$xfButton-Motion>\"                 \"MenuPopupHandle $xfMenu %W %X %Y\"" xfResult]} {
    XFError "$xfResult"
    return
  }
}
}


# Procedure: MenuPopupHandle
if {[string length [info procs MenuPopupHandle]] == 0} {
proc MenuPopupHandle { xfMenu xfW xfX xfY} {

 if {"[info commands $xfMenu]" != "" && [winfo ismapped $xfMenu]} {
   set xfPopMinX [winfo rootx $xfMenu]
   set xfPopMaxX [expr "$xfPopMinX+[winfo width $xfMenu]"]
   if {($xfX >= $xfPopMinX) &&  ($xfX <= $xfPopMaxX)} {
     $xfMenu activate @[expr "$xfY - [winfo rooty $xfMenu]"]
   } {
     $xfMenu activate none}
   }
}
}


# Procedure: NoFunction
if {[string length [info procs NoFunction]] == 0} {
proc NoFunction { args} {

}
}


# Procedure: ReadBox
proc ReadBox {} {
  # Description: show a box where tcl code can be entered and
  #              evaluated
  # Arguments: none
  # Returns: none
  # Notes: none
  #
  # global readBoxActiveBackground
  # global readBoxActiveForeground
  # global readBoxBackground
  # global readBoxFont
  # global readBoxForeground
  # global readBoxScrollActiveForeground
  # global readBoxScrollBackground
  # global readBoxScrollForeground

  global readBoxActiveBackground
  global readBoxActiveForeground
  global readBoxBackground
  global readBoxFont
  global readBoxForeground
  global readBoxScrollActiveForeground
  global readBoxScrollBackground
  global readBoxScrollForeground

  # build widget structure
  if {"[info commands XFDestroy]" != ""} {
    catch {XFDestroy .ReadBox}
  } {
    catch {destroy .ReadBox}
  }
  toplevel .ReadBox     -background "$readBoxBackground"     -borderwidth 0
  wm geometry .ReadBox 420x300
  wm title .ReadBox {Read TCL commands}
  wm maxsize .ReadBox 1000 1000
  wm minsize .ReadBox 100 100
  wm positionfrom .ReadBox program
  wm sizefrom .ReadBox user

  button .ReadBox.ok     -activebackground "$readBoxActiveBackground"     -activeforeground "$readBoxActiveForeground"     -background "$readBoxBackground"     -foreground "$readBoxForeground"     -font "$readBoxFont"     -text "OK"     -command {
      if {"[info commands XFDestroy]" != ""} {
        catch {XFDestroy .ReadBox}
      } {
        catch {destroy .ReadBox}
      }}

  frame .ReadBox.frame1     -background "$readBoxBackground"     -borderwidth 0     -relief raised
 
  button .ReadBox.frame1.send     -activebackground "$readBoxActiveBackground"     -activeforeground "$readBoxActiveForeground"     -background "$readBoxBackground"     -foreground "$readBoxForeground"     -font "$readBoxFont"     -text "Send"     -command {
      if {[catch "[string trim [.ReadBox.text1.text1 get 1.0 end]]" result]} {
        if {"[info commands AlertBox]" != ""} {
          AlertBox "$result"
        } {
          puts stderr "$result"
        }
      }}

  button .ReadBox.frame1.sendAndClear     -activebackground "$readBoxActiveBackground"     -activeforeground "$readBoxActiveForeground"     -background "$readBoxBackground"     -foreground "$readBoxForeground"     -font "$readBoxFont"     -text "Send + Clear"     -command {
      if {[catch "[string trim [.ReadBox.text1.text1 get 1.0 end]]" result]} {
        if {"[info commands AlertBox]" != ""} {
          AlertBox "$result"
        } {
          puts stderr "$result"
        }
      }
      .ReadBox.text1.text1 delete 1.0 end}

  button .ReadBox.frame1.clear     -activebackground "$readBoxActiveBackground"     -activeforeground "$readBoxActiveForeground"     -background "$readBoxBackground"     -foreground "$readBoxForeground"     -font "$readBoxFont"     -text "Clear"     -command ".ReadBox.text1.text1 delete 1.0 end"

  frame .ReadBox.text1     -background "$readBoxBackground"     -borderwidth 0     -relief raised
 
  scrollbar .ReadBox.text1.scrollbar1     -activeforeground "$readBoxScrollActiveForeground"     -background "$readBoxScrollBackground"     -foreground "$readBoxScrollForeground"     -command ".ReadBox.text1.text1 yview"     -relief "raised"

  text .ReadBox.text1.text1     -background "$readBoxBackground"     -foreground "$readBoxForeground"     -font "$readBoxFont"     -borderwidth "2"     -exportselection "true"     -insertbackground "blue"     -relief "raised"     -yscrollcommand ".ReadBox.text1.scrollbar1 set"

  # bindings
  bind .ReadBox.text1.text1 <Left> {
    %W mark set insert insert-1c
    %W yview -pickplace insert}
  bind .ReadBox.text1.text1 <Right> {
    %W mark set insert insert+1c
    %W yview -pickplace insert}
  bind .ReadBox.text1.text1 <Up> {
    %W mark set insert insert-1l
    %W yview -pickplace insert}
  bind .ReadBox.text1.text1 <Down> {
    %W mark set insert insert+1l
    %W yview -pickplace insert}
  bind .ReadBox.text1.text1 <Delete> {
    tk_textBackspace %W
    %W yview -pickplace insert}
  bind .ReadBox.text1.text1 <Control-a> {
    %W mark set insert "insert linestart"
    %W yview -pickplace insert}
  bind .ReadBox.text1.text1 <Control-b> {
    %W mark set insert insert-1c
    %W yview -pickplace insert}
  bind .ReadBox.text1.text1 <Control-d> {
    %W delete insert insert+1c
    %W yview -pickplace insert}
  bind .ReadBox.text1.text1 <Control-e> {
    %W mark set insert "insert lineend"
    %W yview -pickplace insert}
  bind .ReadBox.text1.text1 <Control-f> {
    %W mark set insert insert+1c
    %W yview -pickplace insert}
  bind .ReadBox.text1.text1 <Meta-h> {
    %W delete "insert linestart" insert
    %W yview -pickplace insert}
  bind .ReadBox.text1.text1 <Control-i> {
    %W inser insert \t
    %W yview -pickplace insert}
  bind .ReadBox.text1.text1 <Control-j> {
    %W inser insert \n
    %W yview -pickplace insert}
  bind .ReadBox.text1.text1 <Control-k> {
    if {[%W compare insert == "insert lineend"]} {
      %W delete insert "insert lineend +1c"
      %W yview -pickplace insert
    } {
      %W delete insert "insert lineend"
      %W yview -pickplace insert
    }}
  bind .ReadBox.text1.text1 <Control-l> {
    %W yview -pickplace insert}
  bind .ReadBox.text1.text1 <Control-m> {
    %W inser insert \n
    %W yview -pickplace insert}
  bind .ReadBox.text1.text1 <Control-n> {
    %W mark set insert insert+1l
    %W yview -pickplace insert}
  bind .ReadBox.text1.text1 <Control-o> {
    %W inser insert \n
    %W yview -pickplace insert}
  bind .ReadBox.text1.text1 <Control-p> {
    %W mark set insert insert-1l
    %W yview -pickplace insert}
  bind .ReadBox.text1.text1 <Control-t> {
    set char1 [%W get insert-2c insert-1c]
    set char2 [%W get insert-1c insert]
    %W delete insert-2c insert
    %W insert insert "$char2$char1"
    %W mark set insert insert+1c
    %W yview -pickplace insert}
  bind .ReadBox.text1.text1 <Meta-v> {
    set xfCounter [lindex [%W config -height] 4]
    while {$xfCounter > 0} {
      %W mark set insert insert-1l
      incr xfCounter -1
    }
    %W yview -pickplace insert}
  bind .ReadBox.text1.text1 <Control-v> {
    set xfCounter [lindex [%W config -height] 4]
    while {$xfCounter > 0} {
      %W mark set insert insert+1l
      incr xfCounter -1
    }
    %W yview -pickplace insert}
  bind .ReadBox.text1.text1 <Control-w> {
    catch "%W delete sel.first sel.last"}
  bind .ReadBox.text1.text1 <Control-y> {
    %W insert insert "[GetSelection]"
    %W yview -pickplace insert}
  bind .ReadBox.text1.text1 <Home> {
    %W mark set insert 1.0
    %W yview -pickplace insert}
  bind .ReadBox.text1.text1 <End> {
    %W mark set insert end
    %W yview -pickplace insert}
  bind .ReadBox.text1.text1 <Prior> {
    set xfCounter [lindex [%W config -height] 4]
    while {$xfCounter > 0} {
      %W mark set insert insert-1l
      incr xfCounter -1
    }
    %W yview -pickplace insert}
  bind .ReadBox.text1.text1 <Next> {
    set xfCounter [lindex [%W config -height] 4]
    while {$xfCounter > 0} {
      %W mark set insert insert+1l
      incr xfCounter -1
    }
    %W yview -pickplace insert}

  # packing
  pack append .ReadBox.frame1               .ReadBox.frame1.send {left fill expand}               .ReadBox.frame1.sendAndClear {left fill expand}               .ReadBox.frame1.clear {left fill expand}
  pack append .ReadBox.text1               .ReadBox.text1.scrollbar1 {left frame center filly}               .ReadBox.text1.text1 {top frame center expand fill}
  pack append .ReadBox               .ReadBox.ok {bottom fill}               .ReadBox.frame1 {bottom fill}               .ReadBox.text1 {bottom fill expand}
}


# Procedure: SendToEmacs
proc SendToEmacs { emacsLisp} {

  if {"$emacsLisp" == ""} {
    return
  }
  if {[catch ".frame.text send \{$emacsLisp\}" emacsResult]} {
    puts stdout ">$emacsResult<"
  }
}


# Procedure: SymbolicName
if {[string length [info procs SymbolicName]] == 0} {
proc SymbolicName { {xfName ""}} {
  global symbolicName

  if {"$xfName" != ""} {
    set xfArrayName ""
    append xfArrayName symbolicName ( $xfName )
    if {![catch "set \"$xfArrayName\"" xfValue]} {
      return $xfValue
    } {
      if {"[info commands XFError]" != ""} {
        XFError "Unknown symbolic name:\n$xfName"
      } {
        puts stderr "XF error: unknown symbolic name:\n$xfName"
      }
    }
  }
  return ""
}
}


# Procedure: TextBox
proc TextBox { {textBoxMessage "Text message"} {textBoxGeometry "350x150"} args} {
  # Description: show text box
  # Arguments: textBoxMessage - the text to display
  #            textBoxGeometry - the geometry for the window
  #            args - labels of buttons
  # Returns: The number of the selected button
  # Notes: there exists also functions called:
  #          TextBoxFile - to open and read a file automatically
  #          TextBoxFd - to read from an already opened filedescriptor
  #
  # global textBoxActiveBackground - active background color
  # global textBoxActiveForeground - active foreground color
  # global textBoxBackground - background color
  # global textBoxFont - text font
  # global textBoxForeground - foreground color
  # global textBoxScrollActiveForeground - scrollbar active background color
  # global textBoxScrollBackground - scrollbar background color
  # global textBoxScrollForeground - scrollbar foreground color

  global textBoxButton

  # show text box
  if {[llength $args] > 0} {
    eval TextBoxInternal "\{$textBoxMessage\}" "\{$textBoxGeometry\}" $args
  } {
    TextBoxInternal $textBoxMessage $textBoxGeometry
  }
}


# Procedure: TextBoxInternal
proc TextBoxInternal { textBoxMessage textBoxGeometry args} {
  global textBoxActiveBackground
  global textBoxActiveForeground
  global textBoxBackground
  global textBoxFont
  global textBoxForeground
  global textBoxScrollActiveForeground
  global textBoxScrollBackground
  global textBoxScrollForeground
  global textBoxButton

  if {[string length [info commands .TextBox]] > 0} {
    .TextBox.frame0.text1 configure       -state normal
    .TextBox.frame0.text1 delete 1.0 end
    .TextBox.frame0.text1 insert end $textBoxMessage
    .TextBox.frame0.text1 mark set insert end
    .TextBox.frame0.text1 yview -pickplace end
    .TextBox.frame0.text1 configure       -state disabled
    return
  }
  if {"[info commands XFDestroy]" != ""} {
    catch {XFDestroy .TextBox}
  } {
    catch {destroy .TextBox}
  }
  toplevel .TextBox     -background "$textBoxBackground"     -borderwidth 0
  if {[catch "wm geometry .TextBox $textBoxGeometry"]} {
    wm geometry .TextBox 350x150
  }
  wm title .TextBox {Text box}
  wm maxsize .TextBox 1000 1000
  wm minsize .TextBox 100 100
  wm positionfrom .TextBox program
  wm sizefrom .TextBox user

  frame .TextBox.frame0     -background "$textBoxBackground"     -borderwidth 0     -relief raised

  text .TextBox.frame0.text1     -background "$textBoxBackground"     -foreground "$textBoxForeground"     -font "$textBoxFont"     -relief raised     -wrap none     -borderwidth 2     -yscrollcommand ".TextBox.frame0.vscroll set"

  scrollbar .TextBox.frame0.vscroll     -activeforeground "$textBoxScrollActiveForeground"     -background "$textBoxScrollBackground"     -foreground "$textBoxScrollForeground"     -relief raised     -command ".TextBox.frame0.text1 yview"

  frame .TextBox.frame1     -background "$textBoxBackground"     -borderwidth 0     -relief raised

  set textCounter 0
  set buttonNum [llength $args]

  if {$buttonNum > 0} {
    while {$textCounter < $buttonNum} {
      button .TextBox.frame1.button$textCounter         -activebackground "$textBoxActiveBackground"         -activeforeground "$textBoxActiveForeground"         -background "$textBoxBackground"         -foreground "$textBoxForeground"         -font "$textBoxFont"         -text "[lindex $args $textCounter]"         -command "
          global textBoxButton
          set textBoxButton $textCounter
          if {\"\[info commands XFDestroy\]\" != \"\"} {
            catch {XFDestroy .TextBox}
          } {
            catch {destroy .TextBox}
          }"

      pack append .TextBox.frame1                   .TextBox.frame1.button$textCounter {left fillx expand}

      incr textCounter
    }
  } {
    button .TextBox.frame1.button0       -activebackground $textBoxActiveBackground       -activeforeground $textBoxActiveForeground       -background $textBoxBackground       -foreground $textBoxForeground       -font $textBoxFont       -text {Dismiss}       -command "
        global textBoxButton
        set textBoxButton 0
        if {[string length [info commands XFDestroy]] > 0} {
          catch {XFDestroy .TextBox}
        } {
          catch {destroy .TextBox}
        }"

    button .TextBox.frame1.button1       -activebackground $textBoxActiveBackground       -activeforeground $textBoxActiveForeground       -background $textBoxBackground       -foreground $textBoxForeground       -font $textBoxFont       -text {Clear}       -command "
        global textBoxButton
        global emacsErrorMessage
        set textBoxButton 1
        set emacsErrorMessage {}
        if {[string length [info commands XFDestroy]] > 0} {
          catch {XFDestroy .TextBox}
        } {
          catch {destroy .TextBox}
        }"

    pack append .TextBox.frame1                 .TextBox.frame1.button0 {left fillx expand}                 .TextBox.frame1.button1 {left fillx expand}
  }

  .TextBox.frame0.text1 insert end "$textBoxMessage"

  .TextBox.frame0.text1 configure     -state disabled

  # packing
  pack append .TextBox.frame0               .TextBox.frame0.vscroll {left filly}               .TextBox.frame0.text1 {left fill expand}
  pack append .TextBox               .TextBox.frame1 {bottom fill}               .TextBox.frame0 {top fill expand}
}




# initialize global variables
global {alertBoxActiveBackground}
set {alertBoxActiveBackground} {white}
global {alertBoxActiveForeground}
set {alertBoxActiveForeground} {black}
global {alertBoxAnchor}
set {alertBoxAnchor} {nw}
global {alertBoxBackground}
set {alertBoxBackground} {#dcdcdc}
global {alertBoxButton}
set {alertBoxButton} {0}
global {alertBoxFont}
set {alertBoxFont} {-adobe-helvetica-bold-r-normal--12-120-75-75-p-70-iso8859-1}
global {alertBoxForeground}
set {alertBoxForeground} {black}
global {alertBoxJustify}
set {alertBoxJustify} {center}
global {alertBoxScrollActiveForeground}
set {alertBoxScrollActiveForeground} {GhostWhite}
global {alertBoxScrollBackground}
set {alertBoxScrollBackground} {#dcdcdc}
global {alertBoxScrollForeground}
set {alertBoxScrollForeground} {gray}
global {bindPopupDown}
set {bindPopupDown} {<Mod1-Button-3>}
global {bindPopupMove}
set {bindPopupMove} {<B3-Mod1-Motion>}
global {bindPopupRelease}
set {bindPopupRelease} {<Any-ButtonRelease-3>}
global {colorBoxActiveBackground}
set {colorBoxActiveBackground} {white}
global {colorBoxActiveForeground}
set {colorBoxActiveForeground} {black}
global {colorBoxBackground}
set {colorBoxBackground} {#dcdcdc}
global {colorBoxFont}
set {colorBoxFont} {-adobe-helvetica-bold-r-normal--12-120-75-75-p-70-iso8859-1}
global {colorBoxForeground}
set {colorBoxForeground} {black}
global {colorBoxName}
set {colorBoxName} {gray}
global {colorBoxScrollActiveForeground}
set {colorBoxScrollActiveForeground} {GhostWhite}
global {colorBoxScrollBackground}
set {colorBoxScrollBackground} {#dcdcdc}
global {colorBoxScrollForeground}
set {colorBoxScrollForeground} {gray}
global {connect_info}
set {connect_info(file4)} {1160}
set {connect_info(file5)} {127.0.0.1 1163}
set {connect_info(file6)} {127.0.0.1 1098}
global {curSelected}
set {curSelected} {0}
global {emacsActBackground}
set {emacsActBackground} {"white"}
global {emacsActForeground}
set {emacsActForeground} {"black"}
global {emacsBackground}
set {emacsBackground} {"#dcdcdc"}
global {emacsBuffList}
set {emacsBuffList} {}
global {emacsCurrentMenu}
set {emacsCurrentMenu} {}
global {emacsDebug}
set {emacsDebug} {0}
global {emacsEmacsCursor}
set {emacsEmacsCursor} {}
global {emacsEmacsFont}
set {emacsEmacsFont} {}
global {emacsErrorMessage}
set {emacsErrorMessage} {}
global {emacsFont}
set {emacsFont} {"-adobe-helvetica-bold-r-normal--12-120-75-75-p-70-iso8859-1"}
global {emacsForeground}
set {emacsForeground} {"black"}
global {emacsPollInterval}
set {emacsPollInterval} {60}
global {emacsPopupBind}
set {emacsPopupBind} {<Mod1-Button3>}
global {emacsResult}
set {emacsResult} {gray}
global {emacsScrollActForeground}
set {emacsScrollActForeground} {"GhostWhite"}
global {emacsScrollForeground}
set {emacsScrollForeground} {"gray"}
global {emacsUseAdvise}
set {emacsUseAdvise} {true}
global {fontBoxActiveBackground}
set {fontBoxActiveBackground} {white}
global {fontBoxActiveForeground}
set {fontBoxActiveForeground} {black}
global {fontBoxBackground}
set {fontBoxBackground} {#dcdcdc}
global {fontBoxFont}
set {fontBoxFont} {-adobe-helvetica-bold-r-normal--12-120-75-75-p-70-iso8859-1}
global {fontBoxFontFamily}
set {fontBoxFontFamily} {*}
global {fontBoxFontPixels}
set {fontBoxFontPixels} {*}
global {fontBoxFontSWeight}
set {fontBoxFontSWeight} {*}
global {fontBoxFontSWidth}
set {fontBoxFontSWidth} {}
global {fontBoxFontSlant}
set {fontBoxFontSlant} {*}
global {fontBoxFontWeight}
set {fontBoxFontWeight} {*}
global {fontBoxForeground}
set {fontBoxForeground} {black}
global {fontBoxName}
set {fontBoxName} {-adobe-helvetica-bold-r-normal--12-120-75-75-p-70-iso8859-1}
global {fontBoxScrollActiveForeground}
set {fontBoxScrollActiveForeground} {GhostWhite}
global {fontBoxScrollBackground}
set {fontBoxScrollBackground} {#dcdcdc}
global {fontBoxScrollForeground}
set {fontBoxScrollForeground} {gray}
global {fsBoxActiveBackground}
set {fsBoxActiveBackground} {white}
global {fsBoxActiveForeground}
set {fsBoxActiveForeground} {black}
global {fsBoxBackground}
set {fsBoxBackground} {#dcdcdc}
global {fsBoxButton}
set {fsBoxButton} {0}
global {fsBoxFSAll}
set {fsBoxFSAll} {0}
global {fsBoxFSInternalPath}
set {fsBoxFSInternalPath} {/home/stone/garfield/dvlpmnt/TkEmacs/xfemacs}
global {fsBoxFSName}
set {fsBoxFSName} {}
global {fsBoxFSPath}
set {fsBoxFSPath} {/home/stone/garfield/development/TkEmacs/xfemacs}
global {fsBoxFSPattern}
set {fsBoxFSPattern} {*}
global {fsBoxFont}
set {fsBoxFont} {-adobe-helvetica-bold-r-normal--12-120-75-75-p-70-iso8859-1}
global {fsBoxForeground}
set {fsBoxForeground} {black}
global {fsBoxScrollActiveForeground}
set {fsBoxScrollActiveForeground} {GhostWhite}
global {fsBoxScrollBackground}
set {fsBoxScrollBackground} {#dcdcdc}
global {fsBoxScrollForeground}
set {fsBoxScrollForeground} {gray}
global {menuConfActiveBackground}
set {menuConfActiveBackground} {white}
global {menuConfActiveForeground}
set {menuConfActiveForeground} {black}
global {menuConfBackground}
set {menuConfBackground} {#dcdcdc}
global {menuConfColorFile}
set {menuConfColorFile} {/usr/local/lib/tk/xf/lib/Colors}
global {menuConfCurrentMenuType}
set {menuConfCurrentMenuType} {<command> }
global {menuConfFile}
set {menuConfFile} {.:/usr/local/lib/xfemacs-c.tcl}
global {menuConfFont}
set {menuConfFont} {-adobe-helvetica-bold-r-normal--12-120-75-75-p-70-iso8859-1}
global {menuConfFontFile}
set {menuConfFontFile} {/usr/local/lib/tk/xf/lib/Fonts}
global {menuConfForeground}
set {menuConfForeground} {black}
global {menuConfPathNames}
set {menuConfPathNames} {. .frame0}
global {menuConfScrollActiveForeground}
set {menuConfScrollActiveForeground} {GhostWhite}
global {menuConfScrollBackground}
set {menuConfScrollBackground} {#dcdcdc}
global {menuConfScrollForeground}
set {menuConfScrollForeground} {gray}
global {menuConfState}
set {menuConfState} {normal}
global {menuConfUserFile}
set {menuConfUserFile} {~/.xfemacs-c.tcl}
global {oldBindPopupDown}
set {oldBindPopupDown} {<Mod1-Button-3>}
global {oldBindPopupMove}
set {oldBindPopupMove} {<B3-Mod1-Motion>}
global {oldBindPopupRelease}
set {oldBindPopupRelease} {<Any-ButtonRelease-3>}
global {readBoxActiveBackground}
set {readBoxActiveBackground} {white}
global {readBoxActiveForeground}
set {readBoxActiveForeground} {black}
global {readBoxBackground}
set {readBoxBackground} {#dcdcdc}
global {readBoxFont}
set {readBoxFont} {-adobe-helvetica-bold-r-normal--12-120-75-75-p-70-iso8859-1}
global {readBoxForeground}
set {readBoxForeground} {black}
global {readBoxScrollActiveForeground}
set {readBoxScrollActiveForeground} {GhostWhite}
global {readBoxScrollBackground}
set {readBoxScrollBackground} {#dcdcdc}
global {readBoxScrollForeground}
set {readBoxScrollForeground} {gray}
global {symbolicName}
set {symbolicName(root)} {.}
global {textBoxActiveBackground}
set {textBoxActiveBackground} {white}
global {textBoxActiveForeground}
set {textBoxActiveForeground} {Black}
global {textBoxBackground}
set {textBoxBackground} {#dcdcdc}
global {textBoxButton}
set {textBoxButton} {0}
global {textBoxFont}
set {textBoxFont} {-adobe-helvetica-bold-r-normal--12-120-75-75-p-70-iso8859-1}
global {textBoxForeground}
set {textBoxForeground} {Black}
global {textBoxScrollActiveForeground}
set {textBoxScrollActiveForeground} {GhostWhite}
global {textBoxScrollBackground}
set {textBoxScrollBackground} {#dcdcdc}
global {textBoxScrollForeground}
set {textBoxScrollForeground} {gray}

# stuff to display and remove toplevel windows
# call the procedures to create the toplevels.
ShowWindow.

# end source

  global argc
  global argv
  global emacsBuffList
  global emacsPollInterval
  global emacsUseAdvise
  global fsBoxFSPath
  global xfLoadPath

  if {[file exists ~/.xfemacs-o.tcl]} {
    catch "source ~/.xfemacs-o.tcl"
  }

  MenuConfInit ~/.xfemacs-c.tcl $xfLoadPath/xfemacs-c.tcl . .frame0
  EmacsUpdateResources
  EmacsSetBinding

  set runAsClient 0
  set tmpArgv ""
  set tmpLoadFile ""
  set tmpFunction ""
  for {set counter 0} {$counter < $argc} {incr counter 1} {
    case [string tolower [lindex $argv $counter]] in {
      {-client} {
        set runAsClient 1
      }
      {-load} {
        incr counter
        lappend tmpLoadFile [lindex $argv $counter]
      }
      {-function} {
        incr counter
        set tmpFunction [lindex $argv $counter]
      }
      {default} {
        lappend tmpArgv [lindex $argv $counter]
      }
    }
  }
  set argv $tmpArgv
  set argc [llength $tmpArgv]
  unset counter
  unset tmpArgv

  foreach counter $tmpLoadFile {
    SendToEmacs "(load \"$counter\")"
  }
  foreach counter $argv {
    SendToEmacs "(find-file \"$counter\")"
  }
  if {"[string trim $tmpFunction]" != ""} {
    SendToEmacs "($tmpFunction)"
  }

  set fsBoxFSPath [pwd]
  set emacsBuffList ""

  .frame.text send "(tk-advise-destroy-widget-on-exit)"
  .frame.text config -pollinterval $emacsPollInterval
  .frame.text config -useadvise $emacsUseAdvise

  wm deiconify .
  if {"[info commands ClientLogin]" != ""} {
    ClientLogin xfemacs
  }


# eof
#
