# Text.tcl - BOS Object wrapping tkText widget
#
# Text.tcl,v 1.3 1992/06/18 21:50:18 snl Exp
#
GraphicalObject refineWith Text

TextTraits defMethod initialize {parent {ro 0} {height 25} {width 80}} {
  set w [$self [$self graphicalObjectParent]:initialize $parent]
  frame $w
  frame $w.f
  set textw $w.f.text
  scrollbar $w.f.vs -command "$textw viewline" -relief sunken
  scrollbar $w.hs -relief sunken -orient horizontal
  text $textw -height $height -width $width \
    -scrollvcommand "$w.f.vs set" \
    -scrollhcommand "$w.hs set" \
    -wrapmode word
  if !$ro {
    $self _bindRW $textw
  } else {
    $self _bindRO $textw
  }
  pack append $w $w.f {top expand} $w.hs {bottom expand fillx}
  pack append $w.f \
    $w.f.vs {left expand filly} \
    $textw {left expand}
  $self set textWindow $textw
  return $w
}
TextTraits defMethod _bindRW {textw} {
  bind $textw <Any-KeyPress> "catch {%W insert cursor %A};$self changed"
  bind $textw <Enter> {focus %W}
  bind $textw <backslash> "%W insert cursor \"\\\\\";$self changed"
  bind $textw <braceleft> "%W insert cursor \"\{\";$self changed"
  bind $textw <braceright> "%W insert cursor \"\}\";$self changed"
  bind $textw <bracketleft> "%W insert cursor \"\\\[\";$self changed"
  bind $textw <bracketright> "%W insert cursor \"\]\";$self changed"
  bind $textw <quotedbl> "%W insert cursor \"\\\"\";$self changed"
  bind $textw <space> "%W insert cursor \" \";$self changed"
  bind $textw <Return> "%W insert cursor \"\n\";$self changed"
  bind $textw <2> "%W insert cursor \[selection get\];$self changed"
  bind $textw <Delete> "%W edit dpc;$self changed"
  bind $textw <BackSpace> "%W edit dpc;$self changed"
  bind $textw <Control-h> "%W edit dpc;$self changed"
  bind $textw <1> {%W cursor @%x,%y; focus %W; %W select from @%x,%y}
  bind $textw <B1-Motion> {%W select to @%x,%y}
  bind $textw <Shift-1> {%W select adjust @%x,%y}
  bind $textw <Shift-B1-Motion> {%W select to @%x,%y}
  bind $textw <3> {%W scan mark %x,%y}
  bind $textw <B3-Motion> {%W scan dragto %x,%y}
  bind $textw <Any-Left> {%W edit bc}
  bind $textw <Any-Right> {%W edit fc}
  bind $textw <Any-Up> {%W edit pl}
  bind $textw <Any-Down> {%W edit nl}
  bind $textw <Control-a> {%W edit bol}
  bind $textw <Control-b> {%W edit bc}
#  bind $textw <Control-c> {}
  bind $textw <Control-d> "%W edit dnc;$self changed"
  bind $textw <Control-e> "%W edit eol;$self changed"
  bind $textw <Control-f> "%W edit fc;$self changed"
#  bind $textw <Control-g> {}
#  bind $textw <Control-h> {}
#  bind $textw <Control-i> {}
#  bind $textw <Control-j> {}
  bind $textw <Control-k> "%W delete cursor eol;$self changed"
#  bind $textw <Control-l> {}
#  bind $textw <Control-m> {}
  bind $textw <Control-n> {%W edit nl}
  bind $textw <Control-o> "%W insert cursor \"\\n\";$self changed"
  bind $textw <Control-p> {%W edit pl}
#  bind $textw <Control-q> {}
#  bind $textw <Control-r> {}
#  bind $textw <Control-s> {}
#  bind $textw <Control-t> {}
#  bind $textw <Control-u> {}
  bind $textw <Control-v> "%W insert cursor \[selection get\];$self changed"
  bind $textw <Control-w> "$self killSel"
#  bind $textw <Control-x> {}
  bind $textw <Control-y> "$self yankKill"
#  bind $textw <Control-z> {}
}
TextTraits defMethod _bindRO {textw} {
  bind $textw <1> {%W cursor @%x,%y; focus %W; %W select from @%x,%y}
  bind $textw <B1-Motion> {%W select to @%x,%y}
  bind $textw <Shift-1> {%W select adjust @%x,%y}
  bind $textw <Shift-B1-Motion> {%W select to @%x,%y}
  bind $textw <3> {%W scan mark %x,%y}
  bind $textw <B3-Motion> {%W scan dragto %x,%y}
}
TextTraits defMethod viewLine {l} {
  [$self textWindow] viewline $l
}
TextTraits defMethod insertFile {filename} {
  [$self textWindow] insert 0 [exec cat $filename]
}
TextTraits defMethod insert {string} {
  $self insert@ cursor $string;
}
TextTraits defMethod append {string} {
  $self insert@ end $string;
}
TextTraits defMethod insert@ {pos string} {
  [$self textWindow] insert $pos $string;
}
TextTraits defMethod clear {} {
  [$self textWindow] delete 0 end;
}
TextTraits defMethod saveToFile {filename {mode w}} {
  set f [open $filename $mode]
  puts $f "[[$self textWindow] get]" nonewline
  close $f
}
TextTraits defMethod changed {} {
  if [llength [$self notifyOfChanges]] {
    [$self notifyOfChanges] textChanged [$self textWindow]
  }
}
TextTraits defMethod killSel {} {
  set tw [$self textWindow]
  if [catch {$tw index sel.first}] {
    return
  }
  set sf [$tw index sel.first]
  set sl [$tw index sel.last]
  $self set killBuffer "[$tw get $sf $sl]"
  $tw delete $sf $sl
  $self changed
}
TextTraits defMethod yankKill {} {
  if [string length [$self killBuffer]] {
    [$self textWindow] insert cursor "[$self killBuffer]"
    $self changed
  }
}

Text addSlot textWindow {}
Text addSlot notifyOfChanges {}
Text addSlot killBuffer "" 
