#include "tcl.h"
#include "tk.h"

#if defined(USE_XACCESS)
#include "tkXAccess.h"
#endif

#if defined(USE_MEGAWIDGET)
#include "tkMegaWidget.h"
#endif

/*
 * The following variable is a special hack that allows applications
 * to be linked using the procedure "main" from the Tk library.  The
 * variable generates a reference to "main", which causes main to
 * be brought in from the library (and all of Tk and Tcl with it).
 */

#if defined(USE_TCL_RAW_TCP)
extern int              Tcp_AcceptCmd _ANSI_ARGS_((ClientData clientData,
                            Tcl_Interp *interp, int argc, char **argv));
extern int              Tcp_ConnectCmd _ANSI_ARGS_((ClientData clientData,
                            Tcl_Interp *interp, int argc, char **argv));
extern int              Tcp_ShutdownCmd _ANSI_ARGS_((ClientData clientData,
                            Tcl_Interp *interp, int argc, char **argv));
extern int              Tcp_FileHandlerCmd _ANSI_ARGS_((ClientData clientData,
                            Tcl_Interp *interp, int argc, char **argv));
#endif

void init_steal( interp )
Tcl_Interp *interp;		/* Interpreter for application. */
{
  Tk_Window main;
  
  main = Tk_MainWindow(interp);

#if defined(USE_TCL_RAW_TCP)
  Tcl_CreateCommand(interp, "accept", Tcp_AcceptCmd,
                    (ClientData) NULL, (void (*) ()) NULL);
  Tcl_CreateCommand(interp, "shutdown", Tcp_ShutdownCmd,
                    (ClientData) NULL, (void (*) ()) NULL);
  Tcl_CreateCommand(interp, "connect", Tcp_ConnectCmd,
                    (ClientData) NULL, (void (*) ()) NULL);
  Tcl_CreateCommand(interp, "filehandler", Tcp_FileHandlerCmd,
                    (ClientData) NULL, (void (*) ()) NULL);
#endif

#if defined(USE_XACCESS)
  TkXAccess_Init(interp);
#endif
  
}
