'\"
'\" Copyright 1992 Regents of the University of California
'\" Permission to use, copy, modify, and distribute this
'\" documentation for any purpose and without fee is hereby
'\" granted, provided that this notice appears in all copies.
'\" The University of California makes no representations about
'\" the suitability of this material for any purpose.  It is
'\" provided "as is" without express or implied warranty.
'\" 
'\" Copyright 1993 by AT&T Bell Laboratories.
'\" Permission to use, copy, modify, and distribute this software
'\" and its documentation for any purpose and without fee is hereby
'\" granted, provided that the above copyright notice appear in all
'\" copies and that both that the copyright notice and warranty
'\" disclaimer appear in supporting documentation, and that the
'\" names of AT&T Bell Laboratories any of their entities not be used
'\" in advertising or publicity pertaining to distribution of the
'\" software without specific, written prior permission.
'\"
'\" AT&T disclaims all warranties with regard to this software, including
'\" all implied warranties of merchantability and fitness.  In no event
'\" shall AT&T be liable for any special, indirect or consequential
'\" damages or any damages whatsoever resulting from loss of use, data
'\" or profits, whether in an action of contract, negligence or other
'\" tortuous action, arising out of or in connection with the use or
'\" performance of this software.
'\"
'\" Bitmap command created by George Howlett.
'\"
.\" The definitions below are for supplemental macros used in Tcl/Tk
.\" manual entries.
.\"
.\" .HS name section [date [version]]
.\"	Replacement for .TH in other man pages.  See below for valid
.\"	section names.
.\"
.\" .AP type name in/out [indent]
.\"	Start paragraph describing an argument to a library procedure.
.\"	type is type of argument (int, etc.), in/out is either "in", "out",
.\"	or "in/out" to describe whether procedure reads or modifies arg,
.\"	and indent is equivalent to second arg of .IP (shouldn't ever be
.\"	needed;  use .AS below instead)
.\"
.\" .AS [type [name]]
.\"	Give maximum sizes of arguments for setting tab stops.  Type and
.\"	name are examples of largest possible arguments that will be passed
.\"	to .AP later.  If args are omitted, default tab stops are used.
.\"
.\" .BS
.\"	Start box enclosure.  From here until next .BE, everything will be
.\"	enclosed in one large box.
.\"
.\" .BE
.\"	End of box enclosure.
.\"
.\" .VS
.\"	Begin vertical sidebar, for use in marking newly-changed parts
.\"	of man pages.
.\"
.\" .VE
.\"	End of vertical sidebar.
.\"
.\" .DS
.\"	Begin an indented unfilled display.
.\"
.\" .DE
.\"	End of indented unfilled display.
.\"
'\"	# Heading for Tcl/Tk man pages
.de HS
.if '\\$2'cmds'       .TH \\$1 1 \\$3 \\$4
.if '\\$2'lib'        .TH \\$1 3 \\$3 \\$4
.if '\\$2'tcl'        .TH \\$1 3 \\$3 \\$4
.if '\\$2'tk'         .TH \\$1 3 \\$3 \\$4
.if t .wh -1.3i ^B
.nr ^l \\n(.l
.ad b
..
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ie !"\\$3"" \{\
.ta \\n()Au \\n()Bu
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp .5
..
.HS blt_bitmap cmds
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
blt_bitmap \- Define bitmap from data
.SH SYNOPSIS
\fBblt_bitmap define \fIname dataList\fR
.sp
\fBblt_bitmap bits \fIname\fR
.sp
\fBblt_bitmap data \fIname\fR
.sp
\fBblt_bitmap height \fIname\fR
.sp
\fBblt_bitmap width \fIname\fR
.BE
.SH DESCRIPTION
.PP
This command creates an internal bitmap for Tk from a list of data 
and associates it with a given name.  It essentially offers the 
functionality of \fBTk_DefineBitmap\fR at the Tcl programming level.  
.SH BITMAP COMMANDS
The following commands are available for \fBblt_bitmap\fR:
.TP
\fBblt_bitmap define \fIname dataList\fR 
Associates \fIname\fR with in-memory bitmap data so that \fIname\fR can 
be used in later calls to \fBTk_GetBitmap\fR. 
The \fIname\fR argument is the name of the bitmap; it must
not previously have been defined in either a call to Tk_DefineBitmap or
\fBblt_bitmap\fR.  The argument \fIdataList\fP describes
the bitmap to be created.  It is a list of two elements, the dimensions
and source data.  The dimensions are a list of two numbers which are
the width and height of the bitmap.  The source data is a list 
of hexadecimal values in a format similar to the X11 or X10 bitmap format.  
The values may be optionally separated by commas and do not need to 
be prefixed with "\fC0x\fR". 
.TP
\fBblt_bitmap bits \fIname\fR 
Returns the source data of the bitmap \fIname\fR. The source data is a 
list of the hexadecimal values.  
If \fIname\fR does not represent a valid bitmap, the empty string is
returned.
.TP
\fBblt_bitmap data \fIname\fR 
Returns a list of both the dimensions of the bitmap \fIname\fR and its 
source data. 
If \fIname\fR does not represent a valid bitmap, the empty string is
returned.
.TP
\fBblt_bitmap height \fIname\fR 
Returns the height of the bitmap \fIname\fR.
If \fIname\fR does not represent a valid bitmap, the empty string is
returned.
.TP
\fBblt_bitmap width \fIname\fR 
Returns the width of the bitmap \fIname\fR.
If \fIname\fR does not represent a valid bitmap, the empty string is
returned.
.SH EXAMPLES
The following examples demonstrate the various forms \fIdataList\fR 
may take in the \fBblt_bitmap\fR command.
.PP
The elements may or may not be separated by commas.
.DS 
\fCblt_bitmap define light_gray { { 4 2 } { 0x08, 0x02 } }\fR
\fCblt_bitmap define light_gray { { 4 2 } { 0x08 0x02 } }\fR
.DE
.PP
Each element is a hexadecimal number which is optionally prefixed
by "\fC0x\fR".
.DS
\fCblt_bitmap define light_gray { { 4 2 } { 8 2 } }\fR
.DE
.PP
The hex values of data can be represented in either X11 or X10 bitmap 
format.  In X11 bitmap format, each element is an unsigned character.
.DS 
\fCblt_bitmap define face { { 16 16 } {
   0x1f, 0xf8, 0xc7, 0xe3, 0xf3, 0xcf, 0xf9, 0x9f, 
   0xfd, 0xbf, 0xcc, 0x33, 0xfe, 0x7f, 0xfe, 0x7f, 
   0x7e, 0x7e, 0xfe, 0x7f, 0xec, 0x37, 0xdd, 0xbb,
   0x39, 0x9c, 0xf3, 0xcf, 0xc7, 0xe3, 0x1f, 0xf8 } 
}\fR
.DE
.PP
While in X10 format, they instead represent short integers.
.DS 
\fCblt_bitmap define face { 16 16 } { 
    0xf81f, 0xe3c7, 0xcff3, 0x9ff9, 0xbffd, 0x33cc, 
    0x7ffe, 0x7ffe, 0x7e7e, 0x7ffe, 0x37ec, 0xbbdd, 
    0x9c39, 0xcff3, 0xe3c7, 0xf81f
}\fR
.DE
.SH BUGS
.PP
There is no way to delete or redefine a bitmap.
.SH KEYWORDS
bitmap
