/* 
 * $Id: mwish.c,v 1.2 1993/06/08 06:17:38 david Exp $
 *
 * $Log: mwish.c,v $
 * Revision 1.2  1993/06/08  06:17:38  david
 * Convert to [interp library].
 *
 * Revision 1.1  1993/06/06  06:36:14  david
 * Initial revision.
 *
 */

#ifndef lint
static char rcsid[] = "$Header: /home/usr.stuff/cvsroot/minterp/mwish.c,v 1.2 1993/06/08 06:17:38 david Exp $ ";
#endif

#include <memory.h>
#include "tkConfig.h"
#include "tkInt.h"
#include "interp.h"

#ifdef USING_EXTENDED_TCL
#define TK_EXTENDED
#ifdef TK_EXTENDED
#    include "tclExtend.h"
#endif
#endif

Tcl_Interp *tk_mainInterp;  /* Need to process signals */

/* void Tk_AddDragDropCmd _ANSI_ARGS_((Tcl_Interp*, Tk_Window)); */
/* void init_lcompare _ANSI_ARGS_((Tcl_Interp*)); */
void init_interp _ANSI_ARGS_((Tcl_Interp*));

/*
 * Declarations for library procedures:
 */

extern int isatty();

static char *initCmd[] = {
#ifdef TK_EXTENDED
	"load wishx.tcl",
#else
	"source $tk_library/wish.tcl",
#endif
	"source /usr/prac/oo/dv/tk/src/minterp/init.tcl;",
	"interp MainInterp;",
	"require InterpBase;",
	"InterpBase add_module_directory [interp library];",
	"InterpBase -import MainInterp InterpBase [InterpBase -get EXPORTS]",
	(char *)0
};


Tk_Window Main_Window = (Tk_Window)NULL;
Tk_TimerToken timeToken = 0;
int idleHandler = 0;
Tcl_Interp *Main_Interp;
int x, y;
Tcl_CmdBuf buffer;
int tty;

/*
 * Information for testing out command-line options:
 */

int synchronize = 0;
char *fileName = NULL;
char *name = NULL;
char *display = NULL;
char *geometry = NULL;

Tk_ArgvInfo argTable[] = {
    {"-file", TK_ARGV_STRING, (char *) NULL, (char *) &fileName,
	"File from which to read commands"},
    {"-geometry", TK_ARGV_STRING, (char *) NULL, (char *) &geometry,
	"Initial geometry for window"},
    {"-display", TK_ARGV_STRING, (char *) NULL, (char *) &display,
	"Display to use"},
    {"-name", TK_ARGV_STRING, (char *) NULL, (char *) &name,
	"Name to use for application"},
    {"-sync", TK_ARGV_CONSTANT, (char *) 1, (char *) &synchronize,
	"Use synchronous mode for display server"},
    {(char *) NULL, TK_ARGV_END, (char *) NULL, (char *) NULL,
	(char *) NULL}
};

/*
 * Forward declarations for procedures defined later in this file:
 */
 
static void             DelayedMap _ANSI_ARGS_((ClientData clientData));
static void             StdinProc _ANSI_ARGS_((ClientData clientData,
                            int mask));
static void             StructureProc _ANSI_ARGS_((ClientData clientData,
                            XEvent *eventPtr));

/*
 *----------------------------------------------------------------------
 *
 * Tk_BellCmd --
 *
 *    This procedure is invoked to process the "bell" Tcl command.
 *    See the user documentation for details on what it does.
 *
 * Results:
 *    A standard Tcl result.
 *
 * Side effects:
 *    None.
 *
 *----------------------------------------------------------------------
 */
      /* ARGSUSED */
int
Tk_BellCmd(clientData, interp, argc, argv)
    ClientData clientData;    /* Main window associated with
                               * interpreter.*/
    Tcl_Interp *interp;               /* Current interpreter. */
    int argc;                 /* Number of arguments. */
    char **argv;              /* Argument strings. */
{
    Tk_Window tkwin = (Tk_Window) clientData;
    int percent;

    if (argc == 1) {
      percent = 50;
    } else if (argc == 2) {
      if ((Tcl_GetInt(interp, argv[1], &percent) != TCL_OK)
          || (percent < -100) || (percent > 100)) {
          Tcl_ResetResult(interp);
          Tcl_AppendResult(interp, "bad volume percentage value \"",
                           argv[1], "\"", (char *) NULL);
          return TCL_ERROR;
      }
    } else {
      Tcl_AppendResult(interp, "wrong # args: should be \"",
                       argv[0], " ?volumePercent?\"", (char *) NULL);
      return TCL_ERROR;
    }

    XBell(Tk_Display(tkwin), percent);
    return TCL_OK;
}

int
main(argc, argv)
    int argc;
    char **argv;
{
    char *args, *p, *msg;
    char buf[20];
    int result;
    Tk_3DBorder border;

#ifdef TK_EXTENDED
    tk_mainInterp = Main_Interp = Tcl_CreateExtendedInterp(); 
#else
    Main_Interp = Tcl_CreateInterp(); 
#endif
#ifdef TCL_MEM_DEBUG
    Tcl_InitMemory(Main_Interp);
#endif

    if (Tk_ParseArgv(Main_Interp, (Tk_Window) NULL, &argc, argv, argTable, 0)
	    != TCL_OK) {
	fprintf(stderr, "%s\n", Main_Interp->result);
	exit(1);
    }
    if (name == NULL) {
	if (fileName != NULL) {
	    p = fileName;
	} else {
	    p = argv[0];
	}
	name = strrchr(p, '/');
	if (name != NULL) {
	    name++;
	} else {
	    name = p;
	}
    }

    /*
     * Initialize the Tk application and arrange to map the main window
     * after the startup script has been executed, if any.  This way
     * the script can withdraw the window so it isn't ever mapped
     * at all.
     */

    Main_Window = Tk_CreateMainWindow(Main_Interp, display, name);

    if (Main_Window == NULL) {
	fprintf(stderr, "%s\n", Main_Interp->result);
	exit(1);
    }

        /* Tk_AddDragDropCmd(Main_Interp,Main_Window); */
	init_interp(Main_Interp);

    Tk_SetClass(Main_Window, "Tk");
    Tk_CreateEventHandler(Main_Window, StructureNotifyMask, StructureProc,
	    (ClientData) NULL);
    Tk_DoWhenIdle(DelayedMap, (ClientData) NULL);
    if (synchronize) {
	XSynchronize(Tk_Display(Main_Window), True);
    }
    Tk_GeometryRequest(Main_Window, 200, 200);
    border = Tk_Get3DBorder(Main_Interp, Main_Window, None, "#4eee94");
    if (border == NULL) {
	Tcl_SetResult(Main_Interp, (char *) NULL, TCL_STATIC);
	Tk_SetWindowBackground(Main_Window, WhitePixelOfScreen(Tk_Screen(Main_Window)));
    } else {
	Tk_SetBackgroundFromBorder(Main_Window, border);
    }

    XSetForeground(Tk_Display(Main_Window),DefaultGCOfScreen(Tk_Screen(Main_Window)),
	    BlackPixelOfScreen(Tk_Screen(Main_Window)));
    /*
     * Make command-line arguments available in the Tcl variables "argc"
     * and "argv".  Also set the "geometry" variable from the geometry
     * specified on the command line.
     */
 
    args = Tcl_Merge(argc-1, argv+1);
    Tcl_SetVar(Main_Interp, "argv", args, TCL_GLOBAL_ONLY);
    ckfree(args);
    sprintf(buf, "%d", argc-1);
    Tcl_SetVar(Main_Interp, "argc", buf, TCL_GLOBAL_ONLY);
    if (geometry != NULL) {
        Tcl_SetVar(Main_Interp, "geometry", geometry, TCL_GLOBAL_ONLY);
    }
 

    Tcl_CreateCommand(Main_Interp, "bell", Tk_BellCmd, (ClientData) Main_Window,
	    (void (*)()) NULL);

    /*
     * Execute Wish's initialization script, followed by the script specified
     * on the command line, if any.
     */

#ifdef TK_EXTENDED
    tclAppName     = "mwish";
    tclAppLongname = "Multiple interpretors in WISH";
    tclAppVersion  = TK_VERSION;
    Tcl_ShellEnvInit (Main_Interp, TCLSH_ABORT_STARTUP_ERR,
                      name,
                      0, NULL,           /* argv var already set  */
                      fileName == NULL,  /* interactive?          */
                      NULL);             /* Standard default file */
#endif

	{ int i;
	  for (i = 0; initCmd[i]; i++) {
		result = Tcl_Eval(Main_Interp, initCmd[i], 0, (char **) NULL);
		if (result != TCL_OK) {
			goto error;
		}
	}}
    tty = isatty(0);
    if (fileName != NULL) {
      result = Tcl_VarEval(Main_Interp, "source ", fileName, (char *) NULL);
      if (result != TCL_OK) {
          goto error;
      }
      tty = 0;
    } else {
      Tk_CreateFileHandler(0, TK_READABLE, StdinProc, (ClientData) 0);
      if (tty) {
          printf("mwish: ");
      }
    }
    fflush(stdout);
    buffer = Tcl_CreateCmdBuf();
    (void) Tcl_Eval(Main_Interp, "update", 0, (char **) NULL);

    /*
     * Loop infinitely, waiting for commands to execute.  When there
     * are no windows left, Tk_MainLoop returns and we clean up and
     * exit.
     */

    Tk_MainLoop();
    Tcl_DeleteInterp(Main_Interp);
    Tcl_DeleteCmdBuf(buffer);
    exit(0);

error:
    msg = Tcl_GetVar(Main_Interp, "errorInfo", TCL_GLOBAL_ONLY);
    if (msg == NULL) {
      msg = Main_Interp->result;
    }
    fprintf(stderr, "%s\n", msg);
    Tcl_Eval(Main_Interp, "destroy .", 0, (char **) NULL);
    exit(1);
    return 0;                   /* Needed only to prevent compiler warnings. */
}


/*
 *----------------------------------------------------------------------
 *
 * StdinProc --
 *
 *      This procedure is invoked by the event dispatcher whenever
 *      standard input becomes readable.  It grabs the next line of
 *      input characters, adds them to a command being assembled, and
 *      executes the command if it's complete.
 *
 * Results:
 *      None.
 *
 * Side effects:
 *      Could be almost arbitrary, depending on the command that's
 *      typed.
 *
 *----------------------------------------------------------------------
 */
 
    /* ARGSUSED */
static void
StdinProc(clientData, mask)
    ClientData clientData;              /* Not used. */
    int mask;                           /* Not used. */
{
    char line[200];
    static int gotPartial = 0;
    char *cmd;
    int result;
 
    if (fgets(line, 200, stdin) == NULL) {
        if (!gotPartial) {
            if (tty) {
                Tcl_Eval(Main_Interp, "destroy .", 0, (char **) NULL);
                exit(0);
            } else {
                Tk_DeleteFileHandler(0);
            }
            return;
        } else {
            line[0] = 0;
        }
    }
    cmd = Tcl_AssembleCmd(buffer, line);
    if (cmd == NULL) {
        gotPartial = 1;
        return;
    }
    gotPartial = 0;
    result = Tcl_RecordAndEval(Main_Interp, cmd, 0);
    if (*Main_Interp->result != 0) {
        if ((result != TCL_OK) || (tty)) {
            printf("%s\n", Main_Interp->result);
        }
    }
    if (tty) {
        printf("mwish: ");
        fflush(stdout);
    }
}


/*
 *----------------------------------------------------------------------
 *
 * StructureProc --
 *
 *      This procedure is invoked whenever a structure-related event
 *      occurs on the main window.  If the window is deleted, the
 *      procedure modifies "w" to record that fact.
 *
 * Results:
 *      None.
 *
 * Side effects:
 *      Variable "w" may get set to NULL.
 *
 *----------------------------------------------------------------------
 */
 
        /* ARGSUSED */
static void
StructureProc(clientData, eventPtr)
    ClientData clientData;      /* Information about window. */
    XEvent *eventPtr;           /* Information about event. */
{
    if (eventPtr->type == DestroyNotify) {
        Main_Window = NULL;
    }
}


/*
 *----------------------------------------------------------------------
 *
 * DelayedMap --
 *
 *      This procedure is invoked by the event dispatcher once the
 *      startup script has been processed.  It waits for all other
 *      pending idle handlers to be processed (so that all the
 *      geometry information will be correct), then maps the
 *      application's main window.
 *
 * Results:
 *      None.
 *
 * Side effects:
 *      The main window gets mapped.
 *
 *----------------------------------------------------------------------
 */
 
        /* ARGSUSED */
static void
DelayedMap(clientData)
    ClientData clientData;      /* Not used. */
{
 
    while (Tk_DoOneEvent(TK_IDLE_EVENTS) != 0) {
        /* Empty loop body. */
    }
    if (Main_Window == NULL) {
        return;
    }
    Tk_MapWindow(Main_Window);
}
