# passwd.tcl - format for passwd table
#
# version -
#	$Id$

set t_width(passwd) 110

set t_header(passwd) [format "%-8s %-4s %-4s %-40s %-25s %-30s" \
    name uid gid gcos home shell]

proc t_entry_proc(passwd) {entry} {
 set name [lindex $entry 0]
 set uid [lindex $entry 2]
 set gid [lindex $entry 3]
 set gcos [lindex $entry 4]
 set home [lindex $entry 5]
 set shell [lindex $entry 6]
 return [format \
 "%-8s %4d %4d %-40s %-25s %-30s" $name $uid $gid $gcos $home $shell]
}

proc t_sort_proc(passwd) {e1 e2} {
  return [expr {[lindex $e1 2] > [lindex $e2 2]}]
}

# --- last line of passwd.tcl ---
