'\"
'\" Copyright 1992 The Australian National University.
'\"
'\" Permission to use, copy, modify, and distribute this documentation
'\" is hereby granted, provided that the above copyright
'\" notice appears in all copies.  This software is provided without any
'\" warranty, express or implied. The Australian National University
'\" makes no representations about the suitability of this software for
'\" any purpose.
'\"
'\" Author: Paul Mackerras (paulus@cs.anu.edu.au)
'\"
'\" $Header: /home/paulus/CaVis/othersrc/tk3.3/doc/RCS/colorfocus.n,v 1.2 1993/10/20 05:39:31 paulus Exp $
'\"
.so man.macros
.HS colorfocus tk
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
colorfocus \- Control the colormap focus of an application
.SH SYNOPSIS
\fBcolorfocus \fIwindow\fR
.br
\fBcolorfocus remove \fIwindow\fR
.BE

.SH DESCRIPTION
.PP
The \fBcolorfocus\fR command is used to manage the Tk colormap focus.
An application may have windows which use colormaps other than the
default.  Each screen of an X workstation has a limit, imposed by the
hardware, on how many different colormaps may be installed at one
time; often this limit is one.  If the windows on a screen use more
colormaps than are available on that screen, then an appropriate
`colormap focus' policy must be applied to determine which windows
have their colormaps installed.
.PP
The window manager ultimately
controls the colormap focus policy, but applications can express a
preference about which of their subwindows should have their colormaps
installed by means of the WM_COLORMAP_WINDOWS property.  This property
takes the form of a list of windows in decreasing order of importance
to the application of having the window's colormap installed. 
.PP
Tk automatically creates and maintains such a list whenever any window
in the application uses a colormap other than the default.  The
\fBcolorfocus\fR command allows the user to manipulate this list.
Tk maintains a list for each display screen used by the application.
This gives a global colormap focus over all top-level windows of the
application on a particular screen, rather than a local focus for each
top-level window.  This is consistent with the way that Tk manages the
input focus.
.PP
The \fBcolorfocus\fR command has two forms:
.TP
\fBcolorfocus \fIwindow\fR
This form moves \fIwindow\fR to the front of the list for its screen
(adding it if it is not already in the list).  This should cause the
window manager to install \fIwindow\fR's colormap whenever it assigns
the colormap focus to any top-level window of this application on the
same screen.
.TP
\fBcolorfocus remove \fIwindow\fR
This form removes \fIwindow\fR from the list for its screen, in effect
telling the window manager not to install its colormap.

.SH KEYWORDS
colormap, focus, window manager
