.\"**********************************************************************
.\"*									*
.\"*	Copyright 1993 by Motorola Wireless Data Group,			*
.\"*			  Bothell, WA					*
.\"*									*
.\"*	Motorola hereby grants permission to use, copy, modify and	*
.\"*	distribute  this software and its documentation for any		*
.\"*	purpose and without fee, provided that you retain this		*
.\"*	copyright notice in all copies.  Motorola makes no		*
.\"*	representations about the suitability of this software for any	*
.\"*	purpose.  Motorola provides this software ``as is'' without	*
.\"*	express or implied warranty.					*
.\"*									*
.\"**********************************************************************
.\"
.\" $Header: /sea/ntu/tools/src/bin/tcl/SVipc/man/RCS/msg.n,v 1.4 1993/08/18 21:38:30 kelsey Exp $
.\"
.TH "Tcl_message_queues" TCL "" "Tcl"
.SH NAME
msgget, msgrcv, msgrmid, msgset, msgsnd, msgstat - Tcl interface to
message queue IPC functions.

.SH SYNOPSIS
.nf
\fBmsgget \fIkey ?mode? ?create? ?excl?\fR

\fBmsgrcv \fImsqid msgtyp ?msgsz? ?noerror? ?nowait? ?varName?\fR

\fBmsgrmid \fImsqid\fR

\fBmsgset \fImsqid {uid gid mode} msg_qbytes\fR

\fBmsgsnd \fImsqid msgtyp msgtext ?nowait?\fR

\fBmsgstat \fImsqid ?varName?\fR
.fi

.SH DESCRIPTION
These commands allow access to the System V IPC message queues from Tcl
applications.  They generally allow the same functionality as the
msgop(2), msgget(2), msgctl(2), msgsnd(2) and msgrcv(2) system calls.
'
.SS msgget
Create or connect to a message queue.  The \fImode\fR optional
parameter sets the message queue permissions if the message queues
does not yet exist.  The \fIcreate\fR and \fIexcl\fR
optional parameters set the IPC_CREAT and IPC_PRIVATE flags in the
msgget(2) system call.
'
.SS msgrcv
Tries to remove a message of type \fImsgtyp\fR from the indicated
queue.  The optional parameter \fImsgsz\fR indicates the maximum
number of message text to return.  The optional parameters
\fInoerror\fR and \fInowait\fR set the MSG_NOERROR and IPC_NOWAIT
flags respectively on the msgrcv(2) system call.  If you include the
optional variable name, the command also returns the message text and
message type in the array elements \fBmtype\fR and \fBmtext\fR.  The
command also returns the list {mtype mtext} as its result.
'
.SS msgrmid
Removes the specified message queue by calling msgctl(2) with the
IPC_RMID command.
'
.SS msgset
Modify the owner, group, permissions, and maximum queue size of a
message queue, by using the msgctl(2) system call with the IPC_SET command.
'
.SS msgsnd
Places a message of type \fImsgtyp\fR containing \fImtext\fR on the
indicated queue.  The optional parameter \fInowait\fR sets the
IPC_NOWAIT flag on the msgsnd(2) system call.
'
.SS msgstat
Return all known status about the message queue, placing the returned
status into the named array or returning a structured list value.  If
you pass a variable name, the command places the IPC_STAT values into
the array elements \fBcuid\fR, \fBcgid\fR, \fBuid\fR, \fBgid\fR,
\fBmode\fR, \fBseq\fR, \fBkey\fR, \fBcbytes\fR, \fBqnum\fR,
\fBqbytes\fR, \fBlspid\fR, \fBlrpid\fR, \fBstime\fR, \fBrtime\fR, and
\fBctime\fR.  This command also returns a structured list containing
the values:
.sp
.in 0.5i
.nf
{{cuid cgid uid gid mode seq key} cbytes qnum qbytes lspid lrpid stime rtime ctime}
.fi
'
.SH SEE ALSO
msgctl(2), msgget(2), msgop(2), msgrcv(2), msgsnd(2), msgrcv(2)

.SH AUTHOR
.nf
Joe Kelsey
Motorola Wireless Data Group
19807 North Creek Parkway
Bothell, WA  98011
206.489.5746
kelsey@mdd.comm.mot.com
