/*
 * A Motif program to send and receive messages internally, to its own
 * buttons. It can also send a message to tkSend4 to increment its button
 */

#include <stdio.h>
#include <Xm/Label.h>
#include <Xm/PushB.h>
#include <Xm/RowColumn.h>
#include "../tclXtSend.h"

void
SendTo1(w, clientData, callData)
    Widget w;
    XtPointer clientData;
    XtPointer callData;
{
    Tcl_Interp *interp = (Tcl_Interp *) clientData;
    char sendCommand[1024];

    strcpy(sendCommand,
		"send xmSend4 incrementLabel1");
    if (Tcl_Eval(interp, sendCommand) != TCL_OK)
	fprintf(stderr, "send failed: %s\n", interp->result);
}

void
SendTo2(w, clientData, callData)
    Widget w;
    XtPointer clientData;
    XtPointer callData;
{
    Tcl_Interp *interp = (Tcl_Interp *) clientData;
    char sendCommand[1024];

    strcpy(sendCommand,
		"send xmSend4 incrementLabel1; incrementLabel2");
    if (Tcl_Eval(interp, sendCommand) != TCL_OK)
	fprintf(stderr, "send failed: %s\n", interp->result);
}
 
void
SendTo3(w, clientData, callData)
    Widget w;
    XtPointer clientData;
    XtPointer callData;
{
    Tcl_Interp *interp = (Tcl_Interp *) clientData;
    char sendCommand[1024];

    strcpy(sendCommand,
		"send tkSend4 incrementLabel");
    if (Tcl_Eval(interp, sendCommand) != TCL_OK)
	fprintf(stderr, "send failed: %s\n", interp->result);
}


char incrementLabelCmd[] = "\
  proc incrementLabel1 {} { \n\
    getLabel1 value \n\
    incr value \n\
    setLabel1 $value \n\
  } \n\
  proc incrementLabel2 {} { \n\
    getLabel2 value \n\
    incr value \n\
    setLabel2 $value \n\
  } \n\
  proc incrementLabel3 {} { \n\
    getLabel3 value \n\
    incr value \n\
    setLabel3 $value \n\
  } \
";

int
SetLabel(clientData, interp, argc, argv)
    ClientData *clientData;
    Tcl_Interp *interp;
    int argc;
    char **argv;
{
    XmString xmstr;
    Widget w = (Widget) clientData;

    if (argc < 2) {
	Tcl_SetResult(interp, "setLabel label", TCL_STATIC);
	return TCL_ERROR;
    }

fprintf(stderr, "**Setting label to %s\n", argv[1]);
    xmstr = XmStringCreateLocalized(argv[1]);
    XtVaSetValues(w, XmNlabelString, xmstr, NULL);
    XmStringFree(xmstr);

    return TCL_OK;
}

int
GetLabel(clientData, interp, argc, argv)
    ClientData *clientData;
    Tcl_Interp *interp;
    int argc;
    char **argv;
{
    XmString xmstr;
    String str;
    Widget w = (Widget) clientData;

    if (argc < 2) {
	Tcl_SetResult(interp, "getLabel \"label\"", TCL_STATIC);
	return TCL_ERROR;
    }

    XtVaGetValues(w, XmNlabelString, &xmstr, NULL);
    XmStringGetLtoR(xmstr, XmFONTLIST_DEFAULT_TAG, &str);
    Tcl_SetVar(interp, argv[1], str, 0);

    XtFree(str);
    XmStringFree(xmstr);

    return TCL_OK;
}

int
main(argc, argv)
    int argc;
    char **argv;
{
    Widget toplevel;
    Widget rc;
    Widget button;
    Widget label;
    Tcl_Interp *interp;
    XtAppContext app;

    toplevel = XtAppInitialize(&app, "XmSend", NULL, 0, &argc, argv,
				NULL, NULL, 0);

    interp = Tcl_CreateInterp();

    if (TclXtSend_RegisterInterp(interp, "xmSend4", toplevel) == TCL_ERROR) {
	fprintf(stderr, "couldn't register interpreter %s\n", argv[0]);
	exit(1);
    }

    rc = XmCreateRowColumn(toplevel, "rc", NULL, 0);
    XtManageChild(rc);
    XtVaSetValues(rc,
		XmNpacking, XmPACK_COLUMN,
		XmNnumColumns, 2,
		NULL);

    button = XmCreatePushButton(rc, "Incr label1", NULL, 0);
    XtManageChild(button);
    XtAddCallback(button, XmNactivateCallback, SendTo1, (XtPointer) interp);

    button = XmCreatePushButton(rc, "Incr 1&2", NULL, 0);
    XtManageChild(button);
    XtAddCallback(button, XmNactivateCallback, SendTo2, (XtPointer) interp);

    button = XmCreatePushButton(rc, "Incr tkSend4", NULL, 0);
    XtManageChild(button);
    XtAddCallback(button, XmNactivateCallback, SendTo3, (XtPointer) interp);

    label = XmCreateLabel(rc, "1", NULL, 0);
    XtManageChild(label);
    Tcl_CreateCommand(interp, "setLabel1", SetLabel, (ClientData *) label,
		(Tcl_CmdDeleteProc *) NULL);
    Tcl_CreateCommand(interp, "getLabel1", GetLabel, (ClientData *) label,
		(Tcl_CmdDeleteProc *) NULL);

    label = XmCreateLabel(rc, "2", NULL, 0);
    XtManageChild(label);
    Tcl_CreateCommand(interp, "setLabel2", SetLabel, (ClientData *) label,
		(Tcl_CmdDeleteProc *) NULL);
    Tcl_CreateCommand(interp, "getLabel2", GetLabel, (ClientData *) label,
		(Tcl_CmdDeleteProc *) NULL);

    label = XmCreateLabel(rc, "3", NULL, 0);
    XtManageChild(label);
    Tcl_CreateCommand(interp, "setLabel3", SetLabel, (ClientData *) label,
		(Tcl_CmdDeleteProc *) NULL);
    Tcl_CreateCommand(interp, "getLabel3", GetLabel, (ClientData *) label,
		(Tcl_CmdDeleteProc *) NULL);

    XtRealizeWidget(toplevel);

    /*
     * Create tcl commands based in C, and then load a procedure
     */
    if (Tcl_Eval(interp, incrementLabelCmd) != TCL_OK)
	fprintf(stderr, "couldn't load cmds: %s\n", interp->result);


    XtAppMainLoop(app);
}
