.TH TmText 3 "24 July 1993"
.SH NAME
.B TmText
- the Text widget class
.SH SYNOPSIS
.B xmText
\ pathName [options]
.br

.SH DESCRIPTION
This is the
.I tcl
binding to the Motif Text widget.

.SH CLASSES
The class name for resource files is
.B XmText.
Resources are inherited from
.B TmPrimitive, TmCore.
Methods are inherited from
.B TmCore.

.SH RESOURCES
The new resources are
.IP
autoShowCursorPosition
.br
cursorPosition
.br
editable
.br
editMode
br
marginHeight
.br
marginWidth
.br
maxLength
.br
source
.br
topCharacter
.br
value
.br
valueWCS
.br
verifyBell
.LP
.TP 5 5
\fB editable\fR
The values for this resource are
.RS 10
.br
true
.br
false
.RE
.B editMode
The values for this resource are
.RS 10
single_line_edit
.br
multi_line_edit
.RE

.SH METHODS
New methods for this class are
.RS 5
activateCallback
.br
focusCallback
.br
gainPrimaryCallback
.br
losePrimaryCallback
.br
losingFocusCallback
.br
modifyVerifyCallback
.br
motionVerifyCallback
.br
valueChangedCallback
.br
clearSelection
.br
copy
.br
cut
.br
disableRedisplay
.br
enableRedisplay
.br
findString
.br
getEditable
.br
getInsertionPosition
.br
getSelection
.br
getSelectionPosition
.br
getString
.br
getSubstring
.br
getTopCharacter
.br
insert
.br
paste
.br
replace
.br
remove
.br
scroll
.br
setAddMode
.br
setEditable
.br
setHighlight
.br
setInsertionPosition
.br
setSelection
.br
setSource
.br
setString
.br
setTopCharacter
.br
showPosition
.RE

.LP
.TP 5 5
.B clearSelection
clears the primary selection

.TP 5 5
.B copy
copies the primary selection to the clipboard

.TP 5 5
.B cut
copies the primary selection to the clipboard and deletes the selected text.

.TP 5 5
\fB findString\fP \fI start string direction position \fP
searches for the
.I string
in the specified 
.I direction
starting from the given
.I start.
The possible values of 
.I direction
are \fB forward\fP or \fB backward\fP.
The method returns \fB true \fP or \fB false \fP if the string is found
or not found. 
If it is found, the location of the first character of the string
(counting from 0) is returned in the tcl variable
.I position.

.TP 5 5
.B getEditable
returns \fB true\fP or \fB false\fP indicating
whether or not the widget can be edited.

.TP 5 5
.B getInsertionPosition
returns the location of the insertion cursor.

.TP 5 5
.B getLastPosition
returns the last position in the text.

.TP 5 5
.B getSelection
returns the value of the primary selection.

.TP 5 5
\fB getSelectionPosition\fP \fI left right\fP
returns \fB true\fP f the widget owns the primary selection,
else returns \fB false\fP.
The left and right positions of the primary selection are returned
in the tcl variables
\fI left \fP and \fI right\fP.

.TP 5 5
.B getString
returns the value in the widget.

.TP 5 5
\fB getSubstring\fP \fI start num_chars buffer\fP
stores the substring in the tcl variable
.I buffer.
The method returns \fB succeded\fP, \fB failed\fP or \fB truncated\fP.

.TP 5 5
.B getTopCharacter
returns the position of the first character displayed.

.TP 5 5
\fB insert\fP \fI position text\fP
inserts the \fI text\fP into the widget at \fI position\fP.

.TP 5 5
.B paste
insert the clipboard selection.

.TP 5 5
\fB replace\fP \fI from to value\fP
replaces the text with the new \fI value\fP.

.TP 5 5
\fB scroll\fP \fI lines\fP
scroll the text widget. A negative number of lines scrolls downward.

.TP 5 5
\fB setAddMode\fP \fI boolean\fP
sets the add mode of the text widget.

.TP 5 5
\fB setEditable\fP \fI boolean\fP
set the editable state of the widget.

.TP 5 5
\fB setHighlight \fP \fI left right mode\fP
set the highlight mode for the text between the positions to one
of the \fI highlight\fP values of
\fB normal selected secondary_selected\fP.

.TP 5 5
\fB setInsertionPosition\fP \fI position\fP
set the location of the insertion cursor.

.TP 5 5
\fB setSelection\fP \fI first last\fP
set the primary selection of the text to between the positions.

.TP 5 5
\fB setSource\fP \fI widget top position\fP
sets the source of the current text widget to be the same as
\fI widget\fP and specifies where the top display and where the insertion
cursor are.

.TP 5 5
\fB setString\fP \fI value\fP
sets the text value.

.TP 5 5
\fB setTopCharacter\fP \fI top\fP
sets the top position of the text display.

.TP 5 5
\fB showPosition\fP \fI position\fP
force the text at the \fI position\fP to be displayed.

.SH "CALLBACK SUBSTITUTIONS
The substitutions supported for this class are
.RS 5
.B %reason
\ - the additional values are 
.RS 5
activate 
.br
focus 
.br
gain_primary 
.br
lose_primary 
.br
modifying_text_value 
.br
moving_insert_cursor 
.br
value_changed
.RE
.br
.B %doit
- the tcl variable to set to true or false to allow changes
.br
.B %currInsert
- current position of the insertion cursor
.br
.B %newInsert
- position to which cursor move is attempted
.br
.B %startPos
- itcl variable with starting position of text to modify
.br
.B %endPos
- tcl variable with end position of text to modify
.br
.B %ptr
- tcl variable with text to be inserted
.br
.B %length
- tcl variable with length of text to be inserted
.RE

.SH AUTHOR
.LP
Jan Newmarch, University of Canberra
