.TH TmString 3 "24 July 1993"
.SH NAME
.B TmString
- the string to XmString conversion
.SH SYNOPSIS
This section describes the way strings are converted to XmStrings.
.br
.SH DESCRIPTION
Motif uses a data type known as XmString. This is a compound string
format, containing rendition information such as direction and font.
XmStrings are used in a number of places, most notably in the label
of a Label widget.

In the conversion of a string to an XmString, the following format
rules are applied:
.LP 5
The string is treated as a list of words.

Words in the list are concatenated with a single space between them,
no matter what the original white space between them.

Individual words may be quoted either by quotes "..." or brackets {...}.
White space within a quoted word is preserved, but the quote marks or
brackets are discarded.

If a word begins with the character '@' then it is treated as a control
word for the formatting.
@n places a newline component in the XmString.
@L or @l places a left-to-right component in the XmString.
@R or @r places a right-to-left component in the XmString.
@f\fIX\fP places a  font component in the XmString, where the single character 
.I X
is the font tag.
@f(\fIXY\fP places a  font component in the XmString, where the two character 
.I XY
is the font tag.
@F{\fIfont-tag\fP} places a  font component in the XmString, where 
.I font-tag 
is the font tag of any length.

The font tag is matched with a font as specified in the fontList of the
widget that the XmString is rendered in. The fontList is a list of
\fIfont-name=font-tag\fP specifiers separated by commas.

Example
.DS
 .label setValues \\
     -fontList "9x15=R, 9x15bold=bold" \\
     -labelString "ordinary @r right-to-left @f{bold}
                   right-to-left bold text 
                   @fR @l ordinary font, left to right"
.DE
.SH BUGS
None known.
.SH AUTHOR
.LP
Jan Newmarch, University of Canberra
