/*
 * Copyright (c) 1989,
 * 	National Center for Atmospheric Research
 *
 */
#if !defined(LINT) && !defined(VX)
static char rcsid[]="$Header: /net/src3/btcl/tclTCP2.1/src/RCS/clntStrmSock.c,v 1.3 1994/08/04 13:26:53 vanandel Exp $";
#endif

/*
 * Revision history:
 * $Log: clntStrmSock.c,v $
 * Revision 1.3  1994/08/04  13:26:53  vanandel
 * added include files to suppress compile warnings
 *
 * Revision 1.2  1994/07/12  20:57:59  vanandel
 * use memset() for system 5 compat
 *
 * Revision 1.1  1994/03/09  18:46:39  vanandel
 * Initial revision
 *
 * Revision 1.1  1993/11/18  16:08:18  vanandel
 * Initial revision
 *
 * Revision 1.6  1992/09/25  15:34:21  vanandel
 * made host byte order independent for more portability
 *
 * Revision 1.5  1992/02/10  18:58:18  vanandel
 * changed timeout to mS
 *
 * Revision 1.4  1992/02/10  18:48:18  vanandel
 * added Unix non-blocking version
 *
 * Revision 1.3  1989/11/04  17:56:34  vanandel
 * fixed rcsid string
 *
 * Revision 1.2  89/11/04  17:52:55  vanandel
 * added copyright to file
 * 
 */

#ifdef VX
#include "in.h"
#include "socket.h"
#include "sockLib.h"
#include "hostLib.h"
#include "ioLib.h"
#include "string.h"	/* for bzero() */

#else
#include <stdio.h>
#include <unistd.h>
#include <memory.h>
#include <string.h>

#include "localTypes.h"
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <sys/time.h>
#include <sys/errno.h>
#ifndef  FIONBIO
#include <sys/filio.h>
#endif
#endif


int clntStrmSock(host,port)
	char *host;
	int port;

{
    struct sockaddr_in	serverAddr;		/* server's address */
    int clientSock;

    /* Zero out the sock_addr structures. */
    /* This MUST be done before the socket call. */

#ifdef BZERO
    bzero ((char *)&serverAddr, sizeof (serverAddr));
#else
    memset(&serverAddr, 0, sizeof (serverAddr));
#endif

    /* Open the socket. */
    /* Use ARPA Internet address format and stream sockets. */

    clientSock = socket (AF_INET, SOCK_STREAM, 0);
    if (clientSock == ERROR) {
	(void)close (clientSock);
	return(ERROR);
    }

    serverAddr.sin_addr.s_addr  = hostGetByName(host);

    serverAddr.sin_family = AF_INET;
    serverAddr.sin_port   = htons(port);	

    if (connect(clientSock,(struct sockaddr *)&serverAddr,sizeof(serverAddr))
	==ERROR) {
	(void )close (clientSock);
	return (ERROR);
    }
    return(clientSock);
}

/*
 * this version of clntStrmSock() allows specifying how long to wait
 * before timing out on the connection request
 * only implemented for Unix version, right now
 */

int clntStrmSock2(host,port, block_time)
	char *host;
	int port;
	int block_time;		/* in milliSeconds */

{
    struct sockaddr_in	serverAddr;		/* server's address */
    int clientSock;
#ifndef VX
    int arg;
    fd_set fdset;
    struct timeval timeout;
    extern int errno;
#endif

    /* Zero out the sock_addr structures. */
    /* This MUST be done before the socket call. */

#ifdef BZERO
    bzero ((char *)&serverAddr, sizeof (serverAddr));
#else
    memset(&serverAddr, 0, sizeof (serverAddr));
#endif

    /* Open the socket. */
    /* Use ARPA Internet address format and stream sockets. */

    clientSock = socket (AF_INET, SOCK_STREAM, 0);
    if (clientSock == ERROR) {
	return(ERROR);
    }
#ifndef VX
    arg = 1;
    /* set NO-delay, so we timeout quickly if remote side isn't responding */

    if (ioctl(clientSock, FIONBIO, &arg) < 0)
    {
	fprintf(stderr, "ioctl failed\n");
	return(ERROR);
    }
#endif

    serverAddr.sin_addr.s_addr  = hostGetByName(host);

    serverAddr.sin_family = AF_INET;
    serverAddr.sin_port   = htons(port);	

    if (connect(clientSock,(struct sockaddr *)&serverAddr,sizeof(serverAddr))
	==ERROR) {
#ifndef VX
	/* with NON-BLOCK I/O connect doesn't happen instantly, 
	* so we'll wait briefly */
	if (errno ==  EINPROGRESS)
	{
	    FD_ZERO(&fdset);
	    FD_SET(clientSock, &fdset);
	    timeout.tv_sec = block_time/1000;
	    timeout.tv_usec = (block_time % 1000) * 1000;
	    /* if the connection doesn't timeout, we're connected */
	    if (select( FD_SETSIZE, NULL, &fdset, NULL, &timeout) >= 0)
	    {
		/* now,restore the normal blocking function on the descriptor 
		 * so that reads can block without returning error
		 */
		arg = 0;

		if (ioctl(clientSock, FIONBIO, &arg) < 0)
		{
		    fprintf(stderr, "ioctl failed\n");
		    return(ERROR);
		}
		return(clientSock);
	    }
	}

#endif
	(void )close (clientSock);
	return (ERROR);
    }
    return(clientSock);
}
