/*
 * Copyright (c) 1990, 1991 Stanford University
 *
 * Permission to use, copy, modify, and distribute this software and 
 * its documentation for any purpose is hereby granted without fee, provided
 * that (i) the above copyright notices and this permission notice appear in
 * all copies of the software and related documentation, and (ii) the name
 * Stanford may not be used in any advertising or publicity relating to
 * the software without the specific, prior written permission of
 * Stanford.
 * 
 * THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND, 
 * EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY 
 * WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  
 *
 * IN NO EVENT SHALL STANFORD BE LIABLE FOR ANY SPECIAL, INCIDENTAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND, OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER OR NOT
 * ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF LIABILITY,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 */
/*
 * Copyright 1992 by the National Optical Astronomy Observatories(*)
 *
 * Permission to use, copy, and distribute for non-commercial purposes,
 * is hereby granted without fee, providing that the above copyright
 * notice appear in all copies and that both the copyright notice and this
 * permission notice appear in supporting documentation.
 *
 * This software is provided "as is" without any express or implied warranty.
 *
 * (*) Operated by the Association of Universities for Research in
 *     Astronomy, Inc. (AURA) under cooperative agreement with the
 *     National Science Foundation.
 */
/* Program: tclIPC.x
 *      This is the RPCGEN input file that describes the data passed
 *      during the send IPC calls.  This is duplicated (by hand...) in
 *      tclipc.h for library users.
 *
 * Created: K. Gillies 26 June 1992
 *
 * SCCS INFO
 *      %W% %G%
 */
%#ifndef _rpc_rpc_h
%#include <rpc/rpc.h>
%#endif

const IPCHDR = 1;
const PortMgrPortNumber = 6600;
const AnyPort = 0;

struct Port
{
  string        hostName<>;
  string        appName<>;
  int           portNumber;
};

/*
 * Max size of TCL cmd/return string
 */
const EVAL_SIZE = 8192;

/*
 * String pointer
 */
typedef string cmdText <EVAL_SIZE>;
struct cmdType {
  int destinationPort;
  cmdText cmd;
};

/*
 * Command return structure
 */
struct evalcmd_res {
    int errno;
    cmdText text;
};
%extern  evalcmd_res * cmdsend_4_svc();

program TCLIPC
{
  version FIRSTTESTVERSION
    {
      evalcmd_res CmdSend(cmdType) = 1;
    }
  = 4;
}
= 0x20009001;             /* One more than bret's */
