#include "vogle.h"

/*
 * noop
 *
 *	do nothing but return -1
 */
static int
noop()
{
	return(-1);
}

/*
 * NULL_init
 *
 *	set up the postcript environment. Returns 1 on success.
 */
static
NULL_init()
{
	vdevice.sizeSy = vdevice.sizeSx = vdevice.sizeX = vdevice.sizeY = 1024; 
	return (1);
}

/*
 * NULL_exit
 *
 */
static
NULL_exit()
{
}

/*
 * NULL_draw
 *
 */
static
NULL_draw(x, y)
	int	x, y;
{
}

/*
 * NULL_font
 *
 */
static
NULL_font(font)
	char	*font;
{
	if (strcmp(font, "small") == 0) {
		vdevice.hwidth = 22.0;
		vdevice.hheight = vdevice.hwidth * 1.833;
	} else if (strcmp(font, "large") == 0) {
		vdevice.hwidth = 35.0;
		vdevice.hheight = vdevice.hwidth * 1.833;

	}
	return(1);
}

/*
 * NULL_clear
 *
 */
static
NULL_clear()
{
}

/*
 * NULL_color
 *
 */
static
NULL_color(col)
	int	col;
{
}
	
/*
 * NULL_char
 *
 */
static
NULL_char(c)
	char	c;
{
}

/*
 * NULL_string
 *
 */
static
NULL_string(s)
	char	*s;
{
}

/*
 * NULL_fill
 *
 *      fill a polygon
 */
static
NULL_fill(n, x, y)
	int     n, x[], y[];
{
	vdevice.cpVx = x[n - 1];
	vdevice.cpVy = y[n - 1];
}

static DevEntry nullDev = {
	"null",
	"large",
	"small",
	noop,
	NULL_char,
	noop,
	NULL_clear,
	NULL_color,
	NULL_draw,
	NULL_exit,
	NULL_fill,
	NULL_font,
	noop,
	noop,
	NULL_init,
	noop,
	noop,
	NULL_string,
	noop,
	noop
};

/*
 * _NULL_devcpy
 *
 *	copy the postscript device into vdevice.dev.
 */
_NULL_devcpy()
{
	vdevice.dev = nullDev;
}
