#
# screenScale.t
#
# An example of how to make a paint proc that draw's in units of screen pixels
# with the origin at the lower left of the widget
#
#

proc PixelUnitPaint {widgetname} {

    # move origin to lower left corner
    g_translate -1 -1

    # rescale the world coordinates such that 
    # 1 world unit = 1 pixel
    g_scale [expr 2.0/[winfo width $widgetname]] \
            [expr 2.0/[winfo height $widgetname]]

    # draw a short wide rectangle in the lower left 
    # corner of the widget
    g_color white
    g_rect 4 4 800 64
}

wm minsize . 64 64 
graphic .top -command {PixelUnitPaint .top} \
    -font helvetica-bold \
    -geometry 300x300 -bg black \
    -relief raised \
    -squareaspect false
pack append . .top {top fill expand}
