/*
 * mathCmds.c
 *
 */
/*
 *macros 
 */
#include <stdio.h>
#include <tcl.h>

static char *G_FLOAT_FMT = "%g";
#define G_FLOAT_STR_SIZE 32

#define strEQ(a,b) (*(a)==*(b)&&!strcmp(a,b))
#define Set_Float(interp, scratch, varname, f) \
	sprintf(scratch, G_FLOAT_FMT, f), Tcl_SetVar(interp, varname, scratch)

mth_dblRetDblCmd (cdata, interp, argc, argv)
    double (* cdata)(); Tcl_Interp *interp; int argc; char **argv;
{
    char buf[G_FLOAT_STR_SIZE];
    double d;
    if (argc != 2 || (Tcl_GetDouble(interp, argv[1], &d) == TCL_ERROR)) {
	return args_should_be(interp, argv[0], "doubleArg");
    }
    sprintf(buf, G_FLOAT_FMT, (*cdata)(d));
    Tcl_SetResult(interp, buf, TCL_VOLATILE);
    return TCL_OK;
}

mth_negCmd (cdata, interp, argc, argv)
    double (* cdata)(); Tcl_Interp *interp; int argc; char **argv;
{
    char buf[G_FLOAT_STR_SIZE];
    double d;
    if (argc != 2 || (Tcl_GetDouble(interp, argv[1], &d) == TCL_ERROR)) {
	return args_should_be(interp, argv[0], "doubleArg");
    }
    sprintf(buf, G_FLOAT_FMT, -d);
    Tcl_SetResult(interp, buf, TCL_VOLATILE);
    return TCL_OK;
}
