/* signal handling modules */

#include <stdio.h>
#include <signal.h>
#include <tk.h>

static int siglist_nonfatal[] = {
    SIGUSR1, SIGUSR2, SIGTERM,
    SIGPIPE, SIGHUP, SIGINT, SIGQUIT, 0
};
static int siglist_fatal[] = {
    SIGILL, SIGEMT, SIGFPE, SIGBUS, SIGSEGV, SIGSYS,
    0
};

#define MAX_CLEANUP_INTERPS 8
static Tcl_Interp *CleanupInterpList[MAX_CLEANUP_INTERPS] = { NULL };

void
mySignalHandler(sig, code, scp, addr)
    int     sig, code;  /* see signal(2) sunOS documentation */
    struct sigcontext *scp;
    char   *addr;
{
    char   *mn = __FILE__;
    switch (sig)
    {
        /* roll the log file over */
        break;
    case SIGSYS:
        printf("%s: encountered bad arg on a system call!!\n", mn);
        break;
    case SIGUSR1:
        /* FALL THROUGH */
    case SIGUSR2:
        printf("%s: someone is sending us unwanted SIGUSR[12] signals\n", mn);
        return;
    case SIGPIPE:
        printf("%s: got a SIGPIPE", mn);
	return;

    case SIGQUIT:
    case SIGHUP:
    case SIGINT:
    case SIGTERM:
        printf("%s: caught signal %d exiting\n", mn, sig);
	cleanupInterps();
        exit(sig);

    default:
        signal(SIGCHLD, SIG_IGN);
        printf("%s: caught signal %d aborting\n", mn, sig);
        fflush(stdout);
	cleanupInterps();
        abort();
    }
    return;
}

int
cleanupInterps() 
{
    int x;
    for (x=0; x<MAX_CLEANUP_INTERPS; x++) {
	if (CleanupInterpList[x]!=NULL) {
	    Tcl_Eval(CleanupInterpList[x], "destroy .", (char **)NULL);
	    CleanupInterpList[x] = NULL;
	}
    }
    return 0;
}

/* this should be called for each tk interpreter in the application */
int 
init_sigHandlers(interp)
Tcl_Interp *interp;
{
    extern char *getenv();
    extern void mySignalHandler();
    int x;

    if (CleanupInterpList[0]==NULL)  {
	for (x = 0; siglist_nonfatal[x] != 0; x++)
	    (void) signal(siglist_nonfatal[x], mySignalHandler);
	if (!getenv("CATCH_ONLY_NON_FATAL")) {
	    for (x = 0; siglist_fatal[x] != 0; x++)
		(void) signal(siglist_fatal[x], mySignalHandler);
	}
	memset(CleanupInterpList, '\0', sizeof(CleanupInterpList));
    }
    for (x=0; x<MAX_CLEANUP_INTERPS; x++) {
	if (CleanupInterpList[x]==NULL) {
	    CleanupInterpList[x]=interp;
	    return 0;
	}
    }
    perror("init_sigHandlers: out of CleanupInterpList slots");
    return -1;
}
