/**/## config.tcl: configuration file for tkWWW  user interface
/**/## ==============
/**/## Copyright (C) 1992-1993
/**/## Global Network Academy
/**/## Macvicar Institute for Educational Software Development
/**/##
/**/## See the file COPYRIGHT for conditions

/**/## Conventions:
/**/##   This is the only file the user should have to edit

/**/## *************************
/**/## This file contains user definable parameters
/**/## Do not edit config.tcl.  Instead edit config.cpp and run make.
/**/## *************************

/**/## *************************
/**/## The home page and the start page
/**/## *************************

/**/## Get it from the environment variable WWW_HOME if possible

if {[catch {set env(WWW_HOME)} home_page] != 0} {
    set tkW3ConfigHomePage CPP_TK_WWW_HOME_PAGE
    set tkW3ConfigStartPage CPP_TK_WWW_START_PAGE
} {
    set tkW3ConfigHomePage $home_page
    set tkW3ConfigStartPage $home_page
}

    set tkW3ConfigHelpRoot http://tk-www.mit.edu:8001/tk-www/help

/**/## The programs that tkWWW uses
set tkW3ConfigViewer(editor) 		emacs
set tkW3ConfigViewer(terminal)		xterm
set tkW3ConfigViewer(printer)		lpr
set tkW3ConfigViewer(dvi)		xdvi
set tkW3ConfigViewer(image)		xli
set tkW3ConfigViewer(video)		mpeg_play
set tkW3ConfigViewer(audio)		showaudio
set tkW3ConfigViewer(postscript)	ghostview

set tkW3ConfigImageDirectView 1

/**/## The backend command tkWWW uses
set tkW3ServerCommand tkWWW.server

/**/## The mail command
proc tkW3ConfigSendMail {to subject body} {
#if CPP_TK_WWW_USE_MH_MAIL
    set file [open "| mhmail $to -subject \"$subject\"" w+]
#else
    set file [open "| Mail -s \"$subject\" $to" w+]
#endif
    puts $file $body
    close $file
}

/**/## Configure the menus
set tkW3ConfigMenus {
    {{file "File" 0} {
	{"New" 	{tkW3EditClear .f.msg} 0}
	{}
	{"Open File..." tkW3FileLoadSource 0 }
	{"Open Link..." {DLG:show . .goto_dialog}}
	{"Open Introduction" 
	    {tkW3NavigateRecordAndGoto "http://tk-www.mit.edu:8001/tk-www/help/sources.html"}}
	{}
	{"Generate Source" tkW3EditGenerate}
	{"Save Text..." tkW3FileSaveText 0 }
	{"Reload page" tkW3NavigateReload}
	{}
	{"Find Keyword..." {DLG:show . .find_dialog} 0 "<Meta-f>"}
	{"Clone Current Window" tkW3NavigateClone 1}
	{} 
	{"Print" {DLG:show . .print_dialog} 0 }
	{"Mail" 
	    {DLG:set_entry_value .mail_dialog 2 [tkW3NavigateGetTitle];
	     DLG:show . .mail_dialog} }
	{}
	{"Run TCL Command" {tkW3FileRunTclCommand} 0}
	{}
	{"Close" tkW3FileQueryCloseWindow 0}
	{"Exit" tkW3FileQueryExit 0}
    }}
    {{edit "Edit" 0} {
	{"Cut" {tkW3EditCut .f.msg} 2 "<Shift-Delete>"}
        {"Copy" {tkW3EditCopy .f.msg} 0 "<Control-Insert>"} 
	{"Paste" {tkW3EditPaste .f.msg} 0 "<Shift-Insert>"}
	{}
	{"Delete" {tkW3EditDelete .f.msg} 0}
	{}
	{"Select All" {tkW3EditSelectAll .f.msg} {} }
	{"Deselect All" {tkW3EditDeselectAll .f.msg} {} }
	{}
	{"Insert List Item" {tkW3EditBeginListItem .f.msg} {} "<Meta-l>"}
	{"Insert Glossary Item" {tkW3EditBeginGlossary .f.msg} {} "<Meta-g>"}
	{"Insert Image" {tkW3EditAddImage .f.msg} {} "<Meta-i>"}
	{"Insert Paragraph Break" {tkW3EditInsertBullet .f.msg P} {} "<Meta-p>"}
	{"Create link ..." {tkW3EditBeginAnchor .f.msg} {} "<Meta-a>"}
	{"Change title ..." {tkW3EditQueryChangeTitle .f.msg} {} "<Meta-t>"}
    }}
    {{option "Option" 0} {
	{"Change Fonts ..." {DLG:show . .font_dialog}}
    }}	
    {{paragraph "Paragraph" 0} {
	{"Default" "tkW3EditSetParaStyle {}"}
	{"Heading" "cascade" 
	    {{"Heading1" "tkW3EditSetParaStyle H1" "" "<Meta-1>"}
	     {"Heading2" "tkW3EditSetParaStyle H2" "" "<Meta-2>"}
	     {"Heading3" "tkW3EditSetParaStyle H3" "" "<Meta-3>"}
	     {"Heading4" "tkW3EditSetParaStyle H4" "" "<Meta-4>"}
	     {"Heading5" "tkW3EditSetParaStyle H5" "" "<Meta-5>"}
	     {"Heading6" "tkW3EditSetParaStyle H6" "" "<Meta-6>"}
	    }}
	{"Address" "tkW3EditSetParaStyle ADDRESS"}
	{"Preformatted" "tkW3EditSetParaStyle PRE"}
    }}
    {{character "Characters" 0} {
	{"default"          "tkW3EditSetCharStyle {}"}
	{"Italics"          "tkW3EditSetCharStyle I"}
	{"Bold"             "tkW3EditSetCharStyle B"}
	{"Underline"        "tkW3EditSetCharStyle U"}
	{"Typewriter"       "tkW3EditSetCharStyle TT"}
	{"Emphasis"         "tkW3EditSetCharStyle EM"}
	{"Strong emphasis"  "tkW3EditSetCharStyle STRONG"}
	{"Code"             "tkW3EditSetCharStyle CODE"}
	{"Sample"           "tkW3EditSetCharStyle SAMP"}
	{"Keyboard"         "tkW3EditSetCharStyle KBD"}
	{"Variable"         "tkW3EditSetCharStyle VAR"}
	{"Definition"       "tkW3EditSetCharStyle DFN"}
	{"Citation"         "tkW3EditSetCharStyle CITE"}
    }}	
    {{history "History" 0} {
	{"Backtrack" "tkW3NavigateBacktrack" 0}
	{"Recall" cascade_external history}
    }}
    {{bookmarks "Bookmarks" 0} {
	{"Goto Bookmark" cascade_external bookmarks}
	{}
	{"Add Bookmark" tkW3BookmarksAdd 0}
	{"Delete Bookmark" tkW3BookmarksDelete 0}
	{"Load New Bookmarks..." {tkW3BookmarksLoadDialog 1} 5}
	{"Append Bookmarks..." {tkW3BookmarksLoadDialog 0} 1}
	{"Save Bookmarks..." {tkW3BookmarksSaveDialog} 0}
    }}
    {{annotate "Annotate" 0} {
	{"Add Annotation..." tkW3AnnotateAdd}
	{"Edit Annotation..." tkW3AnnotateEdit}
	{}
	{"Goto Annotation" cascade_external annotate}
    }}
    {{help "Help" 0 right}  {
       {"Overview" 	"tkW3HelpGetTopic overview" 0}
       {"Index" 	"tkW3HelpGetTopic index" 0}
       {"Keyboard" 	"tkW3HelpGetTopic keyboard" 0}
       {"Tutorial" 	"tkW3HelpGetTopic tutorial" 0}
       {}
       {"About Global Network Academy" "tkW3HelpGetTopic uu-gna" 0}
       {"Starting information sources" "tkW3HelpGetTopic sources" 0}
       {}
       {"Send mail to developer..." "DLG:show . .send_mail_dialog" 0}
       {"Subscribe to mailing list tk-www@athena.mit.edu" \
	   "tkW3HelpAddToMailingList" }
       {"Unsubscribe to mailing list tk-www@athena.mit.edu" \
           "tkW3HelpRemoveFromMailingList" }
       {}
       {"Using Help" 	 "tkW3HelpGetTopic using_help" 6}
       {"Product Information" "tkW3HelpAbout" 0}
   }}}

set tkW3ConfigEntries {
    {para "Paragraph: "}
    {char "Character: "}
}

set tkW3ConfigButtons {
    {home "Home" {tkW3NavigateRecordAndGoto $tkW3ConfigHomePage}}
    {back "Back" {tkW3NavigateBacktrack}}
    {find "Find" {DLG:show . .find_dialog}}
    {goto "Goto..." {DLG:show . .goto_dialog}}
    {reload "Reload" tkW3NavigateReload}
    {generate "Generate Source" {tkW3EditGenerate}}
    {clone "Clone" {tkW3NavigateClone [tkW3NavigateGetAddress]}}
    {close_window "Close Window" "tkW3FileQueryCloseWindow"}
}

set tkW3ConfigToggles {
    {is_index "Is Index"}
    {has_annotation "Has Annotations"}
}

proc tkW3ConfigDisplay {} {
    global tkW3HistoryList
    global tkW3BookmarksList
    global tkW3NavigateIsIndex

    if [llength $tkW3HistoryList] {
	.buttons.back configure -state normal
	.menu.history.m entryconfigure "Backtrack*" -state normal
	.menu.history.m entryconfigure "Recall*" -state normal
    } {
	.buttons.back configure -state disabled
	.menu.history.m entryconfigure "Backtrack*" -state disabled
	.menu.history.m entryconfigure "Recall*" -state disabled
    }
    if $tkW3NavigateIsIndex {
	.buttons.find configure -state normal
	.menu.file.m entryconfigure "Find*" -state normal
	.toggles.is_index select
	
    } {
	.buttons.find configure -state disabled
	.menu.file.m entryconfigure "Find*" -state disabled
	.toggles.is_index deselect
    }
    if [tkW3AnnotateDisplay] {
	.toggles.has_annotation select
 	.menu.annotate.m entryconfigure "Goto*" -state normal
    } {
	.toggles.has_annotation deselect
 	.menu.annotate.m entryconfigure "Goto*" -state disabled
    }
    if [llength $tkW3BookmarksList] {
	.menu.bookmarks.m entryconfigure "Goto*" -state normal
    } {
	.menu.bookmarks.m entryconfigure "Goto*" -state disabled
    }
}

set tkW3ConfigFileSuffixes   {
    { ".mime" "www/mime"  "8bit" 1.0 }	
    { ".PS" 	"application/postscript"  "8bit" 0.8 }
    { ".eps" 	"application/postscript"  "8bit" 0.8 }
    { ".ai" 	"application/postscript"  "8bit" 0.5 }
    { ".ps" 	"application/postscript"  "8bit" 0.8 }
    { ".html" "text/html"  "8bit" 1.0 }		
    { ".c" 	"text/plain"  "7bit" 0.5 }
    { ".h" 	"text/plain"  "7bit" 0.5 }		
    { ".m" 	"text/plain"  "7bit" 0.5 } 
    { ".txt"  "text/plain"  "7bit" 0.5 }
    { ".rtf" 	"application/x-rtf" "8bit" 1.0 }
    { ".snd"  "audio/basic"  "binary" 1.0 }
    { ".au"   "audio/basic"  "binary" 1.0 }
    { ".bin" 	"application/octet-stream"  "binary" 1.0 }
    { ".dmp.Z"  "image/compressed-x11-dump" "binary" 1.0}
    { ".dmp"  "image/x11-dump" "binary" 1.0}
    { ".pbm.Z" "image/compressed-portable-bitmap" "binary" 1.0}
    { ".pbm" "image/portable-bitmap" "binary" 1.0}
    { ".ppm.Z" "image/compressed-portable-pixmap" "binary" 1.0}
    { ".ppm" "image/portable-pixmap" "binary" 1.0}
    { ".xbm" "image/x-bitmap" "binary" 1.0} 
    { ".xbm.Z" "image/compressed-xbm" "binary" 1.0}
    { ".gif.Z" "image/compressed-gif" "binary" 1.0}
    { ".gif"  "image/gif"  "binary" 1.0 }
    { ".tiff" "image/x-tiff"  "binary" 1.0 }
    { ".jpg"  "image/jpeg"  "binary" 1.0 }
    { ".JPG"  "image/jpeg"  "binary" 1.0 }
    { ".JPEG" "image/jpeg"  "binary" 1.0 }
    { ".jpeg" "image/jpeg"  "binary" 1.0 }
    { ".ras"  "image/cmu-raster" "binary" 1.0}
    { ".MPEG" "video/mpeg"  "binary" 1.0 }
    { ".mpg" "video/mpeg"  "binary" 1.0 }
    { ".MPG" "video/mpeg"  "binary" 1.0 }
    { ".mpeg" "video/mpeg"  "binary" 1.0 }
    { ".tex" "application/tex" "binary" 1.0}
    { ".latex" "application/latex" "binary" 1.0}
    { ".texi" "application/texinfo" "binary" 1.0}
    { ".dvi" "application/dvi" "binary" 1.0}
    { ".tar" "archive/tar" "binary" 1.0}
    { ".tar.Z"  "archive/compressed-tar" "binary" 1.0}
    { ".shar" "archive/shar" "binary" 1.0}
    { ".shar.Z" "archive/compressed-shar" "binary" 1.0}
    { ".Z" 	"application/x-compressed" "binary" 0.5 }
    { ".gz"    "application/x-zipped" "binary" 0.5}
    { ".x11.Z" "image/compressed-x11-dump" "binary" 1.0}
    { ".x11" "image/x11-dump" "binary" 1.0}
}

proc tkW3ConfigDisplayFile {type file_name} {
    global tkW3ConfigViewer	
    case $type {
	"image/*" {
	    tkW3ImageDisplayFile $file_name
	}
	"video/*" {
	tkW3NavigatePreface {Video file
To display press the button below and wait a few seconds
} {Press here to show video} {Displaying video ...} \
"exec $tkW3ConfigViewer(video) $file_name &"
	}
	"audio/*" {
	tkW3NavigatePreface {Audio file
To display press the button below and wait a few seconds
} {Press here to show audio} {Displaying audio ...} \
"exec $tkW3ConfigViewer(audio) $file_name &"
	}
	{application/postscript} {
	tkW3NavigatePreface {Postscript file
To display press the button below and wait a few seconds
} {Press here to show postscript} {Displaying Postscript ...} \
"exec $tkW3ConfigViewer(postscript) $file_name &"
	}
	{application/dvi} {
	tkW3NavigatePreface {TeX Device Independent file
To display press the button below and wait a few seconds
} {Press here to show DVI file} {Displaying TeX DVI file ...} \
"exec $tkW3ConfigViewer(dvi) $file_name &"
	}
	{text/plain} {
	    tkW3OutputSetBodyToFile $file_name
	}
	{application/x-compressed} {
	    case [DLG:question . .graphics_dialog "Compressed File" \
		  "Display as text" "Display as image" "Save file as..."] {
		      {1} {tkW3OutputSetBodyToFile "| zcat $file_name "}
		      {2} {tkW3ImageDisplayFile $file_name}
		      {3} {tkW3OutputSaveFileAs $file_name}
		  } 
	}
	{application/x-zipped} {
	    case [DLG:question . .graphics_dialog "Gzip Compressed File" \
		  "Display as text" "Display as image" "Save file as..."] {
		      {1} {tkW3OutputSetBodyToFile "| gunzip -c $file_name"}
		      {2} {tkW3ImageDisplayFile $file_name}
		      {3} {tkW3OutputSaveFileAs $file_name}
		  }
	}
	{default} {
	    case [DLG:question . .graphics_dialog "Unknown file type" \
		  "Display as text" "Display as image" "Save file as..."] {
		      {1} {tkW3OutputSetBodyToFile $file_name}
		      {2} {tkW3ImageDisplayFile $file_name}
		      {3} {tkW3OutputSaveFileAs $file_name}
		  }
	}
    }
}

/**/## *************************
/**/## Set options
/**/## *************************

option add *background gray userDefault
option add *foreground black userDefault
option add *buttons*relief raised userDefault
option add *buttons*borderWidth 2 userDefault
option add *toggles*relief flat userDefault
option add *toggles*borderWidth 2 userDefault
option add *Scrollbar.foreground gray userDefault
option add *Hypertext.Button.relief raised userDefault
option add *Frame.relief raised userDefault
option add *Frame.borderWidth 2 userDefault
option add *Hypertext*background bisque userDefault
option add *Text*background bisque userDefault
option add *Text*wrap word userDefault
option add *Text.relief sunken userDefault
option add *Text.borderWidth 2 userDefault
option add *Scrollbar*relief sunken userDefault

/**/## *************************
/**/## Set key bindings
/**/## *************************

proc GetSelection {} {# xf ignore me 7
/**/##########
/**/# Procedure: GetSelection
/**/# Description: get current selection
/**/# Arguments: none
/**/# Returns: none
/**/# Sideeffects: none
/**/##########

/**/# the save way
  set xfSelection ""
  catch "selection get" xfSelection
  if {"$xfSelection" == "selection doesn't exist or form \"STRING\" not defined"} {
    return ""
  } {
    return $xfSelection
  }
}

bind Text <Left> {# xf ignore me 9
  %W mark set insert insert-1c; %W yview -pickplace insert}
bind Text <Right> {# xf ignore me 9
  %W mark set insert insert+1c; %W yview -pickplace insert}
bind Text <Up> {# xf ignore me 9
  %W mark set insert insert-1l; %W yview -pickplace insert}
bind Text <Down> {# xf ignore me 9
  %W mark set insert insert+1l; %W yview -pickplace insert}
bind Text <Delete> {# xf ignore me 9
  tk_textBackspace %W; %W yview -pickplace insert}
bind Text <Control-a> {# xf ignore me 9
  %W mark set insert "insert linestart"; %W yview -pickplace insert}
bind Text <Control-b> {# xf ignore me 9
  %W mark set insert insert-1c; %W yview -pickplace insert}
bind Text <Control-d> {# xf ignore me 9
  %W delete insert insert+1c; %W yview -pickplace insert}
bind Text <Control-e> {# xf ignore me 9
  %W mark set insert "insert lineend"; %W yview -pickplace insert}
bind Text <Control-f> {# xf ignore me 9
  %W mark set insert insert+1c; %W yview -pickplace insert}
bind Text <Meta-h> {# xf ignore me 9
  %W delete "insert linestart" insert; %W yview -pickplace insert}
bind Text <Control-i> {# xf ignore me 9
  %W inser insert \t; %W yview -pickplace insert}
bind Text <Control-j> {# xf ignore me 9
  %W inser insert \n; %W yview -pickplace insert}
bind Text <Control-k> {# xf ignore me 9
  if {[%W compare insert == "insert lineend"]} {
    %W delete insert "insert lineend +1c"
    %W yview -pickplace insert
  } {
    %W delete insert "insert lineend"
    %W yview -pickplace insert}}
bind Text <Control-l> {# xf ignore me 9
  %W yview -pickplace insert}
bind Text <Control-m> {# xf ignore me 9
  %W inser insert \n; %W yview -pickplace insert}
bind Text <Control-n> {# xf ignore me 9
  %W mark set insert insert+1l; %W yview -pickplace insert}
bind Text <Control-o> {# xf ignore me 9
  %W inser insert \n; %W yview -pickplace insert}
bind Text <Control-p> {# xf ignore me 9
  %W mark set insert insert-1l; %W yview -pickplace insert}
bind Text <Meta-v> {# xf ignore me 9
  set xfCounter [lindex [%W config -height] 4]
  while {$xfCounter > 0} {
    %W mark set insert insert-1l
    incr xfCounter -1
  }
  %W yview -pickplace insert}
bind Text <Control-v> {# xf ignore me 9
  set xfCounter [lindex [%W config -height] 4]
  while {$xfCounter > 0} {
    %W mark set insert insert+1l
    incr xfCounter -1
  }
  %W yview -pickplace insert}
bind Text <Control-w> {# xf ignore me 9
  catch "%W delete sel.first sel.last"}
bind Text <Control-y> {# xf ignore me 9
  %W insert insert "[GetSelection]"; %W yview -pickplace insert}
bind Text <Home> {# xf ignore me 9 
  %W mark set insert 1.0; %W yview -pickplace insert}
bind Text <End> {# xf ignore me 9
  %W mark set insert end; %W yview -pickplace insert}
bind Text <Prior> {# xf ignore me 9
  set xfCounter [lindex [%W config -height] 4]
  while {$xfCounter > 0} {
    %W mark set insert insert-1l
    incr xfCounter -1
  }
  %W yview -pickplace insert}
bind Text <Next> {# xf ignore me 9
  set xfCounter [lindex [%W config -height] 4]
  while {$xfCounter > 0} {
    %W mark set insert insert+1l
    incr xfCounter -1
  }
  %W yview -pickplace insert}


if {$tkVersion >= 3.0} {
bind Entry <Right> {# xf ignore me 9
  %W icursor [expr [%W index insert]+1]; tk_entrySeeCaret %W }
bind Entry <Left> {# xf ignore me 9
  %W icursor [expr [%W index insert]-1]; tk_entrySeeCaret %W }
bind Entry <Control-a> {# xf ignore me 9
  %W icursor 0; %W view 0}
bind Entry <Control-b> {# xf ignore me 9
  %W icursor [expr [%W index insert]-1]; tk_entrySeeCaret %W}
bind Entry <Control-d> {# xf ignore me 9
  %W delete [%W index insert]; tk_entrySeeCaret %W }
bind Entry <Control-e> {# xf ignore me 9
  %W icursor end; tk_entrySeeCaret %W}
bind Entry <Control-f> {# xf ignore me 9
  %W icursor [expr [%W index insert]+1]; tk_entrySeeCaret %W}
bind Entry <Control-h> {# xf ignore me 9
  tk_entryBackspace %W; tk_entrySeeCaret %W}
bind Entry <Meta-h> {# xf ignore me 9
  %W delete 0 insert; %W view insert}
bind Entry <Control-i> {# xf ignore me 9
  %W insert insert \t; tk_entrySeeCaret %W}
bind Entry <Control-k> {# xf ignore me 9
  %W delete insert end; tk_entrySeeCaret %W}
bind Entry <Control-l> {# xf ignore me 9
  tk_entrySeeCaret %W}
bind Entry <Control-v> {# xf ignore me 9
  %W insert insert "[GetSelection]"; tk_entrySeeCaret %W}
bind Entry <Control-w> {# xf ignore me 9
  catch "%W delete sel.first sel.last"; tk_entrySeeCaret %W}
bind Entry <Control-y> {# xf ignore me 9
  %W insert insert "[GetSelection]"; tk_entrySeeCaret %W}
} {
bind Entry <Right> {# xf ignore me 9
  %W cursor [expr [%W index cursor]+1]; tk_entrySeeCaret %W }
bind Entry <Left> {# xf ignore me 9
  %W cursor [expr [%W index cursor]-1]; tk_entrySeeCaret %W }
bind Entry <Control-a> {# xf ignore me 9
  %W cursor 0; %W view 0}
bind Entry <Control-b> {# xf ignore me 9
  %W cursor [expr [%W index cursor]-1]; tk_entrySeeCaret %W}
bind Entry <Control-d> {# xf ignore me 9
  %W delete [%W index cursor]; tk_entrySeeCaret %W }
bind Entry <Control-e> {# xf ignore me 9
  %W cursor end; tk_entrySeeCaret %W}
bind Entry <Control-f> {# xf ignore me 9
  %W cursor [expr [%W index cursor]+1]; tk_entrySeeCaret %W}
bind Entry <Control-h> {# xf ignore me 9
  tk_entryBackspace %W; tk_entrySeeCaret %W}
bind Entry <Meta-h> {# xf ignore me 9
  %W delete 0 cursor; %W view cursor}
bind Entry <Control-i> {# xf ignore me 9
  %W insert cursor \t; tk_entrySeeCaret %W}
bind Entry <Control-k> {# xf ignore me 9
  %W delete cursor end; tk_entrySeeCaret %W}
bind Entry <Control-l> {# xf ignore me 9
  tk_entrySeeCaret %W}
bind Entry <Control-v> {# xf ignore me 9
  %W insert cursor "[GetSelection]"; tk_entrySeeCaret %W}
bind Entry <Control-w> {# xf ignore me 9
  catch "%W delete sel.first sel.last"; tk_entrySeeCaret %W}
bind Entry <Control-y> {# xf ignore me 9
  %W insert cursor "[GetSelection]"; tk_entrySeeCaret %W}
}
bind Entry <2> {# xf ignore me 9
  %W insert cursor "[GetSelection]"; tk_entrySeeCaret %W}
