#==============================================================================
#                                chain.tcl
#------------------------------------------------------------------------------
# A port of SIPP demo program chain.c to Tcl-SIPP.
#------------------------------------------------------------------------------
# $Id: chain.tcl,v 4.0 1993/11/27 21:25:49 markd Rel $
#------------------------------------------------------------------------------

if {[info commands DoRendering] == ""} {
    if [file exists ./demoutil.tlib] {
        loadlibindex ./demoutil.tlib
    } else {
        set demoutil [searchpath $auto_path demos/demoutil.tlib]
        if [lempty $demoutil] {
            error "Can't find \"demos/demoutil.tlib\" on auto_path"
        }
        loadlibindex $demoutil
    }
}
ParseDemoArgs

set M_PI     3.14159265358979323846

set SMALLRES 15
set BIGRES   39

SippLightSourceCreate {1.0   1.0 1.0} {0.9 0.9 0.9} DIRECTION
SippLightSourceCreate {-1.0 -1.0 0.5} {0.4 0.4 0.4} DIRECTION


set shader [SippShaderBasic 0.5 0.6 0.2 {0.8 0.6 0.3}]
set torus  [SippTorus 1.0 0.23 $BIGRES $SMALLRES  $shader WORLD]

set torus_pair [SippObjectCreate]
SippObjectAddSubobj $torus_pair $torus

set torus2  [SippObjectInstance $torus]
SippObjectMove $torus2 {0.0 -1.375 0.0}
SippObjectRotateY $torus2 [expr $M_PI/2.0]
SippObjectAddSubobj $torus_pair $torus2

set chain [SippObjectCreate]
SippObjectMove $torus_pair {-1.375 1.375 0.0}
SippObjectAddSubobj $chain $torus_pair

set torus_pair2 [SippObjectInstance $torus_pair]
SippObjectRotateZ $torus_pair2 [expr $M_PI/2.0]
SippObjectMove $torus_pair2 {-1.375 -1.375 0.0}
SippObjectAddSubobj $chain $torus_pair2

set torus_pair3 [SippObjectInstance $torus_pair2]

SippObjectRotateZ $torus_pair3 $M_PI
SippObjectMove $torus_pair3 {1.375 -1.375 0.0}
SippObjectAddSubobj $chain $torus_pair3

set torus_pair4 [SippObjectInstance $torus_pair3]
SippObjectRotateZ $torus_pair4 [expr 3.0*$M_PI/2.0]
SippObjectMove $torus_pair4  {1.375 1.375 0.0}
SippObjectAddSubobj $chain $torus_pair4

SippObjectAddSubobj WORLD $chain

set camera [SippCameraCreate {5.0 -2.0 15.0} {0.5 0.0 0.0} {0.0 0.0 1.0} 0.25]
SippCameraUse $camera

if {$G_mode == "LINE"} {
    SippBackground {0 .4 0}
    SippLineColor {1 0 0} 
}

DoRendering "chain"

