#---dv-----------------Initialisierungsroutinen-------------------------------

#-----------------------------------------------------------------------------
# init {} initialisiert das Programm
#-----------------------------------------------------------------------------
#
proc init {dp} {

  # FileSelectionBox initialisieren
  #
  global fsBox
  set fsBox(activeBackground) ""
  set fsBox(activeForeground) ""
  set fsBox(background) ""
  set fsBox(font) ""
  set fsBox(foreground) ""
  set fsBox(scrollActiveForeground) ""
  set fsBox(scrollBackground) ""
  set fsBox(scrollForeground) ""
  set fsBox(scrollSide) left 
  set fsBox(showPixmap) 0
  set fsBox(name) ""
  set fsBox(pattern) *
  set fsBox(all) 0
  set fsBox(extensions) 0
  set fsBox(internalPath) ""

  # Versionsnummer setzen
  #
  global status
  set status(version) "1.0b"

  # Cursortasten links/rechts in Eingabefeldern realisieren
  #
  bindarrows

  # Focuswechsel bei Tab/Shift-Tab in Eingabefeldern realisieren
  #
  bindtabs

  # Focuswechsel bei Maus-Taste-1 gedrueckt 
  #
  changefocus

  # fuer X11R6 Border Option setzen (fuer Darstellung der 3-d reliefs)
  #
  option add dv*BorderWidth 2
}


#-----------------------------------------------------------------------------
# diagdatainit {} initialisiert die Daten fuer ein Diagramm
#                 dp : aktueller Diagrammdatensatz
#-----------------------------------------------------------------------------
#
proc diagdatainit {dp} {

  # diagram          : derzeit aktiver Datensatz

  # jedes Diagramm besitzt seinen eigenen Datensatz; die Daten werden in einem
  # zweidimensionalen globalen assotiativen Array Namens "diagdata" gehalten
  #
  # erster index  : <dp>   Diagrammpfad ; gibt an, fuer welches Diagramm die 
  #                        Daten gedacht sind
  # zweiter index : <var>  DatenVariable; gibt die genaue Variable an;
  #

  # DatenVariablen (als regulaere Ausdruecke dargestellt): 
  # - - - - - - - - - - - - - - - - - - - - - - - - - - - 
  #  diagrambuf     : [string] enthaelt Namen des zugehoerigen Datenpuffersatz
  #  version        : [string] enthaelt Versionsbezeichnung
  #  status         : [defined|undefined] gibt an, ob Diagramm $dp
  #		      definierte Daten enthaelt

  #  title          : [string] enthaelt Titel des Diagramms
  #  subtitle       : [string] enthaelt Untertitel des Diagramms
  #  labelx         : [string] enthaelt X-Achsenbezeichnung
  #  labely         : [string] enthaelt Y-Achsenbezeichnung
  #  frametitle     : [stirng] enthaelt Rahmentitel des Diagrams 
  #  fromx          : [double] Skalierungsstartwert der X-Achse im Diagramm
  #  tox            : [double] Skalierungsendwert der Xachse im Diagramm
  #  stepx          : [double] Skalierungsschrittweite der Xachse im Diagramm
  #  fromy          : [double] Skalierungsstartwert der Y-Achse im Diagramm
  #  toy            : [double] Skalierungsendwert der Y-Achse im Diagramm
  #  stepy          : [double] Skalierungsschrittweite der Y-Achse im Diagramm
  #  autoscale      : [on|off] gibt an, ob Autoskalierung aktiv
  #  scxcol         : [on|off] Skalierung der Xachse aus Spalte
  #  scxcolind      : [integer] Index der Spalte zur Skalierung der Xachse
  #  size           : [normal|big|other] (Variable fuer sizemenue)
  #  sizex          : [integer] Grafikflaechenbreite in Pixeln
  #  sizey          : [integer] Grafikflaechenhoehe in Pixeln
  #  points         : [on|off]  PunktdarstellungsModus ein/aus 
  #  polygon        : [on|off]  PolygondarstellungsModus ein/aus
  #  bspline        : [on|off]  BsplinedarstellunsModus ein/aus
  #  filename       : [string] Name der Datei, aus der die Daten gelesen wurden
  #  filepath       : [string] Pfad, in der die Datei filename zu finden ist
  #  configname     : [string] Name der Konfigurationsdatei
  #  configpath     : [string] Pfad, in der die Konfigurationdatei zu finden ist
  #  rownum         : [integer] anzahl der Zeilen in der Tabelle
  #  grid           : [on|off] gibt an, ob das Gitter gezeichnet wird
  #  gridx,gridy    : [integer] Masszahl fuer die Anzahl der Skalierungen bei
  #                             eingeschaltetem autoscale 
  #  scalefont[0-2] : [string] Zeichensatz, mit dem die Skalierung erstellt wird
  #  titlefont[0-2] : [string] Zeichensatz, mit dem die Ueberschrift eines
  #                            Diagramms erstellt wird 
  #  scaledist[0-2] : [integer] Mass fuer den Abstand der Skalierungen und der 
  #                             Ueberschrift eines Diagramms zum Rand
  #  fontsmall      : [integer] gibt an, bis zu welcher Diagrammgroesse die
  #                             kleinen Zeichensaetze benutzt werden 
  #  fontbig        : [integer] gibt an, ab welcher Diagrammgroesse die grossen
  #                             Zeichensaetze benutzt werden 
  #  domain         : [index|"real"|date|time] 
  #                   Zustand fuer Radiobuttons im Menue Domain
  #  lastdomain     : [index|"real"|date|time]
  #                   Hilfsvariable fuer setdomain*
  #  partition      : [partitionon|partitionoff]
  #                   Methode Wertelisten zu partitionieren
  #  undefval       : [real] Wert, den das Programm im Modus 'partitionon'
  #                          als 'Messwert undefiniert' erkennt 
  #  undefmarks     : [on|off] gibt an, ob Marken fuer undefinierte Stellen
  #                 :          gezeigt werden
  #  colors         : [list] Liste von Listen von Kurvenindizees und Farben ,
  #                          in denen die Kurven dargestellt werden
  #  table          : [list] Liste von strings der Ursprungstabelle
  #  showtable      : [on|off] gibt an, ob die eingelesene Tabelle
  #                            im Hauptfenster angegeben wird 
  
         # von setdomain* gesetzt 
  #  layouttitle    : [string] Ueberschrift im Layout-Menue
  #  scxstate       : [normal|disabled]
  #                   Zustand der Eingabezeile "Scales from Column"
  #                   im Layout-Menue
  #  testscaleinput : [testinteger|testreal]
  #                    Methode die Eingabewerte der Zeile fromx,tox,stepx,
  #                    fromy,toy,stepy im Layout Menue zu testen 
  #  curveselect    : [colschoose|colsassign]
  #                    Methode, darzustellende Kurven auszuwaehlen/zuzuordnen
  #  calcautoscale  : [autoscaleindex|autoscalereal]
  #                    Methode, Skalierungsbereiche zu berechnen
  #  scalesx        : [scalelesxindex|scalesxreal]
  #                    Methode, Skalierungen auszugeben
  #  drawcurves     : [drawindex|drawreal]
  #                    Methode, Kurven in ein Diagramm einzuzeichnen
  #  gettitles      : [gettitlesindex|gettitlesreal]
  #                    Methode, Spaltentitel fuer das diagchoosecolors Menue
  #                    zu setzen
  #  colorsok       : [diagcolorsokindex|diagcolorsokreal]
  #                    Methode, gewaehlte Farben im diagcolorschoose Menue in
  #                    die Index/Farbliste zu setzen
  #  curvelistindex : [list] darzustellende Kurven im Modus domainint
  #  curvelistreal  : [list] darzustellende Kurven im Modus domainreal
  #  curvelistdate  : [list] darzustellende Kurven im Modus domaindate
  #  curvelisttime  : [list] darzustellende Kurven im Modus domaintime
  #  colorsindex    : [list] Index/Farbliste im Modus domainint
  #                          Format eines Listenelementes:
  #                             {Kurvenindex Farbwert}
  #  colorsreal     : [list] Index/Farbliste im Modus domainreal
  #                 :        Format eines Listenelementes:
  #                          {Urbildspaltenindex Bildspaltenindex Farbwert}
  #  colorsdate     : [list] Index/Farbliste im Modus domaindate
  #  colorstime     : [list] Index/Farbliste im Modus domaintime
  #  transform      : [string] Transformationstechnik; bildet Urbildspalten
  #                            von Tabellen auf reelle Spalten ab 
  #
   
         # von diagdataget initialisiert
  #  coltitle[0-9]+   : [string] Titel der Spalten
  #  col[0-9]+        : [string] Listen aus Spaltenelementen
  #  coltype[0-9]+    : [text|number] Spaltentype der n-ten Spalte
  #  colnum           : [integer] anzahl der Spalten in der Tabelle
  #  curvelist        : [list] Zeiger auf darzustellende Kurven 
  #  textlist         : [list] Zeiger auf die Textspalten

         # von showdiagram {} initialisiert:
  #  curvenum         : [integer] aktuelle Anzahl von dargestellten Kurven;
  #  winsizex         : [integer] aktuelle Breite des Diagrammfensters
  #  winsizey         : [integer] aktuelle Hoehe des Diagrammfensters
  #  colscaled[0-9]+  : [list] Liste von Listen definierter skalierter Werte
  #  undefmarks[0-9]+ : [list] Koordinaten von Marken fuer undefinierte Punkte

         # von drawdiag {} initialisiert:
  #  originx,originy  : [integer] Position des Ursprungs
  #  xaxis            : [integer] maximaler x-Wert der Xachse
  #  yaxis            : [integer] maximaler y-Wert der Yachse
  #  cliporiginx      : 
  #  cliporiginy      : [integer] Position des Ursprungs innerhalb der Clipbox
  #  clipxaxis        : [integer] maximaler x-Wert der Xachse innerhalb der 
  #                               Clipbox
  #  clipyaxis        : [integer] maximaler y-Wert der Yaxhse innerhalb der
  #                               Clipbox
  #  scalefont        : [string]  Font, der gerade fuer die Skalierungen
  #                               verwendet wird
  #  titlefont        : [string]  Font, der gerade fuer den Titel benutzt wird
  #  scaldist         : [integer] Abstandseinheit, fuer die 

         # Variablen fuer diagoutput menue
  #  rotate         : [true|false] Lage bei Postscript/Druckausgabe:
  #                                true portrait; false landscape
  #  outputcolor    : [color|gray] Farbart bei Postscript/Druckausgabe
  #  outputmedium   : [postscript|printer] Ausgabemedium des output-menues
  #  printcmd       : [string] Befehl, der zum Drucken benutzt wird
  #  outputscale    : [height|width] gibt an, ob die Ausgabe entlang
  #                          der Laengst bzq. Querachse skaliert werden soll 
  #  outputheight   : [string] Laenge der Ausgabe 
  #  outputwidth    : [string] Breite der Ausgabe
  #  outputfpath    : [string] filepfad fuer Postscript-Ausgabe
  #  outputfname    : [string] filename fuer Postscript-Ausgabe

         # Variablen fuer choosewindowcolors Menue
  # wincolorclass    : [foreground|background|diasabled|active|spot|insertion]
  #                           gewaehlte Farbklasse
  # foregroundcolor  : [rgb-Farbwert] Farbe der Klasse Foreground
  # backgroundcolor  : [rgb-Farbwert] Farbe der Klasse Background
  # disabledcolor    : [rgb-Farbwert] Farbe der Klasse disabled Foreground
  # activecolor      : [rgb-Farbwert] Farbe der Klasse active Background
  # spotcolor        : [rgb-Farbwert] Farbe der Klasse spot Color
  # insertioncolor   : [rgb-Farbwert] Farbe der Klasse insertion Color
 
  global diagdata env status

   set diagdata(diagram)             $dp

   set diagdata($dp.diagrambuf)      $dp\_buffer
   set diagdata($dp.version)         $status(version)
   set diagdata($dp.status)          "defined"
   set diagdata($dp.filename)        "data"
   set diagdata($dp.filepath)        [pwd]
   set diagdata($dp.configname)      "config"
   set diagdata($dp.configpath)      [pwd]
   set diagdata($dp.title)           "" 
   set diagdata($dp.subtitle)        ""
   set diagdata($dp.labelx)          ""
   set diagdata($dp.labely)          ""
   set diagdata($dp.frametitle)      "Diagram"
   set diagdata($dp.fromx)           0 
   set diagdata($dp.tox)             10  
   set diagdata($dp.stepx)           1  
   set diagdata($dp.fromy)           0  
   set diagdata($dp.toy)             10  
   set diagdata($dp.stepy)           1  
   set diagdata($dp.autoscale)       "on"
   set diagdata($dp.scxcol)          "off"
   set diagdata($dp.scxcolind)       0
   set diagdata($dp.sizex)           500
   set diagdata($dp.sizey)           500 
   set diagdata($dp.points)          "off" 
   set diagdata($dp.polygon)         "on" 
   set diagdata($dp.bspline)         "off"
   set diagdata($dp.grid)            "on"
   set diagdata($dp.gridx)           10 
   set diagdata($dp.gridy)           10 
   set diagdata($dp.colors)          "" 
   set diagdata($dp.showtable)       "on"
   set diagdata($dp.colorsindex)     ""
   set diagdata($dp.colorsreal)      ""
   set diagdata($dp.colorsdate)      ""
   set diagdata($dp.colorstime)      ""
   set diagdata($dp.undefmarks)      "on"
   set diagdata($dp.scalefont0)      "-Adobe-times-bold-r-normal--*-100-*" 
   set diagdata($dp.scalefont1)      "-Adobe-times-bold-r-normal--*-120-*"
   set diagdata($dp.scalefont2)      "-Adobe-times-bold-r-normal--*-180-*"
   set diagdata($dp.titlefont0)      "-Adobe-times-bold-r-normal--*-120-*" 
   set diagdata($dp.titlefont1)      "-Adobe-times-bold-r-normal--*-180-*" 
   set diagdata($dp.titlefont2)      "-Adobe-times-bold-r-normal--*-240-*" 
   set diagdata($dp.scaledist0)      5
   set diagdata($dp.scaledist1)      6
   set diagdata($dp.scaledist2)      9
   set diagdata($dp.fontsmall)       500
   set diagdata($dp.fontbig)         800
   set diagdata($dp.partition)       "partitionon"
   set diagdata($dp.undefval)        9999.99
   set diagdata($dp.rotate)          "false"
   set diagdata($dp.outputcolor)     "color"
   set diagdata($dp.outputmedium)    "postscript"
   set diagdata($dp.printcmd)        "lp"
   set diagdata($dp.outputscale)     "height"
   set diagdata($dp.outputheight)    ""
   set diagdata($dp.outputwidth)     ""
   set diagdata($dp.outputfname)     "data.eps"
   set diagdata($dp.outputfpath)     [pwd]
   set diagdata($dp.wincolorclass)   "foregroundcolor"
   set diagdata($dp.foregroundcolor) "#000000"
   set diagdata($dp.backgroundcolor) "#eb8bce"
   set diagdata($dp.disabledcolor)   "#fdc6e7"
   set diagdata($dp.activecolor)     "#d883b0"
   set diagdata($dp.spotcolor)       "#00ffff"
   set diagdata($dp.insertioncolor)  "#f8a2ed"

   createemptytable $dp 10 ;# Leertabelle fuer alle domainen erzeugen

   loadstartconfig $dp     ; # Startconfiguration laden, falls vorhanden    

   # Initialisierung fuer Modus "domainindex"
   #
   set diagdata($dp.domain)          index
   set diagdata($dp.lastdomain)      real
   setdomainindex $dp      ; # Variablen fuer domainindex

}

#-----------------------------------------------------------------------------
# createemptytable {} erzeugt eine Leertabelle fuer alle Domainen
#                     dp  : aktueller Datensatz
#                     num : anzahl der zu erzeugenden Leerspalten 
#-----------------------------------------------------------------------------
#
proc createemptytable {dp num} {

   # diagrammvariablen sichtbar machen
   #
   global diagdata

   # Leertabelle erzeugen, damit vom Programm aus Voreinstellungen gemacht
   # werden koennen; initial sind zehn (leere) Spalten mit Titeln empty[0-9]
   # eingetragen;
   # im Modus domainreal/date/time werden jeweils ungerade Spaltenindizees
   # auf gerade Spaltenindizees der zehn Spalten abgebildet  
   #
   set diagdata($dp.colnum)           $num
   set diagdata($dp.rownum)           2
   loop i 0 $num {
      set title                       "empty$i"
      append tablehead                "  $title   "
      append tableseparator           "---------- "
      set diagdata($dp.coltitle$i)    $title
      set diagdata($dp.col$i)         ""
      set diagdata($dp.coltype$i)     "number"
      lappend diagdata($dp.curvelist)  $i          ;# Spalte i fuer Darstellung
                                                   ;# selectieren
                               
   }
   
   set diagdata($dp.table) [list $tablehead $tableseparator]

   set diagdata($dp.textlist)         ""

   # Darstellung fuer alle Modi ermoeglichen
   #
   set diagdata($dp.curvelistindex)   $diagdata($dp.curvelist)
   set diagdata($dp.curvelistreal)    $diagdata($dp.curvelist) 
   set diagdata($dp.curvelistdate)    $diagdata($dp.curvelist)
   set diagdata($dp.curvelisttime)    $diagdata($dp.curvelist)

   copyallcols $dp $diagdata($dp.diagrambuf) ; # Spalten in den Datenpuffer
}


#-----------------------------------------------------------------------------
# loadstartconfig {} Prozedur, die die Startconfiguration ~/.dvconfig
#                    einlaedt, falls vorhanden
#-----------------------------------------------------------------------------
#
proc loadstartconfig {dp} {

   # Diagrammvariablen sichtbar machen
   #
   global diagdata
 
   # Konfiguration nachladen, falls ".dvconfig" existiert----------------------
   #
   global env
   set home $env(HOME)
   if {[file exists "$home/.dvconfig"]} {
      # Standartkonfigurationsdatei im HOME-Verzeichniss vorhanden =>
      # Konfiguration einlesen;
      #
      set diagdata($dp.configpath) $home
      set diagdata($dp.configname) .dvconfig
      busy {diagconfigget $dp configbuffer noloadview
            # Konfiguration korrekt geladen =>
            # Konfiguration in Diagrammdatensatz laden
            #
            diagconfigcopy configbuffer diagdata
      }
   }
}
