proc moogBookSaveAll {markFile} {
  global bookType bookName bookPath bookHost bookPort
  global fallbackMarkFile

  set nomarks [llength $bookType]

  if {$nomarks == 0 && [file exists $markFile]} {
    catch [exec rm $markFile]
    return
  }

  if {![file exists $markFile]} {
    catch [exec cp $fallbackMarkFile $markFile]
  }

  catch [exec mv $markFile $markFile.was]
  set FDbooks [open "$markFile" w]
  set OFDbooks [open "$markFile.was" r]

  while {![eof $OFDbooks]} {
    gets $OFDbooks bit
    puts $FDbooks $bit
    flush $FDbooks

    if {[string compare $bit "bookmarks:"] == 0} {
      break
    }
  }

  if {[eof $OFDbooks]} {
    close $OFDbooks
    close $FDbooks
    return
  }

  close $OFDbooks

  for {set ind 0} {$ind < $nomarks} {incr ind} {
    puts $FDbooks "#"; flush $FDbooks

    set type [lindex $bookType $ind]
    puts $FDbooks "Type=$type"; flush $FDbooks

    set name [lindex $bookName $ind]
    puts $FDbooks "Name=$name"; flush $FDbooks

    set path [lindex $bookPath $ind]
    puts $FDbooks "Path=$path"; flush $FDbooks

    set host [lindex $bookHost $ind]
    puts $FDbooks "Host=$host"; flush $FDbooks

    set port [lindex $bookPort $ind]
    puts $FDbooks "Port=$port"; flush $FDbooks
  }

  close $FDbooks
}

