.\" 
.\" Mach Operating System
.\" Copyright (c) 1991,1990 Carnegie Mellon University
.\" All Rights Reserved.
.\" 
.\" Permission to use, copy, modify and distribute this software and its
.\" documentation is hereby granted, provided that both the copyright
.\" notice and this permission notice appear in all copies of the
.\" software, derivative works or modified versions, and any portions
.\" thereof, and that both notices appear in supporting documentation.
.\" 
.\" CARNEGIE MELLON ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS"
.\" CONDITION.  CARNEGIE MELLON DISCLAIMS ANY LIABILITY OF ANY KIND FOR
.\" ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
.\" 
.\" Carnegie Mellon requests users of this software to return to
.\" 
.\"  Software Distribution Coordinator  or  Software.Distribution@CS.CMU.EDU
.\"  School of Computer Science
.\"  Carnegie Mellon University
.\"  Pittsburgh PA 15213-3890
.\" 
.\" any improvements or extensions that they make and grant Carnegie Mellon
.\" the rights to redistribute these changes.
.\" 
.\" 
.\" HISTORY
.\" $Log:	thread_create.man,v $
.\" Revision 2.5  93/03/18  15:15:37  mrt
.\" 	corrected types
.\" 	[93/03/12  16:53:47  lli]
.\" 
.\" Revision 2.4  91/05/14  17:13:55  mrt
.\" 	Correcting copyright
.\" 
.\" Revision 2.3  91/02/14  14:15:12  mrt
.\" 	Changed to new Mach copyright
.\" 	[91/02/12  18:16:02  mrt]
.\" 
.\" Revision 2.2  90/08/07  18:45:20  rpd
.\" 	Created.
.\" 
.TH thread_create 2 1/22/88
.CM 4
.SH NAME
.nf
thread_create  \-  creates new thread within named task
.SH SYNOPSIS
.nf
.ft B
#include <mach.h>

.nf
.ft B
kern_return_t thread_create(parent_task, child_thread)
	mach_port_t	parent_task;
	mach_port_t	*child_thread;	/* out */


.fi
.ft P
.SH DESCRIPTION
.B thread_create
creates a new thread within the task
specified by 
.B parent_task
.
The new thread has no processor state, and has a suspend count of 1.
To get a new thread to run, first 
.B thread_create
is called to get
the new thread's identifier,(
.B child_thread
). Then 
.B thread_set_state
is called to set a processor state, and finally 
.B thread_resume
is
called to get the thread scheduled to execute.

When the thread is created send rights to its thread kernel port are
given to it and returned to the caller in 
.B child_thread
. 
The new thread's  exception port is set to 
.B PORT_NULL
.

.SH ARGUMENTS
.TP 15
.B
parent_task
The task which is to contain the new thread.
.TP 15
.B
child_thread
The new thread.

.SH DIAGNOSTICS
.TP 25
KERN_SUCCESS
A new thread has been created.
.TP 25
KERN_INVALID_ARGUMENT
.B parent_task
is not a valid task.
.TP 25
KERN_RESOURCE_SHORTAGE
Some critical kernel resource is not
available.

.SH SEE ALSO
.B task_create, task_threads, thread_terminate, thread_suspend,
.B thread_resume, thread_special_ports, thread_set_state



