.\"
.\" Distributed as part of the Mach Operating System
.\"
.\" 
.\" @OSF_FREE_COPYRIGHT@
.\" 
.\" Copyright (c) 1990, 1991
.\" Open Software Foundation, Inc.
.\" 
.\" Permission is hereby granted to use, copy, modify and freely distribute
.\" the software in this file and its documentation for any purpose without
.\" fee, provided that the above copyright notice appears in all copies and
.\" that both the copyright notice and this permission notice appear in
.\" supporting documentation.  Further, provided that the name of Open
.\" Software Foundation, Inc. ("OSF") not be used in advertising or
.\" publicity pertaining to distribution of the software without prior
.\" written permission from OSF.  OSF makes no representations about the
.\" suitability of this software for any purpose.  It is provided "as is"
.\" without express or implied warranty.
.\" 
.\" HISTORY
.\" $Log:	make.man,v $
.\" Revision 2.2  92/05/20  20:14:11  mrt
.\" 	First checkin
.\" 	[92/05/20  17:26:40  mrt]
.\" 
...\" Copyright (c) 1990 The Regents of the University of California.
...\" All rights reserved.
...\"
...\" Redistribution and use in source and binary forms are permitted provided
...\" that: (1) source distributions retain this entire copyright notice and
...\" comment, and (2) distributions including binaries display the following
...\" acknowledgement:  ``This product includes software developed by the
...\" University of California, Berkeley and its contributors'' in the
...\" documentation or other materials provided with the distribution and in
...\" all advertising materials mentioning features or use of this software.
...\" Neither the name of the University nor the names of its contributors may
...\" be used to endorse or promote products derived from this software without
...\" specific prior written permission.
...\" THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
...\" WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
...\" MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
...\"
...\"     @(#)make.1	5.5 (Berkeley) 1/11/91
...\"
...\"
...\"	this file contains definitions of a very general nature.
...\"	The intention is to define items that might get redefined
...\"	under a different DWB, or provide global definitions.
...\"
...\"
...\"
...\"	define the constant width font.  Instead of asking explicitly
...\"	for C or CW, everyone (in the macro packages) should use the
...\"	string !) instead.
...\"
.ds !) CW\"  here, we use CW.  use this one in .ft \*(!) expressions
.ds !] (CW\" use this one in \f\*(!] expressions
...\"
...\"
...\"	define the word that we use to start a .H 1
...\"
.ds |A Chapter\"
...\"
...\"
...\"	set flag that we're *not* doing parts (overridden by parts.gpsml)
...\"
.nr |P 0
...\"   Macros Delimiting Titled Elements of a Document
...\"   -----------------------------------------------
...\"
...\"
...\" Figure start--undefined operation
.de aS
..
...\"
...\" Figure end--undefined operation
.de aE
..
...\"
...\"
...\"   Macros Delimiting Untitled Elements of a Document
...\"   -------------------------------------------------
...\"
...\"
...\" Start system output example region
.de oS
.SP
.ps -1
.ft \\*(!)
.nf
.nr !x 8*\\w'0'
.ta \\n(!xu +\\n(!xu +\\n(!xu +\\n(!xu +\\n(!xu +\\n(!xu +\\n(!xu +\\n(!xu +\\n(!xu +\\n(!xu
..
...\"
...\" End system output example region
.de oE
.ps +1
.ft R
.fi
.SP
..
...\"
...\" Start user input example region
.de iS
.SP
.ps -1
.ft B
.nf
..
...\"
...\" End user input example region
.de iE
.ps +1
.ft R
.fi
.SP
..
...\"
...\" Start comment region
.de cS
.ig cE
..
...\" End comment region
.de cE
..
...\"
...\" Start localization region
...\" to be defined later
.de lS
..
...\" End localization region
...\" to be defined later
.de lE
..
...\"
...\"
...\"
...\"	Meaningful Text Markup
...\"	----------------------
...\"
...\"
...\"
...\"		Strings
...\"		-------
...\"		(uses style \*O )
...\"
...\" Literal
.ds L \&\\fB\"
...\" Variable
.ds V \&\\fI\"
...\" Alphabetic constant
.ds A \&\\f\\*(!]\"
...\" Numeric constant
.ds N \&\\f\\*(!]\"
...\" Ordinary text
.ds O \&\\fR\"
...\" System output (C for Computer output
.ds C \&\\f\\*(!]\"
...\" System input (U for User input)
.ds U \&\\fB\"
...\" Emphasize
.ds E \&\\fI\"
...\"
...\"
...\"
...\"		Macros
...\"		------
...\"
...\" Start synopsis definition -- synopses are inherently in fill mode.
...\"  For a function call synopsis, use the .sS/.sE with an inner .iS/.iE
...\"  region.
...\" 
.de sS
.SP
..
...\" End synopsis definition
.de sE
.SP
..
...\"
...\"
...\"
...\" Start function definition
...\"
...\"  Registers:
...\"	!+ = 0 outside of fS/fE
...\"	!+ = 1 within fS/fE
...\"   !% = 0 for first dS/dE after fS
...\"   !% = 1 for second or greater dS/dE after fS
...\"
...\"
.de fS
.br
\&\fB\\$1(\fP
.nr !+ 1				\" now within fS/fE
.nr !% 0				\" reset to see first dS/dE
..
...\"
...\" End function definition
...\"
.de fE
\fB);\fP
.br
.if \\n(!%=1 .in -5i	\" saw .dS, so reset .in made by .dS
.nr !+ 0
.nr !% 0
..
...\"
...\" Start type declaration (uses [opt] )
...\"
.de dS
.if \\n(!+=1 \{\
...\"   this path is for funtion prototype form
.	ie \\n(!%=0 .in +.5i	\" first dS/dE gets indented
.	el \fB,\fP\" 			\" if NOT 1st .dS only do ","
'	br \}
.br
\&\fB\\$1\fR\"				\" make type be bold
.nr !% 1					\" next time .dS won't be first if in .fS/.fE loop
..
...\"
...\" End type declaration
...\"
.de dE
.if \\n(!+=0 \fB;\fR\"		\" if NOT w/in .fS/.fE loop do ";"
..
...\"
...\"
...\"
...\"   Macros for Tagging Index, Key, & Glossary Entries
...\"   -------------------------------------------------
...\"
...\"
...\"
...\" Name of keyboard key, shown in <name> form
.de kY
.ft B
<\\$1>
.ft
..
...\" Keyboard key name followed by ordinary text
.de K,
\fB<\\$1>\fP\\$2
..
...\" Ordinary text followed by keyboard key name
.de ,K
\&\\$1\fB<\\$2>\fP
..
...\" Glossary term 
...\" (rem: .gL acts differently when inside .wS & .wE [gpsml])
...\"  -- defined in {draft|pub}-mmt+.mm because only meaningful with Sync files
...\".de gL
...\".tm !GLOSSARY: "\\$1" "\\n(H1-\\nP"
...\"..
...\"
...\"
...\"
...\" Emphasized text
.de eM
.ft I
\&\\$1
.ft
..
...\" Emphasized text followed by ordinary text
.de E,
\&\fI\\$1\fP\^\\$2
..
...\" Ordinary text followed by emphasized text
.de ,E
\&\\$1\^\fI\\$2\fP
..
...\"
...\"
...\"
...\"   Macros That Include, Define Strings, & Mark Up Pages
...\"   ----------------------------------------------------
...\"
...\"
...\"
...\" Include subdocument of same type
.de dI
..
...\" Include subdocument of example type
.de eI
.nf
.di !~
so\\$1
.br
.di
.eo
.c2 
.nr !x 8*\\w'0'
.ta \\n(!xu +\\n(!xu +\\n(!xu +\\n(!xu +\\n(!xu +\\n(!xu +\\n(!xu +\\n(!xu +\\n(!xu +\\n(!xu
.ft CW
.cc 
!~            \" do the .so here
cc
.ft
.c2
.ec
.fi
..
...\" Include PostScript subdocument: print encapsulated PostScript file
...\" .pI filename [height [width]]
...\" where height is the vertical size of the picture.
.de pI
.br
.fl
.rs
.sy includePS "\\$1" "\\$2" "\\$3" > /tmp/pI.tmp.
.sy rm -f /tmp/pI.tmp.
..
...\" Page markup information
.de pM
...\".tm "Warning:  .pM currently undefined"
..
...\"
...\"
...\"   Escape Mechanisms
...\"   -----------------
...\"
...\"
...\" Force a page break here
.de nP
.bp
..
...\" Force a line break
.de nL
.br
..
...\" Tag text converted from another language, not recognized
.de wH
..
...\"
...\"   Rename the -man .RS/.RE to .rS/.rE for rsml use
.rn RS rS
.rn RE rE
...\"
...\"
...\"
...\"
...\"	Macros Delimiting Titled Elements of a Document
...\"	-----------------------------------------------
...\"
...\" Top head in reference page (Note: this differs from gpsml .TH)
...\" lmui hasn't fixed this yet.
.de tH
..
...\"
...\"
...\"
...\"  initializations:
.nr Ll 0 1	\" no lists active
.nr $A 0 1	\" no lists active
.nr $M 0 1	\" no lists active
.nr $V 0 1	\" no lists active
...\"
...\"
...\" Make paragraph spacing correct inside of lists
.rn PP P#
...\"
.de PP
.ie \\n(Ll>0 .sp \\n(PDu
.el .P#
..
...\"
...\"
...\"
...\" Start nonsequential invariant list
...\"
...\"
.de ML
.SP
.nr $M +1	\" another 'M' level
.if \\n(Ll>0 .rS \\n(%\\n(Llu
.nr Ll +1
...\" set mark indent to work for both troff & nroff
.nr %\\n(Ll .5i
.ie \\n($M=1 .ds %\\n(Ll \(bu
.el \{\
.	ie t .ds %\\n(Ll \(em
.	el .ds %\\n(Ll --
'	br \}
.ie n .ds %\\n(Ll "\ \ \\*(%\\n(Ll
.el .ds %\\n(Ll "\ \ \ \ \ \ \ \\*(%\\n(Ll
.nr #\\n(Ll 0 1
.ds #\\n(Ll M\" we're in a marked list
..
...\"
...\"
...\" Start nonsequential variant list
...\"
...\"
.de VL
.SP
.nr $V +1	\" another level
.if \\n(Ll>0 .rS \\n(%\\n(Llu
.nr Ll +1
.ie \\$1 .nr %\\n(Ll 1i\" default when no indent provided
.el .nr %\\n(Ll \\$1n
.ds #\\n(Ll V\" we're in a variable list
..
...\"
...\"
...\" Start seqential invariant list
...\"
...\"
.de AL
.SP
.nr $A +1
.if \\n(Ll>0 .rS \\n(%\\n(Llu
.nr Ll +1
.nr %\\n(Ll .5i
.ie \\n($A=1 .af #\\n(Ll 1
.el .ie \\n($A=2 .af #\\n(Ll a
.el .af #\\n(Ll i
.nr #\\n(Ll 0 1
.ds %\\n(Ll \\\\\\\\\\\\\\\\n+(#\\n(Ll
.ie n .ds %\\n(Ll "\ \\*(%\\n(Ll
.el .ds %\\n(Ll "\ \ \ \ \ \\*(%\\n(Ll
.ds #\\n(Ll A\" within an auto list
..
...\" List item
.de LI
.SP .25
...\"
...\" test & process for 'V' list
.ie \\*(#\\n(LlV \{\
.	IP "\\$1" \\n(%\\n(Llu
'	br \}
...\"
...\" test & process for 'M' list
.el .ie \\*(#\\n(LlM \{\
.	IP \\*(%\\n(Ll \\n(%\\n(Llu
'	br \}
...\"
...\" otherwise, do an 'A' list, using a "." separator
.el .IP \\*(%\\n(Ll. \\n(%\\n(Llu
..
...\"
...\" End of list
.de LE
...\" decrement list level counter made in 'A', 'M', 'V' lists
.ie \\*(#\\n(LlA \{\
.	nr $A -1
.	nr Ll -1
.	if \\n(Ll>0 .rE
'	in \\n(%\\n(Llu+\\n()Ru+\\n(INu
'	br \}
.el .ie \\*(#\\n(LlV \{\
.	nr $V -1
.	nr Ll -1
.	if \\n(Ll>0 .rE
'	in \\n(%\\n(Llu+\\n()Ru+\\n(INu
'	br \}
.el .if \\*(#\\n(LlM \{\
.	nr $M -1
.	nr Ll -1
.	if \\n(Ll>=0 .rE
'	in \\n(%\\n(Llu+\\n()Ru+\\n(INu
'	br \}
.SP
..
...\"
...\"
...\"
...\"
...\"	Captions:  figure, table, equation, and exhibit
...\"
...\"	-mm defines these, but not -man.  We here define equivalents
...\"	for the -man based pages.  They generate TOC info as well as
...\"	the caption info in the running text.
...\"
...\"
.de FG	\" Figures
.)F Figure 0 \\n+(Fg "\\$1"
..
...\"
.de TB	\" Tables
.)F Table 1 \\n+(Tb "\\$1"
..
...\"
.de EC	\" Equations
.)F Equation 2 \\n+(Ec "\\$1"
..
...\"
.de EX	\" Exhibits
.)F Exhibit 3 \\n+(Ex "\\$1"
..
...\"
...\"
...\"	Now, the generalized output routines
.de )F
.sp \\n(PDu
.ce 1
\\$1\ \\n(H1\(mi\\$3.\ \ \\$4
.sp \\n(PDu
.tm !TOC: .if \\$2=\\\\\\\\$1 .)T 1 1 "\\$1\ \\n(H1\(mi\\$3.\ \ " "\\$4" \\nP \\n(H1
..
...\"
...\"
...\"	Generalized, accumulating output spacer...
.de SP
.nr |Q \\n(PDu
.if \\n(.$ .nr |Q \\$1v
.if !(\\n(nl=\\n(|B) .nr |A 0
.nr |Q -\\n(|Au
.if \\n(|Q \{\
.	sp \\n(|Qu
.	nr |A +\\n(|Qu
'	br \}
.nr |B \\n(nl
..
...\"
...\"
.TH make "1" "" "" "" ""
.iX "make command"
.iX "makefiles"
.iX "files" "makefiles"
.iX "versions" "programs"
.iX "maintaining" "program groups"
.iX "programs" "versions"
.iX "programs" "maintenance"
.iX "updating" "program groups"
.iX "programs" "updating"
.SH NAME
.PP
\*Lmake\*O - Maintains program dependencies
.SH SYNOPSIS
.PP
.sS
.in +.5i
.ti -.5i
\*Lmake\*O
\*O[\*L-eiknqrstv\*O]
\*O[\*L-D \*Vvariable\*O]
\*O[\*L-d \*Vflags\*O]
\*O[\*L-f \*Vmakefile\*O]
\*O[\*L-I \*Vdirectory\*O]
\*O[\*L-j \*Vmax_jobs\*O]
\*O[\*Voperands\*O \&.\&.\&.]
.in -.5i
.sE
.SH FLAGS
.PP
.VL 4m
.LI "\*L-D \*Vvariable\*O"
Defines
\*Vvariable\*O
to be 1, in the global context.
.LI "\*L-d \*Vflags\*O"
Turns on debugging, and specifies which portions of
\*Lmake\*O
are to print debugging information.
\*Vflags\*O
is one or more of the following:
.VL 4m
.LI "\*LA\*O"
Prints all possible debugging information; equivalent to specifying
all of the debugging flags.
.LI "\*La\*O"
Prints debugging information about archive searching and caching.
.LI "\*Lc\*O"
Prints debugging information about conditional evaluation.
.LI "\*Ld\*O"
Prints debugging information about directory searching and caching.
.LI "\*Lg1\*O"
Prints the input graph before making anything.
.LI "\*Lg2\*O"
Prints the input graph after making everything, or before exiting
on error.
.LI "\*Lj\*O"
Prints debugging information about running multiple shells.
.LI "\*Lm\*O"
Prints debugging information about making targets, including modification
dates.
.LI "\*Ls\*O"
Prints debugging information about suffix-transformation rules.
.LI "\*Lt\*O"
Prints debugging information about target list maintenance.
.LI "\*Lv\*O"
Prints debugging information about variable assignment.
.LE
.LI "\*L-e\*O"
Specifies that environmental variables override macro assignments within
makefiles.
.LI "\*L-f \*Vmakefile\*O"
Specifies a makefile to read instead of the default 
\*Lmakefile\*O and \*LMakefile\*O.  If
\*Vmakefile\*O is \*L\-\*O, standard input is read.
Multiple makefiles may be specified, and are read in the order specified.
.LI "\*L-I \*Vdirectory\*O"
Specifies a directory in which to search for makefiles and included makefiles.
The system makefile 
directory is automatically included as part of this list.
.LI "\*L-i\*O"
Ignores nonzero exit of shell commands in the makefile.
Equivalent to specifying \*L\-\*O before each command line in the makefile.
.LI "\*L-j \*Vmax_jobs\*O"
Specifies the maximum number of jobs that
\*Lmake\*O
may have running at any one time.
.LI "\*L-k\*O"
Continues processing after errors are encountered, but only on those targets
that do not depend on the target whose creation caused the error.
.LI "\*L-n\*O"
Displays the commands that would have been executed, but does not actually
execute them.
.LI "\*L-q\*O"
Does not execute any commands, but returns exit value
0 if the specified targets are up-to-date and 1, otherwise.
.LI "\*L-r\*O"
Does not use the built-in rules specified in the system makefile.
.LI "\*L-s\*O"
Does not echo any commands as they are executed.
Equivalent to specifying \*L@\*O before each command line in the makefile.
.LI "\*L-t\*O"
Creates a target
or updates its modification time to make it appear up-to-date,
instead of re-building a target as specified in the makefile. 
.LI "\*Voperand\*O"
Specifies a target name of the form \*Vtarget\*O or
sets the value of the variable \*Vvariable\*O to \*Vvalue\*O
with the form \*Vvariable\*L=\*Vvalue\*O.
.LE
.SH DESCRIPTION
.PP
\*Lmake\*O
is a program designed to simplify the maintenance of other programs.
Its input is a list of specifications as to the files upon which programs
and other files depend.
If the file \*Lmakefile\*O 
exists, it is read for this list of specifications.
If it does not exist, the file \*LMakefile\*O is read.
.PP
There are six different types of lines in a makefile: file dependency
specifications, shell commands, variable assignments, include statements,
conditional directives, and comments.
.PP
In general, lines may be continued from one line to the next by ending
them with a backslash (\*L\e\*O).
The trailing newline character and initial whitespace on the following
line are compressed into a single space.
.SS File Dependency Specifications
.PP
Dependency lines consist of one or more targets, an operator, and zero
or more sources.
This creates a relationship where the targets depend on the sources
and are usually created from them.
The exact relationship between the target and the source is determined
by the operator that separates them.
The three operators are as follows:
.VL 4m
.LI "\*L:\*O"
A target is considered out-of-date if its modification time is less than
those of any of its sources.
Sources for a target accumulate over dependency lines when this operator
is used.
The target is removed if
\*Lmake\*O
is interrupted.
.LI "\*L!\*O"
Targets are always re-created, but not until all sources have been
examined and re-created as necessary.
Sources for a target accumulate over dependency lines when this operator
is used.
The target is removed if
\*Lmake\*O
is interrupted.
.LI "\*L::\*O"
If no sources are specified, the target is always re-created.
Otherwise, a target is considered out-of-date if any of its sources has
been modified more recently than the target.
Sources for a target do not accumulate over dependency lines when this
operator is used.
The target will not be removed if
\*Lmake\*O
is interrupted.
.LE
.PP
Targets and sources may contain the shell wildcard values \*L?\*O, 
\*L*\*O, \*L[]\*O, and \*L{}\*O.
The values \*L?\*O, \*L*\*O and \*L[]\*O
may only be used as part of the final
component of the target or source, and must be used to describe existing
files.
The value \*L{}\*O need not necessarily be used to describe existing files.
Expansion is in directory order, not alphabetically as done in the shell.
.SS Shell Commands
.PP
Each target may have associated with it a series of shell commands, normally
used to create the target.
Each of the commands in this script
\*Emust\*O
be preceded by a tab.
While any target may appear on a dependency line, only one of these
dependencies may be followed by a creation script, unless the \*L::\*O
operator is used.
.PP
If the first or first two characters of the command line are \*L@\*O and/or
\*L\-\*O, the command is treated specially.
A \*L@\*O causes the command not to be echoed before it is executed.
A \*L\-\*O causes any nonzero exit status of the command line to be ignored.
.SS Variable Assignments
.PP
Variables in make are much like variables in the shell, and, by tradition,
consist of all upper-case letters.
The five operators that can be used to assign values to variables are as
follows:
.VL 4m
.LI "\*L=\*O"
Assigns the value to the variable.
Any previous value is overridden.
.LI "\*L+=\*O"
Appends the value to the current value of the variable.
.LI "\*L?=\*O"
Assigns the value to the variable if it is not already defined.
.LI "\*L:=\*O"
Assigns with expansion, that is, expand the value before assigning it
to the variable.  Normally, 
expansion is not done until the variable is referenced.
.LI "\*L!=\*O"
Expands the value and passes it to the shell for execution, and assigns
the result to the variable.  Any newlines in the 
result are replaced with spaces.
.LE
.PP
Any whitespace before the assigned
\*Vvalue\*O
is removed; if the value is being appended, a single space is inserted
between the previous contents of the variable and the appended value.
.PP
Variables are expanded by surrounding the variable name with either
braces (\*L{}\*O) or parentheses (\*L()\*O) and preceding it with
a dollar sign (\*L$\*O).  If the 
variable name contains only a single letter, the surrounding
braces or parentheses are not required.  This shorter form is not recommended.
.PP
Variable substitution occurs at two distinct times, depending on where
the variable is being used.
Variables in dependency lines are expanded as the line is read.
Variables in shell commands are expanded when the shell command is executed.
.PP
The four different classes of variables (in order of increasing precedence)
are:
.VL 4m
.LI "environment variables"
Variables defined as part of
\*Lmake\*O's environment.
.LI "global variables"
Variables defined in the makefile or in included makefiles.
.LI "command line variables"
Variables defined as part of the command line.
.LI "local variables"
Variables that are defined specific to a certain target.
The seven local variables are as follows:
.VL 4m
.LI "\*V\&.ALLSRC\*O"
The list of all sources for this target; also known as \*L>\*O.
.LI "\*V\&.ARCHIVE\*O"
The name of the archive file.
.LI "\*V\&.IMPSRC\*O"
The name/path of the source from which the target is to be transformed
(the implied source); also known as \*L<\*O.
.LI "\*V\&.MEMBER\*O"
The name of the archive member.
.LI "\*V\&.OODATE\*O"
The list of sources for this target that were deemed out-of-date; also
known as \*L?\*O.
.LI "\*V\&.PREFIX\*O"
The file prefix of the file, containing only the file portion, no suffix
or preceding directory components; also known as \*L*\*O.
.LI "\*V\&.TARGET\*O"
The name of the target; also known as \*L@\*O.
.LE
.PP
The shorter forms \*L@\*O, \*L?\*O, \*L>\*O and \*L*\*O 
are permitted for backward
compatibility with historical makefiles and are not recommended.
The six variables \*L@F\*O, \*L@D\*O, \*L<F\*O, \*L<D\*O, 
\*L*F\*O and \*L*D\*O are
permitted for compatibility with System V makefiles and are not recommended.
.PP
Four of the local variables may be used in sources on dependency lines
because they expand to the proper value for each target on the line.
These variables are \*V\&.TARGET\*O, 
\*V\&.PREFIX\*O, \*V\&.ARCHIVE\*O, and \*V\&.MEMBER\*O.
.PP
In addition,
\*Lmake\*O
sets or knows about the following variables:
.VL 4m
.LI "\*L$\*O"
A single dollar sign (\*L$\*O), that is, \*L$$\*O expands to a single dollar
sign.
.LI "\*V\&.MAKE\*O"
The name that
\*Lmake\*O
was executed with
\*L(\*Vargv\*O [\*L0\*O]\*L)\*O
.LI "\*V\&.CURDIR\*O"
A path to the directory where
\*Lmake\*O
was executed.
.LI "\*VMAKEFLAGS\*O"
The environment variable \*VMAKEFLAGS\*O may contain anything that
may be specified on
\*Lmake\*O's command line.  Anything specified on
\*Lmake\*O's
command line is appended to the \*VMAKEFLAGS\*O variable which is then
entered into the environment for all programs which
\*Lmake\*O executes.
.LE
.PP
Variable expansion may be modified to select or modify each word of the
variable (where a word is a sequence of characters delimited by
whitespace).  The general format of a variable expansion is as follows:
.iS
{\*Vvariable\*O[\*L:\*Vmodifier\*O[\*L:\*O...]]\*L}
.iE
.PP
Each modifier begins with a colon and one of the following
special characters.  The colon may be escaped with a backslash (\*L\e\*O).
.VL 4m
.LI "\*LD\*Vnewval\*O"
If the variable being modified is defined, replace
the current value with \*Vnewval\*O.
.LI "\*LE\*O"
Replaces each word in the variable with its suffix.
.LI "\*LH\*O"
Replaces each word in the variable with everything but the last component.
.LI "\*LL\*O"
Replaces any value (unlikely) with the name of
\*Vvariable\*O itself (that is, \*Vvalue\*O is literal).
.LI "\*LM\*Vpattern\*O"
Selects only those words that match the rest of the modifier.
The standard shell wildcard characters (\*L*\*O, \*L?\*O, and
\*L[]\*O) may be used.
The wildcard characters may be escaped with a backslash (\*L\e\*O).
.LI "\*LN\*Vpattern\*O"
This is identical to \*LM\*O, but selects all words which do not match
the rest of the modifier.
.LI "\*LP\*O"
Replaces any value (unlikely) with the path of
the node with the same name as \*Vvariable\*O.
.LI "\*LR\*O"
Replaces each word in the variable with everything but its suffix.
.LI "\*LS/\*Vold_pattern\*L/\*Vnew_pattern\*L/\*O[\*Lg\*O]"
Modifies the first occurrence of
\*Vold_pattern\*O
in each word to be replaced with
\*Vnew_pattern\*O. 
If a \*Lg\*O is appended to the last slash of the pattern, all occurrences
in each word are replaced.  If
\*Vold_pattern\*O
begins with a carat (\*L^\*O),
\*Vold_pattern\*O
is anchored at the beginning of each word.  If
\*Vold_pattern\*O
ends with a dollar sign (\*L$\*O), it is anchored at the end of each word.
Inside \*Vnew_string\*O,
an ampersand (\*L&\*O) is replaced by
\*Vold_pattern\*O.
Any character may be used as a delimiter for the parts of the modifier
string.  The anchoring, ampersand 
and delimiter characters may be escaped with a
backslash (\*L\e\*O).
.PP
Variable expansion occurs in the normal fashion inside both
\*Vold_string\*O
and
\*Vnew_string\*O
with the single exception that a backslash is used to prevent the expansion
of a dollar sign (\*L$\*O), 
not a preceding dollar sign as is usual.
.LI "\*LT\*O"
Replaces each word in the variable with its last component.
.LI "\*LU\*Vnewval\*O
If the variable being modified is undefined, replace
the current value with \*Vnewval\*O.
.LI "\*L!\*Vcommand\*L!\*O"
Runs \*Vcommand\*O through the shell 
if the value when the modifier is encountered
is an empty string (whitespace only).
.LI "\*L@\*Vtmpvar\*L@\*Vnewval\*L@\*O"
Assigns a temporary variable \*Vtmpvar\*O to the value
of each word in the value when the modifier was
encountered and evaluates \*Vnewval\*O for each word.
.LI "\*Vold_string\*L=\*Vnew_string\*O"
This is the System V style variable substitution.
It must be the last modifier specified.
\*Vold_string\*O
is anchored at the end of each word, so only suffixes or entire
words may be replaced.
.LE
.SS Include Statements and Conditionals
.PP
Makefile inclusion and conditional structures reminiscent of the C
programming language are provided in
\*Lmake\*O.  All such structures 
are identified by a line beginning with a single
dot (\*L\&.\*O) character.
Files are included with either \*L\&.include\*O <\*Vfile\*O> or 
\*L\&.include "\*Vfile\*L"\*O.
Variables between the angle brackets or double quotes are expanded
to form the file name.  If brackets are used, 
the included makefile is expected to be in
the system makefile directory.  If double quotes are 
used, the including makefile's directory and any
directories specified using the \*L-I\*O
flag are searched before the system makefile directory.
.Pp
Conditional expressions are also preceded by a single dot as the first
chraracter of a line.  The possible conditionals are as follows:
.VL 4m
.LI "\*L\&.undef \*Vvariable\*O"
Undefines the specified global variable.
Only global variables may be undefined.
.LI "\*L\&.if\*O[\*L!\*O]\*Vexpression\*O [\*Voperator expression \*O\&.\&.\&.]"
Tests the value of an expression.
.LI "\*L\&.ifdef\*O[\*L!\*O]\*Vvariable\*O [\*Voperator variable \*O\&.\&.\&.]"
Tests the value of an variable.
.LI "\*L\&.ifndef\*O[\*L!\*O]\*Vvariable\*O [\*Voperator variable \*O\&.\&.\&.]"
Tests the value of an variable.
.LI "\*L\&.ifmake\*O[\*L!\*O]\*Vtarget\*O [\*Voperator target \*O\&.\&.\&.]"
Tests the the target being built.
.LI "\*L\&.ifnmake\*O[\*L!\*O]\*Vtarget\*O [\*Voperator target \*O\&.\&.\&.]"
Tests the target being built.
.LI "\*L\&.else\*O"
Reverses the sense of the last conditional.
.LI "\*L\&.elif\*O[\*L!\*O]\*Vexpression\*O [\*Voperator expression \*O\&.\&.\&.]"
A combination of \*L\&.else\*O followed by \*L\&.if\*O.
.LI "\*L\&.elifdef\*O[\*L!\*O]\*Vvariable\*O [\*Voperator variable \*O\&.\&.\&.]"
A combination of \*L\&.else\*O followed by \*L\&.ifdef\*O.
.LI "\*L\&.elifndef\*O[\*L!\*O]\*Vvariable\*O [\*Voperator variable \*O\&.\&.\&.]"
A combination of \*L\&.else\*O followed by \*L\&.ifndef\*O.
.LI "\*L\&.elifmake\*O[\*L!\*O]\*Vtarget\*O [\*Voperator target \*O\&.\&.\&.]"
A combination of \*L\&.else\*O followed by \*L\&.ifmake\*O.
.LI "\*L\&.elifnmake\*O[\*L!\*O]\*Vtarget\*O [\*Voperator target \*O\&.\&.\&.]"
A combination of \*L\&.else\*O followed by \*L\&.ifnmake\*O.
.LI "\*L\&.endif\*O"
Ends the body of the conditional.
.LE
.PP
\*Voperator\*O
may be any one of the following:
.VL 4m
.LI "\*L||\*O"
logical OR
.LI "\*L&&\*O"
Logical AND; of higher precedence than \*L``''\*O.
.LE
.LE
.PP
As in C,
\*Lmake\*O
will only evaluate a conditional as far as is necessary to determine
its value.  Parentheses may be 
used to change the order of evaluation.
The boolean operator \*L!\*O may be used to logically negate an entire
conditional.  It is of higher precendence than \*L&&\*O.
.PP
The value of
\*Vexpression\*O
may be any of the following:
.VL 4m
.LI "\*Ldefined\*O"
Takes a variable name as an argument and evaluates to true if the variable
has been defined.
.LI "\*Lmake\*O"
Takes a target name as an argument and evaluates to true if the target
was specified as part of
\*Lmake\*O's
command line or was declared the default target (either implicitly or
explicitly, see \*L\&.MAIN\*O) before the line containing the conditional.
.LI "\*Lempty\*O"
Takes a variable, with possible modifiers, and evalutes to true if
the expansion of the variable would result in an empty string.
.LI "\*Lexists\*O"
Takes a file name as an argument and evaluates to true if the file exists.
The file is searched for on the system search path (see \*L\&.PATH\*O).
.LI "\*Ltarget\*O"
Takes a target name as an argument and evaluates to true if the target
has been defined.
.LE
.PP
\*Vexpression\*O
may also be an arithmetic or string comparison, with the lefthand side
being a variable expansion.  The standard C 
relational operators are all supported, and the usual
number/base conversion is performed.  Note, octal numbers are not supported.
If the righthand value of a \*L==\*O or \*L!=\*O operator begins with a
quotation mark (\*L"\*O) a string comparison is done between the expanded
variable and the text between the quotation marks.
If no relational operator is given, it is assumed that the expanded
variable is being compared against 0.
.PP
When
\*Lmake\*O
is evaluating one of these conditional expression, and it encounters
a word it doesn't recognize, either the \*Lmake\*O or \*Ldefined\*O
expression is applied to it, depending on the form of the conditional.
If the form is \*L\&.ifdef\*O or 
\*L\&.ifndef\*O, the \*Ldefined\*O expression is applied.
Similarly, if the form is \*L\&.ifmake\*O or \*L\&.ifnmake\*O, 
the \*Lmake\*O expression is applied.
.PP
If the conditional evaluates to true the parsing of the makefile continues
as before.
If it evaluates to false, the following lines are skipped.
In both cases this continues until a \*L\&.else\*O or 
\*L\&.endif\*O is found.
.SS Comments
.PP
Comments begin with a pound sign (\*L#\*O), anywhere but in a shell
command line, and continue to the end of the line.
.SS Special Sources
.PP
.VL 4m
.LI "\*L\&.IGNORE\*O"
Ignores any errors from the commands associated with this target, exactly
as if they all were preceded by a dash (\*L\-\*O).
.LI "\*L\&.MAKE\*O"
Executes the commands associated with this target even if the \*L-n\*O 
or \*L-t\*O flags were specified.  Normally used to mark recursive
\*Lmake\*O's.
.LI "\*L\&.NOTMAIN\*O"
Normally
\*Lmake\*O
selects the first target it encounters as the default target to be built
if no target was specified.  This source prevents 
this target from being selected.
.LI "\*L\&.OPTIONAL\*O"
If a target is marked with this attribute and
\*Lmake\*O
can't figure out how to create it, it will ignore this fact and assume
the file isn't needed or already exists.
.LI "\*L\&.PRECIOUS\*O"
When
\*Lmake\*O
is interrupted, it removes any partially made targets.
This source prevents the target from being removed.
.LI "\*L\&.SILENT\*O"
Does not echo any of the commands associated with this target, exactly
as if they all were preceded by an at sign (\*L@\*O).
.LI "\*L\&.USE\*O"
Turns the target into
\*Lmake\*O's
version of a macro.  When the target 
is used as a source for another target, the other target
acquires the commands, sources, and attributes (except for 
\*L\&.USE\*O) of the source.  If the target already 
has commands, the \*L\&.USE\*O target's commands are appended to them.
.LE
.SS Special Targets
.PP
Special targets may not be included with other targets, that is, they must be
the only target specified.
.VL 4m 
.LI "\*L\&.BEGIN\*O"
Any command lines attached to this target are executed before anything
else is done.
.LI "\*L\&.DEFAULT\*O"
This is sort of a \*L\&.USE\*O rule for any target (that was used only as a
source) that
\*Lmake\*O
can't figure out any other way to create.  Only the shell script is used.
The \*L\&.IMPSRC\*O variable of 
a target that inherits \*L\&.DEFAULT\*O's commands is set
to the target's own name.
.LI "\*L\&.END\*O"
Any command lines attached to this target are executed after everything
else is done.
.LI "\*L\&.ERRORS\*O"
If there was an error, this target is executed.
.LI "\*L\&.EXIT\*O"
This target is executed anytime that the \*L\&.END\*O,
\*L\&.ERROR\*O, or \*L\&.INTERRUPT\*O targets would have been
executed, after any of these targets.
.LI "\*L\&.IGNORE\*O"
Marks each of the sources with the \*L\&.IGNORE\*O attribute.
If no sources are specified, this is the equivalent of specifying the 
\*L-i\*O flag.
.LI "\*L\&.INTERRUPT\*O"
If
\*Lmake\*O
is interrupted, the commands for this target will be executed.
.LI "\*L\&.MAIN\*O"
If no target is specified when
\*Lmake\*O
is invoked, this target will be built.
.LI "\*L\&.MAKEFLAGS\*O"
This target provides a way to specify flags for
\*Lmake\*O
when the makefile is used.
The flags are as if typed to the 
shell, though the \*L-f\*O flag will have no effect.
.LI "\*L\&.PATH\*O"
The sources are directories which are to be searched for files not
found in the current directory.  If no sources are 
specified, any previously specified directories are deleted.
.LI "\*L\&.PRECIOUS\*O"
Applies the \*L\&.PRECIOUS\*O attribute to any specified sources.
If no sources are specified, the \*L\&.PRECIOUS\*O 
attribute is applied to every target in the file.
.LI "\*L\&.SILENT\*O"
Applies the \*L\&.SILENT\*O attribute to any specified sources.
If no sources are specified, the \*L\&.SILENT\*O 
attribute is applied to every command in the file.
.LI "\*L\&.SUFFIXES\*O"
Each source specifies a suffix to
\*Lmake\*O.  If no sources are specified, 
any previous specifies suffices are deleted.
.SS Environment
.PP
\*Lmake\*O
utilizes the following environment variables, if they exist:
\*LMAKE\*O, 
\*LMAKEFLAGS\*O,
\*LMAKEOBJDIR\*O
and
\*LMAKESRCDIRPATH\*O.
.SH FILES
.PP
.VL 11m
.LI "\*L/usr/share/mk\*O"
System makefile directory.
.LI "\*L\&depend\*O"
List of dependencies.
.LI "\*LMakefile\*O"
List of dependencies.
.LI "\*Lmakefile\*O"
List of dependencies.
.LI "\*Lsys.mk\*O"
System makefile.
.LE
