#!/bin/csh
#
# Mach Operating System
# Copyright (c) 1992 Carnegie Mellon University
# All Rights Reserved.
# 
# Permission to use, copy, modify and distribute this software and its
# documentation is hereby granted, provided that both the copyright
# notice and this permission notice appear in all copies of the
# software, derivative works or modified versions, and any portions
# thereof, and that both notices appear in supporting documentation.
# 
# CARNEGIE MELLON ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS"
# CONDITION.  CARNEGIE MELLON DISCLAIMS ANY LIABILITY OF ANY KIND FOR
# ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
# 
# Carnegie Mellon requests users of this software to return to
# 
#  Software Distribution Coordinator  or  Software.Distribution@CS.CMU.EDU
#  School of Computer Science
#  Carnegie Mellon University
#  Pittsburgh PA 15213-3890
# 
# any improvements or extensions that they make and grant Carnegie Mellon 
# the rights to redistribute these changes.
#
#
# @OSF_FREE_COPYRIGHT@
#
# Copyright (c) 1991
# Open Software Foundation, Inc.
# 
# Permission is hereby granted to use, copy, modify and freely distribute
# the software in this file and its documentation for any purpose without
# fee, provided that the above copyright notice appears in all copies and
# that both the copyright notice and this permission notice appear in
# supporting documentation.  Further, provided that the name of Open
# Software Foundation, Inc. ("OSF") not be used in advertising or
# publicity pertaining to distribution of the software without prior
# written permission from OSF.  OSF makes no representations about the
# suitability of this software for any purpose.  It is provided "as is"
# without express or implied warranty.
# 
#
#
# HISTORY
# $Log:	setvar.csh,v $
# Revision 2.2  92/05/20  20:16:42  mrt
# 	Put EndLog marker in the right place
# 	[92/05/20  14:34:30  mrt]
# 
# 	First checkin
# 
# 	[92/05/20            mrt]
# 	$EndLog$
# 

#
# Setup variables describing the current environment
#

# TARGET_MACHINE names subdirectories with machine specific files
setenv TARGET_MACHINE "SUN3"
#target_machine is used as the name of the kernel directory that "machine"
#links to unless it it overridden by KERN_MACHINE_DIR
setenv target_machine "sun3"
setenv TARGET_CPU "SUN3"
setenv target_cpu "sun3"
setenv TARGET_OS "MACH"
setenv target_os "mach"

#
# Default search path 
#
setenv DEFPATH /usr/cs/bin:/usr/ucb:/bin:/usr/bin
setenv DEFCPATH /usr/cs/include:/usr/include
setenv DEFLPATH /usr/cs/lib:/usr/lib

#
# File formats
#
setenv OBJECT_FORMAT A_OUT
setenv ARCHIVE_FORMAT BSDARCH

#
#  Compiler choices
#
setenv CC cc
setenv ASCPP "cc -ES"
setenv CPP /lib/cpp

setenv NOSHARED_LIBRARIES NOSHARED_LIBRARIES

#
# Porting flags - used by some ODE tools to avoid using
# features that the current system doesn't support
# Set PORTING_FLAGS to the ones your system is missing
#
# NO_DIRENT used by md.c
# NO_SETENV
# NO_STRDUP used by makepath.c
# NO_SYSLIMITS used by makepath.c
# NO_UTIMES used by release.c
# NO_VPRINTF used by md.c, release.c

set PORTING_FLAGS="-DNO_STRDUP -DNO_SYS_LIMITS -DNO_DIRENT"

#
# Define these if your system  does not have these entries
# in libc.a. Make needs them and will get them from its 
# porting directory if the NO_ environment variable is set
#

#setenv NO_FSS NOFSS
setenv NO_GETCWD NO_GETCWD
setenv NO_GETOPT NO_GETOPT
#setenv NO_SETENV NO_SETENV
setenv NO_STRDUP NO_STRDUP
#setenv NO_STRERROR NO_STRERROR
setenv NO_WAITPID NO_WAITPID

