/* 
 * Mach Operating System
 * Copyright (c) 1991 Carnegie Mellon University
 * All Rights Reserved.
 * 
 * Permission to use, copy, modify and distribute this software and its
 * documentation is hereby granted, provided that both the copyright
 * notice and this permission notice appear in all copies of the
 * software, derivative works or modified versions, and any portions
 * thereof, and that both notices appear in supporting documentation.
 * 
 * CARNEGIE MELLON ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS"
 * CONDITION.  CARNEGIE MELLON DISCLAIMS ANY LIABILITY OF ANY KIND FOR
 * ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
 * 
 * Carnegie Mellon requests users of this software to return to
 * 
 *  Software Distribution Coordinator  or  Software.Distribution@CS.CMU.EDU
 *  School of Computer Science
 *  Carnegie Mellon University
 *  Pittsburgh PA 15213-3890
 * 
 * any improvements or extensions that they make and grant Carnegie Mellon
 * the rights to redistribute these changes.
 */
/*
 * Copyright 1988, 1989, 1990, 1991 by Intel Corporation,
 * Santa Clara, California.
 * 
 *                          All Rights Reserved
 * 
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appears in all copies and that
 * both the copyright notice and this permission notice appear in
 * supporting documentation, and that the name of Intel not be used in
 * advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.
 * 
 * INTEL DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE INCLUDING
 * ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT
 * SHALL INTEL BE LIABLE FOR ANY SPECIAL, INDIRECT, OR CONSEQUENTIAL
 * DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR
 * PROFITS, WHETHER IN ACTION OF CONTRACT, NEGLIGENCE, OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF
 * THIS SOFTWARE.
 */
/*
 * HISTORY
 * $Log:	_setjmp.s,v $
 * Revision 2.2  91/09/04  11:28:54  jsb
 * 	First checkin. Provided by Intel SSD.
 * 	[91/09/04  10:32:35  jsb]
 * 
 */

//
// _setjmp.s - Renamed for Mach 3.0.  wlb 90/09/13
// cswitch.s - Converted for Mach X107 on i860.
// _setjmp(), _longjmp(), _kdbsetjmp(), _kdblongjmp(), _save_context()
//
#define ASSEMBLY
//
// _setjmp(r16) : routine to save the stack image, used before entering
// 	a routine, so that a signal such as SIGINT can cause the routine 
//	to terminate and to restart execution as of the parameters saved
//	here. This routine is used in conjunction with longjmp(). Essentially
//	allows one to return to a particular location and continue as if
//	nothing happened in between. (Should be used sparingly).
//
_setjmp::
__setjmp::

// 1.	Save copies of R1 (return address) and R16 (return value) immediatly.

	mov	r1,r20
	mov	r16,r19

// 2.	The address to save the data was passed in via R16 -> R19 (see 1.)
//	Start saving away (R4-R15), (Int local values), at address in R19.

	st.l	r4, 0 (r19)
	st.l	r5, 4 (r19)
	st.l	r6, 8 (r19)
	st.l	r7, 12(r19)
	st.l	r8, 16(r19)
	st.l	r9, 20(r19)
	st.l	r10,24(r19)
	st.l	r11,28(r19)
	st.l	r12,32(r19)
	st.l	r13,36(r19)
	st.l	r14,40(r19)
	st.l	r15,44(r19)

// 3. Save the frame pointer (R3), the stack pointer (R2) and the return
//	address (R1).

	st.l	fp, 48(r19)
	st.l	sp, 52(r19)
	st.l	r1, 56(r19)

// 4. Save the current interrupt priority level

//	orh	ha%_curr_ipl,r0,r31
//	ld.l	l%_curr_ipl(r31),r31
//	st.l	r31,60(r19)

// 5. Save (F2-F15) (Float local values)

	fst.l	f2,  64(r19)
	fst.l	f3,  68(r19)
	fst.l	f4,  72(r19)
	fst.l	f5,  76(r19)
	fst.l	f6,  80(r19)
	fst.l	f7,  84(r19)
	fst.l	f8,  88(r19)
	fst.l	f9,  92(r19)
	fst.l	f10, 96(r19)
	fst.l	f11,100(r19)
	fst.l	f12,104(r19)
	fst.l	f13,108(r19)
	fst.l	f14,112(r19)
	fst.l	f15,116(r19)

// 6. Return via (R1), as this is setjmp we return (0)

	bri	r1
	mov	r0,r16


//
// _longjmp(r16) : routine to restore the stack image, to the way it was 
// 	as of a particular setjmp previously executed.
//
_longjmp::
__longjmp::

// 1. Disable interrupts

	mov	r16,r19
//	call	_splhigh
//	nop

// 3. Restore the integer registers (R4-R15)

	// address of save area is in r19
	// return value is in r17
	ld.l	 0(r19),r4
	ld.l 	 4(r19),r5
	ld.l 	 8(r19),r6
	ld.l	12(r19),r7
	ld.l	16(r19),r8
	ld.l	20(r19),r9
	ld.l	24(r19),r10
	ld.l	28(r19),r11
	ld.l	32(r19),r12
	ld.l	36(r19),r13
	ld.l	40(r19),r14
	ld.l	44(r19),r15

// 5. Retrieve the saved interrupt priority level.

//	ld.l	60(r19),r16
//	call	_splx		
//	nop

// 4. Restore the frame pointer(R3) and the stack pointer (R2), return addr(R1)

	ld.l	48(r19),fp
	ld.l	52(r19),sp
	ld.l	56(r19),r1

// 6. Restore the float registers (F2-F15)

	fld.l	 64(r19),f2
	fld.l	 68(r19),f3
	fld.l	 72(r19),f4
	fld.l	 76(r19),f5
	fld.l	 80(r19),f6
	fld.l	 84(r19),f7
	fld.l	 88(r19),f8
	fld.l	 92(r19),f9
	fld.l	 96(r19),f10
	fld.l	100(r19),f11
	fld.l	104(r19),f12
	fld.l	108(r19),f13
	fld.l	112(r19),f14
	fld.l	116(r19),f15


// 8. Return , as this is longjmp, we return (1)

	bri	r1
	or	1,r0,r16

