/* 
 * Mach Operating System
 * Copyright (c) 1989 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement specifies
 * the terms and conditions for use and redistribution.
 */
/*
 * HISTORY
 * $Log:	eflags.h,v $
 * Revision 2.2  90/09/27  13:54:28  rwd
 * 	First Checkin.
 * 	[90/09/18  18:02:17  rwd]
 * 
 * Revision 2.2  90/05/21  13:52:32  dbg
 * 	Created.
 * 	[90/02/08            dbg]
 * 
 */

#ifndef	_I386_EFLAGS_H_
#define	_I386_EFLAGS_H_

/*
 *	i386 flags register
 */
#define	EFL_CF		0x00000001		/* carry */
#define	EFL_PF		0x00000004		/* parity of low 8 bits */
#define	EFL_AF		0x00000010		/* carry out of bit 3 */
#define	EFL_ZF		0x00000040		/* zero */
#define	EFL_SF		0x00000080		/* sign */
#define	EFL_TF		0x00000100		/* trace trap */
#define	EFL_IF		0x00000200		/* interrupt enable */
#define	EFL_DF		0x00000400		/* direction */
#define	EFL_OF		0x00000800		/* overflow */
#define	EFL_IOPL	0x00003000		/* IO privilege level: */
#define	EFL_IOPL_KERNEL	0x00000000			/* kernel */
#define	EFL_IOPL_USER	0x00003000			/* user */
#define	EFL_NT		0x00004000		/* nested task */
#define	EFL_RF		0x00010000		/* resume without tracing */
#define	EFL_VM		0x00020000		/* virtual 8086 mode */

#define	EFL_USER_SET	(EFL_IF)
#define	EFL_USER_CLEAR	(EFL_IOPL|EFL_NT|EFL_RF)

#endif	_I386_EFLAGS_H_
