/* Main output processing for terminal
   Copyright (C) 1991 Free Software Foundation

This file is part of the GNU Hurd.

The GNU Hurd is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 1, or (at your option)
any later version.

The GNU Hurd is distributed in the hope that it will be useful, 
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with the GNU Hurd; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

/* Written by Michael I. Bushnell.  */

/* This is called to output a character */
void
output_char (char c)
{
  if (termstate.c_lflag & FLUSHO)
    return;

  if (termstate.c_oflag & OPOST)
    {
      if (c == '\n' && (termstate.c_oflag & ONLCR))
	addoutput ('\r');

      if (c == '\t' && (termstate.c_oflag & OXTABS))
	{
	  repeat
	    addoutput (' ');
	  until (outputpsize % 8 == 0);
	  return;
	}

      if (c == '\004' && (termstate.c_oflag & ONOEOT))
	return;
      
      if (c == '~' && (termstate.c_oflag & OTILDE))
	c = '`';

      if ((termstate.c_oflag & OLCASE) && islower (c))
	c = toupper (c);
      else if ((termstate.c_oflag & OLCASE) && isupper (c))
	addoutput ('\\');
    }
  addoutput (c);
}

void
addoutput (char c)
{
  if (c == '\r')
    outputpsize = 0;
  else if (c == '\t')
    outputpsize = (outputpsize + 8) / 8; /* best guess */
  else if (c == '\b')
    outputpsize--;
  else if (c >= ' ' && c <= '~')
    outputpsize++;

  physical_output (c);
}
