#ifndef	_io_user_
#define	_io_user_

/* Module io */

#include <mach/kern_return.h>
#if	(defined(__STDC__) || defined(c_plusplus)) || defined(LINTLIBRARY)
#include <mach/port.h>
#include <mach/message.h>
#endif

#include <mach/std_types.h>
#include <mach/mach_types.h>
#include <device/device_types.h>
#include <device/net_status.h>
#include <gnu/types.h>
#include <hurd/hurd_types.h>
#include <lib/libhurd.h>

/* Routine io_write */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t rpc_io_write
#if	defined(LINTLIBRARY)
    (io_object, isctty, pid, pgrp, data, dataCnt, offset, amount)
	io_t io_object;
	int isctty;
	int pid;
	int pgrp;
	data_t data;
	mach_msg_type_number_t dataCnt;
	int offset;
	int *amount;
{ return rpc_io_write(io_object, isctty, pid, pgrp, data, dataCnt, offset, amount); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	io_t io_object,
	int isctty,
	int pid,
	int pgrp,
	data_t data,
	mach_msg_type_number_t dataCnt,
	int offset,
	int *amount
);
#else
    ();
#endif
#endif

/* Routine io_read */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t rpc_io_read
#if	defined(LINTLIBRARY)
    (io_object, isctty, pid, pgrp, data, dataCnt, offset, amount)
	io_t io_object;
	int isctty;
	int pid;
	int pgrp;
	data_t data;
	mach_msg_type_number_t *dataCnt;
	int offset;
	int amount;
{ return rpc_io_read(io_object, isctty, pid, pgrp, data, dataCnt, offset, amount); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	io_t io_object,
	int isctty,
	int pid,
	int pgrp,
	data_t data,
	mach_msg_type_number_t *dataCnt,
	int offset,
	int amount
);
#else
    ();
#endif
#endif

/* Routine io_ioctl_x */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t rpc_io_ioctl_x
#if	defined(LINTLIBRARY)
    (io_object, isctty, pid, pgrp, ioctl_code)
	io_t io_object;
	int isctty;
	int pid;
	int pgrp;
	int ioctl_code;
{ return rpc_io_ioctl_x(io_object, isctty, pid, pgrp, ioctl_code); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	io_t io_object,
	int isctty,
	int pid,
	int pgrp,
	int ioctl_code
);
#else
    ();
#endif
#endif

/* Routine io_ioctl_r */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t rpc_io_ioctl_r
#if	defined(LINTLIBRARY)
    (io_object, isctty, pid, pgrp, ioctl_code, data, dataCnt)
	io_t io_object;
	int isctty;
	int pid;
	int pgrp;
	int ioctl_code;
	data_t data;
	mach_msg_type_number_t *dataCnt;
{ return rpc_io_ioctl_r(io_object, isctty, pid, pgrp, ioctl_code, data, dataCnt); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	io_t io_object,
	int isctty,
	int pid,
	int pgrp,
	int ioctl_code,
	data_t data,
	mach_msg_type_number_t *dataCnt
);
#else
    ();
#endif
#endif

/* Routine io_ioctl_w */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t rpc_io_ioctl_w
#if	defined(LINTLIBRARY)
    (io_object, isctty, pid, pgrp, ioctl_code, data, dataCnt)
	io_t io_object;
	int isctty;
	int pid;
	int pgrp;
	int ioctl_code;
	data_t data;
	mach_msg_type_number_t dataCnt;
{ return rpc_io_ioctl_w(io_object, isctty, pid, pgrp, ioctl_code, data, dataCnt); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	io_t io_object,
	int isctty,
	int pid,
	int pgrp,
	int ioctl_code,
	data_t data,
	mach_msg_type_number_t dataCnt
);
#else
    ();
#endif
#endif

/* Routine io_ioctl_rw */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t rpc_io_ioctl_rw
#if	defined(LINTLIBRARY)
    (io_object, isctty, pid, pgrp, ioctl_code, ioctl_data_in, ioctl_data_inCnt, ioctl_data_out, ioctl_data_outCnt)
	io_t io_object;
	int isctty;
	int pid;
	int pgrp;
	int ioctl_code;
	data_t ioctl_data_in;
	mach_msg_type_number_t ioctl_data_inCnt;
	data_t ioctl_data_out;
	mach_msg_type_number_t *ioctl_data_outCnt;
{ return rpc_io_ioctl_rw(io_object, isctty, pid, pgrp, ioctl_code, ioctl_data_in, ioctl_data_inCnt, ioctl_data_out, ioctl_data_outCnt); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	io_t io_object,
	int isctty,
	int pid,
	int pgrp,
	int ioctl_code,
	data_t ioctl_data_in,
	mach_msg_type_number_t ioctl_data_inCnt,
	data_t ioctl_data_out,
	mach_msg_type_number_t *ioctl_data_outCnt
);
#else
    ();
#endif
#endif

/* Routine io_set_flags */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t rpc_io_set_flags
#if	defined(LINTLIBRARY)
    (own_io, io_flags)
	io_t own_io;
	int io_flags;
{ return rpc_io_set_flags(own_io, io_flags); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	io_t own_io,
	int io_flags
);
#else
    ();
#endif
#endif

/* Routine io_get_flags */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t rpc_io_get_flags
#if	defined(LINTLIBRARY)
    (own_io, io_flags)
	io_t own_io;
	int *io_flags;
{ return rpc_io_get_flags(own_io, io_flags); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	io_t own_io,
	int *io_flags
);
#else
    ();
#endif
#endif

/* Routine io_select */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t rpc_io_select
#if	defined(LINTLIBRARY)
    (io_object, select_type, return_port, id_tag, select_result)
	io_t io_object;
	int select_type;
	mach_port_t return_port;
	int id_tag;
	int *select_result;
{ return rpc_io_select(io_object, select_type, return_port, id_tag, select_result); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	io_t io_object,
	int select_type,
	mach_port_t return_port,
	int id_tag,
	int *select_result
);
#else
    ();
#endif
#endif

/* Routine io_stat */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t rpc_io_stat
#if	defined(LINTLIBRARY)
    (stat_object, stat_info)
	io_t stat_object;
	io_statbuf_t *stat_info;
{ return rpc_io_stat(stat_object, stat_info); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	io_t stat_object,
	io_statbuf_t *stat_info
);
#else
    ();
#endif
#endif

/* SimpleRoutine io_reauthenticate */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t rpc_io_reauthenticate
#if	defined(LINTLIBRARY)
    (auth_object)
	io_t auth_object;
{ return rpc_io_reauthenticate(auth_object); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	io_t auth_object
);
#else
    ();
#endif
#endif

/* Routine io_interrupt */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t rpc_io_interrupt
#if	defined(LINTLIBRARY)
    (intr_object)
	io_t intr_object;
{ return rpc_io_interrupt(intr_object); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	io_t intr_object
);
#else
    ();
#endif
#endif

/* Routine io_server_version */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t rpc_io_server_version
#if	defined(LINTLIBRARY)
    (vers_object, server_name, server_major_version, server_minor_version, server_edit_level)
	io_t vers_object;
	string_t server_name;
	int *server_major_version;
	int *server_minor_version;
	int *server_edit_level;
{ return rpc_io_server_version(vers_object, server_name, server_major_version, server_minor_version, server_edit_level); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	io_t vers_object,
	string_t server_name,
	int *server_major_version,
	int *server_minor_version,
	int *server_edit_level
);
#else
    ();
#endif
#endif

/* Routine io_map */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t rpc_io_map
#if	defined(LINTLIBRARY)
    (io_object, memobjxx, memobjrd, memobjwt)
	io_t io_object;
	mach_port_t *memobjxx;
	mach_port_t *memobjrd;
	mach_port_t *memobjwt;
{ return rpc_io_map(io_object, memobjxx, memobjrd, memobjwt); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	io_t io_object,
	mach_port_t *memobjxx,
	mach_port_t *memobjrd,
	mach_port_t *memobjwt
);
#else
    ();
#endif
#endif

/* Routine io_map_cntl */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t rpc_io_map_cntl
#if	defined(LINTLIBRARY)
    (io_object, memobjxx, memobjrd, memobjwt)
	io_t io_object;
	mach_port_t *memobjxx;
	mach_port_t *memobjrd;
	mach_port_t *memobjwt;
{ return rpc_io_map_cntl(io_object, memobjxx, memobjrd, memobjwt); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	io_t io_object,
	mach_port_t *memobjxx,
	mach_port_t *memobjrd,
	mach_port_t *memobjwt
);
#else
    ();
#endif
#endif

/* Routine io_get_it */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t rpc_io_get_it
#if	defined(LINTLIBRARY)
    (io_object, cntl)
	io_t io_object;
	mach_port_t cntl;
{ return rpc_io_get_it(io_object, cntl); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	io_t io_object,
	mach_port_t cntl
);
#else
    ();
#endif
#endif

/* Routine io_release_it */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t rpc_io_release_it
#if	defined(LINTLIBRARY)
    (io_object, cntl)
	io_t io_object;
	mach_port_t cntl;
{ return rpc_io_release_it(io_object, cntl); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	io_t io_object,
	mach_port_t cntl
);
#else
    ();
#endif
#endif

/* Routine io_eofnotify */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t rpc_io_eofnotify
#if	defined(LINTLIBRARY)
    (io_object, cntl)
	io_t io_object;
	mach_port_t cntl;
{ return rpc_io_eofnotify(io_object, cntl); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	io_t io_object,
	mach_port_t cntl
);
#else
    ();
#endif
#endif

/* Routine io_prenotify */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t rpc_io_prenotify
#if	defined(LINTLIBRARY)
    (io_object, cntl, write_start, write_end)
	io_t io_object;
	mach_port_t cntl;
	int write_start;
	int write_end;
{ return rpc_io_prenotify(io_object, cntl, write_start, write_end); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	io_t io_object,
	mach_port_t cntl,
	int write_start,
	int write_end
);
#else
    ();
#endif
#endif

/* Routine io_postnotify */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t rpc_io_postnotify
#if	defined(LINTLIBRARY)
    (io_object, cntl, write_start, write_end)
	io_t io_object;
	mach_port_t cntl;
	int write_start;
	int write_end;
{ return rpc_io_postnotify(io_object, cntl, write_start, write_end); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	io_t io_object,
	mach_port_t cntl,
	int write_start,
	int write_end
);
#else
    ();
#endif
#endif

/* Routine io_readsleep */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t rpc_io_readsleep
#if	defined(LINTLIBRARY)
    (io_object, cntl)
	io_t io_object;
	mach_port_t cntl;
{ return rpc_io_readsleep(io_object, cntl); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	io_t io_object,
	mach_port_t cntl
);
#else
    ();
#endif
#endif

/* Routine io_sigio */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t rpc_io_sigio
#if	defined(LINTLIBRARY)
    (io_object, cntl)
	io_t io_object;
	mach_port_t cntl;
{ return rpc_io_sigio(io_object, cntl); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	io_t io_object,
	mach_port_t cntl
);
#else
    ();
#endif
#endif

#endif	_io_user_
