#ifndef	_startup
#define	_startup

/* Module startup */

#include <mach/kern_return.h>
#if	(defined(__STDC__) || defined(c_plusplus)) || defined(LINTLIBRARY)
#include <mach/port.h>
#include <mach/message.h>
#endif

#ifdef	mig_external
mig_external
#else
extern
#endif
void init_startup
#if	(defined(__STDC__) || defined(c_plusplus))
    (mach_port_t rep_port);
#else
    ();
#endif
#include <mach/std_types.h>
#include <mach/mach_types.h>
#include <device/device_types.h>
#include <device/net_status.h>
#include <gnu/types.h>
#include <hurd/hurd_types.h>
#include <lib/libhurd.h>

/* Routine startup_essential_task */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t startup_essential_task
#if	defined(LINTLIBRARY)
    (server, task, name, nameCnt)
	startup_t server;
	mach_port_t task;
	inband_data_t name;
	mach_msg_type_number_t nameCnt;
{ return startup_essential_task(server, task, name, nameCnt); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	startup_t server,
	mach_port_t task,
	inband_data_t name,
	mach_msg_type_number_t nameCnt
);
#else
    ();
#endif
#endif

/* Routine startup_request_notification */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t startup_request_notification
#if	defined(LINTLIBRARY)
    (server, notify_port)
	startup_t server;
	mach_port_t notify_port;
{ return startup_request_notification(server, notify_port); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	startup_t server,
	mach_port_t notify_port
);
#else
    ();
#endif
#endif

/* Routine startup_reboot */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t startup_reboot
#if	defined(LINTLIBRARY)
    (server, reboot_code)
	startup_t server;
	int reboot_code;
{ return startup_reboot(server, reboot_code); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	startup_t server,
	int reboot_code
);
#else
    ();
#endif
#endif

/* Routine startup_procinit */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t startup_procinit
#if	defined(LINTLIBRARY)
    (server, process, task, host_priv, device_master)
	startup_t server;
	process_t process;
	mach_port_t *task;
	mach_port_t *host_priv;
	mach_port_t *device_master;
{ return startup_procinit(server, process, task, host_priv, device_master); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	startup_t server,
	process_t process,
	mach_port_t *task,
	mach_port_t *host_priv,
	mach_port_t *device_master
);
#else
    ();
#endif
#endif

/* Routine startup_authinit */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t startup_authinit
#if	defined(LINTLIBRARY)
    (server, auth, host_priv)
	startup_t server;
	mach_port_t auth;
	mach_port_t *host_priv;
{ return startup_authinit(server, auth, host_priv); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	startup_t server,
	mach_port_t auth,
	mach_port_t *host_priv
);
#else
    ();
#endif
#endif

/* Routine startup_nameinit */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t startup_nameinit
#if	defined(LINTLIBRARY)
    (server, name)
	startup_t server;
	mach_port_t name;
{ return startup_nameinit(server, name); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	startup_t server,
	mach_port_t name
);
#else
    ();
#endif
#endif

/* Routine startup_awaywego */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t startup_awaywego
#if	defined(LINTLIBRARY)
    (server, host_priv, device_master, root)
	startup_t server;
	mach_port_t host_priv;
	mach_port_t device_master;
	file_t root;
{ return startup_awaywego(server, host_priv, device_master, root); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	startup_t server,
	mach_port_t host_priv,
	mach_port_t device_master,
	file_t root
);
#else
    ();
#endif
#endif

/* Routine startup_getservers */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t startup_getservers
#if	defined(LINTLIBRARY)
    (server, auth_server, proc_server, name_server)
	startup_t server;
	auth_t *auth_server;
	process_t *proc_server;
	mach_port_t *name_server;
{ return startup_getservers(server, auth_server, proc_server, name_server); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	startup_t server,
	auth_t *auth_server,
	process_t *proc_server,
	mach_port_t *name_server
);
#else
    ();
#endif
#endif

#endif	_startup
