/* Main entry to proc server
   Copyright (C) 1991 Free Software Foundation

This file is part of the GNU Hurd.

The GNU Hurd is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 1, or (at your option)
any later version.

The GNU Hurd is distributed in the hope that it will be useful, 
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with the GNU Hurd; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

/* Written by Michael I. Bushnell.  */

main ()
{
  mach_port_t bootport;
  struct proc *p;

  task_get_special_port (mach_task_self (), TASK_BOOTSTRAP_PORT, &bootport);
 

  /* Set up process zero; the startup task.  */
  p = make_process_struct ();

  startup_procinit (bootport, p->p_reqport, &p->p_task, &host_priv,
		    &device_master);

  p->p_pid = 0;

  p->p_login = malloc (sizeof (struct login) + 1);
  p->p_login->l_refcnt = 1;
  p->p_login->l_name[0] = '\0';
  
  p->p_argv = p->p_envp = 0;
  
  p->p_parent = 0;
  p->p_sib = 0;
  p->p_ochild = 0;
  
  p->p_pgrp = malloc (sizeof (struct pgrp));
  p->p_pgrp->pg_plist = 0;
  p->p_pgrp->pg_pgid = 0;
  p->p_pgrp->pg_orphcnt = 0;
  p->p_pgrp->pg_session = malloc (sizeof (struct session));
  p->p_pgrp->pg_session->s_leader = p;
  p->p_pgrp->pg_session->s_ctty = MACH_PORT_NULL;
  p->p_pgrp->pg_session->s_count = 1;
  pgaddhash (p->p_pgrp);
  p->p_pgid = 0;
  join_pgrp (p);
  
  bzero (&p->p_idblock);
  p->p_idblock.nuids = p->p_idblock.ngroups = 1;
  
  p->p_sigthread = MACH_PORT_NULL;
  p->p_nsignals = 0;
  p->p_exit_status = 0;
  p->p_stopsig = 0;
  
  p->p_wc.pw_reply_port = MACH_PORT_NULL;

  p->p_exec = 1;
  p->p_stopped = 0;
  p->p_system = 1;
  p->p_waited = 0;
  p->p_exited = 0;
  p->p_waiting = 0;
  p->p_traced = 0;
  p->p_nostopcld = 0;
  
  /* now we are ready to go... */

  XXX;
  
}

