#include "execdefs.h"
#define EXPORT_BOOLEAN
#include <mach/boolean.h>
#include <mach/kern_return.h>
#include <mach/message.h>
#include <mach/notify.h>
#include <mach/mach_types.h>
#include <mach/mig_errors.h>
#include <mach/msg_type.h>
#ifndef	KERNEL
#include <strings.h>
#endif	KERNEL
/* LINTLIBRARY */

extern mach_port_t mig_get_reply_port();
extern void mig_dealloc_reply_port();

#ifndef	mig_internal
#define	mig_internal	static
#endif

#ifndef	mig_external
#define mig_external
#endif

#ifndef	TypeCheck
#define	TypeCheck 1
#endif

#ifndef	UseExternRCSId
#ifdef	hc
#define	UseExternRCSId		1
#endif
#endif

#ifndef	UseStaticMsgType
#if	!defined(hc) || defined(__STDC__)
#define	UseStaticMsgType	1
#endif
#endif

#define msgh_request_port	msgh_remote_port
#define msgh_reply_port		msgh_local_port


/* Routine exec_exec */
mig_external kern_return_t exec_exec
#if	(defined(__STDC__) || defined(c_plusplus))
(
	mach_port_t execserver,
	mach_port_t file,
	mach_port_t oldtask,
	int flags,
	data_t argv,
	mach_msg_type_number_t argvCnt,
	data_t envp,
	mach_msg_type_number_t envpCnt,
	portarray_t dtable,
	mach_msg_type_number_t dtableCnt,
	portarray_t portarray,
	mach_msg_type_number_t portarrayCnt,
	intarray_t intarray,
	mach_msg_type_number_t intarrayCnt
)
#else
	(execserver, file, oldtask, flags, argv, argvCnt, envp, envpCnt, dtable, dtableCnt, portarray, portarrayCnt, intarray, intarrayCnt)
	mach_port_t execserver;
	mach_port_t file;
	mach_port_t oldtask;
	int flags;
	data_t argv;
	mach_msg_type_number_t argvCnt;
	data_t envp;
	mach_msg_type_number_t envpCnt;
	portarray_t dtable;
	mach_msg_type_number_t dtableCnt;
	portarray_t portarray;
	mach_msg_type_number_t portarrayCnt;
	intarray_t intarray;
	mach_msg_type_number_t intarrayCnt;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t fileType;
		mach_port_t file;
		mach_msg_type_t oldtaskType;
		mach_port_t oldtask;
		mach_msg_type_t flagsType;
		int flags;
		mach_msg_type_long_t argvType;
		char argv[2048];
		mach_msg_type_long_t envpType;
		char envp[2048];
		mach_msg_type_long_t dtableType;
		mach_port_t dtable[512];
		mach_msg_type_long_t portarrayType;
		mach_port_t portarray[512];
		mach_msg_type_long_t intarrayType;
		int intarray[512];
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
	} Reply;

	union {
		Request In;
		Reply Out;
	} Mess;

	register Request *InP = &Mess.In;
	register Reply *OutP = &Mess.Out;

	mach_msg_return_t msg_result;
	unsigned int msgh_size;
	unsigned int msgh_size_delta;

#if	UseStaticMsgType
	static mach_msg_type_t fileType = {
		/* msgt_name = */		MACH_MSG_TYPE_MAKE_SEND,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t oldtaskType = {
		/* msgt_name = */		MACH_MSG_TYPE_COPY_SEND,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t flagsType = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_long_t argvType = {
	{
		/* msgt_name = */		0,
		/* msgt_size = */		0,
		/* msgt_number = */		0,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		TRUE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	},
		/* msgtl_name = */	MACH_MSG_TYPE_CHAR,
		/* msgtl_size = */	8,
		/* msgtl_number = */	2048,
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_long_t envpType = {
	{
		/* msgt_name = */		0,
		/* msgt_size = */		0,
		/* msgt_number = */		0,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		TRUE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	},
		/* msgtl_name = */	MACH_MSG_TYPE_CHAR,
		/* msgtl_size = */	8,
		/* msgtl_number = */	2048,
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_long_t dtableType = {
	{
		/* msgt_name = */		0,
		/* msgt_size = */		0,
		/* msgt_number = */		0,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		TRUE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	},
		/* msgtl_name = */	MACH_MSG_TYPE_COPY_SEND,
		/* msgtl_size = */	32,
		/* msgtl_number = */	512,
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_long_t portarrayType = {
	{
		/* msgt_name = */		0,
		/* msgt_size = */		0,
		/* msgt_number = */		0,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		TRUE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	},
		/* msgtl_name = */	MACH_MSG_TYPE_COPY_SEND,
		/* msgtl_size = */	32,
		/* msgtl_number = */	512,
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_long_t intarrayType = {
	{
		/* msgt_name = */		0,
		/* msgt_size = */		0,
		/* msgt_number = */		0,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		TRUE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	},
		/* msgtl_name = */	MACH_MSG_TYPE_INTEGER_32,
		/* msgtl_size = */	32,
		/* msgtl_number = */	512,
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t RetCodeCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	InP->fileType = fileType;
#else	UseStaticMsgType
	InP->fileType.msgt_name = MACH_MSG_TYPE_MAKE_SEND;
	InP->fileType.msgt_size = 32;
	InP->fileType.msgt_number = 1;
	InP->fileType.msgt_inline = TRUE;
	InP->fileType.msgt_longform = FALSE;
	InP->fileType.msgt_deallocate = FALSE;
	InP->fileType.msgt_unused = 0;
#endif	UseStaticMsgType

	InP->file = file;

#if	UseStaticMsgType
	InP->oldtaskType = oldtaskType;
#else	UseStaticMsgType
	InP->oldtaskType.msgt_name = MACH_MSG_TYPE_COPY_SEND;
	InP->oldtaskType.msgt_size = 32;
	InP->oldtaskType.msgt_number = 1;
	InP->oldtaskType.msgt_inline = TRUE;
	InP->oldtaskType.msgt_longform = FALSE;
	InP->oldtaskType.msgt_deallocate = FALSE;
	InP->oldtaskType.msgt_unused = 0;
#endif	UseStaticMsgType

	InP->oldtask = oldtask;

#if	UseStaticMsgType
	InP->flagsType = flagsType;
#else	UseStaticMsgType
	InP->flagsType.msgt_name = MACH_MSG_TYPE_INTEGER_32;
	InP->flagsType.msgt_size = 32;
	InP->flagsType.msgt_number = 1;
	InP->flagsType.msgt_inline = TRUE;
	InP->flagsType.msgt_longform = FALSE;
	InP->flagsType.msgt_deallocate = FALSE;
	InP->flagsType.msgt_unused = 0;
#endif	UseStaticMsgType

	InP->flags = flags;

#if	UseStaticMsgType
	InP->argvType = argvType;
#else	UseStaticMsgType
	InP->argvType.msgtl_name = MACH_MSG_TYPE_CHAR;
	InP->argvType.msgtl_size = 8;
	InP->argvType.msgtl_header.msgt_name = 0;
	InP->argvType.msgtl_header.msgt_size = 0;
	InP->argvType.msgtl_header.msgt_number = 0;
	InP->argvType.msgtl_header.msgt_inline = TRUE;
	InP->argvType.msgtl_header.msgt_longform = TRUE;
	InP->argvType.msgtl_header.msgt_deallocate = FALSE;
	InP->argvType.msgtl_header.msgt_unused = 0;
#endif	UseStaticMsgType

	if (argvCnt > 2048) {
		InP->argvType.msgtl_header.msgt_inline = FALSE;
		*((char **)InP->argv) = argv;
	}
	else {
		bcopy((char *) argv, (char *) InP->argv, argvCnt);
	}

	InP->argvType.msgtl_number = argvCnt;

	msgh_size_delta = (InP->argvType.msgtl_header.msgt_inline) ? argvCnt + 3 & ~3 : sizeof(char *);
	msgh_size = 108 + msgh_size_delta;
	InP = (Request *) ((char *) InP + msgh_size_delta - 2048);
#if	UseStaticMsgType
	InP->envpType = envpType;
#else	UseStaticMsgType
	InP->envpType.msgtl_name = MACH_MSG_TYPE_CHAR;
	InP->envpType.msgtl_size = 8;
	InP->envpType.msgtl_header.msgt_name = 0;
	InP->envpType.msgtl_header.msgt_size = 0;
	InP->envpType.msgtl_header.msgt_number = 0;
	InP->envpType.msgtl_header.msgt_inline = TRUE;
	InP->envpType.msgtl_header.msgt_longform = TRUE;
	InP->envpType.msgtl_header.msgt_deallocate = FALSE;
	InP->envpType.msgtl_header.msgt_unused = 0;
#endif	UseStaticMsgType

	if (envpCnt > 2048) {
		InP->envpType.msgtl_header.msgt_inline = FALSE;
		*((char **)InP->envp) = envp;
	}
	else {
		bcopy((char *) envp, (char *) InP->envp, envpCnt);
	}

	InP->envpType.msgtl_number = envpCnt;

	msgh_size_delta = (InP->envpType.msgtl_header.msgt_inline) ? envpCnt + 3 & ~3 : sizeof(char *);
	msgh_size += msgh_size_delta;
	InP = (Request *) ((char *) InP + msgh_size_delta - 2048);
#if	UseStaticMsgType
	InP->dtableType = dtableType;
#else	UseStaticMsgType
	InP->dtableType.msgtl_name = MACH_MSG_TYPE_COPY_SEND;
	InP->dtableType.msgtl_size = 32;
	InP->dtableType.msgtl_header.msgt_name = 0;
	InP->dtableType.msgtl_header.msgt_size = 0;
	InP->dtableType.msgtl_header.msgt_number = 0;
	InP->dtableType.msgtl_header.msgt_inline = TRUE;
	InP->dtableType.msgtl_header.msgt_longform = TRUE;
	InP->dtableType.msgtl_header.msgt_deallocate = FALSE;
	InP->dtableType.msgtl_header.msgt_unused = 0;
#endif	UseStaticMsgType

	if (dtableCnt > 512) {
		InP->dtableType.msgtl_header.msgt_inline = FALSE;
		*((mach_port_t **)InP->dtable) = dtable;
	}
	else {
		bcopy((char *) dtable, (char *) InP->dtable, 4 * dtableCnt);
	}

	InP->dtableType.msgtl_number = dtableCnt;

	msgh_size_delta = (InP->dtableType.msgtl_header.msgt_inline) ? 4 * dtableCnt : sizeof(mach_port_t *);
	msgh_size += msgh_size_delta;
	InP = (Request *) ((char *) InP + msgh_size_delta - 2048);
#if	UseStaticMsgType
	InP->portarrayType = portarrayType;
#else	UseStaticMsgType
	InP->portarrayType.msgtl_name = MACH_MSG_TYPE_COPY_SEND;
	InP->portarrayType.msgtl_size = 32;
	InP->portarrayType.msgtl_header.msgt_name = 0;
	InP->portarrayType.msgtl_header.msgt_size = 0;
	InP->portarrayType.msgtl_header.msgt_number = 0;
	InP->portarrayType.msgtl_header.msgt_inline = TRUE;
	InP->portarrayType.msgtl_header.msgt_longform = TRUE;
	InP->portarrayType.msgtl_header.msgt_deallocate = FALSE;
	InP->portarrayType.msgtl_header.msgt_unused = 0;
#endif	UseStaticMsgType

	if (portarrayCnt > 512) {
		InP->portarrayType.msgtl_header.msgt_inline = FALSE;
		*((mach_port_t **)InP->portarray) = portarray;
	}
	else {
		bcopy((char *) portarray, (char *) InP->portarray, 4 * portarrayCnt);
	}

	InP->portarrayType.msgtl_number = portarrayCnt;

	msgh_size_delta = (InP->portarrayType.msgtl_header.msgt_inline) ? 4 * portarrayCnt : sizeof(mach_port_t *);
	msgh_size += msgh_size_delta;
	InP = (Request *) ((char *) InP + msgh_size_delta - 2048);
#if	UseStaticMsgType
	InP->intarrayType = intarrayType;
#else	UseStaticMsgType
	InP->intarrayType.msgtl_name = MACH_MSG_TYPE_INTEGER_32;
	InP->intarrayType.msgtl_size = 32;
	InP->intarrayType.msgtl_header.msgt_name = 0;
	InP->intarrayType.msgtl_header.msgt_size = 0;
	InP->intarrayType.msgtl_header.msgt_number = 0;
	InP->intarrayType.msgtl_header.msgt_inline = TRUE;
	InP->intarrayType.msgtl_header.msgt_longform = TRUE;
	InP->intarrayType.msgtl_header.msgt_deallocate = FALSE;
	InP->intarrayType.msgtl_header.msgt_unused = 0;
#endif	UseStaticMsgType

	if (intarrayCnt > 512) {
		InP->intarrayType.msgtl_header.msgt_inline = FALSE;
		*((int **)InP->intarray) = intarray;
	}
	else {
		bcopy((char *) intarray, (char *) InP->intarray, 4 * intarrayCnt);
	}

	InP->intarrayType.msgtl_number = intarrayCnt;

	msgh_size += (InP->intarrayType.msgtl_header.msgt_inline) ? 4 * intarrayCnt : sizeof(int *);
	InP = &Mess.In;
	InP->Head.msgh_bits = MACH_MSGH_BITS_COMPLEX|
		MACH_MSGH_BITS(MACH_MSG_TYPE_COPY_SEND, MACH_MSG_TYPE_MAKE_SEND_ONCE);
	/* msgh_size passed as argument */
	InP->Head.msgh_request_port = execserver;
	InP->Head.msgh_reply_port = mig_get_reply_port();
	InP->Head.msgh_seqno = 0;
	InP->Head.msgh_id = 30000;

	msg_result = mach_msg(&InP->Head, MACH_SEND_MSG|MACH_RCV_MSG|MACH_MSG_OPTION_NONE, msgh_size, sizeof(Reply), InP->Head.msgh_reply_port, MACH_MSG_TIMEOUT_NONE, MACH_PORT_NULL);
	if (msg_result != MACH_MSG_SUCCESS) {
		if ((msg_result == MACH_SEND_INVALID_REPLY) ||
		    (msg_result == MACH_RCV_INVALID_NAME))
			mig_dealloc_reply_port();
		return msg_result;
	}

	if (OutP->Head.msgh_id != 30100) {
		if (OutP->Head.msgh_id == MACH_NOTIFY_SEND_ONCE)
		return MIG_SERVER_DIED;
		else
		return MIG_REPLY_MISMATCH;
	}

#if	TypeCheck
	if ((OutP->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX) ||
	    (OutP->Head.msgh_size != 32))
		return MIG_TYPE_ERROR;
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &OutP->RetCodeType != * (int *) &RetCodeCheck)
#else	UseStaticMsgType
	if ((OutP->RetCodeType.msgt_inline != TRUE) ||
	    (OutP->RetCodeType.msgt_longform != FALSE) ||
	    (OutP->RetCodeType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (OutP->RetCodeType.msgt_number != 1) ||
	    (OutP->RetCodeType.msgt_size != 32))
#endif	UseStaticMsgType
		return MIG_TYPE_ERROR;
#endif	TypeCheck

	return OutP->RetCode;
}

/* Routine exec_startup */
mig_external kern_return_t exec_startup
#if	(defined(__STDC__) || defined(c_plusplus))
(
	mach_port_t execserver,
	int *flags,
	data_t *argv,
	mach_msg_type_number_t *argvCnt,
	data_t *envp,
	mach_msg_type_number_t *envpCnt,
	portarray_t *dtable,
	mach_msg_type_number_t *dtableCnt,
	portarray_t *portarray,
	mach_msg_type_number_t *portarrayCnt,
	intarray_t *intarray,
	mach_msg_type_number_t *intarrayCnt
)
#else
	(execserver, flags, argv, argvCnt, envp, envpCnt, dtable, dtableCnt, portarray, portarrayCnt, intarray, intarrayCnt)
	mach_port_t execserver;
	int *flags;
	data_t *argv;
	mach_msg_type_number_t *argvCnt;
	data_t *envp;
	mach_msg_type_number_t *envpCnt;
	portarray_t *dtable;
	mach_msg_type_number_t *dtableCnt;
	portarray_t *portarray;
	mach_msg_type_number_t *portarrayCnt;
	intarray_t *intarray;
	mach_msg_type_number_t *intarrayCnt;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
		mach_msg_type_t flagsType;
		int flags;
		mach_msg_type_long_t argvType;
		char argv[2048];
		mach_msg_type_long_t envpType;
		char envp[2048];
		mach_msg_type_long_t dtableType;
		mach_port_t dtable[512];
		mach_msg_type_long_t portarrayType;
		mach_port_t portarray[512];
		mach_msg_type_long_t intarrayType;
		int intarray[512];
	} Reply;

	union {
		Request In;
		Reply Out;
	} Mess;

	register Request *InP = &Mess.In;
	register Reply *OutP = &Mess.Out;

	mach_msg_return_t msg_result;
#if	TypeCheck
	boolean_t msgh_simple;
#endif	TypeCheck
#if	TypeCheck
	unsigned int msgh_size;
#endif	TypeCheck
	unsigned int msgh_size_delta;

#if	UseStaticMsgType
	static mach_msg_type_t RetCodeCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t flagsCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

	InP->Head.msgh_bits =
		MACH_MSGH_BITS(MACH_MSG_TYPE_COPY_SEND, MACH_MSG_TYPE_MAKE_SEND_ONCE);
	/* msgh_size passed as argument */
	InP->Head.msgh_request_port = execserver;
	InP->Head.msgh_reply_port = mig_get_reply_port();
	InP->Head.msgh_seqno = 0;
	InP->Head.msgh_id = 30001;

	msg_result = mach_msg(&InP->Head, MACH_SEND_MSG|MACH_RCV_MSG|MACH_MSG_OPTION_NONE, sizeof(Request), sizeof(Reply), InP->Head.msgh_reply_port, MACH_MSG_TIMEOUT_NONE, MACH_PORT_NULL);
	if (msg_result != MACH_MSG_SUCCESS) {
		if ((msg_result == MACH_SEND_INVALID_REPLY) ||
		    (msg_result == MACH_RCV_INVALID_NAME))
			mig_dealloc_reply_port();
		return msg_result;
	}

	if (OutP->Head.msgh_id != 30101) {
		if (OutP->Head.msgh_id == MACH_NOTIFY_SEND_ONCE)
		return MIG_SERVER_DIED;
		else
		return MIG_REPLY_MISMATCH;
	}

#if	TypeCheck
	msgh_size = OutP->Head.msgh_size;
	msgh_simple = !(OutP->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX);

	if (((msgh_size < 100) || msgh_simple) &&
	    ((msgh_size != sizeof(mig_reply_header_t)) ||
	     !msgh_simple ||
	     (OutP->RetCode == KERN_SUCCESS)))
		return MIG_TYPE_ERROR;
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &OutP->RetCodeType != * (int *) &RetCodeCheck)
#else	UseStaticMsgType
	if ((OutP->RetCodeType.msgt_inline != TRUE) ||
	    (OutP->RetCodeType.msgt_longform != FALSE) ||
	    (OutP->RetCodeType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (OutP->RetCodeType.msgt_number != 1) ||
	    (OutP->RetCodeType.msgt_size != 32))
#endif	UseStaticMsgType
		return MIG_TYPE_ERROR;
#endif	TypeCheck

	if (OutP->RetCode != KERN_SUCCESS)
		return OutP->RetCode;

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &OutP->flagsType != * (int *) &flagsCheck)
#else	UseStaticMsgType
	if ((OutP->flagsType.msgt_inline != TRUE) ||
	    (OutP->flagsType.msgt_longform != FALSE) ||
	    (OutP->flagsType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (OutP->flagsType.msgt_number != 1) ||
	    (OutP->flagsType.msgt_size != 32))
#endif	UseStaticMsgType
		return MIG_TYPE_ERROR;
#endif	TypeCheck

	*flags = OutP->flags;

#if	TypeCheck
	if ((OutP->argvType.msgtl_header.msgt_longform != TRUE) ||
	    (OutP->argvType.msgtl_name != MACH_MSG_TYPE_CHAR) ||
	    (OutP->argvType.msgtl_size != 8))
		return MIG_TYPE_ERROR;
#endif	TypeCheck

	msgh_size_delta = (OutP->argvType.msgtl_header.msgt_inline) ? OutP->argvType.msgtl_number + 3 & ~3 : sizeof(char *);
#if	TypeCheck
	if (msgh_size < 100 + msgh_size_delta)
		return MIG_TYPE_ERROR;
	msgh_size -= msgh_size_delta;
#endif	TypeCheck

	if (!OutP->argvType.msgtl_header.msgt_inline)
	    *argv = *((char **)OutP->argv);
	else if (OutP->argvType.msgtl_number > *argvCnt) {
	    mig_allocate((vm_offset_t *)argv,
		OutP->argvType.msgtl_number);
	    bcopy(*(char **)OutP->argv, (char *)*argv, OutP->argvType.msgtl_number);
	}
	else {
	    bcopy((char *) OutP->argv, (char *) *argv, OutP->argvType.msgtl_number);
	}

	*argvCnt = OutP->argvType.msgtl_number;

	OutP = (Reply *) ((char *) OutP + msgh_size_delta - 2048);

#if	TypeCheck
	if ((OutP->envpType.msgtl_header.msgt_longform != TRUE) ||
	    (OutP->envpType.msgtl_name != MACH_MSG_TYPE_CHAR) ||
	    (OutP->envpType.msgtl_size != 8))
		return MIG_TYPE_ERROR;
#endif	TypeCheck

	msgh_size_delta = (OutP->envpType.msgtl_header.msgt_inline) ? OutP->envpType.msgtl_number + 3 & ~3 : sizeof(char *);
#if	TypeCheck
	if (msgh_size < 100 + msgh_size_delta)
		return MIG_TYPE_ERROR;
	msgh_size -= msgh_size_delta;
#endif	TypeCheck

	if (!OutP->envpType.msgtl_header.msgt_inline)
	    *envp = *((char **)OutP->envp);
	else if (OutP->envpType.msgtl_number > *envpCnt) {
	    mig_allocate((vm_offset_t *)envp,
		OutP->envpType.msgtl_number);
	    bcopy(*(char **)OutP->envp, (char *)*envp, OutP->envpType.msgtl_number);
	}
	else {
	    bcopy((char *) OutP->envp, (char *) *envp, OutP->envpType.msgtl_number);
	}

	*envpCnt = OutP->envpType.msgtl_number;

	OutP = (Reply *) ((char *) OutP + msgh_size_delta - 2048);

#if	TypeCheck
	if ((OutP->dtableType.msgtl_header.msgt_longform != TRUE) ||
	    (OutP->dtableType.msgtl_name != MACH_MSG_TYPE_PORT_SEND) ||
	    (OutP->dtableType.msgtl_size != 32))
		return MIG_TYPE_ERROR;
#endif	TypeCheck

	msgh_size_delta = (OutP->dtableType.msgtl_header.msgt_inline) ? 4 * OutP->dtableType.msgtl_number : sizeof(mach_port_t *);
#if	TypeCheck
	if (msgh_size < 100 + msgh_size_delta)
		return MIG_TYPE_ERROR;
	msgh_size -= msgh_size_delta;
#endif	TypeCheck

	if (!OutP->dtableType.msgtl_header.msgt_inline)
	    *dtable = *((mach_port_t **)OutP->dtable);
	else if (OutP->dtableType.msgtl_number > *dtableCnt) {
	    mig_allocate((vm_offset_t *)dtable,
		4 * OutP->dtableType.msgtl_number);
	    bcopy(*(char **)OutP->dtable, (char *)*dtable, 4 * OutP->dtableType.msgtl_number);
	}
	else {
	    bcopy((char *) OutP->dtable, (char *) *dtable, 4 * OutP->dtableType.msgtl_number);
	}

	*dtableCnt = OutP->dtableType.msgtl_number;

	OutP = (Reply *) ((char *) OutP + msgh_size_delta - 2048);

#if	TypeCheck
	if ((OutP->portarrayType.msgtl_header.msgt_longform != TRUE) ||
	    (OutP->portarrayType.msgtl_name != MACH_MSG_TYPE_PORT_SEND) ||
	    (OutP->portarrayType.msgtl_size != 32))
		return MIG_TYPE_ERROR;
#endif	TypeCheck

	msgh_size_delta = (OutP->portarrayType.msgtl_header.msgt_inline) ? 4 * OutP->portarrayType.msgtl_number : sizeof(mach_port_t *);
#if	TypeCheck
	if (msgh_size < 100 + msgh_size_delta)
		return MIG_TYPE_ERROR;
	msgh_size -= msgh_size_delta;
#endif	TypeCheck

	if (!OutP->portarrayType.msgtl_header.msgt_inline)
	    *portarray = *((mach_port_t **)OutP->portarray);
	else if (OutP->portarrayType.msgtl_number > *portarrayCnt) {
	    mig_allocate((vm_offset_t *)portarray,
		4 * OutP->portarrayType.msgtl_number);
	    bcopy(*(char **)OutP->portarray, (char *)*portarray, 4 * OutP->portarrayType.msgtl_number);
	}
	else {
	    bcopy((char *) OutP->portarray, (char *) *portarray, 4 * OutP->portarrayType.msgtl_number);
	}

	*portarrayCnt = OutP->portarrayType.msgtl_number;

	OutP = (Reply *) ((char *) OutP + msgh_size_delta - 2048);

#if	TypeCheck
	if ((OutP->intarrayType.msgtl_header.msgt_longform != TRUE) ||
	    (OutP->intarrayType.msgtl_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (OutP->intarrayType.msgtl_size != 32))
		return MIG_TYPE_ERROR;
#endif	TypeCheck

#if	TypeCheck
	if (msgh_size != 100 + ((OutP->intarrayType.msgtl_header.msgt_inline) ? 4 * OutP->intarrayType.msgtl_number : sizeof(int *)))
		return MIG_TYPE_ERROR;
#endif	TypeCheck

	if (!OutP->intarrayType.msgtl_header.msgt_inline)
	    *intarray = *((int **)OutP->intarray);
	else if (OutP->intarrayType.msgtl_number > *intarrayCnt) {
	    mig_allocate((vm_offset_t *)intarray,
		4 * OutP->intarrayType.msgtl_number);
	    bcopy(*(char **)OutP->intarray, (char *)*intarray, 4 * OutP->intarrayType.msgtl_number);
	}
	else {
	    bcopy((char *) OutP->intarray, (char *) *intarray, 4 * OutP->intarrayType.msgtl_number);
	}

	*intarrayCnt = OutP->intarrayType.msgtl_number;

	return KERN_SUCCESS;
}

/* Routine exec_boot_init */
mig_external kern_return_t exec_boot_init
#if	(defined(__STDC__) || defined(c_plusplus))
(
	mach_port_t execserver,
	startup_t init
)
#else
	(execserver, init)
	mach_port_t execserver;
	startup_t init;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t initType;
		startup_t init;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
	} Reply;

	union {
		Request In;
		Reply Out;
	} Mess;

	register Request *InP = &Mess.In;
	register Reply *OutP = &Mess.Out;

	mach_msg_return_t msg_result;

#if	UseStaticMsgType
	static mach_msg_type_t initType = {
		/* msgt_name = */		MACH_MSG_TYPE_COPY_SEND,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t RetCodeCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	InP->initType = initType;
#else	UseStaticMsgType
	InP->initType.msgt_name = MACH_MSG_TYPE_COPY_SEND;
	InP->initType.msgt_size = 32;
	InP->initType.msgt_number = 1;
	InP->initType.msgt_inline = TRUE;
	InP->initType.msgt_longform = FALSE;
	InP->initType.msgt_deallocate = FALSE;
	InP->initType.msgt_unused = 0;
#endif	UseStaticMsgType

	InP->init = init;

	InP->Head.msgh_bits = MACH_MSGH_BITS_COMPLEX|
		MACH_MSGH_BITS(MACH_MSG_TYPE_COPY_SEND, MACH_MSG_TYPE_MAKE_SEND_ONCE);
	/* msgh_size passed as argument */
	InP->Head.msgh_request_port = execserver;
	InP->Head.msgh_reply_port = mig_get_reply_port();
	InP->Head.msgh_seqno = 0;
	InP->Head.msgh_id = 30002;

	msg_result = mach_msg(&InP->Head, MACH_SEND_MSG|MACH_RCV_MSG|MACH_MSG_OPTION_NONE, sizeof(Request), sizeof(Reply), InP->Head.msgh_reply_port, MACH_MSG_TIMEOUT_NONE, MACH_PORT_NULL);
	if (msg_result != MACH_MSG_SUCCESS) {
		if ((msg_result == MACH_SEND_INVALID_REPLY) ||
		    (msg_result == MACH_RCV_INVALID_NAME))
			mig_dealloc_reply_port();
		return msg_result;
	}

	if (OutP->Head.msgh_id != 30102) {
		if (OutP->Head.msgh_id == MACH_NOTIFY_SEND_ONCE)
		return MIG_SERVER_DIED;
		else
		return MIG_REPLY_MISMATCH;
	}

#if	TypeCheck
	if ((OutP->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX) ||
	    (OutP->Head.msgh_size != 32))
		return MIG_TYPE_ERROR;
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &OutP->RetCodeType != * (int *) &RetCodeCheck)
#else	UseStaticMsgType
	if ((OutP->RetCodeType.msgt_inline != TRUE) ||
	    (OutP->RetCodeType.msgt_longform != FALSE) ||
	    (OutP->RetCodeType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (OutP->RetCodeType.msgt_number != 1) ||
	    (OutP->RetCodeType.msgt_size != 32))
#endif	UseStaticMsgType
		return MIG_TYPE_ERROR;
#endif	TypeCheck

	return OutP->RetCode;
}
