/* UFS server routines for fsys.defs interface
   Copyright (C) 1991, 1992 Free Software Foundation

This file is part of the GNU Hurd.

The GNU Hurd is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

The GNU Hurd is distributed in the hope that it will be useful, 
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with the GNU Hurd; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

/* Written by Michael I. Bushnell.  */

#include "ufs.h"
#include "fs.h"
#include "fsysdefs.h"
#include <errno.h>

error_t
fsys_startup (mach_port_t prot,
	      mach_port_t ctl,
	      mach_port_t *real,
	      mach_port_t *dotdot)
{
  return EOPNOTSUPP;
}
  
error_t
fsys_goaway (fsys_t controlport,
	     int flags)
{
  if (controlport == MACH_PORT_NULL)
    return EPERM;
  
  panic ("goaway");
}


error_t
fsys_getroot (fsys_t controlport,
	      int flags,
	      mach_port_t auth_realnode,
	      file_t *result)
{
  struct inode *ip;
  error_t error;

  if (controlport == MACH_PORT_NULL)
    return EPERM;

  mach_port_deallocate (mach_task_self (), auth_realnode);

  error = iget (ROOTINO, &ip);
  if (!error)
    {
      *result = convert_protid_to_port (make_protid (ip, 0, 0)); /* do perms */
      iput (ip);
    }

  return error;
}

error_t
fsys_getfile (fsys_t foo,
	      u_int *uids,
	      u_int nuids,
	      u_int *gids,
	      u_int ngids,
	      char *data,
	      u_int datalen,
	      file_t *file)
{
  return EOPNOTSUPP;
}

	      
	      
fsys_t
verify_fsys_port (fsys_t test)
{
  if (test == ufs_control_port)
    return test;
  else
    return MACH_PORT_NULL;
}

