DECLARE SUB simplot (NT&, PB&, TB&, TCOLOR%)
DECLARE SUB simout (NT&)
REM ON ERROR GOTO Handler

VIEWER$ = "L e:\TRC.TRC": 'File viewing program
DATAFILE$ = "TRC.DAT": 'Input file name
GRID = 1000: 'GRID in cycles

'Note: To set trace names, and traces to display, edit SUB simplot.


    LastStep = -1
    NextStep& = -1
    OldRB0 = 0
    OldRA2 = 0

    SCREEN 12

INPUT "Starting Cycle?", t1&
INPUT "Ending Cycle?  ", t2&
IF t2& = 0 THEN t2& = 1999999
INPUT "SCALE? ", scale
IF scale = 0 THEN scale = 1

AGAIN:
RESTART = 0
IF t1& < 0 THEN t1& = 0
CLOSE 3
OPEN DATAFILE$ FOR INPUT AS 3

    CLS

    simout t1&
    simout t2&
   
    IF RESTART THEN t1& = RESTART: GOTO AGAIN

    GOTO Terminate


Handler:
   IF ERR <> 62 THEN
        PRINT "Error"; ERR; "in Line"; ERL
        END
   END IF

Terminate:

        CLOSE 1
        CLOSE 2
        CLOSE 3
        INPUT "PRESS ENTER TO CONTINUE", a$
        SCREEN 0
        END

SUB simout (NT&) STATIC
SHARED RESTART

' Stimulus input parser
' expects input format of:
' nnnnnnn  nnn nnn nnn nnn nnn nnn
' Cycle    PA  PB  PC  TRISA TRISB TRISC
DEFLNG A-C
start:
  DOPLOT = 1

        WHILE NextStep& = 0
              B = -1: C = -1
              IF NOT EOF(3) THEN a$ = INPUT$(7, 3): NextStep& = VAL(a$)
              IF NextStep& = 0 THEN
                  IF NOT EOF(3) THEN LINE INPUT #3, a$: 'skip rest of line
              ELSE
                  INPUT #3, a2, b2, c2, at, bt, ct
              END IF
              DOPLOT = 0
              IF EOF(3) THEN NextStep& = -1
        WEND

        IF (NextStep& < 0) OR EOF(3) GOTO NOdata

        WHILE (NextStep& < NT&) AND (NextStep& > 0 AND (RESTART = 0)) AND NOT EOF(3)
           B = b2 + (256 * c2) + (65536 * a2): C = bt + (256 * ct) + (65536 * at)
           IF DOPLOT THEN simplot NextStep&, B, C, 15
           NextStep& = VAL(INPUT$(7, 3)): INPUT #3, a2, b2, c2, at, bt, ct
        WEND

        IF RESTART GOTO done

        IF (NextStep& = NT&) AND NOT EOF(3) THEN
           DO
             B = b2 + (256 * c2) + (65536 * a2): C = bt + (256 * ct) + (65536 * at)
             simplot NextStep&, B, C, 15
             NextStep& = VAL(INPUT$(7, 3)): INPUT #3, a2, b2, c2, at, bt, ct
             IF RESTART GOTO done
           LOOP WHILE NextStep& = NT&
           GOTO done
        END IF

NOdata:
       simplot NT&, B, C, 8

done:
        IF RESTART THEN NextStep& = 0

END SUB

DEFSNG A-C
SUB simplot (NT&, PB&, TB&, TCOLOR%) STATIC
SHARED scale, RESTART, GRID, VIEWER$
DIM saved&(1 TO 4096)
DIM n$(0 TO 24):  ' *** TRACE NAMES ***

RB0 = 1:        n$(0) = "RB0":  'BIT 0, PORT B
RB1 = 2:        n$(1) = "RB1":  'BIT 1, PORT B
RB2 = 4:        n$(2) = "RB2":  'BIT 2, PORT B
RB3 = 8:        n$(3) = "RB3":  'BIT 3, PORT B
RB4 = 16:       n$(4) = "RB4":  'BIT 4, PORT B
RB5 = 32:       n$(5) = "RB5":  'BIT 5, PORT B
RB6 = 64:       n$(6) = "RB6":  'BIT 6, PORT B
RB7 = 128:      n$(7) = "RB7":  'BIT 7, PORT B

RC0 = 256:      n$(8) = "":  'BIT 0, PORT C
RC1 = 512:      n$(9) = "":  'BIT 1, PORT C
RC2 = 1024:    n$(10) = "":  'BIT 2, PORT C
RC3 = 2048:    n$(11) = "":  'BIT 3, PORT C
RC4 = 4096:    n$(12) = "":  'BIT 4, PORT C
RC5 = 8192:    n$(13) = "":  'BIT 5, PORT C
RC6 = 16384:   n$(14) = "":  'BIT 6, PORT C
RC7 = 32768:   n$(15) = "":  'BIT 7, PORT C

RA0 = 65536:   n$(16) = "RA0":  'BIT 0, PORT A
RA1 = 131072:  n$(17) = "RA1":  'BIT 0, PORT A
RA2 = 262144:  n$(18) = "RA2":  'BIT 0, PORT A
RA3 = 524288:  n$(19) = "RA3":  'BIT 0, PORT A
RA4 = 1048576: n$(20) = "RA4":  'BIT 0, PORT A


'MAP of traces to display
TRACES = RA1 + RA2 + RA3 + RB0 + RB2 + RB4 + RB5 + RB6 + RB7

'MAP of traces which are DRIVEN inputs (ie. from stimulus)
INPUTS = 0

        RA2& = PB&:  'trace mode : RA2& = data, RB0& = tris
        RB0& = TB&:  'combined port b & c & a

        IF (oT > 0) THEN
               FOR X& = oT + 1 TO NT&
                 IF X& = NT& THEN
                    oT = NT&
                    oB& = RB0&
                    oA& = RA2&
                 ELSE
                    IF (NT& - 1) < mX& THEN X& = NT& - 1 ELSE IF X& < mX& THEN X& = mX&
                 END IF

                   x1& = (pX& - oX&) / scale + 64
                   pX& = X&
                   x2& = (X& - oX&) / scale + 64
                   IF (X& <= mX&) THEN

                     IF x1& < x2& THEN LINE (x1& + 1, 16)-(x2&, 478), 0, BF

                     TRCNUM = 0
                     FOR bit& = 0 TO 19: mask& = 2 ^ bit&
                       IF (TRACES AND mask&) = 0 THEN GOTO ebits
                       TRCNUM = TRCNUM + 1
                       y1& = 48 * TRCNUM
                       IF (LASTB& AND mask& AND NOT INPUTS) THEN y1& = y1& - 10:  ELSE IF (LAST& AND mask&) THEN y1& = y1& - 20
                       y2& = 48 * TRCNUM
                       IF (oB& AND mask& AND NOT INPUTS) THEN y2& = y2& - 10:  ELSE IF (oA& AND mask&) THEN y2& = y2& - 20
                       LINE (x1&, y1&)-(x2&, y1&), TCOLOR%: LINE (x2&, y1&)-(x2&, y2&)
ebits:
                     NEXT
                     IF X& = mX& THEN
                       FOR i = (-(oX& MOD GRID)) / scale + 64 TO (mX& - oX&) / scale + 64 STEP GRID / scale
                       IF (i > 64) AND (i < 639) THEN LINE (i, 16)-(i, 478), 9, , &H5555
                       NEXT
                       a$ = " "
                     END IF

                     x1& = x2&

                     LAST& = oA&: LASTB& = oB&
                     IF INKEY$ <> "" OR a$ = " " THEN
                       xx& = X&
loopx:
                       LOCATE 1, 1
                       PRINT xx&; "( GridRel = "; xx& MOD GRID; ")"; : IF VIEWER$ > "" THEN PRINT ": Press v to view listing";
                       PRINT "          "
                       GET (x2&, v)-(x2&, v + 16), saved&
                       LINE (x2&, v)-(x2&, v + 16), 10
                      
                       i = TIMER + .2
LOOP1:
                       a$ = INKEY$: IF a$ = "" GOTO LOOP1
                       IF TIMER > i THEN accel = 0:  ELSE accel = accel + .2

                       IF a$ = "v" THEN SCREEN 0: SHELL VIEWER$: SCREEN 12
                       PUT (x2&, v), saved&, PSET

                       'Left key

                       IF (a$) = CHR$(0) + CHR$(75) THEN
                        FOR i = 0 TO accel
                         IF (xx& >= oX& + scale) THEN
                           xx& = xx& - INT(scale + .999)
                           x2& = (xx& - oX&) / scale + 64
                         END IF
                        NEXT
                         GOTO loopx
                       END IF
                
                       'Right KEY

                       IF (a$) = CHR$(0) + CHR$(77) THEN
                        FOR i = 0 TO accel
                         IF ((xx& + scale) <= X&) THEN
                           xx& = xx& + INT(scale + .999)
                           x2& = (xx& - oX&) / scale + 64
                         END IF
                        NEXT
                         GOTO loopx
                       END IF

                       'UP key

                       IF (a$ = CHR$(0) + CHR$(72)) THEN
                        FOR i = 0 TO accel
                         IF v >= 25 THEN v = v - 25
                        NEXT
                         GOTO loopx
                       END IF

                       'DOWN key

                       IF (a$ = CHR$(0) + CHR$(80)) THEN
                        FOR i = 0 TO accel
                         IF v <= 400 THEN v = v + 25
                        NEXT
                        GOTO loopx
                       END IF

                       'z - zoom in

                       IF (a$ = "z") THEN
                         a$ = ""
                         oT = 0
                         scale = scale / 2
                         IF xx& = X& THEN xx& = oX&
                         RESTART = xx&
                         oT = 0
                         GOTO Pdone
                       END IF

                       'Z - zoom out
     
                       IF (a$ = "Z") THEN
                         a$ = ""
                         oT = 0
                         IF xx& = X& THEN xx& = oX&
                         scale = scale * 2
                         RESTART = xx&
                         GOTO Pdone
                       END IF

                       'CR - move to current cursor position

                       IF (a$ = CHR$(13)) THEN
                         a$ = ""
                         oT = 0
                         RESTART = xx&
                         GOTO Pdone
                       END IF

                       'PAGE UP - 1 screen back

                       IF (a$) = CHR$(0) + CHR$(73) THEN
                         a$ = ""
                         oT = 0
                         xx& = oX& - ((637 - 64) * scale)
                         IF xx& <= 0 THEN xx& = -1
                         RESTART = xx&
                         oT = 0
                         GOTO Pdone
                       END IF
                     END IF
                   ELSE
                       oX& = X&
                       mX& = oX& + ((637 - 64) * scale)
                       LAST& = oA&: LASTB& = oB&
                       'LINE (64, 0)-(66 + (1 / scale), 478), 0, BF
                       TRCNUM = 0
                       FOR bit& = 0 TO 19: mask& = 2 ^ bit&
                         IF (TRACES AND mask&) = 0 THEN GOTO exy
                         TRCNUM = TRCNUM + 1
                         LOCATE TRCNUM * 3, 1
                         PRINT n$(bit&)
exy:
                       NEXT
                   END IF
               NEXT
        ELSE
               oT = NT&
               oB& = RB0&
               oA& = RA2&
               oX& = NT&
               pX& = oX&
               mX& = oX& + ((637 - 64) * scale)
               LAST& = oA&: LASTB& = oB&
               x1& = 0: x2& = 0: y2& = 0: y1& = 0
               TRCNUM = 0
               FOR bit& = 0 TO 19: mask& = 2 ^ bit&
                 IF (TRACES AND mask&) = 0 THEN GOTO exx
                 TRCNUM = TRCNUM + 1
                 LOCATE TRCNUM * 3, 1
                 PRINT n$(bit&)
exx:
               NEXT
        END IF
Pdone:
END SUB

