/*
** FILE: m6811-local.h
** RSC:  $Revision: 1.7 $ $Date: 93/02/23 21:28:53 $
*/

/* Definitions of target machine for GNU compiler. Motorola HC6811C version.
   Copyright (C) 1987, 1993 Free Software Foundation, Inc.
   Contributed by Otto Lind (otto@coactive.com)
   Based on original 6809 port by Tom Jones (jones@sal.wisc.edu)

This file is part of GNU CC.

GNU CC is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 1, or (at your option)
any later version.

GNU CC is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU CC; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

/*****************************************************************************
**
** Controlling the Compilation Driver, `gcc'
**
*****************************************************************************/

#define CC1_SPEC		""

/*****************************************************************************
**
** Run-time Target Specification
**
*****************************************************************************/

/* Names to predefine in the preprocessor for this target machine.  */
#define CPP_PREDEFINES		"-Dmc6811 -DMC6811"

/* Run-time compilation parameters selecting different hardware subsets.  */
extern int target_flags;
extern short *reg_renumber;	/* def in local_alloc.c */

/* Macros used in the machine description to test the flags.  */

/* 
   -margcount	use standard calling sequence, with arg count word
   -mnoargcount don't push arg count (it's in the symbol table)
   -mshort_int	use short integers for type "int"
   -mlong_int	use long integers for type "int"
   -mshort_branch	use short branch instructions
*/

#define TARGET_ARGCOUNT		(target_flags & 4)

/* Compile with 16-bit `int'.  */
#define TARGET_SHORT_INT	(target_flags & 8)

/* Compile with short (+-255) branch instructions */
#define TARGET_SHORT_BRANCH	(target_flags & 1)

/* Default target_flags if no switches specified.  */
#ifndef TARGET_DEFAULT
#define TARGET_DEFAULT		8
#endif

/* 
** Macro to define tables used to set the flags. This is a list in braces of
** pairs in braces, each pair being { "NAME", VALUE } where VALUE is the bits
** to set or minus the bits to clear. An empty string NAME is used to
** identify the default VALUE.
*/

#define TARGET_SWITCHES \
  { { "short_branch", 1 }, \
    { "long_branch", -1 }, \
    { "c2", 2 }, \
    { "noc2", -2 }, \
    { "argcount", 4 }, \
    { "noargcount", -4 }, \
    { "short_int", 8}, \
    { "long_int", -8}, \
    { "", TARGET_DEFAULT }}

/* Print subsidiary information on the compiler version in use.  */
#define TARGET_VERSION		fprintf (stderr, " (MC6811)");

/* Pick a target if none was specified */
#define OVERRIDE_OPTIONS	override_options ();

/*****************************************************************************
**
** Target machine Storage Layout
**
*****************************************************************************/

/* Define this if most significant byte of a word is the lowest numbered.  */
#define BYTES_BIG_ENDIAN 	1

/* Define this if most significant word of a multiword number is numbered.  */
#define WORDS_BIG_ENDIAN 	0

/* Number of bits in an addressible storage unit */
#define BITS_PER_UNIT		8

/* Number of bits in a word */
#define BITS_PER_WORD		16

/* Width of a word, in units (bytes).  */
#define UNITS_PER_WORD		(BITS_PER_WORD/8)

/* Width in bits of a pointer. See also the macro `Pmode' defined below. */
#define POINTER_SIZE		16

/* Allocation boundary (bits) for storing pointers in memory.  */
#define POINTER_BOUNDARY	8

/* Normal alignment required for function parameters on the stack, in bits */
#define PARM_BOUNDARY		8

/* Boundary (bits) on which stack pointer should be aligned.  */
#define STACK_BOUNDARY		8

/* Allocation boundary (bits) for the code of a function.  */
#define FUNCTION_BOUNDARY	8

/* Biggest alignment that any data type can require on this machine, in bits. */
#define BIGGEST_ALIGNMENT	8

/* Alignment of field after `int : 0' in a structure.  */
#define EMPTY_FIELD_BOUNDARY	8

/* Every structure's size must be a multiple of this.  */
#define STRUCTURE_SIZE_BOUNDARY 8

/*
** Define this if instructions will fail to work if given data not
** on the nominal alignment.  If instructions will merely go slower
** in that case, do not define this macro.
*/
#define STRICT_ALIGNMENT	0

/* largest mode to use -- try 16 -- tej */
#define MAX_FIXED_MODE_SIZE	16

/* Check a `double' value for validity for a particular machine mode.  */
#define CHECK_FLOAT_VALUE(mode, d) \
  if ((mode) == SFmode) \
    { \
      if ((d) > 1.7014117331926443e+38) \
	{ error ("magnitude of constant too large for `float'"); \
	  (d) = 1.7014117331926443e+38; } \
      else if ((d) < -1.7014117331926443e+38) \
	{ error ("magnitude of constant too large for `float'"); \
	  (d) = -1.7014117331926443e+38; } \
      else if (((d) > 0) && ((d) < 2.9387358770557188e-39)) \
	{ warning ("`float' constant truncated to zero"); \
	  (d) = 0.0; } \
      else if (((d) < 0) && ((d) > -2.9387358770557188e-39)) \
	{ warning ("`float' constant truncated to zero"); \
	  (d) = 0.0; } \
    }

/*****************************************************************************
**
** Layout of Source Language Data Types
**
*****************************************************************************/

/* Size (bits) of the type "int" on target machine */
/*   (If undefined, default is BITS_PER_WORD).  */
#define INT_TYPE_SIZE		16

/* Size (bits) of the type "short" on target machine */
#define SHORT_TYPE_SIZE		16

/* Size (bits) of the type "long" on target machine */
#define LONG_TYPE_SIZE		16

/* Size (bits) of the type "char" on target machine */
#define CHAR_TYPE_SIZE		8

/* Define this as 1 if `char' should by default be signed; else as 0.  */
#define DEFAULT_SIGNED_CHAR	1

/* Define results of standard character escape sequences.  */
#define TARGET_BELL		007
#define TARGET_BS		010
#define TARGET_TAB		011
#define TARGET_NEWLINE		012
#define TARGET_VT		013
#define TARGET_FF		014
#define TARGET_CR		015

/*****************************************************************************
**
** Register Usage
**
*****************************************************************************/

/* assign names to real MC6811 registers */
#define HARD_D_REGNUM		0
#define HARD_X_REGNUM		1
#define HARD_Y_REGNUM		2
#define HARD_SP_REGNUM		3
#define HARD_PC_REGNUM		4
#define HARD_A_REGNUM		5
#define HARD_B_REGNUM		6
#define HARD_CCR_REGNUM		7

/*
** define 12 pseudo hard registers which access locations in memory
*/
#define HARD_ZD_REGNUM		8
#define HARD_ZX_REGNUM		12
#define HARD_ZB_REGNUM		16

/*
** Number of actual hardware registers. The hardware registers are assigned
** numbers for the compiler from 0 to just below FIRST_PSEUDO_REGISTER. 
** All registers that the compiler knows about must be given numbers, even
** those that are not normally considered general registers. 
*/
#define FIRST_PSEUDO_REGISTER	20

/*
** 1 for registers that have pervasive standard uses and are not available
** for the register allocator. 
*/
#define FIXED_REGISTERS \
    {1, 1, 1, 1, 1, 1, 1, 1,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }
  /* D, X, Y, SP,PC,A, B, CCR, Z1 - Z12 */

/*
** 1 for registers not available across function calls. For our pseudo
** registers, none are available.
*/
#define CALL_USED_REGISTERS \
    {1, 1, 1, 1, 1, 1, 1, 1,   1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 }
  /* D, X, Y, SP,PC,A, B, CCR, Z1 - Z12 */

/* use pseudo regs for MC6811 */
#define REG_ALLOC_ORDER \
    {12,13,14,15,16,17,18,19,  0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11}
  /* D, X, Y, SP,PC,A, B, CCR, Z1 - Z12 */

/*
** A C expression for the number of consecutive hard registers,
** starting at register number REGNO, required to hold a value of
** mode MODE.
*/
#define HARD_REGNO_NREGS(REGNO, MODE) \
    (((REGNO) == HARD_A_REGNUM || (REGNO) == HARD_B_REGNUM) \
    	? (GET_MODE_SIZE (MODE)) \
	: ((GET_MODE_SIZE (MODE) + UNITS_PER_WORD - 1) / UNITS_PER_WORD))

/* Value is 1 if hard register REGNO can hold a value of machine-mode MODE. */
#if 0
#define HARD_REGNO_MODE_OK(REGNO, MODE) \
    (((G_REGNO_P (REGNO)) && (GET_MODE_SIZE (MODE) == 2)) \
  || ((A_REGNO_P (REGNO)) && (GET_MODE_SIZE (MODE) == 2)) \
  || ((D_REGNO_P (REGNO)) && (GET_MODE_SIZE (MODE) == 2)) \
  || ((Q_REGNO_P (REGNO)) && (GET_MODE_SIZE (MODE) == 1)) \
  || (MODE == VOIDmode))
#endif
#define HARD_REGNO_MODE_OK(REGNO, MODE) \
    ((G_REGNO_P (REGNO)) \
  || ((Q_REGNO_P (REGNO)) && (GET_MODE_SIZE (MODE) == 1)) \
  || (MODE == VOIDmode))


/*
** Value is 1 if it is a good idea to tie two pseudo registers when one has
** mode MODE1 and one has mode MODE2.  If HARD_REGNO_MODE_OK could produce
** different values for MODE1 and MODE2, for any hard reg, then this must be
** 0 for correct output.
*/
#define MODES_TIEABLE_P(MODE1, MODE2)	0

/*****************************************************************************
**
** Register Classes
**
*****************************************************************************/

/* Define 3 classes A (address) and D (data), and Q (byte). */
enum reg_class {
    NO_REGS,
    D_REGS,		/* 16-bit (word (SI)) data */
    Q_REGS,		/* 8-bit (byte (HI)) data */
    A_REGS,		/* 16-bit addresses */
    G_REGS,		/* 16-bit data and address */
    ALL_REGS,
    LIM_REG_CLASSES
};

/* alias GENERAL_REGS to G_REGS. */
#define GENERAL_REGS	G_REGS

#define N_REG_CLASSES	(int) LIM_REG_CLASSES

/* Give names of register classes as strings for dump file.   */
#define REG_CLASS_NAMES \
 {"NO_REGS", "D_REGS", "Q_REGS", "A_REGS", "G_REGS", "ALL_REGS" }

/*
** An initializer containing the contents of the register classes,
** as integers which are bit masks.  The Nth integer specifies the
** contents of class N.  The way the integer MASK is interpreted is
** that register R is in the class if `MASK & (1 << R)' is 1.
*/
/*
** D	0x0000001
** X	0x0000002
** Y	0x0000004
** SP	0x0000008
** PC	0x0000010
** A	0x0000020
** B	0x0000040
** CCR	0x0000080
** ZD   0x0000f00
** ZX   0x000f000
** ZB   0x00f0000
*/
#define REG_CLASS_CONTENTS {0x00000000, 0x00000f01, 0x000f0060, \
			    0x0000f01e, 0x000fff6f, 0x000fffff}

/*
** set up a C expression whose value is a register class containing hard
** register REGNO
*/
#define D_REGNO_P(REGNO)	((REGNO) == HARD_D_REGNUM || \
				 ((REGNO) >= HARD_ZD_REGNUM && \
				  (REGNO) < HARD_ZX_REGNUM))
#define Q_REGNO_P(REGNO)	((REGNO) == HARD_A_REGNUM || \
				 (REGNO) == HARD_B_REGNUM || \
				 ((REGNO) >= HARD_ZB_REGNUM && \
				  (REGNO) < FIRST_PSEUDO_REGISTER))
#define A_REGNO_P(REGNO)	(((REGNO) >= HARD_X_REGNUM &&\
    				  (REGNO) <= HARD_PC_REGNUM) || \
				  ((REGNO) >= HARD_ZX_REGNUM && \
				   (REGNO) < HARD_ZB_REGNUM))
#define G_REGNO_P(REGNO) 	(D_REGNO_P(REGNO) || A_REGNO_P(REGNO))

#define D_REG_P(X)		(REG_P (X) && D_REGNO_P (REGNO (X)))
#define A_REG_P(X)		(REG_P (X) && A_REGNO_P (REGNO (X)))
#define Q_REG_P(X)		(REG_P (X) && Q_REGNO_P (REGNO (X)))
#define G_REG_P(X)		(D_REG_P(X) || A_REG_P(X))

#define REGNO_REG_CLASS(REGNO) \
  (D_REGNO_P (REGNO) ? D_REGS : \
  (Q_REGNO_P (REGNO) ? Q_REGS : \
  (A_REGNO_P (REGNO) ? A_REGS : ALL_REGS)))


/* The class value for index registers, and the one for base regs.  */
#define BASE_REG_CLASS		A_REGS
#define INDEX_REG_CLASS		D_REGS

/* Get reg_class from a letter in the machine description.  */
/* 'a' -- Address (SI) class */
/* 'd' -- Data (SI) class */
/* 'q' -- Data class for byte mode */

#define REG_CLASS_FROM_LETTER(C) \
  (((C) == 'a' ? A_REGS : \
   ((C) == 'd' ? D_REGS : \
   ((C) == 'q' ? Q_REGS : NO_REGS))))

/*
** These assume that REGNO is a hard or pseudo reg number. They give nonzero
** only if REGNO is a hard reg of the suitable class or a pseudo reg currently
** allocated to a suitable hard reg.  Since they use reg_renumber, they are
** safe only once reg_renumber has been allocated, which happens in
** local-alloc.c.
*/

#define REGNO_OK_FOR_BASE_P(REGNO) \
    (A_REGNO_P (REGNO) || \
    	(((unsigned) reg_renumber[REGNO]) \
	&& A_REGNO_P ((unsigned) reg_renumber[REGNO])))

#define REGNO_OK_FOR_INDEX_P(REGNO) \
    (D_REGNO_P (REGNO) \
	|| (((unsigned) reg_renumber[REGNO]) \
	&& D_REGNO_P ((unsigned) reg_renumber[REGNO])))

/*
** On the 6811, use the data reg if possible when the value is a constant in
** the range where ldb could be used and we ensure that HImodes are reloaded
** into data regs. 
*/

#if 0
#define PREFERRED_RELOAD_CLASS(X,CLASS)  \
  ((GET_CODE (X) == CONST_INT			\
    && (unsigned) (INTVAL (X) + 0x80) < 0x100	\
    && (CLASS) != A_REGS)			\
   ? Q_REGS					\
   : GET_MODE (X) == HImode			\
   ? Q_REGS					\
   : (CLASS))
#endif

#define PREFERRED_RELOAD_CLASS(X,CLASS)		CLASS

/* LIMIT_RELOAD_CLASS (MODE, CLASS) */

/* SECONDARY_RELOAD_CLASS (CLASS, MODE, X) */
/* SECONDARY_INPUT_RELOAD_CLASS (CLASS, MODE, X) */
/* SECONDARY_OUTPUT_RELOAD_CLASS (CLASS, MODE, X) */

/* This is definitely true */
#define SMALL_REGISTER_CLASSES


/*
** Return the maximum number of consecutive registers needed to represent
** mode MODE in a register of class CLASS. 
*/
/*
#define CLASS_MAX_NREGS(CLASS, MODE) \
    ((GET_MODE_SIZE (MODE) + UNITS_PER_WORD - 1) / UNITS_PER_WORD)
*/
#define CLASS_MAX_NREGS(CLASS, MODE)		1

/*--------------------------------------------------------------
   The letters I, J, K, L and M in a register constraint string
   can be used to stand for particular ranges of immediate operands.
   This macro defines what the ranges are.
   C is the letter, and VALUE is a constant value.
   Return 1 if VALUE is in the range specified by C.

   For the 6811, J, K, L are used for indexed addressing.
   `I' is used for shift counts which can only be equal to 1.
   `J' is used for the 5-bit offsets.
   `K' is used for the 8-bit offsets.
   `L' is used for the range of signed numbers that fit in 16 bits.
--------------------------------------------------------------*/

#define CONST_OK_FOR_LETTER_P(VALUE, C)  \
  ((C) == 'I' ? ((unsigned)(VALUE) == 1) :    \
   (C) == 'J' ? ((unsigned)(VALUE) <= 31) :    \
   (C) == 'K' ? ((unsigned)(VALUE) <= 255) :    \
   (C) == 'L' ? ((unsigned)(VALUE) <= 0xffff) : 0)

/*
** Similar, but for floating constants, and defining letters G and H.
** No floating-point constants are valid on MC6811. 
*/
#define CONST_DOUBLE_OK_FOR_LETTER_P(VALUE, C)  0

/*****************************************************************************
**
** Describing Stack Layout and Calling Conventions
**
*****************************************************************************/

/*
** Define this if pushing a word on the stack makes the stack pointer
** a smaller address.
*/
#define STACK_GROWS_DOWNWARD

/*
** Define this if the nominal address of the stack frame is at the
** high-address end of the local variables; that is, each additional
** local variable allocated goes at a more negative offset in the frame.
**
** #define FRAME_GROWS_DOWNWARD
*/

/*
** Define this if successive arguments to a function occupy decreasing 
** addresses in the stack.
**
** #define ARGS_GROW_DOWNWARD
*/

/*
** Offset within stack frame to start allocating local variables at.
** If FRAME_GROWS_DOWNWARD, this is the offset to the END of the
** first local allocated.  Otherwise, it is the offset to the BEGINNING
** of the first local allocated.
 */
#define STARTING_FRAME_OFFSET		2
/* #define STARTING_FRAME_OFFSET		current_function_args_size */

/* Offset of first parameter from the argument pointer register value.  */
#define FIRST_PARM_OFFSET(FNDECL)	(get_frame_size () + 4)

/*
** Define this if functions should assume that stack space has been
** allocated for arguments even when their values are passed in
** registers.
**
** The value of this macro is the size, in bytes, of the area reserved for
** arguments passed in registers.
**
** This space can either be allocated by the caller or be a part of the
** machine-dependent stack frame: `OUTGOING_REG_PARM_STACK_SPACE'
** says which.
**
** #define REG_PARM_STACK_SPACE(FNDECL)	2
*/

/*
** Define this macro if REG_PARM_STACK_SPACE is defined but stack
** parameters don't skip the area specified by REG_PARM_STACK_SPACE.
** Normally, when a parameter is not passed in registers, it is placed on
** the stack beyond the REG_PARM_STACK_SPACE area.  Defining this macro  
** suppresses this behavior and causes the parameter to be passed on the
** stack in its natural location. 
**
** #define STACK_PARMS_IN_REG_PARM_AREA
*/

/*****************************************************************************
**
** Describing Stack Layout and Calling Conventions
**
*****************************************************************************/

/* Register to use for pushing function arguments.  */
#define STACK_POINTER_REGNUM	HARD_SP_REGNUM

/* Base register for access to local variables of the function.  */
#define FRAME_POINTER_REGNUM	HARD_Y_REGNUM

/* Base register for access to arguments of the function.  */
#define ARG_POINTER_REGNUM	FRAME_POINTER_REGNUM

/* Register in which static-chain is passed to a function.  */
#define STATIC_CHAIN_REGNUM	HARD_D_REGNUM

/*****************************************************************************
**
** Eliminating Frame Pointer and Arg Pointer
**
*****************************************************************************/

/*
** Value should be nonzero if functions must have frame pointers.
** Zero means the frame pointer need not be set up (and parms may be
** accessed via the stack pointer) in functions that seem suitable.
** This is computed in `reload', in reload1.c.
*/
#define FRAME_POINTER_REQUIRED	1

/*
** Store in the variable DEPTH the initial difference between the 
** frame pointer reg contents and the stack pointer reg contents,
** as of the start of the function body.  This depends on the layout
** of the fixed parts of the stack frame and on how registers are saved.
*/
#define INITIAL_FRAME_POINTER_OFFSET(DEPTH)                     \
		{ (DEPTH) = get_frame_size (); }

/* LONGJMP_RESTORE_FROM_STACK */

/*****************************************************************************
**
** Passing Function Arguments on the Stack
**
*****************************************************************************/

/* When a prototype says `char' or `short', really pass an `int'.  */
/* #define PROMOTE_PROTOTYPES */

/*
** If we generate an insn to push BYTES bytes, this says how many the
** stack pointer really advances by. No rounding or alignment needed
** for MC6811
*/
#define PUSH_ROUNDING(BYTES)	(BYTES)

/*
** Value is 1 if returning from a function call automatically pops the
** arguments described by the number-of-args field in the call. FUNTYPE is
** the data type of the function (as a tree), or for a library call it is
** an identifier node for the subroutine name.
**
** The standard MC6811 call, with arg count word, includes popping the
** args as part of the call template.  We optionally omit the arg count
** word and let gcc combine the arg pops.
*/
#define RETURN_POPS_ARGS(FUNTYPE,SIZE)	TARGET_ARGCOUNT

/*****************************************************************************
**
** Passing Arguments in Registers
**
*****************************************************************************/

/*
** First word is passed using the D register
*/
#define FUNCTION_ARG(CUM, MODE, TYPE, NAMED) \
	(((CUM) == 0) ? gen_rtx(REG, MODE, HARD_D_REGNUM) : 0)

/*
** A C type for declaring a variable that is used as the first
** argument of `FUNCTION_ARG' and other related values.  For some
** target machines, the type `int' suffices and can hold the number
** of bytes of argument so far.
*/
#define CUMULATIVE_ARGS		int

/*
** Initialize a variable CUM of type CUMULATIVE_ARGS for a call to a
** function whose data type is FNTYPE. For a library call, FNTYPE is 0.
*/
#define INIT_CUMULATIVE_ARGS(CUM,FNTYPE,LIBNAME) \
	((CUM) = 0)

/*
** Update the data in CUM to advance over an argument of mode MODE and data
** type TYPE. (TYPE is null for libcalls where that information may not be
** available.)
*/
#define FUNCTION_ARG_ADVANCE(CUM, MODE, TYPE, NAMED) \
	((CUM) += ((MODE) != BLKmode \
	    ? (GET_MODE_SIZE (MODE)) \
	    : (int_size_in_bytes (TYPE))))

/* 1 if N is a possible register number for function argument passing. */
#define FUNCTION_ARG_REGNO_P(N)	((N) == HARD_D_REGNUM)

/*****************************************************************************
**
** How Scalar Function Values Are Returned
**
*****************************************************************************/

/* All return values are in the D-register */
#define FUNCTION_VALUE(VALTYPE, FUNC) \
	gen_rtx (REG, TYPE_MODE (VALTYPE), HARD_D_REGNUM)

/* All return values are in the D-register */
#define LIBCALL_VALUE(MODE)	gen_rtx (REG, MODE, HARD_D_REGNUM)

/* 1 if N is a possible register number for a function value. */
#define FUNCTION_VALUE_REGNO_P(N) ((N) == HARD_D_REGNUM)

/*****************************************************************************
**
** How Large Values Are Returnd
**
*****************************************************************************/

/*
** Register in which address to store a structure value is passed to a
** function.
*/
#define STRUCT_VALUE_REGNUM	HARD_D_REGNUM

/*
** NOTE: May want STRUCT_VALUE
*/

/*****************************************************************************
**
** Caller-Saves Register Allocation
**
*****************************************************************************/

/*****************************************************************************
**
** Function Entry and Exit
**
*****************************************************************************/


/* Function Prologue Definition */
#define FUNCTION_PROLOGUE(FILE, SIZE) \
{ \
  int i; \
  fprintf (FILE, ";;;-----------------------------------------\n"); \
  fprintf (FILE, ";;;  PROLOGUE for %s\n", current_function_name); \
  fprintf (FILE, ";;;-----------------------------------------\n"); \
  if ((SIZE) > 8) { \
        fprintf (FILE, "\tTSX\t; allocate %d bytes auto variables\n", (SIZE)); \
        fprintf (FILE, "\tXGDX\n\tSUBD\t#%d\n", (SIZE)); \
        fprintf (FILE, "\tXGDX\n\tTXS\n"); \
  } else { \
      for (i = 0; i < (SIZE)/2; i++) \
        fprintf (FILE, "\tPSHX\t; allocate 2 byte auto variable\n"); \
      if ((SIZE) % 2) \
        fprintf (FILE, "\tDES\t; allocate 1 byte auto variable\n"); \
  } \
  fprintf (FILE, "\tPSHY\t; Save stack frame\n"); \
  fprintf (FILE, "\tTSY\t; Set current stack frame\n"); \
  fprintf (FILE, ";;;END PROLOGUE\n"); \
}

/*
** EXIT_IGNORE_STACK should be nonzero if, when returning from a function,
** the stack pointer does not matter.  The value is tested only in functions
** that have frame pointers. No definition is equivalent to always zero.
*/
#define EXIT_IGNORE_STACK	0

/* Function Epilogue Definition */
#define FUNCTION_EPILOGUE(FILE, SIZE) \
{ \
  int i; \
  fprintf (FILE, ";;;EPILOGUE\n"); \
  fprintf (FILE, "\tPULY\t; Restore stack frame\n"); \
  if ((SIZE) > 8) { \
        fprintf (FILE, "\tTSX\t; deallocate %d bytes auto variables\n", (SIZE)); \
        fprintf (FILE, "\tXGDX\n\tADDD\t#%d\n", (SIZE)); \
        fprintf (FILE, "\tXGDX\n\tTXS\n"); \
  } else { \
      for (i = 0; i < (SIZE)/2; i++) \
        fprintf (FILE, "\tPULX\t; deallocate 2 byte auto variable\n"); \
      if ((SIZE) % 2) \
        fprintf (FILE, "\tINS\t; deallocate 1 byte auto variable\n"); \
  } \
  fprintf (FILE, "\tRTS\t; return from function\n"); \
  fprintf (FILE, ";;;-----------------------------------------\n"); \
  fprintf (FILE, ";;; END EPILOGUE for %s\n", current_function_name); \
  fprintf (FILE, ";;;-----------------------------------------\n"); \
}

/*****************************************************************************
**
** Generating Code for Profiling
**
*****************************************************************************/

/*
** Output assembler code to FILE to increment profiler label # LABELNO
** for profiling a function entry.
*/
#define FUNCTION_PROFILER(FILE, LABELNO) \
	fprintf (FILE, "\tleax LP%d,a1\n\tjsr mcount\n", (LABELNO));

/*****************************************************************************
**
** Implementing the Varargs Macros
**
*****************************************************************************/

/*****************************************************************************
**
** Trampolines for Nested Functions
**
*****************************************************************************/

/*
** Output assembler code for a block containing the constant parts
** of a trampoline, leaving space for the variable parts.
*/

#define TRAMPOLINE_TEMPLATE(FILE) { \
    fprintf (FILE, "\t.bogus\t\t; TRAMPOLINE_TEMPLATE unimplemented\n"); }

/* Length in units of the trampoline for entering a nested function.  */
#define TRAMPOLINE_SIZE		0

/*
** A C statement to initialize the variable parts of a trampoline.
** ADDR is an RTX for the address of the trampoline; FNADDR is an
** RTX for the address of the nested function; STATIC_CHAIN is an
** RTX for the static chain value that should be passed to the
** function when it is called.
*/
#define INITIALIZE_TRAMPOLINE(TRAMP, FNADDR, CXT) { \
	}

/*****************************************************************************
**
** Implicit Calls to Library Routines
**
*****************************************************************************/

/*****************************************************************************
**
** Addressing Modes
**
*****************************************************************************/

/* HAVE_POST_INCREMENT */
/* HAVE_PRE_INCREMENT */
/* HAVE_POST_DECREMENT */
/* HAVE_PRE_DECREMENT */

/* 1 if X is an rtx for a constant that is a valid address.  */
#define CONSTANT_ADDRESS_P(X)	(CONSTANT_P (X))

/* Maximum number of registers that can appear in a valid memory address */
#define MAX_REGS_PER_ADDRESS	1

/*
** GO_IF_LEGITIMATE_ADDRESS recognizes an RTL expression that is a
** valid memory address for an instruction. The MODE argument is the
** machine mode for the MEM expression that wants to use this address.
*/

/*--------------------------------------------------------------
   Valid addresses are either direct or indirect (MEM) versions
   of the following forms:
	constant		N
	register		,X
	indexed			N,X
--------------------------------------------------------------*/

#define REGISTER_ADDRESS_P(X) \
  (GET_CODE (X) == REG && REG_OK_FOR_BASE_P (X))

/* 
** Tried using this to limit the range of index values, but it never worked
** (just aborted in that evil reload pass). Hacked output_swap_regx()
** to try and fix up any illegal offsets. Should probably use
** LEGITIMIZE_ADDRESS() to do the correct thing.
*/
#define VALID_OFFSET_P(X) \
  (GET_CODE (X) != CONST_INT || INTVAL (X) < 256)

#define INDEXED_ADDRESS_P(X) \
   ((GET_CODE (X) == PLUS \
       && CONSTANT_ADDRESS_P (XEXP (X, 0)) \
       && REGISTER_ADDRESS_P (XEXP (X, 1))) \
   || (GET_CODE (X) == PLUS \
       && CONSTANT_ADDRESS_P (XEXP (X, 1)) \
       && REGISTER_ADDRESS_P (XEXP (X, 0))))

/* 
** This is included to allow stack push/pop operations. Special hacks in the
** md and m6811-local.c files exist to support this.
*/
#define PUSH_POP_ADDRESS_P(X) \
	(((GET_CODE (X) == PRE_DEC) || (GET_CODE (X) == POST_INC)) \
	&& REGISTER_ADDRESS_P(XEXP (X, 0)))

/* Go to ADDR if X is a valid address. */
#define GO_IF_LEGITIMATE_ADDRESS(MODE, X, ADDR) \
{ \
  if (CONSTANT_ADDRESS_P(X)) goto ADDR; \
  if (REGISTER_ADDRESS_P(X)) goto ADDR; \
  if (INDEXED_ADDRESS_P(X)) goto ADDR; \
  if (PUSH_POP_ADDRESS_P(X)) goto ADDR; \
}

/*
** The macros REG_OK_FOR..._P assume that the arg is a REG rtx and check its
** validity for a certain class.  We have two alternate definitions for each
** of them.  The usual definition accepts all pseudo regs; the other rejects
** them unless they have been allocated suitable hard regs.  The symbol
** REG_OK_STRICT causes the latter definition to be used.
**
** Most source files want to accept pseudo regs in the hope that they will
** get allocated to the class that the insn wants them to be in. Source files
** for reload pass need to be strict. After reload, it makes no difference,
** since pseudo regs have been eliminated by then.
*/

#ifndef REG_OK_STRICT

/*
** Nonzero if X is a hard reg that can be used as a base reg or if it
** is a pseudo reg.
*/
#define REG_OK_FOR_BASE_P(X) \
    ((REGNO(X) >= FIRST_PSEUDO_REGISTER) \
    || A_REGNO_P (REGNO (X)))

/*
** Nonzero if X is a hard reg that can be used as an index or if it is
** a pseudo reg.
*/
#define REG_OK_FOR_INDEX_P(X) \
    ((REGNO(X) >= FIRST_PSEUDO_REGISTER) \
    || D_REGNO_P (REGNO (X)))

#else

/* Nonzero if X is a hard reg that can be used as a base reg.  */
#define REG_OK_FOR_BASE_P(X) (REGNO_OK_FOR_BASE_P (REGNO (X)))

/* Nonzero if X is a hard reg that can be used as an index.  */
#define REG_OK_FOR_INDEX_P(X) (REGNO_OK_FOR_INDEX_P (REGNO (X)))

#endif /* REG_OK_STRICT */

/*
** Try machine-dependent ways of modifying an illegitimate address
** to be legitimate.  If we find one, return the new, valid address.
** This macro is used in only one place: `memory_address' in explow.c.
**
** OLDX is the address as it was before break_out_memory_refs was called.
** In some cases it is useful to look at this to decide what needs to be done.
**
** MODE and WIN are passed so that this macro can use
** GO_IF_LEGITIMATE_ADDRESS.
**
** It is always safe for this macro to do nothing.
** It exists to recognize opportunities to optimize the output.
*/

#define LEGITIMIZE_ADDRESS(X,OLDX,MODE,WIN) \
{ \
}

/*
** Go to LABEL if ADDR (a legitimate address expression) has an effect that
** depends on the machine mode it is used for.
*/
#define GO_IF_MODE_DEPENDENT_ADDRESS(ADDR,LABEL) \
{\
}

/*
** Any single-word constant is ok; the only contexts allowing
** general_operand of mode DI or DF are movdi and movdf.
*/
#define LEGITIMATE_CONSTANT_P(X)	(GET_CODE (X) != CONST_DOUBLE)

/*****************************************************************************
**
** Condition Code Status
**
*****************************************************************************/

/*
** NOTE: Left this as it was defined in the 6809 port. Should investigate
**	 it further to make sure that it is doing the right thing.
*/
#define NOTICE_UPDATE_CC(EXP, INSN) \
	notice_update_cc((EXP), (INSN))

/*****************************************************************************
**
** Describing Relative Costs of Operations
**
*****************************************************************************/

/*
** Compute the cost of computing a constant rtl expression RTX whose rtx-code
** is CODE.  The body of this macro is a portion of a switch statement.  If
** the code is computed here, return it with a return statement. Otherwise,
** break from the switch.
*/
#define CONST_COSTS(RTX,CODE,OUTER_CODE) \
 case CONST: \
    /* Constant zero is super cheap due to clr instruction.  */ \
    if (RTX == const0_rtx) return 0;                            \
    if ((unsigned) INTVAL (RTX) < 077) return 1;                \
 case LABEL_REF: \
 case SYMBOL_REF: \
 case CONST_INT: \
   return 3; \
 case CONST_DOUBLE: \
   return 4;

/* Nonzero if access to memory by bytes is slow and undesirable.  */
#define SLOW_BYTE_ACCESS	0

/*
** It is as good to call a constant function address as to call an address
** kept in a register.
*/
#define NO_FUNCTION_CSE

/*****************************************************************************
**
** Dividing the Output into Sections (Texts, Data, ...)
**
*****************************************************************************/

/* Output before read-only data.  */
#define TEXT_SECTION_ASM_OP	("\tCODE")

/* Output before writable data.  */
#define DATA_SECTION_ASM_OP	("\tDATA") 

/*
** NOTE: The following is needed in ASM_OUTPUT_COMMON() macro
*/

/* Output before uninitialized data.  */
#define BSS_SECTION_ASM_OP 	("\tBSS") 

#define EXTRA_SECTIONS		in_bss

#define EXTRA_SECTION_FUNCTIONS \
void \
bss_section () \
{ \
  if (in_section != in_bss) \
    { \
      fprintf (asm_out_file, "%s\n", BSS_SECTION_ASM_OP); \
      in_section = in_bss; \
    } \
}

/*****************************************************************************
**
** Position Independent Code
**
*****************************************************************************/

/*****************************************************************************
**
** Defining the Output Assembler Language
**
*****************************************************************************/

/*
** Output at beginning of assembler file. 
*/
#define ASM_FILE_START(FILE) \
    fprintf (FILE, ";;;-----------------------------------------\n"); \
    fprintf (FILE, ";;; Start MC6811 gcc assembly output\n"); \
    fprintf (FILE, ";;; gcc compiler compiled on TBD\n"); \
    print_options (FILE); \
    fprintf (FILE, ";;;-----------------------------------------\n");

#define ASM_FILE_END(FILE) \
    fprintf (FILE, "\tEND\n")

/*
** normally gcc_compiled.:
*/
#define ASM_IDENTIFY_GCC(FILE)

/*
** Comment character 
*/
#define ASM_COMMENT_START	";"

/*
** Output to assembler file text saying following lines
** may contain character constants, extra white space, comments, etc. 
*/
#define ASM_APP_ON 		"; Begin inline assembler code\n"

/*
** Output to assembler file text saying following lines
** no longer contain unusual constructs. 
*/
#define ASM_APP_OFF 		"; End of inline assembler code\n"

/* This is how to output an assembler line defining a `double' constant.  */
#define ASM_OUTPUT_DOUBLE(FILE,VALUE) \
	fprintf (FILE, "\tdd %.17#g\n", (VALUE))

/* This is how to output an assembler line defining a `float' constant.  */
#define ASM_OUTPUT_FLOAT(FILE,VALUE) \
	fprintf (FILE, "\tdf %.9#g\n", (VALUE))

/* This is how to output an assembler line defining an `int' constant.  */
#define ASM_OUTPUT_INT(FILE,VALUE) \
( fprintf (FILE, "\tFDB\t"), \
  output_addr_const (FILE, (VALUE)), \
  fprintf (FILE, "\n"))

/* Likewise for `char' and `short' constants.  */
#define ASM_OUTPUT_SHORT(FILE,VALUE) \
( fprintf (FILE, "\tFDB\t"), \
  output_addr_const (FILE, (VALUE)), \
  fprintf (FILE, "\n"))

#define ASM_OUTPUT_CHAR(FILE,VALUE) \
( fprintf (FILE, "\tFCB\t"), \
  output_addr_const (FILE, (VALUE)), \
  fprintf (FILE, "\n"))

/* This is how to output an assembler line for a numeric constant byte.  */
#define ASM_OUTPUT_BYTE(FILE,VALUE) \
  fprintf (FILE, "\tFCB\t$%x\n", (VALUE))

/* This is how to output a string */

#define ASM_OUTPUT_ASCII(FILE,STR,SIZE)	output_asm_ascii(FILE, STR, SIZE)

/*
** Define the parentheses used to group arithmetic operations in assembler
** code.
*/
#define ASM_OPEN_PAREN		"("
#define ASM_CLOSE_PAREN		")"

/*
** A C statement (sans semicolon) to output to the stdio stream STREAM the
** assembler definition of a common-label named NAME whose size is SIZE
** bytes.  The variable ROUNDED is the size rounded up to whatever alignment
** the caller wants.
*/
#define ASM_OUTPUT_COMMON(FILE, NAME, SIZE, ROUNDED) \
  do {bss_section (); \
  fputs ("\t; global\t", FILE); \
  assemble_name ((FILE), (NAME)); \
  fputs ("\n", FILE); \
  assemble_name ((FILE), (NAME)); \
  fprintf ((FILE), ":\tRMB\t%d\n", (ROUNDED));} while(0)

/*
** This says how to output an assembler line to define a global common
** symbol.
*/
#define ASM_OUTPUT_LOCAL(FILE, NAME, SIZE, ROUNDED) \
do {bss_section (); \
  assemble_name ((FILE), (NAME)); \
  fprintf ((FILE), ":\tRMB\t%d\n", (ROUNDED));} while(0)

/*****************************************************************************
**
** Output and Generation of Labels
**
*****************************************************************************/

/*
** This is how to output the definition of a user-level label named NAME,
** such as the label on a static function or variable NAME.
*/
#define ASM_OUTPUT_LABEL(FILE,NAME) \
  {assemble_name (FILE, NAME); \
  fputs (":\n", FILE);}


/*
** This is how to output a command to make the user-level label
** named NAME defined for reference from other files.
*/
#define ASM_GLOBALIZE_LABEL(FILE,NAME) \
  {fputs ("\t; global ", FILE); \
  assemble_name (FILE, NAME); \
  fputs ("\n", FILE);}

/* output external reference -- tej */
#define ASM_OUTPUT_EXTERNAL(FILE,DECL,NAME) \
  {fputs ("\t; extern\t", FILE); \
  assemble_name (FILE, NAME); \
  fputs ("\n", FILE);}

/* This is how to output a reference to a user label named NAME. */
#define ASM_OUTPUT_LABELREF(FILE,NAME) \
  fprintf (FILE, "_%s", NAME)

/*
** A C statement to output to the stdio stream STREAM a label whose
** name is made from the string PREFIX and the number NUM.
*/
#define ASM_GENERATE_INTERNAL_LABEL(LABEL,PREFIX,NUM) \
  sprintf (LABEL, "*%s%d", PREFIX, NUM)

/*
** This is how to output an internal numbered label where PREFIX is the
** class of label and NUM is the number within the class.
*/
#define ASM_OUTPUT_INTERNAL_LABEL(FILE,PREFIX,NUM) \
  fprintf (FILE, "%s%d:\n", PREFIX, NUM)

/*
** Store in OUTPUT a string (made with alloca) containing an assembler-name
** for a local static variable named NAME. LABELNO is an integer which is
** different for each call.
*/
#define ASM_FORMAT_PRIVATE_NAME(OUTPUT, NAME, LABELNO) \
( (OUTPUT) = (char *) alloca (strlen ((NAME)) + 10), \
  sprintf ((OUTPUT), "%s.%d", (NAME), (LABELNO)))

/*****************************************************************************
**
** Output of Initialization Routines
**
*****************************************************************************/

/*****************************************************************************
**
** Output of Assembler Instructions
**
*****************************************************************************/

/*
** How to refer to registers in assembler output. This sequence is indexed
** by compiler's hard-register-number (see above).
*/

#define REGISTER_NAMES \
{"ZD0", "X", "Y", "SP", "PC", "ZA0", "ZB0", "CCR", \
 "ZD1", "ZD2", "ZD3", "ZD4", "ZX1", "ZX2", "ZX3", "ZX4", \
 "ZB1", "ZB2", "ZB3", "ZB4"}

/*
** Print an instruction operand X on file FILE. CODE is the code from the
** %-spec for printing this operand. If `%z3' was used to print operand
** 3, then CODE is 'z'.
*/
#define PRINT_OPERAND(FILE, X, CODE) \
    print_operand (FILE, X, CODE)

/* Print a memory operand whose address is X, on file FILE. */
#define PRINT_OPERAND_ADDRESS(FILE, ADDR) \
    print_operand_address (FILE, ADDR)

/*
** NOTE: I left the following two defines, they shouldn't be used.
*/
/*
** This is how to output an insn to push a register on the stack.
** It need not be very fast code.
*/
#define ASM_OUTPUT_REG_PUSH(FILE,REGNO) \
   fprintf (FILE, "\tpshs\t%s\n", \
	    reg_names[REGNO])

/*
** This is how to output an insn to pop a register from the stack.
** It need not be very fast code.
*/
#define ASM_OUTPUT_REG_POP(FILE,REGNO) \
   fprintf (FILE, "\tpuls\t%s\n", \
	    reg_names[REGNO])

/*****************************************************************************
**
** Output of Dispatch Tables
**
*****************************************************************************/

/* This is how to output an element of a case-vector that is relative. */
#define ASM_OUTPUT_ADDR_DIFF_ELT(FILE, VALUE, REL) \
  fprintf (FILE, "\tFDB\tL%d-L%d\n", VALUE, REL)

/* This is how to output an element of a case-vector that is absolute. */
#define ASM_OUTPUT_ADDR_VEC_ELT(FILE, VALUE) \
  fprintf (FILE, "\tFDB\tL%d\n", VALUE)

#if 0

#define ASM_OUTPUT_CASE_LABEL(FILE,PREFIX,NUM,TABLE) \
  ASM_OUTPUT_ALIGN (FILE, 1); \
  ASM_OUTPUT_INTERNAL_LABEL (FILE, PREFIX, NUM)

#define ASM_OUTPUT_CASE_END(FILE,NUM,TABLE) \
  ASM_OUTPUT_ALIGN (FILE, 1)

#endif

/*****************************************************************************
**
** Assembler Commands for Alignment
**
*****************************************************************************/

/*
** This is how to output an assembler line that says to advance the
** location counter by SIZE bytes.
*/
#define ASM_OUTPUT_SKIP(FILE,SIZE) \
  fprintf (FILE, "\tRMB\t%d\t;reserve space\n", (SIZE))

/*
** This is how to output an assembler line that says to advance the
** location counter to a multiple of 2**LOG bytes.
*/
#define ASM_OUTPUT_ALIGN(FILE,LOG) \
  if ((LOG) > 1) \
    fprintf (FILE, "\t.align %d\n", 1 << (LOG))

/*****************************************************************************
**
** Controlling Debugging Information Format
**
*****************************************************************************/

/* How to renumber registers for dbx and gdb. */
#define DBX_REGISTER_NUMBER(REGNO) (REGNO)

/* This is BSD, so it wants DBX format.  */
/* #define DBX_DEBUGGING_INFO */

/*
** This is the char to use for continuation (in case we need to turn
** continuation back on).
*/
#define DBX_CONTIN_CHAR		'?'

/*
** Don't use the `xsfoo;' construct in DBX output; this system
** doesn't support it.
*/
#define DBX_NO_XREFS

/* Do not break .stabs pseudos into continuations.  */
#define DBX_CONTIN_LENGTH	0

/*****************************************************************************
**
** Cross Compilation and Floating Point Format
**
*****************************************************************************/


/*****************************************************************************
**
** Miscellaneous Parameters
**
*****************************************************************************/

/*
** Specify the machine mode that this machine uses
** for the index in the tablejump instruction.
*/
#define CASE_VECTOR_MODE	Pmode

/* Specify the tree operation to be used to convert reals to integers. */
#define IMPLICIT_FIX_EXPR	FIX_ROUND_EXPR

/*
** This flag, if defined, says the same insns that convert to a signed fixnum
** also convert validly to an unsigned one.
*/
#define FIXUNS_TRUNC_LIKE_FIX_TRUNC

/* This is the kind of divide that is easiest to do in the general case.  */
#define EASY_DIV_EXPR		TRUNC_DIV_EXPR

/*
** Max number of bytes we can move from memory to memory in one
** reasonably fast instruction.
*/
#define MOVE_MAX 		2

/*
** Define if shifts truncate the shift count which implies one can omit
** a sign-extension or zero-extension of a shift count.
*/
#define SHIFT_COUNT_TRUNCATED

/*
** Value is 1 if truncating an integer of INPREC bits to OUTPREC bits
** is done just by pretending it is already truncated.
*/
#define TRULY_NOOP_TRUNCATION(OUTPREC, INPREC)	1

/*
** Specify the machine mode that pointers have. After generation of rtl, the
** compiler makes no further distinction between pointers and any other
** objects of this machine mode.
*/
#define Pmode			HImode

/*
** A function address in a call instruction is a byte address (for indexing
** purposes) so give the MEM rtx a byte's mode.
*/
#define FUNCTION_MODE		HImode

/* define SCCS_DIRECTIVE if SCCS directives should be ignored */
#define SCCS_DIRECTIVE		1

/* Allow $ in identifiers */
#define DOLLARS_IN_IDENTIFIERS	1
