From cbmvax!cs!phillips Wed Jul 31 09:47 EDT 1991
Received: by blekko.commodore.com; Wed, 31 Jul 1991 09:47 EDT
Received: by cbmvax.cbm.commodore.com (5.57/UUCP-Project/Commodore 2/8/91)
	id AA27194; Wed, 31 Jul 91 09:23:00 EDT
Received: from grolsch.cs.ubc.ca by rutgers.edu (5.59/SMI4.0/RU1.4/3.08) 
	id AA01230; Wed, 31 Jul 91 08:38:37 EDT
Received: by grolsch.cs.ubc.ca id AA17784
  (5.65c/IDA-1.3.5 for skrenta@blekko.commodore.com); Tue, 30 Jul 1991 14:54:06 -0700
Date: 30 Jul 91 14:53 -0700
From: George Phillips <cbmvax!cs.ubc.ca!phillips>
To: Rich Skrenta <blekko!skrenta>
Message-Id: <2607*phillips@cs.ubc.ca>
Subject: a2.shar.6
Content-Type: text
Content-Length: 8228
Status: RO

#! /bin/sh
# This is a shell archive, meaning:
# 1. Remove everything above the #! /bin/sh line.
# 2. Save the resulting text in a file.
# 3. Execute the file with /bin/sh (not csh) to create the files:
#	vidout.c
#	dos.c
#	Makefile
#	hgr.h
#	greypat.h
#	grey.conv
# This archive created: Tue Jul 30 14:43:13 1991
export PATH; PATH=/bin:$PATH
echo shar: extracting "'vidout.c'" '(2005 characters)'
if test -f 'vidout.c'
then
	echo shar: will not over-write existing file "'vidout.c'"
else
cat << \SHAR_EOF > 'vidout.c'
/*
 *  a2, an Apple II emulator in C
 *  (c) Copyright 1990 by Rich Skrenta
 *
 *  Command line interface written by Tom Markson
 *
 *  Distribution agreement:
 *
 *	You may freely copy or redistribute this software, so long
 *	as there is no profit made from its use, sale, trade or
 *	reproduction.  You may not change this copyright notice,
 *	and it must be included prominently in any copy made.
 *
 *  Send emulator related mail to:  skrenta@blekko.commodore.com
 *				    skrenta@blekko.uucp
 */



#include	<stdio.h>
#include	"a2.h"


#define		WNDLFT		0x20
#define		WNDWDTH		0x21
#define		WNDTOP		0x22
#define		WNDBTM		0x23
#define		CH		0x24
#define		CV		0x25
#define		BASL		0x28
#define		BASH		0x29
#define		BAS2L		0x2A
#define		BAS2H		0x2B



/*
 *  VIDOUT at $FBFD
 */

vidout() {
unsigned short ptr;

	if (A >= 0xA0 || A < 0x80) {
		ptr = join(mem[BASL], mem[BASH]) + mem[CH];
		set_text1f(ptr, A);
		mem[CH]++;
		if (mem[CH] >= mem[WNDWDTH])
			mem[CH] = 0;
		else {
			DO_RTS;
			return;
		}
	} else if (A == 0x8D)
		mem[CH] = 0;
	else if (A != 0x8A) {
		Pc = 0xFC0C;
		return;
	}

	A = ++mem[CV];
	if (A < mem[WNDBTM]) {
		Pc = 0xFC24;
		return;
	}
	mem[CV]--;

	scroll();
}


/*
 *  SCROLL at $FC70
 */

scroll() {
int top;
unsigned short bas, bas2, ptr;
int width;
int i;
int scrl2_normal;

	if (mem[0x21] == 40 && mem[0x22] == 0 && mem[0x23] == 24) {
		MoveCursor(term_lines, 0);
		putchar('\n');
		last_line = -1;
		last_col = -1;
		fflush(stdout);
		scrl2_normal = FALSE;
	} else
		scrl2_normal = TRUE;

	top = mem[WNDTOP];
	width = mem[WNDWDTH] - 1;
	bas = text1[top % 32] + mem[WNDLFT];

	while (1) {
		bas2 = bas;

		if (++top >= mem[WNDBTM]) {
			mem[BASL] = low(bas);
			mem[BASH] = high(bas);
			Pc = 0xFC95;
			fflush(stdout);
			return;
		}

		bas = text1[top % 32] + mem[WNDLFT];
		ptr = bas;

		if (scrl2_normal)
			for (i = 0; i <= width; i++)
				/*set_text1(bas2++, mem[ptr++])*/; /* GWP hack */
		else
			for (i = 0; i <= width; i++)
				mem[bas2++] = mem[ptr++];
	}
}


SHAR_EOF
fi # end of overwriting check
echo shar: extracting "'dos.c'" '(1871 characters)'
if test -f 'dos.c'
then
	echo shar: will not over-write existing file "'dos.c'"
else
cat << \SHAR_EOF > 'dos.c'
/*
 *  a2, an Apple II emulator in C
 *  (c) Copyright 1990 by Rich Skrenta
 *
 *  Command line interface written by Tom Markson
 *
 *  Distribution agreement:
 *
 *	You may freely copy or redistribute this software, so long
 *	as there is no profit made from its use, sale, trade or
 *	reproduction.  You may not change this copyright notice,
 *	and it must be included prominently in any copy made.
 *
 *  Send emulator related mail to:  skrenta@blekko.commodore.com
 *				    skrenta@blekko.uucp
 */


#include	<stdio.h>
#include	"a2.h"



char *rwts_func[] = {"-s", "", "-w", "-?", "-f"};


rwts() {
char s[50];
unsigned short iob;
unsigned short buf;
int track;
int sector;
int cmd;
char zero_buf[256];
int i;

	mem[0x48] = Y;
	mem[0x49] = A;
	mem[0x6F8] = 2;
	mem[0x4F8] = 4;

	iob = join(Y, A);

	track = mem[iob + 4];
	sector = mem[iob + 5];
	buf = join(mem[iob + 8], mem[iob + 9]);
	cmd = mem[iob + 12];

	if (cmd > 4)
		cmd = 3;		/* unknown command */

	if (mem[iob + 2] == 2)
		drive = 1;
	else
		drive = 0;

	if ((cmd == 2 || cmd == 4) && write_prot[drive]) {
		C = 1;
		mem[iob + 13] = 0x10;		/* Write protected */
		DO_RTS;
		return;
	}

	if (mem[iob] != 1
	||  disk[drive] < 0
	||  track > 35
	||  sector > 15
	||  cmd == 3
	||  buf > 0xFE00) {
		C = 1;
		mem[iob + 13] = 0x40;		/* IO Error */
		DO_RTS;
		return;
	}

	sprintf(s, "rwts%s t=%d s=%d%s", rwts_func[cmd],
				track, sector, drive ? " d2" : "");
	info(s);

	switch (cmd) {
	case 0:					/* seek */
		break;

	case 1:					/* read */
		read_disk(track, sector, &mem[buf]);
		break;

	case 2:					/* write */
		write_disk(track, sector, &mem[buf]);
		break;

	case 4:					/* format */
		for (i = 0; i < 256; i++)
			zero_buf[i] = 0;

		for (track = 0; track < 35; track++)
			for (sector = 0; sector < 16; sector++)
				write_disk(track, sector, zero_buf);
		break;
	}

	C = 0;
	A = 0;
	DO_RTS;
}

SHAR_EOF
fi # end of overwriting check
echo shar: extracting "'Makefile'" '(1527 characters)'
if test -f 'Makefile'
then
	echo shar: will not over-write existing file "'Makefile'"
else
cat << \SHAR_EOF > 'Makefile'
#
#  Use -O if you can.  It gave a 20% speedup on one test.
#
CC=gcc
CFLAGS = -O -I/cs/local/generic/include
LIBS   = -lcurses -ltermcap -L/cs/local/lib/X11R4 -lX11

#  If Using 286 Xenix, uncomment the following lines:
# CFLAGS  = -M2l -O
# LARGE   = -LARGE
#
# Make SYSTEM be -DBSD for Berkeley-ish machines, leave blank otherwise
#
SYSTEM = 
#SYSTEM = -DBSD


OBJECTS =	a2.o table.o jump.o curses.o main.o screen.o \
		mem.o tbl.o parse.o commands.o dos.o cli.o vidout.o \
		disk.o prodos.o hgr.o

a2:	$(OBJECTS)
	$(CC) -o a2 $(CFLAGS) $(OBJECTS) $(LIBS)

curses.o:	curses.c
	$(CC) -c $(SYSTEM) $(CFLAGS) curses.c

screen.o: charset.h greypat.h

charset.h: char.set
	char.conv <char.set >charset.h

greypat.h: grey.pat
	grey.conv <grey.pat >greypat.h
	
shar:
	-mv ../a2.shar ../a2.shar-
	shar -v a2.readme poster Makefile Notes Snarf Cli.doc *.[ch] *.pat *.conv char.set > ../a2.shar

shar2:
	ls a2.readme poster Makefile Notes Snarf Cli.doc \
	*.[ch] *.pat *.conv char.set | binpack 30000 | \
	awk '{print "shar -v " $$0 " >a2.shar." NR; }' | sh

tar:
	-mv ../a2.tar ../a2.tar-
	tar -cvf ../a2.tar [A-Z]* *.[ch]

clean:
	rm -f *.o core

clobber:	clean
	rm -f a2


a2.o:		a2.h a2.c
	$(CC) $(LARGE) $(CFLAGS) -c a2.c

cli.o:		cli.c a2.h cli.h
commands.o:	commands.c cli.h a2.h
disk.o:		disk.c a2.h
dos.o:		dos.c a2.h
jump.o:		jump.c a2.h
main.o:		main.c a2.h
mem.o:		mem.c a2.h
parse.o:	parse.c cli.h a2.h
pascal.o:	pascal.c a2.h
screen.o:	screen.c a2.h
table.o:	table.c a2.h
tbl.o:		tbl.c cli.h a2.h
vidout.o:	vidout.c a2.h
SHAR_EOF
fi # end of overwriting check
echo shar: extracting "'hgr.h'" '(450 characters)'
if test -f 'hgr.h'
then
	echo shar: will not over-write existing file "'hgr.h'"
else
cat << \SHAR_EOF > 'hgr.h'
/*
 * hgr.h
 */

extern char* hgrinterp();
extern void buildtable();
extern void cbuildtable();

extern unsigned char b1_tab[256], b2_tab[256], b3_tab[256], b4_tab[256],
	b5_tab[256], b6_tab[256], b7_tab[256];

extern unsigned char b1_tab_2[256], b2_tab_2[256], b3_tab_2[256], b4_tab_2[256],
	b5_tab_2[256], b6_tab_2[256], b7_tab_2[256];

extern int cb1_tab[256], cb2_tab[256], cb3_tab[256], cb4_tab[256],
	cb5_tab[256], cb6_tab[256], cb7_tab[256];

SHAR_EOF
fi # end of overwriting check
echo shar: extracting "'greypat.h'" '(432 characters)'
if test -f 'greypat.h'
then
	echo shar: will not over-write existing file "'greypat.h'"
else
cat << \SHAR_EOF > 'greypat.h'
unsigned char greypat[64] = {
 0x00, 0x00, 0x00, 0x00,
 0x09, 0x0a, 0x05, 0x09,
 0x0a, 0x0a, 0x05, 0x05,
 0x0c, 0x03, 0x0c, 0x03,
 0x0c, 0x0c, 0x03, 0x03,
 0x08, 0x04, 0x02, 0x01,
 0x01, 0x02, 0x04, 0x08,
 0x0a, 0x00, 0x0a, 0x00,
 0x00, 0x0f, 0x00, 0x0f,
 0x05, 0x05, 0x05, 0x05,
 0x06, 0x0f, 0x0f, 0x06,
 0x05, 0x0f, 0x05, 0x0f,
 0x09, 0x03, 0x06, 0x0c,
 0x09, 0x0c, 0x06, 0x03,
 0x0a, 0x05, 0x0a, 0x05,
 0x0f, 0x0f, 0x0f, 0x0f
};
SHAR_EOF
fi # end of overwriting check
echo shar: extracting "'grey.conv'" '(278 characters)'
if test -f 'grey.conv'
then
	echo shar: will not over-write existing file "'grey.conv'"
else
cat << \SHAR_EOF > 'grey.conv'
#!/cs/local/bin/perl

print "unsigned char greypat[64] = {\n";

$comma = "";

while (<>) {
	chop;
	if ($_ eq "") {
		print "$comma\n";
		$comma = "";
		next;
	}
	s/\./0/g;
	s/[^0]/1/g;
	print "$comma 0x", unpack("H2", pack("B8", "0000" . $_));
	$comma = ",";
}

print "\n};\n";
SHAR_EOF
chmod +x 'grey.conv'
fi # end of overwriting check
#	End of shell archive
exit 0

From cbmvax!cs!phillips Wed Jul 31 09:47 EDT 1991
Received: by blekko.commodore.com; Wed, 31 Jul 1991 09:47 EDT
Received: by cbmvax.cbm.commodore.com (5.57/UUCP-Project/Commodore 2/8/91)
	id AA25997; Wed, 31 Jul 91 09:13:58 EDT
Received: from grolsch.cs.ubc.ca by rutgers.edu (5.59/SMI4.0/RU1.4/3.08) 
	id AA01108; Wed, 31 Jul 91 08:36:58 EDT
Received: by grolsch.cs.ubc.ca id AA17752
  (5.65c/IDA-1.3.5 for skrenta@blekko.commodore.com); Tue, 30 Jul 1991 14:52:07 -0700
Date: 30 Jul 91 14:52 -0700
From: George Phillips <cbmvax!cs.ubc.ca!phillips>
To: Rich Skrenta <blekko!skrenta>
Message-Id: <2601*phillips@cs.ubc.ca>
Subject: a2 + X
Content-Type: text
Content-Length: 960
Status: O

OK, here comes all the source.  It will be in six parts (not including this
covering letter).  I make the parts about < 32000 bytes to avoid grief
from mailers.

Mostly I've just re-written screen.c and placed minor hacks here and there
to kludge it in.  To that end, I've added a "-j" flags which removes the
jump stuff (including the screen write detection).  This is a symptom of
poor integration.  I run it by using "a2 -c -j", insert a disk and then
go off to the races.  There are some other flags which will change the
size of the display presented, -s for a small display (240x192) display
and -b for a big display (580x384).

I changed the 6502 emulation to just fprintf an error if SBC in decimal
mode is encountered.  This makes a game called "drol" easy to play as
it uses that instruction only for decrementing the number of men left(!).

Let me know if you make any changes worth propagating back; I'll try and
do the same for you.

			-- George

From cbmvax!cs!phillips Wed Jul 31 09:47 EDT 1991
Received: by blekko.commodore.com; Wed, 31 Jul 1991 09:47 EDT
Received: by cbmvax.cbm.commodore.com (5.57/UUCP-Project/Commodore 2/8/91)
	id AA27604; Wed, 31 Jul 91 09:25:45 EDT
Received: from grolsch.cs.ubc.ca by rutgers.edu (5.59/SMI4.0/RU1.4/3.08) 
	id AA01359; Wed, 31 Jul 91 08:40:30 EDT
Received: by grolsch.cs.ubc.ca id AA17756
  (5.65c/IDA-1.3.5 for skrenta@blekko.commodore.com); Tue, 30 Jul 1991 14:52:20 -0700
Date: 30 Jul 91 14:52 -0700
From: George Phillips <cbmvax!cs.ubc.ca!phillips>
To: Rich Skrenta <blekko!skrenta>
Message-Id: <2602*phillips@cs.ubc.ca>
Subject: a2.shar.1
Content-Type: text
Content-Length: 30933
Status: O

#! /bin/sh
# This is a shell archive, meaning:
# 1. Remove everything above the #! /bin/sh line.
# 2. Save the resulting text in a file.
# 3. Execute the file with /bin/sh (not csh) to create the files:
#	a2.c
#	Cli.doc
#	grey.pat
# This archive created: Tue Jul 30 14:43:09 1991
export PATH; PATH=/bin:$PATH
echo shar: extracting "'a2.c'" '(24466 characters)'
if test -f 'a2.c'
then
	echo shar: will not over-write existing file "'a2.c'"
else
cat << \SHAR_EOF > 'a2.c'
/*
 *  a2, an Apple II emulator in C
 *  (c) Copyright 1990 by Rich Skrenta
 *
 *  Command line interface written by Tom Markson
 *
 *  Distribution agreement:
 *
 *	You may freely copy or redistribute this software, so long
 *	as there is no profit made from its use, sale, trade or
 *	reproduction.  You may not change this copyright notice,
 *	and it must be included prominently in any copy made.
 *
 *  Send emulator related mail to:  skrenta@blekko.commodore.com
 *				    skrenta@blekko.uucp
 */


#include	<stdio.h>
#include	"a2.h"

#define	BRANCH()	val = mem[Pc++]; if (val & 0x80) Pc += val - 256; else Pc += val;

#define	put_status(s) stmp = s; N = stmp & 0x80; V = stmp & 0x40; B = stmp & 0x10; D = stmp & 0x08; I = stmp & 0x04; NZ = !(stmp & 0x02); C = stmp & 0x01;


extern long trace_lo, trace_hi;
extern FILE *logging_fp;
extern long phantom_location;
extern long breakpoint;



run()
{
register unsigned short ptr;
register unsigned short ptmp;
register unsigned int val;
register unsigned int tmp;
register unsigned int num;
unsigned char stmp;
int foo;
int show_flags = FALSE;


    do {					/* while (tracing) */
	if (tracing) {

		if (breakpoint == Pc) {
			MoveCursor(term_lines, 0);
			printf("Break at $%.4X\n", Pc);
			return;
		}

		if (phantom_location == (long) Pc)
			phantom_location = -1;		/* start tracing now */

		if (phantom_location == -1
		&&  trace_lo != -1
		&&  (long) Pc >= trace_lo
		&&  (long) Pc <= trace_hi) {
			diss(Pc, logging_fp);
			show_flags = TRUE;
		} else
			show_flags = FALSE;
	}


	do {					/* while (running) */
		switch (mem[Pc++]) {
		case 0x00:			/* BRK */
			PCINC;
			push(high(Pc));
			push(low(Pc));
			B = 1;				/* set I flag? */
			push(get_status());
			Pc = join(mem[0xFFFE], mem[0xFFFF]);
			break;

		case 0x01:	/* ORA (indirect, X) */
			INDX;
			A |= REFptr;
			SIGN(A);
			ZERO(A);
			break;

		case 0x02:
			break;

		case 0x03:
			break;

		case 0x04:	/* TSB zero page	65C02 */
			break;

		case 0x05:	/* ORA zero page */
			A |= rZEROP;
			SIGN(A);
			ZERO(A);
			break;

		case 0x06:	/* ASL zero page */
			ZEROP;
			val = REFzero << 1;
			CARRY(val);
			val &= 0xFF;
			SETzero(val);
			SIGN(val);
			ZERO(val);
			break;

		case 0x07:
			break;

		case 0x08:	/* PHP */
			push(get_status());
			break;

		case 0x09:	/* ORA immediate */
			A |= REFimm;
			SIGN(A);
			ZERO(A);
			break;

		case 0x0A:	/* ASL accumulator */
			A = A << 1;
			CARRY(A);
			A &= 0xFF;
			SIGN(A);
			ZERO(A);
			break;

		case 0x0B:
			break;

		case 0x0C:	/* TSB absolute		65C02 */
			break;

		case 0x0D:	/* ORA absolute */
			ABSOL;
			A |= REFptr;
			SIGN(A);
			ZERO(A);
			break;

		case 0x0E:	/* ASL absolute */
			ABSOL;
			val = REFptr << 1;
			CARRY(val);
			val &= 0xFF;
			SETptr(val);
			SIGN(val);
			ZERO(val);
			break;

		case 0x0F:
			break;

		case 0x10:	/* BPL */
			if (N) {
				PCINC;
			} else {
				BRANCH();
			}
			break;

		case 0x11:	/* ORA (indirect), Y */
			INDY;
			A |= REFptr;
			SIGN(A);
			ZERO(A);
			break;

		case 0x12:	/* ORA (indz)		65C02 */
			break;

		case 0x13:
			break;

		case 0x14:	/* TRB zero page	65C02 */
			break;

		case 0x15:	/* ORA zero page, X */
			A |= rZEROX;
			SIGN(A);
			ZERO(A);
			break;

		case 0x16:	/* ASL zero page, X */
			ZEROX;
			val = REFzero << 1;
			CARRY(val);
			val &= 0xFF;
			SETzero(val);
			SIGN(val);
			ZERO(val);
			break;

		case 0x17:
			break;

		case 0x18:	/* CLC */
			C = 0;
			break;

		case 0x19:	/* ORA absolute, Y */
			ABSY;
			A |= REFptr;
			SIGN(A);
			ZERO(A);
			break;

		case 0x1A:	/* INA			65C02 */
			break;

		case 0x1C:	/* TRB absolute		65C02 */
			break;

		case 0x1D:	/* ORA absolute, X */
			ABSX;
			A |= REFptr;
			SIGN(A);
			ZERO(A);
			break;

		case 0x1E:	/* ASL absolute, X */
			ABSX;
			val = REFptr << 1;
			CARRY(val);
			val &= 0xFF;
			SETptr(val);
			SIGN(val);
			ZERO(val);
			break;

		case 0x1F:
			break;

		case 0x20:	/* JSR */
			ptmp = REFimm;
			ptmp |= mem[Pc] << 8;
			push(high(Pc));
			push(low(Pc));
			Pc = ptmp;

			if (jmp_tbl[Pc])
				jump(jmp_tbl[Pc]);
			break;

		case 0x21:	/* AND (indirect, X) */
			INDX;
			A &= REFptr;
			SIGN(A);
			ZERO(A);
			break;

		case 0x22:
			break;

		case 0x23:
			break;

		case 0x24:	/* BIT zero page */
			tmp = rZEROP;
			ZERO(A & tmp);
			N = tmp & 0x80;
			V = tmp & 0x40;
			break;

		case 0x25:	/* AND zero page */
			A &= rZEROP;
			SIGN(A);
			ZERO(A);
			break;

		case 0x26:	/* ROL zero page */
			ZEROP;
			val = REFzero;
			tmp = C;
			val = val << 1;
			CARRY(val);
			val = (val & 0xFF) | tmp;
			SETzero(val);
			SIGN(val);
			ZERO(val);
			break;

		case 0x27:
			break;

		case 0x28:	/* PLP */
			put_status(pop());
			break;

		case 0x29:	/* AND immediate */
			A &= REFimm;
			SIGN(A);
			ZERO(A);
			break;

		case 0x2A:	/* ROL accumulator */
			tmp = C;
			A = A << 1;
			CARRY(A);
			A = (A & 0xFF) | tmp;
			SIGN(A);
			ZERO(A);
			break;

		case 0x2B:
			break;

		case 0x2C:	/* BIT absolute */
			ABSOL;
			tmp = REFptr;
			ZERO(A & tmp);
			N = tmp & 0x80;
			V = tmp & 0x40;
			break;

		case 0x2D:	/* AND absolute */
			ABSOL;
			A &= REFptr;
			SIGN(A);
			ZERO(A);
			break;

		case 0x2E:	/* ROL absolute */
			ABSOL;
			val = REFptr;
			tmp = C;
			val = val << 1;
			CARRY(val);
			val = (val & 0xFF) | tmp;
			SETptr(val);
			SIGN(val);
			ZERO(val);
			break;

		case 0x2F:
			break;

		case 0x30:	/* BMI */
			if (N) {
				BRANCH();
			} else{
				PCINC;
			}
			break;

		case 0x31:	/* AND (indirect), Y */
			INDY;
			A &= REFptr;
			SIGN(A);
			ZERO(A);
			break;

		case 0x32:	/* AND (indz)		65C02 */
			break;

		case 0x33:
			break;

		case 0x34:	/* BIT zero page, X	65C02 */
			break;

		case 0x35:	/* AND zero page, X */
			A &= rZEROX;
			SIGN(A);
			ZERO(A);
			break;

		case 0x36:	/* ROL zero page, X */
			ZEROX;
			val = REFzero;
			tmp = C;
			val = val << 1;
			CARRY(val);
			val = (val & 0xFF) | tmp;
			SETzero(val);
			SIGN(val);
			ZERO(val);
			break;

		case 0x37:
			break;

		case 0x38:	/* SEC */
			C = 1;
			break;

		case 0x39:	/* AND absolute, Y */
			ABSY;
			A &= REFptr;
			SIGN(A);
			ZERO(A);
			break;

		case 0x3A:	/* DEA			65C02 */
			break;

		case 0x3B:
			break;

		case 0x3C:	/* BIT absolute, X	65C02 */
			break;

		case 0x3D:	/* AND absolute, X */
			ABSX;
			A &= REFptr;
			SIGN(A);
			ZERO(A);
			break;

		case 0x3E:	/* ROL absolute, X */
			ABSX;
			val = REFptr;
			tmp = C;
			val = val << 1;
			CARRY(val);
			val = (val & 0xFF) | tmp;
			SETptr(val);
			SIGN(val);
			ZERO(val);
			break;

		case 0x3F:
			break;

		case 0x40:	/* RTI */
			put_status(pop());
			Pc = pop();
			Pc |= pop() << 8;
			break;

		case 0x41:	/* EOR (indirect, X) */
			INDX;
			A ^= REFptr;
			SIGN(A);
			ZERO(A);
			break;

		case 0x42:
			break;

		case 0x43:
			break;

		case 0x44:
			break;

		case 0x45:	/* EOR zero page */
			A ^= rZEROP;
			SIGN(A);
			ZERO(A);
			break;

		case 0x46:	/* LSR zero page */
			ZEROP;
			tmp = REFzero;
			C = (tmp & 0x01);
			tmp = tmp >> 1;
			SETzero(tmp);
			N = 0;
			ZERO(tmp);
			break;

		case 0x47:
			break;

		case 0x48:	/* PHA */
			push(A);
			break;

		case 0x49:	/* EOR immediate */
			A ^= REFimm;
			SIGN(A);
			ZERO(A);
			break;

		case 0x4A:	/* LSR accumulator */
			C = (A & 0x01);
			A = A >> 1;
			N = 0;
			ZERO(A);
			break;

		case 0x4B:
			break;

		case 0x4C:	/* JMP absolute */
			ptmp = REFimm;
			ptmp |= REFimm << 8;
			Pc = ptmp;

			if (jmp_tbl[Pc])
				jump(jmp_tbl[Pc]);
			break;

		case 0x4D:	/* EOR absolute */
			ABSOL;
			A ^= REFptr;
			SIGN(A);
			ZERO(A);
			break;

		case 0x4E:	/* LSR absolute */
			ABSOL;
			tmp = REFptr;
			C = (tmp & 0x01);
			tmp = tmp >> 1;
			SETptr(tmp);
			N = 0;
			ZERO(tmp);
			break;

		case 0x4F:
			break;

		case 0x50:	/* BVC */
			if (V) {
				PCINC;
			} else {
				BRANCH();
			}
			break;

		case 0x51:	/* EOR (indirect), Y */
			INDY;
			A ^= REFptr;
			SIGN(A);
			ZERO(A);
			break;

		case 0x52:	/* EOR (indz)		65C02 */
			break;

		case 0x53:
			break;

		case 0x54:
			break;

		case 0x55:	/* EOR zero page, X */
			A ^= rZEROX;
			SIGN(A);
			ZERO(A);
			break;

		case 0x56:	/* LSR zero page, X */
			ZEROX;
			tmp = REFzero;
			C = (tmp & 0x01);
			tmp = tmp >> 1;
			SETzero(tmp);
			N = 0;
			ZERO(tmp);
			break;

		case 0x57:
			break;

		case 0x58:	/* CLI */
			I = 0;
			break;

		case 0x59:	/* EOR absolute, Y */
			ABSY;
			A ^= REFptr;
			SIGN(A);
			ZERO(A);
			break;

		case 0x5A:	/* PHY		65C02 */
			break;

		case 0x5B:
			break;

		case 0x5C:
			break;

		case 0x5D:	/* EOR absolute, X */
			ABSX;
			A ^= REFptr;
			SIGN(A);
			ZERO(A);
			break;

		case 0x5E:	/* LSR absolute, X */
			ABSX;
			tmp = REFptr;
			C = (tmp & 0x01);
			tmp = tmp >> 1;
			SETptr(tmp);
			N = 0;
			ZERO(tmp);
			break;

		case 0x5F:
			break;

		case 0x60:	/* RTS */
			DO_RTS;
			break;

		case 0x61:	/* ADC (indirect, X) */
			INDX;
			val = REFptr;
			tmp = A & 0x80;
			stmp = val & 0x80;
			if (D) {
				num = tobinary(val);
				val = tobinary(A);

				val += num + C;
				dCARRY(val);
				while (val >= 100)
					val -= 100;

				A = tobcd(val);
			} else {
				A += val + C;
				CARRY(A);
				A &= 0xFF;
			}
			ZERO(A);
			SIGN(A);
			V = (tmp == stmp) && (tmp != N);
			break;

		case 0x62:
			break;

		case 0x63:
			break;

		case 0x64:	/* STZ zero page	65C02 */
			break;

		case 0x65:	/* ADC zero page */
			val = rZEROP;
			tmp = A & 0x80;
			stmp = val & 0x80;
			if (D) {
				num = tobinary(val);
				val = tobinary(A);

				val += num + C;
				dCARRY(val);
				while (val >= 100)
					val -= 100;

				A = tobcd(val);
			} else {
				A += val + C;
				CARRY(A);
				A &= 0xFF;
			}
			ZERO(A);
			SIGN(A);
			V = (tmp == stmp) && (tmp != N);
			break;


		case 0x66:	/* ROR zero page */
			ZEROP;
			val = REFzero;
			tmp = C;
			C = val & 0x01;
			val = val >> 1;
			val |= tmp << 7;
			SETzero(val);
			SIGN(val);
			ZERO(val);
			break;

		case 0x67:
			break;

		case 0x68:	/* PLA */
			A = pop();
			SIGN(A);
			ZERO(A);
			break;

		case 0x69:	/* ADC immediate */
			val = REFimm;
			tmp = A & 0x80;
			stmp = val & 0x80;
			if (D) {
				num = tobinary(val);
				val = tobinary(A);

				val += num + C;
				dCARRY(val);
				while (val >= 100)
					val -= 100;

				A = tobcd(val);
			} else {
				A += val + C;
				CARRY(A);
				A &= 0xFF;
			}
			ZERO(A);
			SIGN(A);
			V = (tmp == stmp) && (tmp != N);
			break;

		case 0x6A:	/* ROR accumulator */
			tmp = C;
			C = A & 0x01;
			A = A >> 1;
			A |= tmp << 7;
			SIGN(A);
			ZERO(A);
			break;

		case 0x6B:
			break;

		case 0x6C:	/* JMP indirect */
			ptmp = REFimm;
			ptmp |= REFimm << 8;
			Pc = mem[ptmp++];
			Pc |= mem[ptmp] << 8;

			if (jmp_tbl[Pc])
				jump(jmp_tbl[Pc]);
			break;

		case 0x6D:	/* ADC absolute */
			ABSOL;
			val = REFptr;
			tmp = A & 0x80;
			stmp = val & 0x80;
			if (D) {
				num = tobinary(val);
				val = tobinary(A);

				val += num + C;
				dCARRY(val);
				while (val >= 100)
					val -= 100;

				A = tobcd(val);
			} else {
				A += val + C;
				CARRY(A);
				A &= 0xFF;
			}
			ZERO(A);
			SIGN(A);
			V = (tmp == stmp) && (tmp != N);
			break;

		case 0x6E:	/* ROR absolute */
			ABSOL;
			val = REFptr;
			tmp = C;
			C = val & 0x01;
			val = val >> 1;
			val |= tmp << 7;
			SETptr(val);
			SIGN(val);
			ZERO(val);
			break;

		case 0x6F:
			break;

		case 0x70:	/* BVS */
			if (V) {
				BRANCH();
			} else {
				PCINC;
			}
			break;

		case 0x71:	/* ADC (indirect),Y */
			INDY;
			val = REFptr;
			tmp = A & 0x80;
			stmp = val & 0x80;
			if (D) {
				num = tobinary(val);
				val = tobinary(A);

				val += num + C;
				dCARRY(val);
				while (val >= 100)
					val -= 100;

				A = tobcd(val);
			} else {
				A += val + C;
				CARRY(A);
				A &= 0xFF;
			}
			ZERO(A);
			SIGN(A);
			V = (tmp == stmp) && (tmp != N);
			break;

		case 0x72:	/* ADC (indz)		65C02 */
			break;

		case 0x73:
			break;

		case 0x74:	/* STZ zero page, X	65C02 */
			break;

		case 0x75:	/* ADC zero page, X */
			val = rZEROX;
			tmp = A & 0x80;
			stmp = val & 0x80;
			if (D) {
				num = tobinary(val);
				val = tobinary(A);

				val += num + C;
				dCARRY(val);
				while (val >= 100)
					val -= 100;

				A = tobcd(val);
			} else {
				A += val + C;
				CARRY(A);
				A &= 0xFF;
			}
			ZERO(A);
			SIGN(A);
			V = (tmp == stmp) && (tmp != N);
			break;

		case 0x76:	/* ROR zero page, X */
			ZEROX;
			val = REFzero;
			tmp = C;
			C = val & 0x01;
			val = val >> 1;
			val |= tmp << 7;
			SETzero(val);
			SIGN(val);
			ZERO(val);
			break;

		case 0x77:
			break;

		case 0x78:	/* SEI */
			I = 1;
			break;

		case 0x79:	/* ADC absolute, Y */
			ABSY;
			val = REFptr;
			tmp = A & 0x80;
			stmp = val & 0x80;
			if (D) {
				num = tobinary(val);
				val = tobinary(A);

				val += num + C;
				dCARRY(val);
				while (val >= 100)
					val -= 100;

				A = tobcd(val);
			} else {
				A += val + C;
				CARRY(A);
				A &= 0xFF;
			}
			ZERO(A);
			SIGN(A);
			V = (tmp == stmp) && (tmp != N);
			break;

		case 0x7A:	/* PLY		65C02 */
			break;

		case 0x7B:
			break;

		case 0x7C:	/* JMP (abs indirect, X)	65C02 */
			break;

		case 0x7D:	/* ADC absolute, X */
			ABSX;
			val = REFptr;
			tmp = A & 0x80;
			stmp = val & 0x80;
			if (D) {
				num = tobinary(val);
				val = tobinary(A);

				val += num + C;
				dCARRY(val);
				while (val >= 100)
					val -= 100;

				A = tobcd(val);
			} else {
				A += val + C;
				CARRY(A);
				A &= 0xFF;
			}
			ZERO(A);
			SIGN(A);
			V = (tmp == stmp) && (tmp != N);
			break;

		case 0x7E:	/* ROR absolute, X */
			ABSX;
			val = REFptr;
			tmp = C;
			C = val & 0x01;
			val = val >> 1;
			val |= tmp << 7;
			SETptr(val);
			SIGN(val);
			ZERO(val);
			break;

		case 0x7F:
			break;

		case 0x80:	/* BRA			65C02 */
			break;

		case 0x81:	/* STA (indirect, X) */
			INDX;
			SETptr(A);
			break;

		case 0x82:
			break;

		case 0x83:
			break;

		case 0x84:	/* STY zero page */
			sZEROP(Y);
			break;

		case 0x85:	/* STA zero page */
			sZEROP(A);
			break;

		case 0x86:	/* STX zero page */
			sZEROP(X);
			break;

		case 0x87:
			break;

		case 0x88:	/* DEY */
			Y--;
			SIGN(Y);
			ZERO(Y);
			break;

		case 0x89:
			break;

		case 0x8A:	/* TXA */
			A = X;
			SIGN(A);
			ZERO(A);
			break;

		case 0x8B:
			break;

		case 0x8C:	/* STY absolute */
			ABSOL;
			SETptr(Y);
			break;

		case 0x8D:	/* STA absolute */
			ABSOL;
			SETptr(A);
			break;

		case 0x8E:	/* STX absolute */
			ABSOL;
			SETptr(X);
			break;

		case 0x8F:
			break;

		case 0x90:	/* BCC */
			if (C) {
				PCINC;
			} else {
				BRANCH();
			}
			break;

		case 0x91:	/* STA (indirect), Y */
			INDY;
			SETptr(A);
			break;

		case 0x92:
			break;

		case 0x93:
			break;

		case 0x94:	/* STY zero page, X */
			sZEROX(Y);
			break;

		case 0x95:	/* STA zero page, X */
			sZEROX(A);
			break;

		case 0x96:	/* STX zero page, Y */
			sZEROY(X);
			break;

		case 0x97:
			break;

		case 0x98:	/* TYA */
			A = Y;
			SIGN(A);
			ZERO(A);
			break;

		case 0x99:	/* STA absolute, Y */
			ABSY;
			SETptr(A);
			break;

		case 0x9A:	/* TXS */
			Sp = X;
			break;

		case 0x9B:
			break;

		case 0x9C:	/* STZ absolute		65C02 */
			break;

		case 0x9D:	/* STA absolute, X */
			ABSX;
			SETptr(A);
			break;

		case 0x9E:	/* STZ absolute, X	65C02 */
			break;

		case 0x9F:
			break;

		case 0xA0:	/* LDY immediate */
			Y = REFimm;
			SIGN(Y);
			ZERO(Y);
			break;

		case 0xA1:	/* LDA (indirect, X) */
			INDX;
			A = REFptr;
			SIGN(A);
			ZERO(A);
			break;

		case 0xA2:	/* LDX immediate */
			X = REFimm;
			SIGN(X);
			ZERO(X);
			break;

		case 0xA3:
			break;

		case 0xA4:	 /* LDY zero page */
			Y = rZEROP;
			SIGN(Y);
			ZERO(Y);
			break;

		case 0xA5:	/* LDA zero page */
			A = rZEROP;
			SIGN(A);
			ZERO(A);
			break;

		case 0xA6:	/* LDX zero page */
			X = rZEROP;
			SIGN(X);
			ZERO(X);
			break;

		case 0xA7:
			break;

		case 0xA8:	/* TAY */
			Y = A;
			SIGN(Y);
			ZERO(Y);
			break;

		case 0xA9:	/* LDA immediate */
			A = REFimm;
			SIGN(A);
			ZERO(A);
			break;

		case 0xAA:	/* TAX */
			X = A;
			SIGN(X);
			ZERO(X);
			break;

		case 0xAB:
			break;

		case 0xAC:	/* LDY absolute */
			ABSOL;
			Y = REFptr;
			SIGN(Y);
			ZERO(Y);
			break;

		case 0xAD:	/* LDA absolute */
			ABSOL;
			A = REFptr;
			SIGN(A);
			ZERO(A);
			break;

		case 0xAE:	/* LDX absolute */
			ABSOL;
			X = REFptr;
			SIGN(X);
			ZERO(X);
			break;

		case 0xAF:
			break;

		case 0xB0:	/* BCS */
			if (C) {
				BRANCH();
			} else {
				PCINC;
			}
			break;

		case 0xB1:	/* LDA (indirect), Y */
			INDY;
			A = REFptr;
			SIGN(A);
			ZERO(A);
			break;

		case 0xB2:	/* LDA (indz)		65C02 */
			break;

		case 0xB3:
			break;

		case 0xB4:	/* LDY zero page, X */
			Y = rZEROX;
			SIGN(Y);
			ZERO(Y);
			break;

		case 0xB5:	/* LDA zero page, X */
			A = rZEROX;
			SIGN(A);
			ZERO(A);
			break;

		case 0xB6:	/* LDX zero page, Y */
			X = rZEROY;
			SIGN(X);
			ZERO(X);
			break;

		case 0xB7:
			break;

		case 0xB8:	/* CLV */
			V = 0;
			break;

		case 0xB9:	/* LDA absolute, Y */
			ABSY;
			A = REFptr;
			SIGN(A);
			ZERO(A);
			break;

		case 0xBA:	/* TSX */
			X = Sp;
			SIGN(X);
			ZERO(X);
			break;

		case 0xBB:
			break;

		case 0xBC:	/* LDY absolute, X */
			ABSX;
			Y = REFptr;
			SIGN(Y);
			ZERO(Y);
			break;

		case 0xBD:	/* LDA absolute, X */
			ABSX;
			A = REFptr;
			SIGN(A);
			ZERO(A);
			break;

		case 0xBE:	/* LDX absolute, Y */
			ABSY;
			X = REFptr;
			SIGN(X);
			ZERO(X);
			break;

		case 0xBF:
			break;

		case 0xC0:	/* CPY immediate */
			tmp = REFimm;
			C = (Y >= tmp);
			tmp = (Y - tmp) & 0xFF;
			SIGN(tmp);
			ZERO(tmp);
			break;

		case 0xC1:	/* CMP (indirect, X) */
			INDX;
			tmp = REFptr;
			C = (A >= tmp);
			tmp = (A - tmp) & 0xFF;
			SIGN(tmp);
			ZERO(tmp);
			break;

		case 0xC2:
			break;

		case 0xC3:
			break;

		case 0xC4:	/* CPY zero page */
			tmp = rZEROP;
			C = (Y >= tmp);
			tmp = (Y - tmp) & 0xFF;
			SIGN(tmp);
			ZERO(tmp);
			break;

		case 0xC5:	/* CMP zero page */
			tmp = rZEROP;
			C = (A >= tmp);
			tmp = (A - tmp) & 0xFF;
			SIGN(tmp);
			ZERO(tmp);
			break;

		case 0xC6:	/* DEC zero page */
			ZEROP;
			stmp = REFzero - 1;
			SETzero(stmp);
			SIGN(stmp);
			ZERO(stmp);
			break;

		case 0xC7:
			break;

		case 0xC8:	/* INY */
			Y++;
			SIGN(Y);
			ZERO(Y);
			break;

		case 0xC9:	/* CMP immediate */
			tmp = REFimm;
			C = (A >= tmp);
			tmp = (A - tmp) & 0xFF;
			SIGN(tmp);
			ZERO(tmp);
			break;

		case 0xCA:	/* DEX */
			X--;
			SIGN(X);
			ZERO(X);
			break;

		case 0xCB:
			break;

		case 0xCC:	/* CPY absolute */
			ABSOL;
			tmp = REFptr;
			C = (Y >= tmp);
			tmp = (Y - tmp) & 0xFF;
			SIGN(tmp);
			ZERO(tmp);
			break;

		case 0xCD:	/* CMP absolute */
			ABSOL;
			tmp = REFptr;
			C = (A >= tmp);
			tmp = (A - tmp) & 0xFF;
			SIGN(tmp);
			ZERO(tmp);
			break;

		case 0xCE:	/* DEC absolute */
			ABSOL;
			stmp = REFptr - 1;
			SETptr(stmp);
			SIGN(stmp);
			ZERO(stmp);
			break;

		case 0xCF:
			break;

		case 0xD0:	/* BNE */
			if (NZ) {
				BRANCH();
			} else {
				PCINC;
			}
			break;

		case 0xD1:	/* CMP (indirect), Y */
			INDY;
			tmp = REFptr;
			C = (A >= tmp);
			tmp = (A - tmp) & 0xFF;
			SIGN(tmp);
			ZERO(tmp);
			break;

		case 0xD2:	/* CMP (indz)		65C02 */
			break;

		case 0xD3:
			break;

		case 0xD4:
			break;

		case 0xD5:	/* CMP zero page, X */
			tmp = rZEROX;
			C = (A >= tmp);
			tmp = (A - tmp) & 0xFF;
			SIGN(tmp);
			ZERO(tmp);
			break;

		case 0xD6:	/* DEC zero page, X */
			ZEROX;
			stmp = REFzero - 1;
			SETzero(stmp);
			SIGN(stmp);
			ZERO(stmp);
			break;

		case 0xD7:
			break;

		case 0xD8:	/* CLD */
			D = 0;
			break;

		case 0xD9:	/* CMP absolute, Y */
			ABSY;
			tmp = REFptr;
			C = (A >= tmp);
			tmp = (A - tmp) & 0xFF;
			SIGN(tmp);
			ZERO(tmp);
			break;

		case 0xDA:	/* PHX		65C02 */
			break;

		case 0xDB:
			break;

		case 0xDC:
			break;

		case 0xDD:	/* CMP absolute, X */
			ABSX;
			tmp = REFptr;
			C = (A >= tmp);
			tmp = (A - tmp) & 0xFF;
			SIGN(tmp);
			ZERO(tmp);
			break;

		case 0xDE:	/* DEC absolute, X */
			ABSX;
			stmp = REFptr - 1;
			SETptr(stmp);
			SIGN(stmp);
			ZERO(stmp);
			break;

		case 0xDF:
			break;

		case 0xE0:	/* CPX immediate */
			tmp = REFimm;
			C = (X >= tmp);
			tmp = (X - tmp) & 0xFF;
			SIGN(tmp);
			ZERO(tmp);
			break;

		case 0xE1:	/* SBC (indirect, X) */
			INDX;
			val = REFptr;
			tmp = A & 0x80;
			stmp = val & 0x80;
			if (D) {
				printf("warning: SBC (indirect, X) in decimal mode\n");
				/*assert(FALSE);*/
			} else {
				foo = A - (val + !C);
				C = (foo >= 0);
				A = foo & 0xFF;
			}
			ZERO(A);
			SIGN(A);
			V = (tmp != stmp) && (tmp != N);
			break;

		case 0xE2:
			break;

		case 0xE3:
			break;

		case 0xE4:	/* CPX zero page */
			tmp = rZEROP;
			C = (X >= tmp);
			tmp = (X - tmp) & 0xFF;
			SIGN(tmp);
			ZERO(tmp);
			break;

		case 0xE5:	/* SBC zero page */
			val = rZEROP;
			tmp = A & 0x80;
			stmp = val & 0x80;
			if (D) {
				printf("warning: SBC zero page in decimal mode\n");
				/*assert(FALSE);*/
			} else {
				foo = A - (val + !C);
				C = (foo >= 0);
				A = foo & 0xFF;
			}
			ZERO(A);
			SIGN(A);
			V = (tmp != stmp) && (tmp != N);
			break;

		case 0xE6:	/* INC zero page */
			ZEROP;
			stmp = REFzero + 1;
			SIGN(stmp);
			ZERO(stmp);
			SETzero(stmp);
			break;

		case 0xE7:
			break;

		case 0xE8:	/* INX */
			X++;
			SIGN(X);
			ZERO(X);
			break;

		case 0xE9:	/* SBC immediate */
			val = REFimm;
			tmp = A & 0x80;
			stmp = val & 0x80;
			if (D) {
				printf("warning: SBC immediate in decimal mode\n");
				/*assert(FALSE);*/
			} else {
				foo = A - (val + !C);
				C = (foo >= 0);
				A = foo & 0xFF;
			}
			ZERO(A);
			SIGN(A);
			V = (tmp != stmp) && (tmp != N);
			break;

		case 0xEA:	/* NOP */
			break;

		case 0xEB:
			break;

		case 0xEC:	/* CPX absolute */
			ABSOL;
			tmp = REFptr;
			C = (X >= tmp);
			tmp = (X - tmp) & 0xFF;
			SIGN(tmp);
			ZERO(tmp);
			break;

		case 0xED:	/* SBC absolute */
			ABSOL;
			val = REFptr;
			tmp = A & 0x80;
			stmp = val & 0x80;
			if (D) {
				printf("warning: SBC absolute in decimal mode\n");
				/*assert(FALSE);*/
			} else {
				foo = A - (val + !C);
				C = (foo >= 0);
				A = foo & 0xFF;
			}
			ZERO(A);
			SIGN(A);
			V = (tmp != stmp) && (tmp != N);
			break;

		case 0xEE:	/* INC absolute */
			ABSOL;
			stmp = REFptr + 1;
			SETptr(stmp);
			SIGN(stmp);
			ZERO(stmp);
			break;

		case 0xEF:
			break;

		case 0xF0:	/* BEQ */
			if (NZ) {
				PCINC;
			} else {
				BRANCH();
			}
			break;

		case 0xF1:	/* SBC (indirect), Y */
			INDY;
			val = REFptr;
			tmp = A & 0x80;
			stmp = val & 0x80;
			if (D) {
				printf("warning: SBC (indirect),Y in decimal mode\n");
				/*assert(FALSE);*/
			} else {
				foo = A - (val + !C);
				C = (foo >= 0);
				A = foo & 0xFF;
			}
			ZERO(A);
			SIGN(A);
			V = (tmp != stmp) && (tmp != N);
			break;

		case 0xF2:	/* SBC (indz)		65C02 */
			break;

		case 0xF3:
			break;

		case 0xF4:
			break;

		case 0xF5:	/* SBC zero page, X */
			val = rZEROX;
			tmp = A & 0x80;
			stmp = val & 0x80;
			if (D) {
				printf("warning: SBC zero page,X in decimal mode\n");
				/*assert(FALSE);*/
			} else {
				foo = A - (val + !C);
				C = (foo >= 0);
				A = foo & 0xFF;
			}
			ZERO(A);
			SIGN(A);
			V = (tmp != stmp) && (tmp != N);
			break;

		case 0xF6:	/* INC zero page, X */
			ZEROX;
			stmp = REFzero + 1;
			SETzero(stmp);
			SIGN(stmp);
			ZERO(stmp);
			break;

		case 0xF7:
			break;

		case 0xF8:	/* SED */
			D = 1;
			break;

		case 0xF9:	/* SBC absolute, Y */
			ABSY;
			val = REFptr;
			tmp = A & 0x80;
			stmp = val & 0x80;
			if (D) {
				printf("warning: SBC absolute,Y in decimal mode\n");
				/*assert(FALSE);*/
			} else {
				foo = A - (val + !C);
				C = (foo >= 0);
				A = foo & 0xFF;
			}
			ZERO(A);
			SIGN(A);
			V = (tmp != stmp) && (tmp != N);
			break;

		case 0xFA:	/* PLX		65C02 */
			break;

		case 0xFB:
			break;

		case 0xFC:
			break;

		case 0xFD:	/* SBC absolute, X */
			ABSX;
			val = REFptr;
			tmp = A & 0x80;
			stmp = val & 0x80;
			if (D) {
				printf("warning: SBC absolute,X in decimal mode\n");
				/*assert(FALSE);*/
			} else {
				foo = A - (val + !C);
				C = (foo >= 0);
				A = foo & 0xFF;
			}
			ZERO(A);
			SIGN(A);
			V = (tmp != stmp) && (tmp != N);
			break;

		case 0xFE:	/* INC absolute, X */
			ABSX;
			stmp = REFptr + 1;
			SETptr(stmp);
			SIGN(stmp);
			ZERO(stmp);
			break;

		case 0xFF:
			break;
		}
	} while (running);

	if (show_flags)
		flags(logging_fp);
    } while (tracing);
}
 

SHAR_EOF
fi # end of overwriting check
echo shar: extracting "'Cli.doc'" '(5168 characters)'
if test -f 'Cli.doc'
then
	echo shar: will not over-write existing file "'Cli.doc'"
else
cat << \SHAR_EOF > 'Cli.doc'

CLI Basics
----------
The ~ key (default value) will break the emulation and put the User into 
the Command Language Interpreter (CLI). The CLI prompt is >>> .  The 
user may type ? to see a list of available commands in the CLI. The CLI 
allows partial completion of commands.  The partial command name must 
be unambiguous.  For instance, "e" or "exam" may be 
substituted for "examine".

General Commands
----------------

cd [path]	- With no paramters, displays current working directory (CWD).
		  Otherwise attempts to set the CWD to path.

continue or c	- Resume the emulation and refresh the screen.

escape [char]	- Make the character which breaks the emulator into char or
		  display current escape char.

dup l|p		
pop l|p	
push l|p|addr
		- The CLI maintains a value stack for the convenience of 
	 	  the user.  The emulator doesnt use the stack at all.
		  Values may be pushed on the stack with push and
		  retrieved later with pop or dup.  The l and p parameters
		  are used to retrive/store values into the lpoint (list
		  point) and pc.

help		- Gives a quick list of commands

map		- Toggle lower to uppercase mapping during emulation.  The
		  default is to perform mapping.

quit     	- Exit the Emulator

.        	- Display the current point

![command]	- Unix Shell escape.  Without command, the shell is called.
	 	  Otherwise, command is executed.

File Commands
-------------

bload file addr
      -  Bload will Allow the loading of binary images into the memory of
         the emulator.  bload binfile F000  will load file "binfile" at
	 address F000.

bsave file addr1 size
       - Bsave will save a section of memory to a file.  For instance,
  	 bsave mybin 300 FF  will save all of the memory from 300 to 3FF
	 to file "mybin".

disk
       - Display the names of the disks which are currently inserted in
	 the virtual disk drives.

insert file [drive#]
       - Insert will make a file the disk in a particular drive. For 
         Instance: insert mydisk  will make the file "mydisk" appear
  	 to the emulator as the disk in drive 1.

Register Manipulation
---------------------

cl[cdinvz] - Clears Status register bit.  For instance, clc will clear
	     the carry bit.  clz will clear the zero bit.

se[cdinvz] - Set Status register bit.  For instance, sec will set the
	     carry flag.  sez will set the zero bit.

ld[axys] value 
	   - Load a value into a register.  lda ff will load ff into
	     the accumulator.  lds 02 will load 02 into the Stack Pointer.

jmp addr
	   - Sets PC = addr.  A continue will resume at that location.

reset or ~
	   - Sets PC = addr in the Apple II reset Vector.  Combined
	     with continue, will emulate the pressing of the reset
	     button on the Apple II.

Memory Manipulation/Examination
-------------------------------

examine addr [addr]
	   - Display current memory location if no paramters are givin.
	     If one parameter is givin, the contents of that location are
	     displayed.  If two parameters are givin, all memory between
	     the two locations is displayed. examine 300 400 will display
	     all memory between $300 and $400. e 300 will display the
	     8 bit contents of $300

deposit addr value [value]+
	   - Put values into memory.  Addr must be specified as well as
	     one or more values.  Deposit 300 20  will put 20 into memory
	     location 300.  Deposit 300 10 20 30 40 will load 10,20,30,40
	     into consequtive addresses beginning at 300.

list [low] [high]
	   - Dissassembly.  If noparameters are supplied, dissassembly
	     begins at the current point and continues for 1 page. If
	     low is specified, dissassembly begins at low and continues
	     for 1 page.  If both low and high are specified the region
	     between low and high is dissassembled.

Debugging Commands
------------------

breakpoint [addr]
	   - Set breakpoint.  If addr is not specified, the current
	     breakpoint is displayed.  Otherwise, the breakpoint is set
	     to addr.  When PC == addr, the emulator breaks into the
	     command mode.  break 3FFF   sets the breakpoint to 3FFF.

nobreak	   - Turn of breakpoint.

trace [low high] [file]
	   - Enable tracing.  With no parameters, the current trace status
	     is displayed.  When low and high are givin, tracing for that
	     region is enabled (i.e. when low <= pc <= high ).  An output
	     consisting of dissassembly and status registers is written to
	     the trace file.  If file is specified, output is sent to that
	     file, otherwise the file "trace" is used. For instance,
	     trace 3F0 400  will trace the region of 3F0-400 and send its
	     output to trace.

notrace	   - Disable tracing.

phantom location high low [file]
	   - Enable phantom tracing of range low,high.  Phantom tracing
	     allows a trace to be performed AFTER location is reached.
	     For instance, phantom 300 F300 F400 will enable tracing of
	     f300-f400 only AFTER PC == 300. Once the PC has reached 300,
	     tracing between F300-F400 is enabled.  If file is specified
	     trace output will go to the specified file.  Otherwise, "trace"
	     is assumed.
nophantom
	   - disable phantom trace.

SHAR_EOF
fi # end of overwriting check
echo shar: extracting "'grey.pat'" '(335 characters)'
if test -f 'grey.pat'
then
	echo shar: will not over-write existing file "'grey.pat'"
else
cat << \SHAR_EOF > 'grey.pat'
....
....
....
....

*..*
*.*.
.*.*
*..*

*.*.
*.*.
.*.*
.*.*

**..
..**
**..
..**

**..
**..
..**
..**

*...
.*..
..*.
...*

...*
..*.
.*..
*...

*.*.
....
*.*.
....

....
****
....
****

.*.*
.*.*
.*.*
.*.*

.**.
****
****
.**.

.*.*
****
.*.*
****

*..*
..**
.**.
**..

*..*
**..
.**.
..**

*.*.
.*.*
*.*.
.*.*

****
****
****
****
SHAR_EOF
fi # end of overwriting check
#	End of shell archive
exit 0

