lection = room {
	nam = 'Лекция Белина',
	pic = 'gfx/lection.png',
	dsc = [[Я пробираюсь к месту и сажусь... Отсюда хорошо слышно — послушаем именитого физика... — Думаю я... ^^Итак, в ноябре 1935г. Шредингер опубликовал статью, 
в которой проводился следующий мысленный эксперимент — продолжал Белин —
в чем суть эксперимента? — С этими словами Белин вытащил и поставил на стол
ящик странного вида — Люблю опыты — белоснежная улыбка тускло блеснула в свете ламп —
Как вы можете видеть, это — ящик — Белин похлопал ладонью 
по гладкой поверхности. — В ящик встроена капсула с ядовитым газом 
Кроме того, в статико-динамическом поле ящика находятся счетчик радиации, 
изотопный элемент и таймер. Параметры эксперимента подобраны так, что вероятность того, что ядро распадётся за 1 час, составляет 50%.^^


Если ядро распадается, оно приводит механизм в действие, он открывает ёмкость с газом. —
Пока все просто — не так ли, господа? — Улыбается Белин — но дело в том, 
что Шредингер в своем эксперименте помещает в ящик кота — живое существо. ^^

Согласно квантовой механике, если над ядром не производится наблюдения, то его состояние описывается суперпозицией (смешением) двух состояний — распавшегося ядра и нераспавшегося ядра, следовательно, кот, сидящий в ящике, и жив, и мёртв одновременно. — Белин повышает голос. — можно сказать, что это просто игры разума, отвлеченная лирика, но я покажу и докажу, что это не совсем так... ^^

— Итак, если ящик открыть, то экспериментатор обязан увидеть только какое-нибудь одно конкретное состояние — <<ядро распалось, кот мёртв>> или <<ядро не распалось, кот жив>>. Сам Шредингер думал, что его парадокс доказывает несостоятельность квантовой механики, но мы-то с вами знаем, что квантовая механика и есть истинное представление о нашем мире — снова повышает тон голоса Белин — и вот, независимо друг от друга, что доказывает отчасти истинность предположения — Ганс Моравек в 1987 и Бруно Маршал в 1988 рассмотрели ситуацию с точки зрения самого кота!^^

— Если верна многомировая интерпретация Эверетта, то в результате каждого проведенного эксперимента с котом вселенная расщепляется на две вселенных, в одной из которых кот остается жив, а в другой погибает. В мирах, где кот умирает, он перестает существовать. Напротив, с точки зрения неумершего кота, эксперимент будет продолжаться, не приводя к исчезновению кота. Это происходит потому, что в любом ответвлении кот способен наблюдать результат эксперимента лишь в том мире, в котором он выживает. И если многомировая интерпретация верна, то кот может заметить, что он никогда не погибнет в ходе эксперимента... — Белин замолкает и осматривает зал... ^^

— Но что вытекает из этого, господа? Я спрашиваю, что из этого вытекает? — Представим, что участник эксперимента взрывает ядерную бомбу вблизи себя. С точки зрения многомировой интерпретации, практически во всех параллельных вселенных ядерный взрыв уничтожит участника. Но, несмотря на это, должно существовать небольшое множество альтернативных вселенных, в которых участник каким-либо образом выживает. И мы переходим к идее — Белин снова поднял голос — идее квантового бессмертия!!! ^^

— Идея квантового бессмертия состоит в том, что участник остаётся в живых, и тем самым способен воспринимать окружающую реальность, по меньшей мере в одной из вселенных в множестве, пусть даже количество таких вселенных пренебрежимо мало в сравнении с количеством всех возможных вселенных. Таким образом, со временем участник обнаружит, что он может жить вечно!!! ^^

Мы все с вами тяжело работали этот год, под четким руководством... — тут Белин бросил взгляд в сторону портретов — и должен вам сказать, что информации в нашем информационном центре — Белин посмотрел в потолок — достаточно, чтобы доказать, я повторяю, научно доказать теоретически и экспериментально истинность многомировой интерпретации... — Но что это значит для нас? — Вы не можете этого видеть, но — Белин смотрит на часы — уже через несколько минут состав с ураном прибывает к задним воротам института... Урана хватит для того, чтобы обеспечить каждого из вас ядерной бомбой. Так как вы скоро убедитесь в том, что квантовое бессмертие это реальность, то каждый из нас сможет стать непобедимым террористом!!! Вселенная расщепится на множество миров, в каждом из которых Вы — палец Белина указывает в зал — будете его диктатором и господином!!! — Белин почти кричал...^^

Зал не выдержал и взревел. Люди вставали и хлопали... Их глаза горели каким-то бешеным огнем... О Боже, — подумал я — это какое-то наваждение... Мои ноги не слушались меня — я сидел на своем месте и не мог пошевелиться...^^

Но я отвлекся — говорит Белин — продолжим наш опыт. С этими словами он достал из-под стола живой комочек... Это был мой Барсик... — Сейчас я помещу эту кошку в ящик и мы с вами... — красная пелена застилает мои глаза...
	]],
	enter = function(s)
	-- end of episode 2
		eside = nil;
		moika = nil;
		eating = nil;
		kitchen = nil;
		stolcorridor = nil;
		entrance = nil;
		floor2 = nil;
		eroom = nil;
		room33 = nil;
		room3x = nil;
		cor3 = nil;
		toilet3 = nil;
		floor3 = nil;
		toilet = nil;
		toiletw = nil;
		room4x = nil;
		room46 = nil;
		hall42 = nil;
		hall41 = nil;
		floor4 = nil;
		floor5 = nil;
		povardlg = nil;
		kitchendlg = nil;
		facectrl = nil;
	end,
	act = function(s, w)
		if w == 1 then
			set_music("mus/under.s3m");
			return walk('escape1');
		end
	end,
	obj = {
		vobj(1, 'дальше', '{Дальше}.'),
	};
};

profdlg = dlg {
	nam = '!!!',
	pic = 'gfx/me.png',
	dsc = 'Я собираюсь с силами, встаю и во всю глотку кричу...',
	obj = {
		[1] = phr('Это кот, а не кошка!', 
	'— Рука Белина останавливается — его взгляд фокусируется на мне — он узнает меня!! — Охрана — в зале посторонний!!! Убе... Уберите его!!! — кричит он..', 
	[[poff(2);escape1.obj:add('guardian')]]),
		[2] = phr('Не трогай моего кота!', 
	'— Белин замирает, затем смотрит мне прямо в глаза — его лицо выражает удивление — Охрана!!! Охрана!!! В зале посторонний!!!',
	[[poff(1);escape1.obj:add('guardian')]]),
	},
};

profdlg2 = dlg {
	nam = 'Белин',
	pic = 'gfx/prof2.png',
	dsc = 'Белин бледен. Он смотрит на дробовик рассеянным взглядом.',
	obj = {
		[1] = phr('Я пришел за своим котом.', 
	'Я выхватываю Барсика из руки Белина и засовываю себе за пазуху.',
		[[inv():add('mycat'); lifeon('mycat')]]),
		[2] = phr('Скажи им, чтобы расходились!!!', 
	'— Белин бледен, похоже он не понимает меня...',
		[[pon(3)]]),
		[3] = _phr('Ну же!!! Скажи им, чтобы расходились...', 'Я трясу его. Белин не чувствует, он лишь смотрит на черные стволы дробовика.',[[pon(3); back();]]);
	},
};
gdlg1 = dlg {
	nam = 'охранник',
	pic = 'gfx/guard42.png',
	dsc = 'Я кричу охраннику и не узнаю свой голос...',
	obj = {
	[1] = phr('Положи свое ружье прикладом вперед на стол и толкни его сюда..',
		'Охранник неуверенно смотрит на меня..',
		[[pon(2)]]),
	[2] = _phr('Я сказал на стол ружье!!! — я посильнее надавливаю стволами на Белина — он близок к обмороку.', 'Охранник осторожно кладет помповое ружье на стол и толкает его ко мне... — я быстро забираю ружье. Теперь в левой руке у меня обрез, в правом — помповое ружье.',
		[[pon(3); inv():add('shotgun')]]),
	[3] = phr('Не нравилось тебе мое лицо да?? Дааа???',
		'Охранник молчит, на его лбу выступает пот...',
		[[pon(3); back();]]),
	};
};

shotgun = obj {
	nam = 'ружье',
	inv = 'Помповое ружье... На 6 зарядов. Интересно, сколько там осталось?',
	dsc = 'На полу валяется помповое {ружье}.',
	tak = function(s)
		if s._unloaded then
			return 'Оно мне больше не нужно. Полностью разряжено.', false
		end
		return 'Я беру свое ружье обратно.';
	end,
};

guardian = obj {
	nam = 'охранник',
	dsc = function(s, w)
		if not professor._gun then
			return 'Я вижу как {охранник} с помповым ружьем медленно, но верно пробирается к моему месту.';
		end
		if have('shotgun') then
			return 'Я вижу обезоруженного {охранника}, внимательно смотрящего на меня.';
		end
		return 'Я вижу {охранника}, неуверенно держащего в руках помповое ружье.';
	end,
	act = function(s, w)
		if not professor._gun then
			return 'Скоро он доберется до меня...';
		end
		return walk('gdlg1');
	end,
	used = function(s, w)
		if w == 'shotgun' then
			return 'Нет, я не могу пойти на это...';
		end
		if w == 'gun' then
			if not professor._gun then
				return 'Мой обрез не для дальнего боя...';
			end
			return 'Я опасаюсь отводить обрез от Белина, к тому же, потом мне придется его перезаряжать...';
		end
	end
};

professor = obj {
	nam = 'Белин',
	dsc = function(s, w)
		if not s._gun then
			return 'Перед доской стоит {Белин} и держит в руке моего Барсика.';
		end
		return 'Я упираюсь обоими стволами дробовика в грудь {Белина}.';
	end,
	act = function(s)
		if not s._gun then
			return walk('profdlg');
		end
		return walk('profdlg2');	
	end,
	used = function(s, w)
		if w == 'gun' then
			if s._gun then
				return 'Я еще сильнее надавливаю обоими стволами на грудь Белина.';
			end
			s._gun = true;
			objs():add('guardian');
			gun._hidden = false;
			return 'Я достаю обрез из-под одежды и, перепрыгивая через стол, бросаюсь к Белину.';
		end
	end,
};
pdlg = dlg {
	nam = 'люди',
	pic = 'gfx/me.png',
	dsc = 'Я смотрю в зал и кричу...',
	obj = {
		[1] = phr('Вас обманывают!!! Никакого доказательства нет!!!',
			'— никакой реакции...',[[pon(2)]]),
		[2] = _phr('Мир един!!! Каждый из вас знает об это с детства!!! Уходите отсюда!! Бегите от этих сектантов!!!', ' — ответом мне было молчание...'),
		[3] = phr('Стадо баранов!!! Неужели вас так легко обмануть???',
			'— они молчат — и мне не нравится их взгляды...',
			[[pon(3); back();]]),
	},
};
narod = obj {
	nam = 'люди',
	dsc = function(s)
		if not professor._gun then
			if seen('guardian') then
				return '{Люди} в зале смотрят на меня с недоумением. Они в замешательстве.';
			end
			return '{Люди} в зале следят за Белиным.';
		end
		return '{Люди} в зале замерли. Они не спускают с меня взгляд. Если я ошибусь — мне конец... И всему миру...';
	end,
	act = function(s)
		if professor._gun then
			return walk('pdlg');
		end
		if seen('guardian') then
			return 'Пока они на меня не бросились и это хорошо...';
		end
		return 'Фанатики, они фанатики...';
	end,
	used = function(s, w)
		if w == 'gun' or w =='shotgun' then
			return 'Я думаю, что патронов не хватит.';
		end
		return 'Увы...';
	end
};

win = obj {
	nam = 'окно',
	dsc = function(s)
		local st = '';
		if s._broken then
			st = ' Одно из окон разбито.';
		end
		return 'Три широких {окна} выходят на запад.'..st;
	end,
	act = 'За окнами тьма... Только белые снежинки изредка попадают в зону освещения флоуресцентных ламп.';
	used = function(s, w)
		if w ~= 'gun' and w ~= 'shotgun' then
			return 'Не поможет...';
		end
		if s._broken then
			return 'Уже разбито...';
		end
		if not have('shotgun') then
			return 'Охранник подстрелит меня..';
		end
		s._broken = true;
		ways():add('window');
		return 'Я разбиваю прикладом ближайшее окно...';
	end	
};

escape1 = room {
	nam = 'Зал 2',
	dsc = 'Я нахожусь в зале. Люди в зале ждут продолжения эксперимента.',
	pic = function()
		if professor._gun then
			return 'gfx/meandgun.png';
		end
		return 'gfx/lection2.png';
	end,
	obj = {
		'win',
		vobj(4, 'лампы', 'Зал освещают флоуресцентные {лампы}.'), 
		'professor',
		'narod',
		vobj(5, 'ящик', 'На столе стоит {ящик}.'),
		'portrait',
	},
	act = function(s, w)
		if w == 5 then
			return 'Проклятая коробка...';
		end
		if w == 4 then
			return 'Шесть ламп... Ненавижу этот мерцающий свет...';
		end
	end,
	used = function(s, w, ww)
		if ww == 'gun' or ww == 'shotgun' then
			if not professor._gun then
				return 'Не стоит...';
			end
			if w == 4 then
				return 'Темнота поможет не только мне, но и им... А их больше...';
			end
			if w == 5 then
				return 'Там яд. Я боюсь навредить моему Барсику.';
			end
		end
	end,
	exit = function(s, t)
		if t == 'window' and not have('mycat') then
			return 'А как же Барсик?', false
		end
		if t == 'cor4' then
			return 'Я должен что-то сделать сейчас же!', false;
		end
	end,
	way = { 'cor4' },
};
lest = obj {
	nam = function(s, w)
		if s._seen then
			return 'лестница';
		else
			return 'нечто';
		end
	end,
	dsc = function(s, w)
		if s._seen then
			return 'За метелью я едва различаю пожарную {лестницу}!';
		end
		return 'За метелью я едва различаю контуры какой-то {конструкции}.';
	end,
	act = function(s, w)
		if not s._seen then
			ways():add('ladder');
			s._seen = true;
			return 'Это же пожарная лестница!!!';
		end
		return 'Прыгать или нет? Вот в чем вопрос...';
	end,
};

window = room {
	nam = function(s)
		if here() == window then
			return 'на подоконнике';
		end
		return 'в окно';
	end,
	pic = 'gfx/fromwin1.png',
	enter = "Это безумие, но все же я бросаюсь к окну... За спиной я слышу рев толпы...";
	dsc = 'Я стою на подоконнике и всматриваюсь в ночную пустоту.',
	obj = {
		'lest',
	},
	exit = function(s, t)
		if t == 'escape1' then
			return 'Мне нельзя назад... Там толпа фанатиков...', false;
		end
	end,
	way = { 'escape1',},
};

down = room {
	nam = 'вниз';
};

window5 = obj {
	nam = 'окно',
	dsc = function(s, w)
		if s._broken then
			return 'Слева от меня, разбитое {окно}.';
		end
		return 'Слева от меня желтый огонек {окна}.';
	end,
	act = function(s)
		if not s._broken then
			return 'Окно закрыто...';
		end
		return walk('room5');
	end,
	used = function(s, w)
		if w == 'gun' or w == 'shotgun' then
			if s._broken then
				return 'Уже разбито...';
			end
			s._broken = true;
			return 'Я выбиваю стекло прикладом... Осколки стекла падают в темноту...';
		end
	end
};


up = room {
	_num = 0;
	nam = 'наверх',
	enter = function(s, w)
		s._num = s._num + 1;
		if s._num == 2 then
			lifeon('ladder');
			return 'Внезапно, ночную тьму разрезает луч прожектора и тишину нарушает вой сирены... Похоже, внизу меня заметили...', false;
		end
		if s._num > 4 then
			ladder.way:del('up');
			ladder.obj:add('window5');
		end
		return 'Я медленно ползу вверх...', false;
	end
};

ladder = room {
	nam = 'лестница',
	pic = 'gfx/ladder.png',
	dsc = [[Я стою на холодной лестнице. Ледяные иголки снежинок больно ударяются о мое лицо.]],
	act = function(s, w)
		if w == 1 then
			return 'Я скоро окоченею... Надо двигаться..';
		end
	end,
	obj = {
		vobj(1, 'поручни', 'В моих руках железные {поручни}.'),
	};
	enter = function(s)
		inv():del('gun');
		return [[Я разбегаюсь и прыгаю... Несколько секунд мое сердце сжимается, но я чувствую тепло Барсика за пазухой и уже в следующий миг мои руки хватаются за черную сталь... Дробовик срывается с моего плеча и летит вниз...]];
	end,
	way = { 'up', 'down' },
	life = function(s)
		if rnd(2) == 1 then
			return 'Я слышу треск автоматных очередей — несколько пуль проходят совсем рядом...';
		end
	end,
	exit = function(s, t)
		if t == 'down' then
			if s._shoot then
				return 'Меня убьют... И Барсика... И разрушат весь мир...', false;
			end
			lifeon('ladder');
			s._shoot = true;
			return 'Я начинаю спускаться вниз, когда ночную тьму вдруг разрезает луч прожектора и тишину нарушает вой сирены... Похоже, внизу меня заметили...', false;
		end
		if t ~= 'up' then
			lifeoff('ladder');
		end
	end
};

hand = obj {
	nam = 'кровавая рука',
	inv = 'Моя рука кровоточит... Мне кажется, что скоро я потеряю сознание...',
	life = 'Капли крови падают с моей правой руки на пол...',
	used = function(s, w)
		if w == 'galstuk' then
			inv():del('galstuk');
			inv():del('hand');
			lifeoff('hand');
			return 'Я перевязываю руку галстуком... Пока сойдет...';
		end
	end
};

computers = obj {
	nam = 'компьютеры',
	dsc = 'Большую площадь занимают высокие стойки с компьютерным {оборудованием}. Тихое жужжание вентиляторов едва слышно. Нервно подмигивают лампочки сетевого оборудования.';
	act = function(s)
		if kover._fire then
			return 'Ну что же... Гори, зло, гори!!! Пора выбираться отсюда.';
		end
		return 'Это оборудование хранит зло... Мне нужно уничтожить все это, но как? Из своего прошлого я знаю, что самый надежный способ уничтожить информацию на магнитных носителях — провести ее через точку Кюри, другими словами — сжечь это все к чертям собачьим... Но где мне взять огонь?';
	end,
	used = function(s, w)
		if w == 'shotgun' then
			return 'Расстрелять серверы? Ненадежно... Я должен сжечь это зло...';
		end
	end
};

poroh = obj {
	nam = 'порох',
	inv = 'Этот порох должен мне помочь.',
};

trut = obj {
	nam = 'трут',
	inv = 'Кусок газеты с порохом. Да это же трут!!!',
	use = function(s, w)
		if w == 'ibp' and ibp._knife and not ibp._trut then
			ibp._trut = true;
			inv():del('trut');
			return 'Я кладу трут на ИБП.';
		end
	end
};
fire = obj {
	nam = 'огонь',
	inv = 'Бумажка быстро горит... Надо что-то делать!!!',
	use = function(s, w)
		if w == 'poroh' then
			return 'Рванет прямо в руке.';	
		end
		if w == 'news' then
			return 'Я отрываю еще кусок от газеты. Пламя перекидывается на него.';
		end
		inv():del('fire');
		if w ~= 'kover' then
			return 'Бумага догорает и гаснет...';
		end
		if kover._fire then
			return 'Я кидаю бумажку на горящий ковер...';
		end
		kover._fire = true;
		return 'Я кладу бумагу на ковер... Волоски ковра вспыхивают... Похоже, начинается пожар..';
	end
};

ibp = obj {
	nam = 'ИБП',
	dsc = 'Один разобранный {ИБП} валяется на полу.',
	inv = function(s)
		if not s._knife then
			return 'Это источник бесперебойного питания. Что мне с ним делать?';
		end
		local st = '';
		if s._trut then
			st = ' На батарее лежит бумага с порохом.';
		end
		return 'Разобранный ИБП. Я вижу клеммы, ведущие к батарее...'..st;
	end,
	act = function(s)
		if not have('ibp') then
			if not have('fire') and not kover._fire then
				take('ibp');
				return 'Я снова беру ИБП в руки.';
			end
			return 'Мне он больше не нужен.';
		end
		return s:inv();
	end,
	used = function(s, w)
		if not have('ibp') then
			return 'Не сработает...';
		end
		if w == 'knife' then
			s._knife = true;
			return 'Я раскручиваю винты и разбираю ИБП. Теперь я вижу клеммы, ведущие к батарее...';
		end
		if w == 'provodki' and s._knife then
			if not provodki._knife then	
				return 'Проводки не оголены.';
			end
			if not s._trut then
				return 'Я подсоединяю проводки к клеммам и замыкаю усики проводов — от замыкания проскакивает искра. Нужен трут...';
			end
			drop('ibp');
			ibp._trut = false;
			inv():add('fire');
			return 'Я подсоединяю проводки к клеммам и замыкаю усики проводов. Проскакивает искра и перекидывается на трут. Трут вспыхивает!!! Огонь!!!';
		end
		if w == 'provod' then
			return 'Я вставил, а затем снова вытащил провод из ИБП... Хммм...';
		end
	end,
};

provodki = obj {
	nam = 'тонкие проводки',
	inv = function(s)
		if s._knife then
			return 'Пара тонких проводков с усиками на конце.'
		end
		return 'Пара тонких проводков.'
	end,
	used = function(s, w)
		if w == 'knife' and not s._knife then
			s._knife = true;
			return 'Я отрезаю изоляцию с концов проводка и достаю тоненькие усики.';
		else
			return 'Не сработает...';
		end
	end
};

provod = obj {
	nam = 'провод от ИБП',
	inv = 'Это провод от ИБП.',
	used = function(s, w)
		if w == 'knife' then
			if not knife._oster then
				return 'Лезвие ножа слишком тупое...';
			end
			inv():del('provod');
			inv():add('provodki');
			return 'Я разрезаю оплетку и достаю две жилы провода.'
		end
	end
};

ups = obj {
	nam = 'ибп',
	dsc = 'Множество {источников бесперебойного питания} стоят у каждой стойки.',
	act = function(s)
		if have('hand') then
			return 'У меня поранена рука. Кровь так и хлещет, я не могу таскать ИБП.';

		end
		if not have('ibp') and not seen('ibp') then
			inv():add('ibp');
			inv():add('provod');
			return 'Немного порывшись я отсоединяю один из источников и держу его в руках...';
		end
		return 'Я уже брал один UPS.';
	end,
};

kover = obj {
	nam = 'ковер',
	dsc = function(s)
		if s._fire then
			return '{Ковер} на полу занимается пламенем.';
		end
		return 'На полу постелен красный {ковер}.';
	end,
	act = 'Ненужная роскошь.',
};

room5 = room {
	nam = 'центр информации';
	pic = 'gfx/servers.png',
	dsc = [[Я в огромном помещении, занимающем всю южную часть института.]],
	enter = function(s, f)
		if f == 'ladder' then
			set_music('mus/hybrid.xm');
			lifeon('hand');
			inv():add('hand');
			return 'Я прыгаю и хватаюсь за раму окна. Моя правая рука в крови. Не обращая внимания на боль, я спрыгиваю на пол комнаты...';
		end
	end,
	exit = function(s, f)
		set_music("mus/under.s3m");
	end,
	act = function(s, w)
		if w == 1 then
			return 'Я не полезу назад... Там холодно и стреляют...';
		end
	end,
	obj = { 'computers', 'ups',
		vobj(1, 'окно', 'В разбитое {окно} дует холодный зимний ветер.'),
		'kover',
		'dout',
		'portrait',
	},
};
dout = obj {
	nam = 'дверь',
	dsc = function(s)
		return 'Далеко впереди я могу видеть выходную {дверь}.'
	end,
	act = function(s)
		if not kover._fire then
			return 'Это центр обработки информации. Я должен уничтожить его, чтобы спасти мир от заразы, что хранится в недрах его накопителей...';
		end
		return 'Я подбегаю к двери. Дверь ведет на площадку пятого этажа и она электронная!!! Это значит, что открыть я ее могу только с помощью карточки с требуемым уровнем доступа. Я сгорю?';
	end,
	used = function(s, w)
		if not kover._fire then
			return s:act();
		end
		if w == 'card' then
			return 'Я подношу карточку к двери. Биип — в доступе отказано! Я сгорю здесь!!!';
		end
		if w == 'shotgun' then
			return walk('escape2');
		end
		return 'Не поможет...';
	end
};

handgdlg = dlg {
	nam = 'охранник',
	pic = 'gfx/handhoh.png',
	dsc = 'Охранник — еще молодой парень лет 30 — смотрит на меня. Он растерян.',
	obj = {
	[1] = phr('Отдай мне свое оружие!', '— Я без оружия — качает охранник головой... Не знаю верить ему или нет, но обыскивать его мне не хочется...'),
	[2] = phr('Мне нужен ключ от красной двери.', 'Охранник бледнеет. — Ни у кого нет ключа от ЭТОЙ двери. — произносит он. — Что за чушь? — Думаю я.'),
	[3] = phr('Ок! Просто стой и не дергайся.', 'Охранник молча смотрит на меня.',
		[[pon(3);back();]]),
	},
};

win5 = obj {
	nam = 'окно',
	dsc = function (s)
		if s._broken then
			return 'В разбитое {окно} завывает зимний ветер. Снежинки вихрем залетают на этаж.';
		end
		return 'Широкое {окно} выходит на запад.';
	end,
	act = function(s)
		if not s._broken then
			return 'Я подхожу к окну... Любопытно, я вижу, что окно выходит на довольно широкий участок крыши, который проходит через фронтальную часть здания...';
		end
		return 'Окно разбито... Третье за сегодня.';
	end,
	used = function(s, w)
		if s._broken then
			return s:act();
		end
		if w == 'shotgun' then
			s._broken = true;
			ways():add('krysha');
			return 'Уххх.... Третье окно за сегодня... Я размахиваюсь и осколки стекла вылетают на крышу...';
		end
	end,
};

escape2 = room {
	_timer = 0,
	nam = 'площадка 5-го этажа',
	pic = 'gfx/floor5e.png',
	dsc = [[Потолки на пятом этаже очень высокие.]],
	enter = function(s, f)
		if f == 'room5' then
			lifeon('escape2');
			return 'В бессилии я бью прикладом в ненавистную дверь. И вдруг, через несколько секунд слышу, как кто-то подходит к двери с внешней стороны... Это охранник!!! Писк срабатывания считывателя — и вот, дверь открывается. Охранник пятится — ему в грудь упирается ствол помпового ружья. Мы выходим на площадку пятого этажа.';
		end
		if f == 'krysha' then
			lifeon('escape2');
		end
	end,
	life = function(s)
		s._timer = s._timer + 1;
		if s._timer == 3 then
		return 'Внезапно, на этаже раздается звук сирены. — Внимание!!! На пятом этаже лицо с нулевым уровнем допуска. Повторяю... — льется голос из невидимых динамиков.';
		end
		if s._timer > 3 then
			return '— На пятом этаже лицо с нулевым уровнем доступа!!! — от воя сирены меня начинает мутить.';
		end
	end,
	act = function(s, w)
		if w == 1 then
			return 'Мои ноги утопают в красном бархате... Проклятая роскошь!';
		end
		if w == 2 then
			return 'Нет, все-таки это хрусталь...';
		end
		if w == 4 then
			return 'Пожар уже начался...';
		end
		if w == 5 then
			return 'Не думаю, что мой пропуск здесь подойдет.';
		end
		if w == 6 then
			return walk('handgdlg');
		end
	end,
	used = function(s, w, ww)
		if w == 6 then
			return 'Я держу охранника на мушке.';
		end
		if w == 5 then
			return 'Не поможет.';
		end
	end,
	obj = {
	vobj(1, 'ковер', 'Лифтовую площадку покрывает красный {ковер}.'),
	vobj(2, 'люстра', 'Хрустальная {люстра} висит на высоком потолке.'),
	'win5',
	vobj(4, 'информация', '{Дверь} в центр обработки информации распахнута. Из нее начинает валить дым.'),
	vobj(5, 'красная дверь', 'Напротив нее находится {дверь} без надписей. Это массивная дверь, обитая красной кожей.'),

	vobj(6, 'охранник', 'В центре площадки, подняв руки, стоит {охранник}.');
	},
	way = { 'lift','room5' },
	exit = function(s, t)
		if t == 'room5' then
			return 'Там пламя!', false
		end
		if t == 'lift' then
			return 'Я вижу, что лампочки вызова всех лифтов горят. Скорее всего это означает, что сюда поднимается охрана... Надо спешить!', false;
		end
		if t == 'krysha' then
			lifeoff('escape2');
		end
	end
};

swin = obj {
	nam = 'южное окно',
	dsc = 'Из южного {окна} валит дым.',
	act = 'Да, это одно из окон информационного центра. Я заглядываю в окно и вижу пламя.',
};
nwin = obj {
	nam = 'северное окно',
	dsc = function(s)
		local st = '';
		if s._broken then
			st = ' Оно разбито.';
		end
		return 'Северное {окно} светит в темноту желтым светом.'..st;
	end,
	act = function(s)
		if s._broken then
			return walk('hall5');
		end
		return 'Гм... Я заглядываю в окно и вижу прекрасный зал.';
	end,
	used = function(s, w)
		if w == 'shotgun' then
			s._broken = true;
			ways():add('hall5');
			return 'Уххх... Надеюсь, это последнее??? Я размахиваюсь и разбиваю стекло прикладом помпового ружья.';
		end
	end,
};

hall5 = room {
	nam = 'зал',
	pic = 'gfx/hall5.png',
	enter = function(s, f)
		if f == 'krysha' then
			return 'Я спрыгиваю в зал и оглядываюсь...';
		end
	end,
	act = function(s, w)
		if w == 1 then
			return 'Ненужная роскошь.';
		end
		if w == 2 then
			return 'Я провожу ладонью по скользкой поверхности одной из колонн... Мрамор!';
		end
		if w == 3 then
			return 'Но уж эта-то люстра точно из горного хрусталя.';
		end
		if w == 4 then
			return 'Темно... Хотя... Что это? Мне кажется, что у задней стороны института стоит поезд.';
		end
		if w == 5 then
			return 'У разбитого окна кружатся снежинки.';
		end
		if w == 6 then
			if s.way:srch('escape3') then
				return walk('escape3');
			end
			return walk('gudlg');
		end
		if w == 7 then
			return 'Эта дверь закрыта. Вряд ли ее можно открыть моим ключом.';
		end
		if w == 8 then
			return 'Гммм... Пикассо?';
		end
		if w == 9 then
			return 'Страшная слабость охватывает меня... Нет — мне нельзя спать...';
		end
	end,
	used = function(s, w, ww)
		return 'Зачем?';
	end,
	dsc = 'Прекрасный и огромный зал занимает почти всю северную часть здания!',
	obj = {
		vobj(1,'ковер', 'Под ногами бархат красного {ковра}.'),
		vobj(2,'колонны', 'Восемь мраморных {колонн} образуют коридор.'),
		vobj(3,'люстра', 'Великолепная {люстра} свисает с потолка.'),
		vobj(4,'восточные окна', 'На восток выходит четыре {окна}.'),
		vobj(5,'западные окна', 'Разбитое {окно} находится слева от меня.'),
		vobj(6,'небольшая дверь', 'В конце зала, в его северной части, я вижу небольшую деревянную {дверь}.'),
		vobj(7,'входная дверь', 'За моей спиной входная {дверь}.'),
		vobj(8,'картины', 'По стенам развешаны {картины} в красивых рамах.'),
		vobj(9,'диваны', 'У стен расставлены мягкие {диваны}.'),
	},
	way = { 'krysha' },
};

krysha = room {
	nam = 'крыша',
	pic = 'gfx/krysha.png',
	enter = function(s, f)
		return 'Я быстро подхожу к разбитому окну и вот, я на крыше...';
	end,
	dsc = 'Видимо, пятый этаж был достроен позже остальных четырех. По участку крыши я могу добраться до первых окон южного и северного крыла.',
	obj = {'nwin', 'swin'},
	way = {'escape2'},
};

gudlg2 = dlg {
	nam = 'человек с портрета',
	pic = 'gfx/pmanb.png',
	dsc = 'Я смотрю на его поникшее лицо. Оно по-прежнему спокойно.',
	obj = {
		[1] = phr('Получил, гад?',
		'В ответ я слышу едва различимый стон.',
		[[pon(1); back();]]),
		[2] = phr('Но зачем, зачем это все?',
		'Он поднял на меня свои глаза. — Я просто делал свою работу...',
		[[pon(3);poff(1);]]),
		[3] = _phr('Что за ерунда?', 
		'— А потом, потом стал не нужен... Ну что же — подумал я... — Мир заплатит за эту ошибку...',[[pon(4)]]),
		[4] = _phr('Что ты несешь?',
		'— Я работал профессором... Но я был не нужен.. Я ... Я не мог это вынести...',
		[[pon(5)]]),
		[5] = _phr('Какой мерзавец...',
		'— Но я заставлю их... Заставлю... Я, я, я - я буду жить вечно... Сам... Один.',
		[[pon(6)]]),
		[6] = _phr('Мне кажется, что ты спятил...',
		'Его тело дергается в углу — это озноб.',
		[[pon(1); back()]]),
	}
};

gudlg = dlg {
	nam = 'человек с портрета',
	pic = 'gfx/pman.png',
	enter = function(s)
		lifeoff('mycat');
		inv():del('shotgun');
		return [[Странно... Дверь не закрыта... Я осторожно открываю дверь и вхожу в комнату.^^Внезапно я обнаруживаю, что на меня смотрит дуло револьвера. — Браво, браво, браво — говорит мне человек в кресле, владелец револьвера. — Я уже заждался. Тот самый лесник? Ну что же, подождем охрану. А пока — брось ружье на пол. Мне ничего не остается, как сделать то, что он сказал.]];
	end,
	dsc = [[Передо мной то самое лицо. Лицо с портретов, которыми увешаны почти все комнаты этого здания. Лицо спокойное, ничего не выражающее. Слабая улыбка на губах. Надо тянуть время... И я спрашиваю у него:]],
	obj = {
	[1] = phr('Может, поговорим?', 
	'Гм... Ну о чем нам говорить? О чем мне говорить с лесником?', [[pon(2)]]),
	[2] = _phr('Например, правда ли то, что многомировая интерпретация Эверетта верна?',
	'— Ха ха ха ха!!! — невыразительно смеется человек с портрета — Конечно, это фокус... Чтобы заставить этих идиотов верить в собственное бессмертие... А может...',[[pon(3)]] ),
	[3] = _phr('...То-есть никакого доказательства нет?',
	'Человек перестает смеяться — ...А может — это все-таки правда? — загадочно произносит он — Какой ответ истина? Как ТЫ думаешь?', [[pon(4)]]),
	[4] = _phr('Я знаю, что это ложь!',
	'Знаешь ли? — пустые глаза смотрят на меня — Да или нет? - Вдруг паника оглушает меня.'
	,[[pon(5,9)]]),
	[5] = _phr('Ложь!', 
	'А что если? Представь, что если?... Ты же хакер, да? Любишь продумывать все заранее...',
[[pon(6);poff(9)]]),
	[6] = _phr('Нет! Это не может быть правдой! Если это правда — рано или поздно мир будет обречен! Тогда...',
	'— Да, ты правильно понял... Тогда есть только ТЫ!!! Послушай себя — кто дал тебе этот ответ? Не его ли ты жаждешь? Не его ли жаждет твое Я? — Я проваливаюсь в его бездонный взгляд.', [[pon(7)]]),
	[7] = _phr('Если... Если... То зачем?',
	'— Правильно... Правильно — вкрадчиво говорит мне человек с портрета... Новая волна страха оглушает меня, я падаю на колени... Сердце бешено стучит и вылетает из груди...',
	[[pon(8)]]),
	[8] = _phr('Не могу... Нет...',
	'— И если все так, то тебе нечего бояться — мурлычет он. — Сердце бьется еще сильнее. И наконец, моя грудь взрывается, мягкий комочек шерсти отталкивается от нее лапами и летит в лицо человеку с портрета. Раздается выстрел, резкая боль в левом плече отрезвляет меня, я вскакиваю на ноги и бросаюсь вперед...',[[return walk('escape3')]]),
	[9] = _phr('Допустим, это правда.',
		'— Так... Правильно... Думай, думай...Ты же хакер, да? — шепчет человек с портрета.',
		[[pon(6);poff(5)]])
	},
};

--shkf = obj {
--	nam = 'край шкафа',
--	inv = 'Я держу в руках край шкафа.',
--};

shkaf = obj {
	nam = 'шкаф',
	inv = 'Я держу в руках край шкафа.',
	dsc = function(s)
		if s._fall then
			return 'Дверь завалена {шкафом}.';
		end
		return 'Один из книжных {шкафов} стоит возле двери.';
	end,
	act = function(s)
		if not escape3._guards or s._fall then
			return 'Какая-то философия... И еще физика.';
		end
		inv():add('shkaf');
		return 'Я крепко схватился за край шкафа.';
	end,
};

fromw5 = room {
	nam = 'на подоконнике',
	dsc = 'Я стою на подоконнике, ледяной ветер мешает дышать.',
	pic = 'gfx/fromwin2.png',
	enter = 'Ну что-же, надеюсь это в последний раз...',
	act = function(s, w)
		if w == 1 then
			return walk('nwall');
		end
	end,
	obj = {
		vobj(1, 'труба', 'Справа от себя я едва различаю водосточную {трубу}.'),
	},
	way = { 'escape3' },
	exit = function(s, t)
		if t == 'escape3' then
			return 'Надо спешить!', false;
		end
	end
};

winr5 = obj {
	nam = 'окно',
	dsc = function(s)
		if s._broken then
			return 'Сквозь разбитое {окно} в комнату дышит зимний ветер.';
		else
			return '{Окно} выходит на северную сторону.';
		end
	end,
	act = function(s, w)
		if escape3._guards then
			if not shkaf._fall then
				return 'Некогда любоваться видами... Надо задержать охранников.';
			end
			if not have('mycat') then
				return 'Без Барсика? Лучше погибнуть вместе!';
			end
--			if not have('revol') then
--				return 'Лучше поднять с пола пистолет, на всякий случай.';
--			end
			if s._broken then
				ways():add('fromw5');
				return walk('fromw5');
			else
				return 'Окно закрыто.';
			end
		end
		escape3._guards = true;
		lifeon('escape3');
		return 'За окном полная темнота. Я смотрю в темноту, когда вдруг слышу за спиной приглушенный шум шагов... Звуки идут из зала, наверное охрана добралась сюда! Нужно действовать!';
	end,
	used = function(s, w)
		if escape3._guards and not shkaf._fall then
			return 'Некогда... Скоро охрана ворвется сюда...';
		end
		if w == 'shotgun' then
			if not s._broken then
				s._broken = true;
				return 'Опять? Ну что же... Я размахиваюсь и разбиваю стекло прикладом. Осколки улетает в темноту.';
			end
			return 'Это окно уже разбито.';
		end
	end,
};

revol = obj {
	nam = 'револьвер',
	dsc = 'На полу валяется {револьвер}.',
	inv = 'Шесть зарядов.',
	tak = 'Я поднимаю с пола револьвер.',
};

escape3 = room {
	nam = 'в комнате',
	pic = 'gfx/manroom.png',
	enter = function(s, f)
		if f == 'gudlg' then
			inv():del('mycat');
			hall5.way:add('escape3');
			return 'Я слышу звук падающего пистолета... Потом я бью в чье-то лицо изо всех сил. Снова и снова. Барсик носится вокруг и жалобно мяукает. Через несколько секунд я встаю с пола.';
		end
	end,
	act = function(s, w)
		if w == 1 then
			return walk('gudlg2');
		end
		if w == 2 then
			return 'Абстракционисты не в моем вкусе.';
		end
		if w == 3 then
			local st = '';
			if shkaf._fall then
				st = ' Завалена шкафом.';
			end
			return 'Дверь ведущая в зал.'..st;
		end
	end,
	used = function(s, w, ww)
		if w == 1 and ww == 'shotgun' or ww == 'revol' then
			return 'Да — это зло. Но я не могу стрелять в беспомощного человека.';
		end
		if w == 3 and ww == 'shkaf' then
			shkaf._fall = true;
			inv():del('shkaf');
			return 'Я толкаю шкаф и он падает, заграждая собой дверь.';
		end
	end,
	dsc = [[Я нахожусь в небольшой, но уютной  комнате. Посреди стоит стол. Рядом опрокинуто кресло. Из небольшой люстры равномерно льется свет. Два небольших книжных шкафа стоят у стен.]],
	obj = {
		vobj(1, 'человек', 'На полу, прислонившись к столу, сидит {человек} с портретов. Струйка крови стекает с его губ — он стонет.'),
		vobj(2, 'картины', 'По стенам развешаны {картины}.'),
		vobj(3, 'дверь', 'За моей спиной {дверь}.'),
		'revol',
		'shkaf',
		'shotgun',
		'mycat',
		'winr5',
	},
	life = function(s)
		if rnd(3) == 1 then
			return 'Я слышу выстрелы... Пули прошивают дверь... Надо что-то делать...';
		end
	end,
	exit = function(s,t)
		if t == 'hall5' then
			if shkaf._fall then
				return 'Проход завален шкафом.', false;
			end
			if s._guards then
				return 'Меня там подстрелят...', false;
			end
			s._guards = true;
			lifeon('escape3');
			return 'Я собираюсь выйти в зал, когда вдруг на другом конце открывается дверь и в зал вбегают охранники. Я быстро захлопываю дверь.',false;
		end
		lifeoff('escape3');
	end,
	way = {
		'hall5'
	},
};

nwall = room {
	nam = 'северная сторона',
	dsc = 'Я нахожусь у северной стены здания института.',
	pic = 'gfx/nside.png',
	way = {'eside2','wside' },
	act = function(s, w)
		if w == 1 then
			return 'Да — водосточная труба... Довольно крепкая. Но вряд ли я смогу взобраться по ней наверх.';
		end
	end,
	enter = function(s, f)
		if f == 'fromw5' then
			return 'Превозмогая боль в левом плече я прыгаю с подоконника на трубу... Мое сердце бешено стучит в груди, пока мы падаем с Барсиком в зимнюю темноту. Но вот, в следующее мгновение я уже соскальзываю, обдирая кожу с ладоней, по водосточной трубе...';
		end
	end,
	obj = { vobj(1, 'труба', 'Водосточная {труба} проходит по восточному углу здания.')},
	exit = function(s, t)
		if t == 'wside' then
			if not s._guards then
				s._guards = true;
				return 'Я высовываюсь из-за угла и вижу, как толпа охранников приближается ко мне из КПП. — Вон он — слышу я крик... Треск выстрелов отгоняет меня обратно.', false;
			end
			return 'Там меня ждут...', false;
		end
	end
};

eside2 = room {
	nam = 'сзади института',
	pic = 'gfx/esidee.png',
	dsc = [[ Я нахожусь у задней стены здания института. Здесь проходят рельсы.]],
	act = function(s,w)
		if w == 1 then
			return 'Пулеметы направлены на внешнюю - южную сторону периметра, надо держаться от них подальше.';
		end
		if w == 2 then
			return 'Гм... Похоже это тот самый поезд... Разгрузка еще не началась, но ворота уже открыты.';
		end
		if w == 3 then
			return 'Четыре вагона. Тип тепловоза - ЧМЭ3. Поезд полностью помещается на территории института.';
		end
	end,
	obj = {
	vobj(1,'пулеметные вышки', 'Въезд поезда охраняется пулеметными {вышками}..'),
	vobj(3,'поезд', 'Перед институтом стоит темная громада {поезда}.'), 
	vobj(2,'ворота', 'Большие железные {ворота} в стене института открыты — я вижу свет, который льется из дверного проема.'),	
	},
	exit = function(s, t)
		if t == 'sside' then
			return 'На южной стороне меня смущают пулеметы. Лучше не рисковать.', false
		end
		if t == 'nwall' and nwall._guards then
			return 'Назад пути нет...', false;
		end
	end,
	way = {'nwall','train','sside'},
};
function checkloc()
	if p1._off or p2._off then -- battary or switch off off
		p3._off = true;
		p4._off = true;
		p5._off = true;
--		p51._off = true;
--		p6._off = true;
	end
	if p3._off or p4._off then
--		p7._off = true;
--		p71._off = true;
	end
	if p5._off then
		p7._off = true;
	end
	if p51._off then
		p71._off = true;
	end
	if p6._off then
--		p7._off = true;
--		p71._off = true;
	end
	if p7._off then
--		p71._off = true;
	end
end
p1 = obj {
	_off = false,
	nam = 'разъединитель',
	dsc = function(s)
		local st = 'включено.';
		if s._off then
			st = 'выключено.';
		end
		return '{Разъеденитель} батареи ВБ: '..st;
	end,
	act = function(s)
		if s._off then
			s._off = false;
		else
			s._off = true;
		end
		checkloc();
		return 'Переключаю...';
	end
};

p2 = obj {
	_off = true;
	nam = 'ключ',
	dsc = function(s)
		local st = 'повернут вниз.';
		if s._off then
			st = 'повернут вверх.';
		end
		return '{Ключ} кнопочных выключателей: '..st;
	end,
	act = function(s)
		if s._off then
			s._off = false;
		else
			s._off = true;
		end
		checkloc();
		return 'Я поворачиваю ключ.';
	end
};
p3 = obj {
	_off = true,
	nam = 'электроманометр',
	dsc = function(s)
		local st = 'включено.';
		if s._off then
			st = 'выключено.';
		end
		return '{Электроманометр}: '..st;
	end,
	act = function(s)
		if p1._off or p2._off then
			return 'Странно... Не получается.'
		end
		if s._off then
			s._off = false;
		else
			s._off = true;
		end
		checkloc();
		return 'Переключаю...'
	end
};
p4 = obj {
	_off = false,
	nam = 'электротермометр',
	dsc = function(s)
		local st = 'включено.';
		if s._off then
			st = 'выключено.';
		end
		return '{Электротермометр}: '..st;
	end,
	act = function(s)
		if p1._off or p2._off then
			return 'Странно... Не получается.'
		end
		if s._off then
			s._off = false;
		else
			s._off = true;
		end
		checkloc();
		return 'Переключаю...'
	end
};
p5 = obj {
	_off = true,
	nam = 'насос 2-й секции',
	dsc = function(s)
		local st = 'включено.';
		if s._off then
			st = 'выключено.';
		end
		return 'Топливный {насос} 2-й секции: '..st;
	end,
	act = function(s)
		if p1._off or p2._off then
			return 'Странно... Не получается.'
		end
		if s._off then
			s._off = false;
		else
			s._off = true;
		end
		checkloc();
		return 'Переключаю...'
	end
};

p6 = obj {
	_off = true,
	nam = 'управление',
	dsc = function(s)
		local st = 'включено.';
		if s._off then
			st = 'выключено.';
		end
		return '{Управление}: '..st;
	end,
	act = function(s)
		if p1._off or p2._off then
			return 'Странно... Не получается.'
		end
		if s._off then
			s._off = false;
		else
			s._off = true;
		end
		checkloc();
		return 'Переключаю...'
	end
};

p7 = obj {
	_off = true,
	nam = 'пуск дизеля 2-й секции',
	dsc = function(s)
		local st = 'включено.';
		if s._off then
			st = 'выключено.';
		end
		return '{Пуск} дизеля 2-й секции: '..st;
	end,
	act = function(s)
		if p3._off or p4._off or p5._off or p6._off then
			return 'Странно... Не получается.'
		end
		if s._off then
			s._off = false;
		else
			s._off = true;
		end
		checkloc();
		return 'Переключаю...'
	end
};

p51 = obj {
	_off = true,
	nam = 'насос 1-й секции',
	dsc = function(s)
		local st = 'включено.';
		if s._off then
			st = 'выключено.';
		end
		return 'Топливный {насос} 1-й секции: '..st;
	end,
	act = function(s)
		if p1._off or p2._off then
			return 'Странно... Не получается.'
		end
		if s._off then
			s._off = false;
		else
			s._off = true;
		end
		checkloc();
		return 'Переключаю.';
	end
};

p71 = obj {
	_off = true,
	nam = 'пуск дизеля 1-й секции',
	dsc = function(s)
		local st = 'включено.';
		if s._off then
			st = 'выключено.';
		end
		return '{Пуск} дизеля 1-й секции: '..st;
	end,
	act = function(s)
		if p3._off or p4._off or p5._off or p6._off or p7._off then
			return 'Странно... Не получается.'
		end
		if s._off then
			s._off = false;
		else
			s._off = true;
		end
		checkloc();
		return 'Переключаю...';
	end
};

p8 = obj {
	_num = 1,
	nam = 'реверсор',
	dsc = function(s)
		local st;
		if s._num == 1 then
			st = 'нейтрально.';
		elseif s._num == 2 then
			st = 'назад.';
		elseif s._num == 3 then
			st = 'вперед.';
		end
		return 'Рукоятка {реверсора}: '..st;
	end,
	act = function(s)
		s._num = s._num + 1;
		if s._num == 4 then
			s._num = 1;
		end
		return 'Переключаю...';
	end
};

p9 = obj {
	_num = 1,
	nam = 'контроллер',
	dsc = function(s)
		local st;
		if s._num == 1 then
			st = '0.';
		elseif s._num == 2 then
			st = '1.';
		elseif s._num == 3 then
			st = '2.';
		end
		return 'Рукоятка {контроллера}: '..st;
	end,
	act = function(s)
		s._num = s._num + 1;
		if s._num == 4 then
			s._num = 1;
		end
		if s._num == 1 then
			return 'Переключаю.';
		end
		if not p71._off and not p7._off then
			if p8._num == 2 then
				s._num = 1;
				return 'Локомотив вздрагивает и начинает ехать назад. Я перевожу контроллер на 0.';
			elseif p8._num == 3 then
				lifeoff('mycat');
				set_music('mus/liberty.s3m');
				return walk('theend');
			end
		end
		s._num = 1;
		return 'Ничего не происходит... Я перевожу контроллер в положение 0.';
	end
};
	
train = room {
	nam = function(s)
		if here() == train then
			return 'в локомотиве';
		end
		return 'к поезду';
	end,
	pic = 'gfx/cab.png',
	dsc = 'Итак, я в локомотиве. Толстая сталь надежно укрывает меня от пуль. Кабина машиниста оказалась пуста. Я вижу перед собой множество приборов.',
	act = function(s, w)
		if w == 2 then
			if p1._off or p2._off then
				return 'Я нажал кнопку гудка, но ничего не услышал.';
			end
			return 'Раздается унылый звук сигнала. — Я машинист!';
		end
		if w == 1 then
			return 'Только бы успеть завести эту штуку... И никакие ворота меня не остановят.';
		end
	end,
	life = function(s)
		local st = '';
		if not p7._off or not p71._off then
			st = 'Я чувствую как дрожит локомотив. Работает дизель. ';
		end
		if rnd(10) < 5 then
			st = st..'В кабине раздаются звуки ударов пуль о металл.';
		end
		return st;
	end,
	exit = function(s,t)
		if t == 'eside2' then
			return 'Нет... Лучше остаться здесь, мы будем сопротивляться до последнего.', false;
		end
		lifeoff('train');
	end,
	enter = function(s, f)
		if f == 'eside2' and not guards1._broken then 
			return cat('Пригнувшись, я бегу к поезду.^^', walk('vorota')), false;
		end
		lifeon('train');
		set_music('mus/hispeed.s3m');
		return 'Пригнувшись, я бегу к поезду... Пробегая мимо вагонов я успеваю заметить знаки <<осторожно — радиация!!>>. Еще немного — и я добираюсь до локомотива. Сзади я слышу звуки выстрелов. Впереди охрана разворачивает пулеметы. Я открываю тяжелую дверь и вот — я внутри.'
	end,
	obj = {
		'p2', 'p1', 'p4', 'p3',  'p71','p51', 'p7', 'p5', 'p9', 'p8', 'p6',
		vobj(2, 'гудок', '{Гудок}.');
		vobj(1, 'окно', 'В {окнах} я вижу закрытые ворота.'),
	},
	way = { 'eside2' },
};

guards1 = obj {
	nam = 'охрана',
	dsc = function(s, w)
		if s._broken then
			return '{Охранники} за турникетами завалены обломками люстры.';
		end
		if s._shoot then
			return 'Я вижу {охранников}, которые укрываются от моего огня за турникетами.';
		end
		return 'Я вижу {охранников} с автоматами, которые пробираются ко мне через зал первого этажа.';
	end,
	act = function(s, w)
		if s._broken then
			return 'Похоже, они в замешательстве...';
		end
		if s._shoot then
			return 'Вот негодяи!';
		end
		return 'Удивительно, что я еще жив...';
	end,
	used = function(s, w)
		if w == 'shotgun' or w == 'revol' then
			if s._shoot then
				return 'Бесполезно, охранники защищены металлом турникетов.';
			end
			s._shoot = true;
			return 'Я высовываюсь из-за стены и стреляю несколько раз наугад.';
		end
	end,
};

lustra1 = obj {
	nam = 'люстры',
	dsc = function(s, w)
		if s._broken then
			return 'На потолке висит одна {люстра}.';
		end
		return 'Две ослепительные {люстры} свисают с потолка.';
	end,
	act = function(s, w)
		if guards1._shoot then
			return 'Одна из люстр находится прямо над турникетами.';
		end
		return 'Не могу на них наглядеться... Наверное, это хрусталь?';
	end,
	used = function(s, w)
		if w == 'revol' then
			return 'Вряд ли этот пистолет принесет сильный ущерб люстрам.';
		end
		if w == 'shotgun' then
			shotgun._unloaded = true;
			s._broken = true;
			guards1._broken = true;
			lifeoff('vorota');
			drop('shotgun');
			return 'Я высовываюсь из-за стены и разряжаю помповое ружье. Сильный грохот и звуки щелкающего затвора оглушают меня. Я вижу, как одна из люстр, сопровождаемая криками охранников, медленно оторвавшись летит вниз. Я выбрасываю бесполезное ружье на пол.';
		end
	end,
	
};

vorota = room {
	nam = 'у ворот',
	pic = 'gfx/shooting.png',
	enter = function(s, f)
		if f == 'eside2' and not guards1._broken then
			lifeon('vorota');
			return 'Поравнявшись с открытыми воротами я слышу треск выстрелов и прижимаюсь к стене.';
		end
	end,
	life = function(s)
		if rnd(6) < 4 then
			return 'Раздается треск выстрелов. Я вжимаюсь в стену.'; 
		end 
	end,
	act = function(s, w)
		if w == 1 then
			return 'Те самые турникеты, через которые я попал внутрь. Теперь я нахожусь с другой стороны.';
		end
	end,
	dsc = 'Я нахожусь у открытых ворот. Ворота ведут на первый этаж института.',
	obj = {
	vobj(1, 'турникеты', 'Я вижу ряд {турникетов}.'),
	'lustra1',
	'guards1',
	},
	exit = function(s, t)
		if not guards1._broken and t == 'train' then
			return 'Я бросаюсь вперед, но автоматные очереди заставляют меня вернуться.', false;
		end
	end,
	way = { 'train', 'eside2' },
};

theend = room {
	nam = 'эпилог',
	pic = 'gfx/chme3.png',
	dsc = [[Я передвинул ручку контроллера в самое переднее положение, и локомотив, 
вздрогнув, двинулся вперед. Я услышал крики, и пулеметные очереди с новой силой застучали
по стенкам кабины... Но локомотив набирал ход, и скоро послышался сильный лязг — это ворота,
не выдержав натиска 1350 лошадиных сил, вылетели из своих петель и протащились несколько
десятков метров вдоль путей...^^

Барсик высунул морду из-за пазухи и осмотрелся вокруг. Я привычно погладил его за ушами.
Когда лязг раздавленных ворот и стук пуль утихли, я выглянул из окна и последний раз посмотрел в сторону института. Он полыхал словно факел — пожар уже захватил весь пятый этаж.
Я посмотрел на небо и теперь, уже в полной темноте, смог разглядеть россыпи звезд. ^^

Совсем скоро поле уступило место тайге, и привычные очертания сосен и елей замелькали под 
ровный стук колес. Рана в плече ныла, и я почувствовал сильную усталость... Присев на пол
и прислонившись к холодному железу кабины, я слушал гудение локомотива и гладил Барсика за 
ушами...^^

Барсик посмотрел на меня своими умными глазами и вопросительно замурлыкал — Домой, 
ответил я ему — Мы едем домой...^^
КОНЕЦ^^

 ---^^

История и движок: ^
Косых Петр a.k.a. gl00my // 2009^^

Графика: ^
Косых Петр, несколько фотографий из открытых источников.^^

Музыка: ^
One fine day // Elwood^
Revelation // necros^
New beginning // Purple Motion^
Ice frontier // Skaven^
Planete football // Frank Amoros^
Underwater world II // Slightly Magic^
Hybrid song // Quazar^
Hispeed - track whatever // Purple Motion^
Liberty // Zapper^^

Тестеры:^
Каличев Сергей a.k.a. Pkun^
Подобаев Владимир a.k.a. zloyvov^^


Если вам понравилась игра, самое лучшее, что вы можете сделать, это написать свою историю на движке instead. :)^^

Благодарности:^
Всем тем, кто не мешал. :)^^
]],
};

