transition = {}
transition.canvas = undefined
transition.context = undefined

transition.setupContext = function () {
	if (transition.canvas) {
		transition.canvas.style.display = "initial"
		return
	}
	
	transition.canvas = document.createElement("canvas")
	transition.canvas.style.position = "fixed"
	transition.canvas.style.left = "0px"
	transition.canvas.style.top = "0px"
	transition.canvas.style.zIndex = "1"
	transition.canvas.width = window.innerWidth
	transition.canvas.height = window.innerHeight
	transition.canvas.id = "transition"
	
	document.body.appendChild(transition.canvas)
	
	transition.context = transition.canvas.getContext("2d")
}

transition.splat = function (word, style, invert, scatter) {
	transition.setupContext()
	fontHeight = window.innerHeight / 5
	transition.context.font = fontHeight + "px Arial"
	fontWidth = transition.context.measureText(word).width
	transition.context.fillStyle = style ? style : "black"
	
	if (invert) {
		transition.context.fillRect(0,0,window.innerWidth,window.innerHeight)
		transition.context.globalCompositeOperation  = "destination-out"
	}
	
	var i = 0
	var accumulator = 0
	
	var repeat = function () {
		accumulator +=  1 + (i * i) / 1250
		while (accumulator > 0) {
			transition.context.translate(Math.random() * window.innerWidth + fontWidth * 0.5, Math.random() * window.innerHeight * 1.2)
			if (scatter) transition.context.rotate(Math.random() * 3.14 * 2)
			transition.context.fillText(word, 0, 0)
			transition.context.resetTransform()
			accumulator--
		}
	
		if (i++ < 200)
			requestAnimationFrame(repeat)
		else {
			transition.canvas.style.display = "none"
//			if (!invert) main()
		}
	}
	
	repeat()
//	pause()
}

transition.fadeVertical = function (c1, c2) {
	transition.setupContext()
	
	var i = window.innerHeight
	var repeat = function () {
		transition.context.clearRect(0,0,window.innerWidth,window.innerHeight)
		
		var grd=transition.context.createLinearGradient(0,i,0,i+window.innerHeight)
		grd.addColorStop(0, c1)
		grd.addColorStop(1, c2)
		transition.context.fillStyle=grd
		
		transition.context.fillRect(0,0,window.innerWidth,window.innerHeight)
		
		i -= 10
		if (i > -window.innerHeight)
			requestAnimationFrame(repeat)
		else {
			transition.canvas.style.display = "none"
//			main()
			location.reload()
		}
	}
	
	repeat()
//	pause()
}

transition.fadeRadial = function () {
	transition.setupContext()
	transition.context.fillStyle = "black"
	
	var j = 0
	var points = []
	while (j < 5) {
		point = []
		point.x = Math.random() * window.innerWidth
		point.y = Math.random() * window.innerHeight
		point.size = Math.random() * 100
		points.push (point)
		
		j++
	}
	
	var i = 0
	var repeat = function () {
		transition.context.fillRect(0,0,window.innerWidth,window.innerHeight)
		transition.context.globalCompositeOperation  = "destination-out"
		
		for (point in points) {
			point = points[point]
			var grd=transition.context.createRadialGradient(point.x,point.y,Math.max(0,i-window.innerHeight-point.size),point.x,point.y,Math.max(0,i-point.size))
			grd.addColorStop(0,"black")
			grd.addColorStop(1,"rgba(0,0,0,0)")
			transition.context.fillStyle=grd
			
			transition.context.fillRect(0,0,window.innerWidth,window.innerHeight)
		}
		
		i += 10
		if (i < window.innerHeight)
			requestAnimationFrame(repeat)
		else {
			transition.canvas.style.display = "none"
//			main()
		}
	}
	
	repeat()
//	pause()
}

transition.star = function () {
	transition.setupContext()
	transition.context.fillStyle = "black"
	var img = document.createElement('img')
	img.src = "images/star.png"
	var img2 = document.createElement('img')
	img2.src = "images/red star.png"
	
	var star = []
	star.x = 100
	star.y = 0
	star.dx = 0
	star.dy = 0
	star.rotation = 0
	star.grounded = false
	
	var i = 0
	var repeat = function () {
		//transition.context.globalCompositeOperation  = "source-over"
		//transition.context.fillRect(0,0,window.innerWidth,window.innerHeight)
		//transition.context.globalCompositeOperation  = "destination-out"
		transition.context.translate(star.x, star.y)
		transition.context.rotate(star.rotation / 100)
		transition.context.drawImage(img2, -img2.width / 2, -img2.height / 2)
		transition.context.resetTransform()
		
		if (!star.grounded) {
			star.dy += 0.2
			star.x += star.dx
			star.y += star.dy
			star.rotation += 1
		}
		
		if (star.y + star.dy + img.width / 2 > window.innerHeight) {
			star.dy *= -0.6
			star.dx += 2
			
			if (star.dy > -2) star.grounded = true
		}

		transition.context.translate(star.x, star.y)
		transition.context.rotate(star.rotation / 100)
		transition.context.drawImage(img , -img.width / 2, -img.height / 2)
		transition.context.resetTransform()
	
		i++
		if (i < 1000)
			requestAnimationFrame(repeat)
		else {
			transition.canvas.style.display = "none"
//			main()
		}
	}
	
	repeat()
//	pause()
}

transition.vines = function (image, style, invert, scatter) {
	transition.setupContext()
	var img = document.getElementById(image)
	document.body.appendChild (img)
	transition.context.fillStyle = style ? style : "black"

	if (invert) {
		transition.context.fillRect(0,0,window.innerWidth,window.innerHeight)
		transition.context.globalCompositeOperation  = "destination-out"
	}
	
	var i = 0
	var accumulator = 0
	var vines = []
	
	var repeat = function () {
		vine = {}
		vine.x = between(0, transition.canvas.width)
		vine.y = between(0, transition.canvas.height)
		switch (between(0, 4)) {
			case 0: vine.x = 0; vine.rot = 3.14 * 0.5 + (Math.random() - 0.5); break
			case 1: vine.x = transition.canvas.width; vine.rot = 3.14 * 1.5 + (Math.random() - 0.5); break
			case 2: vine.y = 0; vine.rot = 3.14 * 0 + (Math.random() - 0.5); break
			case 3: vine.y = transition.canvas.height; vine.rot = 3.14 * 1 + (Math.random() - 0.5); break
		}
		vine.rot2 = (Math.random() - 0.5) * 3.14 * 0.01
		vine.rot3 = (Math.random() - 0.5) * 3.14 * 0.01
		vine.size = transition.canvas.height / img.height / 6
			
		vines.push (vine)
			
		for (v in vines) {
			vine = vines[v]
			if (vine.x < 0 || vine.y < 0 || vine.x > transition.canvas.width || vine.y > transition.canvas.height){
				vines.splice(vines.indexOf(vine), 1)
			}
			transition.context.translate(vine.x, vine.y)
			transition.context.rotate(Math.random() * 3.14 * 2)
			transition.context.scale(vine.size, vine.size)
			transition.context.drawImage(img, img.width * -0.5, img.height * -0.5)
			transition.context.setTransform(1,0,0,1,0,0)
			
			vine.x += Math.sin(vine.rot) * 30
			vine.y += Math.cos(vine.rot) * 30
			vine.rot += vine.rot2
			vine.rot2 += vine.rot3
			
			if (Math.random() < 0.01) {
				n = {}
				n.x = vine.x
				n.y = vine.y
				n.rot = vine.rot
				n.rot2 = vine.rot2 * -1
				n.rot3 = vine.rot3 * -1
				n.size = vine.size * 0.75
				vine.size *= 0.75
					
				vines.push (n)
			}
		}
	
		if (i++ < 100)
			requestAnimationFrame(repeat)
		else {
			transition.canvas.style.display = "none"
//			if (!invert) main()
		}
	}
	
	repeat()
//	pause()
}