/* background.t

Various background persons, events, etc.

This code is copyright (C) 2000 by Leon Lin, but feel free to
use any code you find here that you might find useful in your
own projects.

The following code is not likely to represent the best way of
doing what the game does, and it probably has some bugs still
in it. Future versions will hopefully resolve any outstanding
problems.

Please direct all comments, questions, and bug reports to:
leonlin@ix.netcom.com

Change History
--------------
8/31/2000 (LWL) -- First release
9/2/2000  (LWL) -- Added more comments for public source release. Also
                   fixed countdown bug.

*/

// This object contains lists of ingredients and other interesting stuff.
// I probably could have added a lot more items for more variety.
// Special thanks to the World Book Encyclopedia, without which
// I couldn't have gotten comprehensive lists of fruits, vegetables,
// and spices.

pantry: fixeditem
	sdesc = "ingredients"
	ldesc = "This is a veritable cornucopia of ingredients, more than
			you can enumerate."
			
	main_ingredient = nil
	
	theme_ingredients = ['rock lobster' 'caviar' 'foie gras' 'Alaska salmon'
	                     'Kobe beef' 'white truffles']
	                     
	spices = ['allspice' 'anise' 'bay leaf' 'caper' 'capsicum' 
			  'caraway' 'cardamom' 'cayenne pepper' 'cinnamon' 
			  'clove' 'coriander' 'curry' 'dill' 'fennel' 
			  'ginger' 'mace' 'marjoram' 'mustard'
			  'nutmeg' 'oregano' 'paprika' 'pepper' 'sage' 'tarragon' 
			  'thyme' 'turmeric']

	fruits = ['apples' 'pears' 'bananas' 'oranges' 'lemons' 'limes' 'peaches'
	          'kiwis' 'grapes' 'plums' 'blueberries' 
	          'strawberries' 'raspberries'
	          'blackberries' 'apricots' 'passion fruits' 'mangos' 'coconuts'
	          'durians' 'grapefruits' 'nectarines' 'figs' 'cherries'
	          'cranberries' 'pineapples' 'tangeloes' 'huckleberries'
	          'loganberries' 'boysenberries']

	vegetables = ['tomatoes' 'potatoes' 'corn' 'carrots' 'celery' 'onion'
	              'beets' 'lettuce' 'cabbage' 'artichokes' 'asparagus'
	              'beans' 'broccoli' 'brussels sprouts' 'cauliflower'
	              'collard greens' 'cucumbers' 'eggplants' 'garlic'
	              'kohlrabi' 'lima beans' 'okra']

	meats = ['chicken' 'beef' 'lamb' 'veal' 'turkey' 'pheasant' 'venison'
	         'rabbit' 'duck' 'quail']
	
	offal = ['liver' 'heart' 'tripe' 'kidney' 'sweetmeats']
	
	fish = ['trout' 'salmon' 'cod' 'herring' 'anchovy' 'bass' 'catfish']
	
	cheeses = ['brie' 'limburger' 'cheddar' 'asiago' 'camembert'
	           'munster' 'edam' 'parmesan' 'cottage cheese' 'gruyere' 'feta'
	           'romano' 'roquefort' 'swiss' 'sap sago' 'monterey jack']
	           
	liquids = ['water' 'milk' 'orange juice' 'lemon juice' 'wine' 'beer'
	           'beef stock' 'lamb stock' 'chicken stock']

	// I think I might have gone a bit overboard with vocabulary words
	// here, but in general I like the player to be able to refer to
	// every object mentioned in a description. For this particular game,
	// though, I didn't follow that rule so strictly.
	
	noun = 'ingredients' 'food' 'meat' 'cheese' 'fish' 'vegetables'
			'fruit' 'liquid' 'beverages'
			'obster' 'caviar' 'gras' 'salmon' 
			'beef' 'truffles'
	                     
			  'allspice' 'anise' 'leaf' 'caper' 'capsicum' 
			  'caraway' 'cardamom' 'pepper' 'cinnamon' 
			  'clove' 'coriander' 'curry' 'dill' 'fennel' 
			  'ginger' 'mace' 'marjoram' 'mustard'
			  'nutmeg' 'oregano' 'paprika' 'pepper' 'sage' 'tarragon' 
			  'thyme' 'turmeric'

			  'apples' 'pears' 'bananas' 'oranges' 'lemons' 'limes' 'peaches'
	          'kiwis' 'grapes' 'plums' 'blueberries' 
	          'strawberries' 'raspberries'
	          'blackberries' 'apricots' 'fruits' 'mangos' 'coconuts'
	          'durians' 'grapefruits' 'nectarines' 'figs' 'cherries'
	          'cranberries' 'pineapples' 'tangeloes' 'huckleberries'
	          'loganberries' 'boysenberries'

			   'tomatoes' 'potatoes' 'corn' 'carrots' 'celery' 'onion'
	              'beets' 'lettuce' 'cabbage' 'artichokes' 'asparagus'
	              'beans' 'broccoli' 'brussels sprouts' 'cauliflower'
	              'collard greens' 'cucumbers' 'eggplants' 'garlic'
	              'kohlrabi' 'beans' 'okra'

			 'chicken' 'beef' 'lamb' 'veal' 'turkey' 'pheasant' 'venison'
	         'rabbit' 'duck' 'quail'
	
			'liver' 'heart' 'tripe' 'kidney' 'sweetmeats'
	
			'trout' 'salmon' 'cod' 'herring' 'anchovy' 'bass' 'catfish'
	
			'brie' 'limburger' 'cheddar' 'asiago' 'camembert'
	           'munster' 'edam' 'parmesan' 'cottage' 'gruyere' 'feta'
	           'romano' 'roquefort' 'swiss' 'sago' 'jack'
	           
			'water' 'milk' 'juice' 'wine' 'beer'
	        'stock'

	adjective = 'chicken' 'lamb' 'beef' 'orange' 'lemon' 'monterey'
				'sap' 'lima' 'passion' 'cayenne' 'bay' 'foie' 'alaska'
				'kobe' 'white' 'rock' 'cottage'
	location = kitchen
	
	// Various routines for getting a random item from each list.
	getMeat =
	{
		return pantry.meats[rand(length(pantry.meats))];
	}

	getOffal =
	{
		return pantry.offal[rand(length(pantry.offal))];
	}

	getFish =
	{
		return pantry.fish[rand(length(pantry.fish))];
	}

	getSpice =
	{
		return pantry.spices[rand(length(pantry.spices))];
	}

	getFruit =
	{
		return pantry.fruits[rand(length(pantry.fruits))];
	}

	getVegetable =
	{
		return pantry.vegetables[rand(length(pantry.vegetables))];
	}
	           
	getCheese =
	{
		return pantry.cheeses[rand(length(pantry.cheeses))];
	}

	getLiquid =
	{
		return pantry.liquids[rand(length(pantry.liquids))];
	}
;

// The commentators for the cookoff.
commentators: Actor
	sdesc = "commentators"
	ldesc = "The commentators, seated in a nearby box, are busy chatting 
			away about the events on the kitchen floor."
	actorDesc = "The commentators continue to talk about the cookoff."
	noun = 'commentators' 'mike' 'bob'
	location = kitchen

	// The usual "ask <actor> about <object>" code
	verDoAskAbout(actor, iobj) = 
	{
		"The commentators don't appear to want to converse with
		you.";
	}

	event =
	{
		local numEvent := rand(21);

		switch (numEvent)
		{
			case 1:
			{
				"\b\"This is a pretty exciting event!\" gushes one of the
				commentators.";
				break;
			}
			
			case 2:
			{
				if (toaster.testedToast)
				{
					"\b\"Backowicz is in much better shape now that the
					toaster's fixed!\" says a commentator.";
				}
				else
				{
					"\b\"Backowicz really needs that toaster fixed, and soon!\"
					a commentator notes.";
				}
				break;
			}

			case 3:
			{
				"\b\"Bob,\" says a commentator, \"it looks like Backowicz
				is putting <<pantry.getMeat>>, <<pantry.getVegetable>>
				, <<pantry.getCheese>>, and <<pantry.getSpice>> in the
				food processor.\"";
				break;
			}
			
			case 4:
			{
				"\b\"Backowicz is struggling hard to harmonize the flavors
				of <<pantry.getFruit>> with <<pantry.main_ingredient>>.\"
				notes a commentator.";
				break;
			}

			case 5:
			{
				"\b\"Oooh, he'll feel that in the morning!\" exclaims a
				commentator as an assistant nearly catches his tongue in
				the blender.";
				break;
			}

			case 6:
			{
				"\b\"Biff Backowicz is showing the influence of the
				West Coast style in his dishes,\" a commentator offers.";
				break;
			}

			case 7:
			{
				"\b\"Mike, \" asks a commentator, \"do you think Biff 
				Backowicz can keep the flavor of <<pantry.getSpice>> 
				from overwhelming the <<pantry.main_ingredient>> like 
				it did last week, when he made <<pantry.getFish>> 
				ice cream?\"";
				break;
			}

			case 8:
			{
				"\b\"The Chicago White Toques really need this win to
				stay three cookoffs ahead of the Washington Red Blenders,\"
				notes a commentator.";
				break;
			}

			case 9:
			{
				"\b\"It's really a shame what happened last week when 
				the head chef of the Atlanta Frying Pans tested 
				positive for MSG,\" a commentator says, shaking his 
				head.";
				break;
			}

			case 10:
			{
				"\b\"Biff Backowicz is really showing heart,\" says a
				commentator. \"He's now stuffing it 
				with <<pantry.getFruit>> and getting ready to broil it.\"";
				break;
			}

			case 11:
			{
				"\b\"Mike,\" says a commentator, \"today's theme ingredient
				is <<pantry.main_ingredient>>, which is not a strong point
				for Biff Backowicz.\"";
				break;
			}
			
			case 12:
			{
				"\bThe commentators casually shoot the breeze about last
				weeks Friers - Roasters game.";
				break;
			}

			case 13:
			{
				"\bThe commentators discuss Biff Backowicz's college career
				and debate whether it was wise of him to leave his 
				junior year.";
				break;
			}

			case 14:
			{
				"\bThe commentators talk about the various advantages and
				disadvantages of using marble rolling pins.";
				break;
			}
			
			case 15:
			{
				"\bThe commentators debate the merits of balsamic versus
				rice wine vinegar.";
				break;
			}
			
			case 16:
			{
				"\b\"The White Toques can't afford to lose today, they'd be
				mathematically eliminated from the playoffs,\" says 
				a commentator.";
				break;
			}

			case 17:
			{
				"\bA souffle collapses, and a commentator groans, 
				\"Oh, man, that's gotta hurt.\"";
				break;
			}
			
			case 18:
			{
				"\b\"'Birdie' Stanton looks very hyper today, he's in the
				zone!\" a commentator excitedly comments.";
				break;
			}
			
			case 19:
			{
				"\b\"Backowicz's omelet flipping technique is very good today,
				all those pancake flipping drills paid off,\" says a
				commentator.";
				break;
			}
			
			case 20:
			{
				"\bThe commentators discuss whether or not it's bad that
				so many high school students have decided to skip college
				and declare eligibility for the National Cooking League
				draft.";
				break;
			}

			case 21:
			{
				"\b\"If 'Birdie' wins today, do ya think his
				team'll dump a container full of hollandaise
				sauce on him like they did last week?\" a commentator
				muses.";
				break;
			}			
			default:
			{
				break;
			}
		}
	}
;

// Okay, just to be fair, here's the commentator's box.
box: fixeditem
	sdesc = "commentator's box"
	ldesc = "This is the box in which the commentators sit."
	noun = 'box'
	adjective = 'commentator\'s'
	location = kitchen
	verDoEnter(actor) =
	{
		"A menacing security guard appears out of nowhere and voices a few
		threats to prevent you from entering the commentators' box. You
		back off.";
	}
;

// This actor actually covers the head chefs as well as the assistants.
// I got a bit lazy and decided to incorporate both in the same object.
assistants: Actor
	sdesc = "chefs"
	ldesc = "The various chefs and assistants on both teams are highly trained
			professionals, and are moving about with an urgency which shows
			the importance of the contest they are in. According to the
			frantic stagehand that called you, the two teams that are
			playing are the Chicago White Toques, lead by Biff Backowicz,
			and the New York Burgermeisters, lead by 'Birdie' Stanton."
	actorDesc = "Both cooking teams are moving (and cooking) frantically about you."
	noun = 'assistants' 'backowicz' 'chefs' 'cooks' 'teams' 'toques'
		   'burgermeisters' 'stanton'
	adjective = 'white' 'chicago' 'new' 'york' 'biff' 'birdie'
	location = kitchen

	// The usual "ask <actor> about <object>" code
	verDoAskAbout(actor, iobj) = 
	{
		"You are waved away. Looks like you'll get no talk from these people.";
	}
	
	event =
	{
		local numEvent := rand(20);

		switch (numEvent)
		{
			case 1:
			{
				"\bAn assistant runs by you carrying an overflowing blender.";
				break;
			}
			
			case 2:
			{
				"\bSeveral assistants struggle to carry a box full of
				fresh <<pantry.getVegetable>>.";
				break;
			}

			case 3:
			{
				"\bAn assistant backs into you, nearly spilling a pitcher 
				of <<pantry.getLiquid>>. \"Watch it!\" he scowls.";
				break;
			}
			
			case 4:
			{
				"\bAssistants from both teams nearly get into a slap fight
				with some <<pantry.getFish>>, but officials break it up.";
				break;
			}

			case 5:
			{
				"\bOne of the assistants sniffs a package 
				of overripe <<pantry.getMeat>> and nearly faints from the
				smell.";
				break;
			}

			case 6:
			{
				"\bOne of the assistants vigorously mixes a bowl 
				of <<pantry.getMeat>>, <<pantry.getVegetable>>, 
				and <<pantry.getLiquid>>, liberally 
				sprinkling <<pantry.getSpice>> all over it.";
				break;
			}

			case 7:
			{
				"\bA novice assistant fumbles around with a grater and
				a heel of <<pantry.getCheese>>.";
				break;
			}

			case 8:
			{
				"\bWith surgical precision, an assistant removes 
				the <<pantry.getOffal>> from a <<pantry.getMeat>> carcass.";
				break;
			}

			case 9:
			{
				"\bOne of the assistants cuts himself with a knife, but
				continues on, oblivious to his injury.";
				break;
			}

			case 10:
			{
				"\bAn assistant, in his hurry to get to the other side of the
				kitchen, almost slips on a puddle of <<pantry.getLiquid>>.";
				break;
			}

			case 11:
			{
				"\b\"Get me half a liter of <<pantry.getLiquid>>, stat!\"
				Biff Backowicz yells at his assistants.";
				break;
			}
			
			case 12:
			{
				"\b\"Pick it up, I need those crepes done in five seconds!\"
				'Birdie' Stanton yells at his assistants.";
				break;
			}
			
			case 13:
			{
				"\b'Birdie' Stanton slices fillets off 
				some <<pantry.getMeat>>	with vigor.";
				break;
			}
			
			case 14:
			{
				"\b'Birdie' Stanton calls a play involving a deep fryer,
				lots of <<pantry.getSpice>>, and five gallons 
				of <<pantry.getLiquid>>.";
				break;
			}

			case 15:
			{
				"\bAn assistant is carded for running with a knife in his
				hand. \"One more and he's out of the game,\" a commentator
				notes.";
				break;
			}

			case 16:
			{
				"\bAn assistant fumbles a basket of <<pantry.getFruit>>, but
				another teammate manages to recover.";
				break;
			}
						
			case 17:
			{
				"\bBiff Backowicz chops up some <<pantry.getVegetable>> and
				throws them into a frying pan with <<pantry.getMeat>>.";
				break;
			}
			
			case 18:
			{
				"\bSweating profusely, Biff Backowicz casts an anxious glance
				at the toaster.";
				break;
			}
						
			case 19:
			{
				"\bBiff Backowicz wipes his forehead and takes a swig of a
				fluorescent power drink.";
				break;
			}

			case 20:
			{
				"\b'Birdie' Stanton yells, \"Go, go, go!\" at an assistant
				hustling across the kitchen with <<pantry.getMeat>> in
				a roasting pan.";
				break;
			}
			
			default:
			{
				"\bThe assistants scurry around you, yelling at you to keep out
				of the way.";
			}
		}
	}
;

// For completeness, I added the stagehands. They don't do as much
// as the above actors, though.
stagehands: Actor
	sdesc = "stagehands"
	ldesc = "All sorts of electricians, prop handlers, gaffers, best boys,
			and personal assistants are running around, making sure the
			show goes smoothly."
	actorDesc = "Stagehands scurry around, solving 
				various problems and generally trying not to get fired."
	adesc = "stagehands"
	noun = 'stagehands' 'handlers' 'gaffers' 'boys'
	adjective = 'personal' 'best'
	location = startroom
	// The usual "ask <actor> about <object>" code
	verDoAskAbout(actor, iobj) = 
	{
	}
	doAskAbout (actor, iobj) =
	{
		switch (iobj)
		{
			case toaster:
			{
				"You ask a stagehand about the toaster. He points to the
				east and says, \"It's right in there. Watch your step!\"";
				break;
			}
			
			case commentators:
			{
				"A stagehand pauses to hear your inquiry about the
				commentators, then says, \"Can't comment, must keep
				job,\" and runs off.";
				break;
			}

			case assistants:
			{
				"\"Go team!\" yells a stagehand in passing.";
				break;
			}			

			default:
			{
				"\"Sorry, can't talk!\" says a stagehand as he passes you.";
				break;
			}
		}
	}
;
hhFaHI:,Western European StopwordsH	Monaco8,pR8\$\$2R*chHH@	R*(,,g	`d'	Monaco		HelveticaConfidentialHhhFl,pFMPSRBBSTL
