#define USE_HTML_STATUS
#include <adv.t>
#include <std.t>
#include <command.t>
#include <parse.t>
#include <kitchen.t>

modify version
	sdesc = "\b\(Mr. Remote Mom\) \n
	Written for the Toaster-Comp held by Mark Musante. \n
	Copyright 2000 by Lenny Pitts \n
	Please mail any comments or bug reports to ten365bye@yahoo.com \n ";
;

replace init: function
{
	local i, keyPress;
#ifdef USE_HTML_STATUS
	/* 
     	*   We're using the adv.t HTML-style status line - make sure the
     	*   run-time version is recent enough to support this code.  (The
     	*   status line code uses systemInfo to detect whether the run-time
     	*   is HTML-enabled or not, which doesn't work properly before
     	*   version 2.2.4.)  
     	*/
	if (systemInfo(__SYSINFO_SYSINFO) != true
        || systemInfo(__SYSINFO_VERSION) < '2.2.4')
    	{
		"\b\b\(WARNING! This game requires the TADS run-time version
        	2.2.4 or higher.  You appear to be using an older version of the
        	TADS run-time.  You can still attempt to run this game, but the
        	game's screen display may not work properly.  If you experience
        	any problems, you should try upgrading to the latest version of
        	the TADS run-time.\)\b\b";
	}
#endif

	/* perform common initializations */
	"\H+";
	if ( systemInfo(__SYSINFO_HTML ) = 1 )
	{
		global.htmlEnabled := true;
	}
	else
	{
		global.htmlEnabled := nil;
	}
	commonInit();
	randomize;
	// put introductory text here
	"\b ";
	"When your wife told you she had to suddenly go out of town to visit her mother 
	you assured her everything would be alright. She fretted about arranging for 
	someone to come help you out, but you wouldn\'t hear of it. After all, if you 
	can handle fighting super criminals for a living you can certainly handle 
	getting yourself and Josh fed and out the door in the morning. She went on 
	and on about the \"procedures\" she follows, and you just shook your head and 
	nodded. Like you really need to lay your next days socks out the night before. 
	After she left on Sunday afternoon you and Josh got to have quality \"men\" time, 
	playing with every ball Josh owns in the house. Then, ice cream for dinner and 
	a \"Creature Double Feature\" marathon. Monday morning did not go quite 
	so smoothly. Josh refused to wear the clothes you picked out for him, so you 
	compromised and let him wear his \'Spiderman\' Underoos t-shirt if he would 
	at least wear his pants. That crisis over, you just have to get him fed before
	you can get him to day care, and you to the office. ";

	version.sdesc;                // display the game's name and version number
	"\b ";
	// setdaemon(turncount, nil);                 // start the turn counter daemon
	notify(startroom, &timeDaemon, 0);
	
	//  outfit.moveInto(parserGetMe());
	// outfit.isworn := true;
	parserGetMe().location := startroom;       // move player to initial location
	startroom.lookAround(true);                // show player where he is
	startroom.isseen := true;                  // note that we've seen the room
}

// ********************************************************
// This code modifies several verbs from adv.t
// Here to eliminate the use of ALL with most verbs
// Clipped from Stephen Granade's Arrival (with permission)
// The only modifications to Stephen's code that I made was to 
// change the style of operators from C++ to normal TADS.

// ***********BEGIN CLIPPED CODE****************************

// I only want you to be able to use certain verbs with the word 'all'.
// This requires some fiddling with the rejectMultiDobj function in deepverb

modify global 
	verbose = true
	tmpV = nil
	tmpDO = nil
	tmpProp = nil
	tmpIO = nil
	lastGoodDO = nil
	lastGoodAct = nil
	lastGoodVerb = nil
	lastGoodPrep = nil
	lastGoodIO = nil
	parseFlag = nil
	myCommand = ''
	myStat = nil
	isVerbPrep = nil
	verbString = ''
	commandStack = []
	commandList = []
	commandListIndex = 0
	lastActor = nil
	tMin = 55
	tSec = 0
	sysTicks = 0
	rightStatusText = ''
	leftStatusText = ''
;

modify deepverb
    rejectMultiDobj(prep) = {
        if (self.allowall or find(objwords(1), 'all') = nil)
            return nil;
        "You can\'t use \(all\) with this verb. ";
        abort;
    }
;

replace takeVerb: deepverb      // This object defines how to take things
    allowall=true
    verb = 'take' 'pick up' 'get'
    sdesc = "take"
    ioAction(offPrep) = 'TakeOff'
    ioAction(outPrep) = 'TakeOut'
    ioAction(fromPrep) = 'TakeOut'
    ioAction(inPrep) = 'TakeOut'
    ioAction(onPrep) = 'TakeOff'
    ioAction(withPrep) = 'TakeWith'
    doAction = 'Take'
    doDefault(actor, prep, io) =
    {
        local ret, rem, cur, rem2, cur2, tot, i, tot2, j;
        
        ret := [];
        
        /*
         *   For "take all out/off of <iobj>", return the (non-fixed)
         *   contents of the indirect object.  Same goes for "take all in
         *   <iobj>", "take all on <iobj>", and "take all from <iobj>".
         */
        if ((prep = outPrep or prep = offPrep or prep = inPrep
             or prep = onPrep or prep = fromPrep)
            and io <> nil)
        {
            rem := io.contents;
            i := 1;
            tot := length(rem);
            while (i <= tot)
            {
                cur := rem[i];
                if (not cur.isfixed and self.validDo(actor, cur, i))
                    ret += cur;
                ++i;
            }
            return ret;
        }
        
        /*
         *   In the general case, return everything that's not fixed
         *   in the actor's location, or everything inside fixed containers
         *   that isn't itself fixed.
         */
        rem := actor.location.contents;
        tot := length(rem);
        i := 1;
        while (i <= tot)
        {
            cur := rem[i];
            if (cur.isfixed)
            {
                if (((cur.isopenable and cur.isopen) or (not cur.isopenable))
                    and (not cur.isactor))
                {
                    rem2 := cur.contents;
                    tot2 := length(rem2);
                    j := 1;
                    while (j <= tot2)
                    {
                        cur2 := rem2[j];
                        if (not cur2.isfixed and not cur2.notakeall)
                        {
                            ret := ret + cur2;
                        }
                        j := j + 1;
                    }
                }
            }
            else if (not cur.notakeall)
            {
                ret := ret + cur;
            }
            
            i := i + 1;            
        }
        return ret;
    }
;

modify removeVerb
	verb = 'take off' 'doff' 'remove'
;

// Besides allowing "all" to work with drop, allow "drop xxx in yyy" ==
//  "put xxx in yyy" and "drop xxx on yyy" == "put xxx on yyy".
modify dropVerb
    allowall=true
    ioAction(inPrep) = 'PutIn'
    ioAction(onPrep)='PutOn'
;

modify putVerb
    allowall=true;
;

// *******************END CODE CLIPPED FROM ARRIVAL***************
// ***************************************************************


// modify basicMe
//    actorAction(verb, dobj, prep, iobj) = 
//   {
//	global.tmpV := verb;
//	global.tmpDO := dobj;
//	global.tmpPrep := prep;
//	global.tmpIO := iobj;
//   }
//;

replace scoreStatus: function(a,b)
{
	if ( global.htmlEnabled )
	{
		// we're using an HTML TADS runtime
		"<BANNER ID=StatusLine HEIGHT=PREVIOUS><BODY BGCOLOR=BLACK TEXT=RED><B>";
		parserGetMe().location.statusRoot;
		"</B><TAB ALIGN=RIGHT><B>";
		say( global.rightStatusText );
		"</B></BANNER>";
	}
	else
	{
		// we're using a plain-text TADS runtime
		setscore( global.rightStatusText );
	}
}

modify room
	statusLine =
	{
		if ( global.htmlEnabled )
		{
			scoreStatus('','');
		}
		else
		{
		        self.statusRoot;
		        self.dispParagraph;
		}
	}
;

replace scoreRank: function()
{
	"\n ";
	"Um, no score. ";
	"\n ";
}

modify thing
	verDoPutIn(actor,io) =
	{
		if(io = toaster && self != bread)
		{
			"\^<<self.thedesc>> will not fit in the toaster. ";
		}
		else
		{
			pass verDoPutIn;
		}
	}
	verDoPlaywith(actor) = {}
	doPlaywith(actor) = 
	{
		if(actor = parserGetMe())
		{
			if(josh.isIn(parserGetMe().location))
			{
				"You get Josh\'s attention. \"Hey Josh! Watch me 
				fight this super evil <<self.sdesc>>.\" You pretend 
				to struggle in a battle for toast supremecy with 
				<<self.sdesc>> until Josh starts laughing at you. ";
				if(josh.flag6 = nil) // he is already hurt
				{
					josh.flag7 := nil;
				}
			}
			else
			{
				"Imaginary games are fine with the kid, but don\'t 
				you think this is taking things a little too far. ";
			}
		}
		else if(actor = josh)
		{
			local playWords;
			playWords := rand(5);
			switch(playWords)
			{
				case 1:
					"Josh spins in a circle and shouts, \"Dad, watch out! \^<<self.thedesc>> is going to get you.\" \n";
					break;
				case 2:
					"Josh looks <<self.thedesc>> up and down and says, \"Dad, that\'s no fun.\"\n ";
					break;
				case 3:
					"Josh jumps and gives <<self.thedesc>> a fake karate chop. \n";
					break;
				case 4:
					"Josh runs in circles and shouts, \"\^<<self.sdesc>>-head! \^<<self.sdesc>>-head!\" \n";
					break;
				case 5:
					"Josh retorts, \"No, I\'m playing bag head.\" \n";
					break;
			}
		}
	}
;


win: function()
{
    "\bYou may restore a saved game, start over, quit, or undo
    the current command.\n";
    while (true)
    {
        local resp;

        "\nPlease enter RESTORE, RESTART, QUIT, or UNDO: >";
        resp := upper(input());
        if (resp = 'RESTORE')
        {
            resp := askfile('File to restore',
                            ASKFILE_PROMPT_OPEN, FILE_TYPE_SAVE);
            if (resp = nil)
                "Restore failed. ";
            else if (restore(resp))
                "Restore failed. ";
            else
            {
                parserGetMe().location.lookAround(true);
                scoreStatus(global.score, global.turnsofar);
                abort;
            }
        }
        else if (resp = 'RESTART')
        {
            scoreStatus(0, 0);
            restart();
        }
        else if (resp = 'QUIT')
        {
            terminate();
            quit();
        }
        else if (resp = 'UNDO')
        {
            if (undo())
            {
                "(Undoing one command)\b";
                parserGetMe().location.lookAround(true);
                scoreStatus(global.score, global.turnsofar);
                abort;
            }
            else
                "Sorry, no undo information is available. ";
        }
    }
}

incTimer: function
{
	if(global.tSec = 59 && global.tMin = 59)
	{
		"\b You fail to leave the house on time to make your meeting. 
		You get demoted to the super hero parking garage squad. ";
		win();
	}
	if(global.tSec = 59)
	{
		global.tSec := 0;
		global.tMin++;
	}
	else
	{
		global.tSec++;
	}
	printTimer();
}

printTimer: function
{
	local msg, strSec;
	if(global.tSec < 10)
	{
		strSec := '0' + cvtstr(global.tSec);
	}
	else
	{
		strSec := cvtstr(global.tSec);
	}
	msg := '7:' + cvtstr(global.tMin) + ':' + strSec;
	setscore(msg);
	global.rightStatusText := msg;
	scoreStatus('','');
}

