# Welt der Fränze

import sys, tkinter, pickle, os.path

# Globale Variablen
rDatei="wdfRes.txt"
verbnr=0
objekt1=0
objekt2=0
redeObjekt=0 # um das Objekt gehts beim aktuellen Dialog
raum=1
level=1 #Spielstadium
nrExit=0
modus=0 # 0 normal, 1=dialog
dialogNr=0 #Nummer des aktuellen Dialogs in dS, dR
dialogS=[]
HText="""Geschrieben 2016-2017 von Anselm v. C. (anselm1109vc@gmail.com)

        Klicke auf den Titel zum Umsehen
    
    -F1- Diese Seite anzeigen
    -S- Spielstand speichern
    -L- Spielstand laden
    -N- Neu starten"""


# import logikWDF.py
#-------------------- Logik ---------(auslagern)---------------
# level 1: Im Haus
# level 2: In der Welt
# level 3: böser Franz tot

Titel="WELT DER FRÄNZE"
verb=[["Gehe (zu)",1],["Gib",2], ["Benutze",2], ["Rede mit",1], ["Drücke",1], ["Öffne",1], ["Schau an",1], ["Ziehe",1], ["Schließe",1], ["Nimm",1]]

def aktion(v, o1, o2, reak=""):
    #txt.tag_delete("*1")
    global level
    if (v==9) and  imInv(o1):# Wenn man was nimmt, das man schon hat
        return ""
    if o1==1:   #Flasche
        if v==6: #Schau an
            reak="Ich betrachte die Flasche. Auf dem Etikett steht 'Franzbranntwein'."
        elif v==9: #Nimm
            insInventar(1)
            reak=" "
        elif v==5: #Öffne
            if raum==6:
                reak="+Doch nicht hier im Freien!"
            else:
                insInventar(1)
                if getzustand(4)==0:
                    reak="Vorsichtig schraube ich den Verschluss der Flasche ab. \
                    Dann ein Zischen, Rauch erfüllt den Raum. Die Schwaden formen sich zu einem *4 Geist."
                    sichtbar(4)
                    inRaum(4)
        elif v==2: #Benutze
            if o2==15 and getzustand(15)==0:
                setzustand(15,1)
                reak="Vorsichtig fülle ich den Franzbranntwein in die Lampe."
    elif o1==2: #Schlüssel
        if v==6: #Schau an
            reak="Mein Schlüssel kommt mir sehr bekannt vor."
        elif v==9: #Nimm
            insInventar(2)
            reak=" "
        elif v==2: #Benutze
            if o2==11: # Haustür
                setzustand(11,1)
                insInventar(2)
                unsichtbar(2)
                reak="Mit Hilfe des Schlüssels ist es ganz leicht, die Tür aufzuschließen. Also mache ich das."
    elif o1==3: #Fisch
        if v==6: # Schau an
            reak="Dieser Fisch ist gelb und glibbrig. Seltsam."
    elif o1==4: #Geist
        if v==6: #Schau an
            reak="Der Geist sieht aus wie die meisten Geister. Nur etwas blauer."
        if v==3: #Rede mit
            if getzustand(4)==0:
                reak=rede(1)
            else:
                reak=rede(2)    # wenn man nochmal mit ihm redet
    elif o1==5: #Licht
        if v==6: #Schau an
            reak="Das Licht gehört zum Lichtschalter."
        if v==4: #Drücke
            setzustand(5,1)
            reak=" "
            raumWechsel(5)
    elif o1==6: #Kerze
        if v==6: #Schau an
            if getzustand(6)==0:
                reak="Die Kerze ist aus echtem Bienenwachs."
            else:
                reak="Hurra, die (erste) Kerze brennt."
        elif v==9: #Nimm
            insInventar(6)
            reak="Ich nehme die Kerze mit."
        elif v==3: # Rede
            reak="Egal, was ich die Kerze frage: Sie antwortet nicht."
        elif v==2: # Benutze
            if o2==10: #Feuerzeug
                if getzustand(6)==0 and imInv(6):
                    setzustand(6,1)
                    if getzustand(11)==0: #Tür noch nicht aufgeschlossen
                        sichtbar(2) # Schlüssel sichtbar
                    reak="Ich zünde die Kerze an. Schon ist es hier gemütlicher."
            elif o2==13: #Kerze
                insInventar(15)
                unsichtbar(6)
                unsichtbar(13)
                reak="Vorsichtig zwicke ich mit meinen Fingernägeln den Docht der Kerze ab und bringe ihn im Anhänger an. Jetzt habe ich eine Lampe."
                
    elif o1==7: #Holzstapel
        if v==6: #Schau an
            if getzustand(7)==0:
                reak="Ich hätte mich beim Stapeln etwas bemühen können. Sieht ein wenig wackelig aus."
            elif getzustand(7)==1:
                reak="Gleich stürzt dieser Stapel ein. Ich bin besser vorsichtig."
            elif getzustand(7)==2:
                reak="Ein Haufen Holz. Und da liegt auch mein *10 Feuerzeug."
                setzustand(7,3)
                sichtbar(10)
            elif getzustand(7)==3:
                reak="Nur ein Haufen Holz."
        elif v==4 :# Drücke
            if getzustand(7)==0:
                reak="Ich drücke das Holz etwas nach hinten. Viel stabiler wird das so aber nicht."
                setzustand(7,1)    
        elif v==7:  #Ziehe
            if getzustand(7)==1:
                reak="Vorsichtig ziehe ein Holzstück heraus ... Zu spät. Ein Krachen und er Stapel fällt in sich zusammen."
                setzustand(7,2)
    elif o1==9: #Kellertür
        if v==0: # Gehe
            if getzustand(5)==0:
                raumWechsel(4)
            else:
                raumWechsel(5)
            reak=" "
    elif o1==8: # Treppe im Keller nach oben
        if v==6: # Schau an
            reak="Sie sieht nicht mehr sehr vertrauenswürdig aus, diese Treppe, aber scheint zu halten."
        if v==0: # Gehe
            raumWechsel(3)
            reak=" "
    elif o1==10: #Feuerzeug
        if v==6: #Schau
            reak="Es ist ein nagelneues Feuerzeug, hat aber schon ein paar Kratzer."
        elif v==9: #Nimm
            insInventar(10)
            reak="Ich stecke es ein."
        if v==2: # Benutze
            if o2==6: #Kerze
                if getzustand(6)==0 and imInv(6):
                    setzustand(6,1)
                    if getzustand(11)==0: #Tür noch nicht aufgeschlossen
                        sichtbar(2) # Schlüssel sichtbar
                    reak="Ich zünde die Kerze an. Schon ist es hier gemütlicher."
            elif o2==10:#Feuerzeug
                reak=="+Ich bin doch nicht wahnsinnig."
            elif o2==1: #Flasche
                reak="+Ich bin doch nicht verrückt!"
            elif o2==12: #Hund
                reak="+Nana! Das geht ja nun wirklich nicht."
            elif o2==15 and getzustand(15)==0:
                reak="+Das wird nicht reichen. Was soll denn da brennen?"
            elif o2==15 and getzustand(15)==1:
                setzustand(15,2)
                level=2
                raumWechsel(7)
            elif o2==15 and getzustand(15)==2:
                reak="+Die Lampe brennt schon."
            else:
                reak="+Was soll das denn? Ich zünde nicht alles an was ich sehe."
    elif o1==11: #Haustür
        if v==6: #Schau an
            if getzustand(4)==1:
                reak="Ich schaue durch das kleine Fenster in der Tür. Da draußen bewegt sich etwas durch den Nebel."
            else:
                reak="Ich schaue durch das kleine Fenster in der Tür. Der Nebel draußen wird immer dichter."
        elif v==2: #Benutze
            if o2==2: # Schlüssel
                setzustand(11,1)
                insInventar(2)
                unsichtbar(2)
                reak="Mit Hilfe des Schlüssels ist es ganz leicht, die Tür aufzuschließen. Also mache ich das."
        elif v==5: #Öffne
            if getzustand(11)==0:
                reak="Mein Versuch, die Haustür zu öffnen schlägt fehl. Sie ist verschlossen."
            elif getzustand(11)==1:
                setzustand(11,2) #Tür offen
                reak="Mit einem leisen Quietschen öffnet sich die Tür ins Freie. Ein kalter Windhauch lässt die Kerze verlöschen."
                setzustand(6,0) #Kerze aus
                if getzustand(4)==1:
                    sichtbar(12) #Hund
                    if not imInv(13):
                        sichtbar(13)
            elif getzustand(11)==2:
                reak="+Die ist doch schon offen."
        elif v==0: #Gehe
            if not getzustand(11)==2:
                reak="+Ich gehe normalerweise nicht durch geschlossene Türen."
            else:
                setzustand(11,1) # Tür zu
                raumWechsel(6)
    elif o1==14: #Schrank
        if v==6: #Schau an
            if getzustand(14)==0:
                reak="Mein Schrank ist etwas ganz besonderes. Gekauft habe ich ihn in London, auf dem Flohmarkt. Der Verkäufer sagte, er berge ein Geheimnis."
            elif getzustand(14)==1:
                reak="Der Schrank steht offen. Ich habe nur ein paar Schuhe und einen Overall darin."
        elif v==5: # Öffne
            if getzustand(14)==0:
                setzustand(14,1)
                setzustand(37,1)
                reak="Ich öffne den Schrank."
        elif v==0: #Gehe
                reak="+Das mache ich auf keinen Fall. In solchen Schränken sind schon Leute verschwunden."
    elif o1==12: #Hund
        if v==6: # Schau an
            if getzustand(12)==0:
                reak="Das Tier sieht aus, als würde es die ganze Zeit im Freien leben."
            else:
                reak="Dieser Hund ist wirlich seltsam. Er zwinkert mir zu."
        elif v==3: #Rede
            if getzustand(12)==0:
                reak=rede(3)
            else:
                reak="+Ich habe keinen weiteren Gesprächsbedarf."
    elif o1==13: #Anhänger
        if v==6: #Schau an
            if imInv(13):
                reak="Ich schaue mir den Anhänger genauer an. Es scheint eine kleine Lampe zu sein."
            else:
                reak="Von hier aus kann ich nicht so genau erkennen, was das für ein Anhänger ist."
        elif v==9: #Nimm
            if getzustand(12)==0:
                reak="Der Hund schnappt sofort nach meiner ausgestreckten Hand."
            else:
                insInventar(13)
                reak="Ich strecke vorsichtig die Hand aus. Dann löse ich den Anhänger vom Halsband. /n Da scheint das Tier zu lächeln. Ja, es zwinkert mir zu."
        elif v==2: #Benutze
            if o2==6: #Kerze
                insInventar(15)
                unsichtbar(6)
                unsichtbar(13)
                reak="Vorsichtig zwicke ich mit meinen Fingernägeln den Docht der Kerze ab und bringe ihn im Anhänger an. Jetzt habe ich eine Lampe."
    elif o1==15: #Lampe
        if v==6: #Schau an
            reak="Ich betrachte die Lampe genauer. Sie scheint schon alt zu sein. Irgenwie sieht sie aus, als wäre sie nicht von dieser Welt."
        elif v==2: #Benutze
            if o2==1 and getzustand(15)==0:
                setzustand(15,1)
                reak="Vorsichtig fülle ich den Franzbranntwein in die Lampe."
            elif o2==10 and getzustand(15)==0:
                reak="+Das wird nicht reichen. Was soll denn da brennen?"
            elif o2==10 and getzustand(15)==1:
                setzustand(15,2)
                level=2
                raumWechsel(7)
            elif o2==10 and getzustand(15)==2:
                reak="+Die Lampe brennt schon."
    elif o1==16: # Bretterwand (Rückkehr)
        if v==6:# Schau an
            if getzustand(16)==0:
                reak="Die Wand besteht aus einer Reihe senkrecht angenagelter Bretter."
            else:
                reak="Die Wand besteht aus senkrechten Brettern und hat eine *17 Lücke."
            if getzustand(18)==0:
                reak=reak+" Im dritten Brett von links ist oben ein winziges *18 Loch."
            else:
                reak=reak+" Und irgendwie: Ich spüre es, die Wand scheint auf seltsame Weise zu leben."
        elif v==4 and getzustand(16)==0: #Drücke
            setzustand(16,1)
            sichtbar(17)
            reak="Als ich gegen die Bretterwand drücke, fällt eines der Brettchen heraus. Es ist eine *17 Lücke entstanden."
        elif v==0: #Gehe
            if getzustand(18)==0:
                reak="+Da hole ich mir nur eine blutige Nase."
            else:
                raumWechsel(35)
    elif o1==18: # Loch in Schrankrückwand
        if v==6:#Schau an
            reak="Es hat einen Durchmesser von ungefähr einem Millimeter."
        elif v==2: #Benutze
            if o2==22: #Nagel
                unsichtbar(22)
                insInventar(18)
                unsichtbar(18)
                setzustand(18,1)
                reak="Ich nehme den Nagel und drücke ihn in das Loch. Er passt genau. Fasst glaube ich, die Wand habe sich bewegt."
                
    elif o1==17: # Lücke
        if v==6: #Schau an
            if getzustand(19)==0 :
                reak="Dort hinter der Wand hängt etwas. Sieht aus wie ein *19 Kleidungsstück."
            else:
                reak="Hinter der Wand ist es dunkel."
    elif o1==19: #Kleidungsstück     
        if v==6 and imInv(19): #Schau an
            unsichtbar(19)
            setzustand(19,2) # angezogen
            reak="Es ist ein gelber Overall. Auf der Brusttasche steht mein Name. /n Bei diesen rauhen Bedingungen wird es nicht schaden, ihn anzuziehen."
        elif v==6:
            reak="Von hier kann ich es nicht genau sehen."
        elif v==9: #Nimm
            insInventar(19)
            setzustand(19,1) #genommen
            reak="Vorsichtig ziehe ich das Kleidungsstück durch die Lücke."
    elif o1==38:  #Heuhaufen
        if v==6:
            reak="Das hier ist wirklich ein großer Haufen Heu. Man könnte sich darin verlaufen."
        elif v==0: #Gehe
            if getzustand(19)<2:
                reak="Ich versuche in das Heu einzudringen. Aber ich zerkratze mir alles. So geht das nicht."
            else:
                raumWechsel(28)
    elif o1==22: #Nagel
        if v==9: #Nimm
            insInventar(22)
            reak="Den Nagel nehme ich zu mir."
        elif v==6: #Schau an
            reak="Der Nagel ist ein bischen rostig."
        elif v==2: #Benutze
            if o2==18: #Loch in der Bretterwand
                unsichtbar(22)
                insInventar(18)
                unsichtbar(18)
                setzustand(18,1)
                reak="Ich nehme den Nagel und drücke ihn in das Loch. Er passt genau. Fasst glaube ich, die Wand habe sich bewegt."
    elif o1==37: # Schranktüre
        if v==0 and getzustand(37)==1:
            raumWechsel(36)
        elif v==5 or v==4: #Öffne oder drücke
            if getzustand(37)==0:
                setzustand(37,1)
                reak="Ein leises Knarzen, als sich die Tür des Schranks öffnet."
            else:
                reak="+Die Schranktür steht schon offen."
    elif o1==20: #Regal
        if v==6: #Schau an
            reak="Das Regal hier ist vollgestopft mit allerlei technisch aussehendem Kram."
        elif v==4 or v==7 : #Ziehe, Drücke
            reak="+Da fasse ich besser nicht ran. Es könnte mich begraben."
    elif o1==21: #Böser Franz
        if v==6: # Schau an
            reak="Dieser Franz sieht wirklich böse aus. Ich sollte mich aus dem Staub machen."
    elif o1==23: #Franz in Kneipe
        if v==6: #Schau an
            reak="Der andere Kneipenbesucher wirkt irgenwie traurig. Er starrt teilnahmslos in sein Glas."
        elif v==3:#Rede mit
            reak=rede(6)
    elif o1==24: # Hund/Wirt
        if v==6: #Schau an
            reak="Ich kenne dieses Tier. Immer wieder scheint er mir zuzuzwinkern."
        elif v==3:#Rede mit
            reak=rede(5)
    elif o1==25: #Franz am Brunnen
        if v==6: #Schau an
            if getzustand(21)==0 or getzustand(21)==10:
                reak="Der Franz liest ein Buch. So etwas habe ich noch nie gesehen."
            else:
                reak="Der Franz am Brunnenrand trägt ein großes Pflaster über der Stirn."
        elif v==3: #Rede mit
            if level==2:
                reak=rede(7)
            elif level==3:
                reak=rede(8)
    elif o1==26: #Mähender Franz
        if v==6: #Schau an
            reak="Er mäht nicht zum ersten mal. Das sieht man."
        elif v==3:#Rede mit
            reak=rede(4)
    elif o1==27: # Buch der Fränze
        if v==6: #Schau an
            reak="Das Buch trägt den Titel DAS GROSSE BUCH DER FRÄNZE. Sobald ich mal Zeit habe, will ich darin lesen."
        elif v==9: # Nimm
            insInventar(27)
            reak="Ein Buch zu lesen wird nicht schaden. Ich nehme es mit."
    elif o1==28: #Schüssel
        if v==6: #Schau an
            reak="Die Schüssel könnte man für Salat gebrauchen. Oder für etwas anderes."
        elif v==9:#Nimm
            insInventar(28)
            reak="Vielleicht kann ich die Schüssel mal gebrauchen. Ich packe sie ein."
        elif v==2 and imInv(28) and imInv(29): #Benutze
            if o2==29: #Gerät
                unsichtbar(28)
                setzustand(29,1)
                reak="Schüssel und Gerät kann man zusammenstecken."
    elif o1==29: # Gerät
        if v==6: #Schau an
            if getzustand(29)<1:
                reak="Ein solches Gerät habe ich noch nie gesehen. Es hat einen Schalter und zwei Lampen, die mit den Worten BÖS und LIEB beschriftet sind."
            else:
                reak="Diese Konstruktion sieht aus wie ein Messgerät."
        elif v==1: #Gib
            if o2 in [21, 23, 34, 25, 26]:
                reak="Dieses Messgerät sollte nicht in falsche Hände geraten. Ich werde gut darauf aufpassen."
        elif v==9: #Nimm
            insInventar(29)
            reak="Ich stecke das Gerät ein."
        elif v==2: #Benutze
            if o2==28 and imInv(28) and imInv(29): #Schüssel
                unsichtbar(28)
                setzustand(29,1)
                reak="Schüssel und Gerät kann man zusammenstecken."
            elif o2==31: #Schraube
                if getzustand(29)==0:
                    reak="Ich könnte die Schraube in das Gerät eindrehen. Das scheint aber keinen Sinn zu geben."
                elif getzustand(29)==1:
                    insInventar(31)
                    unsichtbar(31)
                    setzustand(29,2)
                    reak="Mit der Schraube kann ich die Schüssel richtig befestigen."
            elif o2 in [21, 23, 24, 25, 26]:
                if getzustand(29)==0:
                    reak="Ich schalte das Messgerät ein. Nichts passiert."
                elif getzustand(29)==1:
                    setzustand(29,0)
                    insInventar(28)
                    reak="Ich halte das Messgerät hoch. Ein Scheppern - es ist auseinander gefallen."
                elif o2==21:
                    reak="Die BÖS-Lampe des Messgeräts blinkt hektisch. Der Franz scheint sehr sehr böse zu sein."
                elif o2==23:
                    setzustand(23,getzustand(23)+10)
                    reak="Ich richte das Messgerät auf den Franz. Die BÖS-Lampe leuchtet auf."
                elif o2==25 or o2==26:
                    setzustand(o2,getzustand(o2)+10)
                    reak="Ich richte das Messgerät auf den Franz. Die LIEB-Lampe leuchtet auf."
                elif o2==24:
                    reak="Ich richte das Messgerät auf den Hund. Nichts passiert."
    elif o1==30: #Kabel
        if v==6: #Schau an
            reak="Das etwa fingerdicke Kabel hat an jedem Ende einen Stecker."
        elif v==9: #Nimm
            insInventar(30)
            reak="Weil man ein Kabel IMMER brauchen kann, stecke ich es ein."
        elif v==2:#Benutze
            reak="Hmm. Das Kabel passt hier nicht wirklich."
    elif o1==31: #Schraube
        if v==6: #Schau an
            reak="Diese Schraube scheint irgenwo zu fehlen. Oder irgendwem."
        elif o2==29: #Gerät
                if getzustand(29)==0:
                    reak="Ich könnte die Schraube in das Gerät eindrehen. Das scheint aber keinen Sinn zu geben."
                elif getzustand(29)==1:
                    insInventar(31)
                    unsichtbar(31)
                    setzustand(29,2)
                    reak="Mit der Schraube kann ich die Schüssel richtig befestigen."
        elif v==9: #Nimm
            insInventar(31)
            reak="Die Schraube kommt in meine Hosentasche."
    elif o1==32: #Blechstreifen
        if v==6: #Schau an
            if getzustand(32)==0: # an der Dachrinne
                reak="Diese Befestigung ist wohl etwas locker."
            elif getzustand(32)==1: # genommen
                reak="Der dünne Streifen besteht aus Kupfer. Dort, wo ich ihn herausgerissen habe hat er ein ausgefranztes Loch."
        elif v==2: #Benutze
            if o2==33: #Stein
                unsichtbar(33)
                unsichtbar(32)
                insInventar(39)
                reak="Ich drücke den Stein in das Loch des Blechstreifens und biege diesen ein wenig in Form. Nun habe ich eine hübsche Krone."
        elif v==9:#Nimm
            reak="Der Blechstreifen sitzt zu fest, um ihn einfach zu nehmen."
        elif v==7:#Ziehe
            insInventar(32)
            setzustand(32,1)
            reak="Ich zerre ein wenig herum und halte plötzlich den Blechstreifen in der Hand."
    elif o1==33: #Stein
        if v==6: #Schau an
            reak="Dieser Stein ist wunderschön. Wie sich das Licht in ihm bricht!"
        elif v==2: #Benutze
            if o2==32: #Blechstreifen
                unsichtbar(33)
                unsichtbar(32)
                insInventar(39)
                reak="Ich drücke den Stein in das Loch des Blechstreifens und biege diesen ein wenig in Form. Nun habe ich eine hübsche Krone."
        elif v==9: #Nimm
            insInventar(33)
            setzustand(33,1)
            reak="Ich nehme den Stein mit."
    elif o1==34: #Dachrinne
        if v==6 and getzustand(32)==0: #Schau an
            reak="Diese Dachrinne soll verhindern, dass das Regenwasser einfach herunterläuft. Sie ist mit *32 Blechstreifen befestigt."
        elif v==6:
            reak="Diese Dachrinne hat nichts wirklich spannendes zu bieten."
    elif o1==39: #Krone
        if v==6: #Schau an
            reak="In meinen Händen halte ich eine herrliche Krone. Sie muss für einen König bestimmt sein."
        elif v==1 and o2 in [26,24,23,25]: #Gib
            if int(getzustand(o2)/10)==0: #ungemessen
                reak="Diese Krone sollte nicht in falsche Hände geraten. Solange ich nicht weiß, wen ich vor mir habe..."
            else:
                if o2==26:
                    reak="Feierlich will ich dem Franz die Krone überreichen. Doch er schreckt zurück. /n 'Ich will kein König sein. Das ist mir viel zu anstrengend!', meint er."
                elif o2==24:
                    reak="Der König der Fränze sollte schon ein Franz sein. Dem Hund gebe ich die Krone sicher nicht."
                elif o2==23:
                    reak="Dieser Franz ist böse! Er wäre kein guter König. Niemals sollte er die Krone in die Finger bekommen."
                elif o2==25:
                    unsichtbar(23)#Kneipenfranz
                    sichtbar(21) #Böser Franz
                    setzustand(21,1)
                    insInventar(25)
                    unsichtbar(25) #Franz am Brunnen
                    unsichtbar(39)#Krone
                    reak="""Feierlich drücke ich dem Franz die Krone aufs Haupt. Mit Tränen in den Augen wendet er sich an mich: /n 'Oh Fremder! Deine Wahl ist gut. Ich will den Fränzen ein guter König sein.
                             /n /n Da öffnet sich die Tür der Kneipe. Ein wutentbrannter Franz stürmt heraus. Er schlägt den vor Schreck starren König nieder und entreist
                               diesem die Krone. Dann setzt er sie sich selbst auf den Kopf. Während der wahre König die Flucht ergreift wendet sich der böse Franz an mich: /n /n 'Fremder! Ich bin es, dem die Königswürde gebührt. Dies ist meine Stunde.
                               Und als erstes werde ich DICH vernichten, Eindringling. Und dann werde ich die ganze Welt beherrschen!'"""
    elif o1==35: # Fenster
        if v==6: #Schau an
            if getzustand(35)==0:
                reak="Von hier aus kann man bis hinunter ins Dorf sehen. Am Horizont scheinen die Berge den Himmel zu berühren."
            elif getzustand(35)==1:
                reak="Von hier aus hat man einen herrlichen Blick. Man sieht sogar die *34 Dachrinne des Turms."
        elif v==5:#Öffne
            if getzustand(35)==0:
                setzustand(35,1)
                reak="Ich öffne das Fenster. Sofort strömt frische Luft ins Turmzimmer."
    elif o1==36: #Steine
        if v==6: #Schau an
            if getzustand(36)<3:
                reak="Hier liegen so viele Steine. Irgendetwas muss eingestürzt sein."
            else:
                if getzustand(33)==0:
                    reak="Ein glänzender *33 Stein liegt zwischen diesen Steinen."
                else:
                    reak="Hier liegen ... Steine. Ja."
        elif v==4 or  v==7:# Drücke oder ziehe
            if getzustand(36)==0:
                setzustand(36,1)
                reak="Es ist harte Arbeit, ein paar der Steine beiseite zu räumen."
            elif getzustand(36)==1:
                setzustand(36,2)
                reak="Ich räume noch ein paar Steine weg."
            elif getzustand(36)==2:
                setzustand(36,3)
                sichtbar(33) #Stein
                reak="Jetzt habe ich schon einiges beiseite geräumt. Trotzdem geht es hier nicht weiter."
            elif getzustand(36)==3:
                reak="+Es reicht. Ich bin schon völlig verschwitzt."
    elif o1==40: #Loch nach Einsturz
        if v==0: #Gehe
            raumWechsel(17)
        elif v==6: #Schau an
            reak="Ich könnte versuchen, durch die Öffnung nach oben zu klettern."
    elif o1==41: #zum einsturzraum
        if v==0:# Gehe
            if getzustand(21)==0 or getzustand(21)==2:
                raumWechsel(13)
            elif getzustand(21)==1:
                 insInventar(21) #böser Franz weg
                 unsichtbar(21)
                 setzustand(21,2)
                 sichtbar(40)
                 level=3
                 sichtbar(25)
                 raumWechsel(38)
    elif o1==42: #zum einsturzraum
        if v==0:#Gehe
            if getzustand(21)==0 or getzustand(21)==2:
                raumWechsel(13)
            elif getzustand(21)==1:
                 insInventar(21) #böser Franz weg
                 unsichtbar(21)
                 setzustand(21,2)
                 sichtbar(40)
                 level=3
                 sichtbar(25)
                 raumWechsel(38)
    return reak # "+Text": Text in Befehlszeile, "" Standardablehnung, "Text" gettaged ins Fenster 
#--------------------------------------------------------------

# Routinen
def melde(txt):
    befehl.config(text=txt)
    
def Sichern(self):
    d=open("game1.sav","wb")
    savedata=(rListe, oListe, dS, dR, raum, level)
    pickle.dump(savedata, d)
    melde("Spielstand wurde gesichert.")
    d.close

def Laden(self):
    d="game1.sav"
    if os.path.exists(d):
        HoleSpiel(d)
        melde("Spielstand wurde geladen.")
    else:
        melde("Kein Spielstand gefunden")
    
def HoleSpiel(d):
    global raum, level, rListe, oListe, dS, dR, invListe
    d=open(d, "rb")
    loaddata=pickle.load(d)
    rListe=loaddata[0]
    oListe=loaddata[1]
    dS=loaddata[2]
    dR=loaddata[3]
    raum=loaddata[4]
    level=loaddata[5]
    betrete_raum(raum)
    invListe=LiesInventar()
    updInv(invListe)
    melde("...")
    

def Neustart(self):
    d="game.res"
    HoleSpiel(d)
    

def hilfeSeite(self):
    anz=tkinter.Toplevel()
    anz.attributes("-toolwindow",1)
    anz.resizable(width=False, height=False)
    txt=tkinter.Label(anz, text=Titel+"\n"+HText, height=0, width=40)
    txt.pack()
    anz.focus_force()
    anz.grab_set()
    
def raumWechsel(r): # Wechselt in den Raum
    global verbnr
    verbnr=0
    betrete_raum(r)

def imInv(nr):
    if oListe[nr-1][3]=="2":
        return True
    else:
        return False

def setzustand(nr, flag):
    oListe[nr-1][5]=str(flag)

def getzustand(nr):
    return int(oListe[nr-1][5])

def insInventar(nr):
    global invListe
    oListe[nr-1][3]="2"
    invListe=LiesInventar()
    updInv(invListe)
    txt.tag_delete("*"+str(nr))
        
def sichtbar(nr):
    oListe[nr-1][3]="1"

def unsichtbar(nr):
    global invListe
    oListe[nr-1][3]="0"
    invListe=LiesInventar()
    updInv(invListe)

def inRaum(nr):
    oListe[nr-1][4]=str(raum)

def dialogWahl(event):
    if not modus==1:
        return
    i=int(dialog.curselection()[0])
    tagText("--'"+dS[dialogNr][int(dialogS[i])][1]+"'")
    antwort=int(dS[dialogNr][int(dialogS[i])][2])
    tagText("'"+dR[dialogNr][antwort][1]+"'")
    setDialog(antwort)

def setDialog(reak):
    global dialogS, redeObjekt
    dialog.delete(0,dialog.size())
    dialogS=dR[dialogNr][reak][2].split(",") #zeilen enthält die verwendbaren zeilen als Liste
    dEnde=int(dialogS[0])
    if dEnde<=0: # Ende des Dialogs
          setMode(0)
          x=getzustand(redeObjekt)
          setzustand(redeObjekt, x+abs(dEnde)) # als Eigenschaft des Objekts abspeichern
    else:
        for j in range(len(dialogS)): 
            lin=dS[dialogNr][int (dialogS[j])]
            dialog.insert(dialog.size(),lin[1])
    
def inv_Enter(event):
    t=oListe[int(invListe[inventar.nearest(event.y)])-1][1]
    Befehl(t)
    
def inv_Leave(event):
   Befehl()
    
def invWahl(event):
    wahl=int(inventar.curselection()[0])
    objekt_klick(int(invListe[wahl]))

        
def LiesInventar(): # Inventarliste erneuern
    L=[]
    for i in range(len(oListe)):
        if oListe[i][3]=="2":
            L.append(oListe[i][0])
    return L

def updInv(liste): # Listbox updaten
    inventar.delete(0,inventar.size())
    for i in range(len(liste)):
        inventar.insert("end",(oListe[int(liste[i])-1][1]))

def erneuern(self):
    global raum
    betrete_raum(raum)

def enter_us(self):
    befehl.config(text="Schau dich um")

def leave_us(self):
    Befehl()

def invhoch(self):
    inventar.yview_scroll(-1, "units")

def invrunter(self):
    inventar.yview_scroll(1, "units")

# dialoge einlesen
def LiesDialoge():
    S=[] # Sätze des Spielers
    R=[] # Reaktion
    d=open(rDatei, encoding="latin-1")
    z=""
    while not (z[:5]=="[eof]"):
        z=d.readline()
        if z[:2]=="[D":
            zeileS=[]
            zeileR=[]
            zeileS.append((int(z[2:len(z)-2])))
            zeileR.append((int(z[2:len(z)-2])))
            while not z[:2]=="**":
                if z[:1]=="S":
                    zeileS.append(z.split("=="))
                if z[:1]=="R":
                    zeileR.append(z.split("=="))
                z=d.readline()
            S.append(zeileS)
            R.append(zeileR)
    d.close
    return S, R

# Räume einlesen
def LiesRaum():
    L=[]
    d=open(rDatei, encoding="latin-1")
    z=""
    while not z=="[eof]":
        t=""
        z=d.readline()
        if z[:2]=="[R":
            n=(int(z[2:len(z)-2]))
            #n=str(...)
            z=d.readline()
            while not z[:2]=="**":
                t=t+z
                z=d.readline()
            L.append([n,t])
    d.close
    L.sort()
    return L
    
# Objekte einlesen
def LiesObjekte():
    L=[]
    d=open(rDatei, encoding="latin-1")
    z=""
    while not z=="[eof]":
        z=d.readline()
        if z[:2]=="[O":
            n=int(z[2:len(z)-2])
            z=d.readline().split("==")
            z[0:0]=[n]
            L.append(z)         
    d.close
    L.sort()
    return L

def betreteTag(i):  # Tag einer Richtung
    Befehl(txt.get(str(i)+".first", str(i)+".last"))

def verlasseTag(self):
    Befehl()

def objekt_klick(nr):
    global objekt1, objekt2
    if objekt1==0:
        objekt1=nr    
    else:
        objekt2=nr
    Befehl()
    if (verb[verbnr][1]==1) or (verb[verbnr][1]==2 and not objekt2==0):
        reak=aktion(verbnr, objekt1, objekt2) # VERARBEITUNG DES BEFEHLS
        setVerb(0)
        if reak=="":
            melde(default[0])
        elif reak[0]=="+":
            melde(reak[1:])
        else:
            
            tagText(reak)

def objekt_enter(nr):
    s=oListe[nr-1][1]
    #if not objekt1==0:
    #   s=s+" mit "+oListe[nr-1][1]
    Befehl(s)

def objekt_leave(nr):
    Befehl()

    
# Text des aktuellen Raums bearbeiten
def getRaum(r):

# Objekttexte einfügen
    t=rListe[r-1][1]
    z=t.split()
    t=""
    for wort in z:
        if not wort[:2]=="#O":
            t=t+wort+" "
        else:
            nr=int(wort[2:])
            if oListe[nr-1][3]=="1" and (oListe[nr-1][4]=="0" or oListe[nr-1][4]==str(raum)):   # wenn sichtbar, oder mobil oder im richtigen raum
                oTxt=oListe[nr-1][2].split()
                for w in oTxt:
                    if not w[:1]=="#":
                        t=t+w+" "
                    else:
                        t=t+"*"+str(nr)+" "+w[1:]+" "
    return t

# Text taggen und ausgeben
def tagText(_text):
    global nrExit
    t=_text.split()
    flag=0
    txt.config(state="normal")
    for wort in t:
        if flag==1:     #bei Tag: nächstes Wort drucken
            txt.insert("end",wort+" ",tag)
            flag=0
            continue                
        if wort[:2]=="#R":  #Räume taggen
            nrExit=nrExit+1
            raum_neu=int(wort[2:])
            tag=str(nrExit)
            txt.tag_config(tag, foreground="blue")
            def button_handler(event, neu=raum_neu):
                return betrete_raum(neu)
            txt.tag_bind(tag,"<Button-1>", button_handler)
            def enter_handler(event, nr=nrExit):
                return betreteTag(nr)
            txt.tag_bind(tag, "<Enter>", enter_handler)
            txt.tag_bind(tag, "<Leave>", verlasseTag)
            flag=1
        elif wort[:1]=="*":  #Objekte taggen
            tag=wort
            txt.tag_config(tag, foreground="blue")
            def button_handler_2(event, ob=int(wort[1:])):
                return objekt_klick(ob)
            txt.tag_bind(tag,"<Button-1>",button_handler_2)
            def enter_handler_2(event, ob=int(wort[1:])):
                return objekt_enter(ob)
            txt.tag_bind(tag, "<Enter>", enter_handler_2)
            txt.tag_bind(tag, "<Leave>", objekt_leave)
            flag=1
        elif wort[:2]=="/n":
            txt.insert("end", "\n")
        else:
            txt.insert("end", wort+" ")
            txt.see("end")
    txt.insert("end","\n\n")
    txt.config(state="disabled")
            

    
# in den Raum mit der übergebenen Nummer wechseln
def betrete_raum(r):
    global raum, verbnr
    if modus==1:    #Dialog
        verbnr=1
    if not verbnr==0:   # wenn nicht "gehen"
        befehl.config(text=default[0])
        verbnr=0
    else:    
        raum=r
        nrExit=0
        txt.config(state="normal")
        txt.delete("1.0", "end")
        tagText(getRaum(r))  # Taggen und ausgeben    
        setVerb(0)  # verb gehen einstellen

   
# Befehle behandeln
# Neues Verb gedrückt: Dann Objekte auf 0
def setVerb(nr):
    global verbnr, objekt1, objekt2
    verbnr=nr
    objekt1=0
    objekt2=0
    Befehl()

# Update Befehlszeile
def Befehl(erg=""):
    s=verb[verbnr][0]+" "
    if not erg=="":
        if not objekt1==0:
            if verbnr==2:
                s=s+oListe[objekt1-1][1]+" mit "+erg
            elif verbnr==1:
                s=s+oListe[objekt1-1][1]+" an "+erg
        else:
            s=s+erg
    else:
        if not objekt1==0:
            s=s+oListe[objekt1-1][1]
            if verb[verbnr][1]==2:
                if verbnr==2:
                    s=s+" mit "
                elif verbnr==1:
                    s=s+" an "
        if not objekt2==0:
            s=s+oListe[objekt2-1][1]
    befehl.config(text=s)

# umschalten von Normal auf Dialog
def setMode(md):
    global modus
    modus=md
    if modus==0:
        m="normal"
        dialog.config(state="disabled")
    else:
        m="disabled"
        dialog.config(state="normal")
    b1.config(state=m)
    b2.config(state=m)
    b3.config(state=m)
    b4.config(state=m)
    b5.config(state=m)
    b6.config(state=m)
    b7.config(state=m)
    b8.config(state=m)
    b9.config(state=m)
    #inventar.config(state=m)
    #befehl.config(state=m)
    #txt.config(state=m)
    

# Dialog beginnen
def rede(dNr):
    global dialogNr, objekt1, redeObjekt
    setMode(1)
    redeObjekt=objekt1
    dialog.delete(0,dialog.size())
    dialogNr=0
    while not(dS[dialogNr][0]==dNr): # dialogNr ist Index des gesuchten Dialogs
        dialogNr=dialogNr+1
    setDialog(1)
    return dR[dialogNr][1][1] #Anfangssatz
   
# -----------------------------------------------------------------------
# Init

# Hauptfenster
wdf=tkinter.Tk()
wdf.title("")
wdf.resizable(width=False, height=False)
wdf.bind("<KeyPress-F1>", hilfeSeite)
wdf.bind("<KeyPress-s>", Sichern)
wdf.bind("<KeyPress-l>", Laden)
wdf.bind("<KeyPress-n>", Neustart)

# Oberfläche
uberschrift=tkinter.Label(wdf, text=Titel, anchor="center", font="Courier 16", relief="groove")
uberschrift.grid(row=0, column=0, columnspan=6, sticky="we")
uberschrift.bind("<Button-1>", erneuern)
uberschrift.bind("<Enter>", enter_us)
uberschrift.bind("<Leave>", leave_us)
txt=tkinter.Text(wdf, wrap="word", cursor="arrow")
txt.grid(row=1, column=0, ipadx=10, columnspan=6)
befehl=tkinter.Label(wdf, relief="groove")
befehl.grid(row=2, column=0, ipadx=50, columnspan=6, sticky="we")

default=["Das gibt keinen Sinn.", "Das mache ich nicht."]    # ein paar Standardstatusmeldungen
def b1_handler():
    setVerb(1)
b1=tkinter.Button(wdf, text=verb[1][0], command=b1_handler, width=7)
b1.grid(row=3, column=0, sticky="we")
def b2_handler():
    setVerb(2)
b2=tkinter.Button(wdf, text=verb[2][0], command=b2_handler, width=7)
b2.grid(row=3, column=1, sticky="we")
def b3_handler():
    setVerb(3)
b3=tkinter.Button(wdf, text=verb[3][0], command=b3_handler, width=7)
b3.grid(row=3, column=2, sticky="we")
def b4_handler():
    setVerb(4)
b4=tkinter.Button(wdf, text=verb[4][0], command=b4_handler, width=7)
b4.grid(row=4, column=0, sticky="we")
def b5_handler():
    setVerb(5)
b5=tkinter.Button(wdf, text=verb[5][0], command=b5_handler, width=7)
b5.grid(row=4, column=1, sticky="we")
def b6_handler():
    setVerb(6)
b6=tkinter.Button(wdf, text=verb[6][0], command=b6_handler, width=7)
b6.grid(row=4, column=2, sticky="we")
def b7_handler():
    setVerb(7)
b7=tkinter.Button(wdf, text=verb[7][0], command=b7_handler, width=7)
b7.grid(row=5, column=0, sticky="we")
def b8_handler():
    setVerb(8)
b8=tkinter.Button(wdf, text=verb[8][0], command=b8_handler, width=7)
b8.grid(row=5, column=1, sticky="we")
def b9_handler():
    setVerb(9)
b9=tkinter.Button(wdf, text=verb[9][0], command=b9_handler, width=7)
b9.grid(row=5, column=2, sticky="we")


#inventar=tkinter.Label(wdf, text="Inventar", font="Courier 16", relief="groove")
inventar=tkinter.Listbox(wdf, height=5, width=10, selectmode="browse", selectforeground="black", selectbackground="white", highlightthickness=0, activestyle="none")
inventar.grid(row=3, column=3, rowspan=3)
inventar.bind("<<ListboxSelect>>",invWahl)
inventar.bind("<Enter>", inv_Enter)
inventar.bind("<Motion>", inv_Enter)
inventar.bind("<Leave>", inv_Leave)

hoch=tkinter.Button(wdf, text="\u2B06")
hoch.grid(row=3, column=4, sticky="we")
hoch.bind("<Button-1>", invhoch)
runter=tkinter.Button(wdf, text="\u2B07")
runter.grid(row=5, column=4, sticky="we")
runter.bind("<Button-1>", invrunter)



#dialogfeld
dialog=tkinter.Listbox(wdf, height=5, width=40, selectmode="single", selectforeground="black", selectbackground="white", highlightthickness=0, activestyle="none")
dialog.grid(row=3, column=5, rowspan=3)
dialog.bind("<<ListboxSelect>>",dialogWahl)
dialog.config(state="disabled")
dialog.config(bg=wdf.cget('bg'))


# run
if os.path.exists("game.res"):
    HoleSpiel("game.res")
else:
    rListe=LiesRaum()
    oListe=LiesObjekte()
    dS,dR=LiesDialoge()
    betrete_raum(raum)
    invListe=LiesInventar()
    updInv(invListe)
wdf.mainloop()
