DEFINT A-Z

'*** Lunatix: The Insanity Circle: Copyright (C) 1999-2004 by Mike Snyder and
'***          Prowler Productions, all rights reserved. See "source.txt" for
'***          additional information. QuickBASIC 4.5 required to run/compile.

'*** NOTE: to change the "version number" of the game, go to the PARSER.BAS
'*** function and edit the "ParseCommand" fuction for the "Version" Verb.

DECLARE FUNCTION VariFile (a$)
DECLARE FUNCTION JudgingPeriod ()
DECLARE FUNCTION GetSupport (Lo, b$)
DECLARE FUNCTION RemoveColor$ (b$)
DECLARE FUNCTION StripConcat$ (x$)
DECLARE FUNCTION FixEscape$ (C$)
DECLARE SUB InitTextLib ()
DECLARE SUB TextTitle ()
DECLARE SUB SetUndoInfo ()
DECLARE FUNCTION GetResource$ (Lo%, Tag$)
DECLARE SUB ExitScreen ()
DECLARE SUB ExitGame ()
DECLARE SUB InitGameData ()
DECLARE SUB IntroText ()
DECLARE SUB ExitGameScreen ()
DECLARE SUB RotateCursor (CursorX%, BOXCOLOR%)
DECLARE SUB AddToCommand2 (SB%, a$)
DECLARE FUNCTION GetRoomTitle$ (Lo%)
DECLARE SUB LocTitle (a$)
DECLARE SUB PlayAndSleep (waitval, CanExit, a$)
DECLARE FUNCTION TextYesNo (Text$, Which)
DECLARE SUB Oprint (a$)
DECLARE FUNCTION TextInput$ ()
DECLARE SUB LoadSounds ()

DECLARE FUNCTION KbIn$ (L%, a$, cc$, SB%)
DECLARE FUNCTION CheckArrow$ (selected%, b$)
DECLARE FUNCTION CheckHiLite% ()
DECLARE SUB SetDirections (Lo%)
DECLARE SUB SetRoomPic (Lo%)
DECLARE FUNCTION ParseCommand (a$)
DECLARE SUB AddLine (WhichArray%, Text$, ResetColors)
DECLARE SUB HiLite (SelectedArea%, SetOn%)

DECLARE FUNCTION LeftHold ()
DECLARE FUNCTION RightHold ()
DECLARE FUNCTION MouseAvail ()
DECLARE SUB LocateMouse (x%, Y%)
DECLARE FUNCTION ClickMouse ()

DECLARE SUB DrawMousePix ()
DECLARE SUB MoveMousePix ()
DECLARE SUB PutMousePix ()
DECLARE SUB GetMousePix ()

DECLARE SUB GPrint (Text$, TX, TY, Col)
DECLARE SUB LoadFonts ()
DECLARE SUB FadeIn ()
DECLARE SUB FadeOut ()
DECLARE SUB PalLoad (a$)
DECLARE SUB loadfil (b$, pixelno%)

'******* MOUSE ROUTINES *******

'$INCLUDE: 'q4t.bi'
DECLARE FUNCTION MouseY% ()
DECLARE FUNCTION MouseX% ()
DECLARE SUB InitMouse ()
DECLARE FUNCTION MouseAvail% ()

DECLARE SUB TitleScreen ()
DECLARE SUB esleep (length!)
DECLARE FUNCTION AskYesNo (prom$, Which)
DECLARE FUNCTION CheckScrolling (Allowcommandscroll%)
DECLARE FUNCTION GetScrollTopY (Which%)
DECLARE FUNCTION GetScrollBotY (Which%)
DECLARE FUNCTION InputLoop$ (SelectedArea)
DECLARE SUB ShowArray (style%, Which%)
DECLARE SUB CreateArray (Text$, ml%, WhichArray%, startover%)
DECLARE SUB PicLoad (a$, WhichType)
DECLARE FUNCTION GetRoomDesc$ (Lo%)

CONST MaxScroll = 60
CONST MAXARRAYSIZE = 60

COMMON SHARED TextMode 'configurable
COMMON SHARED BwMode   'configurable
COMMON SHARED MusicOn
COMMON SHARED SoundOn
COMMON SHARED AllUpper 'configurable
COMMON SHARED Box1Size 'This is set by code, not configurable
COMMON SHARED Box2Size 'This is set by code, not configurable
COMMON SHARED a$
COMMON SHARED Lo AS INTEGER
COMMON SHARED Fbuff AS STRING * 8960 'For Fonts
COMMON SHARED ScrollArray() AS STRING * 96
COMMON SHARED bs1$, bs2$, bs3$, bs4$, bs5$, bs6$, bs0$, bsb$

DIM SHARED ScrollArray(MAXARRAYSIZE, 1 TO 2) AS STRING * 96
DIM SHARED ScrollCommandCount AS INTEGER
DIM SHARED ScrollBackCommand$(MaxScroll)
DIM SHARED V1 AS INTEGER
DIM SHARED CursorX AS INTEGER
DIM SHARED TempCommand$
DIM SHARED Getb$ 'Input Data for the
DIM SHARED GlobalError AS INTEGER
DIM SHARED WhyNoGfx AS INTEGER
DIM SHARED ShowScreens AS INTEGER
DIM SHARED CheckMouse

DIM SHARED HasMouse
DIM SHARED OldPixel(9)
DIM SHARED OldMouseX
DIM SHARED OldMouseY

PRINT "Loading...."

'****************************************************************************
  RANDOMIZE -TIMER
  TextMode = 0: '(0=Graphics, 1=80, 2=40)
  BwMode = 0:   '(0=Colors in text mode, 1=black/white in text mode).
  SoundOn = 0:  '(Turn sound effects on)
  MusicOn = 1:  '(Turn Music on)
  ShowScreens = 1 '(Display the title and exit screens) ?
  CheckMouse = 1  '(Check for mouse if we have one)
  AllUpper = 0: 'Will everthing be in all caps?
'****************************************************************************
  GlobalError = 0 'Set this so that system knows no errors found yet
  WhyNoGfx = 0
'****************************************************************************

'*** Get our command line parms
a$ = UCASE$(COMMAND$)
IF INSTR(a$, "T") THEN TextMode = 1
IF INSTR(a$, "B") THEN TextMode = 1: BwMode = 1
IF INSTR(a$, "Q") THEN SoundOn = 0: MusicOn = 0
IF INSTR(a$, "C") THEN SoundOn = 1
IF INSTR(a$, "M") THEN CheckMouse = 0
IF INSTR(a$, "U") THEN AllUpper = 1
IF INSTR(a$, "Y") THEN ShowScreens = 0

a3$ = "playarea"
b3$ = "playarea"

'*************** INITIAL VALUES!!!!
OldLo = 0

LoadSounds
InitGameData
SetUndoInfo 'Make sure we initialize our undo registers
'OPEN "LunUndo.SGM" FOR OUTPUT SHARED AS #2: PRINT #2, "EMPTY": CLOSE #2

IF TextMode = 0 THEN
    ON ERROR GOTO CatchError
    OPEN "LUNATIX2.DAT" FOR INPUT SHARED AS #2: CLOSE #2
    IF GlobalError = 0 THEN
        SCREEN 13
        COLOR 255
        IF GlobalError <> 0 THEN
            WhyNoGfx = 1
        END IF
    ELSE
        WhyNoGfx = 2
    END IF
    ON ERROR GOTO 0
    IF GlobalError <> 0 THEN
        TextMode = 1
    END IF
END IF

IF TextMode > 0 THEN
    IF WhyNoGfx > 0 THEN
        CLS
        LOCATE 5, 5
        Oprint GetResource$(39, "NT1")
        LOCATE 7, 5
        Oprint "`0Reason: "
        IF WhyNoGfx = 2 THEN
            Oprint GetResource$(39, "NT2")
            LOCATE 8, 13
            Oprint GetResource$(39, "NT3")
            LOCATE 9, 13
            Oprint GetResource$(39, "NT4")
            LOCATE 10, 13
            Oprint GetResource$(39, "NT5")
            LOCATE 12, 4
            Oprint GetResource$(39, "NT6")
        END IF
        IF WhyNoGfx = 1 THEN
            Oprint GetResource$(39, "NT7")
            LOCATE 9, 4
            Oprint GetResource$(39, "NT6")
        END IF
        a$ = KbIn$(1, "", "7", 1)
        COLOR 7, 0
        CLS
    END IF
END IF

'*********** Prepare the screen!!!!
IF TextMode = 0 THEN
    SCREEN 0
    'IF CheckMouse = 1 THEN HasMouse = MouseAvail ELSE HasMouse = 0
    HasMouse = 1
    IF HasMouse > 0 THEN
        InitMouse
    END IF
    SCREEN 13
    LoadFonts
    LocateMouse 4, 4
    TitleScreen
    PicLoad "2", 2
    FadeIn
END IF
'*****************************

IF TextMode = 0 THEN Box1Size = 26: Box2Size = 50
IF TextMode = 1 THEN Box1Size = 79: Box2Size = 79: WIDTH 80
IF TextMode = 2 THEN Box1Size = 39: Box2Size = 39: WIDTH 40
SetRoomPic (Lo)
SetDirections (Lo)

    IF TextMode = 0 THEN
        CreateArray RemoveColor$(GetRoomDesc$(Lo)), Box1Size, 1, 1
    ELSE
        CreateArray GetRoomDesc$(Lo), Box1Size, 1, 1
    END IF

IF TextMode > 0 THEN
    InitTextLib
    TextTitle
END IF

IntroText 'Creates the "informational" array!

b$ = GetRoomTitle$(Lo)
'ShowArray 0, 2 'Show the intro text FIRST!
LocTitle b$
ShowArray 0, 1 'Then show the room description

'*** Extract the text walkthrough solution file if needed
IF JudgingPeriod = 1 THEN
    IF VariFile("LUNATIX.SOL") = 0 THEN
        nul = GetSupport(41, "blah")
    END IF
END IF

FOR x = 1 TO 16: a$ = INKEY$: NEXT x: 'throw away the buffer, if any

'****************************************************************************
TopLoop:

IF OnHold$ = "" THEN MultiCommand = 0
IF MultiCommand = 0 THEN
    IF OldLo <> Lo THEN
        IF OldLo = 0 THEN
            a$ = InputLoop$(2) 'Only on the VERY FIRST entry so they can see the game intro text
        ELSE
            a$ = InputLoop$(1)
        END IF
        OldLo = Lo
    ELSE
        a$ = InputLoop$(3)
    END IF
    a$ = StripConcat$(a$)
ELSE
    a$ = StripConcat$(OnHold$)
END IF

'*** check for concatenated commands using semi-colon or period!
OldMult = MultiCommand 'Store for checking it.
MultiCommand = 0
a1 = INSTR(a$, ";"): a2 = INSTR(a$, "."): a3 = INSTR(UCASE$(a$), " THEN ")
IF a1 = 0 THEN a1 = a2
IF a1 = 0 THEN a1 = a3
IF a1 > 0 AND a2 < a1 AND a2 > 0 THEN a1 = a2
IF a1 > 0 AND a3 < a1 AND a3 > 0 THEN a1 = a3


IF a1 > 1 AND a1 < LEN(a$) THEN
    OnHold$ = RTRIM$(LTRIM$((RIGHT$(a$, LEN(a$) - a1))))
    a$ = RTRIM$(LTRIM$(LEFT$(a$, a1 - 1)))
    a$ = StripConcat$(a$)
    IF LEN(a$) > 0 THEN
        MultiCommand = 1
    ELSE
        IF LEN(OnHold$) THEN MultiCommand = 1
        GOTO TopLoop
    END IF
END IF

IF OldMult <> 0 THEN
    IF TextMode > 0 THEN Oprint "`%`9" + a$ + CHR$(13)
    esleep (.5)
END IF


retval = ParseCommand(a$)
IF retval = -1 THEN

    IF AskYesNo(GetResource$(39, "NT8"), 1) = 1 THEN ExitGame
END IF

GOTO TopLoop
'****************************************************************************

CatchError: GlobalError = 1: RESUME NEXT

SUB AddToCommand2 (SB%, a$)

IF SB% = 1 AND a$ <> "" THEN
    IF ScrollCommandCount >= 1 THEN
        IF UCASE$(ScrollBackCommand$(ScrollCommandCount)) = UCASE$(a$) THEN
            EXIT SUB
        END IF
    END IF

    IF ScrollCommandCount >= MaxScroll THEN
        ScrollCommandCount = MaxScroll
        FOR x = 1 TO MaxScroll - 1: ScrollBackCommand$(x) = ScrollBackCommand$(x + 1)
        NEXT x
    ELSE
        ScrollCommandCount = ScrollCommandCount + 1
    END IF
    ScrollBackCommand$(ScrollCommandCount) = a$
END IF

END SUB

FUNCTION AskYesNo (prom$, Which)

FOR x = 1 TO 16: a$ = INKEY$: NEXT x: 'throw away the buffer, if any
null = ClickMouse: null = ClickMouse: null = ClickMouse: 'throw away clicks
Getb$ = ""

IF TextMode <> 0 THEN
    AskYesNo = TextYesNo(prom$, Which)
    EXIT FUNCTION
END IF

SelectedArea = 3
HiLite SelectedArea, 1

BOXCOLOR = 1

'** INITIALIZE THE MOUSE
    GetMousePix
    DrawMousePix
'************************

GPrint prom$, 6, 189, 250
CursorX = 6 * LEN(prom$) + 1

MHold = 0
MHoldTime! = TIMER

IF LeftHold > 0 THEN
    MHold = 1
    MWaitTime = 75 '3/4 of a second (.75)
END IF

WHILE 1
    a$ = INKEY$
    MoveMousePix

    MClick = LeftHold
    IF MClick > 0 THEN
        x = CheckHiLite
        IF (ABS(TIMER - MHoldTime!) >= (MWaitTime / 100)) OR (MHold = 0) THEN
            IF (x > 0 AND x <> SelectedArea) THEN
                PutMousePix
                HiLite SelectedArea, 0
                SelectedArea = x
                HiLite SelectedArea, 1
                GetMousePix
                DrawMousePix
            END IF
            'IF CheckScrolling(0) > 0 AND LEN(GetB$) > 0 THEN
            IF CheckScrolling(0) > 0 THEN
                PutMousePix
                IF Getb$ = "QUIT" THEN
                    Getb$ = ""
                    IF Which = 1 OR Which = 2 THEN
                        AskYesNo = 0
                    END IF
                    IF Which = 3 OR Which = 4 THEN
                        AskYesNo = 1
                    END IF
                ELSE
                    IF Which = 1 OR Which = 2 OR Which = 4 THEN
                        AskYesNo = 1
                    END IF
                    IF Which = 3 THEN
                        AskYesNo = 2
                    END IF
                END IF
                esleep .75
                GOTO ExFunction2
            END IF
            IF MHold = 0 THEN
                MHold = 1
                'MWaitTime = 50 'half a second
                MWaitTime = 30 '.3 of a second
            ELSE
                'MWaitTime = 10 '.1 second
                MWaitTime = 5   '.05 second
            END IF
            MHoldTime! = TIMER
        END IF
    ELSE
        MHold = 0
    END IF
  
    RotateCursor CursorX, BOXCOLOR

    '*** CHECK FOR KEYBOARD INPUT
    IF LEN(a$) > 0 THEN
        PutMousePix
        IF a$ = CHR$(9) THEN
            HiLite SelectedArea, 0
            SelectedArea = SelectedArea + 1
            IF SelectedArea > 3 THEN SelectedArea = 1
            HiLite SelectedArea, 1: a$ = ""
        END IF
        IF RIGHT$(a$, 1) = CHR$(15) AND LEN(a$) = 2 THEN
            HiLite SelectedArea, 0
            SelectedArea = SelectedArea - 1
            IF SelectedArea < 1 THEN SelectedArea = 3
            HiLite SelectedArea, 1: a$ = ""
        END IF
        a$ = CheckArrow$(SelectedArea, a$)
        IF LEN(a$) > 0 THEN
            '** If any typing is going on, we should move the FOCUS!
            IF (SelectedArea <> 3) THEN
                HiLite SelectedArea, 0
                SelectedArea = 3
                HiLite SelectedArea, 1
            END IF
            IF Which = 1 THEN '** Yes or No
                IF a$ = "y" OR a$ = "Y" THEN AskYesNo = 1: GOTO ExFunction2
                IF a$ = CHR$(27) OR a$ = "n" OR a$ = "N" THEN AskYesNo = 0: GOTO ExFunction2
            END IF
            IF Which = 2 THEN '** 1 to 9
                IF a$ = CHR$(27) OR a$ = "0" THEN AskYesNo = 0: GOTO ExFunction2
                IF VAL(a$) >= 1 AND VAL(a$) <= 9 THEN AskYesNo = VAL(a$): GOTO ExFunction2
            END IF
            IF Which = 3 THEN '** (Q)uit, (U)ndo, (R)estore.
                IF a$ = CHR$(27) OR a$ = "q" OR a$ = "Q" THEN AskYesNo = 1: GOTO ExFunction2
                IF a$ = "u" OR a$ = "U" THEN AskYesNo = 2: GOTO ExFunction2
                IF a$ = "r" OR a$ = "R" THEN AskYesNo = 3: GOTO ExFunction2
                IF a$ = "s" OR a$ = "S" THEN AskYesNo = 4: GOTO ExFunction2
            END IF
            IF Which = 4 THEN
                IF a$ = CHR$(27) OR a$ = CHR$(13) THEN AskYesNo = 1: GOTO ExFunction2
            END IF
        END IF
        GetMousePix
        DrawMousePix
    END IF
WEND

PutMousePix
ExFunction2:
LINE (3, 188)-(282, 196), BOXCOLOR, BF 'Erase the input box!
HiLite SelectedArea, 0 'Turn off the hi-light

END FUNCTION

FUNCTION CheckArrow$ (SelectedArea, b$)
    BOXCOLOR = 1
    a$ = b$
    IF LEN(a$) < 1 THEN CheckArrow$ = b$: EXIT FUNCTION
    fs = ASC(RIGHT$(a$, 1))
    IF SelectedArea < 3 THEN
        IF LEN(a$) = 2 AND (fs = 80 OR fs = 77) THEN
            ShowArray 1, SelectedArea: a$ = ""
        END IF
        IF LEN(a$) = 2 AND (fs = 72 OR fs = 75) THEN
            ShowArray 2, SelectedArea: a$ = ""
        END IF
        IF LEN(a$) = 2 AND fs = 81 THEN
            ShowArray 3, SelectedArea: a$ = ""
        END IF
        IF LEN(a$) = 2 AND fs = 73 THEN
            ShowArray 4, SelectedArea: a$ = ""
        END IF
    END IF

    IF SelectedArea = 3 THEN
    'IF SB% = 1 THEN
        IF ScrollCommandCount > 0 AND V1 > 1 THEN
            IF LEN(a$) = 2 AND RIGHT$(a$, 1) = CHR$(72) THEN 'up arrow
                IF V1 >= (ScrollCommandCount + 1) THEN TempCommand$ = Getb$
                LINE (3, 188)-(282, 196), BOXCOLOR, BF 'Erase the input box!
                V1 = V1 - 1: IF V1 < 1 THEN V1 = 1
                Getb$ = ScrollBackCommand$(V1)
                GPrint (Getb$), 5, 189, 255
                CursorX = 5 + (6 * LEN(Getb$))
                a$ = "*R*" 'special tag
            END IF
        END IF
        IF ScrollCommandCount > 0 AND V1 < (ScrollCommandCount + 1) THEN
            IF LEN(a$) = 2 AND ASC(RIGHT$(a$, 1)) = 80 THEN 'Down Arrow
                LINE (3, 188)-(282, 196), BOXCOLOR, BF 'Erase the input box!
                V1 = V1 + 1: IF V1 >= (ScrollCommandCount + 1) THEN V1 = ScrollCommandCount + 1
                IF V1 <= ScrollCommandCount THEN
                    Getb$ = ScrollBackCommand$(V1)
                ELSE
                    Getb$ = TempCommand$
                END IF
                GPrint (Getb$), 5, 189, 255
                CursorX = 5 + (6 * LEN(Getb$))
                a$ = "*R*" 'special tag.
            END IF
        END IF
    'END IF
    END IF

    CheckArrow$ = a$
END FUNCTION

FUNCTION CheckScrolling (Allowcommandscroll)
        '*** Test for the EXIT button
        IF MouseX >= 310 AND MouseY >= 3 AND MouseX <= 316 AND MouseY <= 9 THEN
            Getb$ = "QUIT": CheckScrolling = 1: EXIT FUNCTION
        END IF
        '*** Test for the UPPER SCROLL BOX
        IF MouseX >= 310 AND MouseY >= 17 AND MouseX <= 316 AND MouseY <= 23 THEN
            '*** Clicked the UP ARROW BUTTON!!!
            CALL PutMousePix: ShowArray 2, 1: a$ = "": GetMousePix: DrawMousePix
        END IF
        IF MouseX >= 310 AND MouseY >= 106 AND MouseX <= 316 AND MouseY <= 112 THEN
            '*** Click the DOWN ARROW BUTTON
            CALL PutMousePix: ShowArray 1, 1: a$ = "": GetMousePix: DrawMousePix
        END IF
        IF MouseX >= 310 AND MouseY >= 25 AND MouseX <= 316 AND MouseY <= GetScrollTopY(1) THEN
            '*** Clicked the PAGE UP BUTTON
            CALL PutMousePix: ShowArray 4, 1: a$ = "": GetMousePix: DrawMousePix
        END IF
        IF MouseX >= 310 AND MouseY >= GetScrollBotY(1) AND MouseX <= 316 AND MouseY <= 104 THEN
            '*** Click the PAGE DOWN BUTTON
            CALL PutMousePix: ShowArray 3, 1: a$ = "": GetMousePix: DrawMousePix
        END IF
        '*** Test for the LOWER SCROLL BOX
        IF MouseX >= 310 AND MouseY >= 120 AND MouseX <= 316 AND MouseY <= 126 THEN
            '*** Clicked the UP ARROW BUTTON!!!
            CALL PutMousePix: ShowArray 2, 2: a$ = "": GetMousePix: DrawMousePix
        END IF
        IF MouseX >= 310 AND MouseY >= 174 AND MouseX <= 316 AND MouseY <= 180 THEN
            '*** Click the DOWN ARROW BUTTON
            CALL PutMousePix: ShowArray 1, 2: a$ = "": GetMousePix: DrawMousePix
        END IF
        IF MouseX >= 310 AND MouseY >= 128 AND MouseX <= 316 AND MouseY <= GetScrollTopY(2) THEN
            '*** Clicked the PAGE UP BUTTON
            CALL PutMousePix: ShowArray 4, 2: a$ = "": GetMousePix: DrawMousePix
        END IF
        IF MouseX >= 310 AND MouseY >= GetScrollBotY(2) AND MouseX <= 316 AND MouseY <= 172 THEN
            '*** Click the PAGE DOWN BUTTON
            CALL PutMousePix: ShowArray 3, 2: a$ = "": GetMousePix: DrawMousePix
        END IF
        IF MouseX >= 284 AND MouseY >= 188 AND MouseX <= 296 AND MouseY <= 196 THEN
            CheckScrolling = 1: EXIT FUNCTION
        END IF
        IF Allowcommandscroll > 0 THEN
            IF MouseX >= 308 AND MouseY >= 188 AND MouseX <= 316 AND MouseY <= 196 THEN
                CALL PutMousePix
                a$ = CheckArrow$(3, CHR$(0) + CHR$(80))
                CALL GetMousePix: DrawMousePix
            END IF
            IF MouseX >= 298 AND MouseY >= 188 AND MouseX <= 306 AND MouseY <= 196 THEN
                CALL PutMousePix
                a$ = CheckArrow$(3, CHR$(0) + CHR$(72))
                CALL GetMousePix: DrawMousePix
            END IF
        END IF
    CheckScrolling = 0
END FUNCTION

FUNCTION ClickMouse

STATIC a1%
STATIC b1%
STATIC c1%

IF HasMouse <= 0 THEN ClickMouse = 0: EXIT FUNCTION

CALL MouseScroll(a%, b%, C%)

IF a% = 0 AND a1% = 1 THEN
    a1% = 0: ClickMouse = 1: EXIT FUNCTION
END IF
a1% = a%
ClickMouse = 0
EXIT FUNCTION

'CALL MouseClick(a1%, b1%, c1%)
'IF a1% = 1 THEN LeftClick = 1 ELSE LeftClick = 0
'IF c1% = 1 THEN RightClick = 1 ELSE RightClick = 0
'IF LeftClick > 0 OR RightClick > 0 THEN ClickMouse = 1 ELSE ClickMouse = 0

END FUNCTION

SUB DrawMousePix

    IF HasMouse <= 0 THEN EXIT SUB
    PSET (OldMouseX + 1, OldMouseY + 1), 251
    PSET (OldMouseX - 1, OldMouseY - 1), 251
    PSET (OldMouseX + 1, OldMouseY - 1), 251
    PSET (OldMouseX - 1, OldMouseY + 1), 251
    PSET (OldMouseX, OldMouseY), 251
    PSET (OldMouseX, OldMouseY - 1), 0
    PSET (OldMouseX, OldMouseY + 1), 0
    PSET (OldMouseX - 1, OldMouseY), 0
    PSET (OldMouseX + 1, OldMouseY), 0

END SUB

SUB EndScreen

'*** The player won the game!!!!

PicLoad "5", 2
b$ = "`7"
FOR x1 = 1 TO 16
    IF TextMode = 0 THEN
        GPrint GetResource$(40, "LINE" + LTRIM$(STR$(x1))), 4, (x1 * 8) - 6, 199
    ELSE
        b$ = b$ + GetResource$(40, "LINE" + LTRIM$(STR$(x1))) + " "
    END IF
NEXT x1

IF TextMode <> 0 THEN
    Oprint CHR$(13):  AddLine 2, b$, 1
    Oprint CHR$(13) + "`%`@THE END...     `7[ENTER]:"
END IF

FadeIn
LocateMouse 4, 4

PlayAndSleep 99, 1, GetResource$(0, "MUSIC1")

    IF TextMode = 0 THEN FadeOut: SCREEN 0, 0, 0, 0
    IF TextMode = 2 THEN WIDTH 80
    CLS : END

END SUB

SUB esleep (waitval!)

J! = TIMER
FOR x = 1 TO 16: b$ = INKEY$: NEXT x: 'throw away the buffer, if any
null = ClickMouse: null = ClickMouse: null = ClickMouse: 'throw away clicks

'*** INITIALIZE THE MOUSE
GetMousePix
DrawMousePix

b$ = ""
WHILE b$ = "" AND ABS(TIMER - J!) < waitval!
    b$ = INKEY$
    MoveMousePix
    IF ClickMouse > 0 THEN b$ = CHR$(13)
WEND

PutMousePix

END SUB

SUB ExitGame

    IF TextMode = 0 THEN
        ExitScreen
        SCREEN 0, 0, 0, 0
    END IF
    IF TextMode = 2 THEN WIDTH 80
    CLS
    END

END SUB

SUB ExitGameScreen

IF TextMode = 0 THEN
    PicLoad "1", 2
    FadeIn
    esleep 15
END IF

END SUB

SUB ExitScreen

   IF JudgingPeriod = 0 THEN
        'IF ShowScreens < 1 THEN EXIT SUB
        PicLoad "1", 2
        FadeIn
        PlayAndSleep 3, 1, GetResource$(0, "MUSIC2")
    END IF

END SUB

FUNCTION FixEscape$ (b$)

N = INSTR(b$, CHR$(210))
WHILE N > 0
    MID$(b$, N, 1) = CHR$(27)
    N = INSTR(b$, CHR$(210))
WEND
FixEscape$ = b$

END FUNCTION

SUB GetMousePix

IF HasMouse <= 0 THEN EXIT SUB
OldMouseX = MouseX
OldMouseY = MouseY
OldPixel(1) = POINT(OldMouseX - 1, OldMouseY - 1)
OldPixel(2) = POINT(OldMouseX - 1, OldMouseY + 1)
OldPixel(3) = POINT(OldMouseX + 1, OldMouseY - 1)
OldPixel(4) = POINT(OldMouseX + 1, OldMouseY + 1)
OldPixel(5) = POINT(OldMouseX, OldMouseY)
OldPixel(6) = POINT(OldMouseX, OldMouseY - 1)
OldPixel(7) = POINT(OldMouseX, OldMouseY + 1)
OldPixel(8) = POINT(OldMouseX - 1, OldMouseY)
OldPixel(9) = POINT(OldMouseX + 1, OldMouseY)

END SUB

SUB InitMouse

CALL MouseReset(1)
CALL MouseVisible(0)

END SUB

FUNCTION InputLoop$ (SelectedArea)
SB% = 1

IF TextMode <> 0 THEN
    Oprint "`%Your Command: "
    InputLoop$ = KbIn$(Box2Size - 20, "", "9", 1)'cc=input color 'SB%=Scrollback!
    IF BwMode > 0 THEN Oprint "`7`7": COLOR 7, 0
    PRINT
    EXIT FUNCTION
END IF

HiLite SelectedArea, 1

'FOR x = 1 TO 16: a$ = INKEY$: NEXT x: 'throw away the buffer, if any
null = ClickMouse: null = ClickMouse: null = ClickMouse: 'throw away clicks

BOXCOLOR = 1

'** INITIALIZE THE MOUSE
    GetMousePix
    DrawMousePix
'************************

V1 = ScrollCommandCount + 1
V2 = ScrollItemCount + 1
TempCommand$ = ""

CursorX = 5
Getb$ = "" 'The Input Thing

MHold = 0
MHoldTime! = TIMER

WHILE 1
    MoveMousePix

    MClick = LeftHold
    IF MClick > 0 THEN
        x = CheckHiLite
        IF (ABS(TIMER - MHoldTime!) >= (MWaitTime / 100)) OR (MHold = 0) THEN
            IF (x > 0 AND x <> SelectedArea) THEN
                PutMousePix
                HiLite SelectedArea, 0
                SelectedArea = x
                HiLite SelectedArea, 1
                GetMousePix
                DrawMousePix
            END IF
            IF CheckScrolling(1) > 0 AND LEN(Getb$) > 0 THEN
                InputLoop$ = Getb$
                AddToCommand2 SB%, Getb$
                PutMousePix
                GOTO ExFunction
            END IF
            IF MHold = 0 THEN
                MHold = 1
                'MWaitTime = 50 'half a second
                MWaitTime = 30 '.3 of a second
            ELSE
                'MWaitTime = 10 '.1 second
                MWaitTime = 5   '.05 second
            END IF
            MHoldTime! = TIMER
        END IF
    ELSE
        MHold = 0
    END IF
   
    RotateCursor CursorX, BOXCOLOR

    '*** CHECK FOR KEYBOARD INPUT
    a$ = INKEY$
    IF LEN(a$) > 0 THEN
        IF SoundOn <> 0 THEN PLAY "mbt255l63o1d"
        PutMousePix
        C = ASC(a$)
        IF a$ = CHR$(9) THEN
            HiLite SelectedArea, 0
            SelectedArea = SelectedArea + 1
            IF SelectedArea > 3 THEN SelectedArea = 1
            HiLite SelectedArea, 1: a$ = ""
        END IF
        IF RIGHT$(a$, 1) = CHR$(15) AND LEN(a$) = 2 THEN
            HiLite SelectedArea, 0
            SelectedArea = SelectedArea - 1
            IF SelectedArea < 1 THEN SelectedArea = 3
            HiLite SelectedArea, 1: a$ = ""
        END IF
        a$ = CheckArrow$(SelectedArea, a$)
        IF a$ = "*R*" THEN
            GetMousePix
            DrawMousePix
            GOTO Repeater
        END IF
        IF LEN(a$) > 0 THEN
            '** If any typing is going on, we should move the FOCUS!
            IF (SelectedArea <> 3) THEN
                HiLite SelectedArea, 0
                SelectedArea = 3
                HiLite SelectedArea, 1
            END IF
            IF LEN(a$) = 2 AND RIGHT$(a$, 1) = CHR$(77) THEN a$ = " ": C = 32
            IF LEN(a$) = 1 AND C >= 32 AND C <= 255 AND LEN(Getb$) < 45 THEN
                Getb$ = Getb$ + a$
                LINE (CursorX, 189)-(CursorX + 4, 195), BOXCOLOR, BF
                GPrint (a$), (CursorX), 189, 255
                CursorX = CursorX + 6
            END IF
            IF (C = 8 OR (LEN(a$) = 2 AND (RIGHT$(a$, 1) = CHR$(75) OR RIGHT$(a$, 1) = CHR$(83)))) AND LEN(Getb$) > 0 THEN 'BACKSPACE
                LINE (CursorX, 189)-(CursorX + 4, 195), BOXCOLOR, BF
                CursorX = CursorX - 6
                LINE (CursorX, 189)-(CursorX + 4, 195), BOXCOLOR, BF
                Getb$ = LEFT$(Getb$, LEN(Getb$) - 1)
            END IF
            IF a$ = CHR$(13) AND LEN(Getb$) > 0 THEN
                InputLoop$ = Getb$
                AddToCommand2 SB%, Getb$
                GOTO ExFunction
            END IF
        END IF
        GetMousePix
        DrawMousePix
    END IF
Repeater: WEND

PutMousePix
ExFunction:
LINE (3, 188)-(282, 196), BOXCOLOR, BF 'Erase the input box!
HiLite SelectedArea, 0 'Turn off the hi-light

END FUNCTION

FUNCTION JudgingPeriod

    x = 1
    a$ = DATE$
    IF (VAL(RIGHT$(a$, 4)) > 1999) OR (VAL(RIGHT$(a$, 4)) = 1999 AND VAL(LEFT$(a$, 2)) > 11) OR (VAL(RIGHT$(a$, 4)) = 1999 AND VAL(LEFT$(a$, 2)) = 11 AND VAL(MID$(a$, 4, 2)) > 15) THEN x = 0
    IF (VAL(RIGHT$(a$, 4)) < 1999) OR (VAL(RIGHT$(a$, 4)) = 1999 AND VAL(LEFT$(a$, 2)) < 10) THEN x = 0
    JudgingPeriod = x

END FUNCTION

FUNCTION LeftHold

IF HasMouse <= 0 THEN EXIT FUNCTION
CALL MouseScroll(a%, b%, C%)
IF a% = 1 THEN LeftHold = 1 ELSE LeftHold = 0

END FUNCTION

SUB LocateMouse (x, Y)

IF HasMouse <= 0 THEN EXIT SUB
'CALL MouseLocate(y, x, 1)
CALL MouseLocate(Y, x * 2, 0)
END SUB

FUNCTION MouseAvail

CALL MouseStatus(Have%)
MouseAvail = Have%

END FUNCTION

FUNCTION MouseX

IF HasMouse <= 0 THEN EXIT FUNCTION
CALL MousePosition(Y%, x%, 0)
MouseX = x% \ 2
END FUNCTION

FUNCTION MouseY

IF HasMouse <= 0 THEN EXIT FUNCTION
CALL MousePosition(Y%, x%, 0)
MouseY = Y%

END FUNCTION

SUB MoveMousePix

IF HasMouse <= 0 THEN EXIT SUB
IF MouseX <> OldMouseX OR MouseY <> OldMouseY THEN
    PutMousePix
    GetMousePix
    DrawMousePix
END IF
END SUB

SUB PutMousePix

IF HasMouse <= 0 THEN EXIT SUB
PSET (OldMouseX - 1, OldMouseY - 1), OldPixel(1)
PSET (OldMouseX - 1, OldMouseY + 1), OldPixel(2)
PSET (OldMouseX + 1, OldMouseY - 1), OldPixel(3)
PSET (OldMouseX + 1, OldMouseY + 1), OldPixel(4)
PSET (OldMouseX, OldMouseY), OldPixel(5)
PSET (OldMouseX, OldMouseY - 1), OldPixel(6)
PSET (OldMouseX, OldMouseY + 1), OldPixel(7)
PSET (OldMouseX - 1, OldMouseY), OldPixel(8)
PSET (OldMouseX + 1, OldMouseY), OldPixel(9)

END SUB

FUNCTION RightHold

IF HasMouse <= 0 THEN EXIT FUNCTION
CALL MouseScroll(a%, b%, C%)
IF C% = 1 THEN RightHold = 1 ELSE RightHold = 0

END FUNCTION

SUB RotateCursor (CursorX, BOXCOLOR)

STATIC J!
STATIC WhichCursor

'****** Rotate The Cursor!
IF ABS(TIMER - J!) > .1 THEN
    IF WhichCursor = 0 THEN
        LINE (CursorX, 189)-(CursorX + 4, 195), 255, BF
    END IF
    IF WhichCursor = 1 THEN
        LINE (CursorX, 189)-(CursorX + 4, 195), BOXCOLOR, BF
        LINE (CursorX + 1, 191)-(CursorX + 3, 193), 255, BF
    END IF
    WhichCursor = 1 - WhichCursor
    J! = TIMER
END IF

END SUB

FUNCTION StripConcat$ (x$)

'** StripConcat is here to allow for people who type get x; then get y where
'** the semicolon and the THEN would double-up concat. :)

    IF LEFT$(UCASE$(x$), 4) = "AND " THEN
        x$ = StripConcat$(LTRIM$(RTRIM$(RIGHT$(x$, LEN(x$) - 4))))
    END IF
    IF RIGHT$(UCASE$(RTRIM$(x$)), 4) = " AND" THEN
        x$ = StripConcat$(LTRIM$(RTRIM$(LEFT$(x$, LEN(x$) - 4))))
    END IF
    IF LEFT$(UCASE$(x$), 5) = "THEN " THEN
        x$ = StripConcat$(LTRIM$(RTRIM$(RIGHT$(x$, LEN(x$) - 5))))
    END IF
    IF RIGHT$(UCASE$(RTRIM$(x$)), 5) = " THEN" THEN
        x$ = StripConcat$(LTRIM$(RTRIM$(LEFT$(x$, LEN(x$) - 5))))
    END IF
    IF LEFT$(x$, 1) = "." THEN
       x$ = StripConcat$(LTRIM$(RTRIM$(RIGHT$(x$, LEN(x$) - 1))))
    END IF
    IF RIGHT$(x$, 1) = "." THEN
       x$ = StripConcat$(LTRIM$(RTRIM$(LEFT$(x$, LEN(x$) - 1))))
    END IF
    IF LEFT$(x$, 1) = ";" THEN
       x$ = StripConcat$(LTRIM$(RTRIM$(RIGHT$(x$, LEN(x$) - 1))))
    END IF
    IF RIGHT$(x$, 1) = ";" THEN
       x$ = StripConcat$(LTRIM$(RTRIM$(LEFT$(x$, LEN(x$) - 1))))
    END IF
    IF UCASE$(x$) = "THEN" THEN x$ = ""

StripConcat$ = x$

END FUNCTION

SUB TextTitle

CLS
COLOR 7, 0
Nt = AllUpper: AllUpper = 0
FOR x1 = 1 TO 8
    Oprint FixEscape$(GetResource$(0, "ANSITITLE" + LTRIM$(STR$(x1))))
NEXT x1
AllUpper = Nt

IF BwMode > 0 THEN
    LOCATE 11, 23: Oprint "`% THE  INSANITY  CIRCLE "
    'LOCATE 12, 23: Oprint "`7 ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^ "
END IF

'SLEEP 15

PlayAndSleep 999, 1, GetResource$(0, "MUSIC3")

COLOR 7, 0
CLS

END SUB

SUB TitleScreen

IF ShowScreens = 0 THEN EXIT SUB

PicLoad "4", 2
GPrint "[CLICK]", 17, 10, 255
GPrint " -or-", 20, 18, 255
GPrint "[ANY KEY]", 11, 26, 255
FadeIn
LocateMouse 4, 4

PlayAndSleep 0, 1, "@c..c.......c..c.......c..c.......@c+..c+..."

PicLoad "3", 2

GPrint "[CLICK]", 267, 167, 255
GPrint " -or-", 270, 175, 255
GPrint "[ANY KEY]", 261, 183, 255
FadeIn

PlayAndSleep 999, 1, GetResource$(0, "MUSIC3")

END SUB

