! This include file holds custom verbs and their relevant routines.
! Note - subroutines first, list second!

! The relevant routines.

! FoolSub
! Handles nonsense words (aka xyzzy and co).
[ FoolSub;
 L__M (##Fool, 1);
];

! HelpSub
! Calls the help menu.
[ HelpSub;
 mnuHelpMain.select ();
];

! ReadSub
! Handles reading things.
[ ReadSub;
 <<Examine noun>>;
];

! ShootAtSub
! Shoots something with something else.
[ ShootAtSub;
 if (runlife (noun, ##ShootAt)~=0)	! Something happened!
 {
  rfalse;
 }
 L__M (##ShootAt, 1);
];
! The list of custom verbs.

! ShootAtRSub
! Wrapper for ShootAt.
[ ShootAtRSub;
 <<ShootAt second noun>>;	! Reverses noun and second for 'shoot x with y'.
];

! Genuine custom verbs.
Verb "shoot"	! As Inform doesn't have it.
 * noun "at" noun -> ShootAtR
 * noun "with" noun -> ShootAt
;

! Extensions and replacements to existing syntax.
Extend "read" first
 * Legible -> Read
;

! Meta verbs.
Verb meta "help" "about" "info" "information"
 * -> Help
;
Verb meta "xyzzy" "plugh" "plover" "samoht" "noside" "melenkurion" "zorton"
 * -> Fool
;