! This is for normal ('OBJECT_' prefixed) objects.

! The piece of white paper you're given at the start of the game.
object OBJECT_WhitePaper "piece of white paper" ROOM_Chief
 with
  before
  [;
   Read:	! Yup, you've GOT to read this!
    print "CONFIDENTIAL:", (NewLine)1, "Detective was created by Matt Barringer.", (NewLine)1;
    Quip (0, 1, Crow, "[Snide] Oh, the great Matt Barringer!", 1);
    Quip (0, 0, Tom, "You never get tired of that line, do you, Crow?", 2);
    print "He has worked hard on this so you better enjoy it.", (NewLine)1;
    Quip (0, 1, Mike, "We've been warned, fellas.", 2);
    print "I did have fun making it though. But I'd REALLY appreciate it if you were kind enough to send a postcard or... dare I even say it?... money... to:", (NewLine)1, "Matt Barringer", (NewLine)1, "325 Olive Ave", (NewLine)1, "Piedmont", (NewLine)1, "CA 94611", (NewLine)1;
    Quip (0, 1, Crow, "We'll do that, Matt. We'll do that.", 2);
    print "Just tell me if you like it or not.", (NewLine)1;
    Quip (0, 1, Tom, "We don't, okay? Deal with it.", 2);
    print "If you want to talk to me over a BBS call the Ghostbuster Central BBS at (510)208-5657.", (NewLine)1;
    Quip (0, 1, Mike, "Who ya gonna call?", 1);
    Quip (0, 0, All, "GHOSTBUSTERS!", 2);
    print "There is an Exile Games file area. Have fun. I WILL give hints out over the BBS to any of my games.", (NewLine)1;
    Quip (0, 1, Tom, "Oh right, like you'd actually NEED hints to win this game.", 1);
    rtrue;
  ],
  description
  [;
   print "It is a piece of white paper.", (NewLine)1;
   Quip (0, 1, Mike, "Thanks for clearing that up.", 1);
   rtrue;
  ],
  name "piece" "white" "paper"
 has
  Legible	! Read me!
  scored	! Should be 'scared' or 'scarred'.
;

! The gun.
object OBJECT_Gun "small black pistol" ROOM_Closet1
 with
  description
  [;
   print "It is a small black pistol. ";
   Quip (0, 1, Crow, "Hey, hey, hey! That's ~African-American pistol!~", 2);
   print "It has 10 bullets in it. You must use them wisely.", (NewLine)1;
   Quip (0, 1, Tom, "Or not. It's not like it matters.", 1);
   rtrue;
  ],
  name "small" "black" "pistol" "gun"
 has
  scored
;

! The note.
object OBJECT_Note "paper note" ROOM_Dining
 with
  before
  [;
   Read:	! Believe me, you want to!
    print "The note was written on a computer ";
    Quip (0, 1, Mike, "I think he means it was typed on a computer.", 2);
    print "obviously this murder was planned and it says:", (NewLine)1;
    Quip (0, 1, Crow, "Wait a minute -- the MURDER says something?", 1);
    Quip (0, 0, Mike, "I think he means the note.", 1);
    Quip (0, 0, Tom, "It's hard to tell with this game.", 2);
    print "We have acclaimed Justice! The Justice of the future! Our next hit is the governer! You CAN'T STOP US! ";
    Quip (0, 1, Mike, "YOU CAN'T HANDLE THE TRUTH!", 1);
    Quip (0, 0, Crow, "Well, at least they're being nice and telling us ahead of time.", 2);
    print "The note sounds like the killers are a group and that they are vigilantes (look it up). ";
    Quip (0, 1, Tom, "Right, this from Matt ~Restraunt~ Barringer.", 2);
    print "You are now getting a bit worried.", (NewLine)1;
    Quip (0, 1, Mike, "Because you realize this game could potentially spawn a sequel.", 1);
    Quip (0, 0, Crow, "Say it ain't so, Mike!", 1);
    rtrue;
   Take:			! Taking the note.
    if (self hasnt moved)	! You haven't done anything to it yet.
    {
     give self moved ~scored;	! You have now touched it.
     move self to player;	! You acquire it.
     score=score+OBJECT_SCORE;	! And are scored for it.
     Quip (0, 1, Tom, "I'd like a note, please.", 1);
     Quip (0, 0, Crow, "Paper or plastic, sir?", 1);
     Quip (0, 0, Tom, "Paper, please.", 2);
     "Taken.";
    }
  ],
  description
  [;
   print "It is a note. With writing on it.", (NewLine)1;
   Quip (0, 1, Tom, "Any questions?", 1);
   Quip (0, 0, Mike, "Yeah. Could it technically be considered a note if it didn't have writing on it?", 1);
   rtrue;
  ],
  name "paper" "note"
 has
  Legible
  scored
;

! The wooden wood (sic).
object OBJECT_Wooden "wooden wood" ROOM_Living
 with
  before
  [;
   Take:			! Similar to the note above.
    if (self hasnt moved)	! Haven't yet touched it.
    {
     give self moved ~scored;	! You have now touched it.
     move self to player;	! And acquired it.
     score=score+OBJECT_SCORE;	! And are scored for it.
     Quip (0, 1, Crow, "Wooden wood -- as opposed to metal wood, stone wood, and plastic wood!", 2);
     "Taken.";
    }
  ],
  description
  [;
   print "You look at it closely and figure that the guys in the forensic's lab would be better at this than you.", (NewLine)1;
   Quip (0,1, Tom, "Well, that'd be great if there actually WAS a forensic's lab in this game.", 1);
   rtrue;
  ],
  name "wooden" "wood"
 has
  scored
;

! The bloody phantom knife.
object OBJECT_Knife "bloody knife" ROOM_Bath
 with
  before
  [;
   Take:	! When taking the knife (which isn't really there).
    print "You can't see any such thing.", (NewLine)1;
    Quip (0, 1, Tom, "Boy, where's Sergeant Duffy when you need him?", 1);
    rtrue;
  ],
  description
  [;
   print "You can't see any such thing.", (NewLine)1;	! The knife isn't really here.
   Quip (0, 1, Mike, "Yes, folks, the knife is right here in plain sight, but you can't see it.", 1);
   rtrue;
  ],
  name "bloody" "knife"
 has
  concealed	! Indeed, so you can't see it.
  static
;

! The hamburger.
object OBJECT_Food "food hamburger" ROOM_McDonalds
 with
  before
  [;
   Eat:	! Eating the hamburger.
    move self to ROOM_Limbo;	! Out of the way.
    print "The hamburger slides down your throat, and your stomach quickly is full.", (NewLine)1;
    Quip (-1, 1, Tom, "So how many hamburgers can you eat on an empty stomach?", 1);
    Quip (-1, 0, Mike, "Only one. After that your stomach isn't empty!", 1);
    Quip (-1, 0, Tom, "D'OH!", 1);
    rtrue;
   Take:			! Similar to the note above.
    if (self hasnt moved)	! Haven't yet touched it.
    {
     give self moved ~scored;	! You have now touched it.
     move self to player;	! And acquired it.
     score=score+OBJECT_SCORE;	! And are scored for it.
     Quip (0, 1, Crow, "Is that anything like ~wooden wood~?", 1);
     Quip (0, 0, Tom, "No, ~wooden wood~ is redundant, whereas calling a McDonalds hamburger ~food~ is an oxymoron.", 1);
     Quip (0, 0, Crow, "Ah.", 2);
     "Taken.";
    }
  ],
  description
  [;
   print "It is a hamburger. If you eat it you'll have satisfied that little hunger in your stomach. Go north.", (NewLine)1;
   Quip (0, 1, Crow, "Umm, well, you can go north assuming there's an exit north.", 1);
   rtrue;
  ],
  name "food" "hamburger"
 has
  edible
  scored
;

! Just an object you can't actually interact with.
object OBJECT_ClosetGear "closet gear" ROOM_Closet2
 with
  before
  [;
   print "You can't see any such thing.", (NewLine)1;	! You just *had* to...
   Quip (0, 1, Tom, "Well, you just had to, didn't you?", 1);
   Quip (0, 0, Crow, "Booby, you were *told* you couldn't interact with them!", 1);
   rtrue;
  ],
  name "tennis" "shoes" "heels" "shirts" "coats"
 has
  concealed
  static
;

!!! INTRODUCTORY MENU SYSTEM BEGINS HERE.
Menu IntroMenu "Introductory menu"
 with
  description "MST3K1 (~Detective~) Introductory menu system."
 has
;

Option -> "About this version"
 with
  description
  [;
   print "This version was coded from Mr. Cree's AGT port of C.E. Forman's original MST3K game, ~Detective~.", (NewLine)2;
   print "I originally played the game ~Detective~, and stopped VERY quickly in disgust. Matt Barringer's (only) work of IF stank to high Heaven. Then I stumbled across Mr. Cree's port of Mr. Forman's version of ~Detective~, using characters from an American TV show ('Mystery Science Theatre 3000'). I loved it! Better, it came with the source code.", (NewLine)2;
   rtrue;
  ],
 has
;

Option -> "About ~Detective~"
 with
  description "~Detective~ is a very poor 'game' by Matt Barringer. As you'll see, it has no real puzzles or plot, and rubbish room descriptions (not to mention confused). It stinks - under NO circumstances play the original (non-MiSTed) version!"
 has
;

Option -> "About ~Mystery Science Theatre 3000~"
 with
  description
  [;
   print (FormatText)"%BNOTE:%P This is by C.E. Forman.", (NewLine)3;
   print "For the uninitiated souls who have never seen MST3K, here's a quick lesson:", (NewLine)2, "MST3K features a man trapped up in a satellite called the Satellite of Love, forced by evil scientists to watch really bad movies so they can study his reactions. The characters include:", (NewLine)2;
   print (FormatText)"%BMike Nelson%P", (NewLine)1;
   print "Mike is an ordinary man, not from Green Bay, Wisconsin, who was working as a temp for mad scientists Dr Clayton Forrester and TV's Frank (whom I'll get to in a minute). When Joel Robinson (played by Joel Hodgson, the original host of MST3K, who left the show to work on other things -- most recently HBO's ~The TV Wheel~, easily one of the five weirdest damn things I've ever seen in my life) escaped from the Satellite, the mads needed a replacement and sent Mike up to take his place.", (NewLine)2;
   print (FormatText)"%BCrow T. Robot%P", (NewLine)1;
   print "Crow is a yellow-gold robot with a head made out of a lacrosse helmet and a beak make of a bowling pin cut in half. He has yellow ping-pong balls for eyes and fancies himself a screenwriter. In the theater, Crow sits on Mike's right, at the far right edge of the screen.", (NewLine)2;
   print (FormatText)"%BTom Servo%P", (NewLine)1;
   print "Tom is a short plump robot with a head made from a red gumball machine and a little plastic barrel chest. His arms are on Slinkies (which hop down stairs, alone or in pairs, and make a slinkety sound), and he has a hoverskirt instead of legs. Mike has to carry Tom in and out of the theater, because the air grate in the floor interferes with his hoverskirt. Tom sits on Mike's left.", (NewLine)2;
   print (FormatText)"%BGypsy%P", (NewLine)1;
   print "Gypsy is like a big snake, with a big purple head made out of a child's car seat, and a single flashlight for an eye. She has a fondness for Richard Basehart (best known from ~Voyage to the Bottom of the Sea~). Gypsy doesn't watch the movies with Mike, Crow, and Tom, but instead runs the higher functions of the Satellite of Love.", (NewLine)2;
   print (FormatText)"%BCambot%P", (NewLine)1;
   print "Cambot films everything on the SOL and in Deep 13 (the lair of the mad scientists). He's hardly ever seen, but helps Mike and the other 'bots with short skits that make fun of some of the movies.", (NewLine)2;
   print (FormatText)"%BDr. Clayton Forrester%P", (NewLine)1;
   print "Dr. Forrester is one of the mad scientists in Deep 13. He wears a bright green labcoat and green glasses, and has wild hair and a mustache. Forrester's favorite pastime is watching Mike hurt from the terrible films he's forced to watch. His nemesis is his mother.", (NewLine)2;
   print (FormatText)"%BTV's Frank%P", (NewLine)1;
   print "Frank is Forrester's not-too-bright assistant, picked up by the good doctor at a local Arby's after Dr. Laurence Erhardt (Forrester's original assistant) was reported missing at the start of the show's second season. Frank's trademark is a single curl of hair that hangs down in the center of his forehead. Dr. Forrester uses Frank as the subject of some of his experiments, and has killed him quite a few times.", (NewLine)2;
   rfalse;
  ],
 has
;

Option -> "The Matt Barringer Interview"
 with
  description
  [;
   print (FormatText)"%BNOTE:%P This is by C.E. Forman.", (NewLine)3;
   print "Yes, you read right. MST3K is proud to present this brief tete-a-tete with the man behind ~Detective~, Mr Matt Barringer!", (NewLine)2;
   print "After an exhausting net search, I finally managed to track Matt down. I explained a little about the MST3K game and asked him a couple of questions. Turns out Matt is a huge MST3K fan, is well aware of the quality of his game, and is actually a pretty decent guy, once you get past the fact that he wrote ~Detective.~ He did ask me, though, not to reveal his e-mail address here, and it's the least I can do after all I've put him through.", (NewLine)2;
   Quip (-1, 0, Question, "Okay, first things first. When did you first hear about the MST3K game? What was your initial reaction, and what are your thoughts on it now?");
   Quip (-1, 1, Answer, "Wow. I got home and read your letter, and I'd have to say that it surprised me a bit. I posted that strange, first game of mine on a local BBS and now it's on the Internet! I thought it would get tossed out from the BBS. It's a bit embarrassing that it's spread out amongst the Internet. Oh well. I wrote that 2 years ago, so I'll have to play it to answer your survey thing. I have yet to play MST3000 but I love the show. If you were wondering, I don't care that you make fun of it, feel free to make fun of it all you like.");
   Quip (-1, 1, Question, "Please tell us a little about yourself and the other members of ~Exile Games~, both now and at the time you wrote ~Detective~.");
   Quip (-1, 1, Answer, "I was 12 or so then (I turn 15 in a few months). I have changed a lot. I'm a lot cooler now. I still hang with Kurt [Somogue], he's changed a lot too. Nathaniel [Smith], well, we are way too different to even talk now. He moved away a few months after...");
   Quip (-1, 1, Question, "What activities currently occupy your time? Are you still interested in text adventures?");
   Quip (-1, 1, Answer, "I skateboard, play the guitar. Listen to music. I'm not involved in text games anymore, but I still play the ones others have written every now and then. (I gave up after that obviously pathetic one I wrote.)");
   Quip (-1, 1, Question, "Could you possibly explain some of the places and situations in ~Detective~ and any inside jokes associated with them? (In particular, the purpose of the dazed guy in the music store has kept me awake many a night.)");
   Quip (-1, 1, Answer, "Okay, I sped through it just now, to remember what you're talking about, but all I can say is that it was all imagination, except that guy at the music store's based after a real life guy who used to work at a really cool place in Berkeley.");
   Quip (-1, 1, Question, "Anything else you'd like to add?");
   Quip (-1, 1, Answer, "I suppose I should tell you that I really don't care. Being insulted about something in my past has little effect on me. And if you need any other stupid games, I'd be sorta happy to bring out the old AGT Master edition and do some REALLY stupid games (although topping that'd be a bit tough)...", 1);
   print "Uh, no, that's okay. Thanks again for the interview, Matt, and for making us laugh about love... again.", (NewLine)2;
   rtrue;
  ],
 has
;

Option -> "Legal necessities"
 with
  description 
  [;
   print "~Mystery Science Theatre 3000~, and all related characters and trademarks are Copyright 2000, Best Brains Inc.", (Newline)2;
   print "All trademarks knowingly or unknowingly used are the properties of their respective owners.", (NewLine)2;
   print "~Detective~ is Copyright 2000, Matt Barringer.", (NewLine)2;
   print "This MiSTing is Copyright 2000, C.E.Forman, Gareth Rees, Graeme Cree and Stuart Moore.", (NewLine)2;
   print "The Inform library is Copyright 2000, Graham Nelson.", (NewLine)2;
   print "Portions of code are Copyright 2000, L. Ross Raszewski.", (NewLine)2;
   print "Portions of code are Copyright 2000, Allen Garvin.", (NewLine)2;
   rtrue;
  ],
 has
;

Option -> "Thank yous and greetings"
 with
  description
  [;
   print "In no particular order:", (NewLine)2;
   print (FormatText)"%RC.E. FORMAN%P and %RGARETH REES%P for some portions of code and the original version.", (NewLine)2;
   print (FormatText)"%RGRAEME CREE%P for the AGT code from which this version was created. Thanks a lot, Graeme!", (NewLine)2;
   print (FormatText)"%RGRAHAM NELSON%P for coming up with Inform.", (NewLine)2;
   print (FormatText)"%RL. ROSS RASZEWSKI%P for AltMenu.h/DoMenu.h/Utility.h", (NewLine)2;
   print (FormatText)"%RALLEN GARVIN%P for a useful formatted-text routine.", (NewLine)2;
   print (FormatText)"%RKENT TESSMAN%P for Hugo.", (NewLine)2;
   print (FormatText)"%RROBERT MASENTEN%P for MakeAGX.", (NewLine)2;
   print (FormatText)"And %RMATT BARRINGER%P for the original game and for having a sense of humour.", (NewLine)2;
   print (FormatText)
		"%RALAN GOTTS%P,
		%RDAVID HORTON%P,
		%RPAUL and STEVE MAYHEW%P and
		%RSIMON PALLETT%P
		all get hellos!", (NewLine)2;
   print (FormatText)
		"%RSTUART ADAIR%P,
		%RGILES BOUTEL%P,
		%RNEIL JAMES BROWN%P,
		%RTOM BUCK%P,
		%RADAM CADRE%P,
		%RRYBREAD CELSIUS%P,
		%RANDREW CLOVER%P,
		%RPAUL CORNELL%P,
		%RDJ DELORIE%P,
		%RDAVID DYTE%P,
		%RGARY GILLATT%P,
		%RSHAWN HARGREAVES%P,
		%RROBERT HOEHNE%P,
		%RCOREY KLEMOW%P,
		%RJENNIFER KOKOSKI%P,
		%RSHAUN LYON%P,
		%RIAN McDONALD%P,
		%RDAVID A. McINTEE%P,
		%RJOHN MENICHELLI%P,
		%RMAGNUS OLSSON%P,
		%RKATE ORMAN%P,
		%RJASON PENNEY%P,
		%RANDREW PLOTKIN%P,
		%RRICHARD and PEGGY POSER%P,
		%RMICHAEL J. ROBERTS%P,
		%RGARY RUSSELL%P,
		%RALFRED SNIDER%P,
		%RSHANNON PATRICK SULLIVAN%P,
		%RANDREW VESPERMAN%P,
		%RPATRICK WIGFULL%P and
		%RGERRY KEVIN WILSON%P
		all get hellos too!", (NewLine)2;
   print (FormatText)
		"Especially big hellos to
		%RM. SCOTT ADAMS%P,
		%RBRIAN HOWARTH%P,
		%RLAIRD MALAMED%P,
		%RBILL VOLK%P,
		%RSTEVE MERETZKY%P,
		%RBRIAN MORIARTY%P,
		%RDAVE LEBLING%P,
		%RMARC BLANK%P,
		%RRICHARD GARRIOT%P,
		%RVOLKER BLASIUS%P and
		%RDAVID KINDER%P.", (NewLine)2;
   rtrue;
  ],
 has
;
!!! INTRODUCTORY MENU SYSTEM END.