
! We have three basic phases here. First, you leave the interrog room, but
! you can't go west of NortheastCorner / TossJunction. Then you blow the
! lights, and the guards chase you to where the gun is. Then you have
! the gun, shoot the guards; but two more groups of guards begin circling
! to cut you off. They converge at the lab junction.

Object sc_7
  class Scene,
  with
	number 7,
	init_scene [;
		SetQuestion(q7_1);
	],
	begin_scene [;
		BeginGreatEscape();
	],
	end_scene [;
		"The key to escape is the key to escape. [BUG]";
	];

Object q7_1
  class Question,
  with
	query [;
		new_line;
		print "The man breathes out slowly; his eyes are soft with realization.
			~The ventilation duct. The ", (emphstring) "ventilation",
			" duct.~^^";
		print "Still staring past you, he thumbs a switch on his desk. 
			~Mobile Eight?~ he says to the air. ~Get down to the hallway
			where our friend was captured--~ There is a muffled interruption.
			~Yes, I know you have. You missed a leaf. Open up ventilation
			grille ";
		ventilator.number(FinalEnd);
		print " and search inside.
			There should be a number of microelectronic tools inside, 
			and a small bundle wrapped in cloth. Report to me immediately.~
			He flicks the connection closed.^^";
		print "The man spreads his hands apologetically. 
			~I must look like a great fool,~ he says to you.^";
	],
	time_limit 1,
	answer_yes [;
		print "He chuckles. ~Well,";
		SetQuestion(q7_2);
	],
	answer_no [;
		print "He smiles. ~Kind of you. Well,";
		SetQuestion(q7_2);
	],
	answer_wait [;
		print "He continues, ~It's my own fault.";
		SetQuestion(q7_2);
	];

Object q7_2
  class Question,
  with
	query [;
		print " I can plead an excuse; we rebuilt our ventilation system from
			the ground up, less than half a year ago. It's fenced and webbed
			and wired so that a grain of sand couldn't sneak through -- but
			only at the external intakes and the junctions. We never thought
			to check for an object cached just inside a vent. We never thought
			it would be a ", (emphstring) "danger", ".~^";
		print "^He shrugs. ~And it wasn't a danger, in fact, was it?~^";
	],
	time_limit 1,
	answer_yes [;
		print "~Yes? I can't see how.";
		SetQuestion(q7_3);
	],
	answer_no [;
		print "~No.";
		SetQuestion(q7_3);
	],
	answer_wait [;
		print "~Consider it.";
		SetQuestion(q7_3);
	];

Object q7_3
  class Question,
  with
	query [;
		print " We got you; you didn't get into the lab, much less
			get out afterwards. You moved a package from one hiding place
			to another. I still can't see--~^^A flashing light interrupts
			him. The man touches it, and nods. ~I'll see soon. They're
			bringing it in.~^";
	],
	time_limit 1,
	answer_yes [;
		print "The man absently waves you to silence.^";
		SetQuestion(q7_4);
	],
	answer_no [;
		print "The man absently waves you to silence.^";
		SetQuestion(q7_4);
	],
	answer_wait [;
		print "The man waits.^";
		SetQuestion(q7_4);
	];

Object q7_4
  class Question,
  with
	query [;
		print "^A chime sounds. The man pounces on his controls, and then
			gestures impatiently towards the doorway.^^";
		print "A guard enters. She gives you only a brief professional glance.
			Approaching the desk, she lays out a handful of small items.^^";
		move toolitems to interrogdesk;
		print "The man nods, dismissing her without a thought, and then stares.
			~This was all? Where's the package?~^^~With'?~ asks the guard,
			puzzled.^^~Never mind. Go.~ His eyes are blazing on you as the
			guard slips out the doorway. ~You. You have lied to me, and
			I am ", (emphstring) "tired", " of it. I have had ", 
			(emphstring) "enough", ".~^";
	],
	time_limit 6,
	daemon [;
		switch (self.number) {
			2: "^~You have not told me where the package really is.~";
			4: "^By the man's expression, your last chance is wearing thin.";
			5: "^~Now!~";
		}
	],
	answer_general ", and curse all your blood,~ says the man flatly. His
		finger stabs down.",
	answer_yes [;
		print "~Curse that, curse you";
		self.answer_general();
		BrainDrain();
		rtrue;
	],
	answer_no [;
		print "~Curse that, curse you";
		self.answer_general();
		BrainDrain();
		rtrue;
	],
	answer_wait [;
		print "~That's it. Curse you";
		self.answer_general();
		SetQuestion(q7_fake);
		BrainDrain();
	];

Object q7_fake
  class Question,
  with
	query [; rtrue; ];

Object toolitems "items"
  with
	article "several",
	name 'several' 'handful' 'small' 'tool' 'tools' 'item' 'items'
		'toolcase' 'lamp' 'minilamp' 'scrambler' 'button' 'pushbutton'
		'timer' 'toggle' 'switch' 'disc' 'key' 'voice' 'trans' 'transmitter',
	description [;
		print_ret "You can see the flat grey shape of your toolcase. 
			And the ",
			(ColorTarget) minilight, " minilamp, and the ",
			(ColorTarget) scrambler, " scrambler. The ",
			(ColorTarget) nothing, " boxes which are the pushbutton, 
			timer, and toggle-switch triggers. And the ", 
			(ColorTarget) blasttab, " disc-shaped key
			transmitter, and the square ", 
			(ColorTarget) acidpack, " voice transmitter. That's
			all. There is, of course, no cloth-wrapped package.";
	],
	react_before [ ix;
		Tango:
			<<ActivateTool self>>;
		Waltz:
			<<DeactivateTool self>>;
		VagueSay, Answer:
			if (consult_words >= 1) {
				wn = consult_from;
				ix = NextWord();
				if (ix == '~//' && consult_words >= 2) {
					ix = NextWord();
				}
				if (ix == 'tango') {
					<<ActivateTool self>>;
				}
				if (ix == 'waltz') {
					<<DeactivateTool self>>;
				}
			}
	],
	before [;
		ActivateTool: 
			print "You say the keyword. The man jerks like a lightning-struck
				tree at the sound of your voice, but it is too late.^^";
			print "There is a piercing ", (emphstring) "hiss", 
				" from the pedestal beneath your chair. 
				Acrid mist sprays out around your feet.
				The man is leaping up, but you
				can already feel a shifting beneath you. The metal slats
				sag... and crumple...^^You tear your limbs from the
				dissolving steel bands.^";
			BeginScene(1000);
			rtrue;
		DeactivateTool:
			print "You say the keyword, but nothing happens. ", (The) voicetrans,
				" must already be off.^";
			print "^The man jerks like a lightning-struck tree at the sound of
				your voice. He stares at you, and down
				at his desk. Then, with a vicious curse, he begins slamming
				controls.^";
			BrainDrain();
			rtrue;
	],
	orders [;
		Tango:
			<<ActivateTool self>>;
		Waltz:
			<<DeactivateTool self>>;
		default:
			"There is no reply.";
	],
  has scenery pluralname talkable;

[ BeginGreatEscape;
	if (escaping)
		"What? You can't escape twice! [BUG]";
	
	escaping = 1;
	move activeplayer to InterrogRoomReal;

	move boltwrench to largecrate; ! back where it started
	give cornerdoor ~open; ! wrench storageroom
	give panelhole general; ! existence of blood 
	move blood to CeilingHole;
	remove package;
	remove equiptalker;
	remove tossguards;
	give tossguards absent;
	tossguards.work_target = 0;
	remove baitguards;
	remove dooropenguards;
	remove bigguards;
	OfficeSketchStartup(); ! all in SecurityOffice, with static
	give finaldrawer ~open;
	while (child(finaldrawer)) {
		remove child(finaldrawer);
	}
	give finaldoor ~open;
	give hypervent ~open;
	while (child(hypervent)) {
		remove child(hypervent);
	}
	remove loneguard;
	remove loneguardgun;

	give cornermetaldoor ~open;
	give tossmetaldoor ~open;
	give deadendmetaldoor ~open;
	give secbranchdoor ~open;
	give finaldoor ~open;
	
	! ok, we can begin assembly now.
	
	remove interrealchair;
	remove interrealleads;
	remove interrealbands;
	move brokenchair to InterrogRoomReal;
	move brokenvoicemod to InterrogRoomReal;
	StartDaemon(brokenchair);
	move HimselfEscape to InterrogRoomReal;
	move himselfescapeuniform to InterrogRoomReal;
	
	move penstain to poisonpen;
	remove pennib;
	if (poisonpen_model in Himself)
		move poisonpen to interrealdesk;
	else
		move poisonpen to HimselfEscape;
	
	EscapeToolPositions(interrealdesk);
	
	StartDaemon(HimselfEscape);
	PronounNotice(HimselfEscape);
];

Object brokenchair "scraps of metal"
  with
	name 'scrap' 'scraps' 'rag' 'rags' 'metal' 'chair',
	initial "Scraps of metal lie around the pedestal, still visibly
		decaying.",
	description "Rags of metal are scattered around the pedestal -- 
		nothing else is left of the chair that held you. They are 
		dissolving to hissing mist as you watch.",
	before [;
		Take, Search, Push, Pull, Touch:
			"There's no point; soon there won't be anything left of them.";
		Smell:
			"The scraps smell of acid.";
		Enter:
			"There's barely enough chair left to step on, much
				less sit on.";
	],
	number 0, ! for daemon
	number2 0, ! true if scrambler-alarm occured
	daemon_priority -10, ! after the timer, and pretty much everything else.
	daemon [;
		if (powercut == 0) { ! after cut, no scanning
			if (scrambler has general && self.number2 == 0) {
				self.number2 = 1;
				if (anywherein(scrambler, location))
					print "^The scan scrambler emits a sudden frantic shrilling, 
						which is echoed by a buzzer through the halls of the
						building. Apparently it's a trick that can't work
						twice.^";
				else
					print "^A buzzer sounds, suddenly and for no apparent
						reason.^";
				SummonEsguardsSecurity();
			}
		}
		
		self.number++;
		switch (self.number) {
			5, 7:
				if (location == parent(self))
					print "^The remains of the chair continue to shrivel.^";
			8:
				if (location == parent(self))
					print "^There is now nothing left of the chair at all.^";
				remove self;
			25:
				if (powercut)
					return;
				if (SummonEsguardsSecurity()) {
					if (location == InterrogRoomReal)
						print "^There is a quiet chime from the direction
							of the desk. The unconscious man does not stir.
							The chime is repeated; a moment later, it changes
							to a sharp buzzer.^";
					else
						print "^A buzzer sounds suddenly through the corridors.
							Your time is running tight.^";
				}
			6:
				print "^Your legs are beginning to itch fiercely.^";
			10:
				print "^The itch in your legs is nearly unbearable.^";
			14, 20:
				print "^The itching is slowly fading.^";
			40:
				print "^Your legs still itch. Just a bit.^";
		}
	],
  has static pluralname;

Object brokenvoicemod "voice module"
  with
	name 'voice' 'module' 'short' 'antenna' 'black' 'box',
	description "The voice module seems to have welded itself into the
		corroding metal.",
	before [;
		Take:
			"You cannot pry the voice module loose.";
		Push, Pull, Turn, Attack:
			"It doesn't move.";
		TouchTo, TouchFrom:
			"The voice module's link isn't visible.";
	],
  has scenery connector;

Constant HimselfEscapeNoTalk 
	"The man is no longer interested in anything you have to say.";

Object HimselfEscape "man"
  with
	name 'man' 'interrogator',
	initial [;
		if (self hasnt general) {
			switch (self.number) {
				0, 1: 
					"The man is on his feet, staring at you -- stunned,
						and with perhaps, somewhere underneath, a flicker
						of doubt.";
				100, 101:
					"The man is sitting calmly behind his desk. He seems
						to have found a gun. It is levelled
						at your chest.";
				default:
					"The man is leaping towards you.";
			}
		}
		else {
			"The man is stretched on the floor, dazed and unmoving. 
				The lines of his face are merely age, now.";
		}
	],
	description [;
		if (self hasnt general) {
			self.initial();
		}
		else {
			"He is still unconscious.";
		}
	],
	before [;
		Search:
			if (self hasnt general)
				"I don't think so.";
			if (child(self) == nothing) {
				print "You run your hands over his uniform, but you find
					nothing.";
			}
			else {
				print "You run your hands over his uniform; ";
				WriteListFrom(child(self), TERSE_BIT + ENGLISH_BIT + PARTINV_BIT);
				if (children(self) > 1)
					print " spill";
				else
					print " spills";
				print " onto the floor.";
				while (child(self)) {
					move (child(self)) to parent(self);
				}
			}
			if (self.number2 == 0) {
				self.number2 = 1;
				print " It would be too much to ask, of course, that he
					be carrying a gun. But -- of course -- he was too careful
					to make such a mistake. You hadn't doubted that.";
			}
			new_line;
			rtrue;
		Push, Pull:
			if (self hasnt general)
				<<Attack self>>;
			"The man shifts limply.";
		Take:
			if (self hasnt general)
				"Not likely.";
			"A limp body would be impossibly awkward, especially if you
				were in a hurry. Which you might be.";
	],
	number2 0, ! true if searched already
	life [;
		Attack:
			if (self has general)
				"Satisfying though it might be, there's no more need.";
			give self general;
			StopDaemon(self);
			"A sudden rush echoes in your ears, and you feel a grimace
				straining your lips. The man falls back -- just a fraction --
				and then your fist slams into his belly. You shiver as
				he folds up, and coldly aim another blow at the
				the back of his skull. The man's body hits the floor; he
				lies still.";
		Ask, Tell, AskFor, Answer:
			if (self hasnt general)
				print_ret (string) HimselfEscapeNoTalk;
			else
				"He can't hear you.";
		Show, Give:
			if (self hasnt general)
				print_ret (string) HimselfEscapeNoTalk;
			else
				"He can't see you.";
	],
	orders [;
		if (self hasnt general)
			print_ret (string) HimselfEscapeNoTalk;
		else
			"He can't hear you.";
	],
	number 0, ! for daemon
	daemon_priority 3,
	daemon [;
		if (self has general) {
			StopDaemon(self);
			"The man falls over and snores. [BUG]";
		}
		if (location ~= parent(self)) {
			self.number = 100;
			return;
		}
		self.number++;
		switch (self.number) {
			2: 
				print "^The man breaks from his stunned pose with a
					shudder. He vaults over his desk, and drops
					towards you with vicious speed.^";
			3:
				print "^You twist aside as the man's hand flashes for your
					temple.^";
			4:
				print "^In grim silence, the man lashes out with one
					foot. You stumble; something is horribly wrong with
					your knee, and you crash to the ground, feeling
					pain somewhere very far away. He is on you immediately,
					twisting your arm back; and then, with great
					precision, he cracks your head against the hard,
					cold tiles.^";
				deadflag = 3;
			101:
				print "^He smiles. ~You came back,~ he says, and shoots you.^";
				deadflag = 3;
		}
	],
  has static animate ~general; ! general means unconscious

Object himselfescapeuniform "pale uniform"
  with
	name 'man^s' 'pale' 'uniform',
	description [;
		if (HimselfEscape hasnt general)
			print "The uniform is immaculate.";
		else
			print "The uniform is strained where its wearer lies awkwardly.";
		" It is pale, and bears no insignia but the emblem of its nation.";
	],
	before [;
		Search:
			<<Search HimselfEscape>>;
		Take:
			if (HimselfEscape hasnt general)
				"I don't think so.";
			"It's a fine thought, but stripping a limp body is impossibly
				awkward. And the guards aren't very likely to mistake you
				for their chief, no matter what you're wearing.";
	],
  has scenery;

! Returns true if they actually started. This is silent, at least when not fast.
[ SummonEsguardsSecurity fast;
	if (esguardssec.number)
		return false; ! don't summon twice
	esguardssec.startup(fast);
	return true;
];

Object esguardssec "guards"
  with
	name 'guard' 'guards',
	number 0,
	startup [ fast;
		self.number = 1;
		if (fast)
			self.number = 2;
		StartDaemon(self);
		! due to annoying circumstances, not worth the time to fix, these
		! guys are delayed one turn if summoned by the scrambler.
	],
	shutdown [;
		StopDaemon(self);
		remove self;
		self.number = 99;
	],
	daemon_priority 4, ! fast buggers
	daemon [ oldloc loc;
		self.number++;
		if (self.number <= 2)
			return;
		oldloc = parent(self);
		if (location == oldloc) {
			deadflag = 3;
			"^You stumble to a halt, as you plow into a group of hard-eyed guards.
				They apparently grudge the many times you slid past them; 
				now they waste no time taking you down.";
		}
		switch (self.number) {
			! 0, 1, 2: Do nothing -- already returned
			3:
				move self to SecurityBranch;
			4:
				if (location == LabJunction or NortheastCorner)
					move self to NortheastCorner;
				else if (location == TossJunction or SouthFrontier
					or DeadEndHall or WiringCloset)
					move self to TossJunction;
				else
					move self to SecurityAnnex;
			5:
				if (location == WiringCloset)
					move self to DeadEndHall;
				else
					move self to location;
			default:
				move self to location;
		}
		loc = parent(self);
		switch (loc) {
			InterrogRoomReal, SecurityOffice, SecurityStorage:
				if (location == loc) {
					deadflag = 3;
					"^A group of hard-eyed guards bursts in from the hallway.
						Their guns are out; pulsefire is slashing into
						you almost before you see them.";
				}
			WiringCloset:
				if (location == loc) {
					deadflag = 3;
					new_line;
					if (deadendmetaldoor has open)
						print "A group of hard-eyed guards bursts in
							through the door";
					else
						print "The door snaps open, and a 
							group of hard-eyed guards bursts in";
					". Their guns are out; pulsefire is slashing into
						you almost before you see them.";
				}
			SecurityBranch:
				if (location == SecurityBranch or NortheastCorner 
					or TossJunction or SecurityAnnex) {
					deadflag = 3;
					if (oldloc == nothing) {
						print "^The door";
						switch (location) {
							NortheastCorner: print " in the middle of the
								corridor, to the south,";
							TossJunction: print " in the middle of the
								corridor, to the north,";
							SecurityAnnex: print " down the corridor, to
								the southwest,";
						}
						" snaps open. A group of hard-eyed guards
							bursts out, scanning the corridor, guns levelled.
							Of course they see you immediately.";
					}
					else {
						"^A group of hard-eyed guards down the corridor spots
							you. Pulsefire slashes through you before
							you can react.";
					}
				}
			TossJunction:
				if (location == SecurityBranch or NortheastCorner 
					or TossJunction or DeadEndHall or SouthFrontier) {
					deadflag = 3;
					print "^A group of hard-eyed guards bursts into view at the
						intersection";
					switch (location) {
						DeadEndHall: print ", to the west";
						SouthFrontier: print ", to the east";
					}
					". They spot you instantly, and open fire.";
				}
			NortheastCorner:
				if (location == SecurityBranch or NortheastCorner 
					or TossJunction or LabJunction) {
					deadflag = 3;
					print "^A group of hard-eyed guards bursts into view at the
						intersection";
					switch (location) {
						LabJunction: print ", to the east";
					}
					". They spot you instantly, and open fire.";
				}
			default:
				if (location == loc) {
					deadflag = 3;
					"^A group of hard-eyed guards spots you from across
						the corridor.
						Their guns are out; pulsefire is slashing into
						you almost before you see them.";
				}
		}
	],
  has animate pluralname scenery;

Object NortheastCorner "Northeast Corner"
  with
	description [;
		print "The corridor turns here, running south and west. A single
			metal door stands north; it is";
		if (necornerdoor hasnt open)
			" closed.";
		else
			" open.";
	],
	s_to SecurityBranch,
	n_to necornerdoor,
	w_to [;
		if (escaping) {
			if (powercut == 0) {
				"You move down the west corridor; but as you approach the
					junction, you hear voices. The corridor to the south
					sounds like it's still got a full squad of guards. 
					And they'll be alert, now. You
					don't dare even look; you slide back to the corner,
					as quietly as you can.";
			}
		}
		return LabJunction;
	];

Object -> necornerdoor "metal door"
  class InteriorDoor,
  with
	name 'n//' 'north' 'northern',
	description [;
		print "The door to the north is metal. As usual, it has a black 
			sensor plate beside it.";
		if (self has open)
			" The door is open.";
		else
			" The door is closed.";
	],
	door_dir n_to,
	before [;
		ActivateTool:
			if (escaping) {
				if (location == NortheastCorner) {
					print "^The door snaps open. You have a brief glimpse of
						a nervous-looking janitor, surrounded by dusty crates,
						before he hits an override and the door
						snaps shut again.^^He must have hit an alarm,
						as well, because a sharp buzzer sounds.^";
				}
				else if (location == SecurityBranch or TossJunction or
					LabJunction) {
					print "^The door";
					switch (location) {
						SecurityBranch: print " to the north";
						TossJunction: print " at the far end of the corridor,
							to the north,";
						LabJunction: print " to the east";
					}
					print " snaps open -- and closed again. Someone must have
						hit an override.^^Someone must have hit an alarm,
						as well, because a sharp buzzer sounds.^";
				}
				else {
					print "^A sharp buzzer sounds somewhere.^";
				}
				SummonEsguardsSecurity();
				rtrue;
			}
	];

Object -> necornerdoorplate
  class InteriorPlate,
  with
	work_target necornerdoor;

Object SharpCorner "Sharp Corner"
  with
	description [;
		print "The corridor cuts around a sharp angle, from the northwest
			to the north. To the south, in the end wall, is the standard
			featureless metal door; it is";
		if (sharpcornerdoor hasnt open)
			" closed.";
		else
			" open.";
	],
	nw_to NorthBoundary,
	n_to LabJunction;

Object -> sharpcornerdoor "metal door"
  class InteriorDoor,
  with
	name 's//' 'south' 'southern',
	description [;
		print "The door to the north is metal. As usual, it has a black 
			sensor plate beside it.";
		if (self has open)
			" The door is open.";
		else
			" The door is closed.";
	],
	door_dir s_to;

Object -> sharpcornerdoorplate
  class InteriorPlate,
  with
	work_target sharpcornerdoor;

Object WiringCloset "Wiring Closet"
  with
	description [;
		print "You have barely room to spread your arms; this tiny square
			chamber is lined with cables, pipes, wires, and junction
			nodes. The only exit is the";
		if (deadendmetaldoor has open) {
			if (deadendmetaldoor.number2)
				print " closing";
			else
				print " open";
		}
		else
			print " closed";
		print " door to the south, which has a small white pad beside it.";
		new_line;
		if (powernode in self && child(powernode)) {
			print "^Resting on one of the larger junction nodes";
			WriteListFrom(child(powernode),
				ISARE_BIT + TERSE_BIT + ENGLISH_BIT + PARTINV_BIT);
			print ".^";
		}
		if (powernodebroke in self)
			print "^The largest junction node is a shattered ruin.^";
		rtrue;
	],
	out_to wiringdoorin,
	s_to wiringdoorin;

Object -> powercables "cables and wires"
  with
	name 'heavy' 'power' 'cable' 'cables' 'wire' 'wires' 'pipe' 'pipes',
	description "Cables and wires of all descriptions fill the room; they
		thread up the walls, across the ceiling, and through various
		junction nodes.",
	before [;
		Take, Push, Pull, Turn:
			"The cables and wires are securely anchored.";
		Attack:
			"You can't do any significant damage without a great deal
				more time.";
		Climb:
			"You could easily climb some of the cables, but it would gain you
				little. There is nothing above of any use.";
	],
  has scenery pluralname;

Object -> powernode "large junction node"
  with
	name 'large' 'junction' 'node' 'nodes',
	description [;
		print "One junction node is particularly large; several heavy
			power cables feed through it.";
		if (child(self)) {
			print " ";
			<Search self>;
		}
		else {
			new_line;
		}
		rtrue;
	],
	before [;
		Search:
			if (child(self) == nothing) 
				"You find nothing of interest.";
			print "Resting on the large node";
			WriteListFrom(child(self),
				ISARE_BIT + TERSE_BIT + ENGLISH_BIT + PARTINV_BIT);
			".";
		Receive:
			if (receive_action == ##PutOn)
				<<Insert noun self>>;
		Attack, Push, Pull, Turn:
			"You cannot make any impression.";
		Open, Close:
			"The junction nodes are all sealed.";
	],
	after [ ix;
		Receive:
			ix = child(self);
			if (ix == noun)
				ix = sibling(ix);
			print "You place ", (the) noun, " on";
			if (ix == nothing)
				" one of the larger junction nodes.";
			if (sibling(ix))
				" the node, next to the things already there.";
			print_ret " the node, next to ", (the) ix, ".";
	],
  has scenery open container; 

Object -> wiringdoorin "metal door"
  with
	name 'door' 'metal',
	description [;
		print "It's a door like all the rest. There is a white contact
			pad on one side of the jamb. The door is";
		if (deadendmetaldoor has open)
			" open.";
		else
			" closed.";
	],
	door_dir s_to,
	door_to DeadEndHall,
	door_try [;
		if (deadendmetaldoor hasnt open) {
			PronounNotice(self);
			"The door is shut tight.";
		}
	],
	before [;
		Open:
			if (deadendmetaldoor hasnt open)
				"It doesn't open by itself.";
		Close:
			if (deadendmetaldoor hasnt open)
				"It's already closed.";
			else
				"You're not sure how.";
		Push, Turn: 
			"The steel is immobile.";
		Touch, Rub: 
			"The steel is smooth and cool.";
	],
  has scenery door open;

Object -> wiringclosetpad
  class ContactPad,
  with
	before [;
		Touch:
			if (powercut) {
				print "Nothing happens.";
				if (deadendmetaldoor hasnt open) {
					deadflag = 3;
					print " You stare at the door in some embarrassment;
						of course it won't open without power.^^You sit
						down calmly to wait. It isn't too long before
						the guards come with crowbars to investigate the
						problem.";
				}
				new_line;
				rtrue;
			}
			if (deadendmetaldoor has open) {
				give deadendmetaldoor ~open;
				"The door snaps shut.";
			}
			else {
				give deadendmetaldoor open;
				"The door snaps open again.";
			}
	],
	is_active [ noisy;
		if (noisy == 0) {
			if (powercut)
				rfalse;
			else
				rtrue;
		}
		else {
			<<Touch self>>;
		}
	];

Object powernodebroke "smashed junction node"
  with
	name 'smashed' 'ruin' 'large' 'junction' 'node' 'nodes',
	description "The largest junction node has been reduced to shattered ruin.",
	before [;
		Search:
			"The inside is a tangle of torn cabling.";
		Touch, Attack, Push, Pull:
			"That might not be a good idea.";
		Receive:
			"There's no good surface left on the smashed junction node.";
	],
  has scenery;


