#include "map.h"
#include "magic.h"
#include "runtime.h"

/* INITIALISE MAGIC VARIABLES */
int wc_state = WC_INITIAL0;
int pc_state = 0;
int hc_state = 0;
int drunkLevel = 0;

/* MAGICKAL OBJECT CODES */
#define WISDOM_NPC 0
#define SMALLDAGGER 1
#define BARMAID_NPC 2
#define PROSTITUTE_NPC 3
#define GUARD_NPC 4
#define HAVARSWEEN_NPC 5
#define POLICE_NPC 6

/* MAGICKAL ROOM CODES */
#define QUEST_ROOM 0
#define MAGIC_ROOM -2
#define PURRINGCAT 9
#define BROTHEL 7
#define MAPLE_LANE 3
#define HAVAR_APARTMENT 10

/* CHECK IF DROPPING GIVEN OBJECT IN THIS ROOM HAS
 * MAGICKAL EFFECTS. IF SO, CARRY OUT MAGIC.
 */
void
magicDROP (int obj) {
}

/* TALK TO AN NPC. */
void
magicTALK () {
  if (objInRoom(WISDOM_NPC,curRoom)) {
    if (wc_state == WC_INITIAL0) {
      playMSG(2);
      wc_state = WC_INITIAL1;
    }
    else if (wc_state == WC_INITIAL1) {
      playMSG(3);
      wc_state = WC_INITIAL2;
    }
    else if (wc_state == WC_INITIAL2) {
      playMSG(4);
      wc_state = WC_INITIAL3;
    }
    else if (wc_state == WC_INITIAL3) {
      playMSG(5);
      wc_state = WC_TASK1_INC;
      if (freeinv == 0)
	fatal("GAME INTERNAL ERROR - inventory unexpectedly full\n");
      addInv(SMALLDAGGER);
    }
    else if (wc_state == WC_TASK1_INC) {
      playMSG(6);
    }
    else if (wc_state == WC_TASK1_DONE) {
      playMSG(45);
      exit(0);
    }
    else {
      fatal("GAME INTERNAL ERROR - unknown wc_state value\n");
    }
  }
  else if (objInRoom(BARMAID_NPC,curRoom)) {
    playMSG(10);
  }
  else if (objInRoom(PROSTITUTE_NPC,curRoom)) {
    if (pc_state == 0) {
      playMSG(23);
      pc_state++;
    }
    else if (pc_state == 1) {
      playMSG(24);
      pc_state++;
    }
    else {
      playMSG(25);
    }
  }
  else if (objInRoom(HAVARSWEEN_NPC,curRoom)) {
    if (hc_state == 0) {
      playMSG(32);
      hc_state++;
    }
    else if (hc_state == 1) {
      playMSG(33);
      hc_state++;
    }
    else if (hc_state == 2) {
      playMSG(34);
      hc_state++;
    }
    else if (hc_state == 3) {
      playMSG(35);
      hc_state++;
    }
    else if (hc_state == 4) {
      playMSG(36);
      hc_state++;
    }
    else if (hc_state == 5) {
      playMSG(37);
      doEXIT();
    }
  }
  else {
    printf("I can't see anyone here to talk to.\n");
  }
}

/* ATTEMPT TO EXIT ROOM */
int
magicEXIT (int dir) {
  int i;

  if (curRoom == QUEST_ROOM && dir == SOUTH) {
    /* Attempt to leave into the city without talking to
     * Wisdom.
     */      
    if (wc_state <= WC_INITIAL3) {
      playMSG(7);
      return FALSE;
    }
  }
  else if (curRoom == QUEST_ROOM && dir == NORTH) {
    /* Attempt of unworthy one to enter into house. */
    playMSG(8);
    return FALSE;
  }
  else if (curRoom == BROTHEL && dir == WEST) {
    /* Attempt to go into inner part of brothel */
    if (hc_state < HC_DEAD)
      playMSG(27);
    else
      printf(getMSG(9),dirToText(dir));
    return FALSE;
  }
  else if (curRoom == MAPLE_LANE && dir == NORTH) {
    /* Attempt to enter Havar Sween's apartment */
    /* Do we know who actually lives here? */
    if (pc_state < 2) {
      playMSG(28);
      return FALSE;
    }
    else {
      playMSG(29);
      return TRUE;
    }
  }
  else if (curRoom == HAVAR_APARTMENT && dir == UP) {
    /* Can't go in to rest of Havar's apartment */
    if (hc_state < HC_THREATENS)
      playMSG(31);
    else if (hc_state == HC_THREATENS) {
      playMSG(38);
      doEXIT();
    }
    else if (hc_state == HC_DEAD)
      playMSG(41);
    return FALSE;
  }
  else if (curRoom == HAVAR_APARTMENT && dir == SOUTH) {
    if (hc_state == HC_THREATENS) {
      playMSG(38);
      doEXIT();
    }
    else if (hc_state == HC_DEAD) {
      hc_state = HC_POLICE;
      playMSG(43);
      /* Police collect evidence */
      for (i = 0; i < OBJSLOTS; i++)
	rooms[curRoom].objs[i] = -1;
      rooms[curRoom].freeinv = OBJSLOTS;
      /* Police arrive */
      addObj(POLICE_NPC,curRoom);
      /* Brothel shuts down */
      removeObj(PROSTITUTE_NPC,BROTHEL);
      removeObj(GUARD_NPC,BROTHEL);
      /* Quest completed */
      wc_state = WC_TASK1_DONE;
    }
    return TRUE;
  }
  else if (rooms[curRoom].dirs[dir] == MAGIC_ROOM) {
    printf(getMSG(9),dirToText(dir));
    return FALSE;
  }
  else {
    return TRUE; 
  }
}

/* ENTRY OF ROOM */
void
magicENTER () {
  if (curRoom == HAVAR_APARTMENT) {
    if (hc_state < HC_POLICE)
      playMSG(30);
    else {
      playMSG(42);
      doEXIT();
    }
  }
}

/* BUY SOMETHING IN A SHOP */

void
magicBUY (char *args) {
  if (curRoom == PURRINGCAT) {
    if (drunkLevel == 0)
      playMSG(11);
    else
      playMSG(18);
    drunkLevel++;

    switch (drunkLevel)
      {
      case 1:
	playMSG(12);
	break;
      case 2:
	playMSG(13);
	break;
      case 3:
	playMSG(14);
	break;
      case 4:
	playMSG(15);
	break;
      case 5:
	playMSG(16);
	break;
      case 6:
	playMSG(17);
	doEXIT();
	break;
      }
  }
  else if (curRoom == BROTHEL) {
    /* Buy sex in brothel */
    playMSG(26);
    doEXIT();
  }
  else {
    printf ("There is no one here to sell you anything.\n");
  }
}

void
magicKILL (int obj) {
  if (!hasObj(SMALLDAGGER)) {
    printf("You have no weapon.\n");
    return;
  }

  if (obj == WISDOM_NPC) {
    playMSG(19);
    doEXIT();
  }
  else if (obj == BARMAID_NPC) {
    playMSG(20);
    doEXIT();
  }
  else if (obj == PROSTITUTE_NPC) {
    playMSG(21);
    doEXIT();
  }
  else if (obj == GUARD_NPC) {
    playMSG(22);
    doEXIT();
  }
  else if (obj == HAVARSWEEN_NPC) {
    if (hc_state < HC_THREATENS) {
      playMSG(40);
      doEXIT();
    }
    else {
      playMSG(39);
      hc_state = HC_DEAD;
      removeObj(HAVARSWEEN_NPC,curRoom);
    }
  }
  else {
    fatal("GAME INTERNAL ERROR - don't know how to KILL");
  }
}

void
magicLOOK () {
  if (curRoom == BROTHEL && hc_state == HC_POLICE) {
    /* Brothel is deserted. */
    playMSG(44);
  }
}
